/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.AdalAuthorizationGrant;
import com.microsoft.aad.adal4j.StringHelper;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class AdalOAuthAuthorizationGrant
implements AdalAuthorizationGrant {
    private final AuthorizationGrant grant;
    private final Map<String, List<String>> params;

    AdalOAuthAuthorizationGrant(AuthorizationGrant grant, String resource) {
        this.grant = grant;
        this.params = new LinkedHashMap<String, List<String>>();
        if (!StringHelper.isBlank(resource)) {
            this.params.put("resource", Collections.singletonList(resource));
        }
    }

    AdalOAuthAuthorizationGrant(AuthorizationGrant grant, Map<String, List<String>> params) {
        this.grant = grant;
        this.params = params;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> outParams = new LinkedHashMap<String, List<String>>();
        if (this.params != null) {
            outParams.putAll(this.params);
        }
        outParams.put("scope", Collections.singletonList("openid"));
        outParams.putAll(this.grant.toParameters());
        return outParams;
    }

    AuthorizationGrant getAuthorizationGrant() {
        return this.grant;
    }

    Map<String, List<String>> getCustomParameters() {
        return this.params;
    }
}

