/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.DataInputStream;
import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.util.SHA1;
import org.jxmpp.jid.Jid;

public class Socks5Utils {
    public static String createDigest(String sessionID, Jid initiatorJID, Jid targetJID) {
        StringBuilder b = new StringBuilder();
        b.append(sessionID).append(initiatorJID).append(targetJID);
        return SHA1.hex(b.toString());
    }

    public static byte[] receiveSocks5Message(DataInputStream in) throws IOException, SmackException.SmackMessageException {
        byte[] header = new byte[5];
        in.readFully(header, 0, 5);
        if (header[3] != 3) {
            throw new SmackException.SmackMessageException("Unsupported SOCKS5 address type: " + header[3] + " (expected: 0x03)");
        }
        byte addressLength = header[4];
        byte[] response = new byte[7 + addressLength];
        System.arraycopy(header, 0, response, 0, header.length);
        in.readFully(response, header.length, addressLength + 2);
        return response;
    }
}

