/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import nu.xom.Verifier;

final class UnicodeUtil {
    private static final int CANONICAL_COMBINING_CLASS_NOT_REORDERED = 0;
    private static final int CANONICAL_COMBINING_CLASS_OVERLAY = 1;
    private static final int CANONICAL_COMBINING_CLASS_NUKTA = 7;
    private static final int CANONICAL_COMBINING_CLASS_KANA_VOICING = 8;
    private static final int CANONICAL_COMBINING_CLASS_VIRAMA = 9;
    private static final int CANONICAL_COMBINING_CLASS_10 = 10;
    private static final int CANONICAL_COMBINING_CLASS_11 = 11;
    private static final int CANONICAL_COMBINING_CLASS_12 = 12;
    private static final int CANONICAL_COMBINING_CLASS_13 = 13;
    private static final int CANONICAL_COMBINING_CLASS_14 = 14;
    private static final int CANONICAL_COMBINING_CLASS_15 = 15;
    private static final int CANONICAL_COMBINING_CLASS_16 = 16;
    private static final int CANONICAL_COMBINING_CLASS_17 = 17;
    private static final int CANONICAL_COMBINING_CLASS_18 = 18;
    private static final int CANONICAL_COMBINING_CLASS_19 = 19;
    private static final int CANONICAL_COMBINING_CLASS_20 = 20;
    private static final int CANONICAL_COMBINING_CLASS_21 = 21;
    private static final int CANONICAL_COMBINING_CLASS_22 = 22;
    private static final int CANONICAL_COMBINING_CLASS_23 = 23;
    private static final int CANONICAL_COMBINING_CLASS_24 = 24;
    private static final int CANONICAL_COMBINING_CLASS_25 = 25;
    private static final int CANONICAL_COMBINING_CLASS_26 = 26;
    private static final int CANONICAL_COMBINING_CLASS_27 = 27;
    private static final int CANONICAL_COMBINING_CLASS_28 = 28;
    private static final int CANONICAL_COMBINING_CLASS_29 = 29;
    private static final int CANONICAL_COMBINING_CLASS_30 = 30;
    private static final int CANONICAL_COMBINING_CLASS_31 = 31;
    private static final int CANONICAL_COMBINING_CLASS_32 = 32;
    private static final int CANONICAL_COMBINING_CLASS_33 = 33;
    private static final int CANONICAL_COMBINING_CLASS_34 = 34;
    private static final int CANONICAL_COMBINING_CLASS_35 = 35;
    private static final int CANONICAL_COMBINING_CLASS_36 = 36;
    private static final int CANONICAL_COMBINING_CLASS_84 = 84;
    private static final int CANONICAL_COMBINING_CLASS_91 = 91;
    private static final int CANONICAL_COMBINING_CLASS_103 = 103;
    private static final int CANONICAL_COMBINING_CLASS_107 = 107;
    private static final int CANONICAL_COMBINING_CLASS_118 = 118;
    private static final int CANONICAL_COMBINING_CLASS_122 = 122;
    private static final int CANONICAL_COMBINING_CLASS_129 = 129;
    private static final int CANONICAL_COMBINING_CLASS_130 = 130;
    private static final int CANONICAL_COMBINING_CLASS_132 = 132;
    private static final int CANONICAL_COMBINING_CLASS_ATTACHED_BELOW = 202;
    private static final int CANONICAL_COMBINING_CLASS_214 = 214;
    private static final int CANONICAL_COMBINING_CLASS_ATTACHED_ABOVE_RIGHT = 216;
    private static final int CANONICAL_COMBINING_CLASS_BELOW_LEFT = 218;
    private static final int CANONICAL_COMBINING_CLASS_BELOW = 220;
    private static final int CANONICAL_COMBINING_CLASS_BELOW_RIGHT = 222;
    private static final int CANONICAL_COMBINING_CLASS_LEFT = 224;
    private static final int CANONICAL_COMBINING_CLASS_RIGHT = 226;
    private static final int CANONICAL_COMBINING_CLASS_ABOVE_LEFT = 228;
    private static final int CANONICAL_COMBINING_CLASS_ABOVE = 230;
    private static final int CANONICAL_COMBINING_CLASS_ABOVE_RIGHT = 232;
    private static final int CANONICAL_COMBINING_CLASS_DOUBLE_BELOW = 233;
    private static final int CANONICAL_COMBINING_CLASS_DOUBLE_ABOVE = 234;
    private static final int CANONICAL_COMBINING_CLASS_IOTA_SUBSCRIPT = 240;
    private static int HI_SURROGATE_START = 55296;
    private static int HI_SURROGATE_END = 56319;
    private static int LOW_SURROGATE_START = 56320;
    private static Map<String, String> compositions;
    private static final int FIRST_HANGUL_SYLLABLE = 44032;
    private static final int LAST_HANGUL_SYLLABLE = 55203;

    UnicodeUtil() {
    }

    private static boolean isHighSurrogate(char c) {
        return c >= HI_SURROGATE_START && c <= HI_SURROGATE_END;
    }

    private static void loadCompositions() {
        ClassLoader classLoader = Verifier.class.getClassLoader();
        if (classLoader != null) {
            UnicodeUtil.loadCompositions(classLoader);
        }
        if (compositions == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            UnicodeUtil.loadCompositions(classLoader);
        }
        if (compositions == null) {
            throw new RuntimeException("Broken XOM installation: could not load nu/xom/compositions.dat");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCompositions(ClassLoader classLoader) {
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = classLoader.getResourceAsStream("nu/xom/compositions.dat");
            filterInputStream = new DataInputStream(inputStream);
            compositions = new HashMap<String, String>();
            try {
                while (true) {
                    String string = ((DataInputStream)filterInputStream).readUTF();
                    String string2 = ((DataInputStream)filterInputStream).readUTF();
                    compositions.put(string2, string);
                }
            }
            catch (EOFException eOFException) {
                try {
                    if (filterInputStream != null) {
                        filterInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static boolean isStarter(int n) {
        return UnicodeUtil.getCombiningClass(n) == 0;
    }

    private static int getCombiningClass(int n) {
        if (n <= 767) {
            return 0;
        }
        if (n <= 788) {
            return 230;
        }
        if (n <= 789) {
            return 232;
        }
        if (n <= 793) {
            return 220;
        }
        if (n <= 794) {
            return 232;
        }
        if (n <= 795) {
            return 216;
        }
        if (n <= 800) {
            return 220;
        }
        if (n <= 802) {
            return 202;
        }
        if (n <= 806) {
            return 220;
        }
        if (n <= 808) {
            return 202;
        }
        if (n <= 819) {
            return 220;
        }
        if (n <= 824) {
            return 1;
        }
        if (n <= 828) {
            return 220;
        }
        if (n <= 836) {
            return 230;
        }
        if (n <= 837) {
            return 240;
        }
        if (n <= 838) {
            return 230;
        }
        if (n <= 841) {
            return 220;
        }
        if (n <= 844) {
            return 230;
        }
        if (n <= 846) {
            return 220;
        }
        if (n <= 847) {
            return 0;
        }
        if (n <= 850) {
            return 230;
        }
        if (n <= 854) {
            return 220;
        }
        if (n <= 855) {
            return 230;
        }
        if (n <= 856) {
            return 232;
        }
        if (n <= 858) {
            return 220;
        }
        if (n <= 859) {
            return 230;
        }
        if (n <= 860) {
            return 233;
        }
        if (n <= 862) {
            return 234;
        }
        if (n <= 863) {
            return 233;
        }
        if (n <= 865) {
            return 234;
        }
        if (n <= 866) {
            return 233;
        }
        if (n <= 879) {
            return 230;
        }
        if (n <= 1154) {
            return 0;
        }
        if (n <= 1159) {
            return 230;
        }
        if (n <= 1424) {
            return 0;
        }
        if (n <= 1425) {
            return 220;
        }
        if (n <= 1429) {
            return 230;
        }
        if (n <= 1430) {
            return 220;
        }
        if (n <= 1433) {
            return 230;
        }
        if (n <= 1434) {
            return 222;
        }
        if (n <= 1435) {
            return 220;
        }
        if (n <= 1441) {
            return 230;
        }
        if (n <= 1447) {
            return 220;
        }
        if (n <= 1449) {
            return 230;
        }
        if (n <= 1450) {
            return 220;
        }
        if (n <= 1452) {
            return 230;
        }
        if (n <= 1453) {
            return 222;
        }
        if (n <= 1454) {
            return 228;
        }
        if (n <= 1455) {
            return 230;
        }
        if (n <= 1456) {
            return 10;
        }
        if (n <= 1457) {
            return 11;
        }
        if (n <= 1458) {
            return 12;
        }
        if (n <= 1459) {
            return 13;
        }
        if (n <= 1460) {
            return 14;
        }
        if (n <= 1461) {
            return 15;
        }
        if (n <= 1462) {
            return 16;
        }
        if (n <= 1463) {
            return 17;
        }
        if (n <= 1464) {
            return 18;
        }
        if (n <= 1466) {
            return 19;
        }
        if (n <= 1467) {
            return 20;
        }
        if (n <= 1468) {
            return 21;
        }
        if (n <= 1469) {
            return 22;
        }
        if (n <= 1470) {
            return 0;
        }
        if (n <= 1471) {
            return 23;
        }
        if (n <= 1472) {
            return 0;
        }
        if (n <= 1473) {
            return 24;
        }
        if (n <= 1474) {
            return 25;
        }
        if (n <= 1475) {
            return 0;
        }
        if (n <= 1476) {
            return 230;
        }
        if (n <= 1477) {
            return 220;
        }
        if (n <= 1478) {
            return 0;
        }
        if (n <= 1479) {
            return 18;
        }
        if (n <= 1551) {
            return 0;
        }
        if (n <= 1559) {
            return 230;
        }
        if (n <= 1560) {
            return 30;
        }
        if (n <= 1561) {
            return 31;
        }
        if (n <= 1562) {
            return 32;
        }
        if (n <= 1610) {
            return 0;
        }
        if (n <= 1611) {
            return 27;
        }
        if (n <= 1612) {
            return 28;
        }
        if (n <= 1613) {
            return 29;
        }
        if (n <= 1614) {
            return 30;
        }
        if (n <= 1615) {
            return 31;
        }
        if (n <= 1616) {
            return 32;
        }
        if (n <= 1617) {
            return 33;
        }
        if (n <= 1618) {
            return 34;
        }
        if (n <= 1620) {
            return 230;
        }
        if (n <= 1622) {
            return 220;
        }
        if (n <= 1627) {
            return 230;
        }
        if (n <= 1628) {
            return 220;
        }
        if (n <= 1630) {
            return 230;
        }
        if (n <= 1647) {
            return 0;
        }
        if (n <= 1648) {
            return 35;
        }
        if (n <= 1749) {
            return 0;
        }
        if (n <= 1756) {
            return 230;
        }
        if (n <= 1758) {
            return 0;
        }
        if (n <= 1762) {
            return 230;
        }
        if (n <= 1763) {
            return 220;
        }
        if (n <= 1764) {
            return 230;
        }
        if (n <= 1766) {
            return 0;
        }
        if (n <= 1768) {
            return 230;
        }
        if (n <= 1769) {
            return 0;
        }
        if (n <= 1770) {
            return 220;
        }
        if (n <= 1772) {
            return 230;
        }
        if (n <= 1773) {
            return 220;
        }
        if (n <= 1808) {
            return 0;
        }
        if (n <= 1809) {
            return 36;
        }
        if (n <= 1839) {
            return 0;
        }
        if (n <= 1840) {
            return 230;
        }
        if (n <= 1841) {
            return 220;
        }
        if (n <= 1843) {
            return 230;
        }
        if (n <= 1844) {
            return 220;
        }
        if (n <= 1846) {
            return 230;
        }
        if (n <= 1849) {
            return 220;
        }
        if (n <= 1850) {
            return 230;
        }
        if (n <= 1852) {
            return 220;
        }
        if (n <= 1853) {
            return 230;
        }
        if (n <= 1854) {
            return 220;
        }
        if (n <= 1857) {
            return 230;
        }
        if (n <= 1858) {
            return 220;
        }
        if (n <= 1859) {
            return 230;
        }
        if (n <= 1860) {
            return 220;
        }
        if (n <= 1861) {
            return 230;
        }
        if (n <= 1862) {
            return 220;
        }
        if (n <= 1863) {
            return 230;
        }
        if (n <= 1864) {
            return 220;
        }
        if (n <= 1866) {
            return 230;
        }
        if (n <= 2026) {
            return 0;
        }
        if (n <= 2033) {
            return 230;
        }
        if (n <= 2034) {
            return 220;
        }
        if (n <= 2035) {
            return 230;
        }
        if (n <= 2363) {
            return 0;
        }
        if (n <= 2364) {
            return 7;
        }
        if (n <= 2380) {
            return 0;
        }
        if (n <= 2381) {
            return 9;
        }
        if (n <= 2384) {
            return 0;
        }
        if (n <= 2385) {
            return 230;
        }
        if (n <= 2386) {
            return 220;
        }
        if (n <= 2388) {
            return 230;
        }
        if (n <= 2491) {
            return 0;
        }
        if (n <= 2492) {
            return 7;
        }
        if (n <= 2508) {
            return 0;
        }
        if (n <= 2509) {
            return 9;
        }
        if (n <= 2619) {
            return 0;
        }
        if (n <= 2620) {
            return 7;
        }
        if (n <= 2636) {
            return 0;
        }
        if (n <= 2637) {
            return 9;
        }
        if (n <= 2747) {
            return 0;
        }
        if (n <= 2748) {
            return 7;
        }
        if (n <= 2764) {
            return 0;
        }
        if (n <= 2765) {
            return 9;
        }
        if (n <= 2875) {
            return 0;
        }
        if (n <= 2876) {
            return 7;
        }
        if (n <= 2892) {
            return 0;
        }
        if (n <= 2893) {
            return 9;
        }
        if (n <= 3020) {
            return 0;
        }
        if (n <= 3021) {
            return 9;
        }
        if (n <= 3148) {
            return 0;
        }
        if (n <= 3149) {
            return 9;
        }
        if (n <= 3156) {
            return 0;
        }
        if (n <= 3157) {
            return 84;
        }
        if (n <= 3158) {
            return 91;
        }
        if (n <= 3259) {
            return 0;
        }
        if (n <= 3260) {
            return 7;
        }
        if (n <= 3276) {
            return 0;
        }
        if (n <= 3277) {
            return 9;
        }
        if (n <= 3404) {
            return 0;
        }
        if (n <= 3405) {
            return 9;
        }
        if (n <= 3529) {
            return 0;
        }
        if (n <= 3530) {
            return 9;
        }
        if (n <= 3639) {
            return 0;
        }
        if (n <= 3641) {
            return 103;
        }
        if (n <= 3642) {
            return 9;
        }
        if (n <= 3655) {
            return 0;
        }
        if (n <= 3659) {
            return 107;
        }
        if (n <= 3767) {
            return 0;
        }
        if (n <= 3769) {
            return 118;
        }
        if (n <= 3783) {
            return 0;
        }
        if (n <= 3787) {
            return 122;
        }
        if (n <= 3863) {
            return 0;
        }
        if (n <= 3865) {
            return 220;
        }
        if (n <= 3892) {
            return 0;
        }
        if (n <= 3893) {
            return 220;
        }
        if (n <= 3894) {
            return 0;
        }
        if (n <= 3895) {
            return 220;
        }
        if (n <= 3896) {
            return 0;
        }
        if (n <= 3897) {
            return 216;
        }
        if (n <= 3952) {
            return 0;
        }
        if (n <= 3953) {
            return 129;
        }
        if (n <= 3954) {
            return 130;
        }
        if (n <= 3955) {
            return 0;
        }
        if (n <= 3956) {
            return 132;
        }
        if (n <= 3961) {
            return 0;
        }
        if (n <= 3965) {
            return 130;
        }
        if (n <= 3967) {
            return 0;
        }
        if (n <= 3968) {
            return 130;
        }
        if (n <= 3969) {
            return 0;
        }
        if (n <= 3971) {
            return 230;
        }
        if (n <= 3972) {
            return 9;
        }
        if (n <= 3973) {
            return 0;
        }
        if (n <= 3975) {
            return 230;
        }
        if (n <= 4037) {
            return 0;
        }
        if (n <= 4038) {
            return 220;
        }
        if (n <= 4150) {
            return 0;
        }
        if (n <= 4151) {
            return 7;
        }
        if (n <= 4152) {
            return 0;
        }
        if (n <= 4154) {
            return 9;
        }
        if (n <= 4236) {
            return 0;
        }
        if (n <= 4237) {
            return 220;
        }
        if (n <= 4958) {
            return 0;
        }
        if (n <= 4959) {
            return 230;
        }
        if (n <= 5907) {
            return 0;
        }
        if (n <= 5908) {
            return 9;
        }
        if (n <= 5939) {
            return 0;
        }
        if (n <= 5940) {
            return 9;
        }
        if (n <= 6097) {
            return 0;
        }
        if (n <= 6098) {
            return 9;
        }
        if (n <= 6108) {
            return 0;
        }
        if (n <= 6109) {
            return 230;
        }
        if (n <= 6312) {
            return 0;
        }
        if (n <= 6313) {
            return 228;
        }
        if (n <= 6456) {
            return 0;
        }
        if (n <= 6457) {
            return 222;
        }
        if (n <= 6458) {
            return 230;
        }
        if (n <= 6459) {
            return 220;
        }
        if (n <= 6678) {
            return 0;
        }
        if (n <= 6679) {
            return 230;
        }
        if (n <= 6680) {
            return 220;
        }
        if (n <= 6963) {
            return 0;
        }
        if (n <= 6964) {
            return 7;
        }
        if (n <= 6979) {
            return 0;
        }
        if (n <= 6980) {
            return 9;
        }
        if (n <= 7018) {
            return 0;
        }
        if (n <= 7019) {
            return 230;
        }
        if (n <= 7020) {
            return 220;
        }
        if (n <= 7027) {
            return 230;
        }
        if (n <= 7081) {
            return 0;
        }
        if (n <= 7082) {
            return 9;
        }
        if (n <= 7222) {
            return 0;
        }
        if (n <= 7223) {
            return 7;
        }
        if (n <= 7615) {
            return 0;
        }
        if (n <= 7617) {
            return 230;
        }
        if (n <= 7618) {
            return 220;
        }
        if (n <= 7625) {
            return 230;
        }
        if (n <= 7626) {
            return 220;
        }
        if (n <= 7628) {
            return 230;
        }
        if (n <= 7629) {
            return 234;
        }
        if (n <= 7630) {
            return 214;
        }
        if (n <= 7631) {
            return 220;
        }
        if (n <= 7632) {
            return 202;
        }
        if (n <= 7654) {
            return 230;
        }
        if (n <= 7677) {
            return 0;
        }
        if (n <= 7678) {
            return 230;
        }
        if (n <= 7679) {
            return 220;
        }
        if (n <= 8399) {
            return 0;
        }
        if (n <= 8401) {
            return 230;
        }
        if (n <= 8403) {
            return 1;
        }
        if (n <= 8407) {
            return 230;
        }
        if (n <= 8410) {
            return 1;
        }
        if (n <= 8412) {
            return 230;
        }
        if (n <= 8416) {
            return 0;
        }
        if (n <= 8417) {
            return 230;
        }
        if (n <= 8420) {
            return 0;
        }
        if (n <= 8422) {
            return 1;
        }
        if (n <= 8423) {
            return 230;
        }
        if (n <= 8424) {
            return 220;
        }
        if (n <= 8425) {
            return 230;
        }
        if (n <= 8427) {
            return 1;
        }
        if (n <= 8431) {
            return 220;
        }
        if (n <= 8432) {
            return 230;
        }
        if (n <= 11743) {
            return 0;
        }
        if (n <= 11775) {
            return 230;
        }
        if (n <= 12329) {
            return 0;
        }
        if (n <= 12330) {
            return 218;
        }
        if (n <= 12331) {
            return 228;
        }
        if (n <= 12332) {
            return 232;
        }
        if (n <= 12333) {
            return 222;
        }
        if (n <= 12335) {
            return 224;
        }
        if (n <= 12440) {
            return 0;
        }
        if (n <= 12442) {
            return 8;
        }
        if (n <= 42606) {
            return 0;
        }
        if (n <= 42607) {
            return 230;
        }
        if (n <= 42619) {
            return 0;
        }
        if (n <= 42621) {
            return 230;
        }
        if (n <= 43013) {
            return 0;
        }
        if (n <= 43014) {
            return 9;
        }
        if (n <= 43203) {
            return 0;
        }
        if (n <= 43204) {
            return 9;
        }
        if (n <= 43306) {
            return 0;
        }
        if (n <= 43309) {
            return 220;
        }
        if (n <= 43346) {
            return 0;
        }
        if (n <= 43347) {
            return 9;
        }
        if (n <= 64285) {
            return 0;
        }
        if (n <= 64286) {
            return 26;
        }
        if (n <= 65055) {
            return 0;
        }
        if (n <= 65062) {
            return 230;
        }
        if (n <= 66044) {
            return 0;
        }
        if (n <= 66045) {
            return 220;
        }
        if (n <= 68108) {
            return 0;
        }
        if (n <= 68109) {
            return 220;
        }
        if (n <= 68110) {
            return 0;
        }
        if (n <= 68111) {
            return 230;
        }
        if (n <= 68151) {
            return 0;
        }
        if (n <= 68152) {
            return 230;
        }
        if (n <= 68153) {
            return 1;
        }
        if (n <= 68154) {
            return 220;
        }
        if (n <= 68158) {
            return 0;
        }
        if (n <= 68159) {
            return 9;
        }
        if (n <= 119140) {
            return 0;
        }
        if (n <= 119142) {
            return 216;
        }
        if (n <= 119145) {
            return 1;
        }
        if (n <= 119148) {
            return 0;
        }
        if (n <= 119149) {
            return 226;
        }
        if (n <= 119154) {
            return 216;
        }
        if (n <= 119162) {
            return 0;
        }
        if (n <= 119170) {
            return 220;
        }
        if (n <= 119172) {
            return 0;
        }
        if (n <= 119177) {
            return 230;
        }
        if (n <= 119179) {
            return 220;
        }
        if (n <= 119209) {
            return 0;
        }
        if (n <= 119213) {
            return 230;
        }
        if (n <= 119361) {
            return 0;
        }
        if (n <= 119364) {
            return 230;
        }
        return 0;
    }

    static int combineSurrogatePair(char c, char c2) {
        int n = c & 0x7FF;
        int n2 = c2 - 56320;
        int n3 = n << 10;
        int n4 = n3 | n2;
        int n5 = n4 + 65536;
        return n5;
    }

    private static String makeSurrogatePair(int n) {
        StringBuilder stringBuilder = new StringBuilder(2);
        if (n <= 65535) {
            stringBuilder.append((char)n);
        } else {
            char c = (char)(55232 + (n >> 10));
            char c2 = (char)(56320 + (n & 0x3FF));
            stringBuilder.append(c);
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static char getHighSurrogate(int n) {
        char c = (char)n;
        int n2 = n >> 16 & 0x1F;
        char c2 = (char)(n2 - 1);
        return (char)(HI_SURROGATE_START | c2 << 6 | c >> 10);
    }

    private static char getLowSurrogate(int n) {
        char c = (char)n;
        return (char)(LOW_SURROGATE_START | c & 0x3FF);
    }

    static String normalize(String string) {
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c <= '\u00ff') continue;
            bl = true;
            break;
        }
        if (bl) {
            string = UnicodeUtil.decomposeHangul(string);
            UnicodeString unicodeString = new UnicodeString(string);
            UnicodeString unicodeString2 = unicodeString.decompose();
            UnicodeString unicodeString3 = unicodeString2.compose();
            String string2 = unicodeString3.toString();
            string2 = UnicodeUtil.composeHangul(string2);
            return string2;
        }
        return string;
    }

    private static String decomposeHangul(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\uac00' && c <= '\ud7a3') {
                stringBuilder.append(UnicodeUtil.decomposeHangul(c));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static int composeCharacter(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(4);
        if (n > 65535) {
            stringBuilder.append(UnicodeUtil.getHighSurrogate(n));
            stringBuilder.append(UnicodeUtil.getLowSurrogate(n));
        } else {
            stringBuilder.append((char)n);
        }
        if (n2 > 65535) {
            stringBuilder.append(UnicodeUtil.getHighSurrogate(n2));
            stringBuilder.append(UnicodeUtil.getLowSurrogate(n2));
        } else {
            stringBuilder.append((char)n2);
        }
        String string = compositions.get(stringBuilder.toString());
        if (string == null) {
            return -1;
        }
        if (string.length() == 1) {
            return string.charAt(0);
        }
        return UnicodeUtil.combineSurrogatePair(string.charAt(0), string.charAt(1));
    }

    private static String decompose(int n) {
        if (n < 192) {
            return String.valueOf((char)n);
        }
        if (n >= 44032 && n <= 55203) {
            return UnicodeUtil.decomposeHangul((char)n);
        }
        switch (n) {
            case 192: {
                return "A\u0300";
            }
            case 193: {
                return "A\u0301";
            }
            case 194: {
                return "A\u0302";
            }
            case 195: {
                return "A\u0303";
            }
            case 196: {
                return "A\u0308";
            }
            case 197: {
                return "A\u030a";
            }
            case 199: {
                return "C\u0327";
            }
            case 200: {
                return "E\u0300";
            }
            case 201: {
                return "E\u0301";
            }
            case 202: {
                return "E\u0302";
            }
            case 203: {
                return "E\u0308";
            }
            case 204: {
                return "I\u0300";
            }
            case 205: {
                return "I\u0301";
            }
            case 206: {
                return "I\u0302";
            }
            case 207: {
                return "I\u0308";
            }
            case 209: {
                return "N\u0303";
            }
            case 210: {
                return "O\u0300";
            }
            case 211: {
                return "O\u0301";
            }
            case 212: {
                return "O\u0302";
            }
            case 213: {
                return "O\u0303";
            }
            case 214: {
                return "O\u0308";
            }
            case 217: {
                return "U\u0300";
            }
            case 218: {
                return "U\u0301";
            }
            case 219: {
                return "U\u0302";
            }
            case 220: {
                return "U\u0308";
            }
            case 221: {
                return "Y\u0301";
            }
            case 224: {
                return "a\u0300";
            }
            case 225: {
                return "a\u0301";
            }
            case 226: {
                return "a\u0302";
            }
            case 227: {
                return "a\u0303";
            }
            case 228: {
                return "a\u0308";
            }
            case 229: {
                return "a\u030a";
            }
            case 231: {
                return "c\u0327";
            }
            case 232: {
                return "e\u0300";
            }
            case 233: {
                return "e\u0301";
            }
            case 234: {
                return "e\u0302";
            }
            case 235: {
                return "e\u0308";
            }
            case 236: {
                return "i\u0300";
            }
            case 237: {
                return "i\u0301";
            }
            case 238: {
                return "i\u0302";
            }
            case 239: {
                return "i\u0308";
            }
            case 241: {
                return "n\u0303";
            }
            case 242: {
                return "o\u0300";
            }
            case 243: {
                return "o\u0301";
            }
            case 244: {
                return "o\u0302";
            }
            case 245: {
                return "o\u0303";
            }
            case 246: {
                return "o\u0308";
            }
            case 249: {
                return "u\u0300";
            }
            case 250: {
                return "u\u0301";
            }
            case 251: {
                return "u\u0302";
            }
            case 252: {
                return "u\u0308";
            }
            case 253: {
                return "y\u0301";
            }
            case 255: {
                return "y\u0308";
            }
            case 256: {
                return "A\u0304";
            }
            case 257: {
                return "a\u0304";
            }
            case 258: {
                return "A\u0306";
            }
            case 259: {
                return "a\u0306";
            }
            case 260: {
                return "A\u0328";
            }
            case 261: {
                return "a\u0328";
            }
            case 262: {
                return "C\u0301";
            }
            case 263: {
                return "c\u0301";
            }
            case 264: {
                return "C\u0302";
            }
            case 265: {
                return "c\u0302";
            }
            case 266: {
                return "C\u0307";
            }
            case 267: {
                return "c\u0307";
            }
            case 268: {
                return "C\u030c";
            }
            case 269: {
                return "c\u030c";
            }
            case 270: {
                return "D\u030c";
            }
            case 271: {
                return "d\u030c";
            }
            case 274: {
                return "E\u0304";
            }
            case 275: {
                return "e\u0304";
            }
            case 276: {
                return "E\u0306";
            }
            case 277: {
                return "e\u0306";
            }
            case 278: {
                return "E\u0307";
            }
            case 279: {
                return "e\u0307";
            }
            case 280: {
                return "E\u0328";
            }
            case 281: {
                return "e\u0328";
            }
            case 282: {
                return "E\u030c";
            }
            case 283: {
                return "e\u030c";
            }
            case 284: {
                return "G\u0302";
            }
            case 285: {
                return "g\u0302";
            }
            case 286: {
                return "G\u0306";
            }
            case 287: {
                return "g\u0306";
            }
            case 288: {
                return "G\u0307";
            }
            case 289: {
                return "g\u0307";
            }
            case 290: {
                return "G\u0327";
            }
            case 291: {
                return "g\u0327";
            }
            case 292: {
                return "H\u0302";
            }
            case 293: {
                return "h\u0302";
            }
            case 296: {
                return "I\u0303";
            }
            case 297: {
                return "i\u0303";
            }
            case 298: {
                return "I\u0304";
            }
            case 299: {
                return "i\u0304";
            }
            case 300: {
                return "I\u0306";
            }
            case 301: {
                return "i\u0306";
            }
            case 302: {
                return "I\u0328";
            }
            case 303: {
                return "i\u0328";
            }
            case 304: {
                return "I\u0307";
            }
            case 308: {
                return "J\u0302";
            }
            case 309: {
                return "j\u0302";
            }
            case 310: {
                return "K\u0327";
            }
            case 311: {
                return "k\u0327";
            }
            case 313: {
                return "L\u0301";
            }
            case 314: {
                return "l\u0301";
            }
            case 315: {
                return "L\u0327";
            }
            case 316: {
                return "l\u0327";
            }
            case 317: {
                return "L\u030c";
            }
            case 318: {
                return "l\u030c";
            }
            case 323: {
                return "N\u0301";
            }
            case 324: {
                return "n\u0301";
            }
            case 325: {
                return "N\u0327";
            }
            case 326: {
                return "n\u0327";
            }
            case 327: {
                return "N\u030c";
            }
            case 328: {
                return "n\u030c";
            }
            case 332: {
                return "O\u0304";
            }
            case 333: {
                return "o\u0304";
            }
            case 334: {
                return "O\u0306";
            }
            case 335: {
                return "o\u0306";
            }
            case 336: {
                return "O\u030b";
            }
            case 337: {
                return "o\u030b";
            }
            case 340: {
                return "R\u0301";
            }
            case 341: {
                return "r\u0301";
            }
            case 342: {
                return "R\u0327";
            }
            case 343: {
                return "r\u0327";
            }
            case 344: {
                return "R\u030c";
            }
            case 345: {
                return "r\u030c";
            }
            case 346: {
                return "S\u0301";
            }
            case 347: {
                return "s\u0301";
            }
            case 348: {
                return "S\u0302";
            }
            case 349: {
                return "s\u0302";
            }
            case 350: {
                return "S\u0327";
            }
            case 351: {
                return "s\u0327";
            }
            case 352: {
                return "S\u030c";
            }
            case 353: {
                return "s\u030c";
            }
            case 354: {
                return "T\u0327";
            }
            case 355: {
                return "t\u0327";
            }
            case 356: {
                return "T\u030c";
            }
            case 357: {
                return "t\u030c";
            }
            case 360: {
                return "U\u0303";
            }
            case 361: {
                return "u\u0303";
            }
            case 362: {
                return "U\u0304";
            }
            case 363: {
                return "u\u0304";
            }
            case 364: {
                return "U\u0306";
            }
            case 365: {
                return "u\u0306";
            }
            case 366: {
                return "U\u030a";
            }
            case 367: {
                return "u\u030a";
            }
            case 368: {
                return "U\u030b";
            }
            case 369: {
                return "u\u030b";
            }
            case 370: {
                return "U\u0328";
            }
            case 371: {
                return "u\u0328";
            }
            case 372: {
                return "W\u0302";
            }
            case 373: {
                return "w\u0302";
            }
            case 374: {
                return "Y\u0302";
            }
            case 375: {
                return "y\u0302";
            }
            case 376: {
                return "Y\u0308";
            }
            case 377: {
                return "Z\u0301";
            }
            case 378: {
                return "z\u0301";
            }
            case 379: {
                return "Z\u0307";
            }
            case 380: {
                return "z\u0307";
            }
            case 381: {
                return "Z\u030c";
            }
            case 382: {
                return "z\u030c";
            }
            case 416: {
                return "O\u031b";
            }
            case 417: {
                return "o\u031b";
            }
            case 431: {
                return "U\u031b";
            }
            case 432: {
                return "u\u031b";
            }
            case 461: {
                return "A\u030c";
            }
            case 462: {
                return "a\u030c";
            }
            case 463: {
                return "I\u030c";
            }
            case 464: {
                return "i\u030c";
            }
            case 465: {
                return "O\u030c";
            }
            case 466: {
                return "o\u030c";
            }
            case 467: {
                return "U\u030c";
            }
            case 468: {
                return "u\u030c";
            }
            case 469: {
                return "\u00dc\u0304";
            }
            case 470: {
                return "\u00fc\u0304";
            }
            case 471: {
                return "\u00dc\u0301";
            }
            case 472: {
                return "\u00fc\u0301";
            }
            case 473: {
                return "\u00dc\u030c";
            }
            case 474: {
                return "\u00fc\u030c";
            }
            case 475: {
                return "\u00dc\u0300";
            }
            case 476: {
                return "\u00fc\u0300";
            }
            case 478: {
                return "\u00c4\u0304";
            }
            case 479: {
                return "\u00e4\u0304";
            }
            case 480: {
                return "\u0226\u0304";
            }
            case 481: {
                return "\u0227\u0304";
            }
            case 482: {
                return "\u00c6\u0304";
            }
            case 483: {
                return "\u00e6\u0304";
            }
            case 486: {
                return "G\u030c";
            }
            case 487: {
                return "g\u030c";
            }
            case 488: {
                return "K\u030c";
            }
            case 489: {
                return "k\u030c";
            }
            case 490: {
                return "O\u0328";
            }
            case 491: {
                return "o\u0328";
            }
            case 492: {
                return "\u01ea\u0304";
            }
            case 493: {
                return "\u01eb\u0304";
            }
            case 494: {
                return "\u01b7\u030c";
            }
            case 495: {
                return "\u0292\u030c";
            }
            case 496: {
                return "j\u030c";
            }
            case 500: {
                return "G\u0301";
            }
            case 501: {
                return "g\u0301";
            }
            case 504: {
                return "N\u0300";
            }
            case 505: {
                return "n\u0300";
            }
            case 506: {
                return "\u00c5\u0301";
            }
            case 507: {
                return "\u00e5\u0301";
            }
            case 508: {
                return "\u00c6\u0301";
            }
            case 509: {
                return "\u00e6\u0301";
            }
            case 510: {
                return "\u00d8\u0301";
            }
            case 511: {
                return "\u00f8\u0301";
            }
            case 512: {
                return "A\u030f";
            }
            case 513: {
                return "a\u030f";
            }
            case 514: {
                return "A\u0311";
            }
            case 515: {
                return "a\u0311";
            }
            case 516: {
                return "E\u030f";
            }
            case 517: {
                return "e\u030f";
            }
            case 518: {
                return "E\u0311";
            }
            case 519: {
                return "e\u0311";
            }
            case 520: {
                return "I\u030f";
            }
            case 521: {
                return "i\u030f";
            }
            case 522: {
                return "I\u0311";
            }
            case 523: {
                return "i\u0311";
            }
            case 524: {
                return "O\u030f";
            }
            case 525: {
                return "o\u030f";
            }
            case 526: {
                return "O\u0311";
            }
            case 527: {
                return "o\u0311";
            }
            case 528: {
                return "R\u030f";
            }
            case 529: {
                return "r\u030f";
            }
            case 530: {
                return "R\u0311";
            }
            case 531: {
                return "r\u0311";
            }
            case 532: {
                return "U\u030f";
            }
            case 533: {
                return "u\u030f";
            }
            case 534: {
                return "U\u0311";
            }
            case 535: {
                return "u\u0311";
            }
            case 536: {
                return "S\u0326";
            }
            case 537: {
                return "s\u0326";
            }
            case 538: {
                return "T\u0326";
            }
            case 539: {
                return "t\u0326";
            }
            case 542: {
                return "H\u030c";
            }
            case 543: {
                return "h\u030c";
            }
            case 550: {
                return "A\u0307";
            }
            case 551: {
                return "a\u0307";
            }
            case 552: {
                return "E\u0327";
            }
            case 553: {
                return "e\u0327";
            }
            case 554: {
                return "\u00d6\u0304";
            }
            case 555: {
                return "\u00f6\u0304";
            }
            case 556: {
                return "\u00d5\u0304";
            }
            case 557: {
                return "\u00f5\u0304";
            }
            case 558: {
                return "O\u0307";
            }
            case 559: {
                return "o\u0307";
            }
            case 560: {
                return "\u022e\u0304";
            }
            case 561: {
                return "\u022f\u0304";
            }
            case 562: {
                return "Y\u0304";
            }
            case 563: {
                return "y\u0304";
            }
            case 832: {
                return "\u0300";
            }
            case 833: {
                return "\u0301";
            }
            case 835: {
                return "\u0313";
            }
            case 836: {
                return "\u0308\u0301";
            }
            case 884: {
                return "\u02b9";
            }
            case 894: {
                return ";";
            }
            case 901: {
                return "\u00a8\u0301";
            }
            case 902: {
                return "\u0391\u0301";
            }
            case 903: {
                return "\u00b7";
            }
            case 904: {
                return "\u0395\u0301";
            }
            case 905: {
                return "\u0397\u0301";
            }
            case 906: {
                return "\u0399\u0301";
            }
            case 908: {
                return "\u039f\u0301";
            }
            case 910: {
                return "\u03a5\u0301";
            }
            case 911: {
                return "\u03a9\u0301";
            }
            case 912: {
                return "\u03ca\u0301";
            }
            case 938: {
                return "\u0399\u0308";
            }
            case 939: {
                return "\u03a5\u0308";
            }
            case 940: {
                return "\u03b1\u0301";
            }
            case 941: {
                return "\u03b5\u0301";
            }
            case 942: {
                return "\u03b7\u0301";
            }
            case 943: {
                return "\u03b9\u0301";
            }
            case 944: {
                return "\u03cb\u0301";
            }
            case 970: {
                return "\u03b9\u0308";
            }
            case 971: {
                return "\u03c5\u0308";
            }
            case 972: {
                return "\u03bf\u0301";
            }
            case 973: {
                return "\u03c5\u0301";
            }
            case 974: {
                return "\u03c9\u0301";
            }
            case 979: {
                return "\u03d2\u0301";
            }
            case 980: {
                return "\u03d2\u0308";
            }
            case 1024: {
                return "\u0415\u0300";
            }
            case 1025: {
                return "\u0415\u0308";
            }
            case 1027: {
                return "\u0413\u0301";
            }
            case 1031: {
                return "\u0406\u0308";
            }
            case 1036: {
                return "\u041a\u0301";
            }
            case 1037: {
                return "\u0418\u0300";
            }
            case 1038: {
                return "\u0423\u0306";
            }
            case 1049: {
                return "\u0418\u0306";
            }
            case 1081: {
                return "\u0438\u0306";
            }
            case 1104: {
                return "\u0435\u0300";
            }
            case 1105: {
                return "\u0435\u0308";
            }
            case 1107: {
                return "\u0433\u0301";
            }
            case 1111: {
                return "\u0456\u0308";
            }
            case 1116: {
                return "\u043a\u0301";
            }
            case 1117: {
                return "\u0438\u0300";
            }
            case 1118: {
                return "\u0443\u0306";
            }
            case 1142: {
                return "\u0474\u030f";
            }
            case 1143: {
                return "\u0475\u030f";
            }
            case 1217: {
                return "\u0416\u0306";
            }
            case 1218: {
                return "\u0436\u0306";
            }
            case 1232: {
                return "\u0410\u0306";
            }
            case 1233: {
                return "\u0430\u0306";
            }
            case 1234: {
                return "\u0410\u0308";
            }
            case 1235: {
                return "\u0430\u0308";
            }
            case 1238: {
                return "\u0415\u0306";
            }
            case 1239: {
                return "\u0435\u0306";
            }
            case 1242: {
                return "\u04d8\u0308";
            }
            case 1243: {
                return "\u04d9\u0308";
            }
            case 1244: {
                return "\u0416\u0308";
            }
            case 1245: {
                return "\u0436\u0308";
            }
            case 1246: {
                return "\u0417\u0308";
            }
            case 1247: {
                return "\u0437\u0308";
            }
            case 1250: {
                return "\u0418\u0304";
            }
            case 1251: {
                return "\u0438\u0304";
            }
            case 1252: {
                return "\u0418\u0308";
            }
            case 1253: {
                return "\u0438\u0308";
            }
            case 1254: {
                return "\u041e\u0308";
            }
            case 1255: {
                return "\u043e\u0308";
            }
            case 1258: {
                return "\u04e8\u0308";
            }
            case 1259: {
                return "\u04e9\u0308";
            }
            case 1260: {
                return "\u042d\u0308";
            }
            case 1261: {
                return "\u044d\u0308";
            }
            case 1262: {
                return "\u0423\u0304";
            }
            case 1263: {
                return "\u0443\u0304";
            }
            case 1264: {
                return "\u0423\u0308";
            }
            case 1265: {
                return "\u0443\u0308";
            }
            case 1266: {
                return "\u0423\u030b";
            }
            case 1267: {
                return "\u0443\u030b";
            }
            case 1268: {
                return "\u0427\u0308";
            }
            case 1269: {
                return "\u0447\u0308";
            }
            case 1272: {
                return "\u042b\u0308";
            }
            case 1273: {
                return "\u044b\u0308";
            }
            case 1570: {
                return "\u0627\u0653";
            }
            case 1571: {
                return "\u0627\u0654";
            }
            case 1572: {
                return "\u0648\u0654";
            }
            case 1573: {
                return "\u0627\u0655";
            }
            case 1574: {
                return "\u064a\u0654";
            }
            case 1728: {
                return "\u06d5\u0654";
            }
            case 1730: {
                return "\u06c1\u0654";
            }
            case 1747: {
                return "\u06d2\u0654";
            }
            case 2345: {
                return "\u0928\u093c";
            }
            case 2353: {
                return "\u0930\u093c";
            }
            case 2356: {
                return "\u0933\u093c";
            }
            case 2392: {
                return "\u0915\u093c";
            }
            case 2393: {
                return "\u0916\u093c";
            }
            case 2394: {
                return "\u0917\u093c";
            }
            case 2395: {
                return "\u091c\u093c";
            }
            case 2396: {
                return "\u0921\u093c";
            }
            case 2397: {
                return "\u0922\u093c";
            }
            case 2398: {
                return "\u092b\u093c";
            }
            case 2399: {
                return "\u092f\u093c";
            }
            case 2507: {
                return "\u09c7\u09be";
            }
            case 2508: {
                return "\u09c7\u09d7";
            }
            case 2524: {
                return "\u09a1\u09bc";
            }
            case 2525: {
                return "\u09a2\u09bc";
            }
            case 2527: {
                return "\u09af\u09bc";
            }
            case 2611: {
                return "\u0a32\u0a3c";
            }
            case 2614: {
                return "\u0a38\u0a3c";
            }
            case 2649: {
                return "\u0a16\u0a3c";
            }
            case 2650: {
                return "\u0a17\u0a3c";
            }
            case 2651: {
                return "\u0a1c\u0a3c";
            }
            case 2654: {
                return "\u0a2b\u0a3c";
            }
            case 2888: {
                return "\u0b47\u0b56";
            }
            case 2891: {
                return "\u0b47\u0b3e";
            }
            case 2892: {
                return "\u0b47\u0b57";
            }
            case 2908: {
                return "\u0b21\u0b3c";
            }
            case 2909: {
                return "\u0b22\u0b3c";
            }
            case 2964: {
                return "\u0b92\u0bd7";
            }
            case 3018: {
                return "\u0bc6\u0bbe";
            }
            case 3019: {
                return "\u0bc7\u0bbe";
            }
            case 3020: {
                return "\u0bc6\u0bd7";
            }
            case 3144: {
                return "\u0c46\u0c56";
            }
            case 3264: {
                return "\u0cbf\u0cd5";
            }
            case 3271: {
                return "\u0cc6\u0cd5";
            }
            case 3272: {
                return "\u0cc6\u0cd6";
            }
            case 3274: {
                return "\u0cc6\u0cc2";
            }
            case 3275: {
                return "\u0cca\u0cd5";
            }
            case 3402: {
                return "\u0d46\u0d3e";
            }
            case 3403: {
                return "\u0d47\u0d3e";
            }
            case 3404: {
                return "\u0d46\u0d57";
            }
            case 3546: {
                return "\u0dd9\u0dca";
            }
            case 3548: {
                return "\u0dd9\u0dcf";
            }
            case 3549: {
                return "\u0ddc\u0dca";
            }
            case 3550: {
                return "\u0dd9\u0ddf";
            }
            case 3907: {
                return "\u0f42\u0fb7";
            }
            case 3917: {
                return "\u0f4c\u0fb7";
            }
            case 3922: {
                return "\u0f51\u0fb7";
            }
            case 3927: {
                return "\u0f56\u0fb7";
            }
            case 3932: {
                return "\u0f5b\u0fb7";
            }
            case 3945: {
                return "\u0f40\u0fb5";
            }
            case 3955: {
                return "\u0f71\u0f72";
            }
            case 3957: {
                return "\u0f71\u0f74";
            }
            case 3958: {
                return "\u0fb2\u0f80";
            }
            case 3960: {
                return "\u0fb3\u0f80";
            }
            case 3969: {
                return "\u0f71\u0f80";
            }
            case 3987: {
                return "\u0f92\u0fb7";
            }
            case 3997: {
                return "\u0f9c\u0fb7";
            }
            case 4002: {
                return "\u0fa1\u0fb7";
            }
            case 4007: {
                return "\u0fa6\u0fb7";
            }
            case 4012: {
                return "\u0fab\u0fb7";
            }
            case 4025: {
                return "\u0f90\u0fb5";
            }
            case 4134: {
                return "\u1025\u102e";
            }
            case 6918: {
                return "\u1b05\u1b35";
            }
            case 6920: {
                return "\u1b07\u1b35";
            }
            case 6922: {
                return "\u1b09\u1b35";
            }
            case 6924: {
                return "\u1b0b\u1b35";
            }
            case 6926: {
                return "\u1b0d\u1b35";
            }
            case 6930: {
                return "\u1b11\u1b35";
            }
            case 6971: {
                return "\u1b3a\u1b35";
            }
            case 6973: {
                return "\u1b3c\u1b35";
            }
            case 6976: {
                return "\u1b3e\u1b35";
            }
            case 6977: {
                return "\u1b3f\u1b35";
            }
            case 6979: {
                return "\u1b42\u1b35";
            }
            case 7680: {
                return "A\u0325";
            }
            case 7681: {
                return "a\u0325";
            }
            case 7682: {
                return "B\u0307";
            }
            case 7683: {
                return "b\u0307";
            }
            case 7684: {
                return "B\u0323";
            }
            case 7685: {
                return "b\u0323";
            }
            case 7686: {
                return "B\u0331";
            }
            case 7687: {
                return "b\u0331";
            }
            case 7688: {
                return "\u00c7\u0301";
            }
            case 7689: {
                return "\u00e7\u0301";
            }
            case 7690: {
                return "D\u0307";
            }
            case 7691: {
                return "d\u0307";
            }
            case 7692: {
                return "D\u0323";
            }
            case 7693: {
                return "d\u0323";
            }
            case 7694: {
                return "D\u0331";
            }
            case 7695: {
                return "d\u0331";
            }
            case 7696: {
                return "D\u0327";
            }
            case 7697: {
                return "d\u0327";
            }
            case 7698: {
                return "D\u032d";
            }
            case 7699: {
                return "d\u032d";
            }
            case 7700: {
                return "\u0112\u0300";
            }
            case 7701: {
                return "\u0113\u0300";
            }
            case 7702: {
                return "\u0112\u0301";
            }
            case 7703: {
                return "\u0113\u0301";
            }
            case 7704: {
                return "E\u032d";
            }
            case 7705: {
                return "e\u032d";
            }
            case 7706: {
                return "E\u0330";
            }
            case 7707: {
                return "e\u0330";
            }
            case 7708: {
                return "\u0228\u0306";
            }
            case 7709: {
                return "\u0229\u0306";
            }
            case 7710: {
                return "F\u0307";
            }
            case 7711: {
                return "f\u0307";
            }
            case 7712: {
                return "G\u0304";
            }
            case 7713: {
                return "g\u0304";
            }
            case 7714: {
                return "H\u0307";
            }
            case 7715: {
                return "h\u0307";
            }
            case 7716: {
                return "H\u0323";
            }
            case 7717: {
                return "h\u0323";
            }
            case 7718: {
                return "H\u0308";
            }
            case 7719: {
                return "h\u0308";
            }
            case 7720: {
                return "H\u0327";
            }
            case 7721: {
                return "h\u0327";
            }
            case 7722: {
                return "H\u032e";
            }
            case 7723: {
                return "h\u032e";
            }
            case 7724: {
                return "I\u0330";
            }
            case 7725: {
                return "i\u0330";
            }
            case 7726: {
                return "\u00cf\u0301";
            }
            case 7727: {
                return "\u00ef\u0301";
            }
            case 7728: {
                return "K\u0301";
            }
            case 7729: {
                return "k\u0301";
            }
            case 7730: {
                return "K\u0323";
            }
            case 7731: {
                return "k\u0323";
            }
            case 7732: {
                return "K\u0331";
            }
            case 7733: {
                return "k\u0331";
            }
            case 7734: {
                return "L\u0323";
            }
            case 7735: {
                return "l\u0323";
            }
            case 7736: {
                return "\u1e36\u0304";
            }
            case 7737: {
                return "\u1e37\u0304";
            }
            case 7738: {
                return "L\u0331";
            }
            case 7739: {
                return "l\u0331";
            }
            case 7740: {
                return "L\u032d";
            }
            case 7741: {
                return "l\u032d";
            }
            case 7742: {
                return "M\u0301";
            }
            case 7743: {
                return "m\u0301";
            }
            case 7744: {
                return "M\u0307";
            }
            case 7745: {
                return "m\u0307";
            }
            case 7746: {
                return "M\u0323";
            }
            case 7747: {
                return "m\u0323";
            }
            case 7748: {
                return "N\u0307";
            }
            case 7749: {
                return "n\u0307";
            }
            case 7750: {
                return "N\u0323";
            }
            case 7751: {
                return "n\u0323";
            }
            case 7752: {
                return "N\u0331";
            }
            case 7753: {
                return "n\u0331";
            }
            case 7754: {
                return "N\u032d";
            }
            case 7755: {
                return "n\u032d";
            }
            case 7756: {
                return "\u00d5\u0301";
            }
            case 7757: {
                return "\u00f5\u0301";
            }
            case 7758: {
                return "\u00d5\u0308";
            }
            case 7759: {
                return "\u00f5\u0308";
            }
            case 7760: {
                return "\u014c\u0300";
            }
            case 7761: {
                return "\u014d\u0300";
            }
            case 7762: {
                return "\u014c\u0301";
            }
            case 7763: {
                return "\u014d\u0301";
            }
            case 7764: {
                return "P\u0301";
            }
            case 7765: {
                return "p\u0301";
            }
            case 7766: {
                return "P\u0307";
            }
            case 7767: {
                return "p\u0307";
            }
            case 7768: {
                return "R\u0307";
            }
            case 7769: {
                return "r\u0307";
            }
            case 7770: {
                return "R\u0323";
            }
            case 7771: {
                return "r\u0323";
            }
            case 7772: {
                return "\u1e5a\u0304";
            }
            case 7773: {
                return "\u1e5b\u0304";
            }
            case 7774: {
                return "R\u0331";
            }
            case 7775: {
                return "r\u0331";
            }
            case 7776: {
                return "S\u0307";
            }
            case 7777: {
                return "s\u0307";
            }
            case 7778: {
                return "S\u0323";
            }
            case 7779: {
                return "s\u0323";
            }
            case 7780: {
                return "\u015a\u0307";
            }
            case 7781: {
                return "\u015b\u0307";
            }
            case 7782: {
                return "\u0160\u0307";
            }
            case 7783: {
                return "\u0161\u0307";
            }
            case 7784: {
                return "\u1e62\u0307";
            }
            case 7785: {
                return "\u1e63\u0307";
            }
            case 7786: {
                return "T\u0307";
            }
            case 7787: {
                return "t\u0307";
            }
            case 7788: {
                return "T\u0323";
            }
            case 7789: {
                return "t\u0323";
            }
            case 7790: {
                return "T\u0331";
            }
            case 7791: {
                return "t\u0331";
            }
            case 7792: {
                return "T\u032d";
            }
            case 7793: {
                return "t\u032d";
            }
            case 7794: {
                return "U\u0324";
            }
            case 7795: {
                return "u\u0324";
            }
            case 7796: {
                return "U\u0330";
            }
            case 7797: {
                return "u\u0330";
            }
            case 7798: {
                return "U\u032d";
            }
            case 7799: {
                return "u\u032d";
            }
            case 7800: {
                return "\u0168\u0301";
            }
            case 7801: {
                return "\u0169\u0301";
            }
            case 7802: {
                return "\u016a\u0308";
            }
            case 7803: {
                return "\u016b\u0308";
            }
            case 7804: {
                return "V\u0303";
            }
            case 7805: {
                return "v\u0303";
            }
            case 7806: {
                return "V\u0323";
            }
            case 7807: {
                return "v\u0323";
            }
            case 7808: {
                return "W\u0300";
            }
            case 7809: {
                return "w\u0300";
            }
            case 7810: {
                return "W\u0301";
            }
            case 7811: {
                return "w\u0301";
            }
            case 7812: {
                return "W\u0308";
            }
            case 7813: {
                return "w\u0308";
            }
            case 7814: {
                return "W\u0307";
            }
            case 7815: {
                return "w\u0307";
            }
            case 7816: {
                return "W\u0323";
            }
            case 7817: {
                return "w\u0323";
            }
            case 7818: {
                return "X\u0307";
            }
            case 7819: {
                return "x\u0307";
            }
            case 7820: {
                return "X\u0308";
            }
            case 7821: {
                return "x\u0308";
            }
            case 7822: {
                return "Y\u0307";
            }
            case 7823: {
                return "y\u0307";
            }
            case 7824: {
                return "Z\u0302";
            }
            case 7825: {
                return "z\u0302";
            }
            case 7826: {
                return "Z\u0323";
            }
            case 7827: {
                return "z\u0323";
            }
            case 7828: {
                return "Z\u0331";
            }
            case 7829: {
                return "z\u0331";
            }
            case 7830: {
                return "h\u0331";
            }
            case 7831: {
                return "t\u0308";
            }
            case 7832: {
                return "w\u030a";
            }
            case 7833: {
                return "y\u030a";
            }
            case 7835: {
                return "\u017f\u0307";
            }
            case 7840: {
                return "A\u0323";
            }
            case 7841: {
                return "a\u0323";
            }
            case 7842: {
                return "A\u0309";
            }
            case 7843: {
                return "a\u0309";
            }
            case 7844: {
                return "\u00c2\u0301";
            }
            case 7845: {
                return "\u00e2\u0301";
            }
            case 7846: {
                return "\u00c2\u0300";
            }
            case 7847: {
                return "\u00e2\u0300";
            }
            case 7848: {
                return "\u00c2\u0309";
            }
            case 7849: {
                return "\u00e2\u0309";
            }
            case 7850: {
                return "\u00c2\u0303";
            }
            case 7851: {
                return "\u00e2\u0303";
            }
            case 7852: {
                return "\u1ea0\u0302";
            }
            case 7853: {
                return "\u1ea1\u0302";
            }
            case 7854: {
                return "\u0102\u0301";
            }
            case 7855: {
                return "\u0103\u0301";
            }
            case 7856: {
                return "\u0102\u0300";
            }
            case 7857: {
                return "\u0103\u0300";
            }
            case 7858: {
                return "\u0102\u0309";
            }
            case 7859: {
                return "\u0103\u0309";
            }
            case 7860: {
                return "\u0102\u0303";
            }
            case 7861: {
                return "\u0103\u0303";
            }
            case 7862: {
                return "\u1ea0\u0306";
            }
            case 7863: {
                return "\u1ea1\u0306";
            }
            case 7864: {
                return "E\u0323";
            }
            case 7865: {
                return "e\u0323";
            }
            case 7866: {
                return "E\u0309";
            }
            case 7867: {
                return "e\u0309";
            }
            case 7868: {
                return "E\u0303";
            }
            case 7869: {
                return "e\u0303";
            }
            case 7870: {
                return "\u00ca\u0301";
            }
            case 7871: {
                return "\u00ea\u0301";
            }
            case 7872: {
                return "\u00ca\u0300";
            }
            case 7873: {
                return "\u00ea\u0300";
            }
            case 7874: {
                return "\u00ca\u0309";
            }
            case 7875: {
                return "\u00ea\u0309";
            }
            case 7876: {
                return "\u00ca\u0303";
            }
            case 7877: {
                return "\u00ea\u0303";
            }
            case 7878: {
                return "\u1eb8\u0302";
            }
            case 7879: {
                return "\u1eb9\u0302";
            }
            case 7880: {
                return "I\u0309";
            }
            case 7881: {
                return "i\u0309";
            }
            case 7882: {
                return "I\u0323";
            }
            case 7883: {
                return "i\u0323";
            }
            case 7884: {
                return "O\u0323";
            }
            case 7885: {
                return "o\u0323";
            }
            case 7886: {
                return "O\u0309";
            }
            case 7887: {
                return "o\u0309";
            }
            case 7888: {
                return "\u00d4\u0301";
            }
            case 7889: {
                return "\u00f4\u0301";
            }
            case 7890: {
                return "\u00d4\u0300";
            }
            case 7891: {
                return "\u00f4\u0300";
            }
            case 7892: {
                return "\u00d4\u0309";
            }
            case 7893: {
                return "\u00f4\u0309";
            }
            case 7894: {
                return "\u00d4\u0303";
            }
            case 7895: {
                return "\u00f4\u0303";
            }
            case 7896: {
                return "\u1ecc\u0302";
            }
            case 7897: {
                return "\u1ecd\u0302";
            }
            case 7898: {
                return "\u01a0\u0301";
            }
            case 7899: {
                return "\u01a1\u0301";
            }
            case 7900: {
                return "\u01a0\u0300";
            }
            case 7901: {
                return "\u01a1\u0300";
            }
            case 7902: {
                return "\u01a0\u0309";
            }
            case 7903: {
                return "\u01a1\u0309";
            }
            case 7904: {
                return "\u01a0\u0303";
            }
            case 7905: {
                return "\u01a1\u0303";
            }
            case 7906: {
                return "\u01a0\u0323";
            }
            case 7907: {
                return "\u01a1\u0323";
            }
            case 7908: {
                return "U\u0323";
            }
            case 7909: {
                return "u\u0323";
            }
            case 7910: {
                return "U\u0309";
            }
            case 7911: {
                return "u\u0309";
            }
            case 7912: {
                return "\u01af\u0301";
            }
            case 7913: {
                return "\u01b0\u0301";
            }
            case 7914: {
                return "\u01af\u0300";
            }
            case 7915: {
                return "\u01b0\u0300";
            }
            case 7916: {
                return "\u01af\u0309";
            }
            case 7917: {
                return "\u01b0\u0309";
            }
            case 7918: {
                return "\u01af\u0303";
            }
            case 7919: {
                return "\u01b0\u0303";
            }
            case 7920: {
                return "\u01af\u0323";
            }
            case 7921: {
                return "\u01b0\u0323";
            }
            case 7922: {
                return "Y\u0300";
            }
            case 7923: {
                return "y\u0300";
            }
            case 7924: {
                return "Y\u0323";
            }
            case 7925: {
                return "y\u0323";
            }
            case 7926: {
                return "Y\u0309";
            }
            case 7927: {
                return "y\u0309";
            }
            case 7928: {
                return "Y\u0303";
            }
            case 7929: {
                return "y\u0303";
            }
            case 7936: {
                return "\u03b1\u0313";
            }
            case 7937: {
                return "\u03b1\u0314";
            }
            case 7938: {
                return "\u1f00\u0300";
            }
            case 7939: {
                return "\u1f01\u0300";
            }
            case 7940: {
                return "\u1f00\u0301";
            }
            case 7941: {
                return "\u1f01\u0301";
            }
            case 7942: {
                return "\u1f00\u0342";
            }
            case 7943: {
                return "\u1f01\u0342";
            }
            case 7944: {
                return "\u0391\u0313";
            }
            case 7945: {
                return "\u0391\u0314";
            }
            case 7946: {
                return "\u1f08\u0300";
            }
            case 7947: {
                return "\u1f09\u0300";
            }
            case 7948: {
                return "\u1f08\u0301";
            }
            case 7949: {
                return "\u1f09\u0301";
            }
            case 7950: {
                return "\u1f08\u0342";
            }
            case 7951: {
                return "\u1f09\u0342";
            }
            case 7952: {
                return "\u03b5\u0313";
            }
            case 7953: {
                return "\u03b5\u0314";
            }
            case 7954: {
                return "\u1f10\u0300";
            }
            case 7955: {
                return "\u1f11\u0300";
            }
            case 7956: {
                return "\u1f10\u0301";
            }
            case 7957: {
                return "\u1f11\u0301";
            }
            case 7960: {
                return "\u0395\u0313";
            }
            case 7961: {
                return "\u0395\u0314";
            }
            case 7962: {
                return "\u1f18\u0300";
            }
            case 7963: {
                return "\u1f19\u0300";
            }
            case 7964: {
                return "\u1f18\u0301";
            }
            case 7965: {
                return "\u1f19\u0301";
            }
            case 7968: {
                return "\u03b7\u0313";
            }
            case 7969: {
                return "\u03b7\u0314";
            }
            case 7970: {
                return "\u1f20\u0300";
            }
            case 7971: {
                return "\u1f21\u0300";
            }
            case 7972: {
                return "\u1f20\u0301";
            }
            case 7973: {
                return "\u1f21\u0301";
            }
            case 7974: {
                return "\u1f20\u0342";
            }
            case 7975: {
                return "\u1f21\u0342";
            }
            case 7976: {
                return "\u0397\u0313";
            }
            case 7977: {
                return "\u0397\u0314";
            }
            case 7978: {
                return "\u1f28\u0300";
            }
            case 7979: {
                return "\u1f29\u0300";
            }
            case 7980: {
                return "\u1f28\u0301";
            }
            case 7981: {
                return "\u1f29\u0301";
            }
            case 7982: {
                return "\u1f28\u0342";
            }
            case 7983: {
                return "\u1f29\u0342";
            }
            case 7984: {
                return "\u03b9\u0313";
            }
            case 7985: {
                return "\u03b9\u0314";
            }
            case 7986: {
                return "\u1f30\u0300";
            }
            case 7987: {
                return "\u1f31\u0300";
            }
            case 7988: {
                return "\u1f30\u0301";
            }
            case 7989: {
                return "\u1f31\u0301";
            }
            case 7990: {
                return "\u1f30\u0342";
            }
            case 7991: {
                return "\u1f31\u0342";
            }
            case 7992: {
                return "\u0399\u0313";
            }
            case 7993: {
                return "\u0399\u0314";
            }
            case 7994: {
                return "\u1f38\u0300";
            }
            case 7995: {
                return "\u1f39\u0300";
            }
            case 7996: {
                return "\u1f38\u0301";
            }
            case 7997: {
                return "\u1f39\u0301";
            }
            case 7998: {
                return "\u1f38\u0342";
            }
            case 7999: {
                return "\u1f39\u0342";
            }
            case 8000: {
                return "\u03bf\u0313";
            }
            case 8001: {
                return "\u03bf\u0314";
            }
            case 8002: {
                return "\u1f40\u0300";
            }
            case 8003: {
                return "\u1f41\u0300";
            }
            case 8004: {
                return "\u1f40\u0301";
            }
            case 8005: {
                return "\u1f41\u0301";
            }
            case 8008: {
                return "\u039f\u0313";
            }
            case 8009: {
                return "\u039f\u0314";
            }
            case 8010: {
                return "\u1f48\u0300";
            }
            case 8011: {
                return "\u1f49\u0300";
            }
            case 8012: {
                return "\u1f48\u0301";
            }
            case 8013: {
                return "\u1f49\u0301";
            }
            case 8016: {
                return "\u03c5\u0313";
            }
            case 8017: {
                return "\u03c5\u0314";
            }
            case 8018: {
                return "\u1f50\u0300";
            }
            case 8019: {
                return "\u1f51\u0300";
            }
            case 8020: {
                return "\u1f50\u0301";
            }
            case 8021: {
                return "\u1f51\u0301";
            }
            case 8022: {
                return "\u1f50\u0342";
            }
            case 8023: {
                return "\u1f51\u0342";
            }
            case 8025: {
                return "\u03a5\u0314";
            }
            case 8027: {
                return "\u1f59\u0300";
            }
            case 8029: {
                return "\u1f59\u0301";
            }
            case 8031: {
                return "\u1f59\u0342";
            }
            case 8032: {
                return "\u03c9\u0313";
            }
            case 8033: {
                return "\u03c9\u0314";
            }
            case 8034: {
                return "\u1f60\u0300";
            }
            case 8035: {
                return "\u1f61\u0300";
            }
            case 8036: {
                return "\u1f60\u0301";
            }
            case 8037: {
                return "\u1f61\u0301";
            }
            case 8038: {
                return "\u1f60\u0342";
            }
            case 8039: {
                return "\u1f61\u0342";
            }
            case 8040: {
                return "\u03a9\u0313";
            }
            case 8041: {
                return "\u03a9\u0314";
            }
            case 8042: {
                return "\u1f68\u0300";
            }
            case 8043: {
                return "\u1f69\u0300";
            }
            case 8044: {
                return "\u1f68\u0301";
            }
            case 8045: {
                return "\u1f69\u0301";
            }
            case 8046: {
                return "\u1f68\u0342";
            }
            case 8047: {
                return "\u1f69\u0342";
            }
            case 8048: {
                return "\u03b1\u0300";
            }
            case 8049: {
                return "\u03ac";
            }
            case 8050: {
                return "\u03b5\u0300";
            }
            case 8051: {
                return "\u03ad";
            }
            case 8052: {
                return "\u03b7\u0300";
            }
            case 8053: {
                return "\u03ae";
            }
            case 8054: {
                return "\u03b9\u0300";
            }
            case 8055: {
                return "\u03af";
            }
            case 8056: {
                return "\u03bf\u0300";
            }
            case 8057: {
                return "\u03cc";
            }
            case 8058: {
                return "\u03c5\u0300";
            }
            case 8059: {
                return "\u03cd";
            }
            case 8060: {
                return "\u03c9\u0300";
            }
            case 8061: {
                return "\u03ce";
            }
            case 8064: {
                return "\u1f00\u0345";
            }
            case 8065: {
                return "\u1f01\u0345";
            }
            case 8066: {
                return "\u1f02\u0345";
            }
            case 8067: {
                return "\u1f03\u0345";
            }
            case 8068: {
                return "\u1f04\u0345";
            }
            case 8069: {
                return "\u1f05\u0345";
            }
            case 8070: {
                return "\u1f06\u0345";
            }
            case 8071: {
                return "\u1f07\u0345";
            }
            case 8072: {
                return "\u1f08\u0345";
            }
            case 8073: {
                return "\u1f09\u0345";
            }
            case 8074: {
                return "\u1f0a\u0345";
            }
            case 8075: {
                return "\u1f0b\u0345";
            }
            case 8076: {
                return "\u1f0c\u0345";
            }
            case 8077: {
                return "\u1f0d\u0345";
            }
            case 8078: {
                return "\u1f0e\u0345";
            }
            case 8079: {
                return "\u1f0f\u0345";
            }
            case 8080: {
                return "\u1f20\u0345";
            }
            case 8081: {
                return "\u1f21\u0345";
            }
            case 8082: {
                return "\u1f22\u0345";
            }
            case 8083: {
                return "\u1f23\u0345";
            }
            case 8084: {
                return "\u1f24\u0345";
            }
            case 8085: {
                return "\u1f25\u0345";
            }
            case 8086: {
                return "\u1f26\u0345";
            }
            case 8087: {
                return "\u1f27\u0345";
            }
            case 8088: {
                return "\u1f28\u0345";
            }
            case 8089: {
                return "\u1f29\u0345";
            }
            case 8090: {
                return "\u1f2a\u0345";
            }
            case 8091: {
                return "\u1f2b\u0345";
            }
            case 8092: {
                return "\u1f2c\u0345";
            }
            case 8093: {
                return "\u1f2d\u0345";
            }
            case 8094: {
                return "\u1f2e\u0345";
            }
            case 8095: {
                return "\u1f2f\u0345";
            }
            case 8096: {
                return "\u1f60\u0345";
            }
            case 8097: {
                return "\u1f61\u0345";
            }
            case 8098: {
                return "\u1f62\u0345";
            }
            case 8099: {
                return "\u1f63\u0345";
            }
            case 8100: {
                return "\u1f64\u0345";
            }
            case 8101: {
                return "\u1f65\u0345";
            }
            case 8102: {
                return "\u1f66\u0345";
            }
            case 8103: {
                return "\u1f67\u0345";
            }
            case 8104: {
                return "\u1f68\u0345";
            }
            case 8105: {
                return "\u1f69\u0345";
            }
            case 8106: {
                return "\u1f6a\u0345";
            }
            case 8107: {
                return "\u1f6b\u0345";
            }
            case 8108: {
                return "\u1f6c\u0345";
            }
            case 8109: {
                return "\u1f6d\u0345";
            }
            case 8110: {
                return "\u1f6e\u0345";
            }
            case 8111: {
                return "\u1f6f\u0345";
            }
            case 8112: {
                return "\u03b1\u0306";
            }
            case 8113: {
                return "\u03b1\u0304";
            }
            case 8114: {
                return "\u1f70\u0345";
            }
            case 8115: {
                return "\u03b1\u0345";
            }
            case 8116: {
                return "\u03ac\u0345";
            }
            case 8118: {
                return "\u03b1\u0342";
            }
            case 8119: {
                return "\u1fb6\u0345";
            }
            case 8120: {
                return "\u0391\u0306";
            }
            case 8121: {
                return "\u0391\u0304";
            }
            case 8122: {
                return "\u0391\u0300";
            }
            case 8123: {
                return "\u0386";
            }
            case 8124: {
                return "\u0391\u0345";
            }
            case 8126: {
                return "\u03b9";
            }
            case 8129: {
                return "\u00a8\u0342";
            }
            case 8130: {
                return "\u1f74\u0345";
            }
            case 8131: {
                return "\u03b7\u0345";
            }
            case 8132: {
                return "\u03ae\u0345";
            }
            case 8134: {
                return "\u03b7\u0342";
            }
            case 8135: {
                return "\u1fc6\u0345";
            }
            case 8136: {
                return "\u0395\u0300";
            }
            case 8137: {
                return "\u0388";
            }
            case 8138: {
                return "\u0397\u0300";
            }
            case 8139: {
                return "\u0389";
            }
            case 8140: {
                return "\u0397\u0345";
            }
            case 8141: {
                return "\u1fbf\u0300";
            }
            case 8142: {
                return "\u1fbf\u0301";
            }
            case 8143: {
                return "\u1fbf\u0342";
            }
            case 8144: {
                return "\u03b9\u0306";
            }
            case 8145: {
                return "\u03b9\u0304";
            }
            case 8146: {
                return "\u03ca\u0300";
            }
            case 8147: {
                return "\u0390";
            }
            case 8150: {
                return "\u03b9\u0342";
            }
            case 8151: {
                return "\u03ca\u0342";
            }
            case 8152: {
                return "\u0399\u0306";
            }
            case 8153: {
                return "\u0399\u0304";
            }
            case 8154: {
                return "\u0399\u0300";
            }
            case 8155: {
                return "\u038a";
            }
            case 8157: {
                return "\u1ffe\u0300";
            }
            case 8158: {
                return "\u1ffe\u0301";
            }
            case 8159: {
                return "\u1ffe\u0342";
            }
            case 8160: {
                return "\u03c5\u0306";
            }
            case 8161: {
                return "\u03c5\u0304";
            }
            case 8162: {
                return "\u03cb\u0300";
            }
            case 8163: {
                return "\u03b0";
            }
            case 8164: {
                return "\u03c1\u0313";
            }
            case 8165: {
                return "\u03c1\u0314";
            }
            case 8166: {
                return "\u03c5\u0342";
            }
            case 8167: {
                return "\u03cb\u0342";
            }
            case 8168: {
                return "\u03a5\u0306";
            }
            case 8169: {
                return "\u03a5\u0304";
            }
            case 8170: {
                return "\u03a5\u0300";
            }
            case 8171: {
                return "\u038e";
            }
            case 8172: {
                return "\u03a1\u0314";
            }
            case 8173: {
                return "\u00a8\u0300";
            }
            case 8174: {
                return "\u0385";
            }
            case 8175: {
                return "`";
            }
            case 8178: {
                return "\u1f7c\u0345";
            }
            case 8179: {
                return "\u03c9\u0345";
            }
            case 8180: {
                return "\u03ce\u0345";
            }
            case 8182: {
                return "\u03c9\u0342";
            }
            case 8183: {
                return "\u1ff6\u0345";
            }
            case 8184: {
                return "\u039f\u0300";
            }
            case 8185: {
                return "\u038c";
            }
            case 8186: {
                return "\u03a9\u0300";
            }
            case 8187: {
                return "\u038f";
            }
            case 8188: {
                return "\u03a9\u0345";
            }
            case 8189: {
                return "\u00b4";
            }
            case 8192: {
                return "\u2002";
            }
            case 8193: {
                return "\u2003";
            }
            case 8486: {
                return "\u03a9";
            }
            case 8490: {
                return "K";
            }
            case 8491: {
                return "\u00c5";
            }
            case 8602: {
                return "\u2190\u0338";
            }
            case 8603: {
                return "\u2192\u0338";
            }
            case 8622: {
                return "\u2194\u0338";
            }
            case 8653: {
                return "\u21d0\u0338";
            }
            case 8654: {
                return "\u21d4\u0338";
            }
            case 8655: {
                return "\u21d2\u0338";
            }
            case 8708: {
                return "\u2203\u0338";
            }
            case 8713: {
                return "\u2208\u0338";
            }
            case 8716: {
                return "\u220b\u0338";
            }
            case 8740: {
                return "\u2223\u0338";
            }
            case 8742: {
                return "\u2225\u0338";
            }
            case 8769: {
                return "\u223c\u0338";
            }
            case 8772: {
                return "\u2243\u0338";
            }
            case 8775: {
                return "\u2245\u0338";
            }
            case 8777: {
                return "\u2248\u0338";
            }
            case 8800: {
                return "=\u0338";
            }
            case 8802: {
                return "\u2261\u0338";
            }
            case 8813: {
                return "\u224d\u0338";
            }
            case 8814: {
                return "<\u0338";
            }
            case 8815: {
                return ">\u0338";
            }
            case 8816: {
                return "\u2264\u0338";
            }
            case 8817: {
                return "\u2265\u0338";
            }
            case 8820: {
                return "\u2272\u0338";
            }
            case 8821: {
                return "\u2273\u0338";
            }
            case 8824: {
                return "\u2276\u0338";
            }
            case 8825: {
                return "\u2277\u0338";
            }
            case 8832: {
                return "\u227a\u0338";
            }
            case 8833: {
                return "\u227b\u0338";
            }
            case 8836: {
                return "\u2282\u0338";
            }
            case 8837: {
                return "\u2283\u0338";
            }
            case 8840: {
                return "\u2286\u0338";
            }
            case 8841: {
                return "\u2287\u0338";
            }
            case 8876: {
                return "\u22a2\u0338";
            }
            case 8877: {
                return "\u22a8\u0338";
            }
            case 8878: {
                return "\u22a9\u0338";
            }
            case 8879: {
                return "\u22ab\u0338";
            }
            case 8928: {
                return "\u227c\u0338";
            }
            case 8929: {
                return "\u227d\u0338";
            }
            case 8930: {
                return "\u2291\u0338";
            }
            case 8931: {
                return "\u2292\u0338";
            }
            case 8938: {
                return "\u22b2\u0338";
            }
            case 8939: {
                return "\u22b3\u0338";
            }
            case 8940: {
                return "\u22b4\u0338";
            }
            case 8941: {
                return "\u22b5\u0338";
            }
            case 9001: {
                return "\u3008";
            }
            case 9002: {
                return "\u3009";
            }
            case 10972: {
                return "\u2add\u0338";
            }
            case 12364: {
                return "\u304b\u3099";
            }
            case 12366: {
                return "\u304d\u3099";
            }
            case 12368: {
                return "\u304f\u3099";
            }
            case 12370: {
                return "\u3051\u3099";
            }
            case 12372: {
                return "\u3053\u3099";
            }
            case 12374: {
                return "\u3055\u3099";
            }
            case 12376: {
                return "\u3057\u3099";
            }
            case 12378: {
                return "\u3059\u3099";
            }
            case 12380: {
                return "\u305b\u3099";
            }
            case 12382: {
                return "\u305d\u3099";
            }
            case 12384: {
                return "\u305f\u3099";
            }
            case 12386: {
                return "\u3061\u3099";
            }
            case 12389: {
                return "\u3064\u3099";
            }
            case 12391: {
                return "\u3066\u3099";
            }
            case 12393: {
                return "\u3068\u3099";
            }
            case 12400: {
                return "\u306f\u3099";
            }
            case 12401: {
                return "\u306f\u309a";
            }
            case 12403: {
                return "\u3072\u3099";
            }
            case 12404: {
                return "\u3072\u309a";
            }
            case 12406: {
                return "\u3075\u3099";
            }
            case 12407: {
                return "\u3075\u309a";
            }
            case 12409: {
                return "\u3078\u3099";
            }
            case 12410: {
                return "\u3078\u309a";
            }
            case 12412: {
                return "\u307b\u3099";
            }
            case 12413: {
                return "\u307b\u309a";
            }
            case 12436: {
                return "\u3046\u3099";
            }
            case 12446: {
                return "\u309d\u3099";
            }
            case 12460: {
                return "\u30ab\u3099";
            }
            case 12462: {
                return "\u30ad\u3099";
            }
            case 12464: {
                return "\u30af\u3099";
            }
            case 12466: {
                return "\u30b1\u3099";
            }
            case 12468: {
                return "\u30b3\u3099";
            }
            case 12470: {
                return "\u30b5\u3099";
            }
            case 12472: {
                return "\u30b7\u3099";
            }
            case 12474: {
                return "\u30b9\u3099";
            }
            case 12476: {
                return "\u30bb\u3099";
            }
            case 12478: {
                return "\u30bd\u3099";
            }
            case 12480: {
                return "\u30bf\u3099";
            }
            case 12482: {
                return "\u30c1\u3099";
            }
            case 12485: {
                return "\u30c4\u3099";
            }
            case 12487: {
                return "\u30c6\u3099";
            }
            case 12489: {
                return "\u30c8\u3099";
            }
            case 12496: {
                return "\u30cf\u3099";
            }
            case 12497: {
                return "\u30cf\u309a";
            }
            case 12499: {
                return "\u30d2\u3099";
            }
            case 12500: {
                return "\u30d2\u309a";
            }
            case 12502: {
                return "\u30d5\u3099";
            }
            case 12503: {
                return "\u30d5\u309a";
            }
            case 12505: {
                return "\u30d8\u3099";
            }
            case 12506: {
                return "\u30d8\u309a";
            }
            case 12508: {
                return "\u30db\u3099";
            }
            case 12509: {
                return "\u30db\u309a";
            }
            case 12532: {
                return "\u30a6\u3099";
            }
            case 12535: {
                return "\u30ef\u3099";
            }
            case 12536: {
                return "\u30f0\u3099";
            }
            case 12537: {
                return "\u30f1\u3099";
            }
            case 12538: {
                return "\u30f2\u3099";
            }
            case 12542: {
                return "\u30fd\u3099";
            }
            case 63744: {
                return "\u8c48";
            }
            case 63745: {
                return "\u66f4";
            }
            case 63746: {
                return "\u8eca";
            }
            case 63747: {
                return "\u8cc8";
            }
            case 63748: {
                return "\u6ed1";
            }
            case 63749: {
                return "\u4e32";
            }
            case 63750: {
                return "\u53e5";
            }
            case 63751: {
                return "\u9f9c";
            }
            case 63752: {
                return "\u9f9c";
            }
            case 63753: {
                return "\u5951";
            }
            case 63754: {
                return "\u91d1";
            }
            case 63755: {
                return "\u5587";
            }
            case 63756: {
                return "\u5948";
            }
            case 63757: {
                return "\u61f6";
            }
            case 63758: {
                return "\u7669";
            }
            case 63759: {
                return "\u7f85";
            }
            case 63760: {
                return "\u863f";
            }
            case 63761: {
                return "\u87ba";
            }
            case 63762: {
                return "\u88f8";
            }
            case 63763: {
                return "\u908f";
            }
            case 63764: {
                return "\u6a02";
            }
            case 63765: {
                return "\u6d1b";
            }
            case 63766: {
                return "\u70d9";
            }
            case 63767: {
                return "\u73de";
            }
            case 63768: {
                return "\u843d";
            }
            case 63769: {
                return "\u916a";
            }
            case 63770: {
                return "\u99f1";
            }
            case 63771: {
                return "\u4e82";
            }
            case 63772: {
                return "\u5375";
            }
            case 63773: {
                return "\u6b04";
            }
            case 63774: {
                return "\u721b";
            }
            case 63775: {
                return "\u862d";
            }
            case 63776: {
                return "\u9e1e";
            }
            case 63777: {
                return "\u5d50";
            }
            case 63778: {
                return "\u6feb";
            }
            case 63779: {
                return "\u85cd";
            }
            case 63780: {
                return "\u8964";
            }
            case 63781: {
                return "\u62c9";
            }
            case 63782: {
                return "\u81d8";
            }
            case 63783: {
                return "\u881f";
            }
            case 63784: {
                return "\u5eca";
            }
            case 63785: {
                return "\u6717";
            }
            case 63786: {
                return "\u6d6a";
            }
            case 63787: {
                return "\u72fc";
            }
            case 63788: {
                return "\u90ce";
            }
            case 63789: {
                return "\u4f86";
            }
            case 63790: {
                return "\u51b7";
            }
            case 63791: {
                return "\u52de";
            }
            case 63792: {
                return "\u64c4";
            }
            case 63793: {
                return "\u6ad3";
            }
            case 63794: {
                return "\u7210";
            }
            case 63795: {
                return "\u76e7";
            }
            case 63796: {
                return "\u8001";
            }
            case 63797: {
                return "\u8606";
            }
            case 63798: {
                return "\u865c";
            }
            case 63799: {
                return "\u8def";
            }
            case 63800: {
                return "\u9732";
            }
            case 63801: {
                return "\u9b6f";
            }
            case 63802: {
                return "\u9dfa";
            }
            case 63803: {
                return "\u788c";
            }
            case 63804: {
                return "\u797f";
            }
            case 63805: {
                return "\u7da0";
            }
            case 63806: {
                return "\u83c9";
            }
            case 63807: {
                return "\u9304";
            }
            case 63808: {
                return "\u9e7f";
            }
            case 63809: {
                return "\u8ad6";
            }
            case 63810: {
                return "\u58df";
            }
            case 63811: {
                return "\u5f04";
            }
            case 63812: {
                return "\u7c60";
            }
            case 63813: {
                return "\u807e";
            }
            case 63814: {
                return "\u7262";
            }
            case 63815: {
                return "\u78ca";
            }
            case 63816: {
                return "\u8cc2";
            }
            case 63817: {
                return "\u96f7";
            }
            case 63818: {
                return "\u58d8";
            }
            case 63819: {
                return "\u5c62";
            }
            case 63820: {
                return "\u6a13";
            }
            case 63821: {
                return "\u6dda";
            }
            case 63822: {
                return "\u6f0f";
            }
            case 63823: {
                return "\u7d2f";
            }
            case 63824: {
                return "\u7e37";
            }
            case 63825: {
                return "\u964b";
            }
            case 63826: {
                return "\u52d2";
            }
            case 63827: {
                return "\u808b";
            }
            case 63828: {
                return "\u51dc";
            }
            case 63829: {
                return "\u51cc";
            }
            case 63830: {
                return "\u7a1c";
            }
            case 63831: {
                return "\u7dbe";
            }
            case 63832: {
                return "\u83f1";
            }
            case 63833: {
                return "\u9675";
            }
            case 63834: {
                return "\u8b80";
            }
            case 63835: {
                return "\u62cf";
            }
            case 63836: {
                return "\u6a02";
            }
            case 63837: {
                return "\u8afe";
            }
            case 63838: {
                return "\u4e39";
            }
            case 63839: {
                return "\u5be7";
            }
            case 63840: {
                return "\u6012";
            }
            case 63841: {
                return "\u7387";
            }
            case 63842: {
                return "\u7570";
            }
            case 63843: {
                return "\u5317";
            }
            case 63844: {
                return "\u78fb";
            }
            case 63845: {
                return "\u4fbf";
            }
            case 63846: {
                return "\u5fa9";
            }
            case 63847: {
                return "\u4e0d";
            }
            case 63848: {
                return "\u6ccc";
            }
            case 63849: {
                return "\u6578";
            }
            case 63850: {
                return "\u7d22";
            }
            case 63851: {
                return "\u53c3";
            }
            case 63852: {
                return "\u585e";
            }
            case 63853: {
                return "\u7701";
            }
            case 63854: {
                return "\u8449";
            }
            case 63855: {
                return "\u8aaa";
            }
            case 63856: {
                return "\u6bba";
            }
            case 63857: {
                return "\u8fb0";
            }
            case 63858: {
                return "\u6c88";
            }
            case 63859: {
                return "\u62fe";
            }
            case 63860: {
                return "\u82e5";
            }
            case 63861: {
                return "\u63a0";
            }
            case 63862: {
                return "\u7565";
            }
            case 63863: {
                return "\u4eae";
            }
            case 63864: {
                return "\u5169";
            }
            case 63865: {
                return "\u51c9";
            }
            case 63866: {
                return "\u6881";
            }
            case 63867: {
                return "\u7ce7";
            }
            case 63868: {
                return "\u826f";
            }
            case 63869: {
                return "\u8ad2";
            }
            case 63870: {
                return "\u91cf";
            }
            case 63871: {
                return "\u52f5";
            }
            case 63872: {
                return "\u5442";
            }
            case 63873: {
                return "\u5973";
            }
            case 63874: {
                return "\u5eec";
            }
            case 63875: {
                return "\u65c5";
            }
            case 63876: {
                return "\u6ffe";
            }
            case 63877: {
                return "\u792a";
            }
            case 63878: {
                return "\u95ad";
            }
            case 63879: {
                return "\u9a6a";
            }
            case 63880: {
                return "\u9e97";
            }
            case 63881: {
                return "\u9ece";
            }
            case 63882: {
                return "\u529b";
            }
            case 63883: {
                return "\u66c6";
            }
            case 63884: {
                return "\u6b77";
            }
            case 63885: {
                return "\u8f62";
            }
            case 63886: {
                return "\u5e74";
            }
            case 63887: {
                return "\u6190";
            }
            case 63888: {
                return "\u6200";
            }
            case 63889: {
                return "\u649a";
            }
            case 63890: {
                return "\u6f23";
            }
            case 63891: {
                return "\u7149";
            }
            case 63892: {
                return "\u7489";
            }
            case 63893: {
                return "\u79ca";
            }
            case 63894: {
                return "\u7df4";
            }
            case 63895: {
                return "\u806f";
            }
            case 63896: {
                return "\u8f26";
            }
            case 63897: {
                return "\u84ee";
            }
            case 63898: {
                return "\u9023";
            }
            case 63899: {
                return "\u934a";
            }
            case 63900: {
                return "\u5217";
            }
            case 63901: {
                return "\u52a3";
            }
            case 63902: {
                return "\u54bd";
            }
            case 63903: {
                return "\u70c8";
            }
            case 63904: {
                return "\u88c2";
            }
            case 63905: {
                return "\u8aaa";
            }
            case 63906: {
                return "\u5ec9";
            }
            case 63907: {
                return "\u5ff5";
            }
            case 63908: {
                return "\u637b";
            }
            case 63909: {
                return "\u6bae";
            }
            case 63910: {
                return "\u7c3e";
            }
            case 63911: {
                return "\u7375";
            }
            case 63912: {
                return "\u4ee4";
            }
            case 63913: {
                return "\u56f9";
            }
            case 63914: {
                return "\u5be7";
            }
            case 63915: {
                return "\u5dba";
            }
            case 63916: {
                return "\u601c";
            }
            case 63917: {
                return "\u73b2";
            }
            case 63918: {
                return "\u7469";
            }
            case 63919: {
                return "\u7f9a";
            }
            case 63920: {
                return "\u8046";
            }
            case 63921: {
                return "\u9234";
            }
            case 63922: {
                return "\u96f6";
            }
            case 63923: {
                return "\u9748";
            }
            case 63924: {
                return "\u9818";
            }
            case 63925: {
                return "\u4f8b";
            }
            case 63926: {
                return "\u79ae";
            }
            case 63927: {
                return "\u91b4";
            }
            case 63928: {
                return "\u96b8";
            }
            case 63929: {
                return "\u60e1";
            }
            case 63930: {
                return "\u4e86";
            }
            case 63931: {
                return "\u50da";
            }
            case 63932: {
                return "\u5bee";
            }
            case 63933: {
                return "\u5c3f";
            }
            case 63934: {
                return "\u6599";
            }
            case 63935: {
                return "\u6a02";
            }
            case 63936: {
                return "\u71ce";
            }
            case 63937: {
                return "\u7642";
            }
            case 63938: {
                return "\u84fc";
            }
            case 63939: {
                return "\u907c";
            }
            case 63940: {
                return "\u9f8d";
            }
            case 63941: {
                return "\u6688";
            }
            case 63942: {
                return "\u962e";
            }
            case 63943: {
                return "\u5289";
            }
            case 63944: {
                return "\u677b";
            }
            case 63945: {
                return "\u67f3";
            }
            case 63946: {
                return "\u6d41";
            }
            case 63947: {
                return "\u6e9c";
            }
            case 63948: {
                return "\u7409";
            }
            case 63949: {
                return "\u7559";
            }
            case 63950: {
                return "\u786b";
            }
            case 63951: {
                return "\u7d10";
            }
            case 63952: {
                return "\u985e";
            }
            case 63953: {
                return "\u516d";
            }
            case 63954: {
                return "\u622e";
            }
            case 63955: {
                return "\u9678";
            }
            case 63956: {
                return "\u502b";
            }
            case 63957: {
                return "\u5d19";
            }
            case 63958: {
                return "\u6dea";
            }
            case 63959: {
                return "\u8f2a";
            }
            case 63960: {
                return "\u5f8b";
            }
            case 63961: {
                return "\u6144";
            }
            case 63962: {
                return "\u6817";
            }
            case 63963: {
                return "\u7387";
            }
            case 63964: {
                return "\u9686";
            }
            case 63965: {
                return "\u5229";
            }
            case 63966: {
                return "\u540f";
            }
            case 63967: {
                return "\u5c65";
            }
            case 63968: {
                return "\u6613";
            }
            case 63969: {
                return "\u674e";
            }
            case 63970: {
                return "\u68a8";
            }
            case 63971: {
                return "\u6ce5";
            }
            case 63972: {
                return "\u7406";
            }
            case 63973: {
                return "\u75e2";
            }
            case 63974: {
                return "\u7f79";
            }
            case 63975: {
                return "\u88cf";
            }
            case 63976: {
                return "\u88e1";
            }
            case 63977: {
                return "\u91cc";
            }
            case 63978: {
                return "\u96e2";
            }
            case 63979: {
                return "\u533f";
            }
            case 63980: {
                return "\u6eba";
            }
            case 63981: {
                return "\u541d";
            }
            case 63982: {
                return "\u71d0";
            }
            case 63983: {
                return "\u7498";
            }
            case 63984: {
                return "\u85fa";
            }
            case 63985: {
                return "\u96a3";
            }
            case 63986: {
                return "\u9c57";
            }
            case 63987: {
                return "\u9e9f";
            }
            case 63988: {
                return "\u6797";
            }
            case 63989: {
                return "\u6dcb";
            }
            case 63990: {
                return "\u81e8";
            }
            case 63991: {
                return "\u7acb";
            }
            case 63992: {
                return "\u7b20";
            }
            case 63993: {
                return "\u7c92";
            }
            case 63994: {
                return "\u72c0";
            }
            case 63995: {
                return "\u7099";
            }
            case 63996: {
                return "\u8b58";
            }
            case 63997: {
                return "\u4ec0";
            }
            case 63998: {
                return "\u8336";
            }
            case 63999: {
                return "\u523a";
            }
            case 64000: {
                return "\u5207";
            }
            case 64001: {
                return "\u5ea6";
            }
            case 64002: {
                return "\u62d3";
            }
            case 64003: {
                return "\u7cd6";
            }
            case 64004: {
                return "\u5b85";
            }
            case 64005: {
                return "\u6d1e";
            }
            case 64006: {
                return "\u66b4";
            }
            case 64007: {
                return "\u8f3b";
            }
            case 64008: {
                return "\u884c";
            }
            case 64009: {
                return "\u964d";
            }
            case 64010: {
                return "\u898b";
            }
            case 64011: {
                return "\u5ed3";
            }
            case 64012: {
                return "\u5140";
            }
            case 64013: {
                return "\u55c0";
            }
            case 64016: {
                return "\u585a";
            }
            case 64018: {
                return "\u6674";
            }
            case 64021: {
                return "\u51de";
            }
            case 64022: {
                return "\u732a";
            }
            case 64023: {
                return "\u76ca";
            }
            case 64024: {
                return "\u793c";
            }
            case 64025: {
                return "\u795e";
            }
            case 64026: {
                return "\u7965";
            }
            case 64027: {
                return "\u798f";
            }
            case 64028: {
                return "\u9756";
            }
            case 64029: {
                return "\u7cbe";
            }
            case 64030: {
                return "\u7fbd";
            }
            case 64032: {
                return "\u8612";
            }
            case 64034: {
                return "\u8af8";
            }
            case 64037: {
                return "\u9038";
            }
            case 64038: {
                return "\u90fd";
            }
            case 64042: {
                return "\u98ef";
            }
            case 64043: {
                return "\u98fc";
            }
            case 64044: {
                return "\u9928";
            }
            case 64045: {
                return "\u9db4";
            }
            case 64048: {
                return "\u4fae";
            }
            case 64049: {
                return "\u50e7";
            }
            case 64050: {
                return "\u514d";
            }
            case 64051: {
                return "\u52c9";
            }
            case 64052: {
                return "\u52e4";
            }
            case 64053: {
                return "\u5351";
            }
            case 64054: {
                return "\u559d";
            }
            case 64055: {
                return "\u5606";
            }
            case 64056: {
                return "\u5668";
            }
            case 64057: {
                return "\u5840";
            }
            case 64058: {
                return "\u58a8";
            }
            case 64059: {
                return "\u5c64";
            }
            case 64060: {
                return "\u5c6e";
            }
            case 64061: {
                return "\u6094";
            }
            case 64062: {
                return "\u6168";
            }
            case 64063: {
                return "\u618e";
            }
            case 64064: {
                return "\u61f2";
            }
            case 64065: {
                return "\u654f";
            }
            case 64066: {
                return "\u65e2";
            }
            case 64067: {
                return "\u6691";
            }
            case 64068: {
                return "\u6885";
            }
            case 64069: {
                return "\u6d77";
            }
            case 64070: {
                return "\u6e1a";
            }
            case 64071: {
                return "\u6f22";
            }
            case 64072: {
                return "\u716e";
            }
            case 64073: {
                return "\u722b";
            }
            case 64074: {
                return "\u7422";
            }
            case 64075: {
                return "\u7891";
            }
            case 64076: {
                return "\u793e";
            }
            case 64077: {
                return "\u7949";
            }
            case 64078: {
                return "\u7948";
            }
            case 64079: {
                return "\u7950";
            }
            case 64080: {
                return "\u7956";
            }
            case 64081: {
                return "\u795d";
            }
            case 64082: {
                return "\u798d";
            }
            case 64083: {
                return "\u798e";
            }
            case 64084: {
                return "\u7a40";
            }
            case 64085: {
                return "\u7a81";
            }
            case 64086: {
                return "\u7bc0";
            }
            case 64087: {
                return "\u7df4";
            }
            case 64088: {
                return "\u7e09";
            }
            case 64089: {
                return "\u7e41";
            }
            case 64090: {
                return "\u7f72";
            }
            case 64091: {
                return "\u8005";
            }
            case 64092: {
                return "\u81ed";
            }
            case 64093: {
                return "\u8279";
            }
            case 64094: {
                return "\u8279";
            }
            case 64095: {
                return "\u8457";
            }
            case 64096: {
                return "\u8910";
            }
            case 64097: {
                return "\u8996";
            }
            case 64098: {
                return "\u8b01";
            }
            case 64099: {
                return "\u8b39";
            }
            case 64100: {
                return "\u8cd3";
            }
            case 64101: {
                return "\u8d08";
            }
            case 64102: {
                return "\u8fb6";
            }
            case 64103: {
                return "\u9038";
            }
            case 64104: {
                return "\u96e3";
            }
            case 64105: {
                return "\u97ff";
            }
            case 64106: {
                return "\u983b";
            }
            case 64112: {
                return "\u4e26";
            }
            case 64113: {
                return "\u51b5";
            }
            case 64114: {
                return "\u5168";
            }
            case 64115: {
                return "\u4f80";
            }
            case 64116: {
                return "\u5145";
            }
            case 64117: {
                return "\u5180";
            }
            case 64118: {
                return "\u52c7";
            }
            case 64119: {
                return "\u52fa";
            }
            case 64120: {
                return "\u559d";
            }
            case 64121: {
                return "\u5555";
            }
            case 64122: {
                return "\u5599";
            }
            case 64123: {
                return "\u55e2";
            }
            case 64124: {
                return "\u585a";
            }
            case 64125: {
                return "\u58b3";
            }
            case 64126: {
                return "\u5944";
            }
            case 64127: {
                return "\u5954";
            }
            case 64128: {
                return "\u5a62";
            }
            case 64129: {
                return "\u5b28";
            }
            case 64130: {
                return "\u5ed2";
            }
            case 64131: {
                return "\u5ed9";
            }
            case 64132: {
                return "\u5f69";
            }
            case 64133: {
                return "\u5fad";
            }
            case 64134: {
                return "\u60d8";
            }
            case 64135: {
                return "\u614e";
            }
            case 64136: {
                return "\u6108";
            }
            case 64137: {
                return "\u618e";
            }
            case 64138: {
                return "\u6160";
            }
            case 64139: {
                return "\u61f2";
            }
            case 64140: {
                return "\u6234";
            }
            case 64141: {
                return "\u63c4";
            }
            case 64142: {
                return "\u641c";
            }
            case 64143: {
                return "\u6452";
            }
            case 64144: {
                return "\u6556";
            }
            case 64145: {
                return "\u6674";
            }
            case 64146: {
                return "\u6717";
            }
            case 64147: {
                return "\u671b";
            }
            case 64148: {
                return "\u6756";
            }
            case 64149: {
                return "\u6b79";
            }
            case 64150: {
                return "\u6bba";
            }
            case 64151: {
                return "\u6d41";
            }
            case 64152: {
                return "\u6edb";
            }
            case 64153: {
                return "\u6ecb";
            }
            case 64154: {
                return "\u6f22";
            }
            case 64155: {
                return "\u701e";
            }
            case 64156: {
                return "\u716e";
            }
            case 64157: {
                return "\u77a7";
            }
            case 64158: {
                return "\u7235";
            }
            case 64159: {
                return "\u72af";
            }
            case 64160: {
                return "\u732a";
            }
            case 64161: {
                return "\u7471";
            }
            case 64162: {
                return "\u7506";
            }
            case 64163: {
                return "\u753b";
            }
            case 64164: {
                return "\u761d";
            }
            case 64165: {
                return "\u761f";
            }
            case 64166: {
                return "\u76ca";
            }
            case 64167: {
                return "\u76db";
            }
            case 64168: {
                return "\u76f4";
            }
            case 64169: {
                return "\u774a";
            }
            case 64170: {
                return "\u7740";
            }
            case 64171: {
                return "\u78cc";
            }
            case 64172: {
                return "\u7ab1";
            }
            case 64173: {
                return "\u7bc0";
            }
            case 64174: {
                return "\u7c7b";
            }
            case 64175: {
                return "\u7d5b";
            }
            case 64176: {
                return "\u7df4";
            }
            case 64177: {
                return "\u7f3e";
            }
            case 64178: {
                return "\u8005";
            }
            case 64179: {
                return "\u8352";
            }
            case 64180: {
                return "\u83ef";
            }
            case 64181: {
                return "\u8779";
            }
            case 64182: {
                return "\u8941";
            }
            case 64183: {
                return "\u8986";
            }
            case 64184: {
                return "\u8996";
            }
            case 64185: {
                return "\u8abf";
            }
            case 64186: {
                return "\u8af8";
            }
            case 64187: {
                return "\u8acb";
            }
            case 64188: {
                return "\u8b01";
            }
            case 64189: {
                return "\u8afe";
            }
            case 64190: {
                return "\u8aed";
            }
            case 64191: {
                return "\u8b39";
            }
            case 64192: {
                return "\u8b8a";
            }
            case 64193: {
                return "\u8d08";
            }
            case 64194: {
                return "\u8f38";
            }
            case 64195: {
                return "\u9072";
            }
            case 64196: {
                return "\u9199";
            }
            case 64197: {
                return "\u9276";
            }
            case 64198: {
                return "\u967c";
            }
            case 64199: {
                return "\u96e3";
            }
            case 64200: {
                return "\u9756";
            }
            case 64201: {
                return "\u97db";
            }
            case 64202: {
                return "\u97ff";
            }
            case 64203: {
                return "\u980b";
            }
            case 64204: {
                return "\u983b";
            }
            case 64205: {
                return "\u9b12";
            }
            case 64206: {
                return "\u9f9c";
            }
            case 64207: {
                return "\ud84a\udc4a";
            }
            case 64208: {
                return "\ud84a\udc44";
            }
            case 64209: {
                return "\ud84c\udfd5";
            }
            case 64210: {
                return "\u3b9d";
            }
            case 64211: {
                return "\u4018";
            }
            case 64212: {
                return "\u4039";
            }
            case 64213: {
                return "\ud854\ude49";
            }
            case 64214: {
                return "\ud857\udcd0";
            }
            case 64215: {
                return "\ud85f\uded3";
            }
            case 64216: {
                return "\u9f43";
            }
            case 64217: {
                return "\u9f8e";
            }
            case 64285: {
                return "\u05d9\u05b4";
            }
            case 64287: {
                return "\u05f2\u05b7";
            }
            case 64298: {
                return "\u05e9\u05c1";
            }
            case 64299: {
                return "\u05e9\u05c2";
            }
            case 64300: {
                return "\ufb49\u05c1";
            }
            case 64301: {
                return "\ufb49\u05c2";
            }
            case 64302: {
                return "\u05d0\u05b7";
            }
            case 64303: {
                return "\u05d0\u05b8";
            }
            case 64304: {
                return "\u05d0\u05bc";
            }
            case 64305: {
                return "\u05d1\u05bc";
            }
            case 64306: {
                return "\u05d2\u05bc";
            }
            case 64307: {
                return "\u05d3\u05bc";
            }
            case 64308: {
                return "\u05d4\u05bc";
            }
            case 64309: {
                return "\u05d5\u05bc";
            }
            case 64310: {
                return "\u05d6\u05bc";
            }
            case 64312: {
                return "\u05d8\u05bc";
            }
            case 64313: {
                return "\u05d9\u05bc";
            }
            case 64314: {
                return "\u05da\u05bc";
            }
            case 64315: {
                return "\u05db\u05bc";
            }
            case 64316: {
                return "\u05dc\u05bc";
            }
            case 64318: {
                return "\u05de\u05bc";
            }
            case 64320: {
                return "\u05e0\u05bc";
            }
            case 64321: {
                return "\u05e1\u05bc";
            }
            case 64323: {
                return "\u05e3\u05bc";
            }
            case 64324: {
                return "\u05e4\u05bc";
            }
            case 64326: {
                return "\u05e6\u05bc";
            }
            case 64327: {
                return "\u05e7\u05bc";
            }
            case 64328: {
                return "\u05e8\u05bc";
            }
            case 64329: {
                return "\u05e9\u05bc";
            }
            case 64330: {
                return "\u05ea\u05bc";
            }
            case 64331: {
                return "\u05d5\u05b9";
            }
            case 64332: {
                return "\u05d1\u05bf";
            }
            case 64333: {
                return "\u05db\u05bf";
            }
            case 64334: {
                return "\u05e4\u05bf";
            }
            case 119134: {
                return "\ud834\udd57\ud834\udd65";
            }
            case 119135: {
                return "\ud834\udd58\ud834\udd65";
            }
            case 119136: {
                return "\ud834\udd5f\ud834\udd6e";
            }
            case 119137: {
                return "\ud834\udd5f\ud834\udd6f";
            }
            case 119138: {
                return "\ud834\udd5f\ud834\udd70";
            }
            case 119139: {
                return "\ud834\udd5f\ud834\udd71";
            }
            case 119140: {
                return "\ud834\udd5f\ud834\udd72";
            }
            case 119227: {
                return "\ud834\uddb9\ud834\udd65";
            }
            case 119228: {
                return "\ud834\uddba\ud834\udd65";
            }
            case 119229: {
                return "\ud834\uddbb\ud834\udd6e";
            }
            case 119230: {
                return "\ud834\uddbc\ud834\udd6e";
            }
            case 119231: {
                return "\ud834\uddbb\ud834\udd6f";
            }
            case 119232: {
                return "\ud834\uddbc\ud834\udd6f";
            }
            case 194560: {
                return "\u4e3d";
            }
            case 194561: {
                return "\u4e38";
            }
            case 194562: {
                return "\u4e41";
            }
            case 194563: {
                return "\ud840\udd22";
            }
            case 194564: {
                return "\u4f60";
            }
            case 194565: {
                return "\u4fae";
            }
            case 194566: {
                return "\u4fbb";
            }
            case 194567: {
                return "\u5002";
            }
            case 194568: {
                return "\u507a";
            }
            case 194569: {
                return "\u5099";
            }
            case 194570: {
                return "\u50e7";
            }
            case 194571: {
                return "\u50cf";
            }
            case 194572: {
                return "\u349e";
            }
            case 194573: {
                return "\ud841\ude3a";
            }
            case 194574: {
                return "\u514d";
            }
            case 194575: {
                return "\u5154";
            }
            case 194576: {
                return "\u5164";
            }
            case 194577: {
                return "\u5177";
            }
            case 194578: {
                return "\ud841\udd1c";
            }
            case 194579: {
                return "\u34b9";
            }
            case 194580: {
                return "\u5167";
            }
            case 194581: {
                return "\u518d";
            }
            case 194582: {
                return "\ud841\udd4b";
            }
            case 194583: {
                return "\u5197";
            }
            case 194584: {
                return "\u51a4";
            }
            case 194585: {
                return "\u4ecc";
            }
            case 194586: {
                return "\u51ac";
            }
            case 194587: {
                return "\u51b5";
            }
            case 194588: {
                return "\ud864\udddf";
            }
            case 194589: {
                return "\u51f5";
            }
            case 194590: {
                return "\u5203";
            }
            case 194591: {
                return "\u34df";
            }
            case 194592: {
                return "\u523b";
            }
            case 194593: {
                return "\u5246";
            }
            case 194594: {
                return "\u5272";
            }
            case 194595: {
                return "\u5277";
            }
            case 194596: {
                return "\u3515";
            }
            case 194597: {
                return "\u52c7";
            }
            case 194598: {
                return "\u52c9";
            }
            case 194599: {
                return "\u52e4";
            }
            case 194600: {
                return "\u52fa";
            }
            case 194601: {
                return "\u5305";
            }
            case 194602: {
                return "\u5306";
            }
            case 194603: {
                return "\u5317";
            }
            case 194604: {
                return "\u5349";
            }
            case 194605: {
                return "\u5351";
            }
            case 194606: {
                return "\u535a";
            }
            case 194607: {
                return "\u5373";
            }
            case 194608: {
                return "\u537d";
            }
            case 194609: {
                return "\u537f";
            }
            case 194610: {
                return "\u537f";
            }
            case 194611: {
                return "\u537f";
            }
            case 194612: {
                return "\ud842\ude2c";
            }
            case 194613: {
                return "\u7070";
            }
            case 194614: {
                return "\u53ca";
            }
            case 194615: {
                return "\u53df";
            }
            case 194616: {
                return "\ud842\udf63";
            }
            case 194617: {
                return "\u53eb";
            }
            case 194618: {
                return "\u53f1";
            }
            case 194619: {
                return "\u5406";
            }
            case 194620: {
                return "\u549e";
            }
            case 194621: {
                return "\u5438";
            }
            case 194622: {
                return "\u5448";
            }
            case 194623: {
                return "\u5468";
            }
            case 194624: {
                return "\u54a2";
            }
            case 194625: {
                return "\u54f6";
            }
            case 194626: {
                return "\u5510";
            }
            case 194627: {
                return "\u5553";
            }
            case 194628: {
                return "\u5563";
            }
            case 194629: {
                return "\u5584";
            }
            case 194630: {
                return "\u5584";
            }
            case 194631: {
                return "\u5599";
            }
            case 194632: {
                return "\u55ab";
            }
            case 194633: {
                return "\u55b3";
            }
            case 194634: {
                return "\u55c2";
            }
            case 194635: {
                return "\u5716";
            }
            case 194636: {
                return "\u5606";
            }
            case 194637: {
                return "\u5717";
            }
            case 194638: {
                return "\u5651";
            }
            case 194639: {
                return "\u5674";
            }
            case 194640: {
                return "\u5207";
            }
            case 194641: {
                return "\u58ee";
            }
            case 194642: {
                return "\u57ce";
            }
            case 194643: {
                return "\u57f4";
            }
            case 194644: {
                return "\u580d";
            }
            case 194645: {
                return "\u578b";
            }
            case 194646: {
                return "\u5832";
            }
            case 194647: {
                return "\u5831";
            }
            case 194648: {
                return "\u58ac";
            }
            case 194649: {
                return "\ud845\udce4";
            }
            case 194650: {
                return "\u58f2";
            }
            case 194651: {
                return "\u58f7";
            }
            case 194652: {
                return "\u5906";
            }
            case 194653: {
                return "\u591a";
            }
            case 194654: {
                return "\u5922";
            }
            case 194655: {
                return "\u5962";
            }
            case 194656: {
                return "\ud845\udea8";
            }
            case 194657: {
                return "\ud845\udeea";
            }
            case 194658: {
                return "\u59ec";
            }
            case 194659: {
                return "\u5a1b";
            }
            case 194660: {
                return "\u5a27";
            }
            case 194661: {
                return "\u59d8";
            }
            case 194662: {
                return "\u5a66";
            }
            case 194663: {
                return "\u36ee";
            }
            case 194664: {
                return "\u36fc";
            }
            case 194665: {
                return "\u5b08";
            }
            case 194666: {
                return "\u5b3e";
            }
            case 194667: {
                return "\u5b3e";
            }
            case 194668: {
                return "\ud846\uddc8";
            }
            case 194669: {
                return "\u5bc3";
            }
            case 194670: {
                return "\u5bd8";
            }
            case 194671: {
                return "\u5be7";
            }
            case 194672: {
                return "\u5bf3";
            }
            case 194673: {
                return "\ud846\udf18";
            }
            case 194674: {
                return "\u5bff";
            }
            case 194675: {
                return "\u5c06";
            }
            case 194676: {
                return "\u5f53";
            }
            case 194677: {
                return "\u5c22";
            }
            case 194678: {
                return "\u3781";
            }
            case 194679: {
                return "\u5c60";
            }
            case 194680: {
                return "\u5c6e";
            }
            case 194681: {
                return "\u5cc0";
            }
            case 194682: {
                return "\u5c8d";
            }
            case 194683: {
                return "\ud847\udde4";
            }
            case 194684: {
                return "\u5d43";
            }
            case 194685: {
                return "\ud847\udde6";
            }
            case 194686: {
                return "\u5d6e";
            }
            case 194687: {
                return "\u5d6b";
            }
            case 194688: {
                return "\u5d7c";
            }
            case 194689: {
                return "\u5de1";
            }
            case 194690: {
                return "\u5de2";
            }
            case 194691: {
                return "\u382f";
            }
            case 194692: {
                return "\u5dfd";
            }
            case 194693: {
                return "\u5e28";
            }
            case 194694: {
                return "\u5e3d";
            }
            case 194695: {
                return "\u5e69";
            }
            case 194696: {
                return "\u3862";
            }
            case 194697: {
                return "\ud848\udd83";
            }
            case 194698: {
                return "\u387c";
            }
            case 194699: {
                return "\u5eb0";
            }
            case 194700: {
                return "\u5eb3";
            }
            case 194701: {
                return "\u5eb6";
            }
            case 194702: {
                return "\u5eca";
            }
            case 194703: {
                return "\ud868\udf92";
            }
            case 194704: {
                return "\u5efe";
            }
            case 194705: {
                return "\ud848\udf31";
            }
            case 194706: {
                return "\ud848\udf31";
            }
            case 194707: {
                return "\u8201";
            }
            case 194708: {
                return "\u5f22";
            }
            case 194709: {
                return "\u5f22";
            }
            case 194710: {
                return "\u38c7";
            }
            case 194711: {
                return "\ud84c\udeb8";
            }
            case 194712: {
                return "\ud858\uddda";
            }
            case 194713: {
                return "\u5f62";
            }
            case 194714: {
                return "\u5f6b";
            }
            case 194715: {
                return "\u38e3";
            }
            case 194716: {
                return "\u5f9a";
            }
            case 194717: {
                return "\u5fcd";
            }
            case 194718: {
                return "\u5fd7";
            }
            case 194719: {
                return "\u5ff9";
            }
            case 194720: {
                return "\u6081";
            }
            case 194721: {
                return "\u393a";
            }
            case 194722: {
                return "\u391c";
            }
            case 194723: {
                return "\u6094";
            }
            case 194724: {
                return "\ud849\uded4";
            }
            case 194725: {
                return "\u60c7";
            }
            case 194726: {
                return "\u6148";
            }
            case 194727: {
                return "\u614c";
            }
            case 194728: {
                return "\u614e";
            }
            case 194729: {
                return "\u614c";
            }
            case 194730: {
                return "\u617a";
            }
            case 194731: {
                return "\u618e";
            }
            case 194732: {
                return "\u61b2";
            }
            case 194733: {
                return "\u61a4";
            }
            case 194734: {
                return "\u61af";
            }
            case 194735: {
                return "\u61de";
            }
            case 194736: {
                return "\u61f2";
            }
            case 194737: {
                return "\u61f6";
            }
            case 194738: {
                return "\u6210";
            }
            case 194739: {
                return "\u621b";
            }
            case 194740: {
                return "\u625d";
            }
            case 194741: {
                return "\u62b1";
            }
            case 194742: {
                return "\u62d4";
            }
            case 194743: {
                return "\u6350";
            }
            case 194744: {
                return "\ud84a\udf0c";
            }
            case 194745: {
                return "\u633d";
            }
            case 194746: {
                return "\u62fc";
            }
            case 194747: {
                return "\u6368";
            }
            case 194748: {
                return "\u6383";
            }
            case 194749: {
                return "\u63e4";
            }
            case 194750: {
                return "\ud84a\udff1";
            }
            case 194751: {
                return "\u6422";
            }
            case 194752: {
                return "\u63c5";
            }
            case 194753: {
                return "\u63a9";
            }
            case 194754: {
                return "\u3a2e";
            }
            case 194755: {
                return "\u6469";
            }
            case 194756: {
                return "\u647e";
            }
            case 194757: {
                return "\u649d";
            }
            case 194758: {
                return "\u6477";
            }
            case 194759: {
                return "\u3a6c";
            }
            case 194760: {
                return "\u654f";
            }
            case 194761: {
                return "\u656c";
            }
            case 194762: {
                return "\ud84c\udc0a";
            }
            case 194763: {
                return "\u65e3";
            }
            case 194764: {
                return "\u66f8";
            }
            case 194765: {
                return "\u6649";
            }
            case 194766: {
                return "\u3b19";
            }
            case 194767: {
                return "\u6691";
            }
            case 194768: {
                return "\u3b08";
            }
            case 194769: {
                return "\u3ae4";
            }
            case 194770: {
                return "\u5192";
            }
            case 194771: {
                return "\u5195";
            }
            case 194772: {
                return "\u6700";
            }
            case 194773: {
                return "\u669c";
            }
            case 194774: {
                return "\u80ad";
            }
            case 194775: {
                return "\u43d9";
            }
            case 194776: {
                return "\u6717";
            }
            case 194777: {
                return "\u671b";
            }
            case 194778: {
                return "\u6721";
            }
            case 194779: {
                return "\u675e";
            }
            case 194780: {
                return "\u6753";
            }
            case 194781: {
                return "\ud84c\udfc3";
            }
            case 194782: {
                return "\u3b49";
            }
            case 194783: {
                return "\u67fa";
            }
            case 194784: {
                return "\u6785";
            }
            case 194785: {
                return "\u6852";
            }
            case 194786: {
                return "\u6885";
            }
            case 194787: {
                return "\ud84d\udc6d";
            }
            case 194788: {
                return "\u688e";
            }
            case 194789: {
                return "\u681f";
            }
            case 194790: {
                return "\u6914";
            }
            case 194791: {
                return "\u3b9d";
            }
            case 194792: {
                return "\u6942";
            }
            case 194793: {
                return "\u69a3";
            }
            case 194794: {
                return "\u69ea";
            }
            case 194795: {
                return "\u6aa8";
            }
            case 194796: {
                return "\ud84d\udea3";
            }
            case 194797: {
                return "\u6adb";
            }
            case 194798: {
                return "\u3c18";
            }
            case 194799: {
                return "\u6b21";
            }
            case 194800: {
                return "\ud84e\udca7";
            }
            case 194801: {
                return "\u6b54";
            }
            case 194802: {
                return "\u3c4e";
            }
            case 194803: {
                return "\u6b72";
            }
            case 194804: {
                return "\u6b9f";
            }
            case 194805: {
                return "\u6bba";
            }
            case 194806: {
                return "\u6bbb";
            }
            case 194807: {
                return "\ud84e\ude8d";
            }
            case 194808: {
                return "\ud847\udd0b";
            }
            case 194809: {
                return "\ud84e\udefa";
            }
            case 194810: {
                return "\u6c4e";
            }
            case 194811: {
                return "\ud84f\udcbc";
            }
            case 194812: {
                return "\u6cbf";
            }
            case 194813: {
                return "\u6ccd";
            }
            case 194814: {
                return "\u6c67";
            }
            case 194815: {
                return "\u6d16";
            }
            case 194816: {
                return "\u6d3e";
            }
            case 194817: {
                return "\u6d77";
            }
            case 194818: {
                return "\u6d41";
            }
            case 194819: {
                return "\u6d69";
            }
            case 194820: {
                return "\u6d78";
            }
            case 194821: {
                return "\u6d85";
            }
            case 194822: {
                return "\ud84f\udd1e";
            }
            case 194823: {
                return "\u6d34";
            }
            case 194824: {
                return "\u6e2f";
            }
            case 194825: {
                return "\u6e6e";
            }
            case 194826: {
                return "\u3d33";
            }
            case 194827: {
                return "\u6ecb";
            }
            case 194828: {
                return "\u6ec7";
            }
            case 194829: {
                return "\ud84f\uded1";
            }
            case 194830: {
                return "\u6df9";
            }
            case 194831: {
                return "\u6f6e";
            }
            case 194832: {
                return "\ud84f\udf5e";
            }
            case 194833: {
                return "\ud84f\udf8e";
            }
            case 194834: {
                return "\u6fc6";
            }
            case 194835: {
                return "\u7039";
            }
            case 194836: {
                return "\u701e";
            }
            case 194837: {
                return "\u701b";
            }
            case 194838: {
                return "\u3d96";
            }
            case 194839: {
                return "\u704a";
            }
            case 194840: {
                return "\u707d";
            }
            case 194841: {
                return "\u7077";
            }
            case 194842: {
                return "\u70ad";
            }
            case 194843: {
                return "\ud841\udd25";
            }
            case 194844: {
                return "\u7145";
            }
            case 194845: {
                return "\ud850\ude63";
            }
            case 194846: {
                return "\u719c";
            }
            case 194847: {
                return "\ud850\udfab";
            }
            case 194848: {
                return "\u7228";
            }
            case 194849: {
                return "\u7235";
            }
            case 194850: {
                return "\u7250";
            }
            case 194851: {
                return "\ud851\ude08";
            }
            case 194852: {
                return "\u7280";
            }
            case 194853: {
                return "\u7295";
            }
            case 194854: {
                return "\ud851\udf35";
            }
            case 194855: {
                return "\ud852\udc14";
            }
            case 194856: {
                return "\u737a";
            }
            case 194857: {
                return "\u738b";
            }
            case 194858: {
                return "\u3eac";
            }
            case 194859: {
                return "\u73a5";
            }
            case 194860: {
                return "\u3eb8";
            }
            case 194861: {
                return "\u3eb8";
            }
            case 194862: {
                return "\u7447";
            }
            case 194863: {
                return "\u745c";
            }
            case 194864: {
                return "\u7471";
            }
            case 194865: {
                return "\u7485";
            }
            case 194866: {
                return "\u74ca";
            }
            case 194867: {
                return "\u3f1b";
            }
            case 194868: {
                return "\u7524";
            }
            case 194869: {
                return "\ud853\udc36";
            }
            case 194870: {
                return "\u753e";
            }
            case 194871: {
                return "\ud853\udc92";
            }
            case 194872: {
                return "\u7570";
            }
            case 194873: {
                return "\ud848\udd9f";
            }
            case 194874: {
                return "\u7610";
            }
            case 194875: {
                return "\ud853\udfa1";
            }
            case 194876: {
                return "\ud853\udfb8";
            }
            case 194877: {
                return "\ud854\udc44";
            }
            case 194878: {
                return "\u3ffc";
            }
            case 194879: {
                return "\u4008";
            }
            case 194880: {
                return "\u76f4";
            }
            case 194881: {
                return "\ud854\udcf3";
            }
            case 194882: {
                return "\ud854\udcf2";
            }
            case 194883: {
                return "\ud854\udd19";
            }
            case 194884: {
                return "\ud854\udd33";
            }
            case 194885: {
                return "\u771e";
            }
            case 194886: {
                return "\u771f";
            }
            case 194887: {
                return "\u771f";
            }
            case 194888: {
                return "\u774a";
            }
            case 194889: {
                return "\u4039";
            }
            case 194890: {
                return "\u778b";
            }
            case 194891: {
                return "\u4046";
            }
            case 194892: {
                return "\u4096";
            }
            case 194893: {
                return "\ud855\udc1d";
            }
            case 194894: {
                return "\u784e";
            }
            case 194895: {
                return "\u788c";
            }
            case 194896: {
                return "\u78cc";
            }
            case 194897: {
                return "\u40e3";
            }
            case 194898: {
                return "\ud855\ude26";
            }
            case 194899: {
                return "\u7956";
            }
            case 194900: {
                return "\ud855\ude9a";
            }
            case 194901: {
                return "\ud855\udec5";
            }
            case 194902: {
                return "\u798f";
            }
            case 194903: {
                return "\u79eb";
            }
            case 194904: {
                return "\u412f";
            }
            case 194905: {
                return "\u7a40";
            }
            case 194906: {
                return "\u7a4a";
            }
            case 194907: {
                return "\u7a4f";
            }
            case 194908: {
                return "\ud856\udd7c";
            }
            case 194909: {
                return "\ud856\udea7";
            }
            case 194910: {
                return "\ud856\udea7";
            }
            case 194911: {
                return "\u7aee";
            }
            case 194912: {
                return "\u4202";
            }
            case 194913: {
                return "\ud856\udfab";
            }
            case 194914: {
                return "\u7bc6";
            }
            case 194915: {
                return "\u7bc9";
            }
            case 194916: {
                return "\u4227";
            }
            case 194917: {
                return "\ud857\udc80";
            }
            case 194918: {
                return "\u7cd2";
            }
            case 194919: {
                return "\u42a0";
            }
            case 194920: {
                return "\u7ce8";
            }
            case 194921: {
                return "\u7ce3";
            }
            case 194922: {
                return "\u7d00";
            }
            case 194923: {
                return "\ud857\udf86";
            }
            case 194924: {
                return "\u7d63";
            }
            case 194925: {
                return "\u4301";
            }
            case 194926: {
                return "\u7dc7";
            }
            case 194927: {
                return "\u7e02";
            }
            case 194928: {
                return "\u7e45";
            }
            case 194929: {
                return "\u4334";
            }
            case 194930: {
                return "\ud858\ude28";
            }
            case 194931: {
                return "\ud858\ude47";
            }
            case 194932: {
                return "\u4359";
            }
            case 194933: {
                return "\ud858\uded9";
            }
            case 194934: {
                return "\u7f7a";
            }
            case 194935: {
                return "\ud858\udf3e";
            }
            case 194936: {
                return "\u7f95";
            }
            case 194937: {
                return "\u7ffa";
            }
            case 194938: {
                return "\u8005";
            }
            case 194939: {
                return "\ud859\udcda";
            }
            case 194940: {
                return "\ud859\udd23";
            }
            case 194941: {
                return "\u8060";
            }
            case 194942: {
                return "\ud859\udda8";
            }
            case 194943: {
                return "\u8070";
            }
            case 194944: {
                return "\ud84c\udf5f";
            }
            case 194945: {
                return "\u43d5";
            }
            case 194946: {
                return "\u80b2";
            }
            case 194947: {
                return "\u8103";
            }
            case 194948: {
                return "\u440b";
            }
            case 194949: {
                return "\u813e";
            }
            case 194950: {
                return "\u5ab5";
            }
            case 194951: {
                return "\ud859\udfa7";
            }
            case 194952: {
                return "\ud859\udfb5";
            }
            case 194953: {
                return "\ud84c\udf93";
            }
            case 194954: {
                return "\ud84c\udf9c";
            }
            case 194955: {
                return "\u8201";
            }
            case 194956: {
                return "\u8204";
            }
            case 194957: {
                return "\u8f9e";
            }
            case 194958: {
                return "\u446b";
            }
            case 194959: {
                return "\u8291";
            }
            case 194960: {
                return "\u828b";
            }
            case 194961: {
                return "\u829d";
            }
            case 194962: {
                return "\u52b3";
            }
            case 194963: {
                return "\u82b1";
            }
            case 194964: {
                return "\u82b3";
            }
            case 194965: {
                return "\u82bd";
            }
            case 194966: {
                return "\u82e6";
            }
            case 194967: {
                return "\ud85a\udf3c";
            }
            case 194968: {
                return "\u82e5";
            }
            case 194969: {
                return "\u831d";
            }
            case 194970: {
                return "\u8363";
            }
            case 194971: {
                return "\u83ad";
            }
            case 194972: {
                return "\u8323";
            }
            case 194973: {
                return "\u83bd";
            }
            case 194974: {
                return "\u83e7";
            }
            case 194975: {
                return "\u8457";
            }
            case 194976: {
                return "\u8353";
            }
            case 194977: {
                return "\u83ca";
            }
            case 194978: {
                return "\u83cc";
            }
            case 194979: {
                return "\u83dc";
            }
            case 194980: {
                return "\ud85b\udc36";
            }
            case 194981: {
                return "\ud85b\udd6b";
            }
            case 194982: {
                return "\ud85b\udcd5";
            }
            case 194983: {
                return "\u452b";
            }
            case 194984: {
                return "\u84f1";
            }
            case 194985: {
                return "\u84f3";
            }
            case 194986: {
                return "\u8516";
            }
            case 194987: {
                return "\ud85c\udfca";
            }
            case 194988: {
                return "\u8564";
            }
            case 194989: {
                return "\ud85b\udf2c";
            }
            case 194990: {
                return "\u455d";
            }
            case 194991: {
                return "\u4561";
            }
            case 194992: {
                return "\ud85b\udfb1";
            }
            case 194993: {
                return "\ud85c\udcd2";
            }
            case 194994: {
                return "\u456b";
            }
            case 194995: {
                return "\u8650";
            }
            case 194996: {
                return "\u865c";
            }
            case 194997: {
                return "\u8667";
            }
            case 194998: {
                return "\u8669";
            }
            case 194999: {
                return "\u86a9";
            }
            case 195000: {
                return "\u8688";
            }
            case 195001: {
                return "\u870e";
            }
            case 195002: {
                return "\u86e2";
            }
            case 195003: {
                return "\u8779";
            }
            case 195004: {
                return "\u8728";
            }
            case 195005: {
                return "\u876b";
            }
            case 195006: {
                return "\u8786";
            }
            case 195007: {
                return "\u45d7";
            }
            case 195008: {
                return "\u87e1";
            }
            case 195009: {
                return "\u8801";
            }
            case 195010: {
                return "\u45f9";
            }
            case 195011: {
                return "\u8860";
            }
            case 195012: {
                return "\u8863";
            }
            case 195013: {
                return "\ud85d\ude67";
            }
            case 195014: {
                return "\u88d7";
            }
            case 195015: {
                return "\u88de";
            }
            case 195016: {
                return "\u4635";
            }
            case 195017: {
                return "\u88fa";
            }
            case 195018: {
                return "\u34bb";
            }
            case 195019: {
                return "\ud85e\udcae";
            }
            case 195020: {
                return "\ud85e\udd66";
            }
            case 195021: {
                return "\u46be";
            }
            case 195022: {
                return "\u46c7";
            }
            case 195023: {
                return "\u8aa0";
            }
            case 195024: {
                return "\u8aed";
            }
            case 195025: {
                return "\u8b8a";
            }
            case 195026: {
                return "\u8c55";
            }
            case 195027: {
                return "\ud85f\udca8";
            }
            case 195028: {
                return "\u8cab";
            }
            case 195029: {
                return "\u8cc1";
            }
            case 195030: {
                return "\u8d1b";
            }
            case 195031: {
                return "\u8d77";
            }
            case 195032: {
                return "\ud85f\udf2f";
            }
            case 195033: {
                return "\ud842\udc04";
            }
            case 195034: {
                return "\u8dcb";
            }
            case 195035: {
                return "\u8dbc";
            }
            case 195036: {
                return "\u8df0";
            }
            case 195037: {
                return "\ud842\udcde";
            }
            case 195038: {
                return "\u8ed4";
            }
            case 195039: {
                return "\u8f38";
            }
            case 195040: {
                return "\ud861\uddd2";
            }
            case 195041: {
                return "\ud861\udded";
            }
            case 195042: {
                return "\u9094";
            }
            case 195043: {
                return "\u90f1";
            }
            case 195044: {
                return "\u9111";
            }
            case 195045: {
                return "\ud861\udf2e";
            }
            case 195046: {
                return "\u911b";
            }
            case 195047: {
                return "\u9238";
            }
            case 195048: {
                return "\u92d7";
            }
            case 195049: {
                return "\u92d8";
            }
            case 195050: {
                return "\u927c";
            }
            case 195051: {
                return "\u93f9";
            }
            case 195052: {
                return "\u9415";
            }
            case 195053: {
                return "\ud862\udffa";
            }
            case 195054: {
                return "\u958b";
            }
            case 195055: {
                return "\u4995";
            }
            case 195056: {
                return "\u95b7";
            }
            case 195057: {
                return "\ud863\udd77";
            }
            case 195058: {
                return "\u49e6";
            }
            case 195059: {
                return "\u96c3";
            }
            case 195060: {
                return "\u5db2";
            }
            case 195061: {
                return "\u9723";
            }
            case 195062: {
                return "\ud864\udd45";
            }
            case 195063: {
                return "\ud864\ude1a";
            }
            case 195064: {
                return "\u4a6e";
            }
            case 195065: {
                return "\u4a76";
            }
            case 195066: {
                return "\u97e0";
            }
            case 195067: {
                return "\ud865\udc0a";
            }
            case 195068: {
                return "\u4ab2";
            }
            case 195069: {
                return "\ud865\udc96";
            }
            case 195070: {
                return "\u980b";
            }
            case 195071: {
                return "\u980b";
            }
            case 195072: {
                return "\u9829";
            }
            case 195073: {
                return "\ud865\uddb6";
            }
            case 195074: {
                return "\u98e2";
            }
            case 195075: {
                return "\u4b33";
            }
            case 195076: {
                return "\u9929";
            }
            case 195077: {
                return "\u99a7";
            }
            case 195078: {
                return "\u99c2";
            }
            case 195079: {
                return "\u99fe";
            }
            case 195080: {
                return "\u4bce";
            }
            case 195081: {
                return "\ud866\udf30";
            }
            case 195082: {
                return "\u9b12";
            }
            case 195083: {
                return "\u9c40";
            }
            case 195084: {
                return "\u9cfd";
            }
            case 195085: {
                return "\u4cce";
            }
            case 195086: {
                return "\u4ced";
            }
            case 195087: {
                return "\u9d67";
            }
            case 195088: {
                return "\ud868\udcce";
            }
            case 195089: {
                return "\u4cf8";
            }
            case 195090: {
                return "\ud868\udd05";
            }
            case 195091: {
                return "\ud868\ude0e";
            }
            case 195092: {
                return "\ud868\ude91";
            }
            case 195093: {
                return "\u9ebb";
            }
            case 195094: {
                return "\u4d56";
            }
            case 195095: {
                return "\u9ef9";
            }
            case 195096: {
                return "\u9efe";
            }
            case 195097: {
                return "\u9f05";
            }
            case 195098: {
                return "\u9f0f";
            }
            case 195099: {
                return "\u9f16";
            }
            case 195100: {
                return "\u9f3b";
            }
            case 195101: {
                return "\ud869\ude00";
            }
        }
        if (n <= 65535) {
            return String.valueOf((char)n);
        }
        StringBuilder stringBuilder = new StringBuilder(2);
        stringBuilder.append(UnicodeUtil.getHighSurrogate(n));
        stringBuilder.append(UnicodeUtil.getLowSurrogate(n));
        return stringBuilder.toString();
    }

    private static String decomposeHangul(char c) {
        int n = c - 44032;
        if (n < 0 || n >= 11172) {
            return String.valueOf(c);
        }
        int n2 = 4352 + n / 588;
        int n3 = 4449 + n % 588 / 28;
        int n4 = 4519 + n % 28;
        StringBuilder stringBuilder = new StringBuilder(3);
        stringBuilder.append((char)n2);
        stringBuilder.append((char)n3);
        if (n4 != 4519) {
            stringBuilder.append((char)n4);
        }
        return stringBuilder.toString();
    }

    private static String composeHangul(String string) {
        int n = string.length();
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        char c = string.charAt(0);
        stringBuilder.append(c);
        for (int i = 1; i < n; ++i) {
            int n2;
            int n3;
            char c2 = string.charAt(i);
            int n4 = c - 4352;
            if (0 <= n4 && n4 < 19 && (n3 = c2 - 4449) >= 0 && n3 < 21) {
                c = (char)(44032 + (n4 * 21 + n3) * 28);
                stringBuilder.setCharAt(stringBuilder.length() - 1, c);
                continue;
            }
            n3 = c - 44032;
            if (n3 >= 0 && n3 < 11172 && n3 % 28 == 0 && (n2 = c2 - 4519) >= 0 && n2 <= 28) {
                c = (char)(c + n2);
                stringBuilder.setCharAt(stringBuilder.length() - 1, c);
                continue;
            }
            c = c2;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static class UnicodeString {
        private int[] data;
        private int size = 0;

        UnicodeString(String string) {
            int n = string.length();
            this.data = new int[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3;
                int n4 = n3 = string.charAt(i);
                if (UnicodeUtil.isHighSurrogate((char)n3)) {
                    n4 = UnicodeUtil.combineSurrogatePair((char)n3, string.charAt(++i));
                }
                this.data[n2] = n4;
                ++n2;
            }
            this.size = n2;
        }

        UnicodeString(int n) {
            this.size = 0;
            this.data = new int[n];
        }

        UnicodeString decompose() {
            int n;
            int n2;
            UnicodeString unicodeString = new UnicodeString(this.size);
            for (n2 = 0; n2 < this.size; ++n2) {
                n = this.data[n2];
                String string = UnicodeUtil.decompose(n);
                unicodeString.append(string);
            }
            for (n2 = 0; n2 < unicodeString.size - 1; ++n2) {
                int n3;
                n = unicodeString.data[n2];
                int n4 = unicodeString.data[n2 + 1];
                int n5 = UnicodeUtil.getCombiningClass(n4);
                if (n5 == 0 || (n3 = UnicodeUtil.getCombiningClass(n)) <= n5) continue;
                unicodeString.data[n2] = n4;
                unicodeString.data[n2 + 1] = n;
                if ((n2 -= 2) != -2) continue;
                n2 = -1;
            }
            return unicodeString;
        }

        UnicodeString compose() {
            if (compositions == null) {
                UnicodeUtil.loadCompositions();
            }
            UnicodeString unicodeString = new UnicodeString(this.size);
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            for (int i = 0; i < this.size; ++i) {
                int n4 = this.data[i];
                if (n == -1 || this.isBlocked(n2, i)) {
                    unicodeString.append(n4);
                    if (!UnicodeUtil.isStarter(n4)) continue;
                    n = n4;
                    n2 = i;
                    n3 = unicodeString.size - 1;
                    continue;
                }
                int n5 = UnicodeUtil.composeCharacter(n, n4);
                if (n5 == -1) {
                    unicodeString.append(n4);
                    if (!UnicodeUtil.isStarter(n4)) continue;
                    n = n4;
                    n2 = i;
                    n3 = unicodeString.size - 1;
                    continue;
                }
                n = n5;
                this.data[n2] = n5;
                this.data[i] = 0;
                unicodeString.data[n3] = n5;
            }
            return unicodeString;
        }

        void append(String string) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (UnicodeUtil.isHighSurrogate(c)) {
                    this.append(UnicodeUtil.combineSurrogatePair(c, string.charAt(i + 1)));
                    ++i;
                    continue;
                }
                this.append(c);
            }
        }

        void append(int n) {
            if (this.size < this.data.length - 1) {
                this.data[this.size] = n;
                ++this.size;
            } else {
                int[] nArray = new int[this.data.length + 10];
                System.arraycopy(this.data, 0, nArray, 0, this.size);
                this.data = nArray;
                this.append(n);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.size; ++i) {
                int n = this.data[i];
                if (n <= 65535) {
                    stringBuilder.append((char)n);
                    continue;
                }
                stringBuilder.append(UnicodeUtil.makeSurrogatePair(n));
            }
            return stringBuilder.toString();
        }

        private boolean isBlocked(int n, int n2) {
            int n3 = UnicodeUtil.getCombiningClass(this.data[n2]);
            for (int i = n + 1; i < n2; ++i) {
                if (this.data[i] == 0 || n3 != UnicodeUtil.getCombiningClass(this.data[i])) continue;
                return true;
            }
            return false;
        }
    }
}

