/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.osgi.framework.ServiceReference;

public class CachingServiceReference<T>
implements Comparable<CachingServiceReference<T>> {
    private final ConcurrentHashMap<String, Object> _properties = new ConcurrentHashMap();
    private final ServiceReference<T> _serviceReference;

    public CachingServiceReference(ServiceReference<T> serviceReference) {
        this._serviceReference = serviceReference;
    }

    @Override
    public int compareTo(CachingServiceReference<T> o) {
        int compare;
        Object myServiceRankingObject = this.getProperty("service.ranking");
        Object otherRankingObject = o.getProperty("service.ranking");
        if (myServiceRankingObject == null || !(myServiceRankingObject instanceof Integer)) {
            myServiceRankingObject = 0;
        }
        if (otherRankingObject == null || !(otherRankingObject instanceof Integer)) {
            otherRankingObject = 0;
        }
        if ((compare = Integer.compare((Integer)myServiceRankingObject, (Integer)otherRankingObject)) != 0) {
            return compare;
        }
        return Long.compare((Long)o.getProperty("service.id"), (Long)this._serviceReference.getProperty("service.id"));
    }

    public String[] getCachedPropertyKeys() {
        return ((ConcurrentHashMap.CollectionView)((Object)this._properties.keySet())).toArray(new String[0]);
    }

    public Object getProperty(String key) {
        Object propertyValue = this._properties.compute(key, (__, value) -> {
            if (value == null) {
                Object realValue = this._serviceReference.getProperty(key);
                if (realValue == null) {
                    return NULL.INSTANCE;
                }
                return realValue;
            }
            return value;
        });
        if (propertyValue == NULL.INSTANCE) {
            return null;
        }
        return propertyValue;
    }

    public String[] getPropertyKeys() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(this._serviceReference.getPropertyKeys()));
        set.addAll(this._properties.keySet());
        List nullProperties = this._properties.entrySet().stream().filter(e -> e.getValue().equals(NULL.INSTANCE)).map(Map.Entry::getKey).collect(Collectors.toList());
        set.removeAll(nullProperties);
        return set.toArray(new String[0]);
    }

    public ServiceReference<T> getServiceReference() {
        return this._serviceReference;
    }

    public int hashCode() {
        return this._serviceReference.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingServiceReference that = (CachingServiceReference)o;
        return this._serviceReference.equals(that._serviceReference);
    }

    public boolean isDirty() {
        return this._properties.entrySet().stream().anyMatch(e -> !e.getValue().equals(this._serviceReference.getProperty((String)e.getKey())));
    }

    public String toString() {
        return "CachingServiceReference {" + System.lineSeparator() + "cachedProperties=" + this.mapToString(this._properties) + System.lineSeparator() + "serviceReference=" + this._serviceReference + System.lineSeparator() + "}";
    }

    private String mapToString(Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            Object value = entry.getValue();
            if (value instanceof int[]) {
                stringBuilder.append(Arrays.toString((int[])value));
            } else if (value instanceof long[]) {
                stringBuilder.append(Arrays.toString((long[])value));
            } else if (value instanceof float[]) {
                stringBuilder.append(Arrays.toString((float[])value));
            } else if (value instanceof double[]) {
                stringBuilder.append(Arrays.toString((double[])value));
            } else if (value instanceof byte[]) {
                stringBuilder.append(Arrays.toString((byte[])value));
            } else if (value instanceof short[]) {
                stringBuilder.append(Arrays.toString((short[])value));
            } else if (value instanceof char[]) {
                stringBuilder.append(Arrays.toString((char[])value));
            } else if (value instanceof Object[]) {
                stringBuilder.append(Arrays.deepToString((Object[])value));
            } else {
                stringBuilder.append(value);
            }
            stringBuilder.append(", ");
        }
        if (!map.isEmpty()) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean isDirty(String key) {
        Object value = this._properties.get(key);
        return value != null && !value.equals(this._serviceReference.getProperty(key));
    }

    private static class NULL {
        private static NULL INSTANCE = new NULL();

        private NULL() {
        }

        public boolean equals(Object obj) {
            return this == obj || obj == null;
        }

        public String toString() {
            return "null (cached)";
        }
    }
}

