/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class EXRTile
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET_X;
    public static final int OFFSET_Y;
    public static final int LEVEL_X;
    public static final int LEVEL_Y;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int IMAGES;

    public EXRTile(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), EXRTile.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int offset_x() {
        return EXRTile.noffset_x(this.address());
    }

    public int offset_y() {
        return EXRTile.noffset_y(this.address());
    }

    public int level_x() {
        return EXRTile.nlevel_x(this.address());
    }

    public int level_y() {
        return EXRTile.nlevel_y(this.address());
    }

    public int width() {
        return EXRTile.nwidth(this.address());
    }

    public int height() {
        return EXRTile.nheight(this.address());
    }

    @NativeType(value="unsigned char **")
    public PointerBuffer images(int capacity) {
        return EXRTile.nimages(this.address(), capacity);
    }

    public EXRTile offset_x(int value) {
        EXRTile.noffset_x(this.address(), value);
        return this;
    }

    public EXRTile offset_y(int value) {
        EXRTile.noffset_y(this.address(), value);
        return this;
    }

    public EXRTile level_x(int value) {
        EXRTile.nlevel_x(this.address(), value);
        return this;
    }

    public EXRTile level_y(int value) {
        EXRTile.nlevel_y(this.address(), value);
        return this;
    }

    public EXRTile width(int value) {
        EXRTile.nwidth(this.address(), value);
        return this;
    }

    public EXRTile height(int value) {
        EXRTile.nheight(this.address(), value);
        return this;
    }

    public EXRTile images(@NativeType(value="unsigned char **") PointerBuffer value) {
        EXRTile.nimages(this.address(), value);
        return this;
    }

    public EXRTile set(int offset_x, int offset_y, int level_x, int level_y, int width, int height, PointerBuffer images) {
        this.offset_x(offset_x);
        this.offset_y(offset_y);
        this.level_x(level_x);
        this.level_y(level_y);
        this.width(width);
        this.height(height);
        this.images(images);
        return this;
    }

    public EXRTile set(EXRTile src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static EXRTile malloc() {
        return (EXRTile)EXRTile.wrap(EXRTile.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static EXRTile calloc() {
        return (EXRTile)EXRTile.wrap(EXRTile.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static EXRTile create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (EXRTile)EXRTile.wrap(EXRTile.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static EXRTile create(long address) {
        return (EXRTile)EXRTile.wrap(EXRTile.class, (long)address);
    }

    @Nullable
    public static EXRTile createSafe(long address) {
        return address == 0L ? null : (EXRTile)EXRTile.wrap(EXRTile.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)EXRTile.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)EXRTile.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)EXRTile.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = EXRTile.__create((int)capacity, (int)SIZEOF);
        return (Buffer)EXRTile.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)EXRTile.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)EXRTile.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static EXRTile mallocStack() {
        return EXRTile.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EXRTile callocStack() {
        return EXRTile.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EXRTile mallocStack(MemoryStack stack) {
        return EXRTile.malloc(stack);
    }

    @Deprecated
    public static EXRTile callocStack(MemoryStack stack) {
        return EXRTile.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return EXRTile.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return EXRTile.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EXRTile.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EXRTile.calloc(capacity, stack);
    }

    public static EXRTile malloc(MemoryStack stack) {
        return (EXRTile)EXRTile.wrap(EXRTile.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static EXRTile calloc(MemoryStack stack) {
        return (EXRTile)EXRTile.wrap(EXRTile.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)EXRTile.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)EXRTile.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int noffset_x(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET_X);
    }

    public static int noffset_y(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET_Y);
    }

    public static int nlevel_x(long struct) {
        return UNSAFE.getInt(null, struct + (long)LEVEL_X);
    }

    public static int nlevel_y(long struct) {
        return UNSAFE.getInt(null, struct + (long)LEVEL_Y);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static PointerBuffer nimages(long struct, int capacity) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)IMAGES)), (int)capacity);
    }

    public static void noffset_x(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OFFSET_X, value);
    }

    public static void noffset_y(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OFFSET_Y, value);
    }

    public static void nlevel_x(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LEVEL_X, value);
    }

    public static void nlevel_y(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LEVEL_Y, value);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    public static void nimages(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)IMAGES), (long)MemoryUtil.memAddress((CustomBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)IMAGES)));
    }

    static {
        Struct.Layout layout = EXRTile.__struct((Struct.Member[])new Struct.Member[]{EXRTile.__member((int)4), EXRTile.__member((int)4), EXRTile.__member((int)4), EXRTile.__member((int)4), EXRTile.__member((int)4), EXRTile.__member((int)4), EXRTile.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET_X = layout.offsetof(0);
        OFFSET_Y = layout.offsetof(1);
        LEVEL_X = layout.offsetof(2);
        LEVEL_Y = layout.offsetof(3);
        WIDTH = layout.offsetof(4);
        HEIGHT = layout.offsetof(5);
        IMAGES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<EXRTile, Buffer>
    implements NativeResource {
        private static final EXRTile ELEMENT_FACTORY = EXRTile.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected EXRTile getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int offset_x() {
            return EXRTile.noffset_x(this.address());
        }

        public int offset_y() {
            return EXRTile.noffset_y(this.address());
        }

        public int level_x() {
            return EXRTile.nlevel_x(this.address());
        }

        public int level_y() {
            return EXRTile.nlevel_y(this.address());
        }

        public int width() {
            return EXRTile.nwidth(this.address());
        }

        public int height() {
            return EXRTile.nheight(this.address());
        }

        @NativeType(value="unsigned char **")
        public PointerBuffer images(int capacity) {
            return EXRTile.nimages(this.address(), capacity);
        }

        public Buffer offset_x(int value) {
            EXRTile.noffset_x(this.address(), value);
            return this;
        }

        public Buffer offset_y(int value) {
            EXRTile.noffset_y(this.address(), value);
            return this;
        }

        public Buffer level_x(int value) {
            EXRTile.nlevel_x(this.address(), value);
            return this;
        }

        public Buffer level_y(int value) {
            EXRTile.nlevel_y(this.address(), value);
            return this;
        }

        public Buffer width(int value) {
            EXRTile.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(int value) {
            EXRTile.nheight(this.address(), value);
            return this;
        }

        public Buffer images(@NativeType(value="unsigned char **") PointerBuffer value) {
            EXRTile.nimages(this.address(), value);
            return this;
        }
    }
}

