/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;

public class OsmJsonReader
extends AbstractReader {
    protected JsonParser parser;

    protected OsmJsonReader() {
    }

    protected void setParser(JsonParser parser) {
        this.parser = parser;
    }

    protected void parse() throws IllegalDataException {
        while (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            if (event != JsonParser.Event.START_OBJECT) continue;
            this.parseRoot(this.parser.getObject());
        }
        this.parser.close();
    }

    private void parseRoot(JsonObject object) throws IllegalDataException {
        this.parseVersion(((JsonValue)object.get("version")).toString());
        this.parseDownloadPolicy("download", object.getString("download", null));
        this.parseUploadPolicy("upload", object.getString("upload", null));
        this.parseLocked(object.getString("locked", null));
        this.parseElements(object.getJsonArray("elements"));
        this.parseRemark(object.getString("remark", null));
    }

    private void parseRemark(String remark) {
        this.ds.setRemark(remark);
    }

    private void parseElements(JsonArray jsonArray) throws IllegalDataException {
        for (JsonValue value : jsonArray) {
            if (value instanceof JsonObject) {
                JsonObject item = (JsonObject)value;
                switch (item.getString("type")) {
                    case "node": {
                        this.parseNode(item);
                        break;
                    }
                    case "way": {
                        this.parseWay(item);
                        break;
                    }
                    case "relation": {
                        this.parseRelation(item);
                        break;
                    }
                    default: {
                        this.parseUnknown(item);
                        break;
                    }
                }
                continue;
            }
            throw new IllegalDataException("Unexpected JSON item: " + value);
        }
    }

    private void readCommon(JsonObject item, PrimitiveData current) throws IllegalDataException {
        try {
            this.parseId(current, item.getJsonNumber("id").longValue());
            this.parseTimestamp(current, item.getString("timestamp", null));
            JsonNumber uid = item.getJsonNumber("uid");
            if (uid != null) {
                this.parseUser(current, item.getString("user", null), uid.longValue());
            }
            this.parseVisible(current, item.getString("visible", null));
            JsonNumber version = item.getJsonNumber("version");
            if (version != null) {
                this.parseVersion(current, version.intValue());
            }
            this.parseAction(current, item.getString("action", null));
            JsonNumber changeset = item.getJsonNumber("changeset");
            if (changeset != null) {
                this.parseChangeset(current, changeset.intValue());
            }
        }
        catch (UncheckedParseException e) {
            throw new IllegalDataException(e);
        }
    }

    private static void readTags(JsonObject item, Tagged t) {
        JsonObject tags = item.getJsonObject("tags");
        if (tags != null) {
            for (Map.Entry entry : tags.entrySet()) {
                t.put((String)entry.getKey(), ((JsonString)entry.getValue()).getString());
            }
        }
    }

    private void parseNode(JsonObject item) throws IllegalDataException {
        this.parseNode(item.getJsonNumber("lat").doubleValue(), item.getJsonNumber("lon").doubleValue(), (PrimitiveData nd) -> this.readCommon(item, nd), (Node n) -> OsmJsonReader.readTags(item, n));
    }

    private void parseWay(JsonObject item) throws IllegalDataException {
        this.parseWay(wd -> this.readCommon(item, wd), (w, nodeIds) -> OsmJsonReader.readWayNodesAndTags(item, w, nodeIds));
    }

    private static void readWayNodesAndTags(JsonObject item, Way w, Collection<Long> nodeIds) {
        for (JsonValue v : item.getJsonArray("nodes")) {
            nodeIds.add(((JsonNumber)v).longValue());
        }
        OsmJsonReader.readTags(item, w);
    }

    private void parseRelation(JsonObject item) throws IllegalDataException {
        this.parseRelation(rd -> this.readCommon(item, rd), (r, members) -> this.readRelationMembersAndTags(item, r, members));
    }

    private void readRelationMembersAndTags(JsonObject item, Relation r, Collection<RelationMemberData> members) throws IllegalDataException {
        for (JsonValue v : item.getJsonArray("members")) {
            JsonObject o = v.asJsonObject();
            members.add(this.parseRelationMember(r, ((JsonNumber)o.get("ref")).longValue(), o.getString("type"), o.getString("role")));
        }
        OsmJsonReader.readTags(item, r);
    }

    protected void parseUnknown(JsonObject element, boolean printWarning) {
        if (printWarning) {
            Logging.info(I18n.tr("Undefined element ''{0}'' found in input stream. Skipping.", element));
        }
    }

    private void parseUnknown(JsonObject element) {
        this.parseUnknown(element, true);
    }

    @Override
    protected DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return this.doParseDataSet(source, progressMonitor, ir -> {
            this.setParser(Json.createParser(ir));
            this.parse();
        });
    }

    public static DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return new OsmJsonReader().doParseDataSet(source, progressMonitor);
    }
}

