/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11FrameType;
import org.pcap4j.util.ByteArrays;

public final class Dot11FrameControl
implements Serializable {
    private static final long serialVersionUID = -5402534865955179413L;
    private final ProtocolVersion protocolVersion;
    private final Dot11FrameType type;
    private final boolean toDs;
    private final boolean fromDs;
    private final boolean moreFragments;
    private final boolean retry;
    private final boolean powerManagement;
    private final boolean moreData;
    private final boolean protectedFrame;
    private final boolean order;

    public static Dot11FrameControl newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11FrameControl(rawData, offset, length);
    }

    private Dot11FrameControl(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 2) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a Dot11FrameControl (").append(2).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        byte firstByte = rawData[offset];
        switch (firstByte & 3) {
            case 0: {
                this.protocolVersion = ProtocolVersion.V0;
                break;
            }
            case 1: {
                this.protocolVersion = ProtocolVersion.V1;
                break;
            }
            case 2: {
                this.protocolVersion = ProtocolVersion.V2;
                break;
            }
            case 3: {
                this.protocolVersion = ProtocolVersion.V3;
                break;
            }
            default: {
                throw new AssertionError((Object)"Never get here.");
            }
        }
        this.type = Dot11FrameType.getInstance((byte)(firstByte << 2 & 0x30 | firstByte >> 4 & 0xF));
        byte secondByte = rawData[offset + 1];
        this.toDs = (secondByte & 1) != 0;
        this.fromDs = (secondByte & 2) != 0;
        this.moreFragments = (secondByte & 4) != 0;
        this.retry = (secondByte & 8) != 0;
        this.powerManagement = (secondByte & 0x10) != 0;
        this.moreData = (secondByte & 0x20) != 0;
        this.protectedFrame = (secondByte & 0x40) != 0;
        this.order = (secondByte & 0x80) != 0;
    }

    private Dot11FrameControl(Builder builder2) {
        if (builder2 == null || builder2.protocolVersion == null || builder2.type == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder").append(builder2).append(" builder.protocolVersion: ").append((Object)builder2.protocolVersion).append(" builder.type: ").append(builder2.type);
            throw new NullPointerException(sb.toString());
        }
        this.protocolVersion = builder2.protocolVersion;
        this.type = builder2.type;
        this.toDs = builder2.toDs;
        this.fromDs = builder2.fromDs;
        this.moreFragments = builder2.moreFragments;
        this.retry = builder2.retry;
        this.powerManagement = builder2.powerManagement;
        this.moreData = builder2.moreData;
        this.protectedFrame = builder2.protectedFrame;
        this.order = builder2.order;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public Dot11FrameType getType() {
        return this.type;
    }

    public boolean isToDs() {
        return this.toDs;
    }

    public boolean isFromDs() {
        return this.fromDs;
    }

    public boolean isMoreFragments() {
        return this.moreFragments;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public boolean isPowerManagement() {
        return this.powerManagement;
    }

    public boolean isMoreData() {
        return this.moreData;
    }

    public boolean isProtectedFrame() {
        return this.protectedFrame;
    }

    public boolean isOrder() {
        return this.order;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public byte[] getRawData() {
        byte[] data = new byte[2];
        data[0] = (byte)(data[0] | this.protocolVersion.value);
        data[0] = (byte)(data[0] | this.type.getType().getValue() << 2);
        data[0] = (byte)(data[0] | (Byte)this.type.value() << 4);
        if (this.toDs) {
            data[1] = (byte)(data[1] | 1);
        }
        if (this.fromDs) {
            data[1] = (byte)(data[1] | 2);
        }
        if (this.moreFragments) {
            data[1] = (byte)(data[1] | 4);
        }
        if (this.retry) {
            data[1] = (byte)(data[1] | 8);
        }
        if (this.powerManagement) {
            data[1] = (byte)(data[1] | 0x10);
        }
        if (this.moreData) {
            data[1] = (byte)(data[1] | 0x20);
        }
        if (this.protectedFrame) {
            data[1] = (byte)(data[1] | 0x40);
        }
        if (this.order) {
            data[1] = (byte)(data[1] | 0x80);
        }
        return data;
    }

    public int length() {
        return 2;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Protocol Version: ").append((Object)this.protocolVersion).append(ls).append(indent).append("Type/Subtype: ").append(this.type).append(ls).append(indent).append("To DS: ").append(this.toDs).append(ls).append(indent).append("From DS: ").append(this.fromDs).append(ls).append(indent).append("More Fragments: ").append(this.moreFragments).append(ls).append(indent).append("Retry: ").append(this.retry).append(ls).append(indent).append("Power Management: ").append(this.powerManagement).append(ls).append(indent).append("More Data: ").append(this.moreData).append(ls).append(indent).append("Protected Frame: ").append(this.protectedFrame).append(ls).append(indent).append("Order: ").append(this.order).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fromDs ? 1231 : 1237);
        result = 31 * result + (this.moreData ? 1231 : 1237);
        result = 31 * result + (this.moreFragments ? 1231 : 1237);
        result = 31 * result + (this.order ? 1231 : 1237);
        result = 31 * result + (this.powerManagement ? 1231 : 1237);
        result = 31 * result + (this.protectedFrame ? 1231 : 1237);
        result = 31 * result + (this.protocolVersion == null ? 0 : this.protocolVersion.hashCode());
        result = 31 * result + (this.retry ? 1231 : 1237);
        result = 31 * result + (this.toDs ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dot11FrameControl other = (Dot11FrameControl)obj;
        if (this.fromDs != other.fromDs) {
            return false;
        }
        if (this.moreData != other.moreData) {
            return false;
        }
        if (this.moreFragments != other.moreFragments) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        if (this.powerManagement != other.powerManagement) {
            return false;
        }
        if (this.protectedFrame != other.protectedFrame) {
            return false;
        }
        if (this.protocolVersion != other.protocolVersion) {
            return false;
        }
        if (this.retry != other.retry) {
            return false;
        }
        if (this.toDs != other.toDs) {
            return false;
        }
        return this.type.equals(other.type);
    }

    public static enum ProtocolVersion {
        V0(0),
        V1(1),
        V2(2),
        V3(3);

        private final int value;

        private ProtocolVersion(int value2) {
            this.value = value2;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static final class Builder {
        private ProtocolVersion protocolVersion;
        private Dot11FrameType type;
        private boolean toDs;
        private boolean fromDs;
        private boolean moreFragments;
        private boolean retry;
        private boolean powerManagement;
        private boolean moreData;
        private boolean protectedFrame;
        private boolean order;

        public Builder() {
        }

        private Builder(Dot11FrameControl obj) {
            this.protocolVersion = obj.protocolVersion;
            this.type = obj.type;
            this.toDs = obj.toDs;
            this.fromDs = obj.fromDs;
            this.moreFragments = obj.moreFragments;
            this.retry = obj.retry;
            this.powerManagement = obj.powerManagement;
            this.moreData = obj.moreData;
            this.protectedFrame = obj.protectedFrame;
            this.order = obj.order;
        }

        public Builder protocolVersion(ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder type(Dot11FrameType type) {
            this.type = type;
            return this;
        }

        public Builder toDs(boolean toDs) {
            this.toDs = toDs;
            return this;
        }

        public Builder fromDs(boolean fromDs) {
            this.fromDs = fromDs;
            return this;
        }

        public Builder moreFragments(boolean moreFragments) {
            this.moreFragments = moreFragments;
            return this;
        }

        public Builder retry(boolean retry) {
            this.retry = retry;
            return this;
        }

        public Builder powerManagement(boolean powerManagement) {
            this.powerManagement = powerManagement;
            return this;
        }

        public Builder moreData(boolean moreData) {
            this.moreData = moreData;
            return this;
        }

        public Builder protectedFrame(boolean protectedFrame) {
            this.protectedFrame = protectedFrame;
            return this;
        }

        public Builder order(boolean order) {
            this.order = order;
            return this;
        }

        public Dot11FrameControl build() {
            return new Dot11FrameControl(this);
        }
    }
}

