/*
 * Decompiled with CFR 0.152.
 */
package javolution.io;

import java.io.IOException;
import java.io.Reader;
import javolution.lang.MathLib;
import javolution.lang.Reusable;
import javolution.text.CharArray;
import javolution.text.Text;
import javolution.text.TextBuilder;

public final class CharSequenceReader
extends Reader
implements Reusable {
    private CharSequence _input;
    private int _index;

    public CharSequenceReader setInput(CharSequence charSequence) {
        if (this._input != null) {
            throw new IllegalStateException("Reader not closed or reset");
        }
        this._input = charSequence;
        return this;
    }

    public boolean ready() throws IOException {
        if (this._input == null) {
            throw new IOException("Reader closed");
        }
        return true;
    }

    public void close() throws IOException {
        if (this._input != null) {
            this.reset();
        }
    }

    public int read() throws IOException {
        if (this._input == null) {
            throw new IOException("Reader closed");
        }
        return this._index < this._input.length() ? (int)this._input.charAt(this._index++) : -1;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this._input == null) {
            throw new IOException("Reader closed");
        }
        int n3 = this._input.length();
        if (this._index >= n3) {
            return -1;
        }
        int n4 = MathLib.min(n3 - this._index, n2);
        CharSequence charSequence = this._input;
        if (charSequence instanceof String) {
            String string = (String)charSequence;
            string.getChars(this._index, this._index + n4, cArray, n);
        } else if (charSequence instanceof Text) {
            Text text = (Text)charSequence;
            text.getChars(this._index, this._index + n4, cArray, n);
        } else if (charSequence instanceof TextBuilder) {
            TextBuilder textBuilder = (TextBuilder)charSequence;
            textBuilder.getChars(this._index, this._index + n4, cArray, n);
        } else if (charSequence instanceof CharArray) {
            CharArray charArray = (CharArray)charSequence;
            System.arraycopy(charArray.array(), this._index + charArray.offset(), cArray, n, n4);
        } else {
            int n5 = n;
            int n6 = n + n4;
            int n7 = this._index;
            while (n5 < n6) {
                cArray[n5++] = this._input.charAt(n7++);
            }
        }
        this._index += n4;
        return n4;
    }

    public void read(Appendable appendable) throws IOException {
        if (this._input == null) {
            throw new IOException("Reader closed");
        }
        appendable.append(this._input);
    }

    public void reset() {
        this._index = 0;
        this._input = null;
    }
}

