/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Comparator;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;

public final class ResourceType
extends FreeColSpecObjectType {
    public static final String TAG = "resource-type";
    private int maxValue;
    private int minValue;
    private static final String MAXIMUM_VALUE_TAG = "maximum-value";
    private static final String MINIMUM_VALUE_TAG = "minimum-value";

    public ResourceType(String id, Specification specification) {
        super(id, specification);
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public GoodsType getBestGoodsType() {
        Specification spec = this.getSpecification();
        Comparator<Modifier> comp = CollectionUtils.cachingDoubleComparator(m -> (double)spec.getInitialPrice(spec.getGoodsType(m.getId())) * (double)m.applyTo(100.0f));
        Modifier best = CollectionUtils.maximize(this.getModifiers(), comp);
        return best == null ? null : spec.getGoodsType(best.getId());
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        ResourceType o = this.copyInCast(other, ResourceType.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.maxValue = o.getMaxValue();
        this.minValue = o.getMinValue();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.maxValue > -1) {
            xw.writeAttribute(MAXIMUM_VALUE_TAG, this.maxValue);
            xw.writeAttribute(MINIMUM_VALUE_TAG, this.minValue);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.maxValue = xr.getAttribute(MAXIMUM_VALUE_TAG, -1);
        this.minValue = xr.getAttribute(MINIMUM_VALUE_TAG, -1);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

