%% -*- mode: erlang; indent-tabs-mode: nil -*-
%% Copyright (c) 2013-2021 Robert Virding
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%% Unless required by applicable law or agreed to in writing, software
%% distributed under the License is distributed on an "AS IS" BASIS,
%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License.

{application, lfe,
 [{description, "Lisp Flavored Erlang (LFE)"},
  {vsn, "2.1.4"},
  {modules,[cl,clj,lfe,lfe_abstract_code,lfe_bits,lfe_codegen,
            lfe_codelift,lfe_comp,lfe_docs,lfe_edlin_expand,
            lfe_env,lfe_eval,lfe_eval_bits,lfe_gen,lfe_init,
            lfe_internal,lfe_io,lfe_io_format,lfe_io_pretty,
            lfe_io_write,lfe_lib,lfe_lint,lfe_macro,
            lfe_macro_export,lfe_macro_include,lfe_macro_record,
            lfe_macro_struct,lfe_ms,lfe_parse,lfe_qlc,lfe_scan,
            lfe_shell,lfe_shell_docs,lfe_struct,lfe_translate,
            lfe_types,lfescript,scm]},
  {registered, []},
  {applications, [kernel,stdlib,compiler]},

  %% Project metadata
  {licenses, ["Apache 2.0"]},
  {links, [{"Github", "https://github.com/lfe/lfe"},
           {"Main site", "https://lfe.io/"},
           {"Documentation", "https://lfe.io/use/#reference"}]},
  {files, ["README.md", "LICENSE", "src", "c_src", "include", "bin",
           "rebar.*",  "*akefile", "*.escript"]}
 ]}.
