/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.message;

import com.amazonaws.services.sns.message.SnsMessage;
import com.amazonaws.services.sns.message.SnsMessageHandler;
import com.amazonaws.services.sns.message.Utils;
import com.amazonaws.services.sns.model.ConfirmSubscriptionResult;
import java.net.URL;
import org.apache.http.client.HttpClient;

public final class SnsUnsubscribeConfirmation
extends SnsMessage {
    private final HttpClient httpClient;
    private final String message;
    private final URL subscribeUrl;
    private final String token;

    private SnsUnsubscribeConfirmation(Builder builder) {
        super(builder);
        this.httpClient = builder.httpClient;
        this.message = builder.message;
        this.subscribeUrl = Utils.createUrl(builder.subscribeUrl);
        this.token = builder.token;
    }

    public String getMessage() {
        return this.message;
    }

    public URL getSubscribeUrl() {
        return this.subscribeUrl;
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public void handle(SnsMessageHandler handler) {
        handler.handle(this);
    }

    public ConfirmSubscriptionResult reconfirmSubscription() {
        return Utils.confirmSubscription(this.httpClient, this.subscribeUrl.toExternalForm());
    }

    public static Builder builder(HttpClient httpClient) {
        return new Builder(httpClient);
    }

    public static final class Builder
    extends SnsMessage.Builder<Builder> {
        private final HttpClient httpClient;
        private String message;
        private String subscribeUrl;
        private String token;

        private Builder(HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withSubscribeUrl(String subscribeUrl) {
            this.subscribeUrl = subscribeUrl;
            return this;
        }

        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @Override
        public SnsUnsubscribeConfirmation build() {
            return new SnsUnsubscribeConfirmation(this);
        }
    }
}

