/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

import biz.paluch.logging.gelf.intern.OutputAccessor;
import java.util.Map;

class JsonWriter {
    private static final byte[] NULL = "null".getBytes();
    private static final byte[] TRUE = "true".getBytes();
    private static final byte[] FALSE = "false".getBytes();
    private static final byte[] B = "\\b".getBytes();
    private static final byte[] T = "\\t".getBytes();
    private static final byte[] N = "\\n".getBytes();
    private static final byte[] F = "\\f".getBytes();
    private static final byte[] R = "\\r".getBytes();
    private static final byte[] QUOT = "\\\"".getBytes();
    private static final byte[] BSLASH = "\\\\".getBytes();
    private static final byte[] Q_AND_C = "\":".getBytes();
    private static final byte[] NaN = "NaN".getBytes();
    private static final byte[] Infinite = "Infinite".getBytes();
    private static final byte WRITE_UTF_UNKNOWN = 63;
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();
    private static final byte[] HEX_BYTES;

    private JsonWriter() {
    }

    public static void writeObjectStart(OutputAccessor out) {
        out.write(123);
    }

    public static void writeObjectEnd(OutputAccessor out) {
        out.write(125);
    }

    public static void writeKeyValueSeparator(OutputAccessor out) {
        out.write(44);
    }

    public static void toJSONString(OutputAccessor out, Map<String, ? extends Object> map) {
        JsonWriter.writeObjectStart(out);
        boolean first = true;
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                JsonWriter.writeKeyValueSeparator(out);
            }
            JsonWriter.writeMapEntry(out, entry.getKey(), entry.getValue());
        }
        JsonWriter.writeObjectEnd(out);
    }

    public static void writeMapEntry(OutputAccessor out, String key, Object value) {
        out.write(34);
        if (key == null) {
            out.write(NULL);
        } else {
            JsonWriter.writeUtf8(out, key);
        }
        out.write(Q_AND_C);
        JsonWriter.toJSONString(out, value);
    }

    private static void toJSONString(OutputAccessor out, Object value) {
        if (value == null) {
            out.write(NULL);
            return;
        }
        if (value instanceof String) {
            out.write(34);
            JsonWriter.writeUtf8(out, (String)value);
            out.write(34);
            return;
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            if (d.isNaN()) {
                out.write(34);
                out.write(NaN);
                out.write(34);
            } else if (d.isInfinite()) {
                out.write(34);
                if (d == Double.NEGATIVE_INFINITY) {
                    out.write(45);
                }
                out.write(Infinite);
                out.write(34);
            } else {
                JsonWriter.writeAscii(out, value.toString());
            }
            return;
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            if (f.isNaN()) {
                out.write(34);
                out.write(NaN);
                out.write(34);
            } else if (f.isInfinite()) {
                out.write(34);
                if (f.floatValue() == Float.NEGATIVE_INFINITY) {
                    out.write(45);
                }
                out.write(Infinite);
                out.write(34);
            } else {
                JsonWriter.writeAscii(out, value.toString());
            }
            return;
        }
        if (value instanceof Number) {
            JsonWriter.writeAscii(out, value.toString());
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                out.write(TRUE);
            } else {
                out.write(FALSE);
            }
        }
    }

    private static void writeUtf8(OutputAccessor out, String string) {
        JsonWriter.writeUtf8(out, string, string.length());
    }

    private static void writeAscii(OutputAccessor out, CharSequence seq) {
        for (int i = 0; i < seq.length(); ++i) {
            out.write((byte)seq.charAt(i));
        }
    }

    private static void writeUtf8(OutputAccessor out, CharSequence seq, int len) {
        block11: for (int i = 0; i < len; ++i) {
            char c = seq.charAt(i);
            switch (c) {
                case '\b': {
                    out.write(B);
                    continue block11;
                }
                case '\t': {
                    out.write(T);
                    continue block11;
                }
                case '\n': {
                    out.write(N);
                    continue block11;
                }
                case '\f': {
                    out.write(F);
                    continue block11;
                }
                case '\r': {
                    out.write(R);
                    continue block11;
                }
                case '\"': {
                    out.write(QUOT);
                    continue block11;
                }
                case '\\': {
                    out.write(BSLASH);
                    continue block11;
                }
                default: {
                    if (c < ' ') {
                        JsonWriter.escape(out, c);
                        continue block11;
                    }
                    if (c < '\u0080') {
                        out.write((byte)c);
                        continue block11;
                    }
                    if (c < '\u0800') {
                        out.write((byte)(0xC0 | c >> 6));
                        out.write((byte)(0x80 | c & 0x3F));
                        continue block11;
                    }
                    if (JsonWriter.isSurrogate(c)) {
                        char c2;
                        if (!Character.isHighSurrogate(c)) {
                            out.write(63);
                            continue block11;
                        }
                        try {
                            c2 = seq.charAt(++i);
                        }
                        catch (IndexOutOfBoundsException e) {
                            out.write(63);
                            break block11;
                        }
                        if (!Character.isLowSurrogate(c2)) {
                            out.write(63);
                            out.write((byte)(Character.isHighSurrogate(c2) ? 63 : (int)c2));
                            continue block11;
                        }
                        int codePoint = Character.toCodePoint(c, c2);
                        JsonWriter.escape(out, c);
                        JsonWriter.escape(out, codePoint);
                        continue block11;
                    }
                    out.write((byte)(0xE0 | c >> 12));
                    out.write((byte)(0x80 | c >> 6 & 0x3F));
                    out.write((byte)(0x80 | c & 0x3F));
                }
            }
        }
    }

    private static void escape(OutputAccessor out, int charToEscape) {
        out.write(92);
        out.write(117);
        if (charToEscape > 255) {
            int hi = charToEscape >> 8 & 0xFF;
            out.write(HEX_BYTES[hi >> 4]);
            out.write(HEX_BYTES[hi & 0xF]);
            charToEscape &= 0xFF;
        } else {
            out.write(48);
            out.write(48);
        }
        out.write(HEX_BYTES[charToEscape >> 4]);
        out.write(HEX_BYTES[charToEscape & 0xF]);
    }

    private static boolean isSurrogate(char c) {
        return c >= '\ud800' && c <= '\udfff';
    }

    static {
        int len = HEX_CHARS.length;
        HEX_BYTES = new byte[len];
        for (int i = 0; i < len; ++i) {
            JsonWriter.HEX_BYTES[i] = (byte)HEX_CHARS[i];
        }
    }
}

