/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.codehaus.xfire.util.Resolver;
import org.codehaus.xfire.wsdl.WSDLWriter;

public class ResourceWSDL
implements WSDLWriter {
    private URL wsdlUrl;
    private String wsdlString;
    private String baseString;

    public ResourceWSDL(String wsdlUrl) throws IOException {
        this.wsdlString = wsdlUrl;
        this.baseString = "";
    }

    public ResourceWSDL(String baseUri, String wsdlUrl) throws IOException {
        this.wsdlString = wsdlUrl;
        this.baseString = baseUri;
    }

    public ResourceWSDL(URL wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
    }

    public void write(OutputStream out) throws IOException {
        InputStream is = this.wsdlUrl != null ? this.wsdlUrl.openStream() : new Resolver(this.baseString, this.wsdlString).getInputStream();
        this.copy(is, out, 8096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        try {
            int n;
            byte[] buffer = new byte[bufferSize];
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
        }
        finally {
            input.close();
        }
    }
}

