/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.ReverseArrayIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SequenceExtent
extends Value
implements GroundedValue {
    private Item[] value;
    private int start = 0;
    private int end;
    private ItemType itemType = null;

    public SequenceExtent(Item[] items) {
        this.value = items;
        this.end = items.length;
    }

    public SequenceExtent(Item[] value, int start, int length) {
        this.value = value;
        this.start = start;
        this.end = this.start + length;
    }

    public SequenceExtent(SequenceExtent ext, int start, int length) {
        this.value = ext.value;
        this.start = ext.start + start;
        this.end = this.start + length;
    }

    public SequenceExtent(List<? extends Item> list) {
        Item[] array = new Item[list.size()];
        this.value = list.toArray(array);
        this.end = this.value.length;
    }

    public SequenceExtent(SequenceIterator iter) throws XPathException {
        if ((iter.getProperties() & 2) == 0) {
            Item it;
            ArrayList<Item> list = new ArrayList<Item>(20);
            while ((it = iter.next()) != null) {
                list.add(it);
            }
            Item[] array = new Item[list.size()];
            this.value = list.toArray(array);
            this.end = this.value.length;
        } else {
            Item it;
            this.end = ((LastPositionFinder)((Object)iter)).getLastPosition();
            this.value = new Item[this.end];
            int i = 0;
            while ((it = iter.next()) != null) {
                this.value[i++] = it;
            }
        }
    }

    public static ValueRepresentation makeSequenceExtent(SequenceIterator iter) throws XPathException {
        if ((iter.getProperties() & 1) != 0) {
            return ((GroundedIterator)iter).materialize();
        }
        SequenceExtent extent = new SequenceExtent(iter);
        int len = ((Value)extent).getLength();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            return ((Value)extent).itemAt(0);
        }
        return extent;
    }

    public static ValueRepresentation makeSequenceExtent(List<Item> input) throws XPathException {
        int len = input.size();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            return input.get(0);
        }
        return new SequenceExtent(input);
    }

    public Value simplify() {
        int n = this.getLength();
        if (n == 0) {
            return EmptySequence.getInstance();
        }
        if (n == 1) {
            return Value.asValue(this.itemAt(0));
        }
        return this;
    }

    @Override
    public Value reduce() {
        return this.simplify();
    }

    @Override
    public int getLength() {
        return this.end - this.start;
    }

    @Override
    public int getCardinality() {
        switch (this.end - this.start) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
        }
        return 49152;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.itemType != null) {
            return this.itemType;
        }
        if (this.end == this.start) {
            this.itemType = AnyItemType.getInstance();
        } else {
            this.itemType = Type.getItemType(this.value[this.start], th);
            for (int i = this.start + 1; i < this.end; ++i) {
                if (this.itemType == AnyItemType.getInstance()) {
                    return this.itemType;
                }
                this.itemType = Type.getCommonSuperType(this.itemType, Type.getItemType(this.value[i], th), th);
            }
        }
        return this.itemType;
    }

    @Override
    public Item itemAt(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        return this.value[this.start + n];
    }

    public void swap(int a, int b) {
        Item temp = this.value[this.start + a];
        this.value[this.start + a] = this.value[this.start + b];
        this.value[this.start + b] = temp;
    }

    @Override
    public SequenceIterator iterate() {
        return new ArrayIterator(this.value, this.start, this.end);
    }

    public UnfailingIterator reverseIterate() {
        return new ReverseArrayIterator(this.value, this.start, this.end);
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        int len = this.getLength();
        if (len == 0) {
            return false;
        }
        if (this.value[this.start] instanceof NodeInfo) {
            return true;
        }
        if (len > 1) {
            return ExpressionTool.effectiveBooleanValue(this.iterate());
        }
        return ((AtomicValue)this.value[this.start]).effectiveBooleanValue();
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        int newEnd;
        if (start < 0) {
            start = 0;
        } else if (start >= this.end) {
            return EmptySequence.getInstance();
        }
        int newStart = this.start + start;
        if (length == Integer.MAX_VALUE) {
            newEnd = this.end;
        } else {
            if (length < 0) {
                return EmptySequence.getInstance();
            }
            newEnd = newStart + length;
            if (newEnd > this.end) {
                newEnd = this.end;
            }
        }
        return new SequenceExtent(this.value, newStart, newEnd - newStart);
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        fsb.append('(');
        for (int i = this.start; i < this.end; ++i) {
            fsb.append(this.value[i].toString());
            if (i == this.end - 1) continue;
            fsb.append(", ");
        }
        fsb.append(')');
        return fsb.toString();
    }
}

