/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.util;

import java.lang.reflect.Array;

public class ByteSwapper {
    public static void swap(Object array) {
        Class<?> arrayType = array.getClass().getComponentType();
        if (arrayType.isPrimitive()) {
            if (arrayType == Boolean.TYPE) {
                return;
            }
            if (arrayType == Byte.TYPE) {
                return;
            }
            if (arrayType == Character.TYPE) {
                return;
            }
            if (arrayType == Short.TYPE) {
                ByteSwapper.swapShortArray(array);
            } else if (arrayType == Integer.TYPE) {
                ByteSwapper.swapIntegerArray(array);
            } else if (arrayType == Long.TYPE) {
                ByteSwapper.swapLongArray(array);
            } else if (arrayType == Float.TYPE) {
                ByteSwapper.swapFloatArray(array);
            } else if (arrayType == Double.TYPE) {
                ByteSwapper.swapDoubleArray(array);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void swapDoubleArray(Object array) {
        int len = Array.getLength(array);
        int n = 0;
        while (n < len) {
            void dtmp;
            double d = Array.getDouble(array, n);
            long l = Double.doubleToLongBits(d);
            long l2 = l >> 0 & 0xFFL;
            long l3 = l >> 8 & 0xFFL;
            long l4 = l >> 16 & 0xFFL;
            long l5 = l >> 24 & 0xFFL;
            long l6 = l >> 32 & 0xFFL;
            long l7 = l >> 40 & 0xFFL;
            long l8 = l >> 48 & 0xFFL;
            long l9 = l >> 56 & 0xFFL;
            l = l2 << 56 | l3 << 48 | l4 << 40 | l5 << 32 | l6 << 24 | l7 << 16 | l8 << 8 | l9 << 0;
            d = Double.longBitsToDouble(l);
            Array.setDouble(array, (int)dtmp, d);
            ++dtmp;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void swapFloatArray(Object array) {
        int len = Array.getLength(array);
        int n = 0;
        while (n < len) {
            void ftmp;
            void b4;
            void b3;
            void b2;
            int b1;
            float f = Array.getFloat(array, n);
            int n2 = Float.floatToIntBits(f);
            int n3 = n2 >> 0 & 0xFF;
            int n4 = b1 >> 8 & 0xFF;
            int n5 = b1 >> 16 & 0xFF;
            int i = b1 >> 24 & 0xFF;
            b1 = b2 << 24 | b3 << 16 | b4 << 8 | i << 0;
            float tmp = Float.intBitsToFloat(b1);
            Array.setFloat(array, (int)ftmp, tmp);
            ++ftmp;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void swapIntegerArray(Object array) {
        int len = Array.getLength(array);
        int n = 0;
        while (n < len) {
            void tmp;
            void b4;
            void b3;
            void b2;
            int b1;
            int n2 = Array.getInt(array, n);
            int n3 = n2 >> 0 & 0xFF;
            int n4 = b1 >> 8 & 0xFF;
            int n5 = b1 >> 16 & 0xFF;
            int i = b1 >> 24 & 0xFF;
            b1 = b2 << 24 | b3 << 16 | b4 << 8 | i << 0;
            Array.setInt(array, (int)tmp, b1);
            ++tmp;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void swapLongArray(Object array) {
        int len = Array.getLength(array);
        int n = 0;
        while (n < len) {
            void tmp;
            long l = Array.getLong(array, n);
            long l2 = l >> 0 & 0xFFL;
            long l3 = l >> 8 & 0xFFL;
            long l4 = l >> 16 & 0xFFL;
            long l5 = l >> 24 & 0xFFL;
            long l6 = l >> 32 & 0xFFL;
            long l7 = l >> 40 & 0xFFL;
            long l8 = l >> 48 & 0xFFL;
            long l9 = l >> 56 & 0xFFL;
            l = l2 << 56 | l3 << 48 | l4 << 40 | l5 << 32 | l6 << 24 | l7 << 16 | l8 << 8 | l9 << 0;
            Array.setLong(array, (int)tmp, l);
            ++tmp;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void swapShortArray(Object array) {
        int len = Array.getLength(array);
        int n = 0;
        while (n < len) {
            void tmp;
            void b2;
            short b1;
            short s = Array.getShort(array, n);
            int n2 = s >> 0 & 0xFF;
            int i = b1 >> 8 & 0xFF;
            b1 = (short)(b2 << 8 | i << 0);
            Array.setShort(array, (int)tmp, b1);
            ++tmp;
        }
    }
}

