/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class Bindery {
    private ValueRepresentation[] globals;
    private long[] busy;
    private GlobalParameterSet globalParameters;
    private SlotManager globalVariableMap;
    private Map<GlobalVariable, Set<GlobalVariable>> dependencies = new HashMap<GlobalVariable, Set<GlobalVariable>>();
    private boolean applyConversionRules = true;

    public void allocateGlobals(SlotManager map) {
        this.globalVariableMap = map;
        int n = map.getNumberOfVariables() + 1;
        this.globals = new ValueRepresentation[n];
        this.busy = new long[n];
        for (int i = 0; i < n; ++i) {
            this.globals[i] = null;
            this.busy[i] = -1L;
        }
    }

    public void setApplyFunctionConversionRulesToExternalVariables(boolean convert) {
        this.applyConversionRules = convert;
    }

    public boolean isApplyFunctionConversionRulesToExternalVariables() {
        return this.applyConversionRules;
    }

    public void defineGlobalParameters(GlobalParameterSet params) {
        this.globalParameters = params;
    }

    public boolean useGlobalParameter(StructuredQName qName, int slot, SequenceType requiredType, XPathContext context) throws XPathException {
        XPathException err;
        ValueRepresentation val;
        if (this.globals != null && this.globals[slot] != null) {
            return true;
        }
        if (this.globalParameters == null) {
            return false;
        }
        Object obj = this.globalParameters.get(qName);
        if (obj == null) {
            return false;
        }
        if (obj instanceof DocumentInfo) {
            String systemId = ((DocumentInfo)obj).getSystemId();
            try {
                DocumentPool pool;
                if (systemId != null && new URI(systemId).isAbsolute() && (pool = context.getController().getDocumentPool()).find(systemId) == null) {
                    pool.add((DocumentInfo)obj, systemId);
                }
            }
            catch (URISyntaxException err2) {
                // empty catch block
            }
        }
        if (obj instanceof ValueRepresentation) {
            val = (ValueRepresentation)obj;
        } else {
            JPConverter converter = JPConverter.allocate(obj.getClass(), context.getConfiguration());
            val = converter.convert(obj, context);
        }
        if (val == null) {
            val = EmptySequence.getInstance();
        }
        if (this.applyConversionRules) {
            val = Bindery.applyFunctionConversionRules(val, requiredType, context);
        }
        if ((err = TypeChecker.testConformance(val, requiredType, context)) != null) {
            throw err;
        }
        this.globals[slot] = val;
        return true;
    }

    public static Value applyFunctionConversionRules(ValueRepresentation value, SequenceType requiredType, final XPathContext context) throws XPathException {
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        final ItemType requiredItemType = requiredType.getPrimaryType();
        ItemType suppliedItemType = value instanceof NodeInfo ? new NameTest((NodeInfo)value) : ((Value)value).getItemType(th);
        SequenceIterator iterator = Value.asIterator(value);
        if (requiredItemType.isAtomicType()) {
            ItemMappingFunction promoter;
            if (!suppliedItemType.isAtomicType()) {
                iterator = Atomizer.getAtomizingIterator(iterator);
                suppliedItemType = suppliedItemType.getAtomizedItemType();
            }
            if (th.relationship(suppliedItemType, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
                ItemMappingFunction converter = new ItemMappingFunction(){

                    public Item mapItem(Item item) throws XPathException {
                        if (item instanceof UntypedAtomicValue) {
                            ConversionResult val = ((UntypedAtomicValue)item).convert((AtomicType)requiredItemType, true, context.getConfiguration().getConversionRules());
                            if (val instanceof ValidationFailure) {
                                ValidationFailure vex = (ValidationFailure)val;
                                throw vex.makeException();
                            }
                            return (AtomicValue)val;
                        }
                        return item;
                    }
                };
                iterator = new ItemMappingIterator(iterator, converter, true);
            }
            if (requiredItemType.equals(BuiltInAtomicType.DOUBLE)) {
                promoter = new ItemMappingFunction(){

                    public Item mapItem(Item item) throws XPathException {
                        if (item instanceof NumericValue) {
                            return ((AtomicValue)item).convert(BuiltInAtomicType.DOUBLE, true, context.getConfiguration().getConversionRules()).asAtomic();
                        }
                        throw new XPathException("Cannot promote non-numeric value to xs:double", "XPTY0004", context);
                    }
                };
                iterator = new ItemMappingIterator(iterator, promoter, true);
            } else if (requiredItemType.equals(BuiltInAtomicType.FLOAT)) {
                promoter = new ItemMappingFunction(){

                    public Item mapItem(Item item) throws XPathException {
                        if (item instanceof DoubleValue) {
                            throw new XPathException("Cannot promote xs:double value to xs:float", "XPTY0004", context);
                        }
                        if (item instanceof NumericValue) {
                            return ((AtomicValue)item).convert(BuiltInAtomicType.FLOAT, true, context.getConfiguration().getConversionRules()).asAtomic();
                        }
                        throw new XPathException("Cannot promote non-numeric value to xs:float", "XPTY0004", context);
                    }
                };
                iterator = new ItemMappingIterator(iterator, promoter, true);
            }
            if (requiredItemType.equals(BuiltInAtomicType.STRING) && th.relationship(suppliedItemType, BuiltInAtomicType.ANY_URI) != 4) {
                promoter = new ItemMappingFunction(){

                    public Item mapItem(Item item) throws XPathException {
                        if (item instanceof AnyURIValue) {
                            return new StringValue(item.getStringValueCS());
                        }
                        return item;
                    }
                };
                iterator = new ItemMappingIterator(iterator, promoter, true);
            }
        }
        return Value.asValue(SequenceExtent.makeSequenceExtent(iterator));
    }

    public void defineGlobalVariable(GlobalVariable binding, ValueRepresentation value) {
        this.globals[binding.getSlotNumber()] = value;
    }

    public boolean setExecuting(GlobalVariable binding) throws XPathException {
        long thisThread = Thread.currentThread().getId();
        int slot = binding.getSlotNumber();
        long busyThread = this.busy[slot];
        if (busyThread != -1L) {
            if (busyThread == thisThread) {
                throw new XPathException.Circularity("Circular definition of variable " + binding.getVariableQName().getDisplayName());
            }
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(20 * i);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.busy[slot] != -1L) continue;
                return false;
            }
            return true;
        }
        this.busy[slot] = thisThread;
        return true;
    }

    public void setNotExecuting(GlobalVariable binding) {
        int slot = binding.getSlotNumber();
        this.busy[slot] = -1L;
    }

    public synchronized ValueRepresentation saveGlobalVariableValue(GlobalVariable binding, ValueRepresentation value) {
        int slot = binding.getSlotNumber();
        if (this.globals[slot] != null) {
            return this.globals[slot];
        }
        this.busy[slot] = -1L;
        this.globals[slot] = value;
        return value;
    }

    public ValueRepresentation getGlobalVariableValue(GlobalVariable binding) {
        return this.globals[binding.getSlotNumber()];
    }

    public ValueRepresentation getGlobalVariable(int slot) {
        return this.globals[slot];
    }

    public void setGlobalVariable(int slot, ValueRepresentation value) {
        this.globals[slot] = value;
    }

    public void assignGlobalVariable(GlobalVariable binding, ValueRepresentation value) {
        this.defineGlobalVariable(binding, value);
    }

    public SlotManager getGlobalVariableMap() {
        return this.globalVariableMap;
    }

    public ValueRepresentation[] getGlobalVariables() {
        return this.globals;
    }

    public synchronized void registerDependency(GlobalVariable one, GlobalVariable two) throws XPathException {
        Set<GlobalVariable> existingDependencies;
        if (one == two) {
            throw new XPathException.Circularity("Circular dependency among global variables: " + one.getVariableQName().getDisplayName() + " depends on its own value");
        }
        Set<GlobalVariable> transitiveDependencies = this.dependencies.get(two);
        if (transitiveDependencies != null) {
            if (transitiveDependencies.contains(one)) {
                throw new XPathException.Circularity("Circular dependency among variables: " + one.getVariableQName().getDisplayName() + " depends on the value of " + two.getVariableQName().getDisplayName() + ", which depends directly or indirectly on the value of " + one.getVariableQName().getDisplayName());
            }
            for (GlobalVariable var : transitiveDependencies) {
                this.registerDependency(one, var);
            }
        }
        if ((existingDependencies = this.dependencies.get(one)) == null) {
            existingDependencies = new HashSet<GlobalVariable>();
            this.dependencies.put(one, existingDependencies);
        }
        existingDependencies.add(two);
    }
}

