/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventStackIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;

public class BracketedElementIterator
implements EventIterator {
    private StartElementEvent start;
    private EventIterator content;
    private PullEvent pendingContent;
    private EndElementEvent end;
    private int state = 0;
    private static final int INITIAL_STATE = 0;
    private static final int PROCESSING_FIRST_CHILD = 1;
    private static final int PROCESSING_REMAINING_CHILDREN = 2;
    private static final int REACHED_END_TAG = 3;
    private static final int EXHAUSTED = 4;

    public BracketedElementIterator(StartElementEvent start, EventIterator content, EndElementEvent end) {
        this.start = start;
        this.content = EventStackIterator.flatten(content);
        this.end = end;
        this.state = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public PullEvent next() throws XPathException {
        block12: {
            PullEvent pe;
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 2;
                    return this.pendingContent;
                }
                case 2: {
                    PullEvent pe2 = this.content.next();
                    if (pe2 == null) {
                        this.state = 4;
                        return this.end;
                    }
                    return pe2;
                }
                case 3: {
                    this.state = 4;
                    return this.end;
                }
                case 4: {
                    return null;
                }
                default: {
                    throw new AssertionError((Object)("BracketedEventIterator state " + this.state));
                }
            }
            while (true) {
                if ((pe = this.content.next()) == null) {
                    this.pendingContent = null;
                    this.state = 3;
                    break block12;
                }
                if (!(pe instanceof NodeInfo)) break;
                int k = ((NodeInfo)pe).getNodeKind();
                if (k == 13) {
                    NamePool pool = ((NodeInfo)pe).getNamePool();
                    int nscode = pool.allocateNamespaceCode(((NodeInfo)pe).getLocalPart(), ((NodeInfo)pe).getStringValue());
                    this.start.addNamespace(nscode);
                    continue;
                }
                if (k == 2) {
                    this.start.addAttribute((NodeInfo)pe);
                    continue;
                }
                if (k != 3 || ((NodeInfo)pe).getStringValueCS().length() != 0) break;
            }
            this.pendingContent = pe;
            this.state = 1;
        }
        this.start.namespaceFixup();
        return this.start;
    }

    public boolean isFlatSequence() {
        return true;
    }
}

