case RISCVVector::BI__builtin_rvv_vget_v:
  PolicyAttrs = 3;
IsMasked = false;

      {
        if (isa<StructType>(Ops[0]->getType())) // For tuple type
          // Extract value from index (operand 1) of vtuple (operand 0)
          return Builder.CreateExtractValue(
            Ops[0],
            {(unsigned)cast<ConstantInt>(Ops[1])->getZExtValue()});
        auto *VecTy = cast<ScalableVectorType>(ResultType);
        auto *OpVecTy = cast<ScalableVectorType>(Ops[0]->getType());
        // Mask to only valid indices.
        unsigned MaxIndex = OpVecTy->getMinNumElements() / VecTy->getMinNumElements();
        assert(isPowerOf2_32(MaxIndex));
        Ops[1] = Builder.CreateZExt(Ops[1], Builder.getInt64Ty());
        Ops[1] = Builder.CreateAnd(Ops[1], MaxIndex - 1);
        Ops[1] = Builder.CreateMul(Ops[1],
                                   ConstantInt::get(Ops[1]->getType(),
                                                    VecTy->getMinNumElements()));
        return Builder.CreateExtractVector(ResultType, Ops[0], Ops[1]);
      }
      break;
case RISCVVector::BI__builtin_rvv_vset_v:
  PolicyAttrs = 3;
IsMasked = false;

      {
        if (isa<StructType>(ResultType)) // For tuple type
          // Insert value (operand 2) into index (operand 1) of vtuple (operand 0)
          return Builder.CreateInsertValue(
            Ops[0], Ops[2],
            {(unsigned)cast<ConstantInt>(Ops[1])->getZExtValue()});
        auto *ResVecTy = cast<ScalableVectorType>(ResultType);
        auto *VecTy = cast<ScalableVectorType>(Ops[2]->getType());
        // Mask to only valid indices.
        unsigned MaxIndex = ResVecTy->getMinNumElements() / VecTy->getMinNumElements();
        assert(isPowerOf2_32(MaxIndex));
        Ops[1] = Builder.CreateZExt(Ops[1], Builder.getInt64Ty());
        Ops[1] = Builder.CreateAnd(Ops[1], MaxIndex - 1);
        Ops[1] = Builder.CreateMul(Ops[1],
                                   ConstantInt::get(Ops[1]->getType(),
                                                    VecTy->getMinNumElements()));
        return Builder.CreateInsertVector(ResultType, Ops[0], Ops[2], Ops[1]);
      }
      break;
case RISCVVector::BI__builtin_rvv_vlenb:
  PolicyAttrs = 3;
IsMasked = false;

    {
      LLVMContext &Context = CGM.getLLVMContext();
      llvm::MDBuilder MDHelper(Context);

      llvm::Metadata *Ops[] = {llvm::MDString::get(Context, "vlenb")};
      llvm::MDNode *RegName = llvm::MDNode::get(Context, Ops);
      llvm::Value *Metadata = llvm::MetadataAsValue::get(Context, RegName);
      llvm::Function *F =
        CGM.getIntrinsic(llvm::Intrinsic::read_register, {SizeTy});
      return Builder.CreateCall(F, Metadata);
    }
    break;
case RISCVVector::BI__builtin_rvv_vlmul_ext_v:
  PolicyAttrs = 3;
IsMasked = false;

        return Builder.CreateInsertVector(ResultType,
                                          llvm::PoisonValue::get(ResultType),
                                          Ops[0], ConstantInt::get(Int64Ty, 0));
      break;
case RISCVVector::BI__builtin_rvv_vlmul_trunc_v:
  PolicyAttrs = 3;
IsMasked = false;
 {
        return Builder.CreateExtractVector(ResultType, Ops[0],
                                           ConstantInt::get(Int64Ty, 0));
      } break;
case RISCVVector::BI__builtin_rvv_vreinterpret_v:
  PolicyAttrs = 3;
IsMasked = false;

        if (ResultType->isIntOrIntVectorTy(1) ||
            Ops[0]->getType()->isIntOrIntVectorTy(1)) {
          assert(isa<ScalableVectorType>(ResultType) &&
                 isa<ScalableVectorType>(Ops[0]->getType()));

          LLVMContext &Context = CGM.getLLVMContext();
          ScalableVectorType *Boolean64Ty =
              ScalableVectorType::get(llvm::Type::getInt1Ty(Context), 64);

          if (ResultType->isIntOrIntVectorTy(1)) {
            // Casting from m1 vector integer -> vector boolean
            // Ex: <vscale x 8 x i8>
            //     --(bitcast)--------> <vscale x 64 x i1>
            //     --(vector_extract)-> <vscale x  8 x i1>
            llvm::Value *BitCast = Builder.CreateBitCast(Ops[0], Boolean64Ty);
            return Builder.CreateExtractVector(ResultType, BitCast,
                                               ConstantInt::get(Int64Ty, 0));
          } else {
            // Casting from vector boolean -> m1 vector integer
            // Ex: <vscale x  1 x i1>
            //       --(vector_insert)-> <vscale x 64 x i1>
            //       --(bitcast)-------> <vscale x  8 x i8>
            llvm::Value *Boolean64Val =
              Builder.CreateInsertVector(Boolean64Ty,
                                         llvm::PoisonValue::get(Boolean64Ty),
                                         Ops[0],
                                         ConstantInt::get(Int64Ty, 0));
            return Builder.CreateBitCast(Boolean64Val, ResultType);
          }
        }
        return Builder.CreateBitCast(Ops[0], ResultType);
      break;
case RISCVVector::BI__builtin_rvv_vundefined:
  PolicyAttrs = 3;
IsMasked = false;

        return llvm::PoisonValue::get(ResultType);
      break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vaadd_vx_tu:
  ID = Intrinsic::riscv_vaadd;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv:
case RISCVVector::BI__builtin_rvv_vaadd_vx:
  ID = Intrinsic::riscv_vaadd;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vaadd_vx_tum:
  ID = Intrinsic::riscv_vaadd_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_m:
case RISCVVector::BI__builtin_rvv_vaadd_vx_m:
  ID = Intrinsic::riscv_vaadd_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vaadd_vx_tumu:
  ID = Intrinsic::riscv_vaadd_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vaadd_vx_mu:
  ID = Intrinsic::riscv_vaadd_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_tu:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_tu:
  ID = Intrinsic::riscv_vaaddu;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv:
case RISCVVector::BI__builtin_rvv_vaaddu_vx:
  ID = Intrinsic::riscv_vaaddu;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_tum:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_tum:
  ID = Intrinsic::riscv_vaaddu_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_m:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_m:
  ID = Intrinsic::riscv_vaaddu_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_tumu:
  ID = Intrinsic::riscv_vaaddu_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_mu:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_mu:
  ID = Intrinsic::riscv_vaaddu_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vadc_vvm_tu:
case RISCVVector::BI__builtin_rvv_vadc_vxm_tu:
  ID = Intrinsic::riscv_vadc;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadc_vvm:
case RISCVVector::BI__builtin_rvv_vadc_vxm:
  ID = Intrinsic::riscv_vadc;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vadd_vx_tu:
  ID = Intrinsic::riscv_vadd;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv:
case RISCVVector::BI__builtin_rvv_vadd_vx:
  ID = Intrinsic::riscv_vadd;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vadd_vx_tum:
  ID = Intrinsic::riscv_vadd_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_m:
case RISCVVector::BI__builtin_rvv_vadd_vx_m:
  ID = Intrinsic::riscv_vadd_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vadd_vx_tumu:
  ID = Intrinsic::riscv_vadd_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vadd_vx_mu:
  ID = Intrinsic::riscv_vadd_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_tu:
case RISCVVector::BI__builtin_rvv_vand_vx_tu:
  ID = Intrinsic::riscv_vand;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv:
case RISCVVector::BI__builtin_rvv_vand_vx:
  ID = Intrinsic::riscv_vand;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_tum:
case RISCVVector::BI__builtin_rvv_vand_vx_tum:
  ID = Intrinsic::riscv_vand_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_m:
case RISCVVector::BI__builtin_rvv_vand_vx_m:
  ID = Intrinsic::riscv_vand_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_tumu:
case RISCVVector::BI__builtin_rvv_vand_vx_tumu:
  ID = Intrinsic::riscv_vand_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_mu:
case RISCVVector::BI__builtin_rvv_vand_vx_mu:
  ID = Intrinsic::riscv_vand_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vasub_vv_tu:
case RISCVVector::BI__builtin_rvv_vasub_vx_tu:
  ID = Intrinsic::riscv_vasub;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv:
case RISCVVector::BI__builtin_rvv_vasub_vx:
  ID = Intrinsic::riscv_vasub;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv_tum:
case RISCVVector::BI__builtin_rvv_vasub_vx_tum:
  ID = Intrinsic::riscv_vasub_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv_m:
case RISCVVector::BI__builtin_rvv_vasub_vx_m:
  ID = Intrinsic::riscv_vasub_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vasub_vx_tumu:
  ID = Intrinsic::riscv_vasub_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv_mu:
case RISCVVector::BI__builtin_rvv_vasub_vx_mu:
  ID = Intrinsic::riscv_vasub_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_tu:
case RISCVVector::BI__builtin_rvv_vasubu_vx_tu:
  ID = Intrinsic::riscv_vasubu;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv:
case RISCVVector::BI__builtin_rvv_vasubu_vx:
  ID = Intrinsic::riscv_vasubu;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_tum:
case RISCVVector::BI__builtin_rvv_vasubu_vx_tum:
  ID = Intrinsic::riscv_vasubu_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_m:
case RISCVVector::BI__builtin_rvv_vasubu_vx_m:
  ID = Intrinsic::riscv_vasubu_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vasubu_vx_tumu:
  ID = Intrinsic::riscv_vasubu_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_mu:
case RISCVVector::BI__builtin_rvv_vasubu_vx_mu:
  ID = Intrinsic::riscv_vasubu_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(), Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vcompress_vm_tu:
  ID = Intrinsic::riscv_vcompress;
  PolicyAttrs = 2;
IsMasked = false;

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vcompress_vm:
  ID = Intrinsic::riscv_vcompress;
  PolicyAttrs = 3;
IsMasked = false;

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vcpop_m:
  ID = Intrinsic::riscv_vcpop;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_m_m:
  ID = Intrinsic::riscv_vcpop_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_tu:
case RISCVVector::BI__builtin_rvv_vdiv_vx_tu:
  ID = Intrinsic::riscv_vdiv;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv:
case RISCVVector::BI__builtin_rvv_vdiv_vx:
  ID = Intrinsic::riscv_vdiv;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_tum:
case RISCVVector::BI__builtin_rvv_vdiv_vx_tum:
  ID = Intrinsic::riscv_vdiv_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_m:
case RISCVVector::BI__builtin_rvv_vdiv_vx_m:
  ID = Intrinsic::riscv_vdiv_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_tumu:
case RISCVVector::BI__builtin_rvv_vdiv_vx_tumu:
  ID = Intrinsic::riscv_vdiv_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_mu:
case RISCVVector::BI__builtin_rvv_vdiv_vx_mu:
  ID = Intrinsic::riscv_vdiv_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_tu:
case RISCVVector::BI__builtin_rvv_vdivu_vx_tu:
  ID = Intrinsic::riscv_vdivu;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv:
case RISCVVector::BI__builtin_rvv_vdivu_vx:
  ID = Intrinsic::riscv_vdivu;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_tum:
case RISCVVector::BI__builtin_rvv_vdivu_vx_tum:
  ID = Intrinsic::riscv_vdivu_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_m:
case RISCVVector::BI__builtin_rvv_vdivu_vx_m:
  ID = Intrinsic::riscv_vdivu_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vdivu_vx_tumu:
  ID = Intrinsic::riscv_vdivu_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_mu:
case RISCVVector::BI__builtin_rvv_vdivu_vx_mu:
  ID = Intrinsic::riscv_vdivu_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_tu:
  ID = Intrinsic::riscv_vfadd;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm:
case RISCVVector::BI__builtin_rvv_vfadd_vv:
case RISCVVector::BI__builtin_rvv_vfadd_vf:
  ID = Intrinsic::riscv_vfadd;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vfadd_vf_tum:
  ID = Intrinsic::riscv_vfadd_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfadd_vv_m:
case RISCVVector::BI__builtin_rvv_vfadd_vf_m:
  ID = Intrinsic::riscv_vfadd_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_tumu:
  ID = Intrinsic::riscv_vfadd_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_mu:
  ID = Intrinsic::riscv_vfadd_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfclass_v_tu:
  ID = Intrinsic::riscv_vfclass;
  PolicyAttrs = 2;
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v:
  ID = Intrinsic::riscv_vfclass;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v_tum:
  ID = Intrinsic::riscv_vfclass_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v_m:
  ID = Intrinsic::riscv_vfclass_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v_tumu:
  ID = Intrinsic::riscv_vfclass_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v_mu:
  ID = Intrinsic::riscv_vfclass_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_tu:
  ID = Intrinsic::riscv_vfcvt_f_x_v;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v:
  ID = Intrinsic::riscv_vfcvt_f_x_v;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_tum:
  ID = Intrinsic::riscv_vfcvt_f_x_v_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_m:
  ID = Intrinsic::riscv_vfcvt_f_x_v_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_tumu:
  ID = Intrinsic::riscv_vfcvt_f_x_v_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_mu:
  ID = Intrinsic::riscv_vfcvt_f_x_v_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_tu:
  ID = Intrinsic::riscv_vfcvt_f_xu_v;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v:
  ID = Intrinsic::riscv_vfcvt_f_xu_v;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_tum:
  ID = Intrinsic::riscv_vfcvt_f_xu_v_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_m:
  ID = Intrinsic::riscv_vfcvt_f_xu_v_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_tumu:
  ID = Intrinsic::riscv_vfcvt_f_xu_v_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_mu:
  ID = Intrinsic::riscv_vfcvt_f_xu_v_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_tu:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_tum:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_m:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_tumu:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_mu:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_tu:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_tum:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_m:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_tumu:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_mu:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_tu:
  ID = Intrinsic::riscv_vfcvt_x_f_v;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v:
  ID = Intrinsic::riscv_vfcvt_x_f_v;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_tum:
  ID = Intrinsic::riscv_vfcvt_x_f_v_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_m:
  ID = Intrinsic::riscv_vfcvt_x_f_v_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_tumu:
  ID = Intrinsic::riscv_vfcvt_x_f_v_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_mu:
  ID = Intrinsic::riscv_vfcvt_x_f_v_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_tu:
  ID = Intrinsic::riscv_vfcvt_xu_f_v;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v:
  ID = Intrinsic::riscv_vfcvt_xu_f_v;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_tum:
  ID = Intrinsic::riscv_vfcvt_xu_f_v_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_m:
  ID = Intrinsic::riscv_vfcvt_xu_f_v_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_tumu:
  ID = Intrinsic::riscv_vfcvt_xu_f_v_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_mu:
  ID = Intrinsic::riscv_vfcvt_xu_f_v_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_tu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_tu:
  ID = Intrinsic::riscv_vfdiv;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm:
case RISCVVector::BI__builtin_rvv_vfdiv_vv:
case RISCVVector::BI__builtin_rvv_vfdiv_vf:
  ID = Intrinsic::riscv_vfdiv;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_tum:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_tum:
  ID = Intrinsic::riscv_vfdiv_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_m:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_m:
  ID = Intrinsic::riscv_vfdiv_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_tumu:
  ID = Intrinsic::riscv_vfdiv_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_mu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_mu:
  ID = Intrinsic::riscv_vfdiv_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfirst_m:
  ID = Intrinsic::riscv_vfirst;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfirst_m_m:
  ID = Intrinsic::riscv_vfirst_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_tu:
  ID = Intrinsic::riscv_vfmacc;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmacc_vv:
case RISCVVector::BI__builtin_rvv_vfmacc_vf:
  ID = Intrinsic::riscv_vfmacc;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_tum:
  ID = Intrinsic::riscv_vfmacc_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_m:
  ID = Intrinsic::riscv_vfmacc_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_tumu:
  ID = Intrinsic::riscv_vfmacc_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_mu:
  ID = Intrinsic::riscv_vfmacc_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_tu:
  ID = Intrinsic::riscv_vfmadd;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmadd_vv:
case RISCVVector::BI__builtin_rvv_vfmadd_vf:
  ID = Intrinsic::riscv_vfmadd;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_tum:
  ID = Intrinsic::riscv_vfmadd_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_m:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_m:
  ID = Intrinsic::riscv_vfmadd_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_tumu:
  ID = Intrinsic::riscv_vfmadd_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_mu:
  ID = Intrinsic::riscv_vfmadd_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmax_vf_tu:
  ID = Intrinsic::riscv_vfmax;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv:
case RISCVVector::BI__builtin_rvv_vfmax_vf:
  ID = Intrinsic::riscv_vfmax;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmax_vf_tum:
  ID = Intrinsic::riscv_vfmax_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_m:
case RISCVVector::BI__builtin_rvv_vfmax_vf_m:
  ID = Intrinsic::riscv_vfmax_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmax_vf_tumu:
  ID = Intrinsic::riscv_vfmax_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmax_vf_mu:
  ID = Intrinsic::riscv_vfmax_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmerge_vfm_tu:
  ID = Intrinsic::riscv_vfmerge;
  PolicyAttrs = 2;
IsMasked = false;

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vfmerge_vfm:
  ID = Intrinsic::riscv_vfmerge;
  PolicyAttrs = 3;
IsMasked = false;

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmin_vf_tu:
  ID = Intrinsic::riscv_vfmin;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv:
case RISCVVector::BI__builtin_rvv_vfmin_vf:
  ID = Intrinsic::riscv_vfmin;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmin_vf_tum:
  ID = Intrinsic::riscv_vfmin_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_m:
case RISCVVector::BI__builtin_rvv_vfmin_vf_m:
  ID = Intrinsic::riscv_vfmin_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmin_vf_tumu:
  ID = Intrinsic::riscv_vfmin_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmin_vf_mu:
  ID = Intrinsic::riscv_vfmin_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_tu:
  ID = Intrinsic::riscv_vfmsac;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmsac_vv:
case RISCVVector::BI__builtin_rvv_vfmsac_vf:
  ID = Intrinsic::riscv_vfmsac;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_tum:
  ID = Intrinsic::riscv_vfmsac_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_m:
  ID = Intrinsic::riscv_vfmsac_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_tumu:
  ID = Intrinsic::riscv_vfmsac_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_mu:
  ID = Intrinsic::riscv_vfmsac_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_tu:
  ID = Intrinsic::riscv_vfmsub;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmsub_vv:
case RISCVVector::BI__builtin_rvv_vfmsub_vf:
  ID = Intrinsic::riscv_vfmsub;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_tum:
  ID = Intrinsic::riscv_vfmsub_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_m:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_m:
  ID = Intrinsic::riscv_vfmsub_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_tumu:
  ID = Intrinsic::riscv_vfmsub_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_mu:
  ID = Intrinsic::riscv_vfmsub_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmul_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_tu:
  ID = Intrinsic::riscv_vfmul;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmul_vv:
case RISCVVector::BI__builtin_rvv_vfmul_vf:
  ID = Intrinsic::riscv_vfmul;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmul_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmul_vf_tum:
  ID = Intrinsic::riscv_vfmul_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmul_vv_m:
case RISCVVector::BI__builtin_rvv_vfmul_vf_m:
  ID = Intrinsic::riscv_vfmul_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmul_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_tumu:
  ID = Intrinsic::riscv_vfmul_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmul_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_mu:
  ID = Intrinsic::riscv_vfmul_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfmv_f_s:
  ID = Intrinsic::riscv_vfmv_f_s;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmv_s_f_tu:
case RISCVVector::BI__builtin_rvv_vfmv_s_x_tu:
  ID = Intrinsic::riscv_vfmv_s_f;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmv_s_f:
case RISCVVector::BI__builtin_rvv_vfmv_s_x:
  ID = Intrinsic::riscv_vfmv_s_f;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmv_v_f_tu:
  ID = Intrinsic::riscv_vfmv_v_f;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmv_v_f:
  ID = Intrinsic::riscv_vfmv_v_f;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_f_f_w;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w:
  ID = Intrinsic::riscv_vfncvt_f_f_w;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_f_f_w_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_m:
  ID = Intrinsic::riscv_vfncvt_f_f_w_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_f_f_w_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_f_f_w_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_tu:
  ID = Intrinsic::riscv_vfncvt_f_x_w;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w:
  ID = Intrinsic::riscv_vfncvt_f_x_w;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_tum:
  ID = Intrinsic::riscv_vfncvt_f_x_w_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_m:
  ID = Intrinsic::riscv_vfncvt_f_x_w_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_tumu:
  ID = Intrinsic::riscv_vfncvt_f_x_w_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_mu:
  ID = Intrinsic::riscv_vfncvt_f_x_w_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_tu:
  ID = Intrinsic::riscv_vfncvt_f_xu_w;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w:
  ID = Intrinsic::riscv_vfncvt_f_xu_w;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_tum:
  ID = Intrinsic::riscv_vfncvt_f_xu_w_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_m:
  ID = Intrinsic::riscv_vfncvt_f_xu_w_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_tumu:
  ID = Intrinsic::riscv_vfncvt_f_xu_w_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_mu:
  ID = Intrinsic::riscv_vfncvt_f_xu_w_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_m:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_m:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_m:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_x_f_w;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w:
  ID = Intrinsic::riscv_vfncvt_x_f_w;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_x_f_w_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_m:
  ID = Intrinsic::riscv_vfncvt_x_f_w_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_x_f_w_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_x_f_w_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_xu_f_w;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w:
  ID = Intrinsic::riscv_vfncvt_xu_f_w;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_xu_f_w_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_m:
  ID = Intrinsic::riscv_vfncvt_xu_f_w_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_xu_f_w_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_xu_f_w_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_tu:
  ID = Intrinsic::riscv_vfnmacc;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf:
  ID = Intrinsic::riscv_vfnmacc;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_tum:
  ID = Intrinsic::riscv_vfnmacc_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_m:
  ID = Intrinsic::riscv_vfnmacc_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_tumu:
  ID = Intrinsic::riscv_vfnmacc_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_mu:
  ID = Intrinsic::riscv_vfnmacc_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_tu:
  ID = Intrinsic::riscv_vfnmadd;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf:
  ID = Intrinsic::riscv_vfnmadd;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_tum:
  ID = Intrinsic::riscv_vfnmadd_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_m:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_m:
  ID = Intrinsic::riscv_vfnmadd_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_tumu:
  ID = Intrinsic::riscv_vfnmadd_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_mu:
  ID = Intrinsic::riscv_vfnmadd_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_tu:
  ID = Intrinsic::riscv_vfnmsac;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf:
  ID = Intrinsic::riscv_vfnmsac;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_tum:
  ID = Intrinsic::riscv_vfnmsac_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_m:
  ID = Intrinsic::riscv_vfnmsac_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_tumu:
  ID = Intrinsic::riscv_vfnmsac_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_mu:
  ID = Intrinsic::riscv_vfnmsac_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_tu:
  ID = Intrinsic::riscv_vfnmsub;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf:
  ID = Intrinsic::riscv_vfnmsub;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_tum:
  ID = Intrinsic::riscv_vfnmsub_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_m:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_m:
  ID = Intrinsic::riscv_vfnmsub_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_tumu:
  ID = Intrinsic::riscv_vfnmsub_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_mu:
  ID = Intrinsic::riscv_vfnmsub_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_tu:
  ID = Intrinsic::riscv_vfrdiv;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf:
  ID = Intrinsic::riscv_vfrdiv;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_tum:
  ID = Intrinsic::riscv_vfrdiv_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_m:
  ID = Intrinsic::riscv_vfrdiv_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_tumu:
  ID = Intrinsic::riscv_vfrdiv_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_mu:
  ID = Intrinsic::riscv_vfrdiv_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfrec7_v_tu:
  ID = Intrinsic::riscv_vfrec7;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm:
case RISCVVector::BI__builtin_rvv_vfrec7_v:
  ID = Intrinsic::riscv_vfrec7;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfrec7_v_tum:
  ID = Intrinsic::riscv_vfrec7_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfrec7_v_m:
  ID = Intrinsic::riscv_vfrec7_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfrec7_v_tumu:
  ID = Intrinsic::riscv_vfrec7_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfrec7_v_mu:
  ID = Intrinsic::riscv_vfrec7_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredmax_vs_tu:
  ID = Intrinsic::riscv_vfredmax;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmax_vs:
  ID = Intrinsic::riscv_vfredmax;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmax_vs_tum:
  ID = Intrinsic::riscv_vfredmax_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmax_vs_m:
  ID = Intrinsic::riscv_vfredmax_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmin_vs_tu:
  ID = Intrinsic::riscv_vfredmin;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmin_vs:
  ID = Intrinsic::riscv_vfredmin;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmin_vs_tum:
  ID = Intrinsic::riscv_vfredmin_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmin_vs_m:
  ID = Intrinsic::riscv_vfredmin_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredosum_vs_rm_tu:
case RISCVVector::BI__builtin_rvv_vfredosum_vs_tu:
  ID = Intrinsic::riscv_vfredosum;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredosum_vs_rm:
case RISCVVector::BI__builtin_rvv_vfredosum_vs:
  ID = Intrinsic::riscv_vfredosum;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredosum_vs_rm_tum:
case RISCVVector::BI__builtin_rvv_vfredosum_vs_tum:
  ID = Intrinsic::riscv_vfredosum_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredosum_vs_rm_m:
case RISCVVector::BI__builtin_rvv_vfredosum_vs_m:
  ID = Intrinsic::riscv_vfredosum_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredusum_vs_rm_tu:
case RISCVVector::BI__builtin_rvv_vfredusum_vs_tu:
  ID = Intrinsic::riscv_vfredusum;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredusum_vs_rm:
case RISCVVector::BI__builtin_rvv_vfredusum_vs:
  ID = Intrinsic::riscv_vfredusum;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredusum_vs_rm_tum:
case RISCVVector::BI__builtin_rvv_vfredusum_vs_tum:
  ID = Intrinsic::riscv_vfredusum_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfredusum_vs_rm_m:
case RISCVVector::BI__builtin_rvv_vfredusum_vs_m:
  ID = Intrinsic::riscv_vfredusum_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_tu:
  ID = Intrinsic::riscv_vfrsqrt7;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v:
  ID = Intrinsic::riscv_vfrsqrt7;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_tum:
  ID = Intrinsic::riscv_vfrsqrt7_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_m:
  ID = Intrinsic::riscv_vfrsqrt7_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_tumu:
  ID = Intrinsic::riscv_vfrsqrt7_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_mu:
  ID = Intrinsic::riscv_vfrsqrt7_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_tu:
  ID = Intrinsic::riscv_vfrsub;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfrsub_vf:
  ID = Intrinsic::riscv_vfrsub;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_tum:
  ID = Intrinsic::riscv_vfrsub_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_m:
  ID = Intrinsic::riscv_vfrsub_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_tumu:
  ID = Intrinsic::riscv_vfrsub_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_mu:
  ID = Intrinsic::riscv_vfrsub_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_tu:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_tu:
  ID = Intrinsic::riscv_vfsgnj;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf:
  ID = Intrinsic::riscv_vfsgnj;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_tum:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_tum:
  ID = Intrinsic::riscv_vfsgnj_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_m:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_m:
  ID = Intrinsic::riscv_vfsgnj_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_tumu:
  ID = Intrinsic::riscv_vfsgnj_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_mu:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_mu:
  ID = Intrinsic::riscv_vfsgnj_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfneg_v_tu:
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 2;
IsMasked = false;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_tu:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_tu:
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfneg_v:
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 3;
IsMasked = false;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf:
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfneg_v_tum:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 2;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_tum:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_tum:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfneg_v_m:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 3;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_m:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_m:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfneg_v_tumu:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 0;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_tumu:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfneg_v_mu:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 1;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_mu:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_mu:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_tu:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_tu:
  ID = Intrinsic::riscv_vfsgnjx;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_tu:
  ID = Intrinsic::riscv_vfsgnjx;
  PolicyAttrs = 2;
IsMasked = false;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf:
  ID = Intrinsic::riscv_vfsgnjx;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v:
  ID = Intrinsic::riscv_vfsgnjx;
  PolicyAttrs = 3;
IsMasked = false;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_tum:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_tum:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_tum:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 2;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_m:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_m:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_m:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 3;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_tumu:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_tumu:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 0;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_mu:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_mu:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_mu:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 1;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.insert(Ops.begin() + 2, Ops[1]);
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[2]->getType(),
                            Ops.back()->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          // op1, po2, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(), Ops[2]->getType()};
          Ops.insert(Ops.begin() + 2, Ops[1]);
          break;
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_tu:
  ID = Intrinsic::riscv_vfslide1down;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf:
  ID = Intrinsic::riscv_vfslide1down;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_tum:
  ID = Intrinsic::riscv_vfslide1down_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_m:
  ID = Intrinsic::riscv_vfslide1down_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_tumu:
  ID = Intrinsic::riscv_vfslide1down_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_mu:
  ID = Intrinsic::riscv_vfslide1down_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_tu:
  ID = Intrinsic::riscv_vfslide1up;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf:
  ID = Intrinsic::riscv_vfslide1up;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_tum:
  ID = Intrinsic::riscv_vfslide1up_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_m:
  ID = Intrinsic::riscv_vfslide1up_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_tumu:
  ID = Intrinsic::riscv_vfslide1up_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_mu:
  ID = Intrinsic::riscv_vfslide1up_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_tu:
  ID = Intrinsic::riscv_vfsqrt;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm:
case RISCVVector::BI__builtin_rvv_vfsqrt_v:
  ID = Intrinsic::riscv_vfsqrt;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_tum:
  ID = Intrinsic::riscv_vfsqrt_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_m:
  ID = Intrinsic::riscv_vfsqrt_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_tumu:
  ID = Intrinsic::riscv_vfsqrt_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_mu:
  ID = Intrinsic::riscv_vfsqrt_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, round_mode, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_tu:
  ID = Intrinsic::riscv_vfsub;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfsub_vv:
case RISCVVector::BI__builtin_rvv_vfsub_vf:
  ID = Intrinsic::riscv_vfsub;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vfsub_vf_tum:
  ID = Intrinsic::riscv_vfsub_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfsub_vv_m:
case RISCVVector::BI__builtin_rvv_vfsub_vf_m:
  ID = Intrinsic::riscv_vfsub_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_tumu:
  ID = Intrinsic::riscv_vfsub_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_mu:
  ID = Intrinsic::riscv_vfsub_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_tu:
  ID = Intrinsic::riscv_vfwadd;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwadd_vv:
case RISCVVector::BI__builtin_rvv_vfwadd_vf:
  ID = Intrinsic::riscv_vfwadd;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_tum:
  ID = Intrinsic::riscv_vfwadd_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_m:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_m:
  ID = Intrinsic::riscv_vfwadd_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_tumu:
  ID = Intrinsic::riscv_vfwadd_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_mu:
  ID = Intrinsic::riscv_vfwadd_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_tu:
  ID = Intrinsic::riscv_vfwadd_w;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm:
case RISCVVector::BI__builtin_rvv_vfwadd_wv:
case RISCVVector::BI__builtin_rvv_vfwadd_wf:
  ID = Intrinsic::riscv_vfwadd_w;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_tum:
  ID = Intrinsic::riscv_vfwadd_w_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_m:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_m:
  ID = Intrinsic::riscv_vfwadd_w_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_tumu:
  ID = Intrinsic::riscv_vfwadd_w_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_mu:
  ID = Intrinsic::riscv_vfwadd_w_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_f_f_v;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v:
  ID = Intrinsic::riscv_vfwcvt_f_f_v;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_f_f_v_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_f_f_v_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_f_f_v_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_f_f_v_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_tu:
  ID = Intrinsic::riscv_vfwcvt_f_x_v;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v:
  ID = Intrinsic::riscv_vfwcvt_f_x_v;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_tum:
  ID = Intrinsic::riscv_vfwcvt_f_x_v_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_m:
  ID = Intrinsic::riscv_vfwcvt_f_x_v_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_f_x_v_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_mu:
  ID = Intrinsic::riscv_vfwcvt_f_x_v_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_tu:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_tum:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_m:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_mu:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_x_f_v;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v:
  ID = Intrinsic::riscv_vfwcvt_x_f_v;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_x_f_v_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_x_f_v_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_x_f_v_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_x_f_v_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, frm, vl)
    // Masked:   (passthru, op0, mask, frm, vl, policy)
    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4) :
      (HasMaskedOff ? Ops.size() == 4 : Ops.size() == 3);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 1]); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 1]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 1]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_tu:
  ID = Intrinsic::riscv_vfwmacc;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf:
  ID = Intrinsic::riscv_vfwmacc;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_tum:
  ID = Intrinsic::riscv_vfwmacc_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_m:
  ID = Intrinsic::riscv_vfwmacc_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_tumu:
  ID = Intrinsic::riscv_vfwmacc_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_mu:
  ID = Intrinsic::riscv_vfwmacc_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_tu:
  ID = Intrinsic::riscv_vfwmsac;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf:
  ID = Intrinsic::riscv_vfwmsac;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_tum:
  ID = Intrinsic::riscv_vfwmsac_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_m:
  ID = Intrinsic::riscv_vfwmsac_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_tumu:
  ID = Intrinsic::riscv_vfwmsac_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_mu:
  ID = Intrinsic::riscv_vfwmsac_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_tu:
  ID = Intrinsic::riscv_vfwmul;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwmul_vv:
case RISCVVector::BI__builtin_rvv_vfwmul_vf:
  ID = Intrinsic::riscv_vfwmul;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_tum:
  ID = Intrinsic::riscv_vfwmul_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_m:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_m:
  ID = Intrinsic::riscv_vfwmul_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_tumu:
  ID = Intrinsic::riscv_vfwmul_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_mu:
  ID = Intrinsic::riscv_vfwmul_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_tu:
  ID = Intrinsic::riscv_vfwnmacc;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf:
  ID = Intrinsic::riscv_vfwnmacc;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_tum:
  ID = Intrinsic::riscv_vfwnmacc_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_m:
  ID = Intrinsic::riscv_vfwnmacc_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_tumu:
  ID = Intrinsic::riscv_vfwnmacc_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_mu:
  ID = Intrinsic::riscv_vfwnmacc_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_tu:
  ID = Intrinsic::riscv_vfwnmsac;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf:
  ID = Intrinsic::riscv_vfwnmsac;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_tum:
  ID = Intrinsic::riscv_vfwnmsac_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_m:
  ID = Intrinsic::riscv_vfwnmsac_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_tumu:
  ID = Intrinsic::riscv_vfwnmsac_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_mu:
  ID = Intrinsic::riscv_vfwnmsac_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasRoundModeOp = IsMasked ? Ops.size() == 6 : Ops.size() == 5;

    unsigned Offset = IsMasked ? 2 : 1;

    Operands.push_back(Ops[IsMasked ? 1 : 0]); // passthrough

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};

    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_tu:
  ID = Intrinsic::riscv_vfwredosum;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_rm:
case RISCVVector::BI__builtin_rvv_vfwredosum_vs:
  ID = Intrinsic::riscv_vfwredosum;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_tum:
  ID = Intrinsic::riscv_vfwredosum_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_rm_m:
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_m:
  ID = Intrinsic::riscv_vfwredosum_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_tu:
  ID = Intrinsic::riscv_vfwredusum;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_rm:
case RISCVVector::BI__builtin_rvv_vfwredusum_vs:
  ID = Intrinsic::riscv_vfwredusum;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_tum:
  ID = Intrinsic::riscv_vfwredusum_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_rm_m:
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_m:
  ID = Intrinsic::riscv_vfwredusum_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_tu:
  ID = Intrinsic::riscv_vfwsub;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwsub_vv:
case RISCVVector::BI__builtin_rvv_vfwsub_vf:
  ID = Intrinsic::riscv_vfwsub;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_tum:
  ID = Intrinsic::riscv_vfwsub_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_m:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_m:
  ID = Intrinsic::riscv_vfwsub_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_tumu:
  ID = Intrinsic::riscv_vfwsub_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_mu:
  ID = Intrinsic::riscv_vfwsub_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_tu:
  ID = Intrinsic::riscv_vfwsub_w;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm:
case RISCVVector::BI__builtin_rvv_vfwsub_wv:
case RISCVVector::BI__builtin_rvv_vfwsub_wf:
  ID = Intrinsic::riscv_vfwsub_w;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_tum:
  ID = Intrinsic::riscv_vfwsub_w_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_m:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_m:
  ID = Intrinsic::riscv_vfwsub_w_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_tumu:
  ID = Intrinsic::riscv_vfwsub_w_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_mu:
  ID = Intrinsic::riscv_vfwsub_w_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, frm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    bool HasRoundModeOp = IsMasked ?
      (HasMaskedOff ? Ops.size() == 6 : Ops.size() == 5) :
      (HasMaskedOff ? Ops.size() == 5 : Ops.size() == 4);

    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    if (HasRoundModeOp) {
      Operands.push_back(Ops[Offset + 2]); // frm
      Operands.push_back(Ops[Offset + 3]); // vl
    } else {
      Operands.push_back(ConstantInt::get(Ops[Offset + 2]->getType(), 7)); // frm
      Operands.push_back(Ops[Offset + 2]); // vl
    }

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset + 1]->getType(),
                      Operands.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vid_v_tu:
  ID = Intrinsic::riscv_vid;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v:
  ID = Intrinsic::riscv_vid;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_tum:
  ID = Intrinsic::riscv_vid_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_m:
  ID = Intrinsic::riscv_vid_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_tumu:
  ID = Intrinsic::riscv_vid_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_mu:
  ID = Intrinsic::riscv_vid_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_tu:
  ID = Intrinsic::riscv_viota;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m:
  ID = Intrinsic::riscv_viota;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_tum:
  ID = Intrinsic::riscv_viota_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_m:
  ID = Intrinsic::riscv_viota_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_tumu:
  ID = Intrinsic::riscv_viota_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_mu:
  ID = Intrinsic::riscv_viota_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_tu:
case RISCVVector::BI__builtin_rvv_vle16_v_tu:
case RISCVVector::BI__builtin_rvv_vle32_v_tu:
case RISCVVector::BI__builtin_rvv_vle64_v_tu:
  ID = Intrinsic::riscv_vle;
  PolicyAttrs = 2;
  Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v:
case RISCVVector::BI__builtin_rvv_vle16_v:
case RISCVVector::BI__builtin_rvv_vle32_v:
case RISCVVector::BI__builtin_rvv_vle64_v:
  ID = Intrinsic::riscv_vle;
  PolicyAttrs = 3;
  Ops[0] = Builder.CreateBitCast(Ops[0], ResultType->getPointerTo());
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_tum:
case RISCVVector::BI__builtin_rvv_vle16_v_tum:
case RISCVVector::BI__builtin_rvv_vle32_v_tum:
case RISCVVector::BI__builtin_rvv_vle64_v_tum:
  ID = Intrinsic::riscv_vle_mask;
  PolicyAttrs = 2;
  Ops[2] = Builder.CreateBitCast(Ops[2], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_m:
case RISCVVector::BI__builtin_rvv_vle16_v_m:
case RISCVVector::BI__builtin_rvv_vle32_v_m:
case RISCVVector::BI__builtin_rvv_vle64_v_m:
  ID = Intrinsic::riscv_vle_mask;
  PolicyAttrs = 3;
  Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_tumu:
case RISCVVector::BI__builtin_rvv_vle16_v_tumu:
case RISCVVector::BI__builtin_rvv_vle32_v_tumu:
case RISCVVector::BI__builtin_rvv_vle64_v_tumu:
  ID = Intrinsic::riscv_vle_mask;
  PolicyAttrs = 0;
  Ops[2] = Builder.CreateBitCast(Ops[2], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_mu:
case RISCVVector::BI__builtin_rvv_vle16_v_mu:
case RISCVVector::BI__builtin_rvv_vle32_v_mu:
case RISCVVector::BI__builtin_rvv_vle64_v_mu:
  ID = Intrinsic::riscv_vle_mask;
  PolicyAttrs = 1;
  Ops[2] = Builder.CreateBitCast(Ops[2], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_tu:
case RISCVVector::BI__builtin_rvv_vle16ff_v_tu:
case RISCVVector::BI__builtin_rvv_vle32ff_v_tu:
case RISCVVector::BI__builtin_rvv_vle64ff_v_tu:
  ID = Intrinsic::riscv_vleff;
  PolicyAttrs = 2;
IsMasked = false;

      {
        if (IsMasked) {
          // Move mask to right before vl.
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          IntrinsicTypes = {ResultType, Ops[4]->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          IntrinsicTypes = {ResultType, Ops[3]->getType()};
        }
        Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
        Value *NewVL = Ops[2];
        Ops.erase(Ops.begin() + 2);
        llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
        llvm::Value *LoadValue = Builder.CreateCall(F, Ops, "");
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {0});
        // Store new_vl.
        clang::CharUnits Align;
        if (IsMasked)
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(E->getNumArgs()-2)->getType());
        else
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(1)->getType());
        llvm::Value *Val = Builder.CreateExtractValue(LoadValue, {1});
        Builder.CreateStore(Val, Address(NewVL, Val->getType(), Align));
        return V;
      }
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v:
case RISCVVector::BI__builtin_rvv_vle16ff_v:
case RISCVVector::BI__builtin_rvv_vle32ff_v:
case RISCVVector::BI__builtin_rvv_vle64ff_v:
  ID = Intrinsic::riscv_vleff;
  PolicyAttrs = 3;
IsMasked = false;

      {
        if (IsMasked) {
          // Move mask to right before vl.
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          IntrinsicTypes = {ResultType, Ops[4]->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          IntrinsicTypes = {ResultType, Ops[3]->getType()};
        }
        Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
        Value *NewVL = Ops[2];
        Ops.erase(Ops.begin() + 2);
        llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
        llvm::Value *LoadValue = Builder.CreateCall(F, Ops, "");
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {0});
        // Store new_vl.
        clang::CharUnits Align;
        if (IsMasked)
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(E->getNumArgs()-2)->getType());
        else
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(1)->getType());
        llvm::Value *Val = Builder.CreateExtractValue(LoadValue, {1});
        Builder.CreateStore(Val, Address(NewVL, Val->getType(), Align));
        return V;
      }
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_tum:
case RISCVVector::BI__builtin_rvv_vle16ff_v_tum:
case RISCVVector::BI__builtin_rvv_vle32ff_v_tum:
case RISCVVector::BI__builtin_rvv_vle64ff_v_tum:
  ID = Intrinsic::riscv_vleff_mask;
  PolicyAttrs = 2;
IsMasked = true;

      {
        if (IsMasked) {
          // Move mask to right before vl.
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          IntrinsicTypes = {ResultType, Ops[4]->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          IntrinsicTypes = {ResultType, Ops[3]->getType()};
        }
        Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
        Value *NewVL = Ops[2];
        Ops.erase(Ops.begin() + 2);
        llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
        llvm::Value *LoadValue = Builder.CreateCall(F, Ops, "");
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {0});
        // Store new_vl.
        clang::CharUnits Align;
        if (IsMasked)
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(E->getNumArgs()-2)->getType());
        else
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(1)->getType());
        llvm::Value *Val = Builder.CreateExtractValue(LoadValue, {1});
        Builder.CreateStore(Val, Address(NewVL, Val->getType(), Align));
        return V;
      }
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_m:
case RISCVVector::BI__builtin_rvv_vle16ff_v_m:
case RISCVVector::BI__builtin_rvv_vle32ff_v_m:
case RISCVVector::BI__builtin_rvv_vle64ff_v_m:
  ID = Intrinsic::riscv_vleff_mask;
  PolicyAttrs = 3;
IsMasked = true;

      {
        if (IsMasked) {
          // Move mask to right before vl.
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          IntrinsicTypes = {ResultType, Ops[4]->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          IntrinsicTypes = {ResultType, Ops[3]->getType()};
        }
        Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
        Value *NewVL = Ops[2];
        Ops.erase(Ops.begin() + 2);
        llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
        llvm::Value *LoadValue = Builder.CreateCall(F, Ops, "");
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {0});
        // Store new_vl.
        clang::CharUnits Align;
        if (IsMasked)
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(E->getNumArgs()-2)->getType());
        else
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(1)->getType());
        llvm::Value *Val = Builder.CreateExtractValue(LoadValue, {1});
        Builder.CreateStore(Val, Address(NewVL, Val->getType(), Align));
        return V;
      }
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vle16ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vle32ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vle64ff_v_tumu:
  ID = Intrinsic::riscv_vleff_mask;
  PolicyAttrs = 0;
IsMasked = true;

      {
        if (IsMasked) {
          // Move mask to right before vl.
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          IntrinsicTypes = {ResultType, Ops[4]->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          IntrinsicTypes = {ResultType, Ops[3]->getType()};
        }
        Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
        Value *NewVL = Ops[2];
        Ops.erase(Ops.begin() + 2);
        llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
        llvm::Value *LoadValue = Builder.CreateCall(F, Ops, "");
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {0});
        // Store new_vl.
        clang::CharUnits Align;
        if (IsMasked)
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(E->getNumArgs()-2)->getType());
        else
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(1)->getType());
        llvm::Value *Val = Builder.CreateExtractValue(LoadValue, {1});
        Builder.CreateStore(Val, Address(NewVL, Val->getType(), Align));
        return V;
      }
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_mu:
case RISCVVector::BI__builtin_rvv_vle16ff_v_mu:
case RISCVVector::BI__builtin_rvv_vle32ff_v_mu:
case RISCVVector::BI__builtin_rvv_vle64ff_v_mu:
  ID = Intrinsic::riscv_vleff_mask;
  PolicyAttrs = 1;
IsMasked = true;

      {
        if (IsMasked) {
          // Move mask to right before vl.
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          IntrinsicTypes = {ResultType, Ops[4]->getType()};
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
          IntrinsicTypes = {ResultType, Ops[3]->getType()};
        }
        Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
        Value *NewVL = Ops[2];
        Ops.erase(Ops.begin() + 2);
        llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
        llvm::Value *LoadValue = Builder.CreateCall(F, Ops, "");
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {0});
        // Store new_vl.
        clang::CharUnits Align;
        if (IsMasked)
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(E->getNumArgs()-2)->getType());
        else
          Align = CGM.getNaturalPointeeTypeAlignment(E->getArg(1)->getType());
        llvm::Value *Val = Builder.CreateExtractValue(LoadValue, {1});
        Builder.CreateStore(Val, Address(NewVL, Val->getType(), Align));
        return V;
      }
      break;
case RISCVVector::BI__builtin_rvv_vlm_v:
  ID = Intrinsic::riscv_vlm;
  PolicyAttrs = 3;
  Ops[0] = Builder.CreateBitCast(Ops[0], ResultType->getPointerTo());
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxei64_v_tu:
  ID = Intrinsic::riscv_vloxei;
  PolicyAttrs = 2;
  Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v:
case RISCVVector::BI__builtin_rvv_vloxei16_v:
case RISCVVector::BI__builtin_rvv_vloxei32_v:
case RISCVVector::BI__builtin_rvv_vloxei64_v:
  ID = Intrinsic::riscv_vloxei;
  PolicyAttrs = 3;
  Ops[0] = Builder.CreateBitCast(Ops[0], ResultType->getPointerTo());
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxei64_v_tum:
  ID = Intrinsic::riscv_vloxei_mask;
  PolicyAttrs = 2;
  Ops[2] = Builder.CreateBitCast(Ops[2], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxei64_v_m:
  ID = Intrinsic::riscv_vloxei_mask;
  PolicyAttrs = 3;
  Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxei64_v_tumu:
  ID = Intrinsic::riscv_vloxei_mask;
  PolicyAttrs = 0;
  Ops[2] = Builder.CreateBitCast(Ops[2], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxei64_v_mu:
  ID = Intrinsic::riscv_vloxei_mask;
  PolicyAttrs = 1;
  Ops[2] = Builder.CreateBitCast(Ops[2], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg2;
  NF = 2;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v:
  ID = Intrinsic::riscv_vloxseg2;
  NF = 2;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg2_mask;
  NF = 2;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_m:
  ID = Intrinsic::riscv_vloxseg2_mask;
  NF = 2;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg2_mask;
  NF = 2;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg2_mask;
  NF = 2;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg3;
  NF = 3;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v:
  ID = Intrinsic::riscv_vloxseg3;
  NF = 3;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg3_mask;
  NF = 3;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_m:
  ID = Intrinsic::riscv_vloxseg3_mask;
  NF = 3;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg3_mask;
  NF = 3;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg3_mask;
  NF = 3;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg4;
  NF = 4;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v:
  ID = Intrinsic::riscv_vloxseg4;
  NF = 4;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg4_mask;
  NF = 4;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_m:
  ID = Intrinsic::riscv_vloxseg4_mask;
  NF = 4;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg4_mask;
  NF = 4;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg4_mask;
  NF = 4;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg5;
  NF = 5;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v:
  ID = Intrinsic::riscv_vloxseg5;
  NF = 5;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg5_mask;
  NF = 5;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_m:
  ID = Intrinsic::riscv_vloxseg5_mask;
  NF = 5;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg5_mask;
  NF = 5;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg5_mask;
  NF = 5;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg6;
  NF = 6;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v:
  ID = Intrinsic::riscv_vloxseg6;
  NF = 6;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg6_mask;
  NF = 6;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_m:
  ID = Intrinsic::riscv_vloxseg6_mask;
  NF = 6;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg6_mask;
  NF = 6;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg6_mask;
  NF = 6;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg7;
  NF = 7;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v:
  ID = Intrinsic::riscv_vloxseg7;
  NF = 7;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg7_mask;
  NF = 7;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_m:
  ID = Intrinsic::riscv_vloxseg7_mask;
  NF = 7;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg7_mask;
  NF = 7;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg7_mask;
  NF = 7;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg8;
  NF = 8;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v:
  ID = Intrinsic::riscv_vloxseg8;
  NF = 8;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg8_mask;
  NF = 8;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_m:
  ID = Intrinsic::riscv_vloxseg8_mask;
  NF = 8;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg8_mask;
  NF = 8;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg8_mask;
  NF = 8;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlse8_v_tu:
case RISCVVector::BI__builtin_rvv_vlse16_v_tu:
case RISCVVector::BI__builtin_rvv_vlse32_v_tu:
case RISCVVector::BI__builtin_rvv_vlse64_v_tu:
  ID = Intrinsic::riscv_vlse;
  PolicyAttrs = 2;
  Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v:
case RISCVVector::BI__builtin_rvv_vlse16_v:
case RISCVVector::BI__builtin_rvv_vlse32_v:
case RISCVVector::BI__builtin_rvv_vlse64_v:
  ID = Intrinsic::riscv_vlse;
  PolicyAttrs = 3;
  Ops[0] = Builder.CreateBitCast(Ops[0], ResultType->getPointerTo());
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v_tum:
case RISCVVector::BI__builtin_rvv_vlse16_v_tum:
case RISCVVector::BI__builtin_rvv_vlse32_v_tum:
case RISCVVector::BI__builtin_rvv_vlse64_v_tum:
  ID = Intrinsic::riscv_vlse_mask;
  PolicyAttrs = 2;
  Ops[2] = Builder.CreateBitCast(Ops[2], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v_m:
case RISCVVector::BI__builtin_rvv_vlse16_v_m:
case RISCVVector::BI__builtin_rvv_vlse32_v_m:
case RISCVVector::BI__builtin_rvv_vlse64_v_m:
  ID = Intrinsic::riscv_vlse_mask;
  PolicyAttrs = 3;
  Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlse16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlse32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlse64_v_tumu:
  ID = Intrinsic::riscv_vlse_mask;
  PolicyAttrs = 0;
  Ops[2] = Builder.CreateBitCast(Ops[2], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v_mu:
case RISCVVector::BI__builtin_rvv_vlse16_v_mu:
case RISCVVector::BI__builtin_rvv_vlse32_v_mu:
case RISCVVector::BI__builtin_rvv_vlse64_v_mu:
  ID = Intrinsic::riscv_vlse_mask;
  PolicyAttrs = 1;
  Ops[2] = Builder.CreateBitCast(Ops[2], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_tu:
  ID = Intrinsic::riscv_vlseg2;
  NF = 2;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v:
case RISCVVector::BI__builtin_rvv_vlseg2e16_v:
case RISCVVector::BI__builtin_rvv_vlseg2e32_v:
case RISCVVector::BI__builtin_rvv_vlseg2e64_v:
  ID = Intrinsic::riscv_vlseg2;
  NF = 2;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_tum:
  ID = Intrinsic::riscv_vlseg2_mask;
  NF = 2;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_m:
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_m:
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_m:
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_m:
  ID = Intrinsic::riscv_vlseg2_mask;
  NF = 2;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_tumu:
  ID = Intrinsic::riscv_vlseg2_mask;
  NF = 2;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_mu:
  ID = Intrinsic::riscv_vlseg2_mask;
  NF = 2;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg2ff;
  NF = 2;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v:
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v:
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v:
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v:
  ID = Intrinsic::riscv_vlseg2ff;
  NF = 2;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  NF = 2;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_m:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  NF = 2;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  NF = 2;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  NF = 2;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_tu:
  ID = Intrinsic::riscv_vlseg3;
  NF = 3;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v:
case RISCVVector::BI__builtin_rvv_vlseg3e16_v:
case RISCVVector::BI__builtin_rvv_vlseg3e32_v:
case RISCVVector::BI__builtin_rvv_vlseg3e64_v:
  ID = Intrinsic::riscv_vlseg3;
  NF = 3;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_tum:
  ID = Intrinsic::riscv_vlseg3_mask;
  NF = 3;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_m:
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_m:
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_m:
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_m:
  ID = Intrinsic::riscv_vlseg3_mask;
  NF = 3;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_tumu:
  ID = Intrinsic::riscv_vlseg3_mask;
  NF = 3;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_mu:
  ID = Intrinsic::riscv_vlseg3_mask;
  NF = 3;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg3ff;
  NF = 3;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v:
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v:
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v:
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v:
  ID = Intrinsic::riscv_vlseg3ff;
  NF = 3;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  NF = 3;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v_m:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  NF = 3;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  NF = 3;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  NF = 3;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg4e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg4e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg4e64_v_tu:
  ID = Intrinsic::riscv_vlseg4;
  NF = 4;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8_v:
case RISCVVector::BI__builtin_rvv_vlseg4e16_v:
case RISCVVector::BI__builtin_rvv_vlseg4e32_v:
case RISCVVector::BI__builtin_rvv_vlseg4e64_v:
  ID = Intrinsic::riscv_vlseg4;
  NF = 4;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg4e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg4e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg4e64_v_tum:
  ID = Intrinsic::riscv_vlseg4_mask;
  NF = 4;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8_v_m:
case RISCVVector::BI__builtin_rvv_vlseg4e16_v_m:
case RISCVVector::BI__builtin_rvv_vlseg4e32_v_m:
case RISCVVector::BI__builtin_rvv_vlseg4e64_v_m:
  ID = Intrinsic::riscv_vlseg4_mask;
  NF = 4;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg4e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg4e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg4e64_v_tumu:
  ID = Intrinsic::riscv_vlseg4_mask;
  NF = 4;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg4e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg4e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg4e64_v_mu:
  ID = Intrinsic::riscv_vlseg4_mask;
  NF = 4;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg4e16ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg4e32ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg4e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg4ff;
  NF = 4;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8ff_v:
case RISCVVector::BI__builtin_rvv_vlseg4e16ff_v:
case RISCVVector::BI__builtin_rvv_vlseg4e32ff_v:
case RISCVVector::BI__builtin_rvv_vlseg4e64ff_v:
  ID = Intrinsic::riscv_vlseg4ff;
  NF = 4;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg4e16ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg4e32ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg4e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  NF = 4;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg4e16ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg4e32ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg4e64ff_v_m:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  NF = 4;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg4e16ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg4e32ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg4e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  NF = 4;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg4e16ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg4e32ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg4e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  NF = 4;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg5e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg5e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg5e64_v_tu:
  ID = Intrinsic::riscv_vlseg5;
  NF = 5;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8_v:
case RISCVVector::BI__builtin_rvv_vlseg5e16_v:
case RISCVVector::BI__builtin_rvv_vlseg5e32_v:
case RISCVVector::BI__builtin_rvv_vlseg5e64_v:
  ID = Intrinsic::riscv_vlseg5;
  NF = 5;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg5e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg5e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg5e64_v_tum:
  ID = Intrinsic::riscv_vlseg5_mask;
  NF = 5;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8_v_m:
case RISCVVector::BI__builtin_rvv_vlseg5e16_v_m:
case RISCVVector::BI__builtin_rvv_vlseg5e32_v_m:
case RISCVVector::BI__builtin_rvv_vlseg5e64_v_m:
  ID = Intrinsic::riscv_vlseg5_mask;
  NF = 5;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg5e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg5e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg5e64_v_tumu:
  ID = Intrinsic::riscv_vlseg5_mask;
  NF = 5;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg5e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg5e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg5e64_v_mu:
  ID = Intrinsic::riscv_vlseg5_mask;
  NF = 5;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg5e16ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg5e32ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg5e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg5ff;
  NF = 5;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8ff_v:
case RISCVVector::BI__builtin_rvv_vlseg5e16ff_v:
case RISCVVector::BI__builtin_rvv_vlseg5e32ff_v:
case RISCVVector::BI__builtin_rvv_vlseg5e64ff_v:
  ID = Intrinsic::riscv_vlseg5ff;
  NF = 5;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg5e16ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg5e32ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg5e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  NF = 5;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg5e16ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg5e32ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg5e64ff_v_m:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  NF = 5;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg5e16ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg5e32ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg5e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  NF = 5;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg5e16ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg5e32ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg5e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  NF = 5;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg6e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg6e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg6e64_v_tu:
  ID = Intrinsic::riscv_vlseg6;
  NF = 6;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8_v:
case RISCVVector::BI__builtin_rvv_vlseg6e16_v:
case RISCVVector::BI__builtin_rvv_vlseg6e32_v:
case RISCVVector::BI__builtin_rvv_vlseg6e64_v:
  ID = Intrinsic::riscv_vlseg6;
  NF = 6;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg6e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg6e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg6e64_v_tum:
  ID = Intrinsic::riscv_vlseg6_mask;
  NF = 6;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8_v_m:
case RISCVVector::BI__builtin_rvv_vlseg6e16_v_m:
case RISCVVector::BI__builtin_rvv_vlseg6e32_v_m:
case RISCVVector::BI__builtin_rvv_vlseg6e64_v_m:
  ID = Intrinsic::riscv_vlseg6_mask;
  NF = 6;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg6e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg6e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg6e64_v_tumu:
  ID = Intrinsic::riscv_vlseg6_mask;
  NF = 6;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg6e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg6e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg6e64_v_mu:
  ID = Intrinsic::riscv_vlseg6_mask;
  NF = 6;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg6e16ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg6e32ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg6e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg6ff;
  NF = 6;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8ff_v:
case RISCVVector::BI__builtin_rvv_vlseg6e16ff_v:
case RISCVVector::BI__builtin_rvv_vlseg6e32ff_v:
case RISCVVector::BI__builtin_rvv_vlseg6e64ff_v:
  ID = Intrinsic::riscv_vlseg6ff;
  NF = 6;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg6e16ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg6e32ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg6e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  NF = 6;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg6e16ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg6e32ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg6e64ff_v_m:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  NF = 6;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg6e16ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg6e32ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg6e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  NF = 6;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg6e16ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg6e32ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg6e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  NF = 6;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg7e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg7e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg7e64_v_tu:
  ID = Intrinsic::riscv_vlseg7;
  NF = 7;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8_v:
case RISCVVector::BI__builtin_rvv_vlseg7e16_v:
case RISCVVector::BI__builtin_rvv_vlseg7e32_v:
case RISCVVector::BI__builtin_rvv_vlseg7e64_v:
  ID = Intrinsic::riscv_vlseg7;
  NF = 7;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg7e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg7e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg7e64_v_tum:
  ID = Intrinsic::riscv_vlseg7_mask;
  NF = 7;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8_v_m:
case RISCVVector::BI__builtin_rvv_vlseg7e16_v_m:
case RISCVVector::BI__builtin_rvv_vlseg7e32_v_m:
case RISCVVector::BI__builtin_rvv_vlseg7e64_v_m:
  ID = Intrinsic::riscv_vlseg7_mask;
  NF = 7;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg7e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg7e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg7e64_v_tumu:
  ID = Intrinsic::riscv_vlseg7_mask;
  NF = 7;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg7e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg7e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg7e64_v_mu:
  ID = Intrinsic::riscv_vlseg7_mask;
  NF = 7;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg7e16ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg7e32ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg7e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg7ff;
  NF = 7;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8ff_v:
case RISCVVector::BI__builtin_rvv_vlseg7e16ff_v:
case RISCVVector::BI__builtin_rvv_vlseg7e32ff_v:
case RISCVVector::BI__builtin_rvv_vlseg7e64ff_v:
  ID = Intrinsic::riscv_vlseg7ff;
  NF = 7;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg7e16ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg7e32ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg7e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  NF = 7;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg7e16ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg7e32ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg7e64ff_v_m:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  NF = 7;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg7e16ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg7e32ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg7e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  NF = 7;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg7e16ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg7e32ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg7e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  NF = 7;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg8e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg8e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg8e64_v_tu:
  ID = Intrinsic::riscv_vlseg8;
  NF = 8;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8_v:
case RISCVVector::BI__builtin_rvv_vlseg8e16_v:
case RISCVVector::BI__builtin_rvv_vlseg8e32_v:
case RISCVVector::BI__builtin_rvv_vlseg8e64_v:
  ID = Intrinsic::riscv_vlseg8;
  NF = 8;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg8e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg8e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg8e64_v_tum:
  ID = Intrinsic::riscv_vlseg8_mask;
  NF = 8;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8_v_m:
case RISCVVector::BI__builtin_rvv_vlseg8e16_v_m:
case RISCVVector::BI__builtin_rvv_vlseg8e32_v_m:
case RISCVVector::BI__builtin_rvv_vlseg8e64_v_m:
  ID = Intrinsic::riscv_vlseg8_mask;
  NF = 8;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg8e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg8e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg8e64_v_tumu:
  ID = Intrinsic::riscv_vlseg8_mask;
  NF = 8;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg8e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg8e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg8e64_v_mu:
  ID = Intrinsic::riscv_vlseg8_mask;
  NF = 8;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 1]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg8e16ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg8e32ff_v_tu:
case RISCVVector::BI__builtin_rvv_vlseg8e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg8ff;
  NF = 8;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8ff_v:
case RISCVVector::BI__builtin_rvv_vlseg8e16ff_v:
case RISCVVector::BI__builtin_rvv_vlseg8e32ff_v:
case RISCVVector::BI__builtin_rvv_vlseg8e64ff_v:
  ID = Intrinsic::riscv_vlseg8ff;
  NF = 8;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg8e16ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg8e32ff_v_tum:
case RISCVVector::BI__builtin_rvv_vlseg8e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  NF = 8;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg8e16ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg8e32ff_v_m:
case RISCVVector::BI__builtin_rvv_vlseg8e64ff_v_m:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  NF = 8;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg8e16ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg8e32ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vlseg8e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  NF = 8;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg8e16ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg8e32ff_v_mu:
case RISCVVector::BI__builtin_rvv_vlseg8e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  NF = 8;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // vl
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);

      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");
      // Get alignment from the new vl operand
      clang::CharUnits Align =
          CGM.getNaturalPointeeTypeAlignment(E->getArg(Offset + 1)->getType());

      llvm::Value *ReturnTuple = llvm::PoisonValue::get(ResultType);
      for (unsigned I = 0; I < NF; ++I) {
        llvm::Value *V = Builder.CreateExtractValue(LoadValue, {I});
        ReturnTuple = Builder.CreateInsertValue(ReturnTuple, V, {I});
      }

      // Store new_vl
      llvm::Value *V = Builder.CreateExtractValue(LoadValue, {NF});
      Builder.CreateStore(V, Address(Ops[Offset + 1], V->getType(), Align));

      if (ReturnValue.isNull())
        return ReturnTuple;
      else
        return Builder.CreateStore(ReturnTuple, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg2e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg2e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg2e64_v_tu:
  ID = Intrinsic::riscv_vlsseg2;
  NF = 2;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e8_v:
case RISCVVector::BI__builtin_rvv_vlsseg2e16_v:
case RISCVVector::BI__builtin_rvv_vlsseg2e32_v:
case RISCVVector::BI__builtin_rvv_vlsseg2e64_v:
  ID = Intrinsic::riscv_vlsseg2;
  NF = 2;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg2e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg2e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg2e64_v_tum:
  ID = Intrinsic::riscv_vlsseg2_mask;
  NF = 2;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e8_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg2e16_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg2e32_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg2e64_v_m:
  ID = Intrinsic::riscv_vlsseg2_mask;
  NF = 2;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg2e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg2e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg2e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg2_mask;
  NF = 2;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg2e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg2e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg2e64_v_mu:
  ID = Intrinsic::riscv_vlsseg2_mask;
  NF = 2;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg3e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg3e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg3e64_v_tu:
  ID = Intrinsic::riscv_vlsseg3;
  NF = 3;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e8_v:
case RISCVVector::BI__builtin_rvv_vlsseg3e16_v:
case RISCVVector::BI__builtin_rvv_vlsseg3e32_v:
case RISCVVector::BI__builtin_rvv_vlsseg3e64_v:
  ID = Intrinsic::riscv_vlsseg3;
  NF = 3;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg3e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg3e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg3e64_v_tum:
  ID = Intrinsic::riscv_vlsseg3_mask;
  NF = 3;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e8_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg3e16_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg3e32_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg3e64_v_m:
  ID = Intrinsic::riscv_vlsseg3_mask;
  NF = 3;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg3e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg3e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg3e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg3_mask;
  NF = 3;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg3e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg3e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg3e64_v_mu:
  ID = Intrinsic::riscv_vlsseg3_mask;
  NF = 3;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg4e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg4e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg4e64_v_tu:
  ID = Intrinsic::riscv_vlsseg4;
  NF = 4;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e8_v:
case RISCVVector::BI__builtin_rvv_vlsseg4e16_v:
case RISCVVector::BI__builtin_rvv_vlsseg4e32_v:
case RISCVVector::BI__builtin_rvv_vlsseg4e64_v:
  ID = Intrinsic::riscv_vlsseg4;
  NF = 4;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg4e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg4e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg4e64_v_tum:
  ID = Intrinsic::riscv_vlsseg4_mask;
  NF = 4;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e8_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg4e16_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg4e32_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg4e64_v_m:
  ID = Intrinsic::riscv_vlsseg4_mask;
  NF = 4;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg4e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg4e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg4e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg4_mask;
  NF = 4;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg4e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg4e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg4e64_v_mu:
  ID = Intrinsic::riscv_vlsseg4_mask;
  NF = 4;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg5e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg5e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg5e64_v_tu:
  ID = Intrinsic::riscv_vlsseg5;
  NF = 5;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e8_v:
case RISCVVector::BI__builtin_rvv_vlsseg5e16_v:
case RISCVVector::BI__builtin_rvv_vlsseg5e32_v:
case RISCVVector::BI__builtin_rvv_vlsseg5e64_v:
  ID = Intrinsic::riscv_vlsseg5;
  NF = 5;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg5e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg5e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg5e64_v_tum:
  ID = Intrinsic::riscv_vlsseg5_mask;
  NF = 5;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e8_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg5e16_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg5e32_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg5e64_v_m:
  ID = Intrinsic::riscv_vlsseg5_mask;
  NF = 5;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg5e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg5e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg5e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg5_mask;
  NF = 5;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg5e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg5e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg5e64_v_mu:
  ID = Intrinsic::riscv_vlsseg5_mask;
  NF = 5;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg6e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg6e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg6e64_v_tu:
  ID = Intrinsic::riscv_vlsseg6;
  NF = 6;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e8_v:
case RISCVVector::BI__builtin_rvv_vlsseg6e16_v:
case RISCVVector::BI__builtin_rvv_vlsseg6e32_v:
case RISCVVector::BI__builtin_rvv_vlsseg6e64_v:
  ID = Intrinsic::riscv_vlsseg6;
  NF = 6;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg6e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg6e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg6e64_v_tum:
  ID = Intrinsic::riscv_vlsseg6_mask;
  NF = 6;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e8_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg6e16_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg6e32_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg6e64_v_m:
  ID = Intrinsic::riscv_vlsseg6_mask;
  NF = 6;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg6e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg6e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg6e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg6_mask;
  NF = 6;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg6e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg6e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg6e64_v_mu:
  ID = Intrinsic::riscv_vlsseg6_mask;
  NF = 6;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg7e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg7e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg7e64_v_tu:
  ID = Intrinsic::riscv_vlsseg7;
  NF = 7;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e8_v:
case RISCVVector::BI__builtin_rvv_vlsseg7e16_v:
case RISCVVector::BI__builtin_rvv_vlsseg7e32_v:
case RISCVVector::BI__builtin_rvv_vlsseg7e64_v:
  ID = Intrinsic::riscv_vlsseg7;
  NF = 7;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg7e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg7e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg7e64_v_tum:
  ID = Intrinsic::riscv_vlsseg7_mask;
  NF = 7;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e8_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg7e16_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg7e32_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg7e64_v_m:
  ID = Intrinsic::riscv_vlsseg7_mask;
  NF = 7;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg7e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg7e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg7e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg7_mask;
  NF = 7;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg7e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg7e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg7e64_v_mu:
  ID = Intrinsic::riscv_vlsseg7_mask;
  NF = 7;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e8_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg8e16_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg8e32_v_tu:
case RISCVVector::BI__builtin_rvv_vlsseg8e64_v_tu:
  ID = Intrinsic::riscv_vlsseg8;
  NF = 8;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e8_v:
case RISCVVector::BI__builtin_rvv_vlsseg8e16_v:
case RISCVVector::BI__builtin_rvv_vlsseg8e32_v:
case RISCVVector::BI__builtin_rvv_vlsseg8e64_v:
  ID = Intrinsic::riscv_vlsseg8;
  NF = 8;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e8_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg8e16_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg8e32_v_tum:
case RISCVVector::BI__builtin_rvv_vlsseg8e64_v_tum:
  ID = Intrinsic::riscv_vlsseg8_mask;
  NF = 8;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e8_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg8e16_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg8e32_v_m:
case RISCVVector::BI__builtin_rvv_vlsseg8e64_v_m:
  ID = Intrinsic::riscv_vlsseg8_mask;
  NF = 8;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg8e16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg8e32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlsseg8e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg8_mask;
  NF = 8;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e8_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg8e16_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg8e32_v_mu:
case RISCVVector::BI__builtin_rvv_vlsseg8e64_v_mu:
  ID = Intrinsic::riscv_vlsseg8_mask;
  NF = 8;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Stride
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxei64_v_tu:
case RISCVVector::BI__builtin_rvv_vluxei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxei32_v_tu:
  ID = Intrinsic::riscv_vluxei;
  PolicyAttrs = 2;
  Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vluxei8_v:
case RISCVVector::BI__builtin_rvv_vluxei64_v:
case RISCVVector::BI__builtin_rvv_vluxei16_v:
case RISCVVector::BI__builtin_rvv_vluxei32_v:
  ID = Intrinsic::riscv_vluxei;
  PolicyAttrs = 3;
  Ops[0] = Builder.CreateBitCast(Ops[0], ResultType->getPointerTo());
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vluxei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxei64_v_tum:
case RISCVVector::BI__builtin_rvv_vluxei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxei32_v_tum:
  ID = Intrinsic::riscv_vluxei_mask;
  PolicyAttrs = 2;
  Ops[2] = Builder.CreateBitCast(Ops[2], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vluxei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxei64_v_m:
case RISCVVector::BI__builtin_rvv_vluxei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxei32_v_m:
  ID = Intrinsic::riscv_vluxei_mask;
  PolicyAttrs = 3;
  Ops[1] = Builder.CreateBitCast(Ops[1], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vluxei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxei64_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxei32_v_tumu:
  ID = Intrinsic::riscv_vluxei_mask;
  PolicyAttrs = 0;
  Ops[2] = Builder.CreateBitCast(Ops[2], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vluxei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxei64_v_mu:
case RISCVVector::BI__builtin_rvv_vluxei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxei32_v_mu:
  ID = Intrinsic::riscv_vluxei_mask;
  PolicyAttrs = 1;
  Ops[2] = Builder.CreateBitCast(Ops[2], ResultType->getPointerTo());
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vluxseg2ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg2;
  NF = 2;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg2ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg2ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg2ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg2ei64_v:
  ID = Intrinsic::riscv_vluxseg2;
  NF = 2;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg2ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg2ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg2ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg2ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg2_mask;
  NF = 2;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg2ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg2ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg2ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg2ei64_v_m:
  ID = Intrinsic::riscv_vluxseg2_mask;
  NF = 2;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg2ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg2_mask;
  NF = 2;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg2ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg2_mask;
  NF = 2;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg3ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg3;
  NF = 3;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg3ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg3ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg3ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg3ei64_v:
  ID = Intrinsic::riscv_vluxseg3;
  NF = 3;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg3ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg3ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg3ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg3ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg3_mask;
  NF = 3;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg3ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg3ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg3ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg3ei64_v_m:
  ID = Intrinsic::riscv_vluxseg3_mask;
  NF = 3;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg3ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg3_mask;
  NF = 3;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg3ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg3_mask;
  NF = 3;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg4ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg4;
  NF = 4;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg4ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg4ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg4ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg4ei64_v:
  ID = Intrinsic::riscv_vluxseg4;
  NF = 4;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg4ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg4ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg4ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg4ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg4_mask;
  NF = 4;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg4ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg4ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg4ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg4ei64_v_m:
  ID = Intrinsic::riscv_vluxseg4_mask;
  NF = 4;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg4ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg4_mask;
  NF = 4;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg4ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg4_mask;
  NF = 4;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg5ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg5;
  NF = 5;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg5ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg5ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg5ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg5ei64_v:
  ID = Intrinsic::riscv_vluxseg5;
  NF = 5;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg5ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg5ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg5ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg5ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg5_mask;
  NF = 5;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg5ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg5ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg5ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg5ei64_v_m:
  ID = Intrinsic::riscv_vluxseg5_mask;
  NF = 5;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg5ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg5_mask;
  NF = 5;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg5ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg5_mask;
  NF = 5;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg6ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg6;
  NF = 6;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg6ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg6ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg6ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg6ei64_v:
  ID = Intrinsic::riscv_vluxseg6;
  NF = 6;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg6ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg6ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg6ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg6ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg6_mask;
  NF = 6;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg6ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg6ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg6ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg6ei64_v_m:
  ID = Intrinsic::riscv_vluxseg6_mask;
  NF = 6;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg6ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg6_mask;
  NF = 6;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg6ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg6_mask;
  NF = 6;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg7ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg7;
  NF = 7;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg7ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg7ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg7ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg7ei64_v:
  ID = Intrinsic::riscv_vluxseg7;
  NF = 7;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg7ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg7ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg7ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg7ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg7_mask;
  NF = 7;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg7ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg7ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg7ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg7ei64_v_m:
  ID = Intrinsic::riscv_vluxseg7_mask;
  NF = 7;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg7ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg7_mask;
  NF = 7;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg7ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg7_mask;
  NF = 7;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg8ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg8;
  NF = 8;
  PolicyAttrs = 2;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg8ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg8ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg8ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg8ei64_v:
  ID = Intrinsic::riscv_vluxseg8;
  NF = 8;
  PolicyAttrs = 3;
IsMasked = false;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg8ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg8ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg8ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg8ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg8_mask;
  NF = 8;
  PolicyAttrs = 2;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg8ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg8ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg8ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg8ei64_v_m:
  ID = Intrinsic::riscv_vluxseg8_mask;
  NF = 8;
  PolicyAttrs = 3;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg8ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg8_mask;
  NF = 8;
  PolicyAttrs = 0;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vluxseg8ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg8_mask;
  NF = 8;
  PolicyAttrs = 1;
IsMasked = true;

    {
      llvm::Type *ElementVectorType = cast<StructType>(ResultType)->elements()[0];
      IntrinsicTypes = {ElementVectorType, Ops.back()->getType()};
      SmallVector<llvm::Value*, 12> Operands;

      bool NoPassthru =
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) |
        (!IsMasked && (PolicyAttrs & RVV_VTA));
      unsigned Offset = IsMasked ? NoPassthru ? 1 : 2 : NoPassthru ? 0 : 1;

      if (NoPassthru) { // Push poison into passthru
        Operands.append(NF, llvm::PoisonValue::get(ElementVectorType));
      } else { // Push intrinsics operands into passthru
        llvm::Value *PassthruOperand = IsMasked ? Ops[1] : Ops[0];
        for (unsigned I = 0; I < NF; ++I)
          Operands.push_back(Builder.CreateExtractValue(PassthruOperand, {I}));
      }

      Operands.push_back(Ops[Offset]); // Ptr
      Operands.push_back(Ops[Offset + 1]); // Idx
      if (IsMasked)
        Operands.push_back(Ops[0]);
      Operands.push_back(Ops[Offset + 2]); // VL
      if (IsMasked)
        Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

      IntrinsicTypes = {ElementVectorType, Ops[Offset + 1]->getType(),
                        Ops.back()->getType()};
      llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
      llvm::Value *LoadValue = Builder.CreateCall(F, Operands, "");

      if (ReturnValue.isNull())
        return LoadValue;
      else
        return Builder.CreateStore(LoadValue, ReturnValue.getValue());
    }
    break;
case RISCVVector::BI__builtin_rvv_vmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vmacc_vx_tu:
  ID = Intrinsic::riscv_vmacc;
  PolicyAttrs = 2;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmacc_vv:
case RISCVVector::BI__builtin_rvv_vmacc_vx:
  ID = Intrinsic::riscv_vmacc;
  PolicyAttrs = 3;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vmacc_vx_tum:
  ID = Intrinsic::riscv_vmacc_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vmacc_vx_m:
  ID = Intrinsic::riscv_vmacc_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmacc_vx_tumu:
  ID = Intrinsic::riscv_vmacc_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vmacc_vx_mu:
  ID = Intrinsic::riscv_vmacc_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadc_vv:
case RISCVVector::BI__builtin_rvv_vmadc_vx:
  ID = Intrinsic::riscv_vmadc;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadc_vvm:
case RISCVVector::BI__builtin_rvv_vmadc_vxm:
  ID = Intrinsic::riscv_vmadc_carry_in;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vmadd_vx_tu:
  ID = Intrinsic::riscv_vmadd;
  PolicyAttrs = 2;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadd_vv:
case RISCVVector::BI__builtin_rvv_vmadd_vx:
  ID = Intrinsic::riscv_vmadd;
  PolicyAttrs = 3;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vmadd_vx_tum:
  ID = Intrinsic::riscv_vmadd_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadd_vv_m:
case RISCVVector::BI__builtin_rvv_vmadd_vx_m:
  ID = Intrinsic::riscv_vmadd_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmadd_vx_tumu:
  ID = Intrinsic::riscv_vmadd_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vmadd_vx_mu:
  ID = Intrinsic::riscv_vmadd_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmmv_m:
  ID = Intrinsic::riscv_vmand;
  PolicyAttrs = 3;
IsMasked = false;

      {
        // op1, vl
        IntrinsicTypes = {ResultType,
                          Ops[1]->getType()};
        Ops.insert(Ops.begin() + 1, Ops[0]);
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vmand_mm:
  ID = Intrinsic::riscv_vmand;
  PolicyAttrs = 3;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmandn_mm:
  ID = Intrinsic::riscv_vmandn;
  PolicyAttrs = 3;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmax_vv_tu:
case RISCVVector::BI__builtin_rvv_vmax_vx_tu:
  ID = Intrinsic::riscv_vmax;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmax_vv:
case RISCVVector::BI__builtin_rvv_vmax_vx:
  ID = Intrinsic::riscv_vmax;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmax_vv_tum:
case RISCVVector::BI__builtin_rvv_vmax_vx_tum:
  ID = Intrinsic::riscv_vmax_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmax_vv_m:
case RISCVVector::BI__builtin_rvv_vmax_vx_m:
  ID = Intrinsic::riscv_vmax_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmax_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmax_vx_tumu:
  ID = Intrinsic::riscv_vmax_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmax_vv_mu:
case RISCVVector::BI__builtin_rvv_vmax_vx_mu:
  ID = Intrinsic::riscv_vmax_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmaxu_vv_tu:
case RISCVVector::BI__builtin_rvv_vmaxu_vx_tu:
  ID = Intrinsic::riscv_vmaxu;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmaxu_vv:
case RISCVVector::BI__builtin_rvv_vmaxu_vx:
  ID = Intrinsic::riscv_vmaxu;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmaxu_vv_tum:
case RISCVVector::BI__builtin_rvv_vmaxu_vx_tum:
  ID = Intrinsic::riscv_vmaxu_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmaxu_vv_m:
case RISCVVector::BI__builtin_rvv_vmaxu_vx_m:
  ID = Intrinsic::riscv_vmaxu_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmaxu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmaxu_vx_tumu:
  ID = Intrinsic::riscv_vmaxu_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmaxu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmaxu_vx_mu:
  ID = Intrinsic::riscv_vmaxu_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmclr_m:
  ID = Intrinsic::riscv_vmclr;
  PolicyAttrs = 3;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmerge_vvm_tu:
case RISCVVector::BI__builtin_rvv_vmerge_vxm_tu:
  ID = Intrinsic::riscv_vmerge;
  PolicyAttrs = 2;
IsMasked = false;

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vmerge_vvm:
case RISCVVector::BI__builtin_rvv_vmerge_vxm:
  ID = Intrinsic::riscv_vmerge;
  PolicyAttrs = 3;
IsMasked = false;

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vmfeq_vv:
case RISCVVector::BI__builtin_rvv_vmfeq_vf:
  ID = Intrinsic::riscv_vmfeq;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfeq_vv_m:
case RISCVVector::BI__builtin_rvv_vmfeq_vf_m:
  ID = Intrinsic::riscv_vmfeq_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfeq_vv_mu:
case RISCVVector::BI__builtin_rvv_vmfeq_vf_mu:
  ID = Intrinsic::riscv_vmfeq_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfge_vv:
case RISCVVector::BI__builtin_rvv_vmfge_vf:
  ID = Intrinsic::riscv_vmfge;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfge_vv_m:
case RISCVVector::BI__builtin_rvv_vmfge_vf_m:
  ID = Intrinsic::riscv_vmfge_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfge_vv_mu:
case RISCVVector::BI__builtin_rvv_vmfge_vf_mu:
  ID = Intrinsic::riscv_vmfge_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfgt_vv:
case RISCVVector::BI__builtin_rvv_vmfgt_vf:
  ID = Intrinsic::riscv_vmfgt;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfgt_vv_m:
case RISCVVector::BI__builtin_rvv_vmfgt_vf_m:
  ID = Intrinsic::riscv_vmfgt_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfgt_vv_mu:
case RISCVVector::BI__builtin_rvv_vmfgt_vf_mu:
  ID = Intrinsic::riscv_vmfgt_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfle_vv:
case RISCVVector::BI__builtin_rvv_vmfle_vf:
  ID = Intrinsic::riscv_vmfle;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfle_vv_m:
case RISCVVector::BI__builtin_rvv_vmfle_vf_m:
  ID = Intrinsic::riscv_vmfle_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfle_vv_mu:
case RISCVVector::BI__builtin_rvv_vmfle_vf_mu:
  ID = Intrinsic::riscv_vmfle_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmflt_vv:
case RISCVVector::BI__builtin_rvv_vmflt_vf:
  ID = Intrinsic::riscv_vmflt;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmflt_vv_m:
case RISCVVector::BI__builtin_rvv_vmflt_vf_m:
  ID = Intrinsic::riscv_vmflt_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmflt_vv_mu:
case RISCVVector::BI__builtin_rvv_vmflt_vf_mu:
  ID = Intrinsic::riscv_vmflt_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfne_vv:
case RISCVVector::BI__builtin_rvv_vmfne_vf:
  ID = Intrinsic::riscv_vmfne;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfne_vv_m:
case RISCVVector::BI__builtin_rvv_vmfne_vf_m:
  ID = Intrinsic::riscv_vmfne_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfne_vv_mu:
case RISCVVector::BI__builtin_rvv_vmfne_vf_mu:
  ID = Intrinsic::riscv_vmfne_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmin_vv_tu:
case RISCVVector::BI__builtin_rvv_vmin_vx_tu:
  ID = Intrinsic::riscv_vmin;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmin_vv:
case RISCVVector::BI__builtin_rvv_vmin_vx:
  ID = Intrinsic::riscv_vmin;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmin_vv_tum:
case RISCVVector::BI__builtin_rvv_vmin_vx_tum:
  ID = Intrinsic::riscv_vmin_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmin_vv_m:
case RISCVVector::BI__builtin_rvv_vmin_vx_m:
  ID = Intrinsic::riscv_vmin_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmin_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmin_vx_tumu:
  ID = Intrinsic::riscv_vmin_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmin_vv_mu:
case RISCVVector::BI__builtin_rvv_vmin_vx_mu:
  ID = Intrinsic::riscv_vmin_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vminu_vv_tu:
case RISCVVector::BI__builtin_rvv_vminu_vx_tu:
  ID = Intrinsic::riscv_vminu;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vminu_vv:
case RISCVVector::BI__builtin_rvv_vminu_vx:
  ID = Intrinsic::riscv_vminu;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vminu_vv_tum:
case RISCVVector::BI__builtin_rvv_vminu_vx_tum:
  ID = Intrinsic::riscv_vminu_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vminu_vv_m:
case RISCVVector::BI__builtin_rvv_vminu_vx_m:
  ID = Intrinsic::riscv_vminu_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vminu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vminu_vx_tumu:
  ID = Intrinsic::riscv_vminu_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vminu_vv_mu:
case RISCVVector::BI__builtin_rvv_vminu_vx_mu:
  ID = Intrinsic::riscv_vminu_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmnot_m:
  ID = Intrinsic::riscv_vmnand;
  PolicyAttrs = 3;
IsMasked = false;

      {
        // op1, vl
        IntrinsicTypes = {ResultType,
                          Ops[1]->getType()};
        Ops.insert(Ops.begin() + 1, Ops[0]);
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vmnand_mm:
  ID = Intrinsic::riscv_vmnand;
  PolicyAttrs = 3;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmnor_mm:
  ID = Intrinsic::riscv_vmnor;
  PolicyAttrs = 3;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmor_mm:
  ID = Intrinsic::riscv_vmor;
  PolicyAttrs = 3;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmorn_mm:
  ID = Intrinsic::riscv_vmorn;
  PolicyAttrs = 3;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsbc_vv:
case RISCVVector::BI__builtin_rvv_vmsbc_vx:
  ID = Intrinsic::riscv_vmsbc;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsbc_vvm:
case RISCVVector::BI__builtin_rvv_vmsbc_vxm:
  ID = Intrinsic::riscv_vmsbc_borrow_in;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsbf_m:
  ID = Intrinsic::riscv_vmsbf;
  PolicyAttrs = 3;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsbf_m_m:
  ID = Intrinsic::riscv_vmsbf_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsbf_m_mu:
  ID = Intrinsic::riscv_vmsbf_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmseq_vv:
case RISCVVector::BI__builtin_rvv_vmseq_vx:
  ID = Intrinsic::riscv_vmseq;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmseq_vv_m:
case RISCVVector::BI__builtin_rvv_vmseq_vx_m:
  ID = Intrinsic::riscv_vmseq_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmseq_vv_mu:
case RISCVVector::BI__builtin_rvv_vmseq_vx_mu:
  ID = Intrinsic::riscv_vmseq_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmset_m:
  ID = Intrinsic::riscv_vmset;
  PolicyAttrs = 3;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsge_vv:
case RISCVVector::BI__builtin_rvv_vmsge_vx:
  ID = Intrinsic::riscv_vmsge;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsge_vv_m:
case RISCVVector::BI__builtin_rvv_vmsge_vx_m:
  ID = Intrinsic::riscv_vmsge_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsge_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsge_vx_mu:
  ID = Intrinsic::riscv_vmsge_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgeu_vv:
case RISCVVector::BI__builtin_rvv_vmsgeu_vx:
  ID = Intrinsic::riscv_vmsgeu;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgeu_vv_m:
case RISCVVector::BI__builtin_rvv_vmsgeu_vx_m:
  ID = Intrinsic::riscv_vmsgeu_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgeu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsgeu_vx_mu:
  ID = Intrinsic::riscv_vmsgeu_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgt_vv:
case RISCVVector::BI__builtin_rvv_vmsgt_vx:
  ID = Intrinsic::riscv_vmsgt;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgt_vv_m:
case RISCVVector::BI__builtin_rvv_vmsgt_vx_m:
  ID = Intrinsic::riscv_vmsgt_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgt_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsgt_vx_mu:
  ID = Intrinsic::riscv_vmsgt_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgtu_vv:
case RISCVVector::BI__builtin_rvv_vmsgtu_vx:
  ID = Intrinsic::riscv_vmsgtu;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgtu_vv_m:
case RISCVVector::BI__builtin_rvv_vmsgtu_vx_m:
  ID = Intrinsic::riscv_vmsgtu_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgtu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsgtu_vx_mu:
  ID = Intrinsic::riscv_vmsgtu_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsif_m:
  ID = Intrinsic::riscv_vmsif;
  PolicyAttrs = 3;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsif_m_m:
  ID = Intrinsic::riscv_vmsif_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsif_m_mu:
  ID = Intrinsic::riscv_vmsif_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsle_vv:
case RISCVVector::BI__builtin_rvv_vmsle_vx:
  ID = Intrinsic::riscv_vmsle;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsle_vv_m:
case RISCVVector::BI__builtin_rvv_vmsle_vx_m:
  ID = Intrinsic::riscv_vmsle_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsle_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsle_vx_mu:
  ID = Intrinsic::riscv_vmsle_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsleu_vv:
case RISCVVector::BI__builtin_rvv_vmsleu_vx:
  ID = Intrinsic::riscv_vmsleu;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsleu_vv_m:
case RISCVVector::BI__builtin_rvv_vmsleu_vx_m:
  ID = Intrinsic::riscv_vmsleu_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsleu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsleu_vx_mu:
  ID = Intrinsic::riscv_vmsleu_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmslt_vv:
case RISCVVector::BI__builtin_rvv_vmslt_vx:
  ID = Intrinsic::riscv_vmslt;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmslt_vv_m:
case RISCVVector::BI__builtin_rvv_vmslt_vx_m:
  ID = Intrinsic::riscv_vmslt_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmslt_vv_mu:
case RISCVVector::BI__builtin_rvv_vmslt_vx_mu:
  ID = Intrinsic::riscv_vmslt_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsltu_vv:
case RISCVVector::BI__builtin_rvv_vmsltu_vx:
  ID = Intrinsic::riscv_vmsltu;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsltu_vv_m:
case RISCVVector::BI__builtin_rvv_vmsltu_vx_m:
  ID = Intrinsic::riscv_vmsltu_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsltu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsltu_vx_mu:
  ID = Intrinsic::riscv_vmsltu_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsne_vv:
case RISCVVector::BI__builtin_rvv_vmsne_vx:
  ID = Intrinsic::riscv_vmsne;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsne_vv_m:
case RISCVVector::BI__builtin_rvv_vmsne_vx_m:
  ID = Intrinsic::riscv_vmsne_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsne_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsne_vx_mu:
  ID = Intrinsic::riscv_vmsne_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsof_m:
  ID = Intrinsic::riscv_vmsof;
  PolicyAttrs = 3;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsof_m_m:
  ID = Intrinsic::riscv_vmsof_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsof_m_mu:
  ID = Intrinsic::riscv_vmsof_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmul_vv_tu:
case RISCVVector::BI__builtin_rvv_vmul_vx_tu:
  ID = Intrinsic::riscv_vmul;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmul_vv:
case RISCVVector::BI__builtin_rvv_vmul_vx:
  ID = Intrinsic::riscv_vmul;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmul_vv_tum:
case RISCVVector::BI__builtin_rvv_vmul_vx_tum:
  ID = Intrinsic::riscv_vmul_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmul_vv_m:
case RISCVVector::BI__builtin_rvv_vmul_vx_m:
  ID = Intrinsic::riscv_vmul_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmul_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmul_vx_tumu:
  ID = Intrinsic::riscv_vmul_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmul_vv_mu:
case RISCVVector::BI__builtin_rvv_vmul_vx_mu:
  ID = Intrinsic::riscv_vmul_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulh_vv_tu:
case RISCVVector::BI__builtin_rvv_vmulh_vx_tu:
  ID = Intrinsic::riscv_vmulh;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulh_vv:
case RISCVVector::BI__builtin_rvv_vmulh_vx:
  ID = Intrinsic::riscv_vmulh;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulh_vv_tum:
case RISCVVector::BI__builtin_rvv_vmulh_vx_tum:
  ID = Intrinsic::riscv_vmulh_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulh_vv_m:
case RISCVVector::BI__builtin_rvv_vmulh_vx_m:
  ID = Intrinsic::riscv_vmulh_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulh_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmulh_vx_tumu:
  ID = Intrinsic::riscv_vmulh_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulh_vv_mu:
case RISCVVector::BI__builtin_rvv_vmulh_vx_mu:
  ID = Intrinsic::riscv_vmulh_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhsu_vv_tu:
case RISCVVector::BI__builtin_rvv_vmulhsu_vx_tu:
  ID = Intrinsic::riscv_vmulhsu;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhsu_vv:
case RISCVVector::BI__builtin_rvv_vmulhsu_vx:
  ID = Intrinsic::riscv_vmulhsu;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhsu_vv_tum:
case RISCVVector::BI__builtin_rvv_vmulhsu_vx_tum:
  ID = Intrinsic::riscv_vmulhsu_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhsu_vv_m:
case RISCVVector::BI__builtin_rvv_vmulhsu_vx_m:
  ID = Intrinsic::riscv_vmulhsu_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhsu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmulhsu_vx_tumu:
  ID = Intrinsic::riscv_vmulhsu_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhsu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmulhsu_vx_mu:
  ID = Intrinsic::riscv_vmulhsu_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhu_vv_tu:
case RISCVVector::BI__builtin_rvv_vmulhu_vx_tu:
  ID = Intrinsic::riscv_vmulhu;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhu_vv:
case RISCVVector::BI__builtin_rvv_vmulhu_vx:
  ID = Intrinsic::riscv_vmulhu;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhu_vv_tum:
case RISCVVector::BI__builtin_rvv_vmulhu_vx_tum:
  ID = Intrinsic::riscv_vmulhu_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhu_vv_m:
case RISCVVector::BI__builtin_rvv_vmulhu_vx_m:
  ID = Intrinsic::riscv_vmulhu_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmulhu_vx_tumu:
  ID = Intrinsic::riscv_vmulhu_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmulhu_vx_mu:
  ID = Intrinsic::riscv_vmulhu_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_s_x_tu:
  ID = Intrinsic::riscv_vmv_s_x;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_s_x:
  ID = Intrinsic::riscv_vmv_s_x;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_v_v_tu:
  ID = Intrinsic::riscv_vmv_v_v;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_v_v:
  ID = Intrinsic::riscv_vmv_v_v;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_v_x_tu:
  ID = Intrinsic::riscv_vmv_v_x;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_v_x:
  ID = Intrinsic::riscv_vmv_v_x;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_x_s:
  ID = Intrinsic::riscv_vmv_x_s;
  PolicyAttrs = 3;
  IntrinsicTypes = {Ops[0]->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmxnor_mm:
  ID = Intrinsic::riscv_vmxnor;
  PolicyAttrs = 3;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmxor_mm:
  ID = Intrinsic::riscv_vmxor;
  PolicyAttrs = 3;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnclip_wv_tu:
case RISCVVector::BI__builtin_rvv_vnclip_wx_tu:
  ID = Intrinsic::riscv_vnclip;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vnclip_wv:
case RISCVVector::BI__builtin_rvv_vnclip_wx:
  ID = Intrinsic::riscv_vnclip;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vnclip_wv_tum:
case RISCVVector::BI__builtin_rvv_vnclip_wx_tum:
  ID = Intrinsic::riscv_vnclip_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vnclip_wv_m:
case RISCVVector::BI__builtin_rvv_vnclip_wx_m:
  ID = Intrinsic::riscv_vnclip_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vnclip_wv_tumu:
case RISCVVector::BI__builtin_rvv_vnclip_wx_tumu:
  ID = Intrinsic::riscv_vnclip_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vnclip_wv_mu:
case RISCVVector::BI__builtin_rvv_vnclip_wx_mu:
  ID = Intrinsic::riscv_vnclip_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vnclipu_wv_tu:
case RISCVVector::BI__builtin_rvv_vnclipu_wx_tu:
  ID = Intrinsic::riscv_vnclipu;
  PolicyAttrs = 2;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vnclipu_wv:
case RISCVVector::BI__builtin_rvv_vnclipu_wx:
  ID = Intrinsic::riscv_vnclipu;
  PolicyAttrs = 3;
IsMasked = false;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vnclipu_wv_tum:
case RISCVVector::BI__builtin_rvv_vnclipu_wx_tum:
  ID = Intrinsic::riscv_vnclipu_mask;
  PolicyAttrs = 2;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vnclipu_wv_m:
case RISCVVector::BI__builtin_rvv_vnclipu_wx_m:
  ID = Intrinsic::riscv_vnclipu_mask;
  PolicyAttrs = 3;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vnclipu_wv_tumu:
case RISCVVector::BI__builtin_rvv_vnclipu_wx_tumu:
  ID = Intrinsic::riscv_vnclipu_mask;
  PolicyAttrs = 0;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vnclipu_wv_mu:
case RISCVVector::BI__builtin_rvv_vnclipu_wx_mu:
  ID = Intrinsic::riscv_vnclipu_mask;
  PolicyAttrs = 1;
IsMasked = true;

  {
    // LLVM intrinsic
    // Unmasked: (passthru, op0, op1, round_mode, vl)
    // Masked:   (passthru, vector_in, vector_in/scalar_in, mask, vxrm, vl, policy)

    SmallVector<llvm::Value*, 7> Operands;
    bool HasMaskedOff = !(
        (IsMasked && (PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA)) ||
        (!IsMasked && PolicyAttrs & RVV_VTA));
    unsigned Offset = IsMasked ?
        (HasMaskedOff ? 2 : 1) : (HasMaskedOff ? 1 : 0);

    if (!HasMaskedOff)
      Operands.push_back(llvm::PoisonValue::get(ResultType));
    else
      Operands.push_back(Ops[IsMasked ? 1 : 0]);

    Operands.push_back(Ops[Offset]); // op0
    Operands.push_back(Ops[Offset + 1]); // op1

    if (IsMasked)
      Operands.push_back(Ops[0]); // mask

    Operands.push_back(Ops[Offset + 2]); // vxrm
    Operands.push_back(Ops[Offset + 3]); // vl

    if (IsMasked)
      Operands.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));

    IntrinsicTypes = {ResultType, Ops[Offset]->getType(), Ops[Offset + 1]->getType(),
                      Ops.back()->getType()};
    llvm::Function *F = CGM.getIntrinsic(ID, IntrinsicTypes);
    return Builder.CreateCall(F, Operands, "");
  }
break;
case RISCVVector::BI__builtin_rvv_vnmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vnmsac_vx_tu:
  ID = Intrinsic::riscv_vnmsac;
  PolicyAttrs = 2;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsac_vv:
case RISCVVector::BI__builtin_rvv_vnmsac_vx:
  ID = Intrinsic::riscv_vnmsac;
  PolicyAttrs = 3;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vnmsac_vx_tum:
  ID = Intrinsic::riscv_vnmsac_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vnmsac_vx_m:
  ID = Intrinsic::riscv_vnmsac_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vnmsac_vx_tumu:
  ID = Intrinsic::riscv_vnmsac_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vnmsac_vx_mu:
  ID = Intrinsic::riscv_vnmsac_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vnmsub_vx_tu:
  ID = Intrinsic::riscv_vnmsub;
  PolicyAttrs = 2;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsub_vv:
case RISCVVector::BI__builtin_rvv_vnmsub_vx:
  ID = Intrinsic::riscv_vnmsub;
  PolicyAttrs = 3;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vnmsub_vx_tum:
  ID = Intrinsic::riscv_vnmsub_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsub_vv_m:
case RISCVVector::BI__builtin_rvv_vnmsub_vx_m:
  ID = Intrinsic::riscv_vnmsub_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vnmsub_vx_tumu:
  ID = Intrinsic::riscv_vnmsub_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vnmsub_vx_mu:
  ID = Intrinsic::riscv_vnmsub_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnsra_wv_tu:
case RISCVVector::BI__builtin_rvv_vnsra_wx_tu:
  ID = Intrinsic::riscv_vnsra;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnsra_wv:
case RISCVVector::BI__builtin_rvv_vnsra_wx:
  ID = Intrinsic::riscv_vnsra;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnsra_wv_tum:
case RISCVVector::BI__builtin_rvv_vnsra_wx_tum:
  ID = Intrinsic::riscv_vnsra_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnsra_wv_m:
case RISCVVector::BI__builtin_rvv_vnsra_wx_m:
  ID = Intrinsic::riscv_vnsra_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnsra_wv_tumu:
case RISCVVector::BI__builtin_rvv_vnsra_wx_tumu:
  ID = Intrinsic::riscv_vnsra_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnsra_wv_mu:
case RISCVVector::BI__builtin_rvv_vnsra_wx_mu:
  ID = Intrinsic::riscv_vnsra_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vncvt_x_x_w_tu:
  ID = Intrinsic::riscv_vnsrl;
  PolicyAttrs = 2;
IsMasked = false;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(Ops.back()->getType()));
        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, xlen, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(),
                            Ops[4]->getType(),
                            Ops[4]->getType()};
        } else {
          // passthru, op1, xlen, vl
          IntrinsicTypes = {ResultType,
                  Ops[1]->getType(),
                  Ops[3]->getType(),
                  Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vnsrl_wv_tu:
case RISCVVector::BI__builtin_rvv_vnsrl_wx_tu:
  ID = Intrinsic::riscv_vnsrl;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vnsrl;
  PolicyAttrs = 2;
IsMasked = false;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(Ops.back()->getType()));
        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, xlen, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(),
                            Ops[4]->getType(),
                            Ops[4]->getType()};
        } else {
          // passthru, op1, xlen, vl
          IntrinsicTypes = {ResultType,
                  Ops[1]->getType(),
                  Ops[3]->getType(),
                  Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vncvt_x_x_w:
  ID = Intrinsic::riscv_vnsrl;
  PolicyAttrs = 3;
IsMasked = false;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(Ops.back()->getType()));
        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, xlen, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(),
                            Ops[4]->getType(),
                            Ops[4]->getType()};
        } else {
          // passthru, op1, xlen, vl
          IntrinsicTypes = {ResultType,
                  Ops[1]->getType(),
                  Ops[3]->getType(),
                  Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vnsrl_wv:
case RISCVVector::BI__builtin_rvv_vnsrl_wx:
  ID = Intrinsic::riscv_vnsrl;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vnsrl;
  PolicyAttrs = 3;
IsMasked = false;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(Ops.back()->getType()));
        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, xlen, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(),
                            Ops[4]->getType(),
                            Ops[4]->getType()};
        } else {
          // passthru, op1, xlen, vl
          IntrinsicTypes = {ResultType,
                  Ops[1]->getType(),
                  Ops[3]->getType(),
                  Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vncvt_x_x_w_tum:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 2;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(Ops.back()->getType()));
        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, xlen, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(),
                            Ops[4]->getType(),
                            Ops[4]->getType()};
        } else {
          // passthru, op1, xlen, vl
          IntrinsicTypes = {ResultType,
                  Ops[1]->getType(),
                  Ops[3]->getType(),
                  Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vnsrl_wv_tum:
case RISCVVector::BI__builtin_rvv_vnsrl_wx_tum:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 2;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(Ops.back()->getType()));
        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, xlen, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(),
                            Ops[4]->getType(),
                            Ops[4]->getType()};
        } else {
          // passthru, op1, xlen, vl
          IntrinsicTypes = {ResultType,
                  Ops[1]->getType(),
                  Ops[3]->getType(),
                  Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vncvt_x_x_w_m:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 3;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(Ops.back()->getType()));
        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, xlen, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(),
                            Ops[4]->getType(),
                            Ops[4]->getType()};
        } else {
          // passthru, op1, xlen, vl
          IntrinsicTypes = {ResultType,
                  Ops[1]->getType(),
                  Ops[3]->getType(),
                  Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vnsrl_wv_m:
case RISCVVector::BI__builtin_rvv_vnsrl_wx_m:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 3;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(Ops.back()->getType()));
        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, xlen, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(),
                            Ops[4]->getType(),
                            Ops[4]->getType()};
        } else {
          // passthru, op1, xlen, vl
          IntrinsicTypes = {ResultType,
                  Ops[1]->getType(),
                  Ops[3]->getType(),
                  Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vncvt_x_x_w_tumu:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 0;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(Ops.back()->getType()));
        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, xlen, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(),
                            Ops[4]->getType(),
                            Ops[4]->getType()};
        } else {
          // passthru, op1, xlen, vl
          IntrinsicTypes = {ResultType,
                  Ops[1]->getType(),
                  Ops[3]->getType(),
                  Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vnsrl_wv_tumu:
case RISCVVector::BI__builtin_rvv_vnsrl_wx_tumu:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 0;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(Ops.back()->getType()));
        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, xlen, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(),
                            Ops[4]->getType(),
                            Ops[4]->getType()};
        } else {
          // passthru, op1, xlen, vl
          IntrinsicTypes = {ResultType,
                  Ops[1]->getType(),
                  Ops[3]->getType(),
                  Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vncvt_x_x_w_mu:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 1;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(Ops.back()->getType()));
        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, xlen, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(),
                            Ops[4]->getType(),
                            Ops[4]->getType()};
        } else {
          // passthru, op1, xlen, vl
          IntrinsicTypes = {ResultType,
                  Ops[1]->getType(),
                  Ops[3]->getType(),
                  Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vnsrl_wv_mu:
case RISCVVector::BI__builtin_rvv_vnsrl_wx_mu:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 1;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(Ops.back()->getType()));
        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, xlen, mask, vl
          IntrinsicTypes = {ResultType,
                            Ops[1]->getType(),
                            Ops[4]->getType(),
                            Ops[4]->getType()};
        } else {
          // passthru, op1, xlen, vl
          IntrinsicTypes = {ResultType,
                  Ops[1]->getType(),
                  Ops[3]->getType(),
                  Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vor_vv_tu:
case RISCVVector::BI__builtin_rvv_vor_vx_tu:
  ID = Intrinsic::riscv_vor;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vor_vv:
case RISCVVector::BI__builtin_rvv_vor_vx:
  ID = Intrinsic::riscv_vor;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vor_vv_tum:
case RISCVVector::BI__builtin_rvv_vor_vx_tum:
  ID = Intrinsic::riscv_vor_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vor_vv_m:
case RISCVVector::BI__builtin_rvv_vor_vx_m:
  ID = Intrinsic::riscv_vor_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vor_vv_tumu:
case RISCVVector::BI__builtin_rvv_vor_vx_tumu:
  ID = Intrinsic::riscv_vor_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vor_vv_mu:
case RISCVVector::BI__builtin_rvv_vor_vx_mu:
  ID = Intrinsic::riscv_vor_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredand_vs_tu:
  ID = Intrinsic::riscv_vredand;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredand_vs:
  ID = Intrinsic::riscv_vredand;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredand_vs_tum:
  ID = Intrinsic::riscv_vredand_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredand_vs_m:
  ID = Intrinsic::riscv_vredand_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmax_vs_tu:
  ID = Intrinsic::riscv_vredmax;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmax_vs:
  ID = Intrinsic::riscv_vredmax;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmax_vs_tum:
  ID = Intrinsic::riscv_vredmax_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmax_vs_m:
  ID = Intrinsic::riscv_vredmax_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmaxu_vs_tu:
  ID = Intrinsic::riscv_vredmaxu;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmaxu_vs:
  ID = Intrinsic::riscv_vredmaxu;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmaxu_vs_tum:
  ID = Intrinsic::riscv_vredmaxu_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmaxu_vs_m:
  ID = Intrinsic::riscv_vredmaxu_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmin_vs_tu:
  ID = Intrinsic::riscv_vredmin;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmin_vs:
  ID = Intrinsic::riscv_vredmin;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmin_vs_tum:
  ID = Intrinsic::riscv_vredmin_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmin_vs_m:
  ID = Intrinsic::riscv_vredmin_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredminu_vs_tu:
  ID = Intrinsic::riscv_vredminu;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredminu_vs:
  ID = Intrinsic::riscv_vredminu;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredminu_vs_tum:
  ID = Intrinsic::riscv_vredminu_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredminu_vs_m:
  ID = Intrinsic::riscv_vredminu_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredor_vs_tu:
  ID = Intrinsic::riscv_vredor;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredor_vs:
  ID = Intrinsic::riscv_vredor;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredor_vs_tum:
  ID = Intrinsic::riscv_vredor_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredor_vs_m:
  ID = Intrinsic::riscv_vredor_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredsum_vs_tu:
  ID = Intrinsic::riscv_vredsum;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredsum_vs:
  ID = Intrinsic::riscv_vredsum;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredsum_vs_tum:
  ID = Intrinsic::riscv_vredsum_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredsum_vs_m:
  ID = Intrinsic::riscv_vredsum_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredxor_vs_tu:
  ID = Intrinsic::riscv_vredxor;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredxor_vs:
  ID = Intrinsic::riscv_vredxor;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredxor_vs_tum:
  ID = Intrinsic::riscv_vredxor_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredxor_vs_m:
  ID = Intrinsic::riscv_vredxor_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrem_vv_tu:
case RISCVVector::BI__builtin_rvv_vrem_vx_tu:
  ID = Intrinsic::riscv_vrem;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrem_vv:
case RISCVVector::BI__builtin_rvv_vrem_vx:
  ID = Intrinsic::riscv_vrem;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrem_vv_tum:
case RISCVVector::BI__builtin_rvv_vrem_vx_tum:
  ID = Intrinsic::riscv_vrem_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrem_vv_m:
case RISCVVector::BI__builtin_rvv_vrem_vx_m:
  ID = Intrinsic::riscv_vrem_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrem_vv_tumu:
case RISCVVector::BI__builtin_rvv_vrem_vx_tumu:
  ID = Intrinsic::riscv_vrem_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrem_vv_mu:
case RISCVVector::BI__builtin_rvv_vrem_vx_mu:
  ID = Intrinsic::riscv_vrem_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vremu_vv_tu:
case RISCVVector::BI__builtin_rvv_vremu_vx_tu:
  ID = Intrinsic::riscv_vremu;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vremu_vv:
case RISCVVector::BI__builtin_rvv_vremu_vx:
  ID = Intrinsic::riscv_vremu;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vremu_vv_tum:
case RISCVVector::BI__builtin_rvv_vremu_vx_tum:
  ID = Intrinsic::riscv_vremu_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vremu_vv_m:
case RISCVVector::BI__builtin_rvv_vremu_vx_m:
  ID = Intrinsic::riscv_vremu_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vremu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vremu_vx_tumu:
  ID = Intrinsic::riscv_vremu_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vremu_vv_mu:
case RISCVVector::BI__builtin_rvv_vremu_vx_mu:
  ID = Intrinsic::riscv_vremu_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vv_tu:
  ID = Intrinsic::riscv_vrgather_vv;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vv:
  ID = Intrinsic::riscv_vrgather_vv;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vv_tum:
  ID = Intrinsic::riscv_vrgather_vv_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vv_m:
  ID = Intrinsic::riscv_vrgather_vv_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vv_tumu:
  ID = Intrinsic::riscv_vrgather_vv_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vv_mu:
  ID = Intrinsic::riscv_vrgather_vv_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vx_tu:
  ID = Intrinsic::riscv_vrgather_vx;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vx:
  ID = Intrinsic::riscv_vrgather_vx;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vx_tum:
  ID = Intrinsic::riscv_vrgather_vx_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vx_m:
  ID = Intrinsic::riscv_vrgather_vx_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vx_tumu:
  ID = Intrinsic::riscv_vrgather_vx_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vx_mu:
  ID = Intrinsic::riscv_vrgather_vx_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgatherei16_vv_tu:
  ID = Intrinsic::riscv_vrgatherei16_vv;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgatherei16_vv:
  ID = Intrinsic::riscv_vrgatherei16_vv;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgatherei16_vv_tum:
  ID = Intrinsic::riscv_vrgatherei16_vv_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgatherei16_vv_m:
  ID = Intrinsic::riscv_vrgatherei16_vv_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgatherei16_vv_tumu:
  ID = Intrinsic::riscv_vrgatherei16_vv_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgatherei16_vv_mu:
  ID = Intrinsic::riscv_vrgatherei16_vv_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vneg_v_tu:
  ID = Intrinsic::riscv_vrsub;
  PolicyAttrs = 2;
IsMasked = false;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        auto ElemTy = cast<llvm::VectorType>(ResultType)->getElementType();
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(ElemTy));

        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl, policy
          IntrinsicTypes = {ResultType, ElemTy, Ops[4]->getType()};
        } else {
          // passthru, op1, op2, vl
          IntrinsicTypes = {ResultType, ElemTy, Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vrsub_vx_tu:
  ID = Intrinsic::riscv_vrsub;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vneg_v:
  ID = Intrinsic::riscv_vrsub;
  PolicyAttrs = 3;
IsMasked = false;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        auto ElemTy = cast<llvm::VectorType>(ResultType)->getElementType();
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(ElemTy));

        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl, policy
          IntrinsicTypes = {ResultType, ElemTy, Ops[4]->getType()};
        } else {
          // passthru, op1, op2, vl
          IntrinsicTypes = {ResultType, ElemTy, Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vrsub_vx:
  ID = Intrinsic::riscv_vrsub;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vneg_v_tum:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 2;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        auto ElemTy = cast<llvm::VectorType>(ResultType)->getElementType();
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(ElemTy));

        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl, policy
          IntrinsicTypes = {ResultType, ElemTy, Ops[4]->getType()};
        } else {
          // passthru, op1, op2, vl
          IntrinsicTypes = {ResultType, ElemTy, Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vrsub_vx_tum:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vneg_v_m:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 3;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        auto ElemTy = cast<llvm::VectorType>(ResultType)->getElementType();
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(ElemTy));

        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl, policy
          IntrinsicTypes = {ResultType, ElemTy, Ops[4]->getType()};
        } else {
          // passthru, op1, op2, vl
          IntrinsicTypes = {ResultType, ElemTy, Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vrsub_vx_m:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vneg_v_tumu:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 0;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        auto ElemTy = cast<llvm::VectorType>(ResultType)->getElementType();
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(ElemTy));

        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl, policy
          IntrinsicTypes = {ResultType, ElemTy, Ops[4]->getType()};
        } else {
          // passthru, op1, op2, vl
          IntrinsicTypes = {ResultType, ElemTy, Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vrsub_vx_tumu:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vneg_v_mu:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 1;
IsMasked = true;

      {
        if (IsMasked) {
          std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
          if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        } else {
          if (PolicyAttrs & RVV_VTA)
            Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
        }
        auto ElemTy = cast<llvm::VectorType>(ResultType)->getElementType();
        Ops.insert(Ops.begin() + 2, llvm::Constant::getNullValue(ElemTy));

        if (IsMasked) {
          Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
          // maskedoff, op1, op2, mask, vl, policy
          IntrinsicTypes = {ResultType, ElemTy, Ops[4]->getType()};
        } else {
          // passthru, op1, op2, vl
          IntrinsicTypes = {ResultType, ElemTy, Ops[3]->getType()};
        }
        break;
      }
      break;
case RISCVVector::BI__builtin_rvv_vrsub_vx_mu:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vsadd_vx_tu:
  ID = Intrinsic::riscv_vsadd;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsadd_vv:
case RISCVVector::BI__builtin_rvv_vsadd_vx:
  ID = Intrinsic::riscv_vsadd;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vsadd_vx_tum:
  ID = Intrinsic::riscv_vsadd_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsadd_vv_m:
case RISCVVector::BI__builtin_rvv_vsadd_vx_m:
  ID = Intrinsic::riscv_vsadd_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vsadd_vx_tumu:
  ID = Intrinsic::riscv_vsadd_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vsadd_vx_mu:
  ID = Intrinsic::riscv_vsadd_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsaddu_vv_tu:
case RISCVVector::BI__builtin_rvv_vsaddu_vx_tu:
  ID = Intrinsic::riscv_vsaddu;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsaddu_vv:
case RISCVVector::BI__builtin_rvv_vsaddu_vx:
  ID = Intrinsic::riscv_vsaddu;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsaddu_vv_tum:
case RISCVVector::BI__builtin_rvv_vsaddu_vx_tum:
  ID = Intrinsic::riscv_vsaddu_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsaddu_vv_m:
case RISCVVector::BI__builtin_rvv_vsaddu_vx_m:
  ID = Intrinsic::riscv_vsaddu_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsaddu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vsaddu_vx_tumu:
  ID = Intrinsic::riscv_vsaddu_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsaddu_vv_mu:
case RISCVVector::BI__builtin_rvv_vsaddu_vx_mu:
  ID = Intrinsic::riscv_vsaddu_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsbc_vvm_tu:
case RISCVVector::BI__builtin_rvv_vsbc_vxm_tu:
  ID = Intrinsic::riscv_vsbc;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsbc_vvm:
case RISCVVector::BI__builtin_rvv_vsbc_vxm:
  ID = Intrinsic::riscv_vsbc;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vse8_v:
case RISCVVector::BI__builtin_rvv_vse16_v:
case RISCVVector::BI__builtin_rvv_vse32_v:
case RISCVVector::BI__builtin_rvv_vse64_v:
  ID = Intrinsic::riscv_vse;
  PolicyAttrs = 3;
IsMasked = false;

      if (IsMasked) {
        // Builtin: (mask, ptr, value, vl). Intrinsic: (value, ptr, mask, vl)
        std::swap(Ops[0], Ops[2]);
      } else {
        // Builtin: (ptr, value, vl). Intrinsic: (value, ptr, vl)
        std::swap(Ops[0], Ops[1]);
      }
      Ops[1] = Builder.CreateBitCast(Ops[1], Ops[0]->getType()->getPointerTo());
      if (IsMasked)
        IntrinsicTypes = {Ops[0]->getType(), Ops[3]->getType()};
      else
        IntrinsicTypes = {Ops[0]->getType(), Ops[2]->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vse8_v_m:
case RISCVVector::BI__builtin_rvv_vse16_v_m:
case RISCVVector::BI__builtin_rvv_vse32_v_m:
case RISCVVector::BI__builtin_rvv_vse64_v_m:
  ID = Intrinsic::riscv_vse_mask;
  PolicyAttrs = 3;
IsMasked = true;

      if (IsMasked) {
        // Builtin: (mask, ptr, value, vl). Intrinsic: (value, ptr, mask, vl)
        std::swap(Ops[0], Ops[2]);
      } else {
        // Builtin: (ptr, value, vl). Intrinsic: (value, ptr, vl)
        std::swap(Ops[0], Ops[1]);
      }
      Ops[1] = Builder.CreateBitCast(Ops[1], Ops[0]->getType()->getPointerTo());
      if (IsMasked)
        IntrinsicTypes = {Ops[0]->getType(), Ops[3]->getType()};
      else
        IntrinsicTypes = {Ops[0]->getType(), Ops[2]->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vsetvli:
  ID = Intrinsic::riscv_vsetvli;
  PolicyAttrs = 3;
IsMasked = false;
IntrinsicTypes = {ResultType};break;
case RISCVVector::BI__builtin_rvv_vsetvlimax:
  ID = Intrinsic::riscv_vsetvlimax;
  PolicyAttrs = 3;
IsMasked = false;
IntrinsicTypes = {ResultType};break;
case RISCVVector::BI__builtin_rvv_vsext_vf2_tu:
case RISCVVector::BI__builtin_rvv_vsext_vf4_tu:
case RISCVVector::BI__builtin_rvv_vsext_vf8_tu:
  ID = Intrinsic::riscv_vsext;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsext_vf2:
case RISCVVector::BI__builtin_rvv_vsext_vf4:
case RISCVVector::BI__builtin_rvv_vsext_vf8:
  ID = Intrinsic::riscv_vsext;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsext_vf2_tum:
case RISCVVector::BI__builtin_rvv_vsext_vf4_tum:
case RISCVVector::BI__builtin_rvv_vsext_vf8_tum:
  ID = Intrinsic::riscv_vsext_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsext_vf2_m:
case RISCVVector::BI__builtin_rvv_vsext_vf4_m:
case RISCVVector::BI__builtin_rvv_vsext_vf8_m:
  ID = Intrinsic::riscv_vsext_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsext_vf2_tumu:
case RISCVVector::BI__builtin_rvv_vsext_vf4_tumu:
case RISCVVector::BI__builtin_rvv_vsext_vf8_tumu:
  ID = Intrinsic::riscv_vsext_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsext_vf2_mu:
case RISCVVector::BI__builtin_rvv_vsext_vf4_mu:
case RISCVVector::BI__builtin_rvv_vsext_vf8_mu:
  ID = Intrinsic::riscv_vsext_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1down_vx_tu:
  ID = Intrinsic::riscv_vslide1down;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1down_vx:
  ID = Intrinsic::riscv_vslide1down;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1down_vx_tum:
  ID = Intrinsic::riscv_vslide1down_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1down_vx_m:
  ID = Intrinsic::riscv_vslide1down_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1down_vx_tumu:
  ID = Intrinsic::riscv_vslide1down_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1down_vx_mu:
  ID = Intrinsic::riscv_vslide1down_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1up_vx_tu:
  ID = Intrinsic::riscv_vslide1up;
  PolicyAttrs = 2;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1up_vx:
  ID = Intrinsic::riscv_vslide1up;
  PolicyAttrs = 3;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1up_vx_tum:
  ID = Intrinsic::riscv_vslide1up_mask;
  PolicyAttrs = 2;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1up_vx_m:
  ID = Intrinsic::riscv_vslide1up_mask;
  PolicyAttrs = 3;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1up_vx_tumu:
  ID = Intrinsic::riscv_vslide1up_mask;
  PolicyAttrs = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1up_vx_mu:
  ID = Intrinsic::riscv_vslide1up_mask;
  PolicyAttrs = 1;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslidedown_vx_tu:
  ID = Intrinsic::riscv_vslidedown;
  PolicyAttrs = 2;
IsMasked = false;

      if (IsMasked) {
        std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
        if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      } else {
        if (PolicyAttrs & RVV_VTA)
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      }

      Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vslidedown_vx:
  ID = Intrinsic::riscv_vslidedown;
  PolicyAttrs = 3;
IsMasked = false;

      if (IsMasked) {
        std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
        if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      } else {
        if (PolicyAttrs & RVV_VTA)
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      }

      Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vslidedown_vx_tum:
  ID = Intrinsic::riscv_vslidedown_mask;
  PolicyAttrs = 2;
IsMasked = true;

      if (IsMasked) {
        std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
        if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      } else {
        if (PolicyAttrs & RVV_VTA)
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      }

      Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vslidedown_vx_m:
  ID = Intrinsic::riscv_vslidedown_mask;
  PolicyAttrs = 3;
IsMasked = true;

      if (IsMasked) {
        std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
        if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      } else {
        if (PolicyAttrs & RVV_VTA)
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      }

      Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vslidedown_vx_tumu:
  ID = Intrinsic::riscv_vslidedown_mask;
  PolicyAttrs = 0;
IsMasked = true;

