/*
 * Copyright (c) 2018 Google, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.common.truth;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.truth.Truth.assertThat;

import org.junit.ComparisonFailure;

final class TestPlatform {
  static boolean isGwt() {
    return false;
  }

  static boolean isAndroid() {
    return checkNotNull(System.getProperty("java.runtime.name", "")).contains("Android");
  }

  static void assertIsComparisonFailureIfAvailable(Throwable t) {
    assertThat(t).isInstanceOf(ComparisonFailure.class);
  }

  static void assertIsNotComparisonFailureIfAvailable(Throwable t) {
    assertThat(t).isNotInstanceOf(ComparisonFailure.class);
  }

  private TestPlatform() {}
}
