/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.elementvalues.AnnotationElementValue;

public class RuntimeAnnotationsAttribute
extends AttributeInfo {
    private static final int INITIAL_LENGTH = 2;
    protected AnnotationElementValue[] runtimeAnnotations;

    public AnnotationElementValue[] getRuntimeAnnotations() {
        return this.runtimeAnnotations;
    }

    public void setRuntimeAnnotations(AnnotationElementValue[] annotationElementValueArray) {
        this.runtimeAnnotations = annotationElementValueArray;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        int n = dataInput.readUnsignedShort();
        this.runtimeAnnotations = new AnnotationElementValue[n];
        for (int i = 0; i < n; ++i) {
            this.runtimeAnnotations[i] = new AnnotationElementValue();
            this.runtimeAnnotations[i].setClassFile(this.classFile);
            this.runtimeAnnotations[i].read(dataInput);
        }
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        int n = this.getLength(this.runtimeAnnotations);
        dataOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            this.runtimeAnnotations[i].write(dataOutput);
        }
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    public int getAttributeLength() {
        int n = 2;
        for (int i = 0; i < this.runtimeAnnotations.length; ++i) {
            n += this.runtimeAnnotations[i].getLength();
        }
        return n;
    }
}

