import OlMap from 'ol/Map';
import type { Pixel } from 'ol/pixel';
import { EventsKey } from 'ol/events';
import BaseEvent from 'ol/events/Event';
import { ObjectEvent } from 'ol/Object';
import Control from 'ol/control/Control';
import { TinyEmitter } from 'tiny-emitter';
import type { Coordinate } from 'ol/coordinate';
import { Types as ObjectEventTypes } from 'ol/ObjectEventType';
import { CombinedOnSignature, EventTypes as OlEventTypes, OnSignature } from 'ol/Observable';
import { ContextMenuEvent, CustomEventTypes, Item, MenuEntry, Options } from './types';
export default class ContextMenu extends Control {
    protected map: OlMap;
    protected emitter: TinyEmitter;
    protected container: HTMLDivElement;
    protected coordinate: Coordinate;
    protected pixel: Pixel;
    protected contextMenuEventListener: (evt: MouseEvent) => void;
    protected entryCallbackEventListener: (evt: MouseEvent) => void;
    protected mapMoveListener: () => void;
    protected lineHeight: number;
    protected disabled: boolean;
    protected opened: boolean;
    protected items: Item[];
    protected menuEntries: Map<string, MenuEntry>;
    on: OnSignature<OlEventTypes | `${CustomEventTypes.CLOSE}`, BaseEvent, EventsKey> & OnSignature<`${CustomEventTypes.BEFOREOPEN}` | `${CustomEventTypes.OPEN}`, ContextMenuEvent, EventsKey> & OnSignature<ObjectEventTypes, ObjectEvent, EventsKey> & CombinedOnSignature<`${CustomEventTypes.BEFOREOPEN}` | `${CustomEventTypes.OPEN}` | ObjectEventTypes | `${CustomEventTypes.CLOSE}` | OlEventTypes, EventsKey>;
    once: OnSignature<OlEventTypes | `${CustomEventTypes.CLOSE}`, BaseEvent, EventsKey> & OnSignature<`${CustomEventTypes.BEFOREOPEN}` | `${CustomEventTypes.OPEN}`, ContextMenuEvent, EventsKey> & OnSignature<ObjectEventTypes, ObjectEvent, EventsKey> & CombinedOnSignature<`${CustomEventTypes.BEFOREOPEN}` | `${CustomEventTypes.OPEN}` | ObjectEventTypes | `${CustomEventTypes.CLOSE}` | OlEventTypes, EventsKey>;
    un: OnSignature<OlEventTypes | `${CustomEventTypes.CLOSE}`, BaseEvent, void> & OnSignature<`${CustomEventTypes.BEFOREOPEN}` | `${CustomEventTypes.OPEN}`, ContextMenuEvent, EventsKey> & OnSignature<ObjectEventTypes, ObjectEvent, void> & CombinedOnSignature<`${CustomEventTypes.BEFOREOPEN}` | `${CustomEventTypes.OPEN}` | ObjectEventTypes | `${CustomEventTypes.CLOSE}` | OlEventTypes, void>;
    options: Options;
    constructor(opts?: Partial<Options>);
    clear(): void;
    enable(): void;
    disable(): void;
    getDefaultItems(): import("./types").SingleItem[];
    countItems(): number;
    extend(items: Item[]): void;
    closeMenu(): void;
    isOpen(): boolean;
    updatePosition(pixel: Pixel): void;
    pop(): void;
    shift(): void;
    push(item: Item): void;
    setMap(map: OlMap): void;
    protected removeListeners(): void;
    protected removeMenuEntry(id: string): void;
    protected handleContextMenu(evt: MouseEvent): void;
    protected openMenu(evt: MouseEvent): void;
    protected getMenuEntriesLength(): number;
    protected positionContainer(): void;
    protected handleMapMove(): void;
    protected handleEntryCallback(evt: MouseEvent): void;
    protected handleAddMenuEntry(item: MenuEntry, element: HTMLLIElement): void;
}
