// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package verifiedpermissionsiface provides an interface to enable mocking the Amazon Verified Permissions service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package verifiedpermissionsiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/verifiedpermissions"
)

// VerifiedPermissionsAPI provides an interface to enable mocking the
// verifiedpermissions.VerifiedPermissions service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Verified Permissions.
//	func myFunc(svc verifiedpermissionsiface.VerifiedPermissionsAPI) bool {
//	    // Make svc.BatchIsAuthorized request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := verifiedpermissions.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockVerifiedPermissionsClient struct {
//	    verifiedpermissionsiface.VerifiedPermissionsAPI
//	}
//	func (m *mockVerifiedPermissionsClient) BatchIsAuthorized(input *verifiedpermissions.BatchIsAuthorizedInput) (*verifiedpermissions.BatchIsAuthorizedOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockVerifiedPermissionsClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type VerifiedPermissionsAPI interface {
	BatchIsAuthorized(*verifiedpermissions.BatchIsAuthorizedInput) (*verifiedpermissions.BatchIsAuthorizedOutput, error)
	BatchIsAuthorizedWithContext(aws.Context, *verifiedpermissions.BatchIsAuthorizedInput, ...request.Option) (*verifiedpermissions.BatchIsAuthorizedOutput, error)
	BatchIsAuthorizedRequest(*verifiedpermissions.BatchIsAuthorizedInput) (*request.Request, *verifiedpermissions.BatchIsAuthorizedOutput)

	BatchIsAuthorizedWithToken(*verifiedpermissions.BatchIsAuthorizedWithTokenInput) (*verifiedpermissions.BatchIsAuthorizedWithTokenOutput, error)
	BatchIsAuthorizedWithTokenWithContext(aws.Context, *verifiedpermissions.BatchIsAuthorizedWithTokenInput, ...request.Option) (*verifiedpermissions.BatchIsAuthorizedWithTokenOutput, error)
	BatchIsAuthorizedWithTokenRequest(*verifiedpermissions.BatchIsAuthorizedWithTokenInput) (*request.Request, *verifiedpermissions.BatchIsAuthorizedWithTokenOutput)

	CreateIdentitySource(*verifiedpermissions.CreateIdentitySourceInput) (*verifiedpermissions.CreateIdentitySourceOutput, error)
	CreateIdentitySourceWithContext(aws.Context, *verifiedpermissions.CreateIdentitySourceInput, ...request.Option) (*verifiedpermissions.CreateIdentitySourceOutput, error)
	CreateIdentitySourceRequest(*verifiedpermissions.CreateIdentitySourceInput) (*request.Request, *verifiedpermissions.CreateIdentitySourceOutput)

	CreatePolicy(*verifiedpermissions.CreatePolicyInput) (*verifiedpermissions.CreatePolicyOutput, error)
	CreatePolicyWithContext(aws.Context, *verifiedpermissions.CreatePolicyInput, ...request.Option) (*verifiedpermissions.CreatePolicyOutput, error)
	CreatePolicyRequest(*verifiedpermissions.CreatePolicyInput) (*request.Request, *verifiedpermissions.CreatePolicyOutput)

	CreatePolicyStore(*verifiedpermissions.CreatePolicyStoreInput) (*verifiedpermissions.CreatePolicyStoreOutput, error)
	CreatePolicyStoreWithContext(aws.Context, *verifiedpermissions.CreatePolicyStoreInput, ...request.Option) (*verifiedpermissions.CreatePolicyStoreOutput, error)
	CreatePolicyStoreRequest(*verifiedpermissions.CreatePolicyStoreInput) (*request.Request, *verifiedpermissions.CreatePolicyStoreOutput)

	CreatePolicyTemplate(*verifiedpermissions.CreatePolicyTemplateInput) (*verifiedpermissions.CreatePolicyTemplateOutput, error)
	CreatePolicyTemplateWithContext(aws.Context, *verifiedpermissions.CreatePolicyTemplateInput, ...request.Option) (*verifiedpermissions.CreatePolicyTemplateOutput, error)
	CreatePolicyTemplateRequest(*verifiedpermissions.CreatePolicyTemplateInput) (*request.Request, *verifiedpermissions.CreatePolicyTemplateOutput)

	DeleteIdentitySource(*verifiedpermissions.DeleteIdentitySourceInput) (*verifiedpermissions.DeleteIdentitySourceOutput, error)
	DeleteIdentitySourceWithContext(aws.Context, *verifiedpermissions.DeleteIdentitySourceInput, ...request.Option) (*verifiedpermissions.DeleteIdentitySourceOutput, error)
	DeleteIdentitySourceRequest(*verifiedpermissions.DeleteIdentitySourceInput) (*request.Request, *verifiedpermissions.DeleteIdentitySourceOutput)

	DeletePolicy(*verifiedpermissions.DeletePolicyInput) (*verifiedpermissions.DeletePolicyOutput, error)
	DeletePolicyWithContext(aws.Context, *verifiedpermissions.DeletePolicyInput, ...request.Option) (*verifiedpermissions.DeletePolicyOutput, error)
	DeletePolicyRequest(*verifiedpermissions.DeletePolicyInput) (*request.Request, *verifiedpermissions.DeletePolicyOutput)

	DeletePolicyStore(*verifiedpermissions.DeletePolicyStoreInput) (*verifiedpermissions.DeletePolicyStoreOutput, error)
	DeletePolicyStoreWithContext(aws.Context, *verifiedpermissions.DeletePolicyStoreInput, ...request.Option) (*verifiedpermissions.DeletePolicyStoreOutput, error)
	DeletePolicyStoreRequest(*verifiedpermissions.DeletePolicyStoreInput) (*request.Request, *verifiedpermissions.DeletePolicyStoreOutput)

	DeletePolicyTemplate(*verifiedpermissions.DeletePolicyTemplateInput) (*verifiedpermissions.DeletePolicyTemplateOutput, error)
	DeletePolicyTemplateWithContext(aws.Context, *verifiedpermissions.DeletePolicyTemplateInput, ...request.Option) (*verifiedpermissions.DeletePolicyTemplateOutput, error)
	DeletePolicyTemplateRequest(*verifiedpermissions.DeletePolicyTemplateInput) (*request.Request, *verifiedpermissions.DeletePolicyTemplateOutput)

	GetIdentitySource(*verifiedpermissions.GetIdentitySourceInput) (*verifiedpermissions.GetIdentitySourceOutput, error)
	GetIdentitySourceWithContext(aws.Context, *verifiedpermissions.GetIdentitySourceInput, ...request.Option) (*verifiedpermissions.GetIdentitySourceOutput, error)
	GetIdentitySourceRequest(*verifiedpermissions.GetIdentitySourceInput) (*request.Request, *verifiedpermissions.GetIdentitySourceOutput)

	GetPolicy(*verifiedpermissions.GetPolicyInput) (*verifiedpermissions.GetPolicyOutput, error)
	GetPolicyWithContext(aws.Context, *verifiedpermissions.GetPolicyInput, ...request.Option) (*verifiedpermissions.GetPolicyOutput, error)
	GetPolicyRequest(*verifiedpermissions.GetPolicyInput) (*request.Request, *verifiedpermissions.GetPolicyOutput)

	GetPolicyStore(*verifiedpermissions.GetPolicyStoreInput) (*verifiedpermissions.GetPolicyStoreOutput, error)
	GetPolicyStoreWithContext(aws.Context, *verifiedpermissions.GetPolicyStoreInput, ...request.Option) (*verifiedpermissions.GetPolicyStoreOutput, error)
	GetPolicyStoreRequest(*verifiedpermissions.GetPolicyStoreInput) (*request.Request, *verifiedpermissions.GetPolicyStoreOutput)

	GetPolicyTemplate(*verifiedpermissions.GetPolicyTemplateInput) (*verifiedpermissions.GetPolicyTemplateOutput, error)
	GetPolicyTemplateWithContext(aws.Context, *verifiedpermissions.GetPolicyTemplateInput, ...request.Option) (*verifiedpermissions.GetPolicyTemplateOutput, error)
	GetPolicyTemplateRequest(*verifiedpermissions.GetPolicyTemplateInput) (*request.Request, *verifiedpermissions.GetPolicyTemplateOutput)

	GetSchema(*verifiedpermissions.GetSchemaInput) (*verifiedpermissions.GetSchemaOutput, error)
	GetSchemaWithContext(aws.Context, *verifiedpermissions.GetSchemaInput, ...request.Option) (*verifiedpermissions.GetSchemaOutput, error)
	GetSchemaRequest(*verifiedpermissions.GetSchemaInput) (*request.Request, *verifiedpermissions.GetSchemaOutput)

	IsAuthorized(*verifiedpermissions.IsAuthorizedInput) (*verifiedpermissions.IsAuthorizedOutput, error)
	IsAuthorizedWithContext(aws.Context, *verifiedpermissions.IsAuthorizedInput, ...request.Option) (*verifiedpermissions.IsAuthorizedOutput, error)
	IsAuthorizedRequest(*verifiedpermissions.IsAuthorizedInput) (*request.Request, *verifiedpermissions.IsAuthorizedOutput)

	IsAuthorizedWithToken(*verifiedpermissions.IsAuthorizedWithTokenInput) (*verifiedpermissions.IsAuthorizedWithTokenOutput, error)
	IsAuthorizedWithTokenWithContext(aws.Context, *verifiedpermissions.IsAuthorizedWithTokenInput, ...request.Option) (*verifiedpermissions.IsAuthorizedWithTokenOutput, error)
	IsAuthorizedWithTokenRequest(*verifiedpermissions.IsAuthorizedWithTokenInput) (*request.Request, *verifiedpermissions.IsAuthorizedWithTokenOutput)

	ListIdentitySources(*verifiedpermissions.ListIdentitySourcesInput) (*verifiedpermissions.ListIdentitySourcesOutput, error)
	ListIdentitySourcesWithContext(aws.Context, *verifiedpermissions.ListIdentitySourcesInput, ...request.Option) (*verifiedpermissions.ListIdentitySourcesOutput, error)
	ListIdentitySourcesRequest(*verifiedpermissions.ListIdentitySourcesInput) (*request.Request, *verifiedpermissions.ListIdentitySourcesOutput)

	ListIdentitySourcesPages(*verifiedpermissions.ListIdentitySourcesInput, func(*verifiedpermissions.ListIdentitySourcesOutput, bool) bool) error
	ListIdentitySourcesPagesWithContext(aws.Context, *verifiedpermissions.ListIdentitySourcesInput, func(*verifiedpermissions.ListIdentitySourcesOutput, bool) bool, ...request.Option) error

	ListPolicies(*verifiedpermissions.ListPoliciesInput) (*verifiedpermissions.ListPoliciesOutput, error)
	ListPoliciesWithContext(aws.Context, *verifiedpermissions.ListPoliciesInput, ...request.Option) (*verifiedpermissions.ListPoliciesOutput, error)
	ListPoliciesRequest(*verifiedpermissions.ListPoliciesInput) (*request.Request, *verifiedpermissions.ListPoliciesOutput)

	ListPoliciesPages(*verifiedpermissions.ListPoliciesInput, func(*verifiedpermissions.ListPoliciesOutput, bool) bool) error
	ListPoliciesPagesWithContext(aws.Context, *verifiedpermissions.ListPoliciesInput, func(*verifiedpermissions.ListPoliciesOutput, bool) bool, ...request.Option) error

	ListPolicyStores(*verifiedpermissions.ListPolicyStoresInput) (*verifiedpermissions.ListPolicyStoresOutput, error)
	ListPolicyStoresWithContext(aws.Context, *verifiedpermissions.ListPolicyStoresInput, ...request.Option) (*verifiedpermissions.ListPolicyStoresOutput, error)
	ListPolicyStoresRequest(*verifiedpermissions.ListPolicyStoresInput) (*request.Request, *verifiedpermissions.ListPolicyStoresOutput)

	ListPolicyStoresPages(*verifiedpermissions.ListPolicyStoresInput, func(*verifiedpermissions.ListPolicyStoresOutput, bool) bool) error
	ListPolicyStoresPagesWithContext(aws.Context, *verifiedpermissions.ListPolicyStoresInput, func(*verifiedpermissions.ListPolicyStoresOutput, bool) bool, ...request.Option) error

	ListPolicyTemplates(*verifiedpermissions.ListPolicyTemplatesInput) (*verifiedpermissions.ListPolicyTemplatesOutput, error)
	ListPolicyTemplatesWithContext(aws.Context, *verifiedpermissions.ListPolicyTemplatesInput, ...request.Option) (*verifiedpermissions.ListPolicyTemplatesOutput, error)
	ListPolicyTemplatesRequest(*verifiedpermissions.ListPolicyTemplatesInput) (*request.Request, *verifiedpermissions.ListPolicyTemplatesOutput)

	ListPolicyTemplatesPages(*verifiedpermissions.ListPolicyTemplatesInput, func(*verifiedpermissions.ListPolicyTemplatesOutput, bool) bool) error
	ListPolicyTemplatesPagesWithContext(aws.Context, *verifiedpermissions.ListPolicyTemplatesInput, func(*verifiedpermissions.ListPolicyTemplatesOutput, bool) bool, ...request.Option) error

	PutSchema(*verifiedpermissions.PutSchemaInput) (*verifiedpermissions.PutSchemaOutput, error)
	PutSchemaWithContext(aws.Context, *verifiedpermissions.PutSchemaInput, ...request.Option) (*verifiedpermissions.PutSchemaOutput, error)
	PutSchemaRequest(*verifiedpermissions.PutSchemaInput) (*request.Request, *verifiedpermissions.PutSchemaOutput)

	UpdateIdentitySource(*verifiedpermissions.UpdateIdentitySourceInput) (*verifiedpermissions.UpdateIdentitySourceOutput, error)
	UpdateIdentitySourceWithContext(aws.Context, *verifiedpermissions.UpdateIdentitySourceInput, ...request.Option) (*verifiedpermissions.UpdateIdentitySourceOutput, error)
	UpdateIdentitySourceRequest(*verifiedpermissions.UpdateIdentitySourceInput) (*request.Request, *verifiedpermissions.UpdateIdentitySourceOutput)

	UpdatePolicy(*verifiedpermissions.UpdatePolicyInput) (*verifiedpermissions.UpdatePolicyOutput, error)
	UpdatePolicyWithContext(aws.Context, *verifiedpermissions.UpdatePolicyInput, ...request.Option) (*verifiedpermissions.UpdatePolicyOutput, error)
	UpdatePolicyRequest(*verifiedpermissions.UpdatePolicyInput) (*request.Request, *verifiedpermissions.UpdatePolicyOutput)

	UpdatePolicyStore(*verifiedpermissions.UpdatePolicyStoreInput) (*verifiedpermissions.UpdatePolicyStoreOutput, error)
	UpdatePolicyStoreWithContext(aws.Context, *verifiedpermissions.UpdatePolicyStoreInput, ...request.Option) (*verifiedpermissions.UpdatePolicyStoreOutput, error)
	UpdatePolicyStoreRequest(*verifiedpermissions.UpdatePolicyStoreInput) (*request.Request, *verifiedpermissions.UpdatePolicyStoreOutput)

	UpdatePolicyTemplate(*verifiedpermissions.UpdatePolicyTemplateInput) (*verifiedpermissions.UpdatePolicyTemplateOutput, error)
	UpdatePolicyTemplateWithContext(aws.Context, *verifiedpermissions.UpdatePolicyTemplateInput, ...request.Option) (*verifiedpermissions.UpdatePolicyTemplateOutput, error)
	UpdatePolicyTemplateRequest(*verifiedpermissions.UpdatePolicyTemplateInput) (*request.Request, *verifiedpermissions.UpdatePolicyTemplateOutput)
}

var _ VerifiedPermissionsAPI = (*verifiedpermissions.VerifiedPermissions)(nil)
