// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package resiliencehubiface provides an interface to enable mocking the AWS Resilience Hub service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package resiliencehubiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/resiliencehub"
)

// ResilienceHubAPI provides an interface to enable mocking the
// resiliencehub.ResilienceHub service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Resilience Hub.
//	func myFunc(svc resiliencehubiface.ResilienceHubAPI) bool {
//	    // Make svc.AddDraftAppVersionResourceMappings request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := resiliencehub.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockResilienceHubClient struct {
//	    resiliencehubiface.ResilienceHubAPI
//	}
//	func (m *mockResilienceHubClient) AddDraftAppVersionResourceMappings(input *resiliencehub.AddDraftAppVersionResourceMappingsInput) (*resiliencehub.AddDraftAppVersionResourceMappingsOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockResilienceHubClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ResilienceHubAPI interface {
	AddDraftAppVersionResourceMappings(*resiliencehub.AddDraftAppVersionResourceMappingsInput) (*resiliencehub.AddDraftAppVersionResourceMappingsOutput, error)
	AddDraftAppVersionResourceMappingsWithContext(aws.Context, *resiliencehub.AddDraftAppVersionResourceMappingsInput, ...request.Option) (*resiliencehub.AddDraftAppVersionResourceMappingsOutput, error)
	AddDraftAppVersionResourceMappingsRequest(*resiliencehub.AddDraftAppVersionResourceMappingsInput) (*request.Request, *resiliencehub.AddDraftAppVersionResourceMappingsOutput)

	BatchUpdateRecommendationStatus(*resiliencehub.BatchUpdateRecommendationStatusInput) (*resiliencehub.BatchUpdateRecommendationStatusOutput, error)
	BatchUpdateRecommendationStatusWithContext(aws.Context, *resiliencehub.BatchUpdateRecommendationStatusInput, ...request.Option) (*resiliencehub.BatchUpdateRecommendationStatusOutput, error)
	BatchUpdateRecommendationStatusRequest(*resiliencehub.BatchUpdateRecommendationStatusInput) (*request.Request, *resiliencehub.BatchUpdateRecommendationStatusOutput)

	CreateApp(*resiliencehub.CreateAppInput) (*resiliencehub.CreateAppOutput, error)
	CreateAppWithContext(aws.Context, *resiliencehub.CreateAppInput, ...request.Option) (*resiliencehub.CreateAppOutput, error)
	CreateAppRequest(*resiliencehub.CreateAppInput) (*request.Request, *resiliencehub.CreateAppOutput)

	CreateAppVersionAppComponent(*resiliencehub.CreateAppVersionAppComponentInput) (*resiliencehub.CreateAppVersionAppComponentOutput, error)
	CreateAppVersionAppComponentWithContext(aws.Context, *resiliencehub.CreateAppVersionAppComponentInput, ...request.Option) (*resiliencehub.CreateAppVersionAppComponentOutput, error)
	CreateAppVersionAppComponentRequest(*resiliencehub.CreateAppVersionAppComponentInput) (*request.Request, *resiliencehub.CreateAppVersionAppComponentOutput)

	CreateAppVersionResource(*resiliencehub.CreateAppVersionResourceInput) (*resiliencehub.CreateAppVersionResourceOutput, error)
	CreateAppVersionResourceWithContext(aws.Context, *resiliencehub.CreateAppVersionResourceInput, ...request.Option) (*resiliencehub.CreateAppVersionResourceOutput, error)
	CreateAppVersionResourceRequest(*resiliencehub.CreateAppVersionResourceInput) (*request.Request, *resiliencehub.CreateAppVersionResourceOutput)

	CreateRecommendationTemplate(*resiliencehub.CreateRecommendationTemplateInput) (*resiliencehub.CreateRecommendationTemplateOutput, error)
	CreateRecommendationTemplateWithContext(aws.Context, *resiliencehub.CreateRecommendationTemplateInput, ...request.Option) (*resiliencehub.CreateRecommendationTemplateOutput, error)
	CreateRecommendationTemplateRequest(*resiliencehub.CreateRecommendationTemplateInput) (*request.Request, *resiliencehub.CreateRecommendationTemplateOutput)

	CreateResiliencyPolicy(*resiliencehub.CreateResiliencyPolicyInput) (*resiliencehub.CreateResiliencyPolicyOutput, error)
	CreateResiliencyPolicyWithContext(aws.Context, *resiliencehub.CreateResiliencyPolicyInput, ...request.Option) (*resiliencehub.CreateResiliencyPolicyOutput, error)
	CreateResiliencyPolicyRequest(*resiliencehub.CreateResiliencyPolicyInput) (*request.Request, *resiliencehub.CreateResiliencyPolicyOutput)

	DeleteApp(*resiliencehub.DeleteAppInput) (*resiliencehub.DeleteAppOutput, error)
	DeleteAppWithContext(aws.Context, *resiliencehub.DeleteAppInput, ...request.Option) (*resiliencehub.DeleteAppOutput, error)
	DeleteAppRequest(*resiliencehub.DeleteAppInput) (*request.Request, *resiliencehub.DeleteAppOutput)

	DeleteAppAssessment(*resiliencehub.DeleteAppAssessmentInput) (*resiliencehub.DeleteAppAssessmentOutput, error)
	DeleteAppAssessmentWithContext(aws.Context, *resiliencehub.DeleteAppAssessmentInput, ...request.Option) (*resiliencehub.DeleteAppAssessmentOutput, error)
	DeleteAppAssessmentRequest(*resiliencehub.DeleteAppAssessmentInput) (*request.Request, *resiliencehub.DeleteAppAssessmentOutput)

	DeleteAppInputSource(*resiliencehub.DeleteAppInputSourceInput) (*resiliencehub.DeleteAppInputSourceOutput, error)
	DeleteAppInputSourceWithContext(aws.Context, *resiliencehub.DeleteAppInputSourceInput, ...request.Option) (*resiliencehub.DeleteAppInputSourceOutput, error)
	DeleteAppInputSourceRequest(*resiliencehub.DeleteAppInputSourceInput) (*request.Request, *resiliencehub.DeleteAppInputSourceOutput)

	DeleteAppVersionAppComponent(*resiliencehub.DeleteAppVersionAppComponentInput) (*resiliencehub.DeleteAppVersionAppComponentOutput, error)
	DeleteAppVersionAppComponentWithContext(aws.Context, *resiliencehub.DeleteAppVersionAppComponentInput, ...request.Option) (*resiliencehub.DeleteAppVersionAppComponentOutput, error)
	DeleteAppVersionAppComponentRequest(*resiliencehub.DeleteAppVersionAppComponentInput) (*request.Request, *resiliencehub.DeleteAppVersionAppComponentOutput)

	DeleteAppVersionResource(*resiliencehub.DeleteAppVersionResourceInput) (*resiliencehub.DeleteAppVersionResourceOutput, error)
	DeleteAppVersionResourceWithContext(aws.Context, *resiliencehub.DeleteAppVersionResourceInput, ...request.Option) (*resiliencehub.DeleteAppVersionResourceOutput, error)
	DeleteAppVersionResourceRequest(*resiliencehub.DeleteAppVersionResourceInput) (*request.Request, *resiliencehub.DeleteAppVersionResourceOutput)

	DeleteRecommendationTemplate(*resiliencehub.DeleteRecommendationTemplateInput) (*resiliencehub.DeleteRecommendationTemplateOutput, error)
	DeleteRecommendationTemplateWithContext(aws.Context, *resiliencehub.DeleteRecommendationTemplateInput, ...request.Option) (*resiliencehub.DeleteRecommendationTemplateOutput, error)
	DeleteRecommendationTemplateRequest(*resiliencehub.DeleteRecommendationTemplateInput) (*request.Request, *resiliencehub.DeleteRecommendationTemplateOutput)

	DeleteResiliencyPolicy(*resiliencehub.DeleteResiliencyPolicyInput) (*resiliencehub.DeleteResiliencyPolicyOutput, error)
	DeleteResiliencyPolicyWithContext(aws.Context, *resiliencehub.DeleteResiliencyPolicyInput, ...request.Option) (*resiliencehub.DeleteResiliencyPolicyOutput, error)
	DeleteResiliencyPolicyRequest(*resiliencehub.DeleteResiliencyPolicyInput) (*request.Request, *resiliencehub.DeleteResiliencyPolicyOutput)

	DescribeApp(*resiliencehub.DescribeAppInput) (*resiliencehub.DescribeAppOutput, error)
	DescribeAppWithContext(aws.Context, *resiliencehub.DescribeAppInput, ...request.Option) (*resiliencehub.DescribeAppOutput, error)
	DescribeAppRequest(*resiliencehub.DescribeAppInput) (*request.Request, *resiliencehub.DescribeAppOutput)

	DescribeAppAssessment(*resiliencehub.DescribeAppAssessmentInput) (*resiliencehub.DescribeAppAssessmentOutput, error)
	DescribeAppAssessmentWithContext(aws.Context, *resiliencehub.DescribeAppAssessmentInput, ...request.Option) (*resiliencehub.DescribeAppAssessmentOutput, error)
	DescribeAppAssessmentRequest(*resiliencehub.DescribeAppAssessmentInput) (*request.Request, *resiliencehub.DescribeAppAssessmentOutput)

	DescribeAppVersion(*resiliencehub.DescribeAppVersionInput) (*resiliencehub.DescribeAppVersionOutput, error)
	DescribeAppVersionWithContext(aws.Context, *resiliencehub.DescribeAppVersionInput, ...request.Option) (*resiliencehub.DescribeAppVersionOutput, error)
	DescribeAppVersionRequest(*resiliencehub.DescribeAppVersionInput) (*request.Request, *resiliencehub.DescribeAppVersionOutput)

	DescribeAppVersionAppComponent(*resiliencehub.DescribeAppVersionAppComponentInput) (*resiliencehub.DescribeAppVersionAppComponentOutput, error)
	DescribeAppVersionAppComponentWithContext(aws.Context, *resiliencehub.DescribeAppVersionAppComponentInput, ...request.Option) (*resiliencehub.DescribeAppVersionAppComponentOutput, error)
	DescribeAppVersionAppComponentRequest(*resiliencehub.DescribeAppVersionAppComponentInput) (*request.Request, *resiliencehub.DescribeAppVersionAppComponentOutput)

	DescribeAppVersionResource(*resiliencehub.DescribeAppVersionResourceInput) (*resiliencehub.DescribeAppVersionResourceOutput, error)
	DescribeAppVersionResourceWithContext(aws.Context, *resiliencehub.DescribeAppVersionResourceInput, ...request.Option) (*resiliencehub.DescribeAppVersionResourceOutput, error)
	DescribeAppVersionResourceRequest(*resiliencehub.DescribeAppVersionResourceInput) (*request.Request, *resiliencehub.DescribeAppVersionResourceOutput)

	DescribeAppVersionResourcesResolutionStatus(*resiliencehub.DescribeAppVersionResourcesResolutionStatusInput) (*resiliencehub.DescribeAppVersionResourcesResolutionStatusOutput, error)
	DescribeAppVersionResourcesResolutionStatusWithContext(aws.Context, *resiliencehub.DescribeAppVersionResourcesResolutionStatusInput, ...request.Option) (*resiliencehub.DescribeAppVersionResourcesResolutionStatusOutput, error)
	DescribeAppVersionResourcesResolutionStatusRequest(*resiliencehub.DescribeAppVersionResourcesResolutionStatusInput) (*request.Request, *resiliencehub.DescribeAppVersionResourcesResolutionStatusOutput)

	DescribeAppVersionTemplate(*resiliencehub.DescribeAppVersionTemplateInput) (*resiliencehub.DescribeAppVersionTemplateOutput, error)
	DescribeAppVersionTemplateWithContext(aws.Context, *resiliencehub.DescribeAppVersionTemplateInput, ...request.Option) (*resiliencehub.DescribeAppVersionTemplateOutput, error)
	DescribeAppVersionTemplateRequest(*resiliencehub.DescribeAppVersionTemplateInput) (*request.Request, *resiliencehub.DescribeAppVersionTemplateOutput)

	DescribeDraftAppVersionResourcesImportStatus(*resiliencehub.DescribeDraftAppVersionResourcesImportStatusInput) (*resiliencehub.DescribeDraftAppVersionResourcesImportStatusOutput, error)
	DescribeDraftAppVersionResourcesImportStatusWithContext(aws.Context, *resiliencehub.DescribeDraftAppVersionResourcesImportStatusInput, ...request.Option) (*resiliencehub.DescribeDraftAppVersionResourcesImportStatusOutput, error)
	DescribeDraftAppVersionResourcesImportStatusRequest(*resiliencehub.DescribeDraftAppVersionResourcesImportStatusInput) (*request.Request, *resiliencehub.DescribeDraftAppVersionResourcesImportStatusOutput)

	DescribeResiliencyPolicy(*resiliencehub.DescribeResiliencyPolicyInput) (*resiliencehub.DescribeResiliencyPolicyOutput, error)
	DescribeResiliencyPolicyWithContext(aws.Context, *resiliencehub.DescribeResiliencyPolicyInput, ...request.Option) (*resiliencehub.DescribeResiliencyPolicyOutput, error)
	DescribeResiliencyPolicyRequest(*resiliencehub.DescribeResiliencyPolicyInput) (*request.Request, *resiliencehub.DescribeResiliencyPolicyOutput)

	ImportResourcesToDraftAppVersion(*resiliencehub.ImportResourcesToDraftAppVersionInput) (*resiliencehub.ImportResourcesToDraftAppVersionOutput, error)
	ImportResourcesToDraftAppVersionWithContext(aws.Context, *resiliencehub.ImportResourcesToDraftAppVersionInput, ...request.Option) (*resiliencehub.ImportResourcesToDraftAppVersionOutput, error)
	ImportResourcesToDraftAppVersionRequest(*resiliencehub.ImportResourcesToDraftAppVersionInput) (*request.Request, *resiliencehub.ImportResourcesToDraftAppVersionOutput)

	ListAlarmRecommendations(*resiliencehub.ListAlarmRecommendationsInput) (*resiliencehub.ListAlarmRecommendationsOutput, error)
	ListAlarmRecommendationsWithContext(aws.Context, *resiliencehub.ListAlarmRecommendationsInput, ...request.Option) (*resiliencehub.ListAlarmRecommendationsOutput, error)
	ListAlarmRecommendationsRequest(*resiliencehub.ListAlarmRecommendationsInput) (*request.Request, *resiliencehub.ListAlarmRecommendationsOutput)

	ListAlarmRecommendationsPages(*resiliencehub.ListAlarmRecommendationsInput, func(*resiliencehub.ListAlarmRecommendationsOutput, bool) bool) error
	ListAlarmRecommendationsPagesWithContext(aws.Context, *resiliencehub.ListAlarmRecommendationsInput, func(*resiliencehub.ListAlarmRecommendationsOutput, bool) bool, ...request.Option) error

	ListAppAssessmentComplianceDrifts(*resiliencehub.ListAppAssessmentComplianceDriftsInput) (*resiliencehub.ListAppAssessmentComplianceDriftsOutput, error)
	ListAppAssessmentComplianceDriftsWithContext(aws.Context, *resiliencehub.ListAppAssessmentComplianceDriftsInput, ...request.Option) (*resiliencehub.ListAppAssessmentComplianceDriftsOutput, error)
	ListAppAssessmentComplianceDriftsRequest(*resiliencehub.ListAppAssessmentComplianceDriftsInput) (*request.Request, *resiliencehub.ListAppAssessmentComplianceDriftsOutput)

	ListAppAssessmentComplianceDriftsPages(*resiliencehub.ListAppAssessmentComplianceDriftsInput, func(*resiliencehub.ListAppAssessmentComplianceDriftsOutput, bool) bool) error
	ListAppAssessmentComplianceDriftsPagesWithContext(aws.Context, *resiliencehub.ListAppAssessmentComplianceDriftsInput, func(*resiliencehub.ListAppAssessmentComplianceDriftsOutput, bool) bool, ...request.Option) error

	ListAppAssessmentResourceDrifts(*resiliencehub.ListAppAssessmentResourceDriftsInput) (*resiliencehub.ListAppAssessmentResourceDriftsOutput, error)
	ListAppAssessmentResourceDriftsWithContext(aws.Context, *resiliencehub.ListAppAssessmentResourceDriftsInput, ...request.Option) (*resiliencehub.ListAppAssessmentResourceDriftsOutput, error)
	ListAppAssessmentResourceDriftsRequest(*resiliencehub.ListAppAssessmentResourceDriftsInput) (*request.Request, *resiliencehub.ListAppAssessmentResourceDriftsOutput)

	ListAppAssessmentResourceDriftsPages(*resiliencehub.ListAppAssessmentResourceDriftsInput, func(*resiliencehub.ListAppAssessmentResourceDriftsOutput, bool) bool) error
	ListAppAssessmentResourceDriftsPagesWithContext(aws.Context, *resiliencehub.ListAppAssessmentResourceDriftsInput, func(*resiliencehub.ListAppAssessmentResourceDriftsOutput, bool) bool, ...request.Option) error

	ListAppAssessments(*resiliencehub.ListAppAssessmentsInput) (*resiliencehub.ListAppAssessmentsOutput, error)
	ListAppAssessmentsWithContext(aws.Context, *resiliencehub.ListAppAssessmentsInput, ...request.Option) (*resiliencehub.ListAppAssessmentsOutput, error)
	ListAppAssessmentsRequest(*resiliencehub.ListAppAssessmentsInput) (*request.Request, *resiliencehub.ListAppAssessmentsOutput)

	ListAppAssessmentsPages(*resiliencehub.ListAppAssessmentsInput, func(*resiliencehub.ListAppAssessmentsOutput, bool) bool) error
	ListAppAssessmentsPagesWithContext(aws.Context, *resiliencehub.ListAppAssessmentsInput, func(*resiliencehub.ListAppAssessmentsOutput, bool) bool, ...request.Option) error

	ListAppComponentCompliances(*resiliencehub.ListAppComponentCompliancesInput) (*resiliencehub.ListAppComponentCompliancesOutput, error)
	ListAppComponentCompliancesWithContext(aws.Context, *resiliencehub.ListAppComponentCompliancesInput, ...request.Option) (*resiliencehub.ListAppComponentCompliancesOutput, error)
	ListAppComponentCompliancesRequest(*resiliencehub.ListAppComponentCompliancesInput) (*request.Request, *resiliencehub.ListAppComponentCompliancesOutput)

	ListAppComponentCompliancesPages(*resiliencehub.ListAppComponentCompliancesInput, func(*resiliencehub.ListAppComponentCompliancesOutput, bool) bool) error
	ListAppComponentCompliancesPagesWithContext(aws.Context, *resiliencehub.ListAppComponentCompliancesInput, func(*resiliencehub.ListAppComponentCompliancesOutput, bool) bool, ...request.Option) error

	ListAppComponentRecommendations(*resiliencehub.ListAppComponentRecommendationsInput) (*resiliencehub.ListAppComponentRecommendationsOutput, error)
	ListAppComponentRecommendationsWithContext(aws.Context, *resiliencehub.ListAppComponentRecommendationsInput, ...request.Option) (*resiliencehub.ListAppComponentRecommendationsOutput, error)
	ListAppComponentRecommendationsRequest(*resiliencehub.ListAppComponentRecommendationsInput) (*request.Request, *resiliencehub.ListAppComponentRecommendationsOutput)

	ListAppComponentRecommendationsPages(*resiliencehub.ListAppComponentRecommendationsInput, func(*resiliencehub.ListAppComponentRecommendationsOutput, bool) bool) error
	ListAppComponentRecommendationsPagesWithContext(aws.Context, *resiliencehub.ListAppComponentRecommendationsInput, func(*resiliencehub.ListAppComponentRecommendationsOutput, bool) bool, ...request.Option) error

	ListAppInputSources(*resiliencehub.ListAppInputSourcesInput) (*resiliencehub.ListAppInputSourcesOutput, error)
	ListAppInputSourcesWithContext(aws.Context, *resiliencehub.ListAppInputSourcesInput, ...request.Option) (*resiliencehub.ListAppInputSourcesOutput, error)
	ListAppInputSourcesRequest(*resiliencehub.ListAppInputSourcesInput) (*request.Request, *resiliencehub.ListAppInputSourcesOutput)

	ListAppInputSourcesPages(*resiliencehub.ListAppInputSourcesInput, func(*resiliencehub.ListAppInputSourcesOutput, bool) bool) error
	ListAppInputSourcesPagesWithContext(aws.Context, *resiliencehub.ListAppInputSourcesInput, func(*resiliencehub.ListAppInputSourcesOutput, bool) bool, ...request.Option) error

	ListAppVersionAppComponents(*resiliencehub.ListAppVersionAppComponentsInput) (*resiliencehub.ListAppVersionAppComponentsOutput, error)
	ListAppVersionAppComponentsWithContext(aws.Context, *resiliencehub.ListAppVersionAppComponentsInput, ...request.Option) (*resiliencehub.ListAppVersionAppComponentsOutput, error)
	ListAppVersionAppComponentsRequest(*resiliencehub.ListAppVersionAppComponentsInput) (*request.Request, *resiliencehub.ListAppVersionAppComponentsOutput)

	ListAppVersionAppComponentsPages(*resiliencehub.ListAppVersionAppComponentsInput, func(*resiliencehub.ListAppVersionAppComponentsOutput, bool) bool) error
	ListAppVersionAppComponentsPagesWithContext(aws.Context, *resiliencehub.ListAppVersionAppComponentsInput, func(*resiliencehub.ListAppVersionAppComponentsOutput, bool) bool, ...request.Option) error

	ListAppVersionResourceMappings(*resiliencehub.ListAppVersionResourceMappingsInput) (*resiliencehub.ListAppVersionResourceMappingsOutput, error)
	ListAppVersionResourceMappingsWithContext(aws.Context, *resiliencehub.ListAppVersionResourceMappingsInput, ...request.Option) (*resiliencehub.ListAppVersionResourceMappingsOutput, error)
	ListAppVersionResourceMappingsRequest(*resiliencehub.ListAppVersionResourceMappingsInput) (*request.Request, *resiliencehub.ListAppVersionResourceMappingsOutput)

	ListAppVersionResourceMappingsPages(*resiliencehub.ListAppVersionResourceMappingsInput, func(*resiliencehub.ListAppVersionResourceMappingsOutput, bool) bool) error
	ListAppVersionResourceMappingsPagesWithContext(aws.Context, *resiliencehub.ListAppVersionResourceMappingsInput, func(*resiliencehub.ListAppVersionResourceMappingsOutput, bool) bool, ...request.Option) error

	ListAppVersionResources(*resiliencehub.ListAppVersionResourcesInput) (*resiliencehub.ListAppVersionResourcesOutput, error)
	ListAppVersionResourcesWithContext(aws.Context, *resiliencehub.ListAppVersionResourcesInput, ...request.Option) (*resiliencehub.ListAppVersionResourcesOutput, error)
	ListAppVersionResourcesRequest(*resiliencehub.ListAppVersionResourcesInput) (*request.Request, *resiliencehub.ListAppVersionResourcesOutput)

	ListAppVersionResourcesPages(*resiliencehub.ListAppVersionResourcesInput, func(*resiliencehub.ListAppVersionResourcesOutput, bool) bool) error
	ListAppVersionResourcesPagesWithContext(aws.Context, *resiliencehub.ListAppVersionResourcesInput, func(*resiliencehub.ListAppVersionResourcesOutput, bool) bool, ...request.Option) error

	ListAppVersions(*resiliencehub.ListAppVersionsInput) (*resiliencehub.ListAppVersionsOutput, error)
	ListAppVersionsWithContext(aws.Context, *resiliencehub.ListAppVersionsInput, ...request.Option) (*resiliencehub.ListAppVersionsOutput, error)
	ListAppVersionsRequest(*resiliencehub.ListAppVersionsInput) (*request.Request, *resiliencehub.ListAppVersionsOutput)

	ListAppVersionsPages(*resiliencehub.ListAppVersionsInput, func(*resiliencehub.ListAppVersionsOutput, bool) bool) error
	ListAppVersionsPagesWithContext(aws.Context, *resiliencehub.ListAppVersionsInput, func(*resiliencehub.ListAppVersionsOutput, bool) bool, ...request.Option) error

	ListApps(*resiliencehub.ListAppsInput) (*resiliencehub.ListAppsOutput, error)
	ListAppsWithContext(aws.Context, *resiliencehub.ListAppsInput, ...request.Option) (*resiliencehub.ListAppsOutput, error)
	ListAppsRequest(*resiliencehub.ListAppsInput) (*request.Request, *resiliencehub.ListAppsOutput)

	ListAppsPages(*resiliencehub.ListAppsInput, func(*resiliencehub.ListAppsOutput, bool) bool) error
	ListAppsPagesWithContext(aws.Context, *resiliencehub.ListAppsInput, func(*resiliencehub.ListAppsOutput, bool) bool, ...request.Option) error

	ListRecommendationTemplates(*resiliencehub.ListRecommendationTemplatesInput) (*resiliencehub.ListRecommendationTemplatesOutput, error)
	ListRecommendationTemplatesWithContext(aws.Context, *resiliencehub.ListRecommendationTemplatesInput, ...request.Option) (*resiliencehub.ListRecommendationTemplatesOutput, error)
	ListRecommendationTemplatesRequest(*resiliencehub.ListRecommendationTemplatesInput) (*request.Request, *resiliencehub.ListRecommendationTemplatesOutput)

	ListRecommendationTemplatesPages(*resiliencehub.ListRecommendationTemplatesInput, func(*resiliencehub.ListRecommendationTemplatesOutput, bool) bool) error
	ListRecommendationTemplatesPagesWithContext(aws.Context, *resiliencehub.ListRecommendationTemplatesInput, func(*resiliencehub.ListRecommendationTemplatesOutput, bool) bool, ...request.Option) error

	ListResiliencyPolicies(*resiliencehub.ListResiliencyPoliciesInput) (*resiliencehub.ListResiliencyPoliciesOutput, error)
	ListResiliencyPoliciesWithContext(aws.Context, *resiliencehub.ListResiliencyPoliciesInput, ...request.Option) (*resiliencehub.ListResiliencyPoliciesOutput, error)
	ListResiliencyPoliciesRequest(*resiliencehub.ListResiliencyPoliciesInput) (*request.Request, *resiliencehub.ListResiliencyPoliciesOutput)

	ListResiliencyPoliciesPages(*resiliencehub.ListResiliencyPoliciesInput, func(*resiliencehub.ListResiliencyPoliciesOutput, bool) bool) error
	ListResiliencyPoliciesPagesWithContext(aws.Context, *resiliencehub.ListResiliencyPoliciesInput, func(*resiliencehub.ListResiliencyPoliciesOutput, bool) bool, ...request.Option) error

	ListSopRecommendations(*resiliencehub.ListSopRecommendationsInput) (*resiliencehub.ListSopRecommendationsOutput, error)
	ListSopRecommendationsWithContext(aws.Context, *resiliencehub.ListSopRecommendationsInput, ...request.Option) (*resiliencehub.ListSopRecommendationsOutput, error)
	ListSopRecommendationsRequest(*resiliencehub.ListSopRecommendationsInput) (*request.Request, *resiliencehub.ListSopRecommendationsOutput)

	ListSopRecommendationsPages(*resiliencehub.ListSopRecommendationsInput, func(*resiliencehub.ListSopRecommendationsOutput, bool) bool) error
	ListSopRecommendationsPagesWithContext(aws.Context, *resiliencehub.ListSopRecommendationsInput, func(*resiliencehub.ListSopRecommendationsOutput, bool) bool, ...request.Option) error

	ListSuggestedResiliencyPolicies(*resiliencehub.ListSuggestedResiliencyPoliciesInput) (*resiliencehub.ListSuggestedResiliencyPoliciesOutput, error)
	ListSuggestedResiliencyPoliciesWithContext(aws.Context, *resiliencehub.ListSuggestedResiliencyPoliciesInput, ...request.Option) (*resiliencehub.ListSuggestedResiliencyPoliciesOutput, error)
	ListSuggestedResiliencyPoliciesRequest(*resiliencehub.ListSuggestedResiliencyPoliciesInput) (*request.Request, *resiliencehub.ListSuggestedResiliencyPoliciesOutput)

	ListSuggestedResiliencyPoliciesPages(*resiliencehub.ListSuggestedResiliencyPoliciesInput, func(*resiliencehub.ListSuggestedResiliencyPoliciesOutput, bool) bool) error
	ListSuggestedResiliencyPoliciesPagesWithContext(aws.Context, *resiliencehub.ListSuggestedResiliencyPoliciesInput, func(*resiliencehub.ListSuggestedResiliencyPoliciesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*resiliencehub.ListTagsForResourceInput) (*resiliencehub.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *resiliencehub.ListTagsForResourceInput, ...request.Option) (*resiliencehub.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*resiliencehub.ListTagsForResourceInput) (*request.Request, *resiliencehub.ListTagsForResourceOutput)

	ListTestRecommendations(*resiliencehub.ListTestRecommendationsInput) (*resiliencehub.ListTestRecommendationsOutput, error)
	ListTestRecommendationsWithContext(aws.Context, *resiliencehub.ListTestRecommendationsInput, ...request.Option) (*resiliencehub.ListTestRecommendationsOutput, error)
	ListTestRecommendationsRequest(*resiliencehub.ListTestRecommendationsInput) (*request.Request, *resiliencehub.ListTestRecommendationsOutput)

	ListTestRecommendationsPages(*resiliencehub.ListTestRecommendationsInput, func(*resiliencehub.ListTestRecommendationsOutput, bool) bool) error
	ListTestRecommendationsPagesWithContext(aws.Context, *resiliencehub.ListTestRecommendationsInput, func(*resiliencehub.ListTestRecommendationsOutput, bool) bool, ...request.Option) error

	ListUnsupportedAppVersionResources(*resiliencehub.ListUnsupportedAppVersionResourcesInput) (*resiliencehub.ListUnsupportedAppVersionResourcesOutput, error)
	ListUnsupportedAppVersionResourcesWithContext(aws.Context, *resiliencehub.ListUnsupportedAppVersionResourcesInput, ...request.Option) (*resiliencehub.ListUnsupportedAppVersionResourcesOutput, error)
	ListUnsupportedAppVersionResourcesRequest(*resiliencehub.ListUnsupportedAppVersionResourcesInput) (*request.Request, *resiliencehub.ListUnsupportedAppVersionResourcesOutput)

	ListUnsupportedAppVersionResourcesPages(*resiliencehub.ListUnsupportedAppVersionResourcesInput, func(*resiliencehub.ListUnsupportedAppVersionResourcesOutput, bool) bool) error
	ListUnsupportedAppVersionResourcesPagesWithContext(aws.Context, *resiliencehub.ListUnsupportedAppVersionResourcesInput, func(*resiliencehub.ListUnsupportedAppVersionResourcesOutput, bool) bool, ...request.Option) error

	PublishAppVersion(*resiliencehub.PublishAppVersionInput) (*resiliencehub.PublishAppVersionOutput, error)
	PublishAppVersionWithContext(aws.Context, *resiliencehub.PublishAppVersionInput, ...request.Option) (*resiliencehub.PublishAppVersionOutput, error)
	PublishAppVersionRequest(*resiliencehub.PublishAppVersionInput) (*request.Request, *resiliencehub.PublishAppVersionOutput)

	PutDraftAppVersionTemplate(*resiliencehub.PutDraftAppVersionTemplateInput) (*resiliencehub.PutDraftAppVersionTemplateOutput, error)
	PutDraftAppVersionTemplateWithContext(aws.Context, *resiliencehub.PutDraftAppVersionTemplateInput, ...request.Option) (*resiliencehub.PutDraftAppVersionTemplateOutput, error)
	PutDraftAppVersionTemplateRequest(*resiliencehub.PutDraftAppVersionTemplateInput) (*request.Request, *resiliencehub.PutDraftAppVersionTemplateOutput)

	RemoveDraftAppVersionResourceMappings(*resiliencehub.RemoveDraftAppVersionResourceMappingsInput) (*resiliencehub.RemoveDraftAppVersionResourceMappingsOutput, error)
	RemoveDraftAppVersionResourceMappingsWithContext(aws.Context, *resiliencehub.RemoveDraftAppVersionResourceMappingsInput, ...request.Option) (*resiliencehub.RemoveDraftAppVersionResourceMappingsOutput, error)
	RemoveDraftAppVersionResourceMappingsRequest(*resiliencehub.RemoveDraftAppVersionResourceMappingsInput) (*request.Request, *resiliencehub.RemoveDraftAppVersionResourceMappingsOutput)

	ResolveAppVersionResources(*resiliencehub.ResolveAppVersionResourcesInput) (*resiliencehub.ResolveAppVersionResourcesOutput, error)
	ResolveAppVersionResourcesWithContext(aws.Context, *resiliencehub.ResolveAppVersionResourcesInput, ...request.Option) (*resiliencehub.ResolveAppVersionResourcesOutput, error)
	ResolveAppVersionResourcesRequest(*resiliencehub.ResolveAppVersionResourcesInput) (*request.Request, *resiliencehub.ResolveAppVersionResourcesOutput)

	StartAppAssessment(*resiliencehub.StartAppAssessmentInput) (*resiliencehub.StartAppAssessmentOutput, error)
	StartAppAssessmentWithContext(aws.Context, *resiliencehub.StartAppAssessmentInput, ...request.Option) (*resiliencehub.StartAppAssessmentOutput, error)
	StartAppAssessmentRequest(*resiliencehub.StartAppAssessmentInput) (*request.Request, *resiliencehub.StartAppAssessmentOutput)

	TagResource(*resiliencehub.TagResourceInput) (*resiliencehub.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *resiliencehub.TagResourceInput, ...request.Option) (*resiliencehub.TagResourceOutput, error)
	TagResourceRequest(*resiliencehub.TagResourceInput) (*request.Request, *resiliencehub.TagResourceOutput)

	UntagResource(*resiliencehub.UntagResourceInput) (*resiliencehub.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *resiliencehub.UntagResourceInput, ...request.Option) (*resiliencehub.UntagResourceOutput, error)
	UntagResourceRequest(*resiliencehub.UntagResourceInput) (*request.Request, *resiliencehub.UntagResourceOutput)

	UpdateApp(*resiliencehub.UpdateAppInput) (*resiliencehub.UpdateAppOutput, error)
	UpdateAppWithContext(aws.Context, *resiliencehub.UpdateAppInput, ...request.Option) (*resiliencehub.UpdateAppOutput, error)
	UpdateAppRequest(*resiliencehub.UpdateAppInput) (*request.Request, *resiliencehub.UpdateAppOutput)

	UpdateAppVersion(*resiliencehub.UpdateAppVersionInput) (*resiliencehub.UpdateAppVersionOutput, error)
	UpdateAppVersionWithContext(aws.Context, *resiliencehub.UpdateAppVersionInput, ...request.Option) (*resiliencehub.UpdateAppVersionOutput, error)
	UpdateAppVersionRequest(*resiliencehub.UpdateAppVersionInput) (*request.Request, *resiliencehub.UpdateAppVersionOutput)

	UpdateAppVersionAppComponent(*resiliencehub.UpdateAppVersionAppComponentInput) (*resiliencehub.UpdateAppVersionAppComponentOutput, error)
	UpdateAppVersionAppComponentWithContext(aws.Context, *resiliencehub.UpdateAppVersionAppComponentInput, ...request.Option) (*resiliencehub.UpdateAppVersionAppComponentOutput, error)
	UpdateAppVersionAppComponentRequest(*resiliencehub.UpdateAppVersionAppComponentInput) (*request.Request, *resiliencehub.UpdateAppVersionAppComponentOutput)

	UpdateAppVersionResource(*resiliencehub.UpdateAppVersionResourceInput) (*resiliencehub.UpdateAppVersionResourceOutput, error)
	UpdateAppVersionResourceWithContext(aws.Context, *resiliencehub.UpdateAppVersionResourceInput, ...request.Option) (*resiliencehub.UpdateAppVersionResourceOutput, error)
	UpdateAppVersionResourceRequest(*resiliencehub.UpdateAppVersionResourceInput) (*request.Request, *resiliencehub.UpdateAppVersionResourceOutput)

	UpdateResiliencyPolicy(*resiliencehub.UpdateResiliencyPolicyInput) (*resiliencehub.UpdateResiliencyPolicyOutput, error)
	UpdateResiliencyPolicyWithContext(aws.Context, *resiliencehub.UpdateResiliencyPolicyInput, ...request.Option) (*resiliencehub.UpdateResiliencyPolicyOutput, error)
	UpdateResiliencyPolicyRequest(*resiliencehub.UpdateResiliencyPolicyInput) (*request.Request, *resiliencehub.UpdateResiliencyPolicyOutput)
}

var _ ResilienceHubAPI = (*resiliencehub.ResilienceHub)(nil)
