// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package migrationhuborchestrator

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateTemplate = "CreateTemplate"

// CreateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplate for more information on using the CreateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTemplateRequest method.
//	req, resp := client.CreateTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateTemplate
func (c *MigrationHubOrchestrator) CreateTemplateRequest(input *CreateTemplateInput) (req *request.Request, output *CreateTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/template",
	}

	if input == nil {
		input = &CreateTemplateInput{}
	}

	output = &CreateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTemplate API operation for AWS Migration Hub Orchestrator.
//
// Creates a migration workflow template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation CreateTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     This exception is thrown when an attempt to update or delete a resource would
//     cause an inconsistent state.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateTemplate
func (c *MigrationHubOrchestrator) CreateTemplate(input *CreateTemplateInput) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	return out, req.Send()
}

// CreateTemplateWithContext is the same as CreateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) CreateTemplateWithContext(ctx aws.Context, input *CreateTemplateInput, opts ...request.Option) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkflow = "CreateWorkflow"

// CreateWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkflow for more information on using the CreateWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkflowRequest method.
//	req, resp := client.CreateWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateWorkflow
func (c *MigrationHubOrchestrator) CreateWorkflowRequest(input *CreateWorkflowInput) (req *request.Request, output *CreateWorkflowOutput) {
	op := &request.Operation{
		Name:       opCreateWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/migrationworkflow/",
	}

	if input == nil {
		input = &CreateWorkflowInput{}
	}

	output = &CreateWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkflow API operation for AWS Migration Hub Orchestrator.
//
// Create a workflow to orchestrate your migrations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation CreateWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateWorkflow
func (c *MigrationHubOrchestrator) CreateWorkflow(input *CreateWorkflowInput) (*CreateWorkflowOutput, error) {
	req, out := c.CreateWorkflowRequest(input)
	return out, req.Send()
}

// CreateWorkflowWithContext is the same as CreateWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) CreateWorkflowWithContext(ctx aws.Context, input *CreateWorkflowInput, opts ...request.Option) (*CreateWorkflowOutput, error) {
	req, out := c.CreateWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkflowStep = "CreateWorkflowStep"

// CreateWorkflowStepRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkflowStep operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkflowStep for more information on using the CreateWorkflowStep
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkflowStepRequest method.
//	req, resp := client.CreateWorkflowStepRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateWorkflowStep
func (c *MigrationHubOrchestrator) CreateWorkflowStepRequest(input *CreateWorkflowStepInput) (req *request.Request, output *CreateWorkflowStepOutput) {
	op := &request.Operation{
		Name:       opCreateWorkflowStep,
		HTTPMethod: "POST",
		HTTPPath:   "/workflowstep",
	}

	if input == nil {
		input = &CreateWorkflowStepInput{}
	}

	output = &CreateWorkflowStepOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkflowStep API operation for AWS Migration Hub Orchestrator.
//
// Create a step in the migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation CreateWorkflowStep for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateWorkflowStep
func (c *MigrationHubOrchestrator) CreateWorkflowStep(input *CreateWorkflowStepInput) (*CreateWorkflowStepOutput, error) {
	req, out := c.CreateWorkflowStepRequest(input)
	return out, req.Send()
}

// CreateWorkflowStepWithContext is the same as CreateWorkflowStep with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkflowStep for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) CreateWorkflowStepWithContext(ctx aws.Context, input *CreateWorkflowStepInput, opts ...request.Option) (*CreateWorkflowStepOutput, error) {
	req, out := c.CreateWorkflowStepRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkflowStepGroup = "CreateWorkflowStepGroup"

// CreateWorkflowStepGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkflowStepGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkflowStepGroup for more information on using the CreateWorkflowStepGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkflowStepGroupRequest method.
//	req, resp := client.CreateWorkflowStepGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateWorkflowStepGroup
func (c *MigrationHubOrchestrator) CreateWorkflowStepGroupRequest(input *CreateWorkflowStepGroupInput) (req *request.Request, output *CreateWorkflowStepGroupOutput) {
	op := &request.Operation{
		Name:       opCreateWorkflowStepGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/workflowstepgroups",
	}

	if input == nil {
		input = &CreateWorkflowStepGroupInput{}
	}

	output = &CreateWorkflowStepGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkflowStepGroup API operation for AWS Migration Hub Orchestrator.
//
// Create a step group in a migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation CreateWorkflowStepGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/CreateWorkflowStepGroup
func (c *MigrationHubOrchestrator) CreateWorkflowStepGroup(input *CreateWorkflowStepGroupInput) (*CreateWorkflowStepGroupOutput, error) {
	req, out := c.CreateWorkflowStepGroupRequest(input)
	return out, req.Send()
}

// CreateWorkflowStepGroupWithContext is the same as CreateWorkflowStepGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkflowStepGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) CreateWorkflowStepGroupWithContext(ctx aws.Context, input *CreateWorkflowStepGroupInput, opts ...request.Option) (*CreateWorkflowStepGroupOutput, error) {
	req, out := c.CreateWorkflowStepGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplate = "DeleteTemplate"

// DeleteTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplate for more information on using the DeleteTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTemplateRequest method.
//	req, resp := client.DeleteTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteTemplate
func (c *MigrationHubOrchestrator) DeleteTemplateRequest(input *DeleteTemplateInput) (req *request.Request, output *DeleteTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/template/{id}",
	}

	if input == nil {
		input = &DeleteTemplateInput{}
	}

	output = &DeleteTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTemplate API operation for AWS Migration Hub Orchestrator.
//
// Deletes a migration workflow template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation DeleteTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteTemplate
func (c *MigrationHubOrchestrator) DeleteTemplate(input *DeleteTemplateInput) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	return out, req.Send()
}

// DeleteTemplateWithContext is the same as DeleteTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) DeleteTemplateWithContext(ctx aws.Context, input *DeleteTemplateInput, opts ...request.Option) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkflow = "DeleteWorkflow"

// DeleteWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkflow for more information on using the DeleteWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkflowRequest method.
//	req, resp := client.DeleteWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteWorkflow
func (c *MigrationHubOrchestrator) DeleteWorkflowRequest(input *DeleteWorkflowInput) (req *request.Request, output *DeleteWorkflowOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkflow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/migrationworkflow/{id}",
	}

	if input == nil {
		input = &DeleteWorkflowInput{}
	}

	output = &DeleteWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteWorkflow API operation for AWS Migration Hub Orchestrator.
//
// Delete a migration workflow. You must pause a running workflow in Migration
// Hub Orchestrator console to delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation DeleteWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteWorkflow
func (c *MigrationHubOrchestrator) DeleteWorkflow(input *DeleteWorkflowInput) (*DeleteWorkflowOutput, error) {
	req, out := c.DeleteWorkflowRequest(input)
	return out, req.Send()
}

// DeleteWorkflowWithContext is the same as DeleteWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) DeleteWorkflowWithContext(ctx aws.Context, input *DeleteWorkflowInput, opts ...request.Option) (*DeleteWorkflowOutput, error) {
	req, out := c.DeleteWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkflowStep = "DeleteWorkflowStep"

// DeleteWorkflowStepRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkflowStep operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkflowStep for more information on using the DeleteWorkflowStep
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkflowStepRequest method.
//	req, resp := client.DeleteWorkflowStepRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteWorkflowStep
func (c *MigrationHubOrchestrator) DeleteWorkflowStepRequest(input *DeleteWorkflowStepInput) (req *request.Request, output *DeleteWorkflowStepOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkflowStep,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workflowstep/{id}",
	}

	if input == nil {
		input = &DeleteWorkflowStepInput{}
	}

	output = &DeleteWorkflowStepOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkflowStep API operation for AWS Migration Hub Orchestrator.
//
// Delete a step in a migration workflow. Pause the workflow to delete a running
// step.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation DeleteWorkflowStep for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteWorkflowStep
func (c *MigrationHubOrchestrator) DeleteWorkflowStep(input *DeleteWorkflowStepInput) (*DeleteWorkflowStepOutput, error) {
	req, out := c.DeleteWorkflowStepRequest(input)
	return out, req.Send()
}

// DeleteWorkflowStepWithContext is the same as DeleteWorkflowStep with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkflowStep for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) DeleteWorkflowStepWithContext(ctx aws.Context, input *DeleteWorkflowStepInput, opts ...request.Option) (*DeleteWorkflowStepOutput, error) {
	req, out := c.DeleteWorkflowStepRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkflowStepGroup = "DeleteWorkflowStepGroup"

// DeleteWorkflowStepGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkflowStepGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkflowStepGroup for more information on using the DeleteWorkflowStepGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkflowStepGroupRequest method.
//	req, resp := client.DeleteWorkflowStepGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteWorkflowStepGroup
func (c *MigrationHubOrchestrator) DeleteWorkflowStepGroupRequest(input *DeleteWorkflowStepGroupInput) (req *request.Request, output *DeleteWorkflowStepGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkflowStepGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workflowstepgroup/{id}",
	}

	if input == nil {
		input = &DeleteWorkflowStepGroupInput{}
	}

	output = &DeleteWorkflowStepGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkflowStepGroup API operation for AWS Migration Hub Orchestrator.
//
// Delete a step group in a migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation DeleteWorkflowStepGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/DeleteWorkflowStepGroup
func (c *MigrationHubOrchestrator) DeleteWorkflowStepGroup(input *DeleteWorkflowStepGroupInput) (*DeleteWorkflowStepGroupOutput, error) {
	req, out := c.DeleteWorkflowStepGroupRequest(input)
	return out, req.Send()
}

// DeleteWorkflowStepGroupWithContext is the same as DeleteWorkflowStepGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkflowStepGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) DeleteWorkflowStepGroupWithContext(ctx aws.Context, input *DeleteWorkflowStepGroupInput, opts ...request.Option) (*DeleteWorkflowStepGroupOutput, error) {
	req, out := c.DeleteWorkflowStepGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemplate = "GetTemplate"

// GetTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemplate for more information on using the GetTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTemplateRequest method.
//	req, resp := client.GetTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetTemplate
func (c *MigrationHubOrchestrator) GetTemplateRequest(input *GetTemplateInput) (req *request.Request, output *GetTemplateOutput) {
	op := &request.Operation{
		Name:       opGetTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/migrationworkflowtemplate/{id}",
	}

	if input == nil {
		input = &GetTemplateInput{}
	}

	output = &GetTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplate API operation for AWS Migration Hub Orchestrator.
//
// Get the template you want to use for creating a migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation GetTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetTemplate
func (c *MigrationHubOrchestrator) GetTemplate(input *GetTemplateInput) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	return out, req.Send()
}

// GetTemplateWithContext is the same as GetTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) GetTemplateWithContext(ctx aws.Context, input *GetTemplateInput, opts ...request.Option) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemplateStep = "GetTemplateStep"

// GetTemplateStepRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplateStep operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemplateStep for more information on using the GetTemplateStep
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTemplateStepRequest method.
//	req, resp := client.GetTemplateStepRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetTemplateStep
func (c *MigrationHubOrchestrator) GetTemplateStepRequest(input *GetTemplateStepInput) (req *request.Request, output *GetTemplateStepOutput) {
	op := &request.Operation{
		Name:       opGetTemplateStep,
		HTTPMethod: "GET",
		HTTPPath:   "/templatestep/{id}",
	}

	if input == nil {
		input = &GetTemplateStepInput{}
	}

	output = &GetTemplateStepOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplateStep API operation for AWS Migration Hub Orchestrator.
//
// Get a specific step in a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation GetTemplateStep for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetTemplateStep
func (c *MigrationHubOrchestrator) GetTemplateStep(input *GetTemplateStepInput) (*GetTemplateStepOutput, error) {
	req, out := c.GetTemplateStepRequest(input)
	return out, req.Send()
}

// GetTemplateStepWithContext is the same as GetTemplateStep with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemplateStep for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) GetTemplateStepWithContext(ctx aws.Context, input *GetTemplateStepInput, opts ...request.Option) (*GetTemplateStepOutput, error) {
	req, out := c.GetTemplateStepRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemplateStepGroup = "GetTemplateStepGroup"

// GetTemplateStepGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplateStepGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemplateStepGroup for more information on using the GetTemplateStepGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTemplateStepGroupRequest method.
//	req, resp := client.GetTemplateStepGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetTemplateStepGroup
func (c *MigrationHubOrchestrator) GetTemplateStepGroupRequest(input *GetTemplateStepGroupInput) (req *request.Request, output *GetTemplateStepGroupOutput) {
	op := &request.Operation{
		Name:       opGetTemplateStepGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/templates/{templateId}/stepgroups/{id}",
	}

	if input == nil {
		input = &GetTemplateStepGroupInput{}
	}

	output = &GetTemplateStepGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplateStepGroup API operation for AWS Migration Hub Orchestrator.
//
// Get a step group in a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation GetTemplateStepGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetTemplateStepGroup
func (c *MigrationHubOrchestrator) GetTemplateStepGroup(input *GetTemplateStepGroupInput) (*GetTemplateStepGroupOutput, error) {
	req, out := c.GetTemplateStepGroupRequest(input)
	return out, req.Send()
}

// GetTemplateStepGroupWithContext is the same as GetTemplateStepGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemplateStepGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) GetTemplateStepGroupWithContext(ctx aws.Context, input *GetTemplateStepGroupInput, opts ...request.Option) (*GetTemplateStepGroupOutput, error) {
	req, out := c.GetTemplateStepGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkflow = "GetWorkflow"

// GetWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkflow for more information on using the GetWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkflowRequest method.
//	req, resp := client.GetWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetWorkflow
func (c *MigrationHubOrchestrator) GetWorkflowRequest(input *GetWorkflowInput) (req *request.Request, output *GetWorkflowOutput) {
	op := &request.Operation{
		Name:       opGetWorkflow,
		HTTPMethod: "GET",
		HTTPPath:   "/migrationworkflow/{id}",
	}

	if input == nil {
		input = &GetWorkflowInput{}
	}

	output = &GetWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkflow API operation for AWS Migration Hub Orchestrator.
//
// Get migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation GetWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetWorkflow
func (c *MigrationHubOrchestrator) GetWorkflow(input *GetWorkflowInput) (*GetWorkflowOutput, error) {
	req, out := c.GetWorkflowRequest(input)
	return out, req.Send()
}

// GetWorkflowWithContext is the same as GetWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) GetWorkflowWithContext(ctx aws.Context, input *GetWorkflowInput, opts ...request.Option) (*GetWorkflowOutput, error) {
	req, out := c.GetWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkflowStep = "GetWorkflowStep"

// GetWorkflowStepRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkflowStep operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkflowStep for more information on using the GetWorkflowStep
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkflowStepRequest method.
//	req, resp := client.GetWorkflowStepRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetWorkflowStep
func (c *MigrationHubOrchestrator) GetWorkflowStepRequest(input *GetWorkflowStepInput) (req *request.Request, output *GetWorkflowStepOutput) {
	op := &request.Operation{
		Name:       opGetWorkflowStep,
		HTTPMethod: "GET",
		HTTPPath:   "/workflowstep/{id}",
	}

	if input == nil {
		input = &GetWorkflowStepInput{}
	}

	output = &GetWorkflowStepOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkflowStep API operation for AWS Migration Hub Orchestrator.
//
// Get a step in the migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation GetWorkflowStep for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetWorkflowStep
func (c *MigrationHubOrchestrator) GetWorkflowStep(input *GetWorkflowStepInput) (*GetWorkflowStepOutput, error) {
	req, out := c.GetWorkflowStepRequest(input)
	return out, req.Send()
}

// GetWorkflowStepWithContext is the same as GetWorkflowStep with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkflowStep for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) GetWorkflowStepWithContext(ctx aws.Context, input *GetWorkflowStepInput, opts ...request.Option) (*GetWorkflowStepOutput, error) {
	req, out := c.GetWorkflowStepRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkflowStepGroup = "GetWorkflowStepGroup"

// GetWorkflowStepGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkflowStepGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkflowStepGroup for more information on using the GetWorkflowStepGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkflowStepGroupRequest method.
//	req, resp := client.GetWorkflowStepGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetWorkflowStepGroup
func (c *MigrationHubOrchestrator) GetWorkflowStepGroupRequest(input *GetWorkflowStepGroupInput) (req *request.Request, output *GetWorkflowStepGroupOutput) {
	op := &request.Operation{
		Name:       opGetWorkflowStepGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/workflowstepgroup/{id}",
	}

	if input == nil {
		input = &GetWorkflowStepGroupInput{}
	}

	output = &GetWorkflowStepGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkflowStepGroup API operation for AWS Migration Hub Orchestrator.
//
// Get the step group of a migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation GetWorkflowStepGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/GetWorkflowStepGroup
func (c *MigrationHubOrchestrator) GetWorkflowStepGroup(input *GetWorkflowStepGroupInput) (*GetWorkflowStepGroupOutput, error) {
	req, out := c.GetWorkflowStepGroupRequest(input)
	return out, req.Send()
}

// GetWorkflowStepGroupWithContext is the same as GetWorkflowStepGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkflowStepGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) GetWorkflowStepGroupWithContext(ctx aws.Context, input *GetWorkflowStepGroupInput, opts ...request.Option) (*GetWorkflowStepGroupOutput, error) {
	req, out := c.GetWorkflowStepGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPlugins = "ListPlugins"

// ListPluginsRequest generates a "aws/request.Request" representing the
// client's request for the ListPlugins operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPlugins for more information on using the ListPlugins
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPluginsRequest method.
//	req, resp := client.ListPluginsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListPlugins
func (c *MigrationHubOrchestrator) ListPluginsRequest(input *ListPluginsInput) (req *request.Request, output *ListPluginsOutput) {
	op := &request.Operation{
		Name:       opListPlugins,
		HTTPMethod: "GET",
		HTTPPath:   "/plugins",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPluginsInput{}
	}

	output = &ListPluginsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPlugins API operation for AWS Migration Hub Orchestrator.
//
// List AWS Migration Hub Orchestrator plugins.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation ListPlugins for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListPlugins
func (c *MigrationHubOrchestrator) ListPlugins(input *ListPluginsInput) (*ListPluginsOutput, error) {
	req, out := c.ListPluginsRequest(input)
	return out, req.Send()
}

// ListPluginsWithContext is the same as ListPlugins with the addition of
// the ability to pass a context and additional request options.
//
// See ListPlugins for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListPluginsWithContext(ctx aws.Context, input *ListPluginsInput, opts ...request.Option) (*ListPluginsOutput, error) {
	req, out := c.ListPluginsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPluginsPages iterates over the pages of a ListPlugins operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPlugins method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPlugins operation.
//	pageNum := 0
//	err := client.ListPluginsPages(params,
//	    func(page *migrationhuborchestrator.ListPluginsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MigrationHubOrchestrator) ListPluginsPages(input *ListPluginsInput, fn func(*ListPluginsOutput, bool) bool) error {
	return c.ListPluginsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPluginsPagesWithContext same as ListPluginsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListPluginsPagesWithContext(ctx aws.Context, input *ListPluginsInput, fn func(*ListPluginsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPluginsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPluginsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPluginsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTagsForResource
func (c *MigrationHubOrchestrator) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Migration Hub Orchestrator.
//
// List the tags added to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTagsForResource
func (c *MigrationHubOrchestrator) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTemplateStepGroups = "ListTemplateStepGroups"

// ListTemplateStepGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplateStepGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplateStepGroups for more information on using the ListTemplateStepGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplateStepGroupsRequest method.
//	req, resp := client.ListTemplateStepGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplateStepGroups
func (c *MigrationHubOrchestrator) ListTemplateStepGroupsRequest(input *ListTemplateStepGroupsInput) (req *request.Request, output *ListTemplateStepGroupsOutput) {
	op := &request.Operation{
		Name:       opListTemplateStepGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/templatestepgroups/{templateId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplateStepGroupsInput{}
	}

	output = &ListTemplateStepGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplateStepGroups API operation for AWS Migration Hub Orchestrator.
//
// List the step groups in a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation ListTemplateStepGroups for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplateStepGroups
func (c *MigrationHubOrchestrator) ListTemplateStepGroups(input *ListTemplateStepGroupsInput) (*ListTemplateStepGroupsOutput, error) {
	req, out := c.ListTemplateStepGroupsRequest(input)
	return out, req.Send()
}

// ListTemplateStepGroupsWithContext is the same as ListTemplateStepGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplateStepGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListTemplateStepGroupsWithContext(ctx aws.Context, input *ListTemplateStepGroupsInput, opts ...request.Option) (*ListTemplateStepGroupsOutput, error) {
	req, out := c.ListTemplateStepGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplateStepGroupsPages iterates over the pages of a ListTemplateStepGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplateStepGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTemplateStepGroups operation.
//	pageNum := 0
//	err := client.ListTemplateStepGroupsPages(params,
//	    func(page *migrationhuborchestrator.ListTemplateStepGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MigrationHubOrchestrator) ListTemplateStepGroupsPages(input *ListTemplateStepGroupsInput, fn func(*ListTemplateStepGroupsOutput, bool) bool) error {
	return c.ListTemplateStepGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplateStepGroupsPagesWithContext same as ListTemplateStepGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListTemplateStepGroupsPagesWithContext(ctx aws.Context, input *ListTemplateStepGroupsInput, fn func(*ListTemplateStepGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplateStepGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplateStepGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplateStepGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTemplateSteps = "ListTemplateSteps"

// ListTemplateStepsRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplateSteps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplateSteps for more information on using the ListTemplateSteps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplateStepsRequest method.
//	req, resp := client.ListTemplateStepsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplateSteps
func (c *MigrationHubOrchestrator) ListTemplateStepsRequest(input *ListTemplateStepsInput) (req *request.Request, output *ListTemplateStepsOutput) {
	op := &request.Operation{
		Name:       opListTemplateSteps,
		HTTPMethod: "GET",
		HTTPPath:   "/templatesteps",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplateStepsInput{}
	}

	output = &ListTemplateStepsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplateSteps API operation for AWS Migration Hub Orchestrator.
//
// List the steps in a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation ListTemplateSteps for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplateSteps
func (c *MigrationHubOrchestrator) ListTemplateSteps(input *ListTemplateStepsInput) (*ListTemplateStepsOutput, error) {
	req, out := c.ListTemplateStepsRequest(input)
	return out, req.Send()
}

// ListTemplateStepsWithContext is the same as ListTemplateSteps with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplateSteps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListTemplateStepsWithContext(ctx aws.Context, input *ListTemplateStepsInput, opts ...request.Option) (*ListTemplateStepsOutput, error) {
	req, out := c.ListTemplateStepsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplateStepsPages iterates over the pages of a ListTemplateSteps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplateSteps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTemplateSteps operation.
//	pageNum := 0
//	err := client.ListTemplateStepsPages(params,
//	    func(page *migrationhuborchestrator.ListTemplateStepsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MigrationHubOrchestrator) ListTemplateStepsPages(input *ListTemplateStepsInput, fn func(*ListTemplateStepsOutput, bool) bool) error {
	return c.ListTemplateStepsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplateStepsPagesWithContext same as ListTemplateStepsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListTemplateStepsPagesWithContext(ctx aws.Context, input *ListTemplateStepsInput, fn func(*ListTemplateStepsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplateStepsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplateStepsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplateStepsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTemplates = "ListTemplates"

// ListTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplates for more information on using the ListTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplatesRequest method.
//	req, resp := client.ListTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplates
func (c *MigrationHubOrchestrator) ListTemplatesRequest(input *ListTemplatesInput) (req *request.Request, output *ListTemplatesOutput) {
	op := &request.Operation{
		Name:       opListTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/migrationworkflowtemplates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplatesInput{}
	}

	output = &ListTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplates API operation for AWS Migration Hub Orchestrator.
//
// List the templates available in Migration Hub Orchestrator to create a migration
// workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation ListTemplates for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListTemplates
func (c *MigrationHubOrchestrator) ListTemplates(input *ListTemplatesInput) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	return out, req.Send()
}

// ListTemplatesWithContext is the same as ListTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListTemplatesWithContext(ctx aws.Context, input *ListTemplatesInput, opts ...request.Option) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplatesPages iterates over the pages of a ListTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTemplates operation.
//	pageNum := 0
//	err := client.ListTemplatesPages(params,
//	    func(page *migrationhuborchestrator.ListTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MigrationHubOrchestrator) ListTemplatesPages(input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool) error {
	return c.ListTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplatesPagesWithContext same as ListTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListTemplatesPagesWithContext(ctx aws.Context, input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkflowStepGroups = "ListWorkflowStepGroups"

// ListWorkflowStepGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkflowStepGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkflowStepGroups for more information on using the ListWorkflowStepGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkflowStepGroupsRequest method.
//	req, resp := client.ListWorkflowStepGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflowStepGroups
func (c *MigrationHubOrchestrator) ListWorkflowStepGroupsRequest(input *ListWorkflowStepGroupsInput) (req *request.Request, output *ListWorkflowStepGroupsOutput) {
	op := &request.Operation{
		Name:       opListWorkflowStepGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/workflowstepgroups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkflowStepGroupsInput{}
	}

	output = &ListWorkflowStepGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkflowStepGroups API operation for AWS Migration Hub Orchestrator.
//
// List the step groups in a migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation ListWorkflowStepGroups for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflowStepGroups
func (c *MigrationHubOrchestrator) ListWorkflowStepGroups(input *ListWorkflowStepGroupsInput) (*ListWorkflowStepGroupsOutput, error) {
	req, out := c.ListWorkflowStepGroupsRequest(input)
	return out, req.Send()
}

// ListWorkflowStepGroupsWithContext is the same as ListWorkflowStepGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkflowStepGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListWorkflowStepGroupsWithContext(ctx aws.Context, input *ListWorkflowStepGroupsInput, opts ...request.Option) (*ListWorkflowStepGroupsOutput, error) {
	req, out := c.ListWorkflowStepGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkflowStepGroupsPages iterates over the pages of a ListWorkflowStepGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkflowStepGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkflowStepGroups operation.
//	pageNum := 0
//	err := client.ListWorkflowStepGroupsPages(params,
//	    func(page *migrationhuborchestrator.ListWorkflowStepGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MigrationHubOrchestrator) ListWorkflowStepGroupsPages(input *ListWorkflowStepGroupsInput, fn func(*ListWorkflowStepGroupsOutput, bool) bool) error {
	return c.ListWorkflowStepGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkflowStepGroupsPagesWithContext same as ListWorkflowStepGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListWorkflowStepGroupsPagesWithContext(ctx aws.Context, input *ListWorkflowStepGroupsInput, fn func(*ListWorkflowStepGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkflowStepGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkflowStepGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkflowStepGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkflowSteps = "ListWorkflowSteps"

// ListWorkflowStepsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkflowSteps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkflowSteps for more information on using the ListWorkflowSteps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkflowStepsRequest method.
//	req, resp := client.ListWorkflowStepsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflowSteps
func (c *MigrationHubOrchestrator) ListWorkflowStepsRequest(input *ListWorkflowStepsInput) (req *request.Request, output *ListWorkflowStepsOutput) {
	op := &request.Operation{
		Name:       opListWorkflowSteps,
		HTTPMethod: "GET",
		HTTPPath:   "/workflow/{workflowId}/workflowstepgroups/{stepGroupId}/workflowsteps",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkflowStepsInput{}
	}

	output = &ListWorkflowStepsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkflowSteps API operation for AWS Migration Hub Orchestrator.
//
// List the steps in a workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation ListWorkflowSteps for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflowSteps
func (c *MigrationHubOrchestrator) ListWorkflowSteps(input *ListWorkflowStepsInput) (*ListWorkflowStepsOutput, error) {
	req, out := c.ListWorkflowStepsRequest(input)
	return out, req.Send()
}

// ListWorkflowStepsWithContext is the same as ListWorkflowSteps with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkflowSteps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListWorkflowStepsWithContext(ctx aws.Context, input *ListWorkflowStepsInput, opts ...request.Option) (*ListWorkflowStepsOutput, error) {
	req, out := c.ListWorkflowStepsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkflowStepsPages iterates over the pages of a ListWorkflowSteps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkflowSteps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkflowSteps operation.
//	pageNum := 0
//	err := client.ListWorkflowStepsPages(params,
//	    func(page *migrationhuborchestrator.ListWorkflowStepsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MigrationHubOrchestrator) ListWorkflowStepsPages(input *ListWorkflowStepsInput, fn func(*ListWorkflowStepsOutput, bool) bool) error {
	return c.ListWorkflowStepsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkflowStepsPagesWithContext same as ListWorkflowStepsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListWorkflowStepsPagesWithContext(ctx aws.Context, input *ListWorkflowStepsInput, fn func(*ListWorkflowStepsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkflowStepsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkflowStepsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkflowStepsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkflows = "ListWorkflows"

// ListWorkflowsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkflows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkflows for more information on using the ListWorkflows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkflowsRequest method.
//	req, resp := client.ListWorkflowsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflows
func (c *MigrationHubOrchestrator) ListWorkflowsRequest(input *ListWorkflowsInput) (req *request.Request, output *ListWorkflowsOutput) {
	op := &request.Operation{
		Name:       opListWorkflows,
		HTTPMethod: "GET",
		HTTPPath:   "/migrationworkflows",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkflowsInput{}
	}

	output = &ListWorkflowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkflows API operation for AWS Migration Hub Orchestrator.
//
// List the migration workflows.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation ListWorkflows for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/ListWorkflows
func (c *MigrationHubOrchestrator) ListWorkflows(input *ListWorkflowsInput) (*ListWorkflowsOutput, error) {
	req, out := c.ListWorkflowsRequest(input)
	return out, req.Send()
}

// ListWorkflowsWithContext is the same as ListWorkflows with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkflows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListWorkflowsWithContext(ctx aws.Context, input *ListWorkflowsInput, opts ...request.Option) (*ListWorkflowsOutput, error) {
	req, out := c.ListWorkflowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkflowsPages iterates over the pages of a ListWorkflows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkflows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkflows operation.
//	pageNum := 0
//	err := client.ListWorkflowsPages(params,
//	    func(page *migrationhuborchestrator.ListWorkflowsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MigrationHubOrchestrator) ListWorkflowsPages(input *ListWorkflowsInput, fn func(*ListWorkflowsOutput, bool) bool) error {
	return c.ListWorkflowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkflowsPagesWithContext same as ListWorkflowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) ListWorkflowsPagesWithContext(ctx aws.Context, input *ListWorkflowsInput, fn func(*ListWorkflowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkflowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkflowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkflowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRetryWorkflowStep = "RetryWorkflowStep"

// RetryWorkflowStepRequest generates a "aws/request.Request" representing the
// client's request for the RetryWorkflowStep operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RetryWorkflowStep for more information on using the RetryWorkflowStep
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RetryWorkflowStepRequest method.
//	req, resp := client.RetryWorkflowStepRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/RetryWorkflowStep
func (c *MigrationHubOrchestrator) RetryWorkflowStepRequest(input *RetryWorkflowStepInput) (req *request.Request, output *RetryWorkflowStepOutput) {
	op := &request.Operation{
		Name:       opRetryWorkflowStep,
		HTTPMethod: "POST",
		HTTPPath:   "/retryworkflowstep/{id}",
	}

	if input == nil {
		input = &RetryWorkflowStepInput{}
	}

	output = &RetryWorkflowStepOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RetryWorkflowStep API operation for AWS Migration Hub Orchestrator.
//
// Retry a failed step in a migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation RetryWorkflowStep for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/RetryWorkflowStep
func (c *MigrationHubOrchestrator) RetryWorkflowStep(input *RetryWorkflowStepInput) (*RetryWorkflowStepOutput, error) {
	req, out := c.RetryWorkflowStepRequest(input)
	return out, req.Send()
}

// RetryWorkflowStepWithContext is the same as RetryWorkflowStep with the addition of
// the ability to pass a context and additional request options.
//
// See RetryWorkflowStep for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) RetryWorkflowStepWithContext(ctx aws.Context, input *RetryWorkflowStepInput, opts ...request.Option) (*RetryWorkflowStepOutput, error) {
	req, out := c.RetryWorkflowStepRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartWorkflow = "StartWorkflow"

// StartWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the StartWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartWorkflow for more information on using the StartWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartWorkflowRequest method.
//	req, resp := client.StartWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/StartWorkflow
func (c *MigrationHubOrchestrator) StartWorkflowRequest(input *StartWorkflowInput) (req *request.Request, output *StartWorkflowOutput) {
	op := &request.Operation{
		Name:       opStartWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/migrationworkflow/{id}/start",
	}

	if input == nil {
		input = &StartWorkflowInput{}
	}

	output = &StartWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartWorkflow API operation for AWS Migration Hub Orchestrator.
//
// Start a migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation StartWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/StartWorkflow
func (c *MigrationHubOrchestrator) StartWorkflow(input *StartWorkflowInput) (*StartWorkflowOutput, error) {
	req, out := c.StartWorkflowRequest(input)
	return out, req.Send()
}

// StartWorkflowWithContext is the same as StartWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See StartWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) StartWorkflowWithContext(ctx aws.Context, input *StartWorkflowInput, opts ...request.Option) (*StartWorkflowOutput, error) {
	req, out := c.StartWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopWorkflow = "StopWorkflow"

// StopWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the StopWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopWorkflow for more information on using the StopWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopWorkflowRequest method.
//	req, resp := client.StopWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/StopWorkflow
func (c *MigrationHubOrchestrator) StopWorkflowRequest(input *StopWorkflowInput) (req *request.Request, output *StopWorkflowOutput) {
	op := &request.Operation{
		Name:       opStopWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/migrationworkflow/{id}/stop",
	}

	if input == nil {
		input = &StopWorkflowInput{}
	}

	output = &StopWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopWorkflow API operation for AWS Migration Hub Orchestrator.
//
// Stop an ongoing migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation StopWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/StopWorkflow
func (c *MigrationHubOrchestrator) StopWorkflow(input *StopWorkflowInput) (*StopWorkflowOutput, error) {
	req, out := c.StopWorkflowRequest(input)
	return out, req.Send()
}

// StopWorkflowWithContext is the same as StopWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See StopWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) StopWorkflowWithContext(ctx aws.Context, input *StopWorkflowInput, opts ...request.Option) (*StopWorkflowOutput, error) {
	req, out := c.StopWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/TagResource
func (c *MigrationHubOrchestrator) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Migration Hub Orchestrator.
//
// Tag a resource by specifying its Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/TagResource
func (c *MigrationHubOrchestrator) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UntagResource
func (c *MigrationHubOrchestrator) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Migration Hub Orchestrator.
//
// Deletes the tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UntagResource
func (c *MigrationHubOrchestrator) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplate = "UpdateTemplate"

// UpdateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplate for more information on using the UpdateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTemplateRequest method.
//	req, resp := client.UpdateTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateTemplate
func (c *MigrationHubOrchestrator) UpdateTemplateRequest(input *UpdateTemplateInput) (req *request.Request, output *UpdateTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/template/{id}",
	}

	if input == nil {
		input = &UpdateTemplateInput{}
	}

	output = &UpdateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplate API operation for AWS Migration Hub Orchestrator.
//
// Updates a migration workflow template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation UpdateTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateTemplate
func (c *MigrationHubOrchestrator) UpdateTemplate(input *UpdateTemplateInput) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	return out, req.Send()
}

// UpdateTemplateWithContext is the same as UpdateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) UpdateTemplateWithContext(ctx aws.Context, input *UpdateTemplateInput, opts ...request.Option) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkflow = "UpdateWorkflow"

// UpdateWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkflow for more information on using the UpdateWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkflowRequest method.
//	req, resp := client.UpdateWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateWorkflow
func (c *MigrationHubOrchestrator) UpdateWorkflowRequest(input *UpdateWorkflowInput) (req *request.Request, output *UpdateWorkflowOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/migrationworkflow/{id}",
	}

	if input == nil {
		input = &UpdateWorkflowInput{}
	}

	output = &UpdateWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkflow API operation for AWS Migration Hub Orchestrator.
//
// Update a migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation UpdateWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateWorkflow
func (c *MigrationHubOrchestrator) UpdateWorkflow(input *UpdateWorkflowInput) (*UpdateWorkflowOutput, error) {
	req, out := c.UpdateWorkflowRequest(input)
	return out, req.Send()
}

// UpdateWorkflowWithContext is the same as UpdateWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) UpdateWorkflowWithContext(ctx aws.Context, input *UpdateWorkflowInput, opts ...request.Option) (*UpdateWorkflowOutput, error) {
	req, out := c.UpdateWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkflowStep = "UpdateWorkflowStep"

// UpdateWorkflowStepRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkflowStep operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkflowStep for more information on using the UpdateWorkflowStep
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkflowStepRequest method.
//	req, resp := client.UpdateWorkflowStepRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateWorkflowStep
func (c *MigrationHubOrchestrator) UpdateWorkflowStepRequest(input *UpdateWorkflowStepInput) (req *request.Request, output *UpdateWorkflowStepOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkflowStep,
		HTTPMethod: "POST",
		HTTPPath:   "/workflowstep/{id}",
	}

	if input == nil {
		input = &UpdateWorkflowStepInput{}
	}

	output = &UpdateWorkflowStepOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkflowStep API operation for AWS Migration Hub Orchestrator.
//
// Update a step in a migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation UpdateWorkflowStep for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateWorkflowStep
func (c *MigrationHubOrchestrator) UpdateWorkflowStep(input *UpdateWorkflowStepInput) (*UpdateWorkflowStepOutput, error) {
	req, out := c.UpdateWorkflowStepRequest(input)
	return out, req.Send()
}

// UpdateWorkflowStepWithContext is the same as UpdateWorkflowStep with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkflowStep for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) UpdateWorkflowStepWithContext(ctx aws.Context, input *UpdateWorkflowStepInput, opts ...request.Option) (*UpdateWorkflowStepOutput, error) {
	req, out := c.UpdateWorkflowStepRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkflowStepGroup = "UpdateWorkflowStepGroup"

// UpdateWorkflowStepGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkflowStepGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkflowStepGroup for more information on using the UpdateWorkflowStepGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkflowStepGroupRequest method.
//	req, resp := client.UpdateWorkflowStepGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateWorkflowStepGroup
func (c *MigrationHubOrchestrator) UpdateWorkflowStepGroupRequest(input *UpdateWorkflowStepGroupInput) (req *request.Request, output *UpdateWorkflowStepGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkflowStepGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/workflowstepgroup/{id}",
	}

	if input == nil {
		input = &UpdateWorkflowStepGroupInput{}
	}

	output = &UpdateWorkflowStepGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkflowStepGroup API operation for AWS Migration Hub Orchestrator.
//
// Update the step group in a migration workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Orchestrator's
// API operation UpdateWorkflowStepGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal error has occurred.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/UpdateWorkflowStepGroup
func (c *MigrationHubOrchestrator) UpdateWorkflowStepGroup(input *UpdateWorkflowStepGroupInput) (*UpdateWorkflowStepGroupOutput, error) {
	req, out := c.UpdateWorkflowStepGroupRequest(input)
	return out, req.Send()
}

// UpdateWorkflowStepGroupWithContext is the same as UpdateWorkflowStepGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkflowStepGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubOrchestrator) UpdateWorkflowStepGroupWithContext(ctx aws.Context, input *UpdateWorkflowStepGroupInput, opts ...request.Option) (*UpdateWorkflowStepGroupOutput, error) {
	req, out := c.UpdateWorkflowStepGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when an attempt to update or delete a resource would
// cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateTemplateInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see Idempotency (https://smithy.io/2.0/spec/behavior-traits.html#idempotencytoken-trait)
	// in the Smithy documentation.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The tags to add to the migration workflow template.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A description of the migration workflow template.
	TemplateDescription *string `locationName:"templateDescription" type:"string"`

	// The name of the migration workflow template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`

	// The source of the migration workflow template.
	//
	// TemplateSource is a required field
	TemplateSource *TemplateSource `locationName:"templateSource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTemplateInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.TemplateSource == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateSource"))
	}
	if s.TemplateSource != nil {
		if err := s.TemplateSource.Validate(); err != nil {
			invalidParams.AddNested("TemplateSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTemplateInput) SetClientToken(v string) *CreateTemplateInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTemplateInput) SetTags(v map[string]*string) *CreateTemplateInput {
	s.Tags = v
	return s
}

// SetTemplateDescription sets the TemplateDescription field's value.
func (s *CreateTemplateInput) SetTemplateDescription(v string) *CreateTemplateInput {
	s.TemplateDescription = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateTemplateInput) SetTemplateName(v string) *CreateTemplateInput {
	s.TemplateName = &v
	return s
}

// SetTemplateSource sets the TemplateSource field's value.
func (s *CreateTemplateInput) SetTemplateSource(v *TemplateSource) *CreateTemplateInput {
	s.TemplateSource = v
	return s
}

type CreateTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The tags added to the migration workflow template.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The Amazon Resource Name (ARN) of the migration workflow template. The format
	// for an Migration Hub Orchestrator template ARN is arn:aws:migrationhub-orchestrator:region:account:template/template-abcd1234.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
	// in the AWS General Reference.
	TemplateArn *string `locationName:"templateArn" type:"string"`

	// The ID of the migration workflow template.
	TemplateId *string `locationName:"templateId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *CreateTemplateOutput) SetTags(v map[string]*string) *CreateTemplateOutput {
	s.Tags = v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *CreateTemplateOutput) SetTemplateArn(v string) *CreateTemplateOutput {
	s.TemplateArn = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateTemplateOutput) SetTemplateId(v string) *CreateTemplateOutput {
	s.TemplateId = &v
	return s
}

type CreateWorkflowInput struct {
	_ struct{} `type:"structure"`

	// The configuration ID of the application configured in Application Discovery
	// Service.
	ApplicationConfigurationId *string `locationName:"applicationConfigurationId" type:"string"`

	// The description of the migration workflow.
	Description *string `locationName:"description" type:"string"`

	// The input parameters required to create a migration workflow.
	//
	// InputParameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateWorkflowInput's
	// String and GoString methods.
	//
	// InputParameters is a required field
	InputParameters map[string]*StepInput_ `locationName:"inputParameters" type:"map" required:"true" sensitive:"true"`

	// The name of the migration workflow.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The servers on which a step will be run.
	StepTargets []*string `locationName:"stepTargets" type:"list"`

	// The tags to add on a migration workflow.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the template.
	//
	// TemplateId is a required field
	TemplateId *string `locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkflowInput"}
	if s.InputParameters == nil {
		invalidParams.Add(request.NewErrParamRequired("InputParameters"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationConfigurationId sets the ApplicationConfigurationId field's value.
func (s *CreateWorkflowInput) SetApplicationConfigurationId(v string) *CreateWorkflowInput {
	s.ApplicationConfigurationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWorkflowInput) SetDescription(v string) *CreateWorkflowInput {
	s.Description = &v
	return s
}

// SetInputParameters sets the InputParameters field's value.
func (s *CreateWorkflowInput) SetInputParameters(v map[string]*StepInput_) *CreateWorkflowInput {
	s.InputParameters = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkflowInput) SetName(v string) *CreateWorkflowInput {
	s.Name = &v
	return s
}

// SetStepTargets sets the StepTargets field's value.
func (s *CreateWorkflowInput) SetStepTargets(v []*string) *CreateWorkflowInput {
	s.StepTargets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkflowInput) SetTags(v map[string]*string) *CreateWorkflowInput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateWorkflowInput) SetTemplateId(v string) *CreateWorkflowInput {
	s.TemplateId = &v
	return s
}

type CreateWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The configuration ID of the application configured in Application Discovery
	// Service.
	AdsApplicationConfigurationId *string `locationName:"adsApplicationConfigurationId" type:"string"`

	// The Amazon Resource Name (ARN) of the migration workflow.
	Arn *string `locationName:"arn" type:"string"`

	// The time at which the migration workflow was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description of the migration workflow.
	Description *string `locationName:"description" type:"string"`

	// The ID of the migration workflow.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The name of the migration workflow.
	Name *string `locationName:"name" type:"string"`

	// The status of the migration workflow.
	Status *string `locationName:"status" type:"string" enum:"MigrationWorkflowStatusEnum"`

	// The servers on which a step will be run.
	StepTargets []*string `locationName:"stepTargets" type:"list"`

	// The tags to add on a migration workflow.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the template.
	TemplateId *string `locationName:"templateId" type:"string"`

	// The inputs for creating a migration workflow.
	//
	// WorkflowInputs is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateWorkflowOutput's
	// String and GoString methods.
	WorkflowInputs map[string]*StepInput_ `locationName:"workflowInputs" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowOutput) GoString() string {
	return s.String()
}

// SetAdsApplicationConfigurationId sets the AdsApplicationConfigurationId field's value.
func (s *CreateWorkflowOutput) SetAdsApplicationConfigurationId(v string) *CreateWorkflowOutput {
	s.AdsApplicationConfigurationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateWorkflowOutput) SetArn(v string) *CreateWorkflowOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateWorkflowOutput) SetCreationTime(v time.Time) *CreateWorkflowOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWorkflowOutput) SetDescription(v string) *CreateWorkflowOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateWorkflowOutput) SetId(v string) *CreateWorkflowOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkflowOutput) SetName(v string) *CreateWorkflowOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateWorkflowOutput) SetStatus(v string) *CreateWorkflowOutput {
	s.Status = &v
	return s
}

// SetStepTargets sets the StepTargets field's value.
func (s *CreateWorkflowOutput) SetStepTargets(v []*string) *CreateWorkflowOutput {
	s.StepTargets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkflowOutput) SetTags(v map[string]*string) *CreateWorkflowOutput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateWorkflowOutput) SetTemplateId(v string) *CreateWorkflowOutput {
	s.TemplateId = &v
	return s
}

// SetWorkflowInputs sets the WorkflowInputs field's value.
func (s *CreateWorkflowOutput) SetWorkflowInputs(v map[string]*StepInput_) *CreateWorkflowOutput {
	s.WorkflowInputs = v
	return s
}

type CreateWorkflowStepGroupInput struct {
	_ struct{} `type:"structure"`

	// The description of the step group.
	Description *string `locationName:"description" type:"string"`

	// The name of the step group.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next step group.
	Next []*string `locationName:"next" type:"list"`

	// The previous step group.
	Previous []*string `locationName:"previous" type:"list"`

	// The ID of the migration workflow that will contain the step group.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowStepGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowStepGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkflowStepGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkflowStepGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateWorkflowStepGroupInput) SetDescription(v string) *CreateWorkflowStepGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkflowStepGroupInput) SetName(v string) *CreateWorkflowStepGroupInput {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *CreateWorkflowStepGroupInput) SetNext(v []*string) *CreateWorkflowStepGroupInput {
	s.Next = v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *CreateWorkflowStepGroupInput) SetPrevious(v []*string) *CreateWorkflowStepGroupInput {
	s.Previous = v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *CreateWorkflowStepGroupInput) SetWorkflowId(v string) *CreateWorkflowStepGroupInput {
	s.WorkflowId = &v
	return s
}

type CreateWorkflowStepGroupOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the step group is created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description of the step group.
	Description *string `locationName:"description" type:"string"`

	// The ID of the step group.
	Id *string `locationName:"id" type:"string"`

	// The name of the step group.
	Name *string `locationName:"name" type:"string"`

	// The next step group.
	Next []*string `locationName:"next" type:"list"`

	// The previous step group.
	Previous []*string `locationName:"previous" type:"list"`

	// List of AWS services utilized in a migration workflow.
	Tools []*Tool `locationName:"tools" type:"list"`

	// The ID of the migration workflow that contains the step group.
	WorkflowId *string `locationName:"workflowId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowStepGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowStepGroupOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateWorkflowStepGroupOutput) SetCreationTime(v time.Time) *CreateWorkflowStepGroupOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWorkflowStepGroupOutput) SetDescription(v string) *CreateWorkflowStepGroupOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateWorkflowStepGroupOutput) SetId(v string) *CreateWorkflowStepGroupOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkflowStepGroupOutput) SetName(v string) *CreateWorkflowStepGroupOutput {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *CreateWorkflowStepGroupOutput) SetNext(v []*string) *CreateWorkflowStepGroupOutput {
	s.Next = v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *CreateWorkflowStepGroupOutput) SetPrevious(v []*string) *CreateWorkflowStepGroupOutput {
	s.Previous = v
	return s
}

// SetTools sets the Tools field's value.
func (s *CreateWorkflowStepGroupOutput) SetTools(v []*Tool) *CreateWorkflowStepGroupOutput {
	s.Tools = v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *CreateWorkflowStepGroupOutput) SetWorkflowId(v string) *CreateWorkflowStepGroupOutput {
	s.WorkflowId = &v
	return s
}

type CreateWorkflowStepInput struct {
	_ struct{} `type:"structure"`

	// The description of the step.
	Description *string `locationName:"description" type:"string"`

	// The name of the step.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next step.
	Next []*string `locationName:"next" type:"list"`

	// The key value pairs added for the expected output.
	Outputs []*WorkflowStepOutput_ `locationName:"outputs" type:"list"`

	// The previous step.
	Previous []*string `locationName:"previous" type:"list"`

	// The action type of the step. You must run and update the status of a manual
	// step for the workflow to continue after the completion of the step.
	//
	// StepActionType is a required field
	StepActionType *string `locationName:"stepActionType" type:"string" required:"true" enum:"StepActionType"`

	// The ID of the step group.
	//
	// StepGroupId is a required field
	StepGroupId *string `locationName:"stepGroupId" min:"1" type:"string" required:"true"`

	// The servers on which a step will be run.
	StepTarget []*string `locationName:"stepTarget" type:"list"`

	// The ID of the migration workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`

	// The custom script to run tests on source or target environments.
	WorkflowStepAutomationConfiguration *WorkflowStepAutomationConfiguration `locationName:"workflowStepAutomationConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowStepInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowStepInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkflowStepInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkflowStepInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.StepActionType == nil {
		invalidParams.Add(request.NewErrParamRequired("StepActionType"))
	}
	if s.StepGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepGroupId"))
	}
	if s.StepGroupId != nil && len(*s.StepGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepGroupId", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateWorkflowStepInput) SetDescription(v string) *CreateWorkflowStepInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkflowStepInput) SetName(v string) *CreateWorkflowStepInput {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *CreateWorkflowStepInput) SetNext(v []*string) *CreateWorkflowStepInput {
	s.Next = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *CreateWorkflowStepInput) SetOutputs(v []*WorkflowStepOutput_) *CreateWorkflowStepInput {
	s.Outputs = v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *CreateWorkflowStepInput) SetPrevious(v []*string) *CreateWorkflowStepInput {
	s.Previous = v
	return s
}

// SetStepActionType sets the StepActionType field's value.
func (s *CreateWorkflowStepInput) SetStepActionType(v string) *CreateWorkflowStepInput {
	s.StepActionType = &v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *CreateWorkflowStepInput) SetStepGroupId(v string) *CreateWorkflowStepInput {
	s.StepGroupId = &v
	return s
}

// SetStepTarget sets the StepTarget field's value.
func (s *CreateWorkflowStepInput) SetStepTarget(v []*string) *CreateWorkflowStepInput {
	s.StepTarget = v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *CreateWorkflowStepInput) SetWorkflowId(v string) *CreateWorkflowStepInput {
	s.WorkflowId = &v
	return s
}

// SetWorkflowStepAutomationConfiguration sets the WorkflowStepAutomationConfiguration field's value.
func (s *CreateWorkflowStepInput) SetWorkflowStepAutomationConfiguration(v *WorkflowStepAutomationConfiguration) *CreateWorkflowStepInput {
	s.WorkflowStepAutomationConfiguration = v
	return s
}

type CreateWorkflowStepOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the step.
	Id *string `locationName:"id" type:"string"`

	// The name of the step.
	Name *string `locationName:"name" type:"string"`

	// The ID of the step group.
	StepGroupId *string `locationName:"stepGroupId" type:"string"`

	// The ID of the migration workflow.
	WorkflowId *string `locationName:"workflowId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowStepOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkflowStepOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateWorkflowStepOutput) SetId(v string) *CreateWorkflowStepOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkflowStepOutput) SetName(v string) *CreateWorkflowStepOutput {
	s.Name = &v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *CreateWorkflowStepOutput) SetStepGroupId(v string) *CreateWorkflowStepOutput {
	s.StepGroupId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *CreateWorkflowStepOutput) SetWorkflowId(v string) *CreateWorkflowStepOutput {
	s.WorkflowId = &v
	return s
}

type DeleteTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the request to delete a migration workflow template.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteTemplateInput) SetId(v string) *DeleteTemplateInput {
	s.Id = &v
	return s
}

type DeleteTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateOutput) GoString() string {
	return s.String()
}

type DeleteWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the migration workflow you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkflowInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteWorkflowInput) SetId(v string) *DeleteWorkflowInput {
	s.Id = &v
	return s
}

type DeleteWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the migration workflow.
	Arn *string `locationName:"arn" type:"string"`

	// The ID of the migration workflow.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The status of the migration workflow.
	Status *string `locationName:"status" type:"string" enum:"MigrationWorkflowStatusEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteWorkflowOutput) SetArn(v string) *DeleteWorkflowOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteWorkflowOutput) SetId(v string) *DeleteWorkflowOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteWorkflowOutput) SetStatus(v string) *DeleteWorkflowOutput {
	s.Status = &v
	return s
}

type DeleteWorkflowStepGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the step group you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The ID of the migration workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `location:"querystring" locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowStepGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowStepGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkflowStepGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkflowStepGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteWorkflowStepGroupInput) SetId(v string) *DeleteWorkflowStepGroupInput {
	s.Id = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *DeleteWorkflowStepGroupInput) SetWorkflowId(v string) *DeleteWorkflowStepGroupInput {
	s.WorkflowId = &v
	return s
}

type DeleteWorkflowStepGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowStepGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowStepGroupOutput) GoString() string {
	return s.String()
}

type DeleteWorkflowStepInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the step you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The ID of the step group that contains the step you want to delete.
	//
	// StepGroupId is a required field
	StepGroupId *string `location:"querystring" locationName:"stepGroupId" min:"1" type:"string" required:"true"`

	// The ID of the migration workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `location:"querystring" locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowStepInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowStepInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkflowStepInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkflowStepInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.StepGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepGroupId"))
	}
	if s.StepGroupId != nil && len(*s.StepGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepGroupId", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteWorkflowStepInput) SetId(v string) *DeleteWorkflowStepInput {
	s.Id = &v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *DeleteWorkflowStepInput) SetStepGroupId(v string) *DeleteWorkflowStepInput {
	s.StepGroupId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *DeleteWorkflowStepInput) SetWorkflowId(v string) *DeleteWorkflowStepInput {
	s.WorkflowId = &v
	return s
}

type DeleteWorkflowStepOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowStepOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkflowStepOutput) GoString() string {
	return s.String()
}

type GetTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the template.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetTemplateInput) SetId(v string) *GetTemplateInput {
	s.Id = &v
	return s
}

type GetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the template was last created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The time at which the template was last created.
	Description *string `locationName:"description" type:"string"`

	// The ID of the template.
	Id *string `locationName:"id" type:"string"`

	// The inputs provided for the creation of the migration workflow.
	Inputs []*TemplateInput_ `locationName:"inputs" type:"list"`

	// The name of the template.
	Name *string `locationName:"name" type:"string"`

	// The owner of the migration workflow template.
	Owner *string `locationName:"owner" type:"string"`

	// The status of the template.
	Status *string `locationName:"status" type:"string" enum:"TemplateStatus"`

	// The status message of retrieving migration workflow templates.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The tags added to the migration workflow template.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// >The Amazon Resource Name (ARN) of the migration workflow template. The format
	// for an Migration Hub Orchestrator template ARN is arn:aws:migrationhub-orchestrator:region:account:template/template-abcd1234.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
	// in the AWS General Reference.
	TemplateArn *string `locationName:"templateArn" type:"string"`

	// The class of the migration workflow template. The available template classes
	// are:
	//
	//    * A2C
	//
	//    * MGN
	//
	//    * SAP_MULTI
	//
	//    * SQL_EC2
	//
	//    * SQL_RDS
	//
	//    * VMIE
	TemplateClass *string `locationName:"templateClass" type:"string"`

	// List of AWS services utilized in a migration workflow.
	Tools []*Tool `locationName:"tools" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetTemplateOutput) SetCreationTime(v time.Time) *GetTemplateOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetTemplateOutput) SetDescription(v string) *GetTemplateOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetTemplateOutput) SetId(v string) *GetTemplateOutput {
	s.Id = &v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *GetTemplateOutput) SetInputs(v []*TemplateInput_) *GetTemplateOutput {
	s.Inputs = v
	return s
}

// SetName sets the Name field's value.
func (s *GetTemplateOutput) SetName(v string) *GetTemplateOutput {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *GetTemplateOutput) SetOwner(v string) *GetTemplateOutput {
	s.Owner = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetTemplateOutput) SetStatus(v string) *GetTemplateOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetTemplateOutput) SetStatusMessage(v string) *GetTemplateOutput {
	s.StatusMessage = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetTemplateOutput) SetTags(v map[string]*string) *GetTemplateOutput {
	s.Tags = v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *GetTemplateOutput) SetTemplateArn(v string) *GetTemplateOutput {
	s.TemplateArn = &v
	return s
}

// SetTemplateClass sets the TemplateClass field's value.
func (s *GetTemplateOutput) SetTemplateClass(v string) *GetTemplateOutput {
	s.TemplateClass = &v
	return s
}

// SetTools sets the Tools field's value.
func (s *GetTemplateOutput) SetTools(v []*Tool) *GetTemplateOutput {
	s.Tools = v
	return s
}

type GetTemplateStepGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the step group.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The ID of the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateStepGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateStepGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateStepGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateStepGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetTemplateStepGroupInput) SetId(v string) *GetTemplateStepGroupInput {
	s.Id = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetTemplateStepGroupInput) SetTemplateId(v string) *GetTemplateStepGroupInput {
	s.TemplateId = &v
	return s
}

type GetTemplateStepGroupOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the step group was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description of the step group.
	Description *string `locationName:"description" type:"string"`

	// The ID of the step group.
	Id *string `locationName:"id" type:"string"`

	// The time at which the step group was last modified.
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp"`

	// The name of the step group.
	Name *string `locationName:"name" type:"string"`

	// The next step group.
	Next []*string `locationName:"next" type:"list"`

	// The previous step group.
	Previous []*string `locationName:"previous" type:"list"`

	// The status of the step group.
	Status *string `locationName:"status" type:"string" enum:"StepGroupStatus"`

	// The ID of the template.
	TemplateId *string `locationName:"templateId" type:"string"`

	// List of AWS services utilized in a migration workflow.
	Tools []*Tool `locationName:"tools" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateStepGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateStepGroupOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetTemplateStepGroupOutput) SetCreationTime(v time.Time) *GetTemplateStepGroupOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetTemplateStepGroupOutput) SetDescription(v string) *GetTemplateStepGroupOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetTemplateStepGroupOutput) SetId(v string) *GetTemplateStepGroupOutput {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetTemplateStepGroupOutput) SetLastModifiedTime(v time.Time) *GetTemplateStepGroupOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetTemplateStepGroupOutput) SetName(v string) *GetTemplateStepGroupOutput {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *GetTemplateStepGroupOutput) SetNext(v []*string) *GetTemplateStepGroupOutput {
	s.Next = v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *GetTemplateStepGroupOutput) SetPrevious(v []*string) *GetTemplateStepGroupOutput {
	s.Previous = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetTemplateStepGroupOutput) SetStatus(v string) *GetTemplateStepGroupOutput {
	s.Status = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetTemplateStepGroupOutput) SetTemplateId(v string) *GetTemplateStepGroupOutput {
	s.TemplateId = &v
	return s
}

// SetTools sets the Tools field's value.
func (s *GetTemplateStepGroupOutput) SetTools(v []*Tool) *GetTemplateStepGroupOutput {
	s.Tools = v
	return s
}

type GetTemplateStepInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the step.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The ID of the step group.
	//
	// StepGroupId is a required field
	StepGroupId *string `location:"querystring" locationName:"stepGroupId" min:"1" type:"string" required:"true"`

	// The ID of the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"querystring" locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateStepInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateStepInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateStepInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateStepInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.StepGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepGroupId"))
	}
	if s.StepGroupId != nil && len(*s.StepGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepGroupId", 1))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetTemplateStepInput) SetId(v string) *GetTemplateStepInput {
	s.Id = &v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *GetTemplateStepInput) SetStepGroupId(v string) *GetTemplateStepInput {
	s.StepGroupId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetTemplateStepInput) SetTemplateId(v string) *GetTemplateStepInput {
	s.TemplateId = &v
	return s
}

type GetTemplateStepOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the step was created.
	CreationTime *string `locationName:"creationTime" type:"string"`

	// The description of the step.
	Description *string `locationName:"description" type:"string"`

	// The ID of the step.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The name of the step.
	Name *string `locationName:"name" type:"string"`

	// The next step.
	Next []*string `locationName:"next" type:"list"`

	// The outputs of the step.
	Outputs []*StepOutput_ `locationName:"outputs" type:"list"`

	// The previous step.
	Previous []*string `locationName:"previous" type:"list"`

	// The action type of the step. You must run and update the status of a manual
	// step for the workflow to continue after the completion of the step.
	StepActionType *string `locationName:"stepActionType" type:"string" enum:"StepActionType"`

	// The custom script to run tests on source or target environments.
	StepAutomationConfiguration *StepAutomationConfiguration `locationName:"stepAutomationConfiguration" type:"structure"`

	// The ID of the step group.
	StepGroupId *string `locationName:"stepGroupId" min:"1" type:"string"`

	// The ID of the template.
	TemplateId *string `locationName:"templateId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateStepOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateStepOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetTemplateStepOutput) SetCreationTime(v string) *GetTemplateStepOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetTemplateStepOutput) SetDescription(v string) *GetTemplateStepOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetTemplateStepOutput) SetId(v string) *GetTemplateStepOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetTemplateStepOutput) SetName(v string) *GetTemplateStepOutput {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *GetTemplateStepOutput) SetNext(v []*string) *GetTemplateStepOutput {
	s.Next = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *GetTemplateStepOutput) SetOutputs(v []*StepOutput_) *GetTemplateStepOutput {
	s.Outputs = v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *GetTemplateStepOutput) SetPrevious(v []*string) *GetTemplateStepOutput {
	s.Previous = v
	return s
}

// SetStepActionType sets the StepActionType field's value.
func (s *GetTemplateStepOutput) SetStepActionType(v string) *GetTemplateStepOutput {
	s.StepActionType = &v
	return s
}

// SetStepAutomationConfiguration sets the StepAutomationConfiguration field's value.
func (s *GetTemplateStepOutput) SetStepAutomationConfiguration(v *StepAutomationConfiguration) *GetTemplateStepOutput {
	s.StepAutomationConfiguration = v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *GetTemplateStepOutput) SetStepGroupId(v string) *GetTemplateStepOutput {
	s.StepGroupId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetTemplateStepOutput) SetTemplateId(v string) *GetTemplateStepOutput {
	s.TemplateId = &v
	return s
}

type GetWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the migration workflow.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkflowInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetWorkflowInput) SetId(v string) *GetWorkflowInput {
	s.Id = &v
	return s
}

type GetWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The configuration ID of the application configured in Application Discovery
	// Service.
	AdsApplicationConfigurationId *string `locationName:"adsApplicationConfigurationId" type:"string"`

	// The name of the application configured in Application Discovery Service.
	AdsApplicationName *string `locationName:"adsApplicationName" type:"string"`

	// The Amazon Resource Name (ARN) of the migration workflow.
	Arn *string `locationName:"arn" type:"string"`

	// Get a list of completed steps in the migration workflow.
	CompletedSteps *int64 `locationName:"completedSteps" type:"integer"`

	// The time at which the migration workflow was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description of the migration workflow.
	Description *string `locationName:"description" type:"string"`

	// The time at which the migration workflow ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The ID of the migration workflow.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The time at which the migration workflow was last modified.
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp"`

	// The time at which the migration workflow was last started.
	LastStartTime *time.Time `locationName:"lastStartTime" type:"timestamp"`

	// The time at which the migration workflow was last stopped.
	LastStopTime *time.Time `locationName:"lastStopTime" type:"timestamp"`

	// The name of the migration workflow.
	Name *string `locationName:"name" type:"string"`

	// The status of the migration workflow.
	Status *string `locationName:"status" type:"string" enum:"MigrationWorkflowStatusEnum"`

	// The status message of the migration workflow.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The tags added to the migration workflow.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the template.
	TemplateId *string `locationName:"templateId" type:"string"`

	// List of AWS services utilized in a migration workflow.
	Tools []*Tool `locationName:"tools" type:"list"`

	// The total number of steps in the migration workflow.
	TotalSteps *int64 `locationName:"totalSteps" type:"integer"`

	// The Amazon S3 bucket where the migration logs are stored.
	WorkflowBucket *string `locationName:"workflowBucket" type:"string"`

	// The inputs required for creating the migration workflow.
	//
	// WorkflowInputs is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetWorkflowOutput's
	// String and GoString methods.
	WorkflowInputs map[string]*StepInput_ `locationName:"workflowInputs" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowOutput) GoString() string {
	return s.String()
}

// SetAdsApplicationConfigurationId sets the AdsApplicationConfigurationId field's value.
func (s *GetWorkflowOutput) SetAdsApplicationConfigurationId(v string) *GetWorkflowOutput {
	s.AdsApplicationConfigurationId = &v
	return s
}

// SetAdsApplicationName sets the AdsApplicationName field's value.
func (s *GetWorkflowOutput) SetAdsApplicationName(v string) *GetWorkflowOutput {
	s.AdsApplicationName = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetWorkflowOutput) SetArn(v string) *GetWorkflowOutput {
	s.Arn = &v
	return s
}

// SetCompletedSteps sets the CompletedSteps field's value.
func (s *GetWorkflowOutput) SetCompletedSteps(v int64) *GetWorkflowOutput {
	s.CompletedSteps = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetWorkflowOutput) SetCreationTime(v time.Time) *GetWorkflowOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetWorkflowOutput) SetDescription(v string) *GetWorkflowOutput {
	s.Description = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetWorkflowOutput) SetEndTime(v time.Time) *GetWorkflowOutput {
	s.EndTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetWorkflowOutput) SetId(v string) *GetWorkflowOutput {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetWorkflowOutput) SetLastModifiedTime(v time.Time) *GetWorkflowOutput {
	s.LastModifiedTime = &v
	return s
}

// SetLastStartTime sets the LastStartTime field's value.
func (s *GetWorkflowOutput) SetLastStartTime(v time.Time) *GetWorkflowOutput {
	s.LastStartTime = &v
	return s
}

// SetLastStopTime sets the LastStopTime field's value.
func (s *GetWorkflowOutput) SetLastStopTime(v time.Time) *GetWorkflowOutput {
	s.LastStopTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetWorkflowOutput) SetName(v string) *GetWorkflowOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetWorkflowOutput) SetStatus(v string) *GetWorkflowOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetWorkflowOutput) SetStatusMessage(v string) *GetWorkflowOutput {
	s.StatusMessage = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetWorkflowOutput) SetTags(v map[string]*string) *GetWorkflowOutput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetWorkflowOutput) SetTemplateId(v string) *GetWorkflowOutput {
	s.TemplateId = &v
	return s
}

// SetTools sets the Tools field's value.
func (s *GetWorkflowOutput) SetTools(v []*Tool) *GetWorkflowOutput {
	s.Tools = v
	return s
}

// SetTotalSteps sets the TotalSteps field's value.
func (s *GetWorkflowOutput) SetTotalSteps(v int64) *GetWorkflowOutput {
	s.TotalSteps = &v
	return s
}

// SetWorkflowBucket sets the WorkflowBucket field's value.
func (s *GetWorkflowOutput) SetWorkflowBucket(v string) *GetWorkflowOutput {
	s.WorkflowBucket = &v
	return s
}

// SetWorkflowInputs sets the WorkflowInputs field's value.
func (s *GetWorkflowOutput) SetWorkflowInputs(v map[string]*StepInput_) *GetWorkflowOutput {
	s.WorkflowInputs = v
	return s
}

type GetWorkflowStepGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the step group.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The ID of the migration workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `location:"querystring" locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowStepGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowStepGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkflowStepGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkflowStepGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetWorkflowStepGroupInput) SetId(v string) *GetWorkflowStepGroupInput {
	s.Id = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *GetWorkflowStepGroupInput) SetWorkflowId(v string) *GetWorkflowStepGroupInput {
	s.WorkflowId = &v
	return s
}

type GetWorkflowStepGroupOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the step group was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description of the step group.
	Description *string `locationName:"description" type:"string"`

	// The time at which the step group ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The ID of the step group.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The time at which the step group was last modified.
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp"`

	// The name of the step group.
	Name *string `locationName:"name" type:"string"`

	// The next step group.
	Next []*string `locationName:"next" type:"list"`

	// The owner of the step group.
	Owner *string `locationName:"owner" type:"string" enum:"Owner"`

	// The previous step group.
	Previous []*string `locationName:"previous" type:"list"`

	// The status of the step group.
	Status *string `locationName:"status" type:"string" enum:"StepGroupStatus"`

	// List of AWS services utilized in a migration workflow.
	Tools []*Tool `locationName:"tools" type:"list"`

	// The ID of the migration workflow.
	WorkflowId *string `locationName:"workflowId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowStepGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowStepGroupOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetWorkflowStepGroupOutput) SetCreationTime(v time.Time) *GetWorkflowStepGroupOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetWorkflowStepGroupOutput) SetDescription(v string) *GetWorkflowStepGroupOutput {
	s.Description = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetWorkflowStepGroupOutput) SetEndTime(v time.Time) *GetWorkflowStepGroupOutput {
	s.EndTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetWorkflowStepGroupOutput) SetId(v string) *GetWorkflowStepGroupOutput {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetWorkflowStepGroupOutput) SetLastModifiedTime(v time.Time) *GetWorkflowStepGroupOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetWorkflowStepGroupOutput) SetName(v string) *GetWorkflowStepGroupOutput {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *GetWorkflowStepGroupOutput) SetNext(v []*string) *GetWorkflowStepGroupOutput {
	s.Next = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *GetWorkflowStepGroupOutput) SetOwner(v string) *GetWorkflowStepGroupOutput {
	s.Owner = &v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *GetWorkflowStepGroupOutput) SetPrevious(v []*string) *GetWorkflowStepGroupOutput {
	s.Previous = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetWorkflowStepGroupOutput) SetStatus(v string) *GetWorkflowStepGroupOutput {
	s.Status = &v
	return s
}

// SetTools sets the Tools field's value.
func (s *GetWorkflowStepGroupOutput) SetTools(v []*Tool) *GetWorkflowStepGroupOutput {
	s.Tools = v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *GetWorkflowStepGroupOutput) SetWorkflowId(v string) *GetWorkflowStepGroupOutput {
	s.WorkflowId = &v
	return s
}

type GetWorkflowStepInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the step.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The ID of the step group.
	//
	// StepGroupId is a required field
	StepGroupId *string `location:"querystring" locationName:"stepGroupId" min:"1" type:"string" required:"true"`

	// The ID of the migration workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `location:"querystring" locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowStepInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowStepInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkflowStepInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkflowStepInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.StepGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepGroupId"))
	}
	if s.StepGroupId != nil && len(*s.StepGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepGroupId", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetWorkflowStepInput) SetId(v string) *GetWorkflowStepInput {
	s.Id = &v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *GetWorkflowStepInput) SetStepGroupId(v string) *GetWorkflowStepInput {
	s.StepGroupId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *GetWorkflowStepInput) SetWorkflowId(v string) *GetWorkflowStepInput {
	s.WorkflowId = &v
	return s
}

type GetWorkflowStepOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the step was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description of the step.
	Description *string `locationName:"description" type:"string"`

	// The time at which the step ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The time at which the workflow was last started.
	LastStartTime *time.Time `locationName:"lastStartTime" type:"timestamp"`

	// The name of the step.
	Name *string `locationName:"name" type:"string"`

	// The next step.
	Next []*string `locationName:"next" type:"list"`

	// The number of servers that have been migrated.
	NoOfSrvCompleted *int64 `locationName:"noOfSrvCompleted" type:"integer"`

	// The number of servers that have failed to migrate.
	NoOfSrvFailed *int64 `locationName:"noOfSrvFailed" type:"integer"`

	// The outputs of the step.
	Outputs []*WorkflowStepOutput_ `locationName:"outputs" type:"list"`

	// The owner of the step.
	Owner *string `locationName:"owner" type:"string" enum:"Owner"`

	// The previous step.
	Previous []*string `locationName:"previous" type:"list"`

	// The output location of the script.
	ScriptOutputLocation *string `locationName:"scriptOutputLocation" type:"string"`

	// The status of the step.
	Status *string `locationName:"status" type:"string" enum:"StepStatus"`

	// The status message of the migration workflow.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The action type of the step. You must run and update the status of a manual
	// step for the workflow to continue after the completion of the step.
	StepActionType *string `locationName:"stepActionType" type:"string" enum:"StepActionType"`

	// The ID of the step group.
	StepGroupId *string `locationName:"stepGroupId" type:"string"`

	// The ID of the step.
	StepId *string `locationName:"stepId" type:"string"`

	// The servers on which a step will be run.
	StepTarget []*string `locationName:"stepTarget" type:"list"`

	// The total number of servers that have been migrated.
	TotalNoOfSrv *int64 `locationName:"totalNoOfSrv" type:"integer"`

	// The ID of the migration workflow.
	WorkflowId *string `locationName:"workflowId" type:"string"`

	// The custom script to run tests on source or target environments.
	WorkflowStepAutomationConfiguration *WorkflowStepAutomationConfiguration `locationName:"workflowStepAutomationConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowStepOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkflowStepOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetWorkflowStepOutput) SetCreationTime(v time.Time) *GetWorkflowStepOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetWorkflowStepOutput) SetDescription(v string) *GetWorkflowStepOutput {
	s.Description = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetWorkflowStepOutput) SetEndTime(v time.Time) *GetWorkflowStepOutput {
	s.EndTime = &v
	return s
}

// SetLastStartTime sets the LastStartTime field's value.
func (s *GetWorkflowStepOutput) SetLastStartTime(v time.Time) *GetWorkflowStepOutput {
	s.LastStartTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetWorkflowStepOutput) SetName(v string) *GetWorkflowStepOutput {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *GetWorkflowStepOutput) SetNext(v []*string) *GetWorkflowStepOutput {
	s.Next = v
	return s
}

// SetNoOfSrvCompleted sets the NoOfSrvCompleted field's value.
func (s *GetWorkflowStepOutput) SetNoOfSrvCompleted(v int64) *GetWorkflowStepOutput {
	s.NoOfSrvCompleted = &v
	return s
}

// SetNoOfSrvFailed sets the NoOfSrvFailed field's value.
func (s *GetWorkflowStepOutput) SetNoOfSrvFailed(v int64) *GetWorkflowStepOutput {
	s.NoOfSrvFailed = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *GetWorkflowStepOutput) SetOutputs(v []*WorkflowStepOutput_) *GetWorkflowStepOutput {
	s.Outputs = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *GetWorkflowStepOutput) SetOwner(v string) *GetWorkflowStepOutput {
	s.Owner = &v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *GetWorkflowStepOutput) SetPrevious(v []*string) *GetWorkflowStepOutput {
	s.Previous = v
	return s
}

// SetScriptOutputLocation sets the ScriptOutputLocation field's value.
func (s *GetWorkflowStepOutput) SetScriptOutputLocation(v string) *GetWorkflowStepOutput {
	s.ScriptOutputLocation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetWorkflowStepOutput) SetStatus(v string) *GetWorkflowStepOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetWorkflowStepOutput) SetStatusMessage(v string) *GetWorkflowStepOutput {
	s.StatusMessage = &v
	return s
}

// SetStepActionType sets the StepActionType field's value.
func (s *GetWorkflowStepOutput) SetStepActionType(v string) *GetWorkflowStepOutput {
	s.StepActionType = &v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *GetWorkflowStepOutput) SetStepGroupId(v string) *GetWorkflowStepOutput {
	s.StepGroupId = &v
	return s
}

// SetStepId sets the StepId field's value.
func (s *GetWorkflowStepOutput) SetStepId(v string) *GetWorkflowStepOutput {
	s.StepId = &v
	return s
}

// SetStepTarget sets the StepTarget field's value.
func (s *GetWorkflowStepOutput) SetStepTarget(v []*string) *GetWorkflowStepOutput {
	s.StepTarget = v
	return s
}

// SetTotalNoOfSrv sets the TotalNoOfSrv field's value.
func (s *GetWorkflowStepOutput) SetTotalNoOfSrv(v int64) *GetWorkflowStepOutput {
	s.TotalNoOfSrv = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *GetWorkflowStepOutput) SetWorkflowId(v string) *GetWorkflowStepOutput {
	s.WorkflowId = &v
	return s
}

// SetWorkflowStepAutomationConfiguration sets the WorkflowStepAutomationConfiguration field's value.
func (s *GetWorkflowStepOutput) SetWorkflowStepAutomationConfiguration(v *WorkflowStepAutomationConfiguration) *GetWorkflowStepOutput {
	s.WorkflowStepAutomationConfiguration = v
	return s
}

// An internal error has occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListPluginsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of plugins that can be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPluginsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPluginsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPluginsInput) SetMaxResults(v int64) *ListPluginsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPluginsInput) SetNextToken(v string) *ListPluginsInput {
	s.NextToken = &v
	return s
}

type ListPluginsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Migration Hub Orchestrator plugins.
	Plugins []*PluginSummary `locationName:"plugins" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPluginsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPluginsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPluginsOutput) SetNextToken(v string) *ListPluginsOutput {
	s.NextToken = &v
	return s
}

// SetPlugins sets the Plugins field's value.
func (s *ListPluginsOutput) SetPlugins(v []*PluginSummary) *ListPluginsOutput {
	s.Plugins = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags added to a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTemplateStepGroupsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that can be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ID of the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateStepGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateStepGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTemplateStepGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTemplateStepGroupsInput"}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTemplateStepGroupsInput) SetMaxResults(v int64) *ListTemplateStepGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplateStepGroupsInput) SetNextToken(v string) *ListTemplateStepGroupsInput {
	s.NextToken = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *ListTemplateStepGroupsInput) SetTemplateId(v string) *ListTemplateStepGroupsInput {
	s.TemplateId = &v
	return s
}

type ListTemplateStepGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The summary of the step group in the template.
	//
	// TemplateStepGroupSummary is a required field
	TemplateStepGroupSummary []*TemplateStepGroupSummary `locationName:"templateStepGroupSummary" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateStepGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateStepGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplateStepGroupsOutput) SetNextToken(v string) *ListTemplateStepGroupsOutput {
	s.NextToken = &v
	return s
}

// SetTemplateStepGroupSummary sets the TemplateStepGroupSummary field's value.
func (s *ListTemplateStepGroupsOutput) SetTemplateStepGroupSummary(v []*TemplateStepGroupSummary) *ListTemplateStepGroupsOutput {
	s.TemplateStepGroupSummary = v
	return s
}

type ListTemplateStepsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that can be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ID of the step group.
	//
	// StepGroupId is a required field
	StepGroupId *string `location:"querystring" locationName:"stepGroupId" min:"1" type:"string" required:"true"`

	// The ID of the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"querystring" locationName:"templateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateStepsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateStepsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTemplateStepsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTemplateStepsInput"}
	if s.StepGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepGroupId"))
	}
	if s.StepGroupId != nil && len(*s.StepGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepGroupId", 1))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTemplateStepsInput) SetMaxResults(v int64) *ListTemplateStepsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplateStepsInput) SetNextToken(v string) *ListTemplateStepsInput {
	s.NextToken = &v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *ListTemplateStepsInput) SetStepGroupId(v string) *ListTemplateStepsInput {
	s.StepGroupId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *ListTemplateStepsInput) SetTemplateId(v string) *ListTemplateStepsInput {
	s.TemplateId = &v
	return s
}

type ListTemplateStepsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of summaries of steps in a template.
	TemplateStepSummaryList []*TemplateStepSummary `locationName:"templateStepSummaryList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateStepsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplateStepsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplateStepsOutput) SetNextToken(v string) *ListTemplateStepsOutput {
	s.NextToken = &v
	return s
}

// SetTemplateStepSummaryList sets the TemplateStepSummaryList field's value.
func (s *ListTemplateStepsOutput) SetTemplateStepSummaryList(v []*TemplateStepSummary) *ListTemplateStepsOutput {
	s.TemplateStepSummaryList = v
	return s
}

type ListTemplatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that can be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The name of the template.
	Name *string `location:"querystring" locationName:"name" min:"1" type:"string"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTemplatesInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTemplatesInput) SetMaxResults(v int64) *ListTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListTemplatesInput) SetName(v string) *ListTemplatesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplatesInput) SetNextToken(v string) *ListTemplatesInput {
	s.NextToken = &v
	return s
}

type ListTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The summary of the template.
	//
	// TemplateSummary is a required field
	TemplateSummary []*TemplateSummary `locationName:"templateSummary" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplatesOutput) SetNextToken(v string) *ListTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetTemplateSummary sets the TemplateSummary field's value.
func (s *ListTemplatesOutput) SetTemplateSummary(v []*TemplateSummary) *ListTemplatesOutput {
	s.TemplateSummary = v
	return s
}

type ListWorkflowStepGroupsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that can be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ID of the migration workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `location:"querystring" locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowStepGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowStepGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkflowStepGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkflowStepGroupsInput"}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkflowStepGroupsInput) SetMaxResults(v int64) *ListWorkflowStepGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkflowStepGroupsInput) SetNextToken(v string) *ListWorkflowStepGroupsInput {
	s.NextToken = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *ListWorkflowStepGroupsInput) SetWorkflowId(v string) *ListWorkflowStepGroupsInput {
	s.WorkflowId = &v
	return s
}

type ListWorkflowStepGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The summary of step groups in a migration workflow.
	//
	// WorkflowStepGroupsSummary is a required field
	WorkflowStepGroupsSummary []*WorkflowStepGroupSummary `locationName:"workflowStepGroupsSummary" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowStepGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowStepGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkflowStepGroupsOutput) SetNextToken(v string) *ListWorkflowStepGroupsOutput {
	s.NextToken = &v
	return s
}

// SetWorkflowStepGroupsSummary sets the WorkflowStepGroupsSummary field's value.
func (s *ListWorkflowStepGroupsOutput) SetWorkflowStepGroupsSummary(v []*WorkflowStepGroupSummary) *ListWorkflowStepGroupsOutput {
	s.WorkflowStepGroupsSummary = v
	return s
}

type ListWorkflowStepsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results that can be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ID of the step group.
	//
	// StepGroupId is a required field
	StepGroupId *string `location:"uri" locationName:"stepGroupId" min:"1" type:"string" required:"true"`

	// The ID of the migration workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `location:"uri" locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowStepsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowStepsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkflowStepsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkflowStepsInput"}
	if s.StepGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepGroupId"))
	}
	if s.StepGroupId != nil && len(*s.StepGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepGroupId", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkflowStepsInput) SetMaxResults(v int64) *ListWorkflowStepsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkflowStepsInput) SetNextToken(v string) *ListWorkflowStepsInput {
	s.NextToken = &v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *ListWorkflowStepsInput) SetStepGroupId(v string) *ListWorkflowStepsInput {
	s.StepGroupId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *ListWorkflowStepsInput) SetWorkflowId(v string) *ListWorkflowStepsInput {
	s.WorkflowId = &v
	return s
}

type ListWorkflowStepsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The summary of steps in a migration workflow.
	//
	// WorkflowStepsSummary is a required field
	WorkflowStepsSummary []*WorkflowStepSummary `locationName:"workflowStepsSummary" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowStepsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowStepsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkflowStepsOutput) SetNextToken(v string) *ListWorkflowStepsOutput {
	s.NextToken = &v
	return s
}

// SetWorkflowStepsSummary sets the WorkflowStepsSummary field's value.
func (s *ListWorkflowStepsOutput) SetWorkflowStepsSummary(v []*WorkflowStepSummary) *ListWorkflowStepsOutput {
	s.WorkflowStepsSummary = v
	return s
}

type ListWorkflowsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the application configured in Application Discovery Service.
	AdsApplicationConfigurationName *string `location:"querystring" locationName:"adsApplicationConfigurationName" min:"1" type:"string"`

	// The maximum number of results that can be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The name of the migration workflow.
	Name *string `location:"querystring" locationName:"name" type:"string"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The status of the migration workflow.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"MigrationWorkflowStatusEnum"`

	// The ID of the template.
	TemplateId *string `location:"querystring" locationName:"templateId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkflowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkflowsInput"}
	if s.AdsApplicationConfigurationName != nil && len(*s.AdsApplicationConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdsApplicationConfigurationName", 1))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdsApplicationConfigurationName sets the AdsApplicationConfigurationName field's value.
func (s *ListWorkflowsInput) SetAdsApplicationConfigurationName(v string) *ListWorkflowsInput {
	s.AdsApplicationConfigurationName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkflowsInput) SetMaxResults(v int64) *ListWorkflowsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListWorkflowsInput) SetName(v string) *ListWorkflowsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkflowsInput) SetNextToken(v string) *ListWorkflowsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListWorkflowsInput) SetStatus(v string) *ListWorkflowsInput {
	s.Status = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *ListWorkflowsInput) SetTemplateId(v string) *ListWorkflowsInput {
	s.TemplateId = &v
	return s
}

type ListWorkflowsOutput struct {
	_ struct{} `type:"structure"`

	// The summary of the migration workflow.
	//
	// MigrationWorkflowSummary is a required field
	MigrationWorkflowSummary []*MigrationWorkflowSummary `locationName:"migrationWorkflowSummary" type:"list" required:"true"`

	// The pagination token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkflowsOutput) GoString() string {
	return s.String()
}

// SetMigrationWorkflowSummary sets the MigrationWorkflowSummary field's value.
func (s *ListWorkflowsOutput) SetMigrationWorkflowSummary(v []*MigrationWorkflowSummary) *ListWorkflowsOutput {
	s.MigrationWorkflowSummary = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkflowsOutput) SetNextToken(v string) *ListWorkflowsOutput {
	s.NextToken = &v
	return s
}

// The summary of a migration workflow.
type MigrationWorkflowSummary struct {
	_ struct{} `type:"structure"`

	// The name of the application configured in Application Discovery Service.
	AdsApplicationConfigurationName *string `locationName:"adsApplicationConfigurationName" type:"string"`

	// The steps completed in the migration workflow.
	CompletedSteps *int64 `locationName:"completedSteps" type:"integer"`

	// The time at which the migration workflow was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The time at which the migration workflow ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The ID of the migration workflow.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The name of the migration workflow.
	Name *string `locationName:"name" type:"string"`

	// The status of the migration workflow.
	Status *string `locationName:"status" type:"string" enum:"MigrationWorkflowStatusEnum"`

	// The status message of the migration workflow.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The ID of the template.
	TemplateId *string `locationName:"templateId" type:"string"`

	// All the steps in a migration workflow.
	TotalSteps *int64 `locationName:"totalSteps" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MigrationWorkflowSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MigrationWorkflowSummary) GoString() string {
	return s.String()
}

// SetAdsApplicationConfigurationName sets the AdsApplicationConfigurationName field's value.
func (s *MigrationWorkflowSummary) SetAdsApplicationConfigurationName(v string) *MigrationWorkflowSummary {
	s.AdsApplicationConfigurationName = &v
	return s
}

// SetCompletedSteps sets the CompletedSteps field's value.
func (s *MigrationWorkflowSummary) SetCompletedSteps(v int64) *MigrationWorkflowSummary {
	s.CompletedSteps = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *MigrationWorkflowSummary) SetCreationTime(v time.Time) *MigrationWorkflowSummary {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *MigrationWorkflowSummary) SetEndTime(v time.Time) *MigrationWorkflowSummary {
	s.EndTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *MigrationWorkflowSummary) SetId(v string) *MigrationWorkflowSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *MigrationWorkflowSummary) SetName(v string) *MigrationWorkflowSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MigrationWorkflowSummary) SetStatus(v string) *MigrationWorkflowSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *MigrationWorkflowSummary) SetStatusMessage(v string) *MigrationWorkflowSummary {
	s.StatusMessage = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *MigrationWorkflowSummary) SetTemplateId(v string) *MigrationWorkflowSummary {
	s.TemplateId = &v
	return s
}

// SetTotalSteps sets the TotalSteps field's value.
func (s *MigrationWorkflowSummary) SetTotalSteps(v int64) *MigrationWorkflowSummary {
	s.TotalSteps = &v
	return s
}

// Command to be run on a particular operating system.
type PlatformCommand struct {
	_ struct{} `type:"structure"`

	// Command for Linux.
	Linux *string `locationName:"linux" type:"string"`

	// Command for Windows.
	Windows *string `locationName:"windows" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlatformCommand) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlatformCommand) GoString() string {
	return s.String()
}

// SetLinux sets the Linux field's value.
func (s *PlatformCommand) SetLinux(v string) *PlatformCommand {
	s.Linux = &v
	return s
}

// SetWindows sets the Windows field's value.
func (s *PlatformCommand) SetWindows(v string) *PlatformCommand {
	s.Windows = &v
	return s
}

// The script location for a particular operating system.
type PlatformScriptKey struct {
	_ struct{} `type:"structure"`

	// The script location for Linux.
	Linux *string `locationName:"linux" type:"string"`

	// The script location for Windows.
	Windows *string `locationName:"windows" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlatformScriptKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlatformScriptKey) GoString() string {
	return s.String()
}

// SetLinux sets the Linux field's value.
func (s *PlatformScriptKey) SetLinux(v string) *PlatformScriptKey {
	s.Linux = &v
	return s
}

// SetWindows sets the Windows field's value.
func (s *PlatformScriptKey) SetWindows(v string) *PlatformScriptKey {
	s.Windows = &v
	return s
}

// The summary of the Migration Hub Orchestrator plugin.
type PluginSummary struct {
	_ struct{} `type:"structure"`

	// The name of the host.
	Hostname *string `locationName:"hostname" type:"string"`

	// The IP address at which the plugin is located.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// The ID of the plugin.
	PluginId *string `locationName:"pluginId" min:"1" type:"string"`

	// The time at which the plugin was registered.
	RegisteredTime *string `locationName:"registeredTime" type:"string"`

	// The status of the plugin.
	Status *string `locationName:"status" type:"string" enum:"PluginHealth"`

	// The version of the plugin.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PluginSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PluginSummary) GoString() string {
	return s.String()
}

// SetHostname sets the Hostname field's value.
func (s *PluginSummary) SetHostname(v string) *PluginSummary {
	s.Hostname = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *PluginSummary) SetIpAddress(v string) *PluginSummary {
	s.IpAddress = &v
	return s
}

// SetPluginId sets the PluginId field's value.
func (s *PluginSummary) SetPluginId(v string) *PluginSummary {
	s.PluginId = &v
	return s
}

// SetRegisteredTime sets the RegisteredTime field's value.
func (s *PluginSummary) SetRegisteredTime(v string) *PluginSummary {
	s.RegisteredTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PluginSummary) SetStatus(v string) *PluginSummary {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PluginSummary) SetVersion(v string) *PluginSummary {
	s.Version = &v
	return s
}

// The resource is not available.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RetryWorkflowStepInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the step.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The ID of the step group.
	//
	// StepGroupId is a required field
	StepGroupId *string `location:"querystring" locationName:"stepGroupId" min:"1" type:"string" required:"true"`

	// The ID of the migration workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `location:"querystring" locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryWorkflowStepInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryWorkflowStepInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetryWorkflowStepInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetryWorkflowStepInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.StepGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepGroupId"))
	}
	if s.StepGroupId != nil && len(*s.StepGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepGroupId", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *RetryWorkflowStepInput) SetId(v string) *RetryWorkflowStepInput {
	s.Id = &v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *RetryWorkflowStepInput) SetStepGroupId(v string) *RetryWorkflowStepInput {
	s.StepGroupId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *RetryWorkflowStepInput) SetWorkflowId(v string) *RetryWorkflowStepInput {
	s.WorkflowId = &v
	return s
}

type RetryWorkflowStepOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the step.
	Id *string `locationName:"id" type:"string"`

	// The status of the step.
	Status *string `locationName:"status" type:"string" enum:"StepStatus"`

	// The ID of the step group.
	StepGroupId *string `locationName:"stepGroupId" type:"string"`

	// The ID of the migration workflow.
	WorkflowId *string `locationName:"workflowId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryWorkflowStepOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryWorkflowStepOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *RetryWorkflowStepOutput) SetId(v string) *RetryWorkflowStepOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RetryWorkflowStepOutput) SetStatus(v string) *RetryWorkflowStepOutput {
	s.Status = &v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *RetryWorkflowStepOutput) SetStepGroupId(v string) *RetryWorkflowStepOutput {
	s.StepGroupId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *RetryWorkflowStepOutput) SetWorkflowId(v string) *RetryWorkflowStepOutput {
	s.WorkflowId = &v
	return s
}

type StartWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the migration workflow.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartWorkflowInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *StartWorkflowInput) SetId(v string) *StartWorkflowInput {
	s.Id = &v
	return s
}

type StartWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the migration workflow.
	Arn *string `locationName:"arn" type:"string"`

	// The ID of the migration workflow.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The time at which the migration workflow was last started.
	LastStartTime *time.Time `locationName:"lastStartTime" type:"timestamp"`

	// The status of the migration workflow.
	Status *string `locationName:"status" type:"string" enum:"MigrationWorkflowStatusEnum"`

	// The status message of the migration workflow.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkflowOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartWorkflowOutput) SetArn(v string) *StartWorkflowOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartWorkflowOutput) SetId(v string) *StartWorkflowOutput {
	s.Id = &v
	return s
}

// SetLastStartTime sets the LastStartTime field's value.
func (s *StartWorkflowOutput) SetLastStartTime(v time.Time) *StartWorkflowOutput {
	s.LastStartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartWorkflowOutput) SetStatus(v string) *StartWorkflowOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *StartWorkflowOutput) SetStatusMessage(v string) *StartWorkflowOutput {
	s.StatusMessage = &v
	return s
}

// The custom script to run tests on source or target environments.
type StepAutomationConfiguration struct {
	_ struct{} `type:"structure"`

	// The command to run the script.
	Command *PlatformCommand `locationName:"command" type:"structure"`

	// The source or target environment.
	RunEnvironment *string `locationName:"runEnvironment" type:"string" enum:"RunEnvironment"`

	// The Amazon S3 bucket where the script is located.
	ScriptLocationS3Bucket *string `locationName:"scriptLocationS3Bucket" type:"string"`

	// The Amazon S3 key for the script location.
	ScriptLocationS3Key *PlatformScriptKey `locationName:"scriptLocationS3Key" type:"structure"`

	// The servers on which to run the script.
	TargetType *string `locationName:"targetType" type:"string" enum:"TargetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepAutomationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepAutomationConfiguration) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *StepAutomationConfiguration) SetCommand(v *PlatformCommand) *StepAutomationConfiguration {
	s.Command = v
	return s
}

// SetRunEnvironment sets the RunEnvironment field's value.
func (s *StepAutomationConfiguration) SetRunEnvironment(v string) *StepAutomationConfiguration {
	s.RunEnvironment = &v
	return s
}

// SetScriptLocationS3Bucket sets the ScriptLocationS3Bucket field's value.
func (s *StepAutomationConfiguration) SetScriptLocationS3Bucket(v string) *StepAutomationConfiguration {
	s.ScriptLocationS3Bucket = &v
	return s
}

// SetScriptLocationS3Key sets the ScriptLocationS3Key field's value.
func (s *StepAutomationConfiguration) SetScriptLocationS3Key(v *PlatformScriptKey) *StepAutomationConfiguration {
	s.ScriptLocationS3Key = v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *StepAutomationConfiguration) SetTargetType(v string) *StepAutomationConfiguration {
	s.TargetType = &v
	return s
}

// A map of key value pairs that is generated when you create a migration workflow.
// The key value pairs will differ based on your selection of the template.
type StepInput_ struct {
	_ struct{} `type:"structure"`

	// The value of the integer.
	IntegerValue *int64 `locationName:"integerValue" type:"integer"`

	// List of string values.
	ListOfStringsValue []*string `locationName:"listOfStringsValue" type:"list"`

	// Map of string values.
	MapOfStringValue map[string]*string `locationName:"mapOfStringValue" type:"map"`

	// String value.
	StringValue *string `locationName:"stringValue" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepInput_) GoString() string {
	return s.String()
}

// SetIntegerValue sets the IntegerValue field's value.
func (s *StepInput_) SetIntegerValue(v int64) *StepInput_ {
	s.IntegerValue = &v
	return s
}

// SetListOfStringsValue sets the ListOfStringsValue field's value.
func (s *StepInput_) SetListOfStringsValue(v []*string) *StepInput_ {
	s.ListOfStringsValue = v
	return s
}

// SetMapOfStringValue sets the MapOfStringValue field's value.
func (s *StepInput_) SetMapOfStringValue(v map[string]*string) *StepInput_ {
	s.MapOfStringValue = v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *StepInput_) SetStringValue(v string) *StepInput_ {
	s.StringValue = &v
	return s
}

// The output of the step.
type StepOutput_ struct {
	_ struct{} `type:"structure"`

	// The data type of the step output.
	DataType *string `locationName:"dataType" type:"string" enum:"DataType"`

	// The name of the step.
	Name *string `locationName:"name" type:"string"`

	// Determine if an output is required from a step.
	Required *bool `locationName:"required" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepOutput_) GoString() string {
	return s.String()
}

// SetDataType sets the DataType field's value.
func (s *StepOutput_) SetDataType(v string) *StepOutput_ {
	s.DataType = &v
	return s
}

// SetName sets the Name field's value.
func (s *StepOutput_) SetName(v string) *StepOutput_ {
	s.Name = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *StepOutput_) SetRequired(v bool) *StepOutput_ {
	s.Required = &v
	return s
}

type StopWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the migration workflow.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopWorkflowInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *StopWorkflowInput) SetId(v string) *StopWorkflowInput {
	s.Id = &v
	return s
}

type StopWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the migration workflow.
	Arn *string `locationName:"arn" type:"string"`

	// The ID of the migration workflow.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The time at which the migration workflow was stopped.
	LastStopTime *time.Time `locationName:"lastStopTime" type:"timestamp"`

	// The status of the migration workflow.
	Status *string `locationName:"status" type:"string" enum:"MigrationWorkflowStatusEnum"`

	// The status message of the migration workflow.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkflowOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StopWorkflowOutput) SetArn(v string) *StopWorkflowOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *StopWorkflowOutput) SetId(v string) *StopWorkflowOutput {
	s.Id = &v
	return s
}

// SetLastStopTime sets the LastStopTime field's value.
func (s *StopWorkflowOutput) SetLastStopTime(v time.Time) *StopWorkflowOutput {
	s.LastStopTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StopWorkflowOutput) SetStatus(v string) *StopWorkflowOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *StopWorkflowOutput) SetStatusMessage(v string) *StopWorkflowOutput {
	s.StatusMessage = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to which you want to add tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The input parameters of a template.
type TemplateInput_ struct {
	_ struct{} `type:"structure"`

	// The data type of the template input.
	DataType *string `locationName:"dataType" type:"string" enum:"DataType"`

	// The name of the template.
	InputName *string `locationName:"inputName" min:"1" type:"string"`

	// Determine if an input is required from the template.
	Required *bool `locationName:"required" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateInput_) GoString() string {
	return s.String()
}

// SetDataType sets the DataType field's value.
func (s *TemplateInput_) SetDataType(v string) *TemplateInput_ {
	s.DataType = &v
	return s
}

// SetInputName sets the InputName field's value.
func (s *TemplateInput_) SetInputName(v string) *TemplateInput_ {
	s.InputName = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *TemplateInput_) SetRequired(v bool) *TemplateInput_ {
	s.Required = &v
	return s
}

// The migration workflow template used as the source for the new template.
type TemplateSource struct {
	_ struct{} `type:"structure"`

	// The ID of the workflow from the source migration workflow template.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemplateSource"}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *TemplateSource) SetWorkflowId(v string) *TemplateSource {
	s.WorkflowId = &v
	return s
}

// The summary of the step group in the template.
type TemplateStepGroupSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the step group.
	Id *string `locationName:"id" type:"string"`

	// The name of the step group.
	Name *string `locationName:"name" type:"string"`

	// The next step group.
	Next []*string `locationName:"next" type:"list"`

	// The previous step group.
	Previous []*string `locationName:"previous" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateStepGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateStepGroupSummary) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *TemplateStepGroupSummary) SetId(v string) *TemplateStepGroupSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *TemplateStepGroupSummary) SetName(v string) *TemplateStepGroupSummary {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *TemplateStepGroupSummary) SetNext(v []*string) *TemplateStepGroupSummary {
	s.Next = v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *TemplateStepGroupSummary) SetPrevious(v []*string) *TemplateStepGroupSummary {
	s.Previous = v
	return s
}

// The summary of the step.
type TemplateStepSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the step.
	Id *string `locationName:"id" type:"string"`

	// The name of the step.
	Name *string `locationName:"name" type:"string"`

	// The next step.
	Next []*string `locationName:"next" type:"list"`

	// The owner of the step.
	Owner *string `locationName:"owner" type:"string" enum:"Owner"`

	// The previous step.
	Previous []*string `locationName:"previous" type:"list"`

	// The action type of the step. You must run and update the status of a manual
	// step for the workflow to continue after the completion of the step.
	StepActionType *string `locationName:"stepActionType" type:"string" enum:"StepActionType"`

	// The ID of the step group.
	StepGroupId *string `locationName:"stepGroupId" type:"string"`

	// The servers on which to run the script.
	TargetType *string `locationName:"targetType" type:"string" enum:"TargetType"`

	// The ID of the template.
	TemplateId *string `locationName:"templateId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateStepSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateStepSummary) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *TemplateStepSummary) SetId(v string) *TemplateStepSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *TemplateStepSummary) SetName(v string) *TemplateStepSummary {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *TemplateStepSummary) SetNext(v []*string) *TemplateStepSummary {
	s.Next = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *TemplateStepSummary) SetOwner(v string) *TemplateStepSummary {
	s.Owner = &v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *TemplateStepSummary) SetPrevious(v []*string) *TemplateStepSummary {
	s.Previous = v
	return s
}

// SetStepActionType sets the StepActionType field's value.
func (s *TemplateStepSummary) SetStepActionType(v string) *TemplateStepSummary {
	s.StepActionType = &v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *TemplateStepSummary) SetStepGroupId(v string) *TemplateStepSummary {
	s.StepGroupId = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *TemplateStepSummary) SetTargetType(v string) *TemplateStepSummary {
	s.TargetType = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *TemplateStepSummary) SetTemplateId(v string) *TemplateStepSummary {
	s.TemplateId = &v
	return s
}

// The summary of the template.
type TemplateSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the template.
	Arn *string `locationName:"arn" type:"string"`

	// The description of the template.
	Description *string `locationName:"description" type:"string"`

	// The ID of the template.
	Id *string `locationName:"id" type:"string"`

	// The name of the template.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TemplateSummary) SetArn(v string) *TemplateSummary {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TemplateSummary) SetDescription(v string) *TemplateSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *TemplateSummary) SetId(v string) *TemplateSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *TemplateSummary) SetName(v string) *TemplateSummary {
	s.Name = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// List of AWS services utilized in a migration workflow.
type Tool struct {
	_ struct{} `type:"structure"`

	// The name of an AWS service.
	Name *string `locationName:"name" type:"string"`

	// The URL of an AWS service.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tool) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Tool) SetName(v string) *Tool {
	s.Name = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Tool) SetUrl(v string) *Tool {
	s.Url = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource from which you want to remove
	// tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// One or more tag keys. Specify only the tag keys, not the tag values.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateTemplateInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the request to update a migration workflow template.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The description of the migration workflow template to update.
	TemplateDescription *string `locationName:"templateDescription" type:"string"`

	// The name of the migration workflow template to update.
	TemplateName *string `locationName:"templateName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTemplateInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateTemplateInput) SetClientToken(v string) *UpdateTemplateInput {
	s.ClientToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateTemplateInput) SetId(v string) *UpdateTemplateInput {
	s.Id = &v
	return s
}

// SetTemplateDescription sets the TemplateDescription field's value.
func (s *UpdateTemplateInput) SetTemplateDescription(v string) *UpdateTemplateInput {
	s.TemplateDescription = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *UpdateTemplateInput) SetTemplateName(v string) *UpdateTemplateInput {
	s.TemplateName = &v
	return s
}

type UpdateTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The tags added to the migration workflow template.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ARN of the migration workflow template being updated. The format for
	// an Migration Hub Orchestrator template ARN is arn:aws:migrationhub-orchestrator:region:account:template/template-abcd1234.
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
	// in the AWS General Reference.
	TemplateArn *string `locationName:"templateArn" type:"string"`

	// The ID of the migration workflow template being updated.
	TemplateId *string `locationName:"templateId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *UpdateTemplateOutput) SetTags(v map[string]*string) *UpdateTemplateOutput {
	s.Tags = v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *UpdateTemplateOutput) SetTemplateArn(v string) *UpdateTemplateOutput {
	s.TemplateArn = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *UpdateTemplateOutput) SetTemplateId(v string) *UpdateTemplateOutput {
	s.TemplateId = &v
	return s
}

type UpdateWorkflowInput struct {
	_ struct{} `type:"structure"`

	// The description of the migration workflow.
	Description *string `locationName:"description" type:"string"`

	// The ID of the migration workflow.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The input parameters required to update a migration workflow.
	//
	// InputParameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateWorkflowInput's
	// String and GoString methods.
	InputParameters map[string]*StepInput_ `locationName:"inputParameters" type:"map" sensitive:"true"`

	// The name of the migration workflow.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The servers on which a step will be run.
	StepTargets []*string `locationName:"stepTargets" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkflowInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateWorkflowInput) SetDescription(v string) *UpdateWorkflowInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWorkflowInput) SetId(v string) *UpdateWorkflowInput {
	s.Id = &v
	return s
}

// SetInputParameters sets the InputParameters field's value.
func (s *UpdateWorkflowInput) SetInputParameters(v map[string]*StepInput_) *UpdateWorkflowInput {
	s.InputParameters = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWorkflowInput) SetName(v string) *UpdateWorkflowInput {
	s.Name = &v
	return s
}

// SetStepTargets sets the StepTargets field's value.
func (s *UpdateWorkflowInput) SetStepTargets(v []*string) *UpdateWorkflowInput {
	s.StepTargets = v
	return s
}

type UpdateWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the application configured in Application Discovery Service.
	AdsApplicationConfigurationId *string `locationName:"adsApplicationConfigurationId" type:"string"`

	// The Amazon Resource Name (ARN) of the migration workflow.
	Arn *string `locationName:"arn" type:"string"`

	// The time at which the migration workflow was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The description of the migration workflow.
	Description *string `locationName:"description" type:"string"`

	// The ID of the migration workflow.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The time at which the migration workflow was last modified.
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp"`

	// The name of the migration workflow.
	Name *string `locationName:"name" type:"string"`

	// The status of the migration workflow.
	Status *string `locationName:"status" type:"string" enum:"MigrationWorkflowStatusEnum"`

	// The servers on which a step will be run.
	StepTargets []*string `locationName:"stepTargets" type:"list"`

	// The tags added to the migration workflow.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the template.
	TemplateId *string `locationName:"templateId" type:"string"`

	// The inputs required to update a migration workflow.
	//
	// WorkflowInputs is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateWorkflowOutput's
	// String and GoString methods.
	WorkflowInputs map[string]*StepInput_ `locationName:"workflowInputs" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowOutput) GoString() string {
	return s.String()
}

// SetAdsApplicationConfigurationId sets the AdsApplicationConfigurationId field's value.
func (s *UpdateWorkflowOutput) SetAdsApplicationConfigurationId(v string) *UpdateWorkflowOutput {
	s.AdsApplicationConfigurationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateWorkflowOutput) SetArn(v string) *UpdateWorkflowOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateWorkflowOutput) SetCreationTime(v time.Time) *UpdateWorkflowOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateWorkflowOutput) SetDescription(v string) *UpdateWorkflowOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWorkflowOutput) SetId(v string) *UpdateWorkflowOutput {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateWorkflowOutput) SetLastModifiedTime(v time.Time) *UpdateWorkflowOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWorkflowOutput) SetName(v string) *UpdateWorkflowOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateWorkflowOutput) SetStatus(v string) *UpdateWorkflowOutput {
	s.Status = &v
	return s
}

// SetStepTargets sets the StepTargets field's value.
func (s *UpdateWorkflowOutput) SetStepTargets(v []*string) *UpdateWorkflowOutput {
	s.StepTargets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateWorkflowOutput) SetTags(v map[string]*string) *UpdateWorkflowOutput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *UpdateWorkflowOutput) SetTemplateId(v string) *UpdateWorkflowOutput {
	s.TemplateId = &v
	return s
}

// SetWorkflowInputs sets the WorkflowInputs field's value.
func (s *UpdateWorkflowOutput) SetWorkflowInputs(v map[string]*StepInput_) *UpdateWorkflowOutput {
	s.WorkflowInputs = v
	return s
}

type UpdateWorkflowStepGroupInput struct {
	_ struct{} `type:"structure"`

	// The description of the step group.
	Description *string `locationName:"description" type:"string"`

	// The ID of the step group.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The name of the step group.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next step group.
	Next []*string `locationName:"next" type:"list"`

	// The previous step group.
	Previous []*string `locationName:"previous" type:"list"`

	// The ID of the migration workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `location:"querystring" locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowStepGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowStepGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkflowStepGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkflowStepGroupInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateWorkflowStepGroupInput) SetDescription(v string) *UpdateWorkflowStepGroupInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWorkflowStepGroupInput) SetId(v string) *UpdateWorkflowStepGroupInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWorkflowStepGroupInput) SetName(v string) *UpdateWorkflowStepGroupInput {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *UpdateWorkflowStepGroupInput) SetNext(v []*string) *UpdateWorkflowStepGroupInput {
	s.Next = v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *UpdateWorkflowStepGroupInput) SetPrevious(v []*string) *UpdateWorkflowStepGroupInput {
	s.Previous = v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *UpdateWorkflowStepGroupInput) SetWorkflowId(v string) *UpdateWorkflowStepGroupInput {
	s.WorkflowId = &v
	return s
}

type UpdateWorkflowStepGroupOutput struct {
	_ struct{} `type:"structure"`

	// The description of the step group.
	Description *string `locationName:"description" type:"string"`

	// The ID of the step group.
	Id *string `locationName:"id" type:"string"`

	// The time at which the step group was last modified.
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp"`

	// The name of the step group.
	Name *string `locationName:"name" type:"string"`

	// The next step group.
	Next []*string `locationName:"next" type:"list"`

	// The previous step group.
	Previous []*string `locationName:"previous" type:"list"`

	// List of AWS services utilized in a migration workflow.
	Tools []*Tool `locationName:"tools" type:"list"`

	// The ID of the migration workflow.
	WorkflowId *string `locationName:"workflowId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowStepGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowStepGroupOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *UpdateWorkflowStepGroupOutput) SetDescription(v string) *UpdateWorkflowStepGroupOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWorkflowStepGroupOutput) SetId(v string) *UpdateWorkflowStepGroupOutput {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateWorkflowStepGroupOutput) SetLastModifiedTime(v time.Time) *UpdateWorkflowStepGroupOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWorkflowStepGroupOutput) SetName(v string) *UpdateWorkflowStepGroupOutput {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *UpdateWorkflowStepGroupOutput) SetNext(v []*string) *UpdateWorkflowStepGroupOutput {
	s.Next = v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *UpdateWorkflowStepGroupOutput) SetPrevious(v []*string) *UpdateWorkflowStepGroupOutput {
	s.Previous = v
	return s
}

// SetTools sets the Tools field's value.
func (s *UpdateWorkflowStepGroupOutput) SetTools(v []*Tool) *UpdateWorkflowStepGroupOutput {
	s.Tools = v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *UpdateWorkflowStepGroupOutput) SetWorkflowId(v string) *UpdateWorkflowStepGroupOutput {
	s.WorkflowId = &v
	return s
}

type UpdateWorkflowStepInput struct {
	_ struct{} `type:"structure"`

	// The description of the step.
	Description *string `locationName:"description" type:"string"`

	// The ID of the step.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The name of the step.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next step.
	Next []*string `locationName:"next" type:"list"`

	// The outputs of a step.
	Outputs []*WorkflowStepOutput_ `locationName:"outputs" type:"list"`

	// The previous step.
	Previous []*string `locationName:"previous" type:"list"`

	// The status of the step.
	Status *string `locationName:"status" type:"string" enum:"StepStatus"`

	// The action type of the step. You must run and update the status of a manual
	// step for the workflow to continue after the completion of the step.
	StepActionType *string `locationName:"stepActionType" type:"string" enum:"StepActionType"`

	// The ID of the step group.
	//
	// StepGroupId is a required field
	StepGroupId *string `locationName:"stepGroupId" min:"1" type:"string" required:"true"`

	// The servers on which a step will be run.
	StepTarget []*string `locationName:"stepTarget" type:"list"`

	// The ID of the migration workflow.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`

	// The custom script to run tests on the source and target environments.
	WorkflowStepAutomationConfiguration *WorkflowStepAutomationConfiguration `locationName:"workflowStepAutomationConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowStepInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowStepInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkflowStepInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkflowStepInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.StepGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepGroupId"))
	}
	if s.StepGroupId != nil && len(*s.StepGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepGroupId", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateWorkflowStepInput) SetDescription(v string) *UpdateWorkflowStepInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateWorkflowStepInput) SetId(v string) *UpdateWorkflowStepInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWorkflowStepInput) SetName(v string) *UpdateWorkflowStepInput {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *UpdateWorkflowStepInput) SetNext(v []*string) *UpdateWorkflowStepInput {
	s.Next = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *UpdateWorkflowStepInput) SetOutputs(v []*WorkflowStepOutput_) *UpdateWorkflowStepInput {
	s.Outputs = v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *UpdateWorkflowStepInput) SetPrevious(v []*string) *UpdateWorkflowStepInput {
	s.Previous = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateWorkflowStepInput) SetStatus(v string) *UpdateWorkflowStepInput {
	s.Status = &v
	return s
}

// SetStepActionType sets the StepActionType field's value.
func (s *UpdateWorkflowStepInput) SetStepActionType(v string) *UpdateWorkflowStepInput {
	s.StepActionType = &v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *UpdateWorkflowStepInput) SetStepGroupId(v string) *UpdateWorkflowStepInput {
	s.StepGroupId = &v
	return s
}

// SetStepTarget sets the StepTarget field's value.
func (s *UpdateWorkflowStepInput) SetStepTarget(v []*string) *UpdateWorkflowStepInput {
	s.StepTarget = v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *UpdateWorkflowStepInput) SetWorkflowId(v string) *UpdateWorkflowStepInput {
	s.WorkflowId = &v
	return s
}

// SetWorkflowStepAutomationConfiguration sets the WorkflowStepAutomationConfiguration field's value.
func (s *UpdateWorkflowStepInput) SetWorkflowStepAutomationConfiguration(v *WorkflowStepAutomationConfiguration) *UpdateWorkflowStepInput {
	s.WorkflowStepAutomationConfiguration = v
	return s
}

type UpdateWorkflowStepOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the step.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The name of the step.
	Name *string `locationName:"name" type:"string"`

	// The ID of the step group.
	StepGroupId *string `locationName:"stepGroupId" type:"string"`

	// The ID of the migration workflow.
	WorkflowId *string `locationName:"workflowId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowStepOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkflowStepOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *UpdateWorkflowStepOutput) SetId(v string) *UpdateWorkflowStepOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWorkflowStepOutput) SetName(v string) *UpdateWorkflowStepOutput {
	s.Name = &v
	return s
}

// SetStepGroupId sets the StepGroupId field's value.
func (s *UpdateWorkflowStepOutput) SetStepGroupId(v string) *UpdateWorkflowStepOutput {
	s.StepGroupId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *UpdateWorkflowStepOutput) SetWorkflowId(v string) *UpdateWorkflowStepOutput {
	s.WorkflowId = &v
	return s
}

// The input fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The custom script to run tests on source or target environments.
type WorkflowStepAutomationConfiguration struct {
	_ struct{} `type:"structure"`

	// The command required to run the script.
	Command *PlatformCommand `locationName:"command" type:"structure"`

	// The source or target environment.
	RunEnvironment *string `locationName:"runEnvironment" type:"string" enum:"RunEnvironment"`

	// The Amazon S3 bucket where the script is located.
	ScriptLocationS3Bucket *string `locationName:"scriptLocationS3Bucket" type:"string"`

	// The Amazon S3 key for the script location.
	ScriptLocationS3Key *PlatformScriptKey `locationName:"scriptLocationS3Key" type:"structure"`

	// The servers on which to run the script.
	TargetType *string `locationName:"targetType" type:"string" enum:"TargetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStepAutomationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStepAutomationConfiguration) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *WorkflowStepAutomationConfiguration) SetCommand(v *PlatformCommand) *WorkflowStepAutomationConfiguration {
	s.Command = v
	return s
}

// SetRunEnvironment sets the RunEnvironment field's value.
func (s *WorkflowStepAutomationConfiguration) SetRunEnvironment(v string) *WorkflowStepAutomationConfiguration {
	s.RunEnvironment = &v
	return s
}

// SetScriptLocationS3Bucket sets the ScriptLocationS3Bucket field's value.
func (s *WorkflowStepAutomationConfiguration) SetScriptLocationS3Bucket(v string) *WorkflowStepAutomationConfiguration {
	s.ScriptLocationS3Bucket = &v
	return s
}

// SetScriptLocationS3Key sets the ScriptLocationS3Key field's value.
func (s *WorkflowStepAutomationConfiguration) SetScriptLocationS3Key(v *PlatformScriptKey) *WorkflowStepAutomationConfiguration {
	s.ScriptLocationS3Key = v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *WorkflowStepAutomationConfiguration) SetTargetType(v string) *WorkflowStepAutomationConfiguration {
	s.TargetType = &v
	return s
}

// The summary of a step group in a workflow.
type WorkflowStepGroupSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the step group.
	Id *string `locationName:"id" type:"string"`

	// The name of the step group.
	Name *string `locationName:"name" type:"string"`

	// The next step group.
	Next []*string `locationName:"next" type:"list"`

	// The owner of the step group.
	Owner *string `locationName:"owner" type:"string" enum:"Owner"`

	// The previous step group.
	Previous []*string `locationName:"previous" type:"list"`

	// The status of the step group.
	Status *string `locationName:"status" type:"string" enum:"StepGroupStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStepGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStepGroupSummary) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *WorkflowStepGroupSummary) SetId(v string) *WorkflowStepGroupSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkflowStepGroupSummary) SetName(v string) *WorkflowStepGroupSummary {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *WorkflowStepGroupSummary) SetNext(v []*string) *WorkflowStepGroupSummary {
	s.Next = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *WorkflowStepGroupSummary) SetOwner(v string) *WorkflowStepGroupSummary {
	s.Owner = &v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *WorkflowStepGroupSummary) SetPrevious(v []*string) *WorkflowStepGroupSummary {
	s.Previous = v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkflowStepGroupSummary) SetStatus(v string) *WorkflowStepGroupSummary {
	s.Status = &v
	return s
}

// A structure to hold multiple values of an output.
type WorkflowStepOutputUnion struct {
	_ struct{} `type:"structure"`

	// The integer value.
	IntegerValue *int64 `locationName:"integerValue" type:"integer"`

	// The list of string value.
	ListOfStringValue []*string `locationName:"listOfStringValue" type:"list"`

	// The string value.
	StringValue *string `locationName:"stringValue" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStepOutputUnion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStepOutputUnion) GoString() string {
	return s.String()
}

// SetIntegerValue sets the IntegerValue field's value.
func (s *WorkflowStepOutputUnion) SetIntegerValue(v int64) *WorkflowStepOutputUnion {
	s.IntegerValue = &v
	return s
}

// SetListOfStringValue sets the ListOfStringValue field's value.
func (s *WorkflowStepOutputUnion) SetListOfStringValue(v []*string) *WorkflowStepOutputUnion {
	s.ListOfStringValue = v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *WorkflowStepOutputUnion) SetStringValue(v string) *WorkflowStepOutputUnion {
	s.StringValue = &v
	return s
}

// The output of a step.
type WorkflowStepOutput_ struct {
	_ struct{} `type:"structure"`

	// The data type of the output.
	DataType *string `locationName:"dataType" type:"string" enum:"DataType"`

	// The name of the step.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Determine if an output is required from a step.
	Required *bool `locationName:"required" type:"boolean"`

	// The value of the output.
	Value *WorkflowStepOutputUnion `locationName:"value" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStepOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStepOutput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkflowStepOutput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkflowStepOutput_"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataType sets the DataType field's value.
func (s *WorkflowStepOutput_) SetDataType(v string) *WorkflowStepOutput_ {
	s.DataType = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkflowStepOutput_) SetName(v string) *WorkflowStepOutput_ {
	s.Name = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *WorkflowStepOutput_) SetRequired(v bool) *WorkflowStepOutput_ {
	s.Required = &v
	return s
}

// SetValue sets the Value field's value.
func (s *WorkflowStepOutput_) SetValue(v *WorkflowStepOutputUnion) *WorkflowStepOutput_ {
	s.Value = v
	return s
}

// The summary of the step in a migration workflow.
type WorkflowStepSummary struct {
	_ struct{} `type:"structure"`

	// The description of the step.
	Description *string `locationName:"description" type:"string"`

	// The name of the step.
	Name *string `locationName:"name" type:"string"`

	// The next step.
	Next []*string `locationName:"next" type:"list"`

	// The number of servers that have been migrated.
	NoOfSrvCompleted *int64 `locationName:"noOfSrvCompleted" type:"integer"`

	// The number of servers that have failed to migrate.
	NoOfSrvFailed *int64 `locationName:"noOfSrvFailed" type:"integer"`

	// The owner of the step.
	Owner *string `locationName:"owner" type:"string" enum:"Owner"`

	// The previous step.
	Previous []*string `locationName:"previous" type:"list"`

	// The location of the script.
	ScriptLocation *string `locationName:"scriptLocation" type:"string"`

	// The status of the step.
	Status *string `locationName:"status" type:"string" enum:"StepStatus"`

	// The status message of the migration workflow.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The action type of the step. You must run and update the status of a manual
	// step for the workflow to continue after the completion of the step.
	StepActionType *string `locationName:"stepActionType" type:"string" enum:"StepActionType"`

	// The ID of the step.
	StepId *string `locationName:"stepId" type:"string"`

	// The total number of servers that have been migrated.
	TotalNoOfSrv *int64 `locationName:"totalNoOfSrv" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStepSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkflowStepSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *WorkflowStepSummary) SetDescription(v string) *WorkflowStepSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkflowStepSummary) SetName(v string) *WorkflowStepSummary {
	s.Name = &v
	return s
}

// SetNext sets the Next field's value.
func (s *WorkflowStepSummary) SetNext(v []*string) *WorkflowStepSummary {
	s.Next = v
	return s
}

// SetNoOfSrvCompleted sets the NoOfSrvCompleted field's value.
func (s *WorkflowStepSummary) SetNoOfSrvCompleted(v int64) *WorkflowStepSummary {
	s.NoOfSrvCompleted = &v
	return s
}

// SetNoOfSrvFailed sets the NoOfSrvFailed field's value.
func (s *WorkflowStepSummary) SetNoOfSrvFailed(v int64) *WorkflowStepSummary {
	s.NoOfSrvFailed = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *WorkflowStepSummary) SetOwner(v string) *WorkflowStepSummary {
	s.Owner = &v
	return s
}

// SetPrevious sets the Previous field's value.
func (s *WorkflowStepSummary) SetPrevious(v []*string) *WorkflowStepSummary {
	s.Previous = v
	return s
}

// SetScriptLocation sets the ScriptLocation field's value.
func (s *WorkflowStepSummary) SetScriptLocation(v string) *WorkflowStepSummary {
	s.ScriptLocation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkflowStepSummary) SetStatus(v string) *WorkflowStepSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *WorkflowStepSummary) SetStatusMessage(v string) *WorkflowStepSummary {
	s.StatusMessage = &v
	return s
}

// SetStepActionType sets the StepActionType field's value.
func (s *WorkflowStepSummary) SetStepActionType(v string) *WorkflowStepSummary {
	s.StepActionType = &v
	return s
}

// SetStepId sets the StepId field's value.
func (s *WorkflowStepSummary) SetStepId(v string) *WorkflowStepSummary {
	s.StepId = &v
	return s
}

// SetTotalNoOfSrv sets the TotalNoOfSrv field's value.
func (s *WorkflowStepSummary) SetTotalNoOfSrv(v int64) *WorkflowStepSummary {
	s.TotalNoOfSrv = &v
	return s
}

const (
	// DataTypeString is a DataType enum value
	DataTypeString = "STRING"

	// DataTypeInteger is a DataType enum value
	DataTypeInteger = "INTEGER"

	// DataTypeStringlist is a DataType enum value
	DataTypeStringlist = "STRINGLIST"

	// DataTypeStringmap is a DataType enum value
	DataTypeStringmap = "STRINGMAP"
)

// DataType_Values returns all elements of the DataType enum
func DataType_Values() []string {
	return []string{
		DataTypeString,
		DataTypeInteger,
		DataTypeStringlist,
		DataTypeStringmap,
	}
}

const (
	// MigrationWorkflowStatusEnumCreating is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumCreating = "CREATING"

	// MigrationWorkflowStatusEnumNotStarted is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumNotStarted = "NOT_STARTED"

	// MigrationWorkflowStatusEnumCreationFailed is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumCreationFailed = "CREATION_FAILED"

	// MigrationWorkflowStatusEnumStarting is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumStarting = "STARTING"

	// MigrationWorkflowStatusEnumInProgress is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumInProgress = "IN_PROGRESS"

	// MigrationWorkflowStatusEnumWorkflowFailed is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumWorkflowFailed = "WORKFLOW_FAILED"

	// MigrationWorkflowStatusEnumPaused is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumPaused = "PAUSED"

	// MigrationWorkflowStatusEnumPausing is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumPausing = "PAUSING"

	// MigrationWorkflowStatusEnumPausingFailed is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumPausingFailed = "PAUSING_FAILED"

	// MigrationWorkflowStatusEnumUserAttentionRequired is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumUserAttentionRequired = "USER_ATTENTION_REQUIRED"

	// MigrationWorkflowStatusEnumDeleting is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumDeleting = "DELETING"

	// MigrationWorkflowStatusEnumDeletionFailed is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumDeletionFailed = "DELETION_FAILED"

	// MigrationWorkflowStatusEnumDeleted is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumDeleted = "DELETED"

	// MigrationWorkflowStatusEnumCompleted is a MigrationWorkflowStatusEnum enum value
	MigrationWorkflowStatusEnumCompleted = "COMPLETED"
)

// MigrationWorkflowStatusEnum_Values returns all elements of the MigrationWorkflowStatusEnum enum
func MigrationWorkflowStatusEnum_Values() []string {
	return []string{
		MigrationWorkflowStatusEnumCreating,
		MigrationWorkflowStatusEnumNotStarted,
		MigrationWorkflowStatusEnumCreationFailed,
		MigrationWorkflowStatusEnumStarting,
		MigrationWorkflowStatusEnumInProgress,
		MigrationWorkflowStatusEnumWorkflowFailed,
		MigrationWorkflowStatusEnumPaused,
		MigrationWorkflowStatusEnumPausing,
		MigrationWorkflowStatusEnumPausingFailed,
		MigrationWorkflowStatusEnumUserAttentionRequired,
		MigrationWorkflowStatusEnumDeleting,
		MigrationWorkflowStatusEnumDeletionFailed,
		MigrationWorkflowStatusEnumDeleted,
		MigrationWorkflowStatusEnumCompleted,
	}
}

const (
	// OwnerAwsManaged is a Owner enum value
	OwnerAwsManaged = "AWS_MANAGED"

	// OwnerCustom is a Owner enum value
	OwnerCustom = "CUSTOM"
)

// Owner_Values returns all elements of the Owner enum
func Owner_Values() []string {
	return []string{
		OwnerAwsManaged,
		OwnerCustom,
	}
}

const (
	// PluginHealthHealthy is a PluginHealth enum value
	PluginHealthHealthy = "HEALTHY"

	// PluginHealthUnhealthy is a PluginHealth enum value
	PluginHealthUnhealthy = "UNHEALTHY"
)

// PluginHealth_Values returns all elements of the PluginHealth enum
func PluginHealth_Values() []string {
	return []string{
		PluginHealthHealthy,
		PluginHealthUnhealthy,
	}
}

const (
	// RunEnvironmentAws is a RunEnvironment enum value
	RunEnvironmentAws = "AWS"

	// RunEnvironmentOnpremise is a RunEnvironment enum value
	RunEnvironmentOnpremise = "ONPREMISE"
)

// RunEnvironment_Values returns all elements of the RunEnvironment enum
func RunEnvironment_Values() []string {
	return []string{
		RunEnvironmentAws,
		RunEnvironmentOnpremise,
	}
}

const (
	// StepActionTypeManual is a StepActionType enum value
	StepActionTypeManual = "MANUAL"

	// StepActionTypeAutomated is a StepActionType enum value
	StepActionTypeAutomated = "AUTOMATED"
)

// StepActionType_Values returns all elements of the StepActionType enum
func StepActionType_Values() []string {
	return []string{
		StepActionTypeManual,
		StepActionTypeAutomated,
	}
}

const (
	// StepGroupStatusAwaitingDependencies is a StepGroupStatus enum value
	StepGroupStatusAwaitingDependencies = "AWAITING_DEPENDENCIES"

	// StepGroupStatusReady is a StepGroupStatus enum value
	StepGroupStatusReady = "READY"

	// StepGroupStatusInProgress is a StepGroupStatus enum value
	StepGroupStatusInProgress = "IN_PROGRESS"

	// StepGroupStatusCompleted is a StepGroupStatus enum value
	StepGroupStatusCompleted = "COMPLETED"

	// StepGroupStatusFailed is a StepGroupStatus enum value
	StepGroupStatusFailed = "FAILED"

	// StepGroupStatusPaused is a StepGroupStatus enum value
	StepGroupStatusPaused = "PAUSED"

	// StepGroupStatusPausing is a StepGroupStatus enum value
	StepGroupStatusPausing = "PAUSING"

	// StepGroupStatusUserAttentionRequired is a StepGroupStatus enum value
	StepGroupStatusUserAttentionRequired = "USER_ATTENTION_REQUIRED"
)

// StepGroupStatus_Values returns all elements of the StepGroupStatus enum
func StepGroupStatus_Values() []string {
	return []string{
		StepGroupStatusAwaitingDependencies,
		StepGroupStatusReady,
		StepGroupStatusInProgress,
		StepGroupStatusCompleted,
		StepGroupStatusFailed,
		StepGroupStatusPaused,
		StepGroupStatusPausing,
		StepGroupStatusUserAttentionRequired,
	}
}

const (
	// StepStatusAwaitingDependencies is a StepStatus enum value
	StepStatusAwaitingDependencies = "AWAITING_DEPENDENCIES"

	// StepStatusSkipped is a StepStatus enum value
	StepStatusSkipped = "SKIPPED"

	// StepStatusReady is a StepStatus enum value
	StepStatusReady = "READY"

	// StepStatusInProgress is a StepStatus enum value
	StepStatusInProgress = "IN_PROGRESS"

	// StepStatusCompleted is a StepStatus enum value
	StepStatusCompleted = "COMPLETED"

	// StepStatusFailed is a StepStatus enum value
	StepStatusFailed = "FAILED"

	// StepStatusPaused is a StepStatus enum value
	StepStatusPaused = "PAUSED"

	// StepStatusUserAttentionRequired is a StepStatus enum value
	StepStatusUserAttentionRequired = "USER_ATTENTION_REQUIRED"
)

// StepStatus_Values returns all elements of the StepStatus enum
func StepStatus_Values() []string {
	return []string{
		StepStatusAwaitingDependencies,
		StepStatusSkipped,
		StepStatusReady,
		StepStatusInProgress,
		StepStatusCompleted,
		StepStatusFailed,
		StepStatusPaused,
		StepStatusUserAttentionRequired,
	}
}

const (
	// TargetTypeSingle is a TargetType enum value
	TargetTypeSingle = "SINGLE"

	// TargetTypeAll is a TargetType enum value
	TargetTypeAll = "ALL"

	// TargetTypeNone is a TargetType enum value
	TargetTypeNone = "NONE"
)

// TargetType_Values returns all elements of the TargetType enum
func TargetType_Values() []string {
	return []string{
		TargetTypeSingle,
		TargetTypeAll,
		TargetTypeNone,
	}
}

const (
	// TemplateStatusCreated is a TemplateStatus enum value
	TemplateStatusCreated = "CREATED"

	// TemplateStatusReady is a TemplateStatus enum value
	TemplateStatusReady = "READY"

	// TemplateStatusPendingCreation is a TemplateStatus enum value
	TemplateStatusPendingCreation = "PENDING_CREATION"

	// TemplateStatusCreating is a TemplateStatus enum value
	TemplateStatusCreating = "CREATING"

	// TemplateStatusCreationFailed is a TemplateStatus enum value
	TemplateStatusCreationFailed = "CREATION_FAILED"
)

// TemplateStatus_Values returns all elements of the TemplateStatus enum
func TemplateStatus_Values() []string {
	return []string{
		TemplateStatusCreated,
		TemplateStatusReady,
		TemplateStatusPendingCreation,
		TemplateStatusCreating,
		TemplateStatusCreationFailed,
	}
}
