// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package eksauthiface provides an interface to enable mocking the Amazon EKS Auth service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package eksauthiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/eksauth"
)

// EKSAuthAPI provides an interface to enable mocking the
// eksauth.EKSAuth service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon EKS Auth.
//	func myFunc(svc eksauthiface.EKSAuthAPI) bool {
//	    // Make svc.AssumeRoleForPodIdentity request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := eksauth.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockEKSAuthClient struct {
//	    eksauthiface.EKSAuthAPI
//	}
//	func (m *mockEKSAuthClient) AssumeRoleForPodIdentity(input *eksauth.AssumeRoleForPodIdentityInput) (*eksauth.AssumeRoleForPodIdentityOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockEKSAuthClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type EKSAuthAPI interface {
	AssumeRoleForPodIdentity(*eksauth.AssumeRoleForPodIdentityInput) (*eksauth.AssumeRoleForPodIdentityOutput, error)
	AssumeRoleForPodIdentityWithContext(aws.Context, *eksauth.AssumeRoleForPodIdentityInput, ...request.Option) (*eksauth.AssumeRoleForPodIdentityOutput, error)
	AssumeRoleForPodIdentityRequest(*eksauth.AssumeRoleForPodIdentityInput) (*request.Request, *eksauth.AssumeRoleForPodIdentityOutput)
}

var _ EKSAuthAPI = (*eksauth.EKSAuth)(nil)
