// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package controlcatalogiface provides an interface to enable mocking the AWS Control Catalog service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package controlcatalogiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/controlcatalog"
)

// ControlCatalogAPI provides an interface to enable mocking the
// controlcatalog.ControlCatalog service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Control Catalog.
//	func myFunc(svc controlcatalogiface.ControlCatalogAPI) bool {
//	    // Make svc.ListCommonControls request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := controlcatalog.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockControlCatalogClient struct {
//	    controlcatalogiface.ControlCatalogAPI
//	}
//	func (m *mockControlCatalogClient) ListCommonControls(input *controlcatalog.ListCommonControlsInput) (*controlcatalog.ListCommonControlsOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockControlCatalogClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ControlCatalogAPI interface {
	ListCommonControls(*controlcatalog.ListCommonControlsInput) (*controlcatalog.ListCommonControlsOutput, error)
	ListCommonControlsWithContext(aws.Context, *controlcatalog.ListCommonControlsInput, ...request.Option) (*controlcatalog.ListCommonControlsOutput, error)
	ListCommonControlsRequest(*controlcatalog.ListCommonControlsInput) (*request.Request, *controlcatalog.ListCommonControlsOutput)

	ListCommonControlsPages(*controlcatalog.ListCommonControlsInput, func(*controlcatalog.ListCommonControlsOutput, bool) bool) error
	ListCommonControlsPagesWithContext(aws.Context, *controlcatalog.ListCommonControlsInput, func(*controlcatalog.ListCommonControlsOutput, bool) bool, ...request.Option) error

	ListDomains(*controlcatalog.ListDomainsInput) (*controlcatalog.ListDomainsOutput, error)
	ListDomainsWithContext(aws.Context, *controlcatalog.ListDomainsInput, ...request.Option) (*controlcatalog.ListDomainsOutput, error)
	ListDomainsRequest(*controlcatalog.ListDomainsInput) (*request.Request, *controlcatalog.ListDomainsOutput)

	ListDomainsPages(*controlcatalog.ListDomainsInput, func(*controlcatalog.ListDomainsOutput, bool) bool) error
	ListDomainsPagesWithContext(aws.Context, *controlcatalog.ListDomainsInput, func(*controlcatalog.ListDomainsOutput, bool) bool, ...request.Option) error

	ListObjectives(*controlcatalog.ListObjectivesInput) (*controlcatalog.ListObjectivesOutput, error)
	ListObjectivesWithContext(aws.Context, *controlcatalog.ListObjectivesInput, ...request.Option) (*controlcatalog.ListObjectivesOutput, error)
	ListObjectivesRequest(*controlcatalog.ListObjectivesInput) (*request.Request, *controlcatalog.ListObjectivesOutput)

	ListObjectivesPages(*controlcatalog.ListObjectivesInput, func(*controlcatalog.ListObjectivesOutput, bool) bool) error
	ListObjectivesPagesWithContext(aws.Context, *controlcatalog.ListObjectivesInput, func(*controlcatalog.ListObjectivesOutput, bool) bool, ...request.Option) error
}

var _ ControlCatalogAPI = (*controlcatalog.ControlCatalog)(nil)
