// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationautoscaling

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opDeleteScalingPolicy = "DeleteScalingPolicy"

// DeleteScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScalingPolicy for more information on using the DeleteScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteScalingPolicyRequest method.
//	req, resp := client.DeleteScalingPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeleteScalingPolicy
func (c *ApplicationAutoScaling) DeleteScalingPolicyRequest(input *DeleteScalingPolicyInput) (req *request.Request, output *DeleteScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScalingPolicyInput{}
	}

	output = &DeleteScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteScalingPolicy API operation for Application Auto Scaling.
//
// Deletes the specified scaling policy for an Application Auto Scaling scalable
// target.
//
// Deleting a step scaling policy deletes the underlying alarm action, but does
// not delete the CloudWatch alarm associated with the scaling policy, even
// if it no longer has an associated action.
//
// For more information, see Delete a step scaling policy (https://docs.aws.amazon.com/autoscaling/application/userguide/create-step-scaling-policy-cli.html#delete-step-scaling-policy)
// and Delete a target tracking scaling policy (https://docs.aws.amazon.com/autoscaling/application/userguide/create-target-tracking-policy-cli.html#delete-target-tracking-policy)
// in the Application Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DeleteScalingPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception was thrown for a validation issue. Review the available parameters
//     for the API request.
//
//   - ObjectNotFoundException
//     The specified object could not be found. For any operation that depends on
//     the existence of a scalable target, this exception is thrown if the scalable
//     target with the specified service namespace, resource ID, and scalable dimension
//     does not exist. For any operation that deletes or deregisters a resource,
//     this exception is thrown if the resource cannot be found.
//
//   - ConcurrentUpdateException
//     Concurrent updates caused an exception, for example, if you request an update
//     to an Application Auto Scaling resource that already has a pending update.
//
//   - InternalServiceException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeleteScalingPolicy
func (c *ApplicationAutoScaling) DeleteScalingPolicy(input *DeleteScalingPolicyInput) (*DeleteScalingPolicyOutput, error) {
	req, out := c.DeleteScalingPolicyRequest(input)
	return out, req.Send()
}

// DeleteScalingPolicyWithContext is the same as DeleteScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DeleteScalingPolicyWithContext(ctx aws.Context, input *DeleteScalingPolicyInput, opts ...request.Option) (*DeleteScalingPolicyOutput, error) {
	req, out := c.DeleteScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScheduledAction = "DeleteScheduledAction"

// DeleteScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScheduledAction for more information on using the DeleteScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteScheduledActionRequest method.
//	req, resp := client.DeleteScheduledActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeleteScheduledAction
func (c *ApplicationAutoScaling) DeleteScheduledActionRequest(input *DeleteScheduledActionInput) (req *request.Request, output *DeleteScheduledActionOutput) {
	op := &request.Operation{
		Name:       opDeleteScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScheduledActionInput{}
	}

	output = &DeleteScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteScheduledAction API operation for Application Auto Scaling.
//
// Deletes the specified scheduled action for an Application Auto Scaling scalable
// target.
//
// For more information, see Delete a scheduled action (https://docs.aws.amazon.com/autoscaling/application/userguide/scheduled-scaling-additional-cli-commands.html#delete-scheduled-action)
// in the Application Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DeleteScheduledAction for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception was thrown for a validation issue. Review the available parameters
//     for the API request.
//
//   - ObjectNotFoundException
//     The specified object could not be found. For any operation that depends on
//     the existence of a scalable target, this exception is thrown if the scalable
//     target with the specified service namespace, resource ID, and scalable dimension
//     does not exist. For any operation that deletes or deregisters a resource,
//     this exception is thrown if the resource cannot be found.
//
//   - ConcurrentUpdateException
//     Concurrent updates caused an exception, for example, if you request an update
//     to an Application Auto Scaling resource that already has a pending update.
//
//   - InternalServiceException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeleteScheduledAction
func (c *ApplicationAutoScaling) DeleteScheduledAction(input *DeleteScheduledActionInput) (*DeleteScheduledActionOutput, error) {
	req, out := c.DeleteScheduledActionRequest(input)
	return out, req.Send()
}

// DeleteScheduledActionWithContext is the same as DeleteScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DeleteScheduledActionWithContext(ctx aws.Context, input *DeleteScheduledActionInput, opts ...request.Option) (*DeleteScheduledActionOutput, error) {
	req, out := c.DeleteScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterScalableTarget = "DeregisterScalableTarget"

// DeregisterScalableTargetRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterScalableTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterScalableTarget for more information on using the DeregisterScalableTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterScalableTargetRequest method.
//	req, resp := client.DeregisterScalableTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeregisterScalableTarget
func (c *ApplicationAutoScaling) DeregisterScalableTargetRequest(input *DeregisterScalableTargetInput) (req *request.Request, output *DeregisterScalableTargetOutput) {
	op := &request.Operation{
		Name:       opDeregisterScalableTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterScalableTargetInput{}
	}

	output = &DeregisterScalableTargetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterScalableTarget API operation for Application Auto Scaling.
//
// Deregisters an Application Auto Scaling scalable target when you have finished
// using it. To see which resources have been registered, use DescribeScalableTargets
// (https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html).
//
// Deregistering a scalable target deletes the scaling policies and the scheduled
// actions that are associated with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DeregisterScalableTarget for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception was thrown for a validation issue. Review the available parameters
//     for the API request.
//
//   - ObjectNotFoundException
//     The specified object could not be found. For any operation that depends on
//     the existence of a scalable target, this exception is thrown if the scalable
//     target with the specified service namespace, resource ID, and scalable dimension
//     does not exist. For any operation that deletes or deregisters a resource,
//     this exception is thrown if the resource cannot be found.
//
//   - ConcurrentUpdateException
//     Concurrent updates caused an exception, for example, if you request an update
//     to an Application Auto Scaling resource that already has a pending update.
//
//   - InternalServiceException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeregisterScalableTarget
func (c *ApplicationAutoScaling) DeregisterScalableTarget(input *DeregisterScalableTargetInput) (*DeregisterScalableTargetOutput, error) {
	req, out := c.DeregisterScalableTargetRequest(input)
	return out, req.Send()
}

// DeregisterScalableTargetWithContext is the same as DeregisterScalableTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterScalableTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DeregisterScalableTargetWithContext(ctx aws.Context, input *DeregisterScalableTargetInput, opts ...request.Option) (*DeregisterScalableTargetOutput, error) {
	req, out := c.DeregisterScalableTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeScalableTargets = "DescribeScalableTargets"

// DescribeScalableTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalableTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalableTargets for more information on using the DescribeScalableTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeScalableTargetsRequest method.
//	req, resp := client.DescribeScalableTargetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalableTargets
func (c *ApplicationAutoScaling) DescribeScalableTargetsRequest(input *DescribeScalableTargetsInput) (req *request.Request, output *DescribeScalableTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeScalableTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalableTargetsInput{}
	}

	output = &DescribeScalableTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalableTargets API operation for Application Auto Scaling.
//
// Gets information about the scalable targets in the specified namespace.
//
// You can filter the results using ResourceIds and ScalableDimension.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DescribeScalableTargets for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception was thrown for a validation issue. Review the available parameters
//     for the API request.
//
//   - InvalidNextTokenException
//     The next token supplied was invalid.
//
//   - ConcurrentUpdateException
//     Concurrent updates caused an exception, for example, if you request an update
//     to an Application Auto Scaling resource that already has a pending update.
//
//   - InternalServiceException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalableTargets
func (c *ApplicationAutoScaling) DescribeScalableTargets(input *DescribeScalableTargetsInput) (*DescribeScalableTargetsOutput, error) {
	req, out := c.DescribeScalableTargetsRequest(input)
	return out, req.Send()
}

// DescribeScalableTargetsWithContext is the same as DescribeScalableTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalableTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScalableTargetsWithContext(ctx aws.Context, input *DescribeScalableTargetsInput, opts ...request.Option) (*DescribeScalableTargetsOutput, error) {
	req, out := c.DescribeScalableTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeScalableTargetsPages iterates over the pages of a DescribeScalableTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScalableTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeScalableTargets operation.
//	pageNum := 0
//	err := client.DescribeScalableTargetsPages(params,
//	    func(page *applicationautoscaling.DescribeScalableTargetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ApplicationAutoScaling) DescribeScalableTargetsPages(input *DescribeScalableTargetsInput, fn func(*DescribeScalableTargetsOutput, bool) bool) error {
	return c.DescribeScalableTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeScalableTargetsPagesWithContext same as DescribeScalableTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScalableTargetsPagesWithContext(ctx aws.Context, input *DescribeScalableTargetsInput, fn func(*DescribeScalableTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScalableTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScalableTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeScalableTargetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeScalingActivities = "DescribeScalingActivities"

// DescribeScalingActivitiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingActivities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalingActivities for more information on using the DescribeScalingActivities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeScalingActivitiesRequest method.
//	req, resp := client.DescribeScalingActivitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingActivities
func (c *ApplicationAutoScaling) DescribeScalingActivitiesRequest(input *DescribeScalingActivitiesInput) (req *request.Request, output *DescribeScalingActivitiesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingActivities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalingActivitiesInput{}
	}

	output = &DescribeScalingActivitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalingActivities API operation for Application Auto Scaling.
//
// Provides descriptive information about the scaling activities in the specified
// namespace from the previous six weeks.
//
// You can filter the results using ResourceId and ScalableDimension.
//
// For information about viewing scaling activities using the Amazon Web Services
// CLI, see Scaling activities for Application Auto Scaling (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scaling-activities.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DescribeScalingActivities for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception was thrown for a validation issue. Review the available parameters
//     for the API request.
//
//   - InvalidNextTokenException
//     The next token supplied was invalid.
//
//   - ConcurrentUpdateException
//     Concurrent updates caused an exception, for example, if you request an update
//     to an Application Auto Scaling resource that already has a pending update.
//
//   - InternalServiceException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingActivities
func (c *ApplicationAutoScaling) DescribeScalingActivities(input *DescribeScalingActivitiesInput) (*DescribeScalingActivitiesOutput, error) {
	req, out := c.DescribeScalingActivitiesRequest(input)
	return out, req.Send()
}

// DescribeScalingActivitiesWithContext is the same as DescribeScalingActivities with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalingActivities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScalingActivitiesWithContext(ctx aws.Context, input *DescribeScalingActivitiesInput, opts ...request.Option) (*DescribeScalingActivitiesOutput, error) {
	req, out := c.DescribeScalingActivitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeScalingActivitiesPages iterates over the pages of a DescribeScalingActivities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScalingActivities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeScalingActivities operation.
//	pageNum := 0
//	err := client.DescribeScalingActivitiesPages(params,
//	    func(page *applicationautoscaling.DescribeScalingActivitiesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ApplicationAutoScaling) DescribeScalingActivitiesPages(input *DescribeScalingActivitiesInput, fn func(*DescribeScalingActivitiesOutput, bool) bool) error {
	return c.DescribeScalingActivitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeScalingActivitiesPagesWithContext same as DescribeScalingActivitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScalingActivitiesPagesWithContext(ctx aws.Context, input *DescribeScalingActivitiesInput, fn func(*DescribeScalingActivitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScalingActivitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScalingActivitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeScalingActivitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeScalingPolicies = "DescribeScalingPolicies"

// DescribeScalingPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalingPolicies for more information on using the DescribeScalingPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeScalingPoliciesRequest method.
//	req, resp := client.DescribeScalingPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingPolicies
func (c *ApplicationAutoScaling) DescribeScalingPoliciesRequest(input *DescribeScalingPoliciesInput) (req *request.Request, output *DescribeScalingPoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalingPoliciesInput{}
	}

	output = &DescribeScalingPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalingPolicies API operation for Application Auto Scaling.
//
// Describes the Application Auto Scaling scaling policies for the specified
// service namespace.
//
// You can filter the results using ResourceId, ScalableDimension, and PolicyNames.
//
// For more information, see Target tracking scaling policies (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html)
// and Step scaling policies (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html)
// in the Application Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DescribeScalingPolicies for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception was thrown for a validation issue. Review the available parameters
//     for the API request.
//
//   - FailedResourceAccessException
//     Failed access to resources caused an exception. This exception is thrown
//     when Application Auto Scaling is unable to retrieve the alarms associated
//     with a scaling policy due to a client error, for example, if the role ARN
//     specified for a scalable target does not have permission to call the CloudWatch
//     DescribeAlarms (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)
//     on your behalf.
//
//   - InvalidNextTokenException
//     The next token supplied was invalid.
//
//   - ConcurrentUpdateException
//     Concurrent updates caused an exception, for example, if you request an update
//     to an Application Auto Scaling resource that already has a pending update.
//
//   - InternalServiceException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingPolicies
func (c *ApplicationAutoScaling) DescribeScalingPolicies(input *DescribeScalingPoliciesInput) (*DescribeScalingPoliciesOutput, error) {
	req, out := c.DescribeScalingPoliciesRequest(input)
	return out, req.Send()
}

// DescribeScalingPoliciesWithContext is the same as DescribeScalingPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalingPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScalingPoliciesWithContext(ctx aws.Context, input *DescribeScalingPoliciesInput, opts ...request.Option) (*DescribeScalingPoliciesOutput, error) {
	req, out := c.DescribeScalingPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeScalingPoliciesPages iterates over the pages of a DescribeScalingPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScalingPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeScalingPolicies operation.
//	pageNum := 0
//	err := client.DescribeScalingPoliciesPages(params,
//	    func(page *applicationautoscaling.DescribeScalingPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ApplicationAutoScaling) DescribeScalingPoliciesPages(input *DescribeScalingPoliciesInput, fn func(*DescribeScalingPoliciesOutput, bool) bool) error {
	return c.DescribeScalingPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeScalingPoliciesPagesWithContext same as DescribeScalingPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScalingPoliciesPagesWithContext(ctx aws.Context, input *DescribeScalingPoliciesInput, fn func(*DescribeScalingPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScalingPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScalingPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeScalingPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeScheduledActions = "DescribeScheduledActions"

// DescribeScheduledActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScheduledActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScheduledActions for more information on using the DescribeScheduledActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeScheduledActionsRequest method.
//	req, resp := client.DescribeScheduledActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScheduledActions
func (c *ApplicationAutoScaling) DescribeScheduledActionsRequest(input *DescribeScheduledActionsInput) (req *request.Request, output *DescribeScheduledActionsOutput) {
	op := &request.Operation{
		Name:       opDescribeScheduledActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScheduledActionsInput{}
	}

	output = &DescribeScheduledActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScheduledActions API operation for Application Auto Scaling.
//
// Describes the Application Auto Scaling scheduled actions for the specified
// service namespace.
//
// You can filter the results using the ResourceId, ScalableDimension, and ScheduledActionNames
// parameters.
//
// For more information, see Scheduled scaling (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html)
// in the Application Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DescribeScheduledActions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception was thrown for a validation issue. Review the available parameters
//     for the API request.
//
//   - InvalidNextTokenException
//     The next token supplied was invalid.
//
//   - ConcurrentUpdateException
//     Concurrent updates caused an exception, for example, if you request an update
//     to an Application Auto Scaling resource that already has a pending update.
//
//   - InternalServiceException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScheduledActions
func (c *ApplicationAutoScaling) DescribeScheduledActions(input *DescribeScheduledActionsInput) (*DescribeScheduledActionsOutput, error) {
	req, out := c.DescribeScheduledActionsRequest(input)
	return out, req.Send()
}

// DescribeScheduledActionsWithContext is the same as DescribeScheduledActions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScheduledActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScheduledActionsWithContext(ctx aws.Context, input *DescribeScheduledActionsInput, opts ...request.Option) (*DescribeScheduledActionsOutput, error) {
	req, out := c.DescribeScheduledActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeScheduledActionsPages iterates over the pages of a DescribeScheduledActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScheduledActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeScheduledActions operation.
//	pageNum := 0
//	err := client.DescribeScheduledActionsPages(params,
//	    func(page *applicationautoscaling.DescribeScheduledActionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ApplicationAutoScaling) DescribeScheduledActionsPages(input *DescribeScheduledActionsInput, fn func(*DescribeScheduledActionsOutput, bool) bool) error {
	return c.DescribeScheduledActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeScheduledActionsPagesWithContext same as DescribeScheduledActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) DescribeScheduledActionsPagesWithContext(ctx aws.Context, input *DescribeScheduledActionsInput, fn func(*DescribeScheduledActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScheduledActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScheduledActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeScheduledActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/ListTagsForResource
func (c *ApplicationAutoScaling) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Application Auto Scaling.
//
// Returns all the tags on the specified Application Auto Scaling scalable target.
//
// For general information about tags, including the format and syntax, see
// Tagging your Amazon Web Services resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// in the Amazon Web Services General Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/ListTagsForResource
func (c *ApplicationAutoScaling) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutScalingPolicy = "PutScalingPolicy"

// PutScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutScalingPolicy for more information on using the PutScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutScalingPolicyRequest method.
//	req, resp := client.PutScalingPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScalingPolicy
func (c *ApplicationAutoScaling) PutScalingPolicyRequest(input *PutScalingPolicyInput) (req *request.Request, output *PutScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opPutScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScalingPolicyInput{}
	}

	output = &PutScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutScalingPolicy API operation for Application Auto Scaling.
//
// Creates or updates a scaling policy for an Application Auto Scaling scalable
// target.
//
// Each scalable target is identified by a service namespace, resource ID, and
// scalable dimension. A scaling policy applies to the scalable target identified
// by those three attributes. You cannot create a scaling policy until you have
// registered the resource as a scalable target.
//
// Multiple scaling policies can be in force at the same time for the same scalable
// target. You can have one or more target tracking scaling policies, one or
// more step scaling policies, or both. However, there is a chance that multiple
// policies could conflict, instructing the scalable target to scale out or
// in at the same time. Application Auto Scaling gives precedence to the policy
// that provides the largest capacity for both scale out and scale in. For example,
// if one policy increases capacity by 3, another policy increases capacity
// by 200 percent, and the current capacity is 10, Application Auto Scaling
// uses the policy with the highest calculated capacity (200% of 10 = 20) and
// scales out to 30.
//
// We recommend caution, however, when using target tracking scaling policies
// with step scaling policies because conflicts between these policies can cause
// undesirable behavior. For example, if the step scaling policy initiates a
// scale-in activity before the target tracking policy is ready to scale in,
// the scale-in activity will not be blocked. After the scale-in activity completes,
// the target tracking policy could instruct the scalable target to scale out
// again.
//
// For more information, see Target tracking scaling policies (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html)
// and Step scaling policies (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html)
// in the Application Auto Scaling User Guide.
//
// If a scalable target is deregistered, the scalable target is no longer available
// to use scaling policies. Any scaling policies that were specified for the
// scalable target are deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation PutScalingPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception was thrown for a validation issue. Review the available parameters
//     for the API request.
//
//   - LimitExceededException
//     A per-account resource limit is exceeded. For more information, see Application
//     Auto Scaling service quotas (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-limits.html).
//
//   - ObjectNotFoundException
//     The specified object could not be found. For any operation that depends on
//     the existence of a scalable target, this exception is thrown if the scalable
//     target with the specified service namespace, resource ID, and scalable dimension
//     does not exist. For any operation that deletes or deregisters a resource,
//     this exception is thrown if the resource cannot be found.
//
//   - ConcurrentUpdateException
//     Concurrent updates caused an exception, for example, if you request an update
//     to an Application Auto Scaling resource that already has a pending update.
//
//   - FailedResourceAccessException
//     Failed access to resources caused an exception. This exception is thrown
//     when Application Auto Scaling is unable to retrieve the alarms associated
//     with a scaling policy due to a client error, for example, if the role ARN
//     specified for a scalable target does not have permission to call the CloudWatch
//     DescribeAlarms (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)
//     on your behalf.
//
//   - InternalServiceException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScalingPolicy
func (c *ApplicationAutoScaling) PutScalingPolicy(input *PutScalingPolicyInput) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	return out, req.Send()
}

// PutScalingPolicyWithContext is the same as PutScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) PutScalingPolicyWithContext(ctx aws.Context, input *PutScalingPolicyInput, opts ...request.Option) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutScheduledAction = "PutScheduledAction"

// PutScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the PutScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutScheduledAction for more information on using the PutScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutScheduledActionRequest method.
//	req, resp := client.PutScheduledActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScheduledAction
func (c *ApplicationAutoScaling) PutScheduledActionRequest(input *PutScheduledActionInput) (req *request.Request, output *PutScheduledActionOutput) {
	op := &request.Operation{
		Name:       opPutScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScheduledActionInput{}
	}

	output = &PutScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutScheduledAction API operation for Application Auto Scaling.
//
// Creates or updates a scheduled action for an Application Auto Scaling scalable
// target.
//
// Each scalable target is identified by a service namespace, resource ID, and
// scalable dimension. A scheduled action applies to the scalable target identified
// by those three attributes. You cannot create a scheduled action until you
// have registered the resource as a scalable target.
//
// When you specify start and end times with a recurring schedule using a cron
// expression or rates, they form the boundaries for when the recurring action
// starts and stops.
//
// To update a scheduled action, specify the parameters that you want to change.
// If you don't specify start and end times, the old values are deleted.
//
// For more information, see Scheduled scaling (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html)
// in the Application Auto Scaling User Guide.
//
// If a scalable target is deregistered, the scalable target is no longer available
// to run scheduled actions. Any scheduled actions that were specified for the
// scalable target are deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation PutScheduledAction for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception was thrown for a validation issue. Review the available parameters
//     for the API request.
//
//   - LimitExceededException
//     A per-account resource limit is exceeded. For more information, see Application
//     Auto Scaling service quotas (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-limits.html).
//
//   - ObjectNotFoundException
//     The specified object could not be found. For any operation that depends on
//     the existence of a scalable target, this exception is thrown if the scalable
//     target with the specified service namespace, resource ID, and scalable dimension
//     does not exist. For any operation that deletes or deregisters a resource,
//     this exception is thrown if the resource cannot be found.
//
//   - ConcurrentUpdateException
//     Concurrent updates caused an exception, for example, if you request an update
//     to an Application Auto Scaling resource that already has a pending update.
//
//   - InternalServiceException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScheduledAction
func (c *ApplicationAutoScaling) PutScheduledAction(input *PutScheduledActionInput) (*PutScheduledActionOutput, error) {
	req, out := c.PutScheduledActionRequest(input)
	return out, req.Send()
}

// PutScheduledActionWithContext is the same as PutScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See PutScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) PutScheduledActionWithContext(ctx aws.Context, input *PutScheduledActionInput, opts ...request.Option) (*PutScheduledActionOutput, error) {
	req, out := c.PutScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterScalableTarget = "RegisterScalableTarget"

// RegisterScalableTargetRequest generates a "aws/request.Request" representing the
// client's request for the RegisterScalableTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterScalableTarget for more information on using the RegisterScalableTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterScalableTargetRequest method.
//	req, resp := client.RegisterScalableTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/RegisterScalableTarget
func (c *ApplicationAutoScaling) RegisterScalableTargetRequest(input *RegisterScalableTargetInput) (req *request.Request, output *RegisterScalableTargetOutput) {
	op := &request.Operation{
		Name:       opRegisterScalableTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterScalableTargetInput{}
	}

	output = &RegisterScalableTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterScalableTarget API operation for Application Auto Scaling.
//
// Registers or updates a scalable target, which is the resource that you want
// to scale.
//
// Scalable targets are uniquely identified by the combination of resource ID,
// scalable dimension, and namespace, which represents some capacity dimension
// of the underlying service.
//
// When you register a new scalable target, you must specify values for the
// minimum and maximum capacity. If the specified resource is not active in
// the target service, this operation does not change the resource's current
// capacity. Otherwise, it changes the resource's current capacity to a value
// that is inside of this range.
//
// If you add a scaling policy, current capacity is adjustable within the specified
// range when scaling starts. Application Auto Scaling scaling policies will
// not scale capacity to values that are outside of the minimum and maximum
// range.
//
// After you register a scalable target, you do not need to register it again
// to use other Application Auto Scaling operations. To see which resources
// have been registered, use DescribeScalableTargets (https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html).
// You can also view the scaling policies for a service namespace by using DescribeScalableTargets
// (https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html).
// If you no longer need a scalable target, you can deregister it by using DeregisterScalableTarget
// (https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeregisterScalableTarget.html).
//
// To update a scalable target, specify the parameters that you want to change.
// Include the parameters that identify the scalable target: resource ID, scalable
// dimension, and namespace. Any parameters that you don't specify are not changed
// by this update request.
//
// If you call the RegisterScalableTarget API operation to create a scalable
// target, there might be a brief delay until the operation achieves eventual
// consistency (https://en.wikipedia.org/wiki/Eventual_consistency). You might
// become aware of this brief delay if you get unexpected errors when performing
// sequential operations. The typical strategy is to retry the request, and
// some Amazon Web Services SDKs include automatic backoff and retry logic.
//
// If you call the RegisterScalableTarget API operation to update an existing
// scalable target, Application Auto Scaling retrieves the current capacity
// of the resource. If it's below the minimum capacity or above the maximum
// capacity, Application Auto Scaling adjusts the capacity of the scalable target
// to place it within these bounds, even if you don't include the MinCapacity
// or MaxCapacity request parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation RegisterScalableTarget for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An exception was thrown for a validation issue. Review the available parameters
//     for the API request.
//
//   - LimitExceededException
//     A per-account resource limit is exceeded. For more information, see Application
//     Auto Scaling service quotas (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-limits.html).
//
//   - ConcurrentUpdateException
//     Concurrent updates caused an exception, for example, if you request an update
//     to an Application Auto Scaling resource that already has a pending update.
//
//   - InternalServiceException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/RegisterScalableTarget
func (c *ApplicationAutoScaling) RegisterScalableTarget(input *RegisterScalableTargetInput) (*RegisterScalableTargetOutput, error) {
	req, out := c.RegisterScalableTargetRequest(input)
	return out, req.Send()
}

// RegisterScalableTargetWithContext is the same as RegisterScalableTarget with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterScalableTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) RegisterScalableTargetWithContext(ctx aws.Context, input *RegisterScalableTargetInput, opts ...request.Option) (*RegisterScalableTargetOutput, error) {
	req, out := c.RegisterScalableTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/TagResource
func (c *ApplicationAutoScaling) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Application Auto Scaling.
//
// Adds or edits tags on an Application Auto Scaling scalable target.
//
// Each tag consists of a tag key and a tag value, which are both case-sensitive
// strings. To add a tag, specify a new tag key and a tag value. To edit a tag,
// specify an existing tag key and a new tag value.
//
// You can use this operation to tag an Application Auto Scaling scalable target,
// but you cannot tag a scaling policy or scheduled action.
//
// You can also add tags to an Application Auto Scaling scalable target while
// creating it (RegisterScalableTarget).
//
// For general information about tags, including the format and syntax, see
// Tagging your Amazon Web Services resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// in the Amazon Web Services General Reference.
//
// Use tags to control access to a scalable target. For more information, see
// Tagging support for Application Auto Scaling (https://docs.aws.amazon.com/autoscaling/application/userguide/resource-tagging-support.html)
// in the Application Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - TooManyTagsException
//     The request contains too many tags. Try the request again with fewer tags.
//
//   - ValidationException
//     An exception was thrown for a validation issue. Review the available parameters
//     for the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/TagResource
func (c *ApplicationAutoScaling) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/UntagResource
func (c *ApplicationAutoScaling) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Application Auto Scaling.
//
// Deletes tags from an Application Auto Scaling scalable target. To delete
// a tag, specify the tag key and the Application Auto Scaling scalable target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ValidationException
//     An exception was thrown for a validation issue. Review the available parameters
//     for the API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/UntagResource
func (c *ApplicationAutoScaling) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationAutoScaling) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents a CloudWatch alarm associated with a scaling policy.
type Alarm struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alarm.
	//
	// AlarmARN is a required field
	AlarmARN *string `type:"string" required:"true"`

	// The name of the alarm.
	//
	// AlarmName is a required field
	AlarmName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alarm) GoString() string {
	return s.String()
}

// SetAlarmARN sets the AlarmARN field's value.
func (s *Alarm) SetAlarmARN(v string) *Alarm {
	s.AlarmARN = &v
	return s
}

// SetAlarmName sets the AlarmName field's value.
func (s *Alarm) SetAlarmName(v string) *Alarm {
	s.AlarmName = &v
	return s
}

// Concurrent updates caused an exception, for example, if you request an update
// to an Application Auto Scaling resource that already has a pending update.
type ConcurrentUpdateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentUpdateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentUpdateException) GoString() string {
	return s.String()
}

func newErrorConcurrentUpdateException(v protocol.ResponseMetadata) error {
	return &ConcurrentUpdateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentUpdateException) Code() string {
	return "ConcurrentUpdateException"
}

// Message returns the exception's message.
func (s *ConcurrentUpdateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentUpdateException) OrigErr() error {
	return nil
}

func (s *ConcurrentUpdateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentUpdateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentUpdateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a CloudWatch metric of your choosing for a target tracking scaling
// policy to use with Application Auto Scaling.
//
// For information about the available metrics for a service, see Amazon Web
// Services services that publish CloudWatch metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html)
// in the Amazon CloudWatch User Guide.
//
// To create your customized metric specification:
//
//   - Add values for each required parameter from CloudWatch. You can use
//     an existing metric, or a new metric that you create. To use your own metric,
//     you must first publish the metric to CloudWatch. For more information,
//     see Publish custom metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
//     in the Amazon CloudWatch User Guide.
//
//   - Choose a metric that changes proportionally with capacity. The value
//     of the metric should increase or decrease in inverse proportion to the
//     number of capacity units. That is, the value of the metric should decrease
//     when capacity increases, and increase when capacity decreases.
//
// For more information about the CloudWatch terminology below, see Amazon CloudWatch
// concepts (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html)
// in the Amazon CloudWatch User Guide.
type CustomizedMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The dimensions of the metric.
	//
	// Conditional: If you published your metric with dimensions, you must specify
	// the same dimensions in your scaling policy.
	Dimensions []*MetricDimension `type:"list"`

	// The name of the metric. To get the exact metric name, namespace, and dimensions,
	// inspect the Metric (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html)
	// object that's returned by a call to ListMetrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html).
	MetricName *string `type:"string"`

	// The metrics to include in the target tracking scaling policy, as a metric
	// data query. This can include both raw metric and metric math expressions.
	Metrics []*TargetTrackingMetricDataQuery `type:"list"`

	// The namespace of the metric.
	Namespace *string `type:"string"`

	// The statistic of the metric.
	Statistic *string `type:"string" enum:"MetricStatistic"`

	// The unit of the metric. For a complete list of the units that CloudWatch
	// supports, see the MetricDatum (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html)
	// data type in the Amazon CloudWatch API Reference.
	Unit *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomizedMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomizedMetricSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomizedMetricSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomizedMetricSpecification"}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Metrics != nil {
		for i, v := range s.Metrics {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Metrics", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *CustomizedMetricSpecification) SetDimensions(v []*MetricDimension) *CustomizedMetricSpecification {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CustomizedMetricSpecification) SetMetricName(v string) *CustomizedMetricSpecification {
	s.MetricName = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *CustomizedMetricSpecification) SetMetrics(v []*TargetTrackingMetricDataQuery) *CustomizedMetricSpecification {
	s.Metrics = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CustomizedMetricSpecification) SetNamespace(v string) *CustomizedMetricSpecification {
	s.Namespace = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *CustomizedMetricSpecification) SetStatistic(v string) *CustomizedMetricSpecification {
	s.Statistic = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *CustomizedMetricSpecification) SetUnit(v string) *CustomizedMetricSpecification {
	s.Unit = &v
	return s
}

type DeleteScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the scaling policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The identifier of the resource associated with the scalable target. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the Amazon Web Services service that provides the resource.
	// For a resource provided by your own application or service, use custom-resource
	// instead.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScalingPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeleteScalingPolicyInput) SetPolicyName(v string) *DeleteScalingPolicyInput {
	s.PolicyName = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteScalingPolicyInput) SetResourceId(v string) *DeleteScalingPolicyInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DeleteScalingPolicyInput) SetScalableDimension(v string) *DeleteScalingPolicyInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DeleteScalingPolicyInput) SetServiceNamespace(v string) *DeleteScalingPolicyInput {
	s.ServiceNamespace = &v
	return s
}

type DeleteScalingPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScalingPolicyOutput) GoString() string {
	return s.String()
}

type DeleteScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the resource associated with the scheduled action. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The name of the scheduled action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`

	// The namespace of the Amazon Web Services service that provides the resource.
	// For a resource provided by your own application or service, use custom-resource
	// instead.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduledActionInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledActionName", 1))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteScheduledActionInput) SetResourceId(v string) *DeleteScheduledActionInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DeleteScheduledActionInput) SetScalableDimension(v string) *DeleteScheduledActionInput {
	s.ScalableDimension = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *DeleteScheduledActionInput) SetScheduledActionName(v string) *DeleteScheduledActionInput {
	s.ScheduledActionName = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DeleteScheduledActionInput) SetServiceNamespace(v string) *DeleteScheduledActionInput {
	s.ServiceNamespace = &v
	return s
}

type DeleteScheduledActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledActionOutput) GoString() string {
	return s.String()
}

type DeregisterScalableTargetInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the resource associated with the scalable target. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension associated with the scalable target. This string consists
	// of the service namespace, resource type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the Amazon Web Services service that provides the resource.
	// For a resource provided by your own application or service, use custom-resource
	// instead.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterScalableTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterScalableTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterScalableTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterScalableTargetInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DeregisterScalableTargetInput) SetResourceId(v string) *DeregisterScalableTargetInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DeregisterScalableTargetInput) SetScalableDimension(v string) *DeregisterScalableTargetInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DeregisterScalableTargetInput) SetServiceNamespace(v string) *DeregisterScalableTargetInput {
	s.ServiceNamespace = &v
	return s
}

type DeregisterScalableTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterScalableTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterScalableTargetOutput) GoString() string {
	return s.String()
}

type DescribeScalableTargetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of scalable targets. This value can be between 1 and 50.
	// The default value is 50.
	//
	// If this parameter is used, the operation returns up to MaxResults results
	// at a time, along with a NextToken value. To get the next set of results,
	// include the NextToken value in a subsequent call. If this parameter is not
	// used, the operation returns up to 50 results and a NextToken value, if applicable.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The identifier of the resource associated with the scalable target. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	ResourceIds []*string `type:"list"`

	// The scalable dimension associated with the scalable target. This string consists
	// of the service namespace, resource type, and scaling property. If you specify
	// a scalable dimension, you must also specify a resource ID.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	ScalableDimension *string `type:"string" enum:"ScalableDimension"`

	// The namespace of the Amazon Web Services service that provides the resource.
	// For a resource provided by your own application or service, use custom-resource
	// instead.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalableTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalableTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalableTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalableTargetsInput"}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScalableTargetsInput) SetMaxResults(v int64) *DescribeScalableTargetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalableTargetsInput) SetNextToken(v string) *DescribeScalableTargetsInput {
	s.NextToken = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *DescribeScalableTargetsInput) SetResourceIds(v []*string) *DescribeScalableTargetsInput {
	s.ResourceIds = v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DescribeScalableTargetsInput) SetScalableDimension(v string) *DescribeScalableTargetsInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DescribeScalableTargetsInput) SetServiceNamespace(v string) *DescribeScalableTargetsInput {
	s.ServiceNamespace = &v
	return s
}

type DescribeScalableTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The token required to get the next set of results. This value is null if
	// there are no more results to return.
	NextToken *string `type:"string"`

	// The scalable targets that match the request parameters.
	ScalableTargets []*ScalableTarget `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalableTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalableTargetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalableTargetsOutput) SetNextToken(v string) *DescribeScalableTargetsOutput {
	s.NextToken = &v
	return s
}

// SetScalableTargets sets the ScalableTargets field's value.
func (s *DescribeScalableTargetsOutput) SetScalableTargets(v []*ScalableTarget) *DescribeScalableTargetsOutput {
	s.ScalableTargets = v
	return s
}

type DescribeScalingActivitiesInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to include activities that aren't scaled (not scaled activities)
	// in the response. Not scaled activities are activities that aren't completed
	// or started for various reasons, such as preventing infinite scaling loops.
	// For help interpreting the not scaled reason details in the response, see
	// Scaling activities for Application Auto Scaling (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scaling-activities.html).
	IncludeNotScaledActivities *bool `type:"boolean"`

	// The maximum number of scalable targets. This value can be between 1 and 50.
	// The default value is 50.
	//
	// If this parameter is used, the operation returns up to MaxResults results
	// at a time, along with a NextToken value. To get the next set of results,
	// include the NextToken value in a subsequent call. If this parameter is not
	// used, the operation returns up to 50 results and a NextToken value, if applicable.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The identifier of the resource associated with the scaling activity. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	ResourceId *string `min:"1" type:"string"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property. If you specify a scalable dimension, you must
	// also specify a resource ID.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	ScalableDimension *string `type:"string" enum:"ScalableDimension"`

	// The namespace of the Amazon Web Services service that provides the resource.
	// For a resource provided by your own application or service, use custom-resource
	// instead.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingActivitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingActivitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingActivitiesInput"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeNotScaledActivities sets the IncludeNotScaledActivities field's value.
func (s *DescribeScalingActivitiesInput) SetIncludeNotScaledActivities(v bool) *DescribeScalingActivitiesInput {
	s.IncludeNotScaledActivities = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScalingActivitiesInput) SetMaxResults(v int64) *DescribeScalingActivitiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingActivitiesInput) SetNextToken(v string) *DescribeScalingActivitiesInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeScalingActivitiesInput) SetResourceId(v string) *DescribeScalingActivitiesInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DescribeScalingActivitiesInput) SetScalableDimension(v string) *DescribeScalingActivitiesInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DescribeScalingActivitiesInput) SetServiceNamespace(v string) *DescribeScalingActivitiesInput {
	s.ServiceNamespace = &v
	return s
}

type DescribeScalingActivitiesOutput struct {
	_ struct{} `type:"structure"`

	// The token required to get the next set of results. This value is null if
	// there are no more results to return.
	NextToken *string `type:"string"`

	// A list of scaling activity objects.
	ScalingActivities []*ScalingActivity `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingActivitiesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingActivitiesOutput) SetNextToken(v string) *DescribeScalingActivitiesOutput {
	s.NextToken = &v
	return s
}

// SetScalingActivities sets the ScalingActivities field's value.
func (s *DescribeScalingActivitiesOutput) SetScalingActivities(v []*ScalingActivity) *DescribeScalingActivitiesOutput {
	s.ScalingActivities = v
	return s
}

type DescribeScalingPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of scalable targets. This value can be between 1 and 10.
	// The default value is 10.
	//
	// If this parameter is used, the operation returns up to MaxResults results
	// at a time, along with a NextToken value. To get the next set of results,
	// include the NextToken value in a subsequent call. If this parameter is not
	// used, the operation returns up to 10 results and a NextToken value, if applicable.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The names of the scaling policies to describe.
	PolicyNames []*string `type:"list"`

	// The identifier of the resource associated with the scaling policy. This string
	// consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	ResourceId *string `min:"1" type:"string"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property. If you specify a scalable dimension, you must
	// also specify a resource ID.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	ScalableDimension *string `type:"string" enum:"ScalableDimension"`

	// The namespace of the Amazon Web Services service that provides the resource.
	// For a resource provided by your own application or service, use custom-resource
	// instead.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingPoliciesInput"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScalingPoliciesInput) SetMaxResults(v int64) *DescribeScalingPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPoliciesInput) SetNextToken(v string) *DescribeScalingPoliciesInput {
	s.NextToken = &v
	return s
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *DescribeScalingPoliciesInput) SetPolicyNames(v []*string) *DescribeScalingPoliciesInput {
	s.PolicyNames = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeScalingPoliciesInput) SetResourceId(v string) *DescribeScalingPoliciesInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DescribeScalingPoliciesInput) SetScalableDimension(v string) *DescribeScalingPoliciesInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DescribeScalingPoliciesInput) SetServiceNamespace(v string) *DescribeScalingPoliciesInput {
	s.ServiceNamespace = &v
	return s
}

type DescribeScalingPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The token required to get the next set of results. This value is null if
	// there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the scaling policies.
	ScalingPolicies []*ScalingPolicy `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPoliciesOutput) SetNextToken(v string) *DescribeScalingPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetScalingPolicies sets the ScalingPolicies field's value.
func (s *DescribeScalingPoliciesOutput) SetScalingPolicies(v []*ScalingPolicy) *DescribeScalingPoliciesOutput {
	s.ScalingPolicies = v
	return s
}

type DescribeScheduledActionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of scheduled action results. This value can be between
	// 1 and 50. The default value is 50.
	//
	// If this parameter is used, the operation returns up to MaxResults results
	// at a time, along with a NextToken value. To get the next set of results,
	// include the NextToken value in a subsequent call. If this parameter is not
	// used, the operation returns up to 50 results and a NextToken value, if applicable.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The identifier of the resource associated with the scheduled action. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	ResourceId *string `min:"1" type:"string"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property. If you specify a scalable dimension, you must
	// also specify a resource ID.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	ScalableDimension *string `type:"string" enum:"ScalableDimension"`

	// The names of the scheduled actions to describe.
	ScheduledActionNames []*string `type:"list"`

	// The namespace of the Amazon Web Services service that provides the resource.
	// For a resource provided by your own application or service, use custom-resource
	// instead.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduledActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduledActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScheduledActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScheduledActionsInput"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScheduledActionsInput) SetMaxResults(v int64) *DescribeScheduledActionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScheduledActionsInput) SetNextToken(v string) *DescribeScheduledActionsInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeScheduledActionsInput) SetResourceId(v string) *DescribeScheduledActionsInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *DescribeScheduledActionsInput) SetScalableDimension(v string) *DescribeScheduledActionsInput {
	s.ScalableDimension = &v
	return s
}

// SetScheduledActionNames sets the ScheduledActionNames field's value.
func (s *DescribeScheduledActionsInput) SetScheduledActionNames(v []*string) *DescribeScheduledActionsInput {
	s.ScheduledActionNames = v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *DescribeScheduledActionsInput) SetServiceNamespace(v string) *DescribeScheduledActionsInput {
	s.ServiceNamespace = &v
	return s
}

type DescribeScheduledActionsOutput struct {
	_ struct{} `type:"structure"`

	// The token required to get the next set of results. This value is null if
	// there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the scheduled actions.
	ScheduledActions []*ScheduledAction `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduledActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduledActionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScheduledActionsOutput) SetNextToken(v string) *DescribeScheduledActionsOutput {
	s.NextToken = &v
	return s
}

// SetScheduledActions sets the ScheduledActions field's value.
func (s *DescribeScheduledActionsOutput) SetScheduledActions(v []*ScheduledAction) *DescribeScheduledActionsOutput {
	s.ScheduledActions = v
	return s
}

// Failed access to resources caused an exception. This exception is thrown
// when Application Auto Scaling is unable to retrieve the alarms associated
// with a scaling policy due to a client error, for example, if the role ARN
// specified for a scalable target does not have permission to call the CloudWatch
// DescribeAlarms (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)
// on your behalf.
type FailedResourceAccessException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedResourceAccessException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedResourceAccessException) GoString() string {
	return s.String()
}

func newErrorFailedResourceAccessException(v protocol.ResponseMetadata) error {
	return &FailedResourceAccessException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *FailedResourceAccessException) Code() string {
	return "FailedResourceAccessException"
}

// Message returns the exception's message.
func (s *FailedResourceAccessException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *FailedResourceAccessException) OrigErr() error {
	return nil
}

func (s *FailedResourceAccessException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *FailedResourceAccessException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *FailedResourceAccessException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service encountered an internal error.
type InternalServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) GoString() string {
	return s.String()
}

func newErrorInternalServiceException(v protocol.ResponseMetadata) error {
	return &InternalServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceException) Code() string {
	return "InternalServiceException"
}

// Message returns the exception's message.
func (s *InternalServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceException) OrigErr() error {
	return nil
}

func (s *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The next token supplied was invalid.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A per-account resource limit is exceeded. For more information, see Application
// Auto Scaling service quotas (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-limits.html).
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Specify the ARN of the scalable target.
	//
	// For example: arn:aws:application-autoscaling:us-east-1:123456789012:scalable-target/1234abcd56ab78cd901ef1234567890ab123
	//
	// To get the ARN for a scalable target, use DescribeScalableTargets.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags. Each tag consists of a tag key and a tag value.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Describes the dimension names and values associated with a metric.
type MetricDimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the dimension.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *MetricDimension) SetName(v string) *MetricDimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDimension) SetValue(v string) *MetricDimension {
	s.Value = &v
	return s
}

// Describes the reason for an activity that isn't scaled (not scaled activity),
// in machine-readable format. For help interpreting the not scaled reason details,
// see Scaling activities for Application Auto Scaling (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scaling-activities.html)
// in the Application Auto Scaling User Guide.
type NotScaledReason struct {
	_ struct{} `type:"structure"`

	// A code that represents the reason for not scaling.
	//
	// Valid values:
	//
	//    * AutoScalingAnticipatedFlapping
	//
	//    * TargetServicePutResourceAsUnscalable
	//
	//    * AlreadyAtMaxCapacity
	//
	//    * AlreadyAtMinCapacity
	//
	//    * AlreadyAtDesiredCapacity
	//
	// Code is a required field
	Code *string `type:"string" required:"true"`

	// The current capacity.
	CurrentCapacity *int64 `type:"integer"`

	// The maximum capacity.
	MaxCapacity *int64 `type:"integer"`

	// The minimum capacity.
	MinCapacity *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotScaledReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotScaledReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *NotScaledReason) SetCode(v string) *NotScaledReason {
	s.Code = &v
	return s
}

// SetCurrentCapacity sets the CurrentCapacity field's value.
func (s *NotScaledReason) SetCurrentCapacity(v int64) *NotScaledReason {
	s.CurrentCapacity = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *NotScaledReason) SetMaxCapacity(v int64) *NotScaledReason {
	s.MaxCapacity = &v
	return s
}

// SetMinCapacity sets the MinCapacity field's value.
func (s *NotScaledReason) SetMinCapacity(v int64) *NotScaledReason {
	s.MinCapacity = &v
	return s
}

// The specified object could not be found. For any operation that depends on
// the existence of a scalable target, this exception is thrown if the scalable
// target with the specified service namespace, resource ID, and scalable dimension
// does not exist. For any operation that deletes or deregisters a resource,
// this exception is thrown if the resource cannot be found.
type ObjectNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectNotFoundException) GoString() string {
	return s.String()
}

func newErrorObjectNotFoundException(v protocol.ResponseMetadata) error {
	return &ObjectNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ObjectNotFoundException) Code() string {
	return "ObjectNotFoundException"
}

// Message returns the exception's message.
func (s *ObjectNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ObjectNotFoundException) OrigErr() error {
	return nil
}

func (s *ObjectNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ObjectNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ObjectNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a predefined metric for a target tracking scaling policy to use
// with Application Auto Scaling.
//
// For more information, Predefined metrics for target tracking scaling policies
// (https://docs.aws.amazon.com/autoscaling/application/userguide/monitor-cloudwatch-metrics.html#predefined-metrics)
// in the Application Auto Scaling User Guide.
type PredefinedMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The metric type. The ALBRequestCountPerTarget metric type applies only to
	// Spot Fleets and ECS services.
	//
	// PredefinedMetricType is a required field
	PredefinedMetricType *string `type:"string" required:"true" enum:"MetricType"`

	// Identifies the resource associated with the metric type. You can't specify
	// a resource label unless the metric type is ALBRequestCountPerTarget and there
	// is a target group attached to the Spot Fleet or ECS service.
	//
	// You create the resource label by appending the final portion of the load
	// balancer ARN and the final portion of the target group ARN into a single
	// value, separated by a forward slash (/). The format of the resource label
	// is:
	//
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff.
	//
	// Where:
	//
	//    * app/<load-balancer-name>/<load-balancer-id> is the final portion of
	//    the load balancer ARN
	//
	//    * targetgroup/<target-group-name>/<target-group-id> is the final portion
	//    of the target group ARN.
	//
	// To find the ARN for an Application Load Balancer, use the DescribeLoadBalancers
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	// API operation. To find the ARN for the target group, use the DescribeTargetGroups
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)
	// API operation.
	ResourceLabel *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredefinedMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredefinedMetricSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredefinedMetricSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredefinedMetricSpecification"}
	if s.PredefinedMetricType == nil {
		invalidParams.Add(request.NewErrParamRequired("PredefinedMetricType"))
	}
	if s.ResourceLabel != nil && len(*s.ResourceLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPredefinedMetricType sets the PredefinedMetricType field's value.
func (s *PredefinedMetricSpecification) SetPredefinedMetricType(v string) *PredefinedMetricSpecification {
	s.PredefinedMetricType = &v
	return s
}

// SetResourceLabel sets the ResourceLabel field's value.
func (s *PredefinedMetricSpecification) SetResourceLabel(v string) *PredefinedMetricSpecification {
	s.ResourceLabel = &v
	return s
}

type PutScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the scaling policy.
	//
	// You cannot change the name of a scaling policy, but you can delete the original
	// scaling policy and create a new scaling policy with the same settings and
	// a different name.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The scaling policy type. This parameter is required if you are creating a
	// scaling policy.
	//
	// The following policy types are supported:
	//
	// TargetTrackingScaling—Not supported for Amazon EMR.
	//
	// StepScaling—Not supported for DynamoDB, Amazon Comprehend, Lambda, Amazon
	// Keyspaces, Amazon MSK, Amazon ElastiCache, or Neptune.
	//
	// For more information, see Target tracking scaling policies (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html)
	// and Step scaling policies (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html)
	// in the Application Auto Scaling User Guide.
	PolicyType *string `type:"string" enum:"PolicyType"`

	// The identifier of the resource associated with the scaling policy. This string
	// consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the Amazon Web Services service that provides the resource.
	// For a resource provided by your own application or service, use custom-resource
	// instead.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// A step scaling policy.
	//
	// This parameter is required if you are creating a policy and the policy type
	// is StepScaling.
	StepScalingPolicyConfiguration *StepScalingPolicyConfiguration `type:"structure"`

	// A target tracking scaling policy. Includes support for predefined or customized
	// metrics.
	//
	// This parameter is required if you are creating a policy and the policy type
	// is TargetTrackingScaling.
	TargetTrackingScalingPolicyConfiguration *TargetTrackingScalingPolicyConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutScalingPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}
	if s.StepScalingPolicyConfiguration != nil {
		if err := s.StepScalingPolicyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StepScalingPolicyConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.TargetTrackingScalingPolicyConfiguration != nil {
		if err := s.TargetTrackingScalingPolicyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TargetTrackingScalingPolicyConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *PutScalingPolicyInput) SetPolicyName(v string) *PutScalingPolicyInput {
	s.PolicyName = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *PutScalingPolicyInput) SetPolicyType(v string) *PutScalingPolicyInput {
	s.PolicyType = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *PutScalingPolicyInput) SetResourceId(v string) *PutScalingPolicyInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *PutScalingPolicyInput) SetScalableDimension(v string) *PutScalingPolicyInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *PutScalingPolicyInput) SetServiceNamespace(v string) *PutScalingPolicyInput {
	s.ServiceNamespace = &v
	return s
}

// SetStepScalingPolicyConfiguration sets the StepScalingPolicyConfiguration field's value.
func (s *PutScalingPolicyInput) SetStepScalingPolicyConfiguration(v *StepScalingPolicyConfiguration) *PutScalingPolicyInput {
	s.StepScalingPolicyConfiguration = v
	return s
}

// SetTargetTrackingScalingPolicyConfiguration sets the TargetTrackingScalingPolicyConfiguration field's value.
func (s *PutScalingPolicyInput) SetTargetTrackingScalingPolicyConfiguration(v *TargetTrackingScalingPolicyConfiguration) *PutScalingPolicyInput {
	s.TargetTrackingScalingPolicyConfiguration = v
	return s
}

type PutScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The CloudWatch alarms created for the target tracking scaling policy.
	Alarms []*Alarm `type:"list"`

	// The Amazon Resource Name (ARN) of the resulting scaling policy.
	//
	// PolicyARN is a required field
	PolicyARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScalingPolicyOutput) GoString() string {
	return s.String()
}

// SetAlarms sets the Alarms field's value.
func (s *PutScalingPolicyOutput) SetAlarms(v []*Alarm) *PutScalingPolicyOutput {
	s.Alarms = v
	return s
}

// SetPolicyARN sets the PolicyARN field's value.
func (s *PutScalingPolicyOutput) SetPolicyARN(v string) *PutScalingPolicyOutput {
	s.PolicyARN = &v
	return s
}

type PutScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// The date and time for the recurring schedule to end, in UTC.
	EndTime *time.Time `type:"timestamp"`

	// The identifier of the resource associated with the scheduled action. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The new minimum and maximum capacity. You can set both values or just one.
	// At the scheduled time, if the current capacity is below the minimum capacity,
	// Application Auto Scaling scales out to the minimum capacity. If the current
	// capacity is above the maximum capacity, Application Auto Scaling scales in
	// to the maximum capacity.
	ScalableTargetAction *ScalableTargetAction `type:"structure"`

	// The schedule for this action. The following formats are supported:
	//
	//    * At expressions - "at(yyyy-mm-ddThh:mm:ss)"
	//
	//    * Rate expressions - "rate(value unit)"
	//
	//    * Cron expressions - "cron(fields)"
	//
	// At expressions are useful for one-time schedules. Cron expressions are useful
	// for scheduled actions that run periodically at a specified date and time,
	// and rate expressions are useful for scheduled actions that run at a regular
	// interval.
	//
	// At and cron expressions use Universal Coordinated Time (UTC) by default.
	//
	// The cron format consists of six fields separated by white spaces: [Minutes]
	// [Hours] [Day_of_Month] [Month] [Day_of_Week] [Year].
	//
	// For rate expressions, value is a positive integer and unit is minute | minutes
	// | hour | hours | day | days.
	//
	// For more information, see Schedule recurring scaling actions using cron expressions
	// (https://docs.aws.amazon.com/autoscaling/application/userguide/scheduled-scaling-using-cron-expressions.html)
	// in the Application Auto Scaling User Guide.
	Schedule *string `min:"1" type:"string"`

	// The name of the scheduled action. This name must be unique among all other
	// scheduled actions on the specified scalable target.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`

	// The namespace of the Amazon Web Services service that provides the resource.
	// For a resource provided by your own application or service, use custom-resource
	// instead.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// The date and time for this scheduled action to start, in UTC.
	StartTime *time.Time `type:"timestamp"`

	// Specifies the time zone used when setting a scheduled action by using an
	// at or cron expression. If a time zone is not provided, UTC is used by default.
	//
	// Valid values are the canonical names of the IANA time zones supported by
	// Joda-Time (such as Etc/GMT+9 or Pacific/Tahiti). For more information, see
	// https://www.joda.org/joda-time/timezones.html (https://www.joda.org/joda-time/timezones.html).
	Timezone *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutScheduledActionInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.Schedule != nil && len(*s.Schedule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Schedule", 1))
	}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledActionName", 1))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}
	if s.Timezone != nil && len(*s.Timezone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Timezone", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *PutScheduledActionInput) SetEndTime(v time.Time) *PutScheduledActionInput {
	s.EndTime = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *PutScheduledActionInput) SetResourceId(v string) *PutScheduledActionInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *PutScheduledActionInput) SetScalableDimension(v string) *PutScheduledActionInput {
	s.ScalableDimension = &v
	return s
}

// SetScalableTargetAction sets the ScalableTargetAction field's value.
func (s *PutScheduledActionInput) SetScalableTargetAction(v *ScalableTargetAction) *PutScheduledActionInput {
	s.ScalableTargetAction = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *PutScheduledActionInput) SetSchedule(v string) *PutScheduledActionInput {
	s.Schedule = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *PutScheduledActionInput) SetScheduledActionName(v string) *PutScheduledActionInput {
	s.ScheduledActionName = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *PutScheduledActionInput) SetServiceNamespace(v string) *PutScheduledActionInput {
	s.ServiceNamespace = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *PutScheduledActionInput) SetStartTime(v time.Time) *PutScheduledActionInput {
	s.StartTime = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *PutScheduledActionInput) SetTimezone(v string) *PutScheduledActionInput {
	s.Timezone = &v
	return s
}

type PutScheduledActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScheduledActionOutput) GoString() string {
	return s.String()
}

type RegisterScalableTargetInput struct {
	_ struct{} `type:"structure"`

	// The maximum value that you plan to scale out to. When a scaling policy is
	// in effect, Application Auto Scaling can scale out (expand) as needed to the
	// maximum capacity limit in response to changing demand. This property is required
	// when registering a new scalable target.
	//
	// Although you can specify a large maximum capacity, note that service quotas
	// might impose lower limits. Each service has its own default quotas for the
	// maximum capacity of the resource. If you want to specify a higher limit,
	// you can request an increase. For more information, consult the documentation
	// for that service. For information about the default quotas for each service,
	// see Service endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html)
	// in the Amazon Web Services General Reference.
	MaxCapacity *int64 `type:"integer"`

	// The minimum value that you plan to scale in to. When a scaling policy is
	// in effect, Application Auto Scaling can scale in (contract) as needed to
	// the minimum capacity limit in response to changing demand. This property
	// is required when registering a new scalable target.
	//
	// For the following resources, the minimum value allowed is 0.
	//
	//    * AppStream 2.0 fleets
	//
	//    * Aurora DB clusters
	//
	//    * ECS services
	//
	//    * EMR clusters
	//
	//    * Lambda provisioned concurrency
	//
	//    * SageMaker endpoint variants
	//
	//    * SageMaker inference components
	//
	//    * SageMaker serverless endpoint provisioned concurrency
	//
	//    * Spot Fleets
	//
	//    * custom resources
	//
	// It's strongly recommended that you specify a value greater than 0. A value
	// greater than 0 means that data points are continuously reported to CloudWatch
	// that scaling policies can use to scale on a metric like average CPU utilization.
	//
	// For all other resources, the minimum allowed value depends on the type of
	// resource that you are using. If you provide a value that is lower than what
	// a resource can accept, an error occurs. In which case, the error message
	// will provide the minimum value that the resource can accept.
	MinCapacity *int64 `type:"integer"`

	// The identifier of the resource that is associated with the scalable target.
	// This string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// This parameter is required for services that do not support service-linked
	// roles (such as Amazon EMR), and it must specify the ARN of an IAM role that
	// allows Application Auto Scaling to modify the scalable target on your behalf.
	//
	// If the service supports service-linked roles, Application Auto Scaling uses
	// a service-linked role, which it creates if it does not yet exist. For more
	// information, see How Application Auto Scaling works with IAM (https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html).
	RoleARN *string `min:"1" type:"string"`

	// The scalable dimension associated with the scalable target. This string consists
	// of the service namespace, resource type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the Amazon Web Services service that provides the resource.
	// For a resource provided by your own application or service, use custom-resource
	// instead.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// An embedded object that contains attributes and attribute values that are
	// used to suspend and resume automatic scaling. Setting the value of an attribute
	// to true suspends the specified scaling activities. Setting it to false (default)
	// resumes the specified scaling activities.
	//
	// Suspension Outcomes
	//
	//    * For DynamicScalingInSuspended, while a suspension is in effect, all
	//    scale-in activities that are triggered by a scaling policy are suspended.
	//
	//    * For DynamicScalingOutSuspended, while a suspension is in effect, all
	//    scale-out activities that are triggered by a scaling policy are suspended.
	//
	//    * For ScheduledScalingSuspended, while a suspension is in effect, all
	//    scaling activities that involve scheduled actions are suspended.
	//
	// For more information, see Suspend and resume scaling (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html)
	// in the Application Auto Scaling User Guide.
	SuspendedState *SuspendedState `type:"structure"`

	// Assigns one or more tags to the scalable target. Use this parameter to tag
	// the scalable target when it is created. To tag an existing scalable target,
	// use the TagResource operation.
	//
	// Each tag consists of a tag key and a tag value. Both the tag key and the
	// tag value are required. You cannot have more than one tag on a scalable target
	// with the same tag key.
	//
	// Use tags to control access to a scalable target. For more information, see
	// Tagging support for Application Auto Scaling (https://docs.aws.amazon.com/autoscaling/application/userguide/resource-tagging-support.html)
	// in the Application Auto Scaling User Guide.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterScalableTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterScalableTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterScalableTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterScalableTargetInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *RegisterScalableTargetInput) SetMaxCapacity(v int64) *RegisterScalableTargetInput {
	s.MaxCapacity = &v
	return s
}

// SetMinCapacity sets the MinCapacity field's value.
func (s *RegisterScalableTargetInput) SetMinCapacity(v int64) *RegisterScalableTargetInput {
	s.MinCapacity = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *RegisterScalableTargetInput) SetResourceId(v string) *RegisterScalableTargetInput {
	s.ResourceId = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *RegisterScalableTargetInput) SetRoleARN(v string) *RegisterScalableTargetInput {
	s.RoleARN = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *RegisterScalableTargetInput) SetScalableDimension(v string) *RegisterScalableTargetInput {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *RegisterScalableTargetInput) SetServiceNamespace(v string) *RegisterScalableTargetInput {
	s.ServiceNamespace = &v
	return s
}

// SetSuspendedState sets the SuspendedState field's value.
func (s *RegisterScalableTargetInput) SetSuspendedState(v *SuspendedState) *RegisterScalableTargetInput {
	s.SuspendedState = v
	return s
}

// SetTags sets the Tags field's value.
func (s *RegisterScalableTargetInput) SetTags(v map[string]*string) *RegisterScalableTargetInput {
	s.Tags = v
	return s
}

type RegisterScalableTargetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the scalable target.
	ScalableTargetARN *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterScalableTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterScalableTargetOutput) GoString() string {
	return s.String()
}

// SetScalableTargetARN sets the ScalableTargetARN field's value.
func (s *RegisterScalableTargetOutput) SetScalableTargetARN(v string) *RegisterScalableTargetOutput {
	s.ScalableTargetARN = &v
	return s
}

// The specified resource doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The name of the Application Auto Scaling resource. This value is an Amazon
	// Resource Name (ARN).
	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a scalable target.
type ScalableTarget struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp for when the scalable target was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The maximum value to scale to in response to a scale-out activity.
	//
	// MaxCapacity is a required field
	MaxCapacity *int64 `type:"integer" required:"true"`

	// The minimum value to scale to in response to a scale-in activity.
	//
	// MinCapacity is a required field
	MinCapacity *int64 `type:"integer" required:"true"`

	// The identifier of the resource associated with the scalable target. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The ARN of an IAM role that allows Application Auto Scaling to modify the
	// scalable target on your behalf.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The scalable dimension associated with the scalable target. This string consists
	// of the service namespace, resource type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The ARN of the scalable target.
	ScalableTargetARN *string `type:"string"`

	// The namespace of the Amazon Web Services service that provides the resource,
	// or a custom-resource.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// Specifies whether the scaling activities for a scalable target are in a suspended
	// state.
	SuspendedState *SuspendedState `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScalableTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScalableTarget) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ScalableTarget) SetCreationTime(v time.Time) *ScalableTarget {
	s.CreationTime = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *ScalableTarget) SetMaxCapacity(v int64) *ScalableTarget {
	s.MaxCapacity = &v
	return s
}

// SetMinCapacity sets the MinCapacity field's value.
func (s *ScalableTarget) SetMinCapacity(v int64) *ScalableTarget {
	s.MinCapacity = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ScalableTarget) SetResourceId(v string) *ScalableTarget {
	s.ResourceId = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ScalableTarget) SetRoleARN(v string) *ScalableTarget {
	s.RoleARN = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *ScalableTarget) SetScalableDimension(v string) *ScalableTarget {
	s.ScalableDimension = &v
	return s
}

// SetScalableTargetARN sets the ScalableTargetARN field's value.
func (s *ScalableTarget) SetScalableTargetARN(v string) *ScalableTarget {
	s.ScalableTargetARN = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *ScalableTarget) SetServiceNamespace(v string) *ScalableTarget {
	s.ServiceNamespace = &v
	return s
}

// SetSuspendedState sets the SuspendedState field's value.
func (s *ScalableTarget) SetSuspendedState(v *SuspendedState) *ScalableTarget {
	s.SuspendedState = v
	return s
}

// Represents the minimum and maximum capacity for a scheduled action.
type ScalableTargetAction struct {
	_ struct{} `type:"structure"`

	// The maximum capacity.
	//
	// Although you can specify a large maximum capacity, note that service quotas
	// may impose lower limits. Each service has its own default quotas for the
	// maximum capacity of the resource. If you want to specify a higher limit,
	// you can request an increase. For more information, consult the documentation
	// for that service. For information about the default quotas for each service,
	// see Service endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html)
	// in the Amazon Web Services General Reference.
	MaxCapacity *int64 `type:"integer"`

	// The minimum capacity.
	//
	// When the scheduled action runs, the resource will have at least this much
	// capacity, but it might have more depending on other settings, such as the
	// target utilization level of a target tracking scaling policy.
	MinCapacity *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScalableTargetAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScalableTargetAction) GoString() string {
	return s.String()
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *ScalableTargetAction) SetMaxCapacity(v int64) *ScalableTargetAction {
	s.MaxCapacity = &v
	return s
}

// SetMinCapacity sets the MinCapacity field's value.
func (s *ScalableTargetAction) SetMinCapacity(v int64) *ScalableTargetAction {
	s.MinCapacity = &v
	return s
}

// Represents a scaling activity.
type ScalingActivity struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the scaling activity.
	//
	// ActivityId is a required field
	ActivityId *string `type:"string" required:"true"`

	// A simple description of what caused the scaling activity to happen.
	//
	// Cause is a required field
	Cause *string `type:"string" required:"true"`

	// A simple description of what action the scaling activity intends to accomplish.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The details about the scaling activity.
	Details *string `type:"string"`

	// The Unix timestamp for when the scaling activity ended.
	EndTime *time.Time `type:"timestamp"`

	// Machine-readable data that describes the reason for a not scaled activity.
	// Only available when DescribeScalingActivities (https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalingActivities.html)
	// includes not scaled activities.
	NotScaledReasons []*NotScaledReason `type:"list"`

	// The identifier of the resource associated with the scaling activity. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the Amazon Web Services service that provides the resource,
	// or a custom-resource.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// The Unix timestamp for when the scaling activity began.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`

	// Indicates the status of the scaling activity.
	//
	// StatusCode is a required field
	StatusCode *string `type:"string" required:"true" enum:"ScalingActivityStatusCode"`

	// A simple message about the current status of the scaling activity.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScalingActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScalingActivity) GoString() string {
	return s.String()
}

// SetActivityId sets the ActivityId field's value.
func (s *ScalingActivity) SetActivityId(v string) *ScalingActivity {
	s.ActivityId = &v
	return s
}

// SetCause sets the Cause field's value.
func (s *ScalingActivity) SetCause(v string) *ScalingActivity {
	s.Cause = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ScalingActivity) SetDescription(v string) *ScalingActivity {
	s.Description = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *ScalingActivity) SetDetails(v string) *ScalingActivity {
	s.Details = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ScalingActivity) SetEndTime(v time.Time) *ScalingActivity {
	s.EndTime = &v
	return s
}

// SetNotScaledReasons sets the NotScaledReasons field's value.
func (s *ScalingActivity) SetNotScaledReasons(v []*NotScaledReason) *ScalingActivity {
	s.NotScaledReasons = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ScalingActivity) SetResourceId(v string) *ScalingActivity {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *ScalingActivity) SetScalableDimension(v string) *ScalingActivity {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *ScalingActivity) SetServiceNamespace(v string) *ScalingActivity {
	s.ServiceNamespace = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ScalingActivity) SetStartTime(v time.Time) *ScalingActivity {
	s.StartTime = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ScalingActivity) SetStatusCode(v string) *ScalingActivity {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ScalingActivity) SetStatusMessage(v string) *ScalingActivity {
	s.StatusMessage = &v
	return s
}

// Represents a scaling policy to use with Application Auto Scaling.
//
// For more information about configuring scaling policies for a specific service,
// see Amazon Web Services services that you can use with Application Auto Scaling
// (https://docs.aws.amazon.com/autoscaling/application/userguide/integrated-services-list.html)
// in the Application Auto Scaling User Guide.
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// The CloudWatch alarms associated with the scaling policy.
	Alarms []*Alarm `type:"list"`

	// The Unix timestamp for when the scaling policy was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the scaling policy.
	//
	// PolicyARN is a required field
	PolicyARN *string `min:"1" type:"string" required:"true"`

	// The name of the scaling policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The scaling policy type.
	//
	// The following policy types are supported:
	//
	// TargetTrackingScaling—Not supported for Amazon EMR
	//
	// StepScaling—Not supported for DynamoDB, Amazon Comprehend, Lambda, Amazon
	// Keyspaces, Amazon MSK, Amazon ElastiCache, or Neptune.
	//
	// PolicyType is a required field
	PolicyType *string `type:"string" required:"true" enum:"PolicyType"`

	// The identifier of the resource associated with the scaling policy. This string
	// consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the Amazon Web Services service that provides the resource,
	// or a custom-resource.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// A step scaling policy.
	StepScalingPolicyConfiguration *StepScalingPolicyConfiguration `type:"structure"`

	// A target tracking scaling policy.
	TargetTrackingScalingPolicyConfiguration *TargetTrackingScalingPolicyConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScalingPolicy) GoString() string {
	return s.String()
}

// SetAlarms sets the Alarms field's value.
func (s *ScalingPolicy) SetAlarms(v []*Alarm) *ScalingPolicy {
	s.Alarms = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ScalingPolicy) SetCreationTime(v time.Time) *ScalingPolicy {
	s.CreationTime = &v
	return s
}

// SetPolicyARN sets the PolicyARN field's value.
func (s *ScalingPolicy) SetPolicyARN(v string) *ScalingPolicy {
	s.PolicyARN = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *ScalingPolicy) SetPolicyName(v string) *ScalingPolicy {
	s.PolicyName = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *ScalingPolicy) SetPolicyType(v string) *ScalingPolicy {
	s.PolicyType = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ScalingPolicy) SetResourceId(v string) *ScalingPolicy {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *ScalingPolicy) SetScalableDimension(v string) *ScalingPolicy {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *ScalingPolicy) SetServiceNamespace(v string) *ScalingPolicy {
	s.ServiceNamespace = &v
	return s
}

// SetStepScalingPolicyConfiguration sets the StepScalingPolicyConfiguration field's value.
func (s *ScalingPolicy) SetStepScalingPolicyConfiguration(v *StepScalingPolicyConfiguration) *ScalingPolicy {
	s.StepScalingPolicyConfiguration = v
	return s
}

// SetTargetTrackingScalingPolicyConfiguration sets the TargetTrackingScalingPolicyConfiguration field's value.
func (s *ScalingPolicy) SetTargetTrackingScalingPolicyConfiguration(v *TargetTrackingScalingPolicyConfiguration) *ScalingPolicy {
	s.TargetTrackingScalingPolicyConfiguration = v
	return s
}

// Represents a scheduled action.
type ScheduledAction struct {
	_ struct{} `type:"structure"`

	// The date and time that the scheduled action was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The date and time that the action is scheduled to end, in UTC.
	EndTime *time.Time `type:"timestamp"`

	// The identifier of the resource associated with the scaling policy. This string
	// consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/my-cluster/my-service.
	//
	//    * Spot Fleet - The resource type is spot-fleet-request and the unique
	//    identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * SageMaker endpoint variant - The resource type is variant and the unique
	//    identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Amazon Comprehend entity recognizer endpoint - The resource type and
	//    unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	//    * Amazon Keyspaces table - The resource type is table and the unique identifier
	//    is the table name. Example: keyspace/mykeyspace/table/mytable.
	//
	//    * Amazon MSK cluster - The resource type and unique identifier are specified
	//    using the cluster ARN. Example: arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5.
	//
	//    * Amazon ElastiCache replication group - The resource type is replication-group
	//    and the unique identifier is the replication group name. Example: replication-group/mycluster.
	//
	//    * Neptune cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:mycluster.
	//
	//    * SageMaker serverless endpoint - The resource type is variant and the
	//    unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * SageMaker inference component - The resource type is inference-component
	//    and the unique identifier is the resource ID. Example: inference-component/my-inference-component.
	//
	//    * Pool of WorkSpaces - The resource type is workspacespool and the unique
	//    identifier is the pool ID. Example: workspacespool/wspool-123456.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The task count of an ECS service.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet.
	//
	//    * appstream:fleet:DesiredCapacity - The capacity of an AppStream 2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for a SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * comprehend:entity-recognizer-endpoint:DesiredInferenceUnits - The number
	//    of inference units for an Amazon Comprehend entity recognizer endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	//    * cassandra:table:ReadCapacityUnits - The provisioned read capacity for
	//    an Amazon Keyspaces table.
	//
	//    * cassandra:table:WriteCapacityUnits - The provisioned write capacity
	//    for an Amazon Keyspaces table.
	//
	//    * kafka:broker-storage:VolumeSize - The provisioned volume size (in GiB)
	//    for brokers in an Amazon MSK cluster.
	//
	//    * elasticache:replication-group:NodeGroups - The number of node groups
	//    for an Amazon ElastiCache replication group.
	//
	//    * elasticache:replication-group:Replicas - The number of replicas per
	//    node group for an Amazon ElastiCache replication group.
	//
	//    * neptune:cluster:ReadReplicaCount - The count of read replicas in an
	//    Amazon Neptune DB cluster.
	//
	//    * sagemaker:variant:DesiredProvisionedConcurrency - The provisioned concurrency
	//    for a SageMaker serverless endpoint.
	//
	//    * sagemaker:inference-component:DesiredCopyCount - The number of copies
	//    across an endpoint for a SageMaker inference component.
	//
	//    * workspaces:workspacespool:DesiredUserSessions - The number of user sessions
	//    for the WorkSpaces in the pool.
	ScalableDimension *string `type:"string" enum:"ScalableDimension"`

	// The new minimum and maximum capacity. You can set both values or just one.
	// At the scheduled time, if the current capacity is below the minimum capacity,
	// Application Auto Scaling scales out to the minimum capacity. If the current
	// capacity is above the maximum capacity, Application Auto Scaling scales in
	// to the maximum capacity.
	ScalableTargetAction *ScalableTargetAction `type:"structure"`

	// The schedule for this action. The following formats are supported:
	//
	//    * At expressions - "at(yyyy-mm-ddThh:mm:ss)"
	//
	//    * Rate expressions - "rate(value unit)"
	//
	//    * Cron expressions - "cron(fields)"
	//
	// At expressions are useful for one-time schedules. Cron expressions are useful
	// for scheduled actions that run periodically at a specified date and time,
	// and rate expressions are useful for scheduled actions that run at a regular
	// interval.
	//
	// At and cron expressions use Universal Coordinated Time (UTC) by default.
	//
	// The cron format consists of six fields separated by white spaces: [Minutes]
	// [Hours] [Day_of_Month] [Month] [Day_of_Week] [Year].
	//
	// For rate expressions, value is a positive integer and unit is minute | minutes
	// | hour | hours | day | days.
	//
	// For more information, see Schedule recurring scaling actions using cron expressions
	// (https://docs.aws.amazon.com/autoscaling/application/userguide/scheduled-scaling-using-cron-expressions.html)
	// in the Application Auto Scaling User Guide.
	//
	// Schedule is a required field
	Schedule *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the scheduled action.
	//
	// ScheduledActionARN is a required field
	ScheduledActionARN *string `min:"1" type:"string" required:"true"`

	// The name of the scheduled action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`

	// The namespace of the Amazon Web Services service that provides the resource,
	// or a custom-resource.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// The date and time that the action is scheduled to begin, in UTC.
	StartTime *time.Time `type:"timestamp"`

	// The time zone used when referring to the date and time of a scheduled action,
	// when the scheduled action uses an at or cron expression.
	Timezone *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledAction) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ScheduledAction) SetCreationTime(v time.Time) *ScheduledAction {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ScheduledAction) SetEndTime(v time.Time) *ScheduledAction {
	s.EndTime = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ScheduledAction) SetResourceId(v string) *ScheduledAction {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *ScheduledAction) SetScalableDimension(v string) *ScheduledAction {
	s.ScalableDimension = &v
	return s
}

// SetScalableTargetAction sets the ScalableTargetAction field's value.
func (s *ScheduledAction) SetScalableTargetAction(v *ScalableTargetAction) *ScheduledAction {
	s.ScalableTargetAction = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *ScheduledAction) SetSchedule(v string) *ScheduledAction {
	s.Schedule = &v
	return s
}

// SetScheduledActionARN sets the ScheduledActionARN field's value.
func (s *ScheduledAction) SetScheduledActionARN(v string) *ScheduledAction {
	s.ScheduledActionARN = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *ScheduledAction) SetScheduledActionName(v string) *ScheduledAction {
	s.ScheduledActionName = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *ScheduledAction) SetServiceNamespace(v string) *ScheduledAction {
	s.ServiceNamespace = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ScheduledAction) SetStartTime(v time.Time) *ScheduledAction {
	s.StartTime = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *ScheduledAction) SetTimezone(v string) *ScheduledAction {
	s.Timezone = &v
	return s
}

// Represents a step adjustment for a StepScalingPolicyConfiguration (https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepScalingPolicyConfiguration.html).
// Describes an adjustment based on the difference between the value of the
// aggregated CloudWatch metric and the breach threshold that you've defined
// for the alarm.
//
// For the following examples, suppose that you have an alarm with a breach
// threshold of 50:
//
//   - To initiate the adjustment when the metric is greater than or equal
//     to 50 and less than 60, specify a lower bound of 0 and an upper bound
//     of 10.
//
//   - To initiate the adjustment when the metric is greater than 40 and less
//     than or equal to 50, specify a lower bound of -10 and an upper bound of
//     0.
//
// There are a few rules for the step adjustments for your step policy:
//
//   - The ranges of your step adjustments can't overlap or have a gap.
//
//   - At most one step adjustment can have a null lower bound. If one step
//     adjustment has a negative lower bound, then there must be a step adjustment
//     with a null lower bound.
//
//   - At most one step adjustment can have a null upper bound. If one step
//     adjustment has a positive upper bound, then there must be a step adjustment
//     with a null upper bound.
//
//   - The upper and lower bound can't be null in the same step adjustment.
type StepAdjustment struct {
	_ struct{} `type:"structure"`

	// The lower bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the lower bound
	// is inclusive (the metric must be greater than or equal to the threshold plus
	// the lower bound). Otherwise, it's exclusive (the metric must be greater than
	// the threshold plus the lower bound). A null value indicates negative infinity.
	MetricIntervalLowerBound *float64 `type:"double"`

	// The upper bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the upper bound
	// is exclusive (the metric must be less than the threshold plus the upper bound).
	// Otherwise, it's inclusive (the metric must be less than or equal to the threshold
	// plus the upper bound). A null value indicates positive infinity.
	//
	// The upper bound must be greater than the lower bound.
	MetricIntervalUpperBound *float64 `type:"double"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity. For exact capacity, you must specify a non-negative value.
	//
	// ScalingAdjustment is a required field
	ScalingAdjustment *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepAdjustment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepAdjustment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepAdjustment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StepAdjustment"}
	if s.ScalingAdjustment == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingAdjustment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricIntervalLowerBound sets the MetricIntervalLowerBound field's value.
func (s *StepAdjustment) SetMetricIntervalLowerBound(v float64) *StepAdjustment {
	s.MetricIntervalLowerBound = &v
	return s
}

// SetMetricIntervalUpperBound sets the MetricIntervalUpperBound field's value.
func (s *StepAdjustment) SetMetricIntervalUpperBound(v float64) *StepAdjustment {
	s.MetricIntervalUpperBound = &v
	return s
}

// SetScalingAdjustment sets the ScalingAdjustment field's value.
func (s *StepAdjustment) SetScalingAdjustment(v int64) *StepAdjustment {
	s.ScalingAdjustment = &v
	return s
}

// Represents a step scaling policy configuration to use with Application Auto
// Scaling.
//
// For more information, see Step scaling policies (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html)
// in the Application Auto Scaling User Guide.
type StepScalingPolicyConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies how the ScalingAdjustment value in a StepAdjustment (https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepAdjustment.html)
	// is interpreted (for example, an absolute number or a percentage). The valid
	// values are ChangeInCapacity, ExactCapacity, and PercentChangeInCapacity.
	//
	// AdjustmentType is required if you are adding a new step scaling policy configuration.
	AdjustmentType *string `type:"string" enum:"AdjustmentType"`

	// The amount of time, in seconds, to wait for a previous scaling activity to
	// take effect. If not specified, the default value is 300. For more information,
	// see Cooldown period (https://docs.aws.amazon.com/autoscaling/application/userguide/step-scaling-policy-overview.html#step-scaling-cooldown)
	// in the Application Auto Scaling User Guide.
	Cooldown *int64 `type:"integer"`

	// The aggregation type for the CloudWatch metrics. Valid values are Minimum,
	// Maximum, and Average. If the aggregation type is null, the value is treated
	// as Average.
	MetricAggregationType *string `type:"string" enum:"MetricAggregationType"`

	// The minimum value to scale by when the adjustment type is PercentChangeInCapacity.
	// For example, suppose that you create a step scaling policy to scale out an
	// Amazon ECS service by 25 percent and you specify a MinAdjustmentMagnitude
	// of 2. If the service has 4 tasks and the scaling policy is performed, 25
	// percent of 4 is 1. However, because you specified a MinAdjustmentMagnitude
	// of 2, Application Auto Scaling scales out the service by 2 tasks.
	MinAdjustmentMagnitude *int64 `type:"integer"`

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	//
	// At least one step adjustment is required if you are adding a new step scaling
	// policy configuration.
	StepAdjustments []*StepAdjustment `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepScalingPolicyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepScalingPolicyConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepScalingPolicyConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StepScalingPolicyConfiguration"}
	if s.StepAdjustments != nil {
		for i, v := range s.StepAdjustments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StepAdjustments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdjustmentType sets the AdjustmentType field's value.
func (s *StepScalingPolicyConfiguration) SetAdjustmentType(v string) *StepScalingPolicyConfiguration {
	s.AdjustmentType = &v
	return s
}

// SetCooldown sets the Cooldown field's value.
func (s *StepScalingPolicyConfiguration) SetCooldown(v int64) *StepScalingPolicyConfiguration {
	s.Cooldown = &v
	return s
}

// SetMetricAggregationType sets the MetricAggregationType field's value.
func (s *StepScalingPolicyConfiguration) SetMetricAggregationType(v string) *StepScalingPolicyConfiguration {
	s.MetricAggregationType = &v
	return s
}

// SetMinAdjustmentMagnitude sets the MinAdjustmentMagnitude field's value.
func (s *StepScalingPolicyConfiguration) SetMinAdjustmentMagnitude(v int64) *StepScalingPolicyConfiguration {
	s.MinAdjustmentMagnitude = &v
	return s
}

// SetStepAdjustments sets the StepAdjustments field's value.
func (s *StepScalingPolicyConfiguration) SetStepAdjustments(v []*StepAdjustment) *StepScalingPolicyConfiguration {
	s.StepAdjustments = v
	return s
}

// Specifies whether the scaling activities for a scalable target are in a suspended
// state.
type SuspendedState struct {
	_ struct{} `type:"structure"`

	// Whether scale in by a target tracking scaling policy or a step scaling policy
	// is suspended. Set the value to true if you don't want Application Auto Scaling
	// to remove capacity when a scaling policy is triggered. The default is false.
	DynamicScalingInSuspended *bool `type:"boolean"`

	// Whether scale out by a target tracking scaling policy or a step scaling policy
	// is suspended. Set the value to true if you don't want Application Auto Scaling
	// to add capacity when a scaling policy is triggered. The default is false.
	DynamicScalingOutSuspended *bool `type:"boolean"`

	// Whether scheduled scaling is suspended. Set the value to true if you don't
	// want Application Auto Scaling to add or remove capacity by initiating scheduled
	// actions. The default is false.
	ScheduledScalingSuspended *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuspendedState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuspendedState) GoString() string {
	return s.String()
}

// SetDynamicScalingInSuspended sets the DynamicScalingInSuspended field's value.
func (s *SuspendedState) SetDynamicScalingInSuspended(v bool) *SuspendedState {
	s.DynamicScalingInSuspended = &v
	return s
}

// SetDynamicScalingOutSuspended sets the DynamicScalingOutSuspended field's value.
func (s *SuspendedState) SetDynamicScalingOutSuspended(v bool) *SuspendedState {
	s.DynamicScalingOutSuspended = &v
	return s
}

// SetScheduledScalingSuspended sets the ScheduledScalingSuspended field's value.
func (s *SuspendedState) SetScheduledScalingSuspended(v bool) *SuspendedState {
	s.ScheduledScalingSuspended = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifies the Application Auto Scaling scalable target that you want to
	// apply tags to.
	//
	// For example: arn:aws:application-autoscaling:us-east-1:123456789012:scalable-target/1234abcd56ab78cd901ef1234567890ab123
	//
	// To get the ARN for a scalable target, use DescribeScalableTargets.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tags assigned to the resource. A tag is a label that you assign to an
	// Amazon Web Services resource.
	//
	// Each tag consists of a tag key and a tag value.
	//
	// You cannot have more than one tag on an Application Auto Scaling scalable
	// target with the same tag key. If you specify an existing tag key with a different
	// tag value, Application Auto Scaling replaces the current tag value with the
	// specified one.
	//
	// For information about the rules that apply to tag keys and tag values, see
	// User-defined tag restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html)
	// in the Amazon Web Services Billing User Guide.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Represents a specific metric.
//
// Metric is a property of the TargetTrackingMetricStat object.
type TargetTrackingMetric struct {
	_ struct{} `type:"structure"`

	// The dimensions for the metric. For the list of available dimensions, see
	// the Amazon Web Services documentation available from the table in Amazon
	// Web Services services that publish CloudWatch metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html)
	// in the Amazon CloudWatch User Guide.
	//
	// Conditional: If you published your metric with dimensions, you must specify
	// the same dimensions in your scaling policy.
	Dimensions []*TargetTrackingMetricDimension `type:"list"`

	// The name of the metric.
	MetricName *string `min:"1" type:"string"`

	// The namespace of the metric. For more information, see the table in Amazon
	// Web Services services that publish CloudWatch metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html)
	// in the Amazon CloudWatch User Guide.
	Namespace *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetTrackingMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetTrackingMetric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetTrackingMetric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetTrackingMetric"}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *TargetTrackingMetric) SetDimensions(v []*TargetTrackingMetricDimension) *TargetTrackingMetric {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *TargetTrackingMetric) SetMetricName(v string) *TargetTrackingMetric {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *TargetTrackingMetric) SetNamespace(v string) *TargetTrackingMetric {
	s.Namespace = &v
	return s
}

// The metric data to return. Also defines whether this call is returning data
// for one metric only, or whether it is performing a math expression on the
// values of returned metric statistics to create a new time series. A time
// series is a series of data points, each of which is associated with a timestamp.
//
// For more information and examples, see Create a target tracking scaling policy
// for Application Auto Scaling using metric math (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking-metric-math.html)
// in the Application Auto Scaling User Guide.
type TargetTrackingMetricDataQuery struct {
	_ struct{} `type:"structure"`

	// The math expression to perform on the returned data, if this object is performing
	// a math expression. This expression can use the Id of the other metrics to
	// refer to those metrics, and can also use the Id of other expressions to use
	// the result of those expressions.
	//
	// Conditional: Within each TargetTrackingMetricDataQuery object, you must specify
	// either Expression or MetricStat, but not both.
	Expression *string `min:"1" type:"string"`

	// A short name that identifies the object's results in the response. This name
	// must be unique among all MetricDataQuery objects specified for a single scaling
	// policy. If you are performing math expressions on this set of data, this
	// name represents that data and can serve as a variable in the mathematical
	// expression. The valid characters are letters, numbers, and underscores. The
	// first character must be a lowercase letter.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A human-readable label for this metric or expression. This is especially
	// useful if this is a math expression, so that you know what the value represents.
	Label *string `type:"string"`

	// Information about the metric data to return.
	//
	// Conditional: Within each MetricDataQuery object, you must specify either
	// Expression or MetricStat, but not both.
	MetricStat *TargetTrackingMetricStat `type:"structure"`

	// Indicates whether to return the timestamps and raw data values of this metric.
	//
	// If you use any math expressions, specify true for this value for only the
	// final math expression that the metric specification is based on. You must
	// specify false for ReturnData for all the other metrics and expressions used
	// in the metric specification.
	//
	// If you are only retrieving metrics and not performing any math expressions,
	// do not specify anything for ReturnData. This sets it to its default (true).
	ReturnData *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetTrackingMetricDataQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetTrackingMetricDataQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetTrackingMetricDataQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetTrackingMetricDataQuery"}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.MetricStat != nil {
		if err := s.MetricStat.Validate(); err != nil {
			invalidParams.AddNested("MetricStat", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *TargetTrackingMetricDataQuery) SetExpression(v string) *TargetTrackingMetricDataQuery {
	s.Expression = &v
	return s
}

// SetId sets the Id field's value.
func (s *TargetTrackingMetricDataQuery) SetId(v string) *TargetTrackingMetricDataQuery {
	s.Id = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *TargetTrackingMetricDataQuery) SetLabel(v string) *TargetTrackingMetricDataQuery {
	s.Label = &v
	return s
}

// SetMetricStat sets the MetricStat field's value.
func (s *TargetTrackingMetricDataQuery) SetMetricStat(v *TargetTrackingMetricStat) *TargetTrackingMetricDataQuery {
	s.MetricStat = v
	return s
}

// SetReturnData sets the ReturnData field's value.
func (s *TargetTrackingMetricDataQuery) SetReturnData(v bool) *TargetTrackingMetricDataQuery {
	s.ReturnData = &v
	return s
}

// Describes the dimension of a metric.
type TargetTrackingMetricDimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the dimension.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetTrackingMetricDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetTrackingMetricDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetTrackingMetricDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetTrackingMetricDimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *TargetTrackingMetricDimension) SetName(v string) *TargetTrackingMetricDimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TargetTrackingMetricDimension) SetValue(v string) *TargetTrackingMetricDimension {
	s.Value = &v
	return s
}

// This structure defines the CloudWatch metric to return, along with the statistic
// and unit.
//
// For more information about the CloudWatch terminology below, see Amazon CloudWatch
// concepts (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html)
// in the Amazon CloudWatch User Guide.
type TargetTrackingMetricStat struct {
	_ struct{} `type:"structure"`

	// The CloudWatch metric to return, including the metric name, namespace, and
	// dimensions. To get the exact metric name, namespace, and dimensions, inspect
	// the Metric (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html)
	// object that is returned by a call to ListMetrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html).
	//
	// Metric is a required field
	Metric *TargetTrackingMetric `type:"structure" required:"true"`

	// The statistic to return. It can include any CloudWatch statistic or extended
	// statistic. For a list of valid values, see the table in Statistics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic)
	// in the Amazon CloudWatch User Guide.
	//
	// The most commonly used metric for scaling is Average.
	//
	// Stat is a required field
	Stat *string `type:"string" required:"true"`

	// The unit to use for the returned data points. For a complete list of the
	// units that CloudWatch supports, see the MetricDatum (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html)
	// data type in the Amazon CloudWatch API Reference.
	Unit *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetTrackingMetricStat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetTrackingMetricStat) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetTrackingMetricStat) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetTrackingMetricStat"}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.Stat == nil {
		invalidParams.Add(request.NewErrParamRequired("Stat"))
	}
	if s.Unit != nil && len(*s.Unit) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Unit", 1))
	}
	if s.Metric != nil {
		if err := s.Metric.Validate(); err != nil {
			invalidParams.AddNested("Metric", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetric sets the Metric field's value.
func (s *TargetTrackingMetricStat) SetMetric(v *TargetTrackingMetric) *TargetTrackingMetricStat {
	s.Metric = v
	return s
}

// SetStat sets the Stat field's value.
func (s *TargetTrackingMetricStat) SetStat(v string) *TargetTrackingMetricStat {
	s.Stat = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *TargetTrackingMetricStat) SetUnit(v string) *TargetTrackingMetricStat {
	s.Unit = &v
	return s
}

// Represents a target tracking scaling policy configuration to use with Application
// Auto Scaling.
//
// For more information, see Target tracking scaling policies (https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html)
// in the Application Auto Scaling User Guide.
type TargetTrackingScalingPolicyConfiguration struct {
	_ struct{} `type:"structure"`

	// A customized metric. You can specify either a predefined metric or a customized
	// metric.
	CustomizedMetricSpecification *CustomizedMetricSpecification `type:"structure"`

	// Indicates whether scale in by the target tracking scaling policy is disabled.
	// If the value is true, scale in is disabled and the target tracking scaling
	// policy won't remove capacity from the scalable target. Otherwise, scale in
	// is enabled and the target tracking scaling policy can remove capacity from
	// the scalable target. The default value is false.
	DisableScaleIn *bool `type:"boolean"`

	// A predefined metric. You can specify either a predefined metric or a customized
	// metric.
	PredefinedMetricSpecification *PredefinedMetricSpecification `type:"structure"`

	// The amount of time, in seconds, after a scale-in activity completes before
	// another scale-in activity can start. For more information and for default
	// values, see Define cooldown periods (https://docs.aws.amazon.com/autoscaling/application/userguide/target-tracking-scaling-policy-overview.html#target-tracking-cooldown)
	// in the Application Auto Scaling User Guide.
	ScaleInCooldown *int64 `type:"integer"`

	// The amount of time, in seconds, to wait for a previous scale-out activity
	// to take effect. For more information and for default values, see Define cooldown
	// periods (https://docs.aws.amazon.com/autoscaling/application/userguide/target-tracking-scaling-policy-overview.html#target-tracking-cooldown)
	// in the Application Auto Scaling User Guide.
	ScaleOutCooldown *int64 `type:"integer"`

	// The target value for the metric. Although this property accepts numbers of
	// type Double, it won't accept values that are either too small or too large.
	// Values must be in the range of -2^360 to 2^360. The value must be a valid
	// number based on the choice of metric. For example, if the metric is CPU utilization,
	// then the target value is a percent value that represents how much of the
	// CPU can be used before scaling out.
	//
	// If the scaling policy specifies the ALBRequestCountPerTarget predefined metric,
	// specify the target utilization as the optimal average request count per target
	// during any one-minute interval.
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetTrackingScalingPolicyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetTrackingScalingPolicyConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetTrackingScalingPolicyConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetTrackingScalingPolicyConfiguration"}
	if s.TargetValue == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetValue"))
	}
	if s.CustomizedMetricSpecification != nil {
		if err := s.CustomizedMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("CustomizedMetricSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.PredefinedMetricSpecification != nil {
		if err := s.PredefinedMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("PredefinedMetricSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomizedMetricSpecification sets the CustomizedMetricSpecification field's value.
func (s *TargetTrackingScalingPolicyConfiguration) SetCustomizedMetricSpecification(v *CustomizedMetricSpecification) *TargetTrackingScalingPolicyConfiguration {
	s.CustomizedMetricSpecification = v
	return s
}

// SetDisableScaleIn sets the DisableScaleIn field's value.
func (s *TargetTrackingScalingPolicyConfiguration) SetDisableScaleIn(v bool) *TargetTrackingScalingPolicyConfiguration {
	s.DisableScaleIn = &v
	return s
}

// SetPredefinedMetricSpecification sets the PredefinedMetricSpecification field's value.
func (s *TargetTrackingScalingPolicyConfiguration) SetPredefinedMetricSpecification(v *PredefinedMetricSpecification) *TargetTrackingScalingPolicyConfiguration {
	s.PredefinedMetricSpecification = v
	return s
}

// SetScaleInCooldown sets the ScaleInCooldown field's value.
func (s *TargetTrackingScalingPolicyConfiguration) SetScaleInCooldown(v int64) *TargetTrackingScalingPolicyConfiguration {
	s.ScaleInCooldown = &v
	return s
}

// SetScaleOutCooldown sets the ScaleOutCooldown field's value.
func (s *TargetTrackingScalingPolicyConfiguration) SetScaleOutCooldown(v int64) *TargetTrackingScalingPolicyConfiguration {
	s.ScaleOutCooldown = &v
	return s
}

// SetTargetValue sets the TargetValue field's value.
func (s *TargetTrackingScalingPolicyConfiguration) SetTargetValue(v float64) *TargetTrackingScalingPolicyConfiguration {
	s.TargetValue = &v
	return s
}

// The request contains too many tags. Try the request again with fewer tags.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The name of the Application Auto Scaling resource. This value is an Amazon
	// Resource Name (ARN).
	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifies the Application Auto Scaling scalable target from which to remove
	// tags.
	//
	// For example: arn:aws:application-autoscaling:us-east-1:123456789012:scalable-target/1234abcd56ab78cd901ef1234567890ab123
	//
	// To get the ARN for a scalable target, use DescribeScalableTargets.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// One or more tag keys. Specify only the tag keys, not the tag values.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// An exception was thrown for a validation issue. Review the available parameters
// for the API request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AdjustmentTypeChangeInCapacity is a AdjustmentType enum value
	AdjustmentTypeChangeInCapacity = "ChangeInCapacity"

	// AdjustmentTypePercentChangeInCapacity is a AdjustmentType enum value
	AdjustmentTypePercentChangeInCapacity = "PercentChangeInCapacity"

	// AdjustmentTypeExactCapacity is a AdjustmentType enum value
	AdjustmentTypeExactCapacity = "ExactCapacity"
)

// AdjustmentType_Values returns all elements of the AdjustmentType enum
func AdjustmentType_Values() []string {
	return []string{
		AdjustmentTypeChangeInCapacity,
		AdjustmentTypePercentChangeInCapacity,
		AdjustmentTypeExactCapacity,
	}
}

const (
	// MetricAggregationTypeAverage is a MetricAggregationType enum value
	MetricAggregationTypeAverage = "Average"

	// MetricAggregationTypeMinimum is a MetricAggregationType enum value
	MetricAggregationTypeMinimum = "Minimum"

	// MetricAggregationTypeMaximum is a MetricAggregationType enum value
	MetricAggregationTypeMaximum = "Maximum"
)

// MetricAggregationType_Values returns all elements of the MetricAggregationType enum
func MetricAggregationType_Values() []string {
	return []string{
		MetricAggregationTypeAverage,
		MetricAggregationTypeMinimum,
		MetricAggregationTypeMaximum,
	}
}

const (
	// MetricStatisticAverage is a MetricStatistic enum value
	MetricStatisticAverage = "Average"

	// MetricStatisticMinimum is a MetricStatistic enum value
	MetricStatisticMinimum = "Minimum"

	// MetricStatisticMaximum is a MetricStatistic enum value
	MetricStatisticMaximum = "Maximum"

	// MetricStatisticSampleCount is a MetricStatistic enum value
	MetricStatisticSampleCount = "SampleCount"

	// MetricStatisticSum is a MetricStatistic enum value
	MetricStatisticSum = "Sum"
)

// MetricStatistic_Values returns all elements of the MetricStatistic enum
func MetricStatistic_Values() []string {
	return []string{
		MetricStatisticAverage,
		MetricStatisticMinimum,
		MetricStatisticMaximum,
		MetricStatisticSampleCount,
		MetricStatisticSum,
	}
}

const (
	// MetricTypeDynamoDbreadCapacityUtilization is a MetricType enum value
	MetricTypeDynamoDbreadCapacityUtilization = "DynamoDBReadCapacityUtilization"

	// MetricTypeDynamoDbwriteCapacityUtilization is a MetricType enum value
	MetricTypeDynamoDbwriteCapacityUtilization = "DynamoDBWriteCapacityUtilization"

	// MetricTypeAlbrequestCountPerTarget is a MetricType enum value
	MetricTypeAlbrequestCountPerTarget = "ALBRequestCountPerTarget"

	// MetricTypeRdsreaderAverageCpuutilization is a MetricType enum value
	MetricTypeRdsreaderAverageCpuutilization = "RDSReaderAverageCPUUtilization"

	// MetricTypeRdsreaderAverageDatabaseConnections is a MetricType enum value
	MetricTypeRdsreaderAverageDatabaseConnections = "RDSReaderAverageDatabaseConnections"

	// MetricTypeEc2spotFleetRequestAverageCpuutilization is a MetricType enum value
	MetricTypeEc2spotFleetRequestAverageCpuutilization = "EC2SpotFleetRequestAverageCPUUtilization"

	// MetricTypeEc2spotFleetRequestAverageNetworkIn is a MetricType enum value
	MetricTypeEc2spotFleetRequestAverageNetworkIn = "EC2SpotFleetRequestAverageNetworkIn"

	// MetricTypeEc2spotFleetRequestAverageNetworkOut is a MetricType enum value
	MetricTypeEc2spotFleetRequestAverageNetworkOut = "EC2SpotFleetRequestAverageNetworkOut"

	// MetricTypeSageMakerVariantInvocationsPerInstance is a MetricType enum value
	MetricTypeSageMakerVariantInvocationsPerInstance = "SageMakerVariantInvocationsPerInstance"

	// MetricTypeEcsserviceAverageCpuutilization is a MetricType enum value
	MetricTypeEcsserviceAverageCpuutilization = "ECSServiceAverageCPUUtilization"

	// MetricTypeEcsserviceAverageMemoryUtilization is a MetricType enum value
	MetricTypeEcsserviceAverageMemoryUtilization = "ECSServiceAverageMemoryUtilization"

	// MetricTypeAppStreamAverageCapacityUtilization is a MetricType enum value
	MetricTypeAppStreamAverageCapacityUtilization = "AppStreamAverageCapacityUtilization"

	// MetricTypeComprehendInferenceUtilization is a MetricType enum value
	MetricTypeComprehendInferenceUtilization = "ComprehendInferenceUtilization"

	// MetricTypeLambdaProvisionedConcurrencyUtilization is a MetricType enum value
	MetricTypeLambdaProvisionedConcurrencyUtilization = "LambdaProvisionedConcurrencyUtilization"

	// MetricTypeCassandraReadCapacityUtilization is a MetricType enum value
	MetricTypeCassandraReadCapacityUtilization = "CassandraReadCapacityUtilization"

	// MetricTypeCassandraWriteCapacityUtilization is a MetricType enum value
	MetricTypeCassandraWriteCapacityUtilization = "CassandraWriteCapacityUtilization"

	// MetricTypeKafkaBrokerStorageUtilization is a MetricType enum value
	MetricTypeKafkaBrokerStorageUtilization = "KafkaBrokerStorageUtilization"

	// MetricTypeElastiCachePrimaryEngineCpuutilization is a MetricType enum value
	MetricTypeElastiCachePrimaryEngineCpuutilization = "ElastiCachePrimaryEngineCPUUtilization"

	// MetricTypeElastiCacheReplicaEngineCpuutilization is a MetricType enum value
	MetricTypeElastiCacheReplicaEngineCpuutilization = "ElastiCacheReplicaEngineCPUUtilization"

	// MetricTypeElastiCacheDatabaseMemoryUsageCountedForEvictPercentage is a MetricType enum value
	MetricTypeElastiCacheDatabaseMemoryUsageCountedForEvictPercentage = "ElastiCacheDatabaseMemoryUsageCountedForEvictPercentage"

	// MetricTypeNeptuneReaderAverageCpuutilization is a MetricType enum value
	MetricTypeNeptuneReaderAverageCpuutilization = "NeptuneReaderAverageCPUUtilization"

	// MetricTypeSageMakerVariantProvisionedConcurrencyUtilization is a MetricType enum value
	MetricTypeSageMakerVariantProvisionedConcurrencyUtilization = "SageMakerVariantProvisionedConcurrencyUtilization"

	// MetricTypeElastiCacheDatabaseCapacityUsageCountedForEvictPercentage is a MetricType enum value
	MetricTypeElastiCacheDatabaseCapacityUsageCountedForEvictPercentage = "ElastiCacheDatabaseCapacityUsageCountedForEvictPercentage"

	// MetricTypeSageMakerInferenceComponentInvocationsPerCopy is a MetricType enum value
	MetricTypeSageMakerInferenceComponentInvocationsPerCopy = "SageMakerInferenceComponentInvocationsPerCopy"

	// MetricTypeWorkSpacesAverageUserSessionsCapacityUtilization is a MetricType enum value
	MetricTypeWorkSpacesAverageUserSessionsCapacityUtilization = "WorkSpacesAverageUserSessionsCapacityUtilization"

	// MetricTypeSageMakerInferenceComponentConcurrentRequestsPerCopyHighResolution is a MetricType enum value
	MetricTypeSageMakerInferenceComponentConcurrentRequestsPerCopyHighResolution = "SageMakerInferenceComponentConcurrentRequestsPerCopyHighResolution"

	// MetricTypeSageMakerVariantConcurrentRequestsPerModelHighResolution is a MetricType enum value
	MetricTypeSageMakerVariantConcurrentRequestsPerModelHighResolution = "SageMakerVariantConcurrentRequestsPerModelHighResolution"
)

// MetricType_Values returns all elements of the MetricType enum
func MetricType_Values() []string {
	return []string{
		MetricTypeDynamoDbreadCapacityUtilization,
		MetricTypeDynamoDbwriteCapacityUtilization,
		MetricTypeAlbrequestCountPerTarget,
		MetricTypeRdsreaderAverageCpuutilization,
		MetricTypeRdsreaderAverageDatabaseConnections,
		MetricTypeEc2spotFleetRequestAverageCpuutilization,
		MetricTypeEc2spotFleetRequestAverageNetworkIn,
		MetricTypeEc2spotFleetRequestAverageNetworkOut,
		MetricTypeSageMakerVariantInvocationsPerInstance,
		MetricTypeEcsserviceAverageCpuutilization,
		MetricTypeEcsserviceAverageMemoryUtilization,
		MetricTypeAppStreamAverageCapacityUtilization,
		MetricTypeComprehendInferenceUtilization,
		MetricTypeLambdaProvisionedConcurrencyUtilization,
		MetricTypeCassandraReadCapacityUtilization,
		MetricTypeCassandraWriteCapacityUtilization,
		MetricTypeKafkaBrokerStorageUtilization,
		MetricTypeElastiCachePrimaryEngineCpuutilization,
		MetricTypeElastiCacheReplicaEngineCpuutilization,
		MetricTypeElastiCacheDatabaseMemoryUsageCountedForEvictPercentage,
		MetricTypeNeptuneReaderAverageCpuutilization,
		MetricTypeSageMakerVariantProvisionedConcurrencyUtilization,
		MetricTypeElastiCacheDatabaseCapacityUsageCountedForEvictPercentage,
		MetricTypeSageMakerInferenceComponentInvocationsPerCopy,
		MetricTypeWorkSpacesAverageUserSessionsCapacityUtilization,
		MetricTypeSageMakerInferenceComponentConcurrentRequestsPerCopyHighResolution,
		MetricTypeSageMakerVariantConcurrentRequestsPerModelHighResolution,
	}
}

const (
	// PolicyTypeStepScaling is a PolicyType enum value
	PolicyTypeStepScaling = "StepScaling"

	// PolicyTypeTargetTrackingScaling is a PolicyType enum value
	PolicyTypeTargetTrackingScaling = "TargetTrackingScaling"
)

// PolicyType_Values returns all elements of the PolicyType enum
func PolicyType_Values() []string {
	return []string{
		PolicyTypeStepScaling,
		PolicyTypeTargetTrackingScaling,
	}
}

const (
	// ScalableDimensionEcsServiceDesiredCount is a ScalableDimension enum value
	ScalableDimensionEcsServiceDesiredCount = "ecs:service:DesiredCount"

	// ScalableDimensionEc2SpotFleetRequestTargetCapacity is a ScalableDimension enum value
	ScalableDimensionEc2SpotFleetRequestTargetCapacity = "ec2:spot-fleet-request:TargetCapacity"

	// ScalableDimensionElasticmapreduceInstancegroupInstanceCount is a ScalableDimension enum value
	ScalableDimensionElasticmapreduceInstancegroupInstanceCount = "elasticmapreduce:instancegroup:InstanceCount"

	// ScalableDimensionAppstreamFleetDesiredCapacity is a ScalableDimension enum value
	ScalableDimensionAppstreamFleetDesiredCapacity = "appstream:fleet:DesiredCapacity"

	// ScalableDimensionDynamodbTableReadCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbTableReadCapacityUnits = "dynamodb:table:ReadCapacityUnits"

	// ScalableDimensionDynamodbTableWriteCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbTableWriteCapacityUnits = "dynamodb:table:WriteCapacityUnits"

	// ScalableDimensionDynamodbIndexReadCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbIndexReadCapacityUnits = "dynamodb:index:ReadCapacityUnits"

	// ScalableDimensionDynamodbIndexWriteCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbIndexWriteCapacityUnits = "dynamodb:index:WriteCapacityUnits"

	// ScalableDimensionRdsClusterReadReplicaCount is a ScalableDimension enum value
	ScalableDimensionRdsClusterReadReplicaCount = "rds:cluster:ReadReplicaCount"

	// ScalableDimensionSagemakerVariantDesiredInstanceCount is a ScalableDimension enum value
	ScalableDimensionSagemakerVariantDesiredInstanceCount = "sagemaker:variant:DesiredInstanceCount"

	// ScalableDimensionCustomResourceResourceTypeProperty is a ScalableDimension enum value
	ScalableDimensionCustomResourceResourceTypeProperty = "custom-resource:ResourceType:Property"

	// ScalableDimensionComprehendDocumentClassifierEndpointDesiredInferenceUnits is a ScalableDimension enum value
	ScalableDimensionComprehendDocumentClassifierEndpointDesiredInferenceUnits = "comprehend:document-classifier-endpoint:DesiredInferenceUnits"

	// ScalableDimensionComprehendEntityRecognizerEndpointDesiredInferenceUnits is a ScalableDimension enum value
	ScalableDimensionComprehendEntityRecognizerEndpointDesiredInferenceUnits = "comprehend:entity-recognizer-endpoint:DesiredInferenceUnits"

	// ScalableDimensionLambdaFunctionProvisionedConcurrency is a ScalableDimension enum value
	ScalableDimensionLambdaFunctionProvisionedConcurrency = "lambda:function:ProvisionedConcurrency"

	// ScalableDimensionCassandraTableReadCapacityUnits is a ScalableDimension enum value
	ScalableDimensionCassandraTableReadCapacityUnits = "cassandra:table:ReadCapacityUnits"

	// ScalableDimensionCassandraTableWriteCapacityUnits is a ScalableDimension enum value
	ScalableDimensionCassandraTableWriteCapacityUnits = "cassandra:table:WriteCapacityUnits"

	// ScalableDimensionKafkaBrokerStorageVolumeSize is a ScalableDimension enum value
	ScalableDimensionKafkaBrokerStorageVolumeSize = "kafka:broker-storage:VolumeSize"

	// ScalableDimensionElasticacheReplicationGroupNodeGroups is a ScalableDimension enum value
	ScalableDimensionElasticacheReplicationGroupNodeGroups = "elasticache:replication-group:NodeGroups"

	// ScalableDimensionElasticacheReplicationGroupReplicas is a ScalableDimension enum value
	ScalableDimensionElasticacheReplicationGroupReplicas = "elasticache:replication-group:Replicas"

	// ScalableDimensionNeptuneClusterReadReplicaCount is a ScalableDimension enum value
	ScalableDimensionNeptuneClusterReadReplicaCount = "neptune:cluster:ReadReplicaCount"

	// ScalableDimensionSagemakerVariantDesiredProvisionedConcurrency is a ScalableDimension enum value
	ScalableDimensionSagemakerVariantDesiredProvisionedConcurrency = "sagemaker:variant:DesiredProvisionedConcurrency"

	// ScalableDimensionSagemakerInferenceComponentDesiredCopyCount is a ScalableDimension enum value
	ScalableDimensionSagemakerInferenceComponentDesiredCopyCount = "sagemaker:inference-component:DesiredCopyCount"

	// ScalableDimensionWorkspacesWorkspacespoolDesiredUserSessions is a ScalableDimension enum value
	ScalableDimensionWorkspacesWorkspacespoolDesiredUserSessions = "workspaces:workspacespool:DesiredUserSessions"
)

// ScalableDimension_Values returns all elements of the ScalableDimension enum
func ScalableDimension_Values() []string {
	return []string{
		ScalableDimensionEcsServiceDesiredCount,
		ScalableDimensionEc2SpotFleetRequestTargetCapacity,
		ScalableDimensionElasticmapreduceInstancegroupInstanceCount,
		ScalableDimensionAppstreamFleetDesiredCapacity,
		ScalableDimensionDynamodbTableReadCapacityUnits,
		ScalableDimensionDynamodbTableWriteCapacityUnits,
		ScalableDimensionDynamodbIndexReadCapacityUnits,
		ScalableDimensionDynamodbIndexWriteCapacityUnits,
		ScalableDimensionRdsClusterReadReplicaCount,
		ScalableDimensionSagemakerVariantDesiredInstanceCount,
		ScalableDimensionCustomResourceResourceTypeProperty,
		ScalableDimensionComprehendDocumentClassifierEndpointDesiredInferenceUnits,
		ScalableDimensionComprehendEntityRecognizerEndpointDesiredInferenceUnits,
		ScalableDimensionLambdaFunctionProvisionedConcurrency,
		ScalableDimensionCassandraTableReadCapacityUnits,
		ScalableDimensionCassandraTableWriteCapacityUnits,
		ScalableDimensionKafkaBrokerStorageVolumeSize,
		ScalableDimensionElasticacheReplicationGroupNodeGroups,
		ScalableDimensionElasticacheReplicationGroupReplicas,
		ScalableDimensionNeptuneClusterReadReplicaCount,
		ScalableDimensionSagemakerVariantDesiredProvisionedConcurrency,
		ScalableDimensionSagemakerInferenceComponentDesiredCopyCount,
		ScalableDimensionWorkspacesWorkspacespoolDesiredUserSessions,
	}
}

const (
	// ScalingActivityStatusCodePending is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodePending = "Pending"

	// ScalingActivityStatusCodeInProgress is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeInProgress = "InProgress"

	// ScalingActivityStatusCodeSuccessful is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeSuccessful = "Successful"

	// ScalingActivityStatusCodeOverridden is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeOverridden = "Overridden"

	// ScalingActivityStatusCodeUnfulfilled is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeUnfulfilled = "Unfulfilled"

	// ScalingActivityStatusCodeFailed is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeFailed = "Failed"
)

// ScalingActivityStatusCode_Values returns all elements of the ScalingActivityStatusCode enum
func ScalingActivityStatusCode_Values() []string {
	return []string{
		ScalingActivityStatusCodePending,
		ScalingActivityStatusCodeInProgress,
		ScalingActivityStatusCodeSuccessful,
		ScalingActivityStatusCodeOverridden,
		ScalingActivityStatusCodeUnfulfilled,
		ScalingActivityStatusCodeFailed,
	}
}

const (
	// ServiceNamespaceEcs is a ServiceNamespace enum value
	ServiceNamespaceEcs = "ecs"

	// ServiceNamespaceElasticmapreduce is a ServiceNamespace enum value
	ServiceNamespaceElasticmapreduce = "elasticmapreduce"

	// ServiceNamespaceEc2 is a ServiceNamespace enum value
	ServiceNamespaceEc2 = "ec2"

	// ServiceNamespaceAppstream is a ServiceNamespace enum value
	ServiceNamespaceAppstream = "appstream"

	// ServiceNamespaceDynamodb is a ServiceNamespace enum value
	ServiceNamespaceDynamodb = "dynamodb"

	// ServiceNamespaceRds is a ServiceNamespace enum value
	ServiceNamespaceRds = "rds"

	// ServiceNamespaceSagemaker is a ServiceNamespace enum value
	ServiceNamespaceSagemaker = "sagemaker"

	// ServiceNamespaceCustomResource is a ServiceNamespace enum value
	ServiceNamespaceCustomResource = "custom-resource"

	// ServiceNamespaceComprehend is a ServiceNamespace enum value
	ServiceNamespaceComprehend = "comprehend"

	// ServiceNamespaceLambda is a ServiceNamespace enum value
	ServiceNamespaceLambda = "lambda"

	// ServiceNamespaceCassandra is a ServiceNamespace enum value
	ServiceNamespaceCassandra = "cassandra"

	// ServiceNamespaceKafka is a ServiceNamespace enum value
	ServiceNamespaceKafka = "kafka"

	// ServiceNamespaceElasticache is a ServiceNamespace enum value
	ServiceNamespaceElasticache = "elasticache"

	// ServiceNamespaceNeptune is a ServiceNamespace enum value
	ServiceNamespaceNeptune = "neptune"

	// ServiceNamespaceWorkspaces is a ServiceNamespace enum value
	ServiceNamespaceWorkspaces = "workspaces"
)

// ServiceNamespace_Values returns all elements of the ServiceNamespace enum
func ServiceNamespace_Values() []string {
	return []string{
		ServiceNamespaceEcs,
		ServiceNamespaceElasticmapreduce,
		ServiceNamespaceEc2,
		ServiceNamespaceAppstream,
		ServiceNamespaceDynamodb,
		ServiceNamespaceRds,
		ServiceNamespaceSagemaker,
		ServiceNamespaceCustomResource,
		ServiceNamespaceComprehend,
		ServiceNamespaceLambda,
		ServiceNamespaceCassandra,
		ServiceNamespaceKafka,
		ServiceNamespaceElasticache,
		ServiceNamespaceNeptune,
		ServiceNamespaceWorkspaces,
	}
}
