/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// WindowsService struct for WindowsService
type WindowsService struct {
	Attributes *WindowsServiceAttributes `json:"attributes,omitempty"`
	Host *string `json:"host,omitempty"`
	Name *string `json:"name,omitempty"`
}

// NewWindowsService instantiates a new WindowsService object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewWindowsService() *WindowsService {
	this := WindowsService{}
	return &this
}

// NewWindowsServiceWithDefaults instantiates a new WindowsService object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewWindowsServiceWithDefaults() *WindowsService {
	this := WindowsService{}
	return &this
}

// GetAttributes returns the Attributes field value if set, zero value otherwise.
func (o *WindowsService) GetAttributes() WindowsServiceAttributes {
	if o == nil || o.Attributes == nil {
		var ret WindowsServiceAttributes
		return ret
	}
	return *o.Attributes
}

// GetAttributesOk returns a tuple with the Attributes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *WindowsService) GetAttributesOk() (*WindowsServiceAttributes, bool) {
	if o == nil || o.Attributes == nil {
		return nil, false
	}
	return o.Attributes, true
}

// HasAttributes returns a boolean if a field has been set.
func (o *WindowsService) HasAttributes() bool {
	if o != nil && o.Attributes != nil {
		return true
	}

	return false
}

// SetAttributes gets a reference to the given WindowsServiceAttributes and assigns it to the Attributes field.
func (o *WindowsService) SetAttributes(v WindowsServiceAttributes) {
	o.Attributes = &v
}

// GetHost returns the Host field value if set, zero value otherwise.
func (o *WindowsService) GetHost() string {
	if o == nil || o.Host == nil {
		var ret string
		return ret
	}
	return *o.Host
}

// GetHostOk returns a tuple with the Host field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *WindowsService) GetHostOk() (*string, bool) {
	if o == nil || o.Host == nil {
		return nil, false
	}
	return o.Host, true
}

// HasHost returns a boolean if a field has been set.
func (o *WindowsService) HasHost() bool {
	if o != nil && o.Host != nil {
		return true
	}

	return false
}

// SetHost gets a reference to the given string and assigns it to the Host field.
func (o *WindowsService) SetHost(v string) {
	o.Host = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *WindowsService) GetName() string {
	if o == nil || o.Name == nil {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *WindowsService) GetNameOk() (*string, bool) {
	if o == nil || o.Name == nil {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *WindowsService) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *WindowsService) SetName(v string) {
	o.Name = &v
}

func (o WindowsService) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Attributes != nil {
		toSerialize["attributes"] = o.Attributes
	}
	if o.Host != nil {
		toSerialize["host"] = o.Host
	}
	if o.Name != nil {
		toSerialize["name"] = o.Name
	}
	return json.Marshal(toSerialize)
}

type NullableWindowsService struct {
	value *WindowsService
	isSet bool
}

func (v NullableWindowsService) Get() *WindowsService {
	return v.value
}

func (v *NullableWindowsService) Set(val *WindowsService) {
	v.value = val
	v.isSet = true
}

func (v NullableWindowsService) IsSet() bool {
	return v.isSet
}

func (v *NullableWindowsService) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableWindowsService(val *WindowsService) *NullableWindowsService {
	return &NullableWindowsService{value: val, isSet: true}
}

func (v NullableWindowsService) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableWindowsService) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


