/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UpdateManagedKey struct for UpdateManagedKey
type UpdateManagedKey struct {
	// List of the new tags that will be attached to this item
	AddTag *[]string `json:"add-tag,omitempty"`
	// Whether to automatically rotate every --rotation-interval days, or disable existing automatic rotation
	AutoRotate *string `json:"auto-rotate,omitempty"`
	// ManagedKey name
	Name string `json:"name"`
	// New item metadata
	NewMetadata *string `json:"new-metadata,omitempty"`
	// New managed key name
	NewName *string `json:"new-name,omitempty"`
	// List of the existent tags that will be removed from this item
	RmTag *[]string `json:"rm-tag,omitempty"`
	// The number of days to wait between every automatic key rotation (7-365)
	RotationInterval *string `json:"rotation-interval,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Gateway url
	UpdateUrl *string `json:"update-url,omitempty"`
}

// NewUpdateManagedKey instantiates a new UpdateManagedKey object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateManagedKey(name string, ) *UpdateManagedKey {
	this := UpdateManagedKey{}
	this.Name = name
	var newMetadata string = "default_metadata"
	this.NewMetadata = &newMetadata
	var updateUrl string = "http://localhost:8000"
	this.UpdateUrl = &updateUrl
	return &this
}

// NewUpdateManagedKeyWithDefaults instantiates a new UpdateManagedKey object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateManagedKeyWithDefaults() *UpdateManagedKey {
	this := UpdateManagedKey{}
	var newMetadata string = "default_metadata"
	this.NewMetadata = &newMetadata
	var updateUrl string = "http://localhost:8000"
	this.UpdateUrl = &updateUrl
	return &this
}

// GetAddTag returns the AddTag field value if set, zero value otherwise.
func (o *UpdateManagedKey) GetAddTag() []string {
	if o == nil || o.AddTag == nil {
		var ret []string
		return ret
	}
	return *o.AddTag
}

// GetAddTagOk returns a tuple with the AddTag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateManagedKey) GetAddTagOk() (*[]string, bool) {
	if o == nil || o.AddTag == nil {
		return nil, false
	}
	return o.AddTag, true
}

// HasAddTag returns a boolean if a field has been set.
func (o *UpdateManagedKey) HasAddTag() bool {
	if o != nil && o.AddTag != nil {
		return true
	}

	return false
}

// SetAddTag gets a reference to the given []string and assigns it to the AddTag field.
func (o *UpdateManagedKey) SetAddTag(v []string) {
	o.AddTag = &v
}

// GetAutoRotate returns the AutoRotate field value if set, zero value otherwise.
func (o *UpdateManagedKey) GetAutoRotate() string {
	if o == nil || o.AutoRotate == nil {
		var ret string
		return ret
	}
	return *o.AutoRotate
}

// GetAutoRotateOk returns a tuple with the AutoRotate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateManagedKey) GetAutoRotateOk() (*string, bool) {
	if o == nil || o.AutoRotate == nil {
		return nil, false
	}
	return o.AutoRotate, true
}

// HasAutoRotate returns a boolean if a field has been set.
func (o *UpdateManagedKey) HasAutoRotate() bool {
	if o != nil && o.AutoRotate != nil {
		return true
	}

	return false
}

// SetAutoRotate gets a reference to the given string and assigns it to the AutoRotate field.
func (o *UpdateManagedKey) SetAutoRotate(v string) {
	o.AutoRotate = &v
}

// GetName returns the Name field value
func (o *UpdateManagedKey) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *UpdateManagedKey) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *UpdateManagedKey) SetName(v string) {
	o.Name = v
}

// GetNewMetadata returns the NewMetadata field value if set, zero value otherwise.
func (o *UpdateManagedKey) GetNewMetadata() string {
	if o == nil || o.NewMetadata == nil {
		var ret string
		return ret
	}
	return *o.NewMetadata
}

// GetNewMetadataOk returns a tuple with the NewMetadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateManagedKey) GetNewMetadataOk() (*string, bool) {
	if o == nil || o.NewMetadata == nil {
		return nil, false
	}
	return o.NewMetadata, true
}

// HasNewMetadata returns a boolean if a field has been set.
func (o *UpdateManagedKey) HasNewMetadata() bool {
	if o != nil && o.NewMetadata != nil {
		return true
	}

	return false
}

// SetNewMetadata gets a reference to the given string and assigns it to the NewMetadata field.
func (o *UpdateManagedKey) SetNewMetadata(v string) {
	o.NewMetadata = &v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *UpdateManagedKey) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateManagedKey) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *UpdateManagedKey) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *UpdateManagedKey) SetNewName(v string) {
	o.NewName = &v
}

// GetRmTag returns the RmTag field value if set, zero value otherwise.
func (o *UpdateManagedKey) GetRmTag() []string {
	if o == nil || o.RmTag == nil {
		var ret []string
		return ret
	}
	return *o.RmTag
}

// GetRmTagOk returns a tuple with the RmTag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateManagedKey) GetRmTagOk() (*[]string, bool) {
	if o == nil || o.RmTag == nil {
		return nil, false
	}
	return o.RmTag, true
}

// HasRmTag returns a boolean if a field has been set.
func (o *UpdateManagedKey) HasRmTag() bool {
	if o != nil && o.RmTag != nil {
		return true
	}

	return false
}

// SetRmTag gets a reference to the given []string and assigns it to the RmTag field.
func (o *UpdateManagedKey) SetRmTag(v []string) {
	o.RmTag = &v
}

// GetRotationInterval returns the RotationInterval field value if set, zero value otherwise.
func (o *UpdateManagedKey) GetRotationInterval() string {
	if o == nil || o.RotationInterval == nil {
		var ret string
		return ret
	}
	return *o.RotationInterval
}

// GetRotationIntervalOk returns a tuple with the RotationInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateManagedKey) GetRotationIntervalOk() (*string, bool) {
	if o == nil || o.RotationInterval == nil {
		return nil, false
	}
	return o.RotationInterval, true
}

// HasRotationInterval returns a boolean if a field has been set.
func (o *UpdateManagedKey) HasRotationInterval() bool {
	if o != nil && o.RotationInterval != nil {
		return true
	}

	return false
}

// SetRotationInterval gets a reference to the given string and assigns it to the RotationInterval field.
func (o *UpdateManagedKey) SetRotationInterval(v string) {
	o.RotationInterval = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *UpdateManagedKey) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateManagedKey) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *UpdateManagedKey) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *UpdateManagedKey) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UpdateManagedKey) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateManagedKey) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UpdateManagedKey) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UpdateManagedKey) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUpdateUrl returns the UpdateUrl field value if set, zero value otherwise.
func (o *UpdateManagedKey) GetUpdateUrl() string {
	if o == nil || o.UpdateUrl == nil {
		var ret string
		return ret
	}
	return *o.UpdateUrl
}

// GetUpdateUrlOk returns a tuple with the UpdateUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateManagedKey) GetUpdateUrlOk() (*string, bool) {
	if o == nil || o.UpdateUrl == nil {
		return nil, false
	}
	return o.UpdateUrl, true
}

// HasUpdateUrl returns a boolean if a field has been set.
func (o *UpdateManagedKey) HasUpdateUrl() bool {
	if o != nil && o.UpdateUrl != nil {
		return true
	}

	return false
}

// SetUpdateUrl gets a reference to the given string and assigns it to the UpdateUrl field.
func (o *UpdateManagedKey) SetUpdateUrl(v string) {
	o.UpdateUrl = &v
}

func (o UpdateManagedKey) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AddTag != nil {
		toSerialize["add-tag"] = o.AddTag
	}
	if o.AutoRotate != nil {
		toSerialize["auto-rotate"] = o.AutoRotate
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewMetadata != nil {
		toSerialize["new-metadata"] = o.NewMetadata
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.RmTag != nil {
		toSerialize["rm-tag"] = o.RmTag
	}
	if o.RotationInterval != nil {
		toSerialize["rotation-interval"] = o.RotationInterval
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UpdateUrl != nil {
		toSerialize["update-url"] = o.UpdateUrl
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateManagedKey struct {
	value *UpdateManagedKey
	isSet bool
}

func (v NullableUpdateManagedKey) Get() *UpdateManagedKey {
	return v.value
}

func (v *NullableUpdateManagedKey) Set(val *UpdateManagedKey) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateManagedKey) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateManagedKey) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateManagedKey(val *UpdateManagedKey) *NullableUpdateManagedKey {
	return &NullableUpdateManagedKey{value: val, isSet: true}
}

func (v NullableUpdateManagedKey) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateManagedKey) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


