/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UpdateGlobalSignAtlasTarget updateGlobalSignAtlasTarget is a command that updates an existing target. [Deprecated: Use target-update-globalsign-atlas command]
type UpdateGlobalSignAtlasTarget struct {
	// API Key of the GlobalSign Atlas account
	ApiKey string `json:"api-key"`
	// API Secret of the GlobalSign Atlas account
	ApiSecret string `json:"api-secret"`
	// Deprecated - use description
	Comment *string `json:"comment,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Whether to keep previous version [true/false]. If not set, use default according to account settings
	KeepPrevVersion *string `json:"keep-prev-version,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Mutual TLS Certificate contents of the GlobalSign Atlas account encoded in base64, either mtls-cert-file-path or mtls-cert-data-base64 must be supplied
	MtlsCertDataBase64 *string `json:"mtls-cert-data-base64,omitempty"`
	// Mutual TLS Key contents of the GlobalSign Atlas account encoded in base64, either mtls-key-file-path or mtls-data-base64 must be supplied
	MtlsKeyDataBase64 *string `json:"mtls-key-data-base64,omitempty"`
	// Target name
	Name string `json:"name"`
	// New target name
	NewName *string `json:"new-name,omitempty"`
	// Timeout waiting for certificate validation in Duration format (1h - 1 Hour, 20m - 20 Minutes, 33m3s - 33 Minutes and 3 Seconds), maximum 1h.
	Timeout *string `json:"timeout,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Deprecated
	UpdateVersion *bool `json:"update-version,omitempty"`
}

// NewUpdateGlobalSignAtlasTarget instantiates a new UpdateGlobalSignAtlasTarget object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateGlobalSignAtlasTarget(apiKey string, apiSecret string, name string, ) *UpdateGlobalSignAtlasTarget {
	this := UpdateGlobalSignAtlasTarget{}
	this.ApiKey = apiKey
	this.ApiSecret = apiSecret
	var json bool = false
	this.Json = &json
	this.Name = name
	var timeout string = "5m"
	this.Timeout = &timeout
	return &this
}

// NewUpdateGlobalSignAtlasTargetWithDefaults instantiates a new UpdateGlobalSignAtlasTarget object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateGlobalSignAtlasTargetWithDefaults() *UpdateGlobalSignAtlasTarget {
	this := UpdateGlobalSignAtlasTarget{}
	var json bool = false
	this.Json = &json
	var timeout string = "5m"
	this.Timeout = &timeout
	return &this
}

// GetApiKey returns the ApiKey field value
func (o *UpdateGlobalSignAtlasTarget) GetApiKey() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ApiKey
}

// GetApiKeyOk returns a tuple with the ApiKey field value
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetApiKeyOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ApiKey, true
}

// SetApiKey sets field value
func (o *UpdateGlobalSignAtlasTarget) SetApiKey(v string) {
	o.ApiKey = v
}

// GetApiSecret returns the ApiSecret field value
func (o *UpdateGlobalSignAtlasTarget) GetApiSecret() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ApiSecret
}

// GetApiSecretOk returns a tuple with the ApiSecret field value
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetApiSecretOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ApiSecret, true
}

// SetApiSecret sets field value
func (o *UpdateGlobalSignAtlasTarget) SetApiSecret(v string) {
	o.ApiSecret = v
}

// GetComment returns the Comment field value if set, zero value otherwise.
func (o *UpdateGlobalSignAtlasTarget) GetComment() string {
	if o == nil || o.Comment == nil {
		var ret string
		return ret
	}
	return *o.Comment
}

// GetCommentOk returns a tuple with the Comment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetCommentOk() (*string, bool) {
	if o == nil || o.Comment == nil {
		return nil, false
	}
	return o.Comment, true
}

// HasComment returns a boolean if a field has been set.
func (o *UpdateGlobalSignAtlasTarget) HasComment() bool {
	if o != nil && o.Comment != nil {
		return true
	}

	return false
}

// SetComment gets a reference to the given string and assigns it to the Comment field.
func (o *UpdateGlobalSignAtlasTarget) SetComment(v string) {
	o.Comment = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *UpdateGlobalSignAtlasTarget) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *UpdateGlobalSignAtlasTarget) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *UpdateGlobalSignAtlasTarget) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *UpdateGlobalSignAtlasTarget) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *UpdateGlobalSignAtlasTarget) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *UpdateGlobalSignAtlasTarget) SetJson(v bool) {
	o.Json = &v
}

// GetKeepPrevVersion returns the KeepPrevVersion field value if set, zero value otherwise.
func (o *UpdateGlobalSignAtlasTarget) GetKeepPrevVersion() string {
	if o == nil || o.KeepPrevVersion == nil {
		var ret string
		return ret
	}
	return *o.KeepPrevVersion
}

// GetKeepPrevVersionOk returns a tuple with the KeepPrevVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetKeepPrevVersionOk() (*string, bool) {
	if o == nil || o.KeepPrevVersion == nil {
		return nil, false
	}
	return o.KeepPrevVersion, true
}

// HasKeepPrevVersion returns a boolean if a field has been set.
func (o *UpdateGlobalSignAtlasTarget) HasKeepPrevVersion() bool {
	if o != nil && o.KeepPrevVersion != nil {
		return true
	}

	return false
}

// SetKeepPrevVersion gets a reference to the given string and assigns it to the KeepPrevVersion field.
func (o *UpdateGlobalSignAtlasTarget) SetKeepPrevVersion(v string) {
	o.KeepPrevVersion = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *UpdateGlobalSignAtlasTarget) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *UpdateGlobalSignAtlasTarget) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *UpdateGlobalSignAtlasTarget) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *UpdateGlobalSignAtlasTarget) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *UpdateGlobalSignAtlasTarget) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *UpdateGlobalSignAtlasTarget) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetMtlsCertDataBase64 returns the MtlsCertDataBase64 field value if set, zero value otherwise.
func (o *UpdateGlobalSignAtlasTarget) GetMtlsCertDataBase64() string {
	if o == nil || o.MtlsCertDataBase64 == nil {
		var ret string
		return ret
	}
	return *o.MtlsCertDataBase64
}

// GetMtlsCertDataBase64Ok returns a tuple with the MtlsCertDataBase64 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetMtlsCertDataBase64Ok() (*string, bool) {
	if o == nil || o.MtlsCertDataBase64 == nil {
		return nil, false
	}
	return o.MtlsCertDataBase64, true
}

// HasMtlsCertDataBase64 returns a boolean if a field has been set.
func (o *UpdateGlobalSignAtlasTarget) HasMtlsCertDataBase64() bool {
	if o != nil && o.MtlsCertDataBase64 != nil {
		return true
	}

	return false
}

// SetMtlsCertDataBase64 gets a reference to the given string and assigns it to the MtlsCertDataBase64 field.
func (o *UpdateGlobalSignAtlasTarget) SetMtlsCertDataBase64(v string) {
	o.MtlsCertDataBase64 = &v
}

// GetMtlsKeyDataBase64 returns the MtlsKeyDataBase64 field value if set, zero value otherwise.
func (o *UpdateGlobalSignAtlasTarget) GetMtlsKeyDataBase64() string {
	if o == nil || o.MtlsKeyDataBase64 == nil {
		var ret string
		return ret
	}
	return *o.MtlsKeyDataBase64
}

// GetMtlsKeyDataBase64Ok returns a tuple with the MtlsKeyDataBase64 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetMtlsKeyDataBase64Ok() (*string, bool) {
	if o == nil || o.MtlsKeyDataBase64 == nil {
		return nil, false
	}
	return o.MtlsKeyDataBase64, true
}

// HasMtlsKeyDataBase64 returns a boolean if a field has been set.
func (o *UpdateGlobalSignAtlasTarget) HasMtlsKeyDataBase64() bool {
	if o != nil && o.MtlsKeyDataBase64 != nil {
		return true
	}

	return false
}

// SetMtlsKeyDataBase64 gets a reference to the given string and assigns it to the MtlsKeyDataBase64 field.
func (o *UpdateGlobalSignAtlasTarget) SetMtlsKeyDataBase64(v string) {
	o.MtlsKeyDataBase64 = &v
}

// GetName returns the Name field value
func (o *UpdateGlobalSignAtlasTarget) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *UpdateGlobalSignAtlasTarget) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *UpdateGlobalSignAtlasTarget) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *UpdateGlobalSignAtlasTarget) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *UpdateGlobalSignAtlasTarget) SetNewName(v string) {
	o.NewName = &v
}

// GetTimeout returns the Timeout field value if set, zero value otherwise.
func (o *UpdateGlobalSignAtlasTarget) GetTimeout() string {
	if o == nil || o.Timeout == nil {
		var ret string
		return ret
	}
	return *o.Timeout
}

// GetTimeoutOk returns a tuple with the Timeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetTimeoutOk() (*string, bool) {
	if o == nil || o.Timeout == nil {
		return nil, false
	}
	return o.Timeout, true
}

// HasTimeout returns a boolean if a field has been set.
func (o *UpdateGlobalSignAtlasTarget) HasTimeout() bool {
	if o != nil && o.Timeout != nil {
		return true
	}

	return false
}

// SetTimeout gets a reference to the given string and assigns it to the Timeout field.
func (o *UpdateGlobalSignAtlasTarget) SetTimeout(v string) {
	o.Timeout = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *UpdateGlobalSignAtlasTarget) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *UpdateGlobalSignAtlasTarget) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *UpdateGlobalSignAtlasTarget) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UpdateGlobalSignAtlasTarget) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UpdateGlobalSignAtlasTarget) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UpdateGlobalSignAtlasTarget) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUpdateVersion returns the UpdateVersion field value if set, zero value otherwise.
func (o *UpdateGlobalSignAtlasTarget) GetUpdateVersion() bool {
	if o == nil || o.UpdateVersion == nil {
		var ret bool
		return ret
	}
	return *o.UpdateVersion
}

// GetUpdateVersionOk returns a tuple with the UpdateVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGlobalSignAtlasTarget) GetUpdateVersionOk() (*bool, bool) {
	if o == nil || o.UpdateVersion == nil {
		return nil, false
	}
	return o.UpdateVersion, true
}

// HasUpdateVersion returns a boolean if a field has been set.
func (o *UpdateGlobalSignAtlasTarget) HasUpdateVersion() bool {
	if o != nil && o.UpdateVersion != nil {
		return true
	}

	return false
}

// SetUpdateVersion gets a reference to the given bool and assigns it to the UpdateVersion field.
func (o *UpdateGlobalSignAtlasTarget) SetUpdateVersion(v bool) {
	o.UpdateVersion = &v
}

func (o UpdateGlobalSignAtlasTarget) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["api-key"] = o.ApiKey
	}
	if true {
		toSerialize["api-secret"] = o.ApiSecret
	}
	if o.Comment != nil {
		toSerialize["comment"] = o.Comment
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.KeepPrevVersion != nil {
		toSerialize["keep-prev-version"] = o.KeepPrevVersion
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if o.MtlsCertDataBase64 != nil {
		toSerialize["mtls-cert-data-base64"] = o.MtlsCertDataBase64
	}
	if o.MtlsKeyDataBase64 != nil {
		toSerialize["mtls-key-data-base64"] = o.MtlsKeyDataBase64
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.Timeout != nil {
		toSerialize["timeout"] = o.Timeout
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UpdateVersion != nil {
		toSerialize["update-version"] = o.UpdateVersion
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateGlobalSignAtlasTarget struct {
	value *UpdateGlobalSignAtlasTarget
	isSet bool
}

func (v NullableUpdateGlobalSignAtlasTarget) Get() *UpdateGlobalSignAtlasTarget {
	return v.value
}

func (v *NullableUpdateGlobalSignAtlasTarget) Set(val *UpdateGlobalSignAtlasTarget) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateGlobalSignAtlasTarget) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateGlobalSignAtlasTarget) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateGlobalSignAtlasTarget(val *UpdateGlobalSignAtlasTarget) *NullableUpdateGlobalSignAtlasTarget {
	return &NullableUpdateGlobalSignAtlasTarget{value: val, isSet: true}
}

func (v NullableUpdateGlobalSignAtlasTarget) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateGlobalSignAtlasTarget) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


