/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UpdateGitlabTarget updateGitlabTarget is a command that updates an existing target. [Deprecated: Use target-update-gitlab command]
type UpdateGitlabTarget struct {
	// Deprecated - use description
	Comment *string `json:"comment,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Gitlab access token
	GitlabAccessToken *string `json:"gitlab-access-token,omitempty"`
	// Gitlab tls certificate (base64 encoded)
	GitlabCertificate *string `json:"gitlab-certificate,omitempty"`
	// Gitlab base url
	GitlabUrl *string `json:"gitlab-url,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Whether to keep previous version [true/false]. If not set, use default according to account settings
	KeepPrevVersion *string `json:"keep-prev-version,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// New target name
	NewName *string `json:"new-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Deprecated
	UpdateVersion *bool `json:"update-version,omitempty"`
}

// NewUpdateGitlabTarget instantiates a new UpdateGitlabTarget object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateGitlabTarget(name string, ) *UpdateGitlabTarget {
	this := UpdateGitlabTarget{}
	var gitlabUrl string = "https://gitlab.com/"
	this.GitlabUrl = &gitlabUrl
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewUpdateGitlabTargetWithDefaults instantiates a new UpdateGitlabTarget object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateGitlabTargetWithDefaults() *UpdateGitlabTarget {
	this := UpdateGitlabTarget{}
	var gitlabUrl string = "https://gitlab.com/"
	this.GitlabUrl = &gitlabUrl
	var json bool = false
	this.Json = &json
	return &this
}

// GetComment returns the Comment field value if set, zero value otherwise.
func (o *UpdateGitlabTarget) GetComment() string {
	if o == nil || o.Comment == nil {
		var ret string
		return ret
	}
	return *o.Comment
}

// GetCommentOk returns a tuple with the Comment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetCommentOk() (*string, bool) {
	if o == nil || o.Comment == nil {
		return nil, false
	}
	return o.Comment, true
}

// HasComment returns a boolean if a field has been set.
func (o *UpdateGitlabTarget) HasComment() bool {
	if o != nil && o.Comment != nil {
		return true
	}

	return false
}

// SetComment gets a reference to the given string and assigns it to the Comment field.
func (o *UpdateGitlabTarget) SetComment(v string) {
	o.Comment = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *UpdateGitlabTarget) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *UpdateGitlabTarget) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *UpdateGitlabTarget) SetDescription(v string) {
	o.Description = &v
}

// GetGitlabAccessToken returns the GitlabAccessToken field value if set, zero value otherwise.
func (o *UpdateGitlabTarget) GetGitlabAccessToken() string {
	if o == nil || o.GitlabAccessToken == nil {
		var ret string
		return ret
	}
	return *o.GitlabAccessToken
}

// GetGitlabAccessTokenOk returns a tuple with the GitlabAccessToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetGitlabAccessTokenOk() (*string, bool) {
	if o == nil || o.GitlabAccessToken == nil {
		return nil, false
	}
	return o.GitlabAccessToken, true
}

// HasGitlabAccessToken returns a boolean if a field has been set.
func (o *UpdateGitlabTarget) HasGitlabAccessToken() bool {
	if o != nil && o.GitlabAccessToken != nil {
		return true
	}

	return false
}

// SetGitlabAccessToken gets a reference to the given string and assigns it to the GitlabAccessToken field.
func (o *UpdateGitlabTarget) SetGitlabAccessToken(v string) {
	o.GitlabAccessToken = &v
}

// GetGitlabCertificate returns the GitlabCertificate field value if set, zero value otherwise.
func (o *UpdateGitlabTarget) GetGitlabCertificate() string {
	if o == nil || o.GitlabCertificate == nil {
		var ret string
		return ret
	}
	return *o.GitlabCertificate
}

// GetGitlabCertificateOk returns a tuple with the GitlabCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetGitlabCertificateOk() (*string, bool) {
	if o == nil || o.GitlabCertificate == nil {
		return nil, false
	}
	return o.GitlabCertificate, true
}

// HasGitlabCertificate returns a boolean if a field has been set.
func (o *UpdateGitlabTarget) HasGitlabCertificate() bool {
	if o != nil && o.GitlabCertificate != nil {
		return true
	}

	return false
}

// SetGitlabCertificate gets a reference to the given string and assigns it to the GitlabCertificate field.
func (o *UpdateGitlabTarget) SetGitlabCertificate(v string) {
	o.GitlabCertificate = &v
}

// GetGitlabUrl returns the GitlabUrl field value if set, zero value otherwise.
func (o *UpdateGitlabTarget) GetGitlabUrl() string {
	if o == nil || o.GitlabUrl == nil {
		var ret string
		return ret
	}
	return *o.GitlabUrl
}

// GetGitlabUrlOk returns a tuple with the GitlabUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetGitlabUrlOk() (*string, bool) {
	if o == nil || o.GitlabUrl == nil {
		return nil, false
	}
	return o.GitlabUrl, true
}

// HasGitlabUrl returns a boolean if a field has been set.
func (o *UpdateGitlabTarget) HasGitlabUrl() bool {
	if o != nil && o.GitlabUrl != nil {
		return true
	}

	return false
}

// SetGitlabUrl gets a reference to the given string and assigns it to the GitlabUrl field.
func (o *UpdateGitlabTarget) SetGitlabUrl(v string) {
	o.GitlabUrl = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *UpdateGitlabTarget) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *UpdateGitlabTarget) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *UpdateGitlabTarget) SetJson(v bool) {
	o.Json = &v
}

// GetKeepPrevVersion returns the KeepPrevVersion field value if set, zero value otherwise.
func (o *UpdateGitlabTarget) GetKeepPrevVersion() string {
	if o == nil || o.KeepPrevVersion == nil {
		var ret string
		return ret
	}
	return *o.KeepPrevVersion
}

// GetKeepPrevVersionOk returns a tuple with the KeepPrevVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetKeepPrevVersionOk() (*string, bool) {
	if o == nil || o.KeepPrevVersion == nil {
		return nil, false
	}
	return o.KeepPrevVersion, true
}

// HasKeepPrevVersion returns a boolean if a field has been set.
func (o *UpdateGitlabTarget) HasKeepPrevVersion() bool {
	if o != nil && o.KeepPrevVersion != nil {
		return true
	}

	return false
}

// SetKeepPrevVersion gets a reference to the given string and assigns it to the KeepPrevVersion field.
func (o *UpdateGitlabTarget) SetKeepPrevVersion(v string) {
	o.KeepPrevVersion = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *UpdateGitlabTarget) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *UpdateGitlabTarget) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *UpdateGitlabTarget) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *UpdateGitlabTarget) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *UpdateGitlabTarget) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *UpdateGitlabTarget) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *UpdateGitlabTarget) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *UpdateGitlabTarget) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *UpdateGitlabTarget) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *UpdateGitlabTarget) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *UpdateGitlabTarget) SetNewName(v string) {
	o.NewName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *UpdateGitlabTarget) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *UpdateGitlabTarget) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *UpdateGitlabTarget) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UpdateGitlabTarget) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UpdateGitlabTarget) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UpdateGitlabTarget) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUpdateVersion returns the UpdateVersion field value if set, zero value otherwise.
func (o *UpdateGitlabTarget) GetUpdateVersion() bool {
	if o == nil || o.UpdateVersion == nil {
		var ret bool
		return ret
	}
	return *o.UpdateVersion
}

// GetUpdateVersionOk returns a tuple with the UpdateVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGitlabTarget) GetUpdateVersionOk() (*bool, bool) {
	if o == nil || o.UpdateVersion == nil {
		return nil, false
	}
	return o.UpdateVersion, true
}

// HasUpdateVersion returns a boolean if a field has been set.
func (o *UpdateGitlabTarget) HasUpdateVersion() bool {
	if o != nil && o.UpdateVersion != nil {
		return true
	}

	return false
}

// SetUpdateVersion gets a reference to the given bool and assigns it to the UpdateVersion field.
func (o *UpdateGitlabTarget) SetUpdateVersion(v bool) {
	o.UpdateVersion = &v
}

func (o UpdateGitlabTarget) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Comment != nil {
		toSerialize["comment"] = o.Comment
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.GitlabAccessToken != nil {
		toSerialize["gitlab-access-token"] = o.GitlabAccessToken
	}
	if o.GitlabCertificate != nil {
		toSerialize["gitlab-certificate"] = o.GitlabCertificate
	}
	if o.GitlabUrl != nil {
		toSerialize["gitlab-url"] = o.GitlabUrl
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.KeepPrevVersion != nil {
		toSerialize["keep-prev-version"] = o.KeepPrevVersion
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UpdateVersion != nil {
		toSerialize["update-version"] = o.UpdateVersion
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateGitlabTarget struct {
	value *UpdateGitlabTarget
	isSet bool
}

func (v NullableUpdateGitlabTarget) Get() *UpdateGitlabTarget {
	return v.value
}

func (v *NullableUpdateGitlabTarget) Set(val *UpdateGitlabTarget) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateGitlabTarget) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateGitlabTarget) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateGitlabTarget(val *UpdateGitlabTarget) *NullableUpdateGitlabTarget {
	return &NullableUpdateGitlabTarget{value: val, isSet: true}
}

func (v NullableUpdateGitlabTarget) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateGitlabTarget) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


