/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// TargetCreateGitlab struct for TargetCreateGitlab
type TargetCreateGitlab struct {
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Gitlab access token
	GitlabAccessToken *string `json:"gitlab-access-token,omitempty"`
	// Gitlab tls certificate (base64 encoded)
	GitlabCertificate *string `json:"gitlab-certificate,omitempty"`
	// Gitlab base url
	GitlabUrl *string `json:"gitlab-url,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewTargetCreateGitlab instantiates a new TargetCreateGitlab object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetCreateGitlab(name string, ) *TargetCreateGitlab {
	this := TargetCreateGitlab{}
	var gitlabUrl string = "https://gitlab.com/"
	this.GitlabUrl = &gitlabUrl
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewTargetCreateGitlabWithDefaults instantiates a new TargetCreateGitlab object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetCreateGitlabWithDefaults() *TargetCreateGitlab {
	this := TargetCreateGitlab{}
	var gitlabUrl string = "https://gitlab.com/"
	this.GitlabUrl = &gitlabUrl
	var json bool = false
	this.Json = &json
	return &this
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *TargetCreateGitlab) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGitlab) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *TargetCreateGitlab) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *TargetCreateGitlab) SetDescription(v string) {
	o.Description = &v
}

// GetGitlabAccessToken returns the GitlabAccessToken field value if set, zero value otherwise.
func (o *TargetCreateGitlab) GetGitlabAccessToken() string {
	if o == nil || o.GitlabAccessToken == nil {
		var ret string
		return ret
	}
	return *o.GitlabAccessToken
}

// GetGitlabAccessTokenOk returns a tuple with the GitlabAccessToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGitlab) GetGitlabAccessTokenOk() (*string, bool) {
	if o == nil || o.GitlabAccessToken == nil {
		return nil, false
	}
	return o.GitlabAccessToken, true
}

// HasGitlabAccessToken returns a boolean if a field has been set.
func (o *TargetCreateGitlab) HasGitlabAccessToken() bool {
	if o != nil && o.GitlabAccessToken != nil {
		return true
	}

	return false
}

// SetGitlabAccessToken gets a reference to the given string and assigns it to the GitlabAccessToken field.
func (o *TargetCreateGitlab) SetGitlabAccessToken(v string) {
	o.GitlabAccessToken = &v
}

// GetGitlabCertificate returns the GitlabCertificate field value if set, zero value otherwise.
func (o *TargetCreateGitlab) GetGitlabCertificate() string {
	if o == nil || o.GitlabCertificate == nil {
		var ret string
		return ret
	}
	return *o.GitlabCertificate
}

// GetGitlabCertificateOk returns a tuple with the GitlabCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGitlab) GetGitlabCertificateOk() (*string, bool) {
	if o == nil || o.GitlabCertificate == nil {
		return nil, false
	}
	return o.GitlabCertificate, true
}

// HasGitlabCertificate returns a boolean if a field has been set.
func (o *TargetCreateGitlab) HasGitlabCertificate() bool {
	if o != nil && o.GitlabCertificate != nil {
		return true
	}

	return false
}

// SetGitlabCertificate gets a reference to the given string and assigns it to the GitlabCertificate field.
func (o *TargetCreateGitlab) SetGitlabCertificate(v string) {
	o.GitlabCertificate = &v
}

// GetGitlabUrl returns the GitlabUrl field value if set, zero value otherwise.
func (o *TargetCreateGitlab) GetGitlabUrl() string {
	if o == nil || o.GitlabUrl == nil {
		var ret string
		return ret
	}
	return *o.GitlabUrl
}

// GetGitlabUrlOk returns a tuple with the GitlabUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGitlab) GetGitlabUrlOk() (*string, bool) {
	if o == nil || o.GitlabUrl == nil {
		return nil, false
	}
	return o.GitlabUrl, true
}

// HasGitlabUrl returns a boolean if a field has been set.
func (o *TargetCreateGitlab) HasGitlabUrl() bool {
	if o != nil && o.GitlabUrl != nil {
		return true
	}

	return false
}

// SetGitlabUrl gets a reference to the given string and assigns it to the GitlabUrl field.
func (o *TargetCreateGitlab) SetGitlabUrl(v string) {
	o.GitlabUrl = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *TargetCreateGitlab) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGitlab) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *TargetCreateGitlab) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *TargetCreateGitlab) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *TargetCreateGitlab) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGitlab) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *TargetCreateGitlab) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *TargetCreateGitlab) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *TargetCreateGitlab) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGitlab) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *TargetCreateGitlab) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *TargetCreateGitlab) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *TargetCreateGitlab) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *TargetCreateGitlab) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *TargetCreateGitlab) SetName(v string) {
	o.Name = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *TargetCreateGitlab) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGitlab) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *TargetCreateGitlab) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *TargetCreateGitlab) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *TargetCreateGitlab) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGitlab) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *TargetCreateGitlab) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *TargetCreateGitlab) SetUidToken(v string) {
	o.UidToken = &v
}

func (o TargetCreateGitlab) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.GitlabAccessToken != nil {
		toSerialize["gitlab-access-token"] = o.GitlabAccessToken
	}
	if o.GitlabCertificate != nil {
		toSerialize["gitlab-certificate"] = o.GitlabCertificate
	}
	if o.GitlabUrl != nil {
		toSerialize["gitlab-url"] = o.GitlabUrl
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableTargetCreateGitlab struct {
	value *TargetCreateGitlab
	isSet bool
}

func (v NullableTargetCreateGitlab) Get() *TargetCreateGitlab {
	return v.value
}

func (v *NullableTargetCreateGitlab) Set(val *TargetCreateGitlab) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetCreateGitlab) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetCreateGitlab) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetCreateGitlab(val *TargetCreateGitlab) *NullableTargetCreateGitlab {
	return &NullableTargetCreateGitlab{value: val, isSet: true}
}

func (v NullableTargetCreateGitlab) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetCreateGitlab) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


