/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// SmInfo struct for SmInfo
type SmInfo struct {
	Sla *string `json:"sla,omitempty"`
	// Tier represents a level of extensibility the account will have, defined by various limits for different resources of Akeyless e.g - A StarterTier may have a limit of 3 Client resources and 50 Secret resources
	Tier *string `json:"tier,omitempty"`
}

// NewSmInfo instantiates a new SmInfo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSmInfo() *SmInfo {
	this := SmInfo{}
	return &this
}

// NewSmInfoWithDefaults instantiates a new SmInfo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSmInfoWithDefaults() *SmInfo {
	this := SmInfo{}
	return &this
}

// GetSla returns the Sla field value if set, zero value otherwise.
func (o *SmInfo) GetSla() string {
	if o == nil || o.Sla == nil {
		var ret string
		return ret
	}
	return *o.Sla
}

// GetSlaOk returns a tuple with the Sla field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SmInfo) GetSlaOk() (*string, bool) {
	if o == nil || o.Sla == nil {
		return nil, false
	}
	return o.Sla, true
}

// HasSla returns a boolean if a field has been set.
func (o *SmInfo) HasSla() bool {
	if o != nil && o.Sla != nil {
		return true
	}

	return false
}

// SetSla gets a reference to the given string and assigns it to the Sla field.
func (o *SmInfo) SetSla(v string) {
	o.Sla = &v
}

// GetTier returns the Tier field value if set, zero value otherwise.
func (o *SmInfo) GetTier() string {
	if o == nil || o.Tier == nil {
		var ret string
		return ret
	}
	return *o.Tier
}

// GetTierOk returns a tuple with the Tier field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SmInfo) GetTierOk() (*string, bool) {
	if o == nil || o.Tier == nil {
		return nil, false
	}
	return o.Tier, true
}

// HasTier returns a boolean if a field has been set.
func (o *SmInfo) HasTier() bool {
	if o != nil && o.Tier != nil {
		return true
	}

	return false
}

// SetTier gets a reference to the given string and assigns it to the Tier field.
func (o *SmInfo) SetTier(v string) {
	o.Tier = &v
}

func (o SmInfo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Sla != nil {
		toSerialize["sla"] = o.Sla
	}
	if o.Tier != nil {
		toSerialize["tier"] = o.Tier
	}
	return json.Marshal(toSerialize)
}

type NullableSmInfo struct {
	value *SmInfo
	isSet bool
}

func (v NullableSmInfo) Get() *SmInfo {
	return v.value
}

func (v *NullableSmInfo) Set(val *SmInfo) {
	v.value = val
	v.isSet = true
}

func (v NullableSmInfo) IsSet() bool {
	return v.isSet
}

func (v *NullableSmInfo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSmInfo(val *SmInfo) *NullableSmInfo {
	return &NullableSmInfo{value: val, isSet: true}
}

func (v NullableSmInfo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSmInfo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


