/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// SignDataWithClassicKey struct for SignDataWithClassicKey
type SignDataWithClassicKey struct {
	// Data
	Data string `json:"data"`
	// The name of the key to use in the sign data process
	DisplayId string `json:"display-id"`
	// Defines whether the data should be hashed as part of the signing. If true, the data will not be hashed
	Hashed *bool `json:"hashed,omitempty"`
	// HashingMethod
	HashingMethod *string `json:"hashing-method,omitempty"`
	// Retrieve the Secret value without checking the Gateway's cache [true/false]. This flag is only relevant when using the RestAPI
	IgnoreCache *string `json:"ignore-cache,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// ClassicKey name
	Name string `json:"name"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// classic key version
	Version int32 `json:"version"`
}

// NewSignDataWithClassicKey instantiates a new SignDataWithClassicKey object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSignDataWithClassicKey(data string, displayId string, name string, version int32, ) *SignDataWithClassicKey {
	this := SignDataWithClassicKey{}
	this.Data = data
	this.DisplayId = displayId
	var hashed bool = false
	this.Hashed = &hashed
	var hashingMethod string = "SHA256"
	this.HashingMethod = &hashingMethod
	var ignoreCache string = "false"
	this.IgnoreCache = &ignoreCache
	var json bool = false
	this.Json = &json
	this.Name = name
	this.Version = version
	return &this
}

// NewSignDataWithClassicKeyWithDefaults instantiates a new SignDataWithClassicKey object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSignDataWithClassicKeyWithDefaults() *SignDataWithClassicKey {
	this := SignDataWithClassicKey{}
	var hashed bool = false
	this.Hashed = &hashed
	var hashingMethod string = "SHA256"
	this.HashingMethod = &hashingMethod
	var ignoreCache string = "false"
	this.IgnoreCache = &ignoreCache
	var json bool = false
	this.Json = &json
	return &this
}

// GetData returns the Data field value
func (o *SignDataWithClassicKey) GetData() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Data
}

// GetDataOk returns a tuple with the Data field value
// and a boolean to check if the value has been set.
func (o *SignDataWithClassicKey) GetDataOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Data, true
}

// SetData sets field value
func (o *SignDataWithClassicKey) SetData(v string) {
	o.Data = v
}

// GetDisplayId returns the DisplayId field value
func (o *SignDataWithClassicKey) GetDisplayId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.DisplayId
}

// GetDisplayIdOk returns a tuple with the DisplayId field value
// and a boolean to check if the value has been set.
func (o *SignDataWithClassicKey) GetDisplayIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.DisplayId, true
}

// SetDisplayId sets field value
func (o *SignDataWithClassicKey) SetDisplayId(v string) {
	o.DisplayId = v
}

// GetHashed returns the Hashed field value if set, zero value otherwise.
func (o *SignDataWithClassicKey) GetHashed() bool {
	if o == nil || o.Hashed == nil {
		var ret bool
		return ret
	}
	return *o.Hashed
}

// GetHashedOk returns a tuple with the Hashed field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignDataWithClassicKey) GetHashedOk() (*bool, bool) {
	if o == nil || o.Hashed == nil {
		return nil, false
	}
	return o.Hashed, true
}

// HasHashed returns a boolean if a field has been set.
func (o *SignDataWithClassicKey) HasHashed() bool {
	if o != nil && o.Hashed != nil {
		return true
	}

	return false
}

// SetHashed gets a reference to the given bool and assigns it to the Hashed field.
func (o *SignDataWithClassicKey) SetHashed(v bool) {
	o.Hashed = &v
}

// GetHashingMethod returns the HashingMethod field value if set, zero value otherwise.
func (o *SignDataWithClassicKey) GetHashingMethod() string {
	if o == nil || o.HashingMethod == nil {
		var ret string
		return ret
	}
	return *o.HashingMethod
}

// GetHashingMethodOk returns a tuple with the HashingMethod field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignDataWithClassicKey) GetHashingMethodOk() (*string, bool) {
	if o == nil || o.HashingMethod == nil {
		return nil, false
	}
	return o.HashingMethod, true
}

// HasHashingMethod returns a boolean if a field has been set.
func (o *SignDataWithClassicKey) HasHashingMethod() bool {
	if o != nil && o.HashingMethod != nil {
		return true
	}

	return false
}

// SetHashingMethod gets a reference to the given string and assigns it to the HashingMethod field.
func (o *SignDataWithClassicKey) SetHashingMethod(v string) {
	o.HashingMethod = &v
}

// GetIgnoreCache returns the IgnoreCache field value if set, zero value otherwise.
func (o *SignDataWithClassicKey) GetIgnoreCache() string {
	if o == nil || o.IgnoreCache == nil {
		var ret string
		return ret
	}
	return *o.IgnoreCache
}

// GetIgnoreCacheOk returns a tuple with the IgnoreCache field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignDataWithClassicKey) GetIgnoreCacheOk() (*string, bool) {
	if o == nil || o.IgnoreCache == nil {
		return nil, false
	}
	return o.IgnoreCache, true
}

// HasIgnoreCache returns a boolean if a field has been set.
func (o *SignDataWithClassicKey) HasIgnoreCache() bool {
	if o != nil && o.IgnoreCache != nil {
		return true
	}

	return false
}

// SetIgnoreCache gets a reference to the given string and assigns it to the IgnoreCache field.
func (o *SignDataWithClassicKey) SetIgnoreCache(v string) {
	o.IgnoreCache = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *SignDataWithClassicKey) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignDataWithClassicKey) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *SignDataWithClassicKey) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *SignDataWithClassicKey) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *SignDataWithClassicKey) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *SignDataWithClassicKey) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *SignDataWithClassicKey) SetName(v string) {
	o.Name = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *SignDataWithClassicKey) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignDataWithClassicKey) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *SignDataWithClassicKey) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *SignDataWithClassicKey) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *SignDataWithClassicKey) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignDataWithClassicKey) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *SignDataWithClassicKey) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *SignDataWithClassicKey) SetUidToken(v string) {
	o.UidToken = &v
}

// GetVersion returns the Version field value
func (o *SignDataWithClassicKey) GetVersion() int32 {
	if o == nil  {
		var ret int32
		return ret
	}

	return o.Version
}

// GetVersionOk returns a tuple with the Version field value
// and a boolean to check if the value has been set.
func (o *SignDataWithClassicKey) GetVersionOk() (*int32, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Version, true
}

// SetVersion sets field value
func (o *SignDataWithClassicKey) SetVersion(v int32) {
	o.Version = v
}

func (o SignDataWithClassicKey) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["data"] = o.Data
	}
	if true {
		toSerialize["display-id"] = o.DisplayId
	}
	if o.Hashed != nil {
		toSerialize["hashed"] = o.Hashed
	}
	if o.HashingMethod != nil {
		toSerialize["hashing-method"] = o.HashingMethod
	}
	if o.IgnoreCache != nil {
		toSerialize["ignore-cache"] = o.IgnoreCache
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if true {
		toSerialize["version"] = o.Version
	}
	return json.Marshal(toSerialize)
}

type NullableSignDataWithClassicKey struct {
	value *SignDataWithClassicKey
	isSet bool
}

func (v NullableSignDataWithClassicKey) Get() *SignDataWithClassicKey {
	return v.value
}

func (v *NullableSignDataWithClassicKey) Set(val *SignDataWithClassicKey) {
	v.value = val
	v.isSet = true
}

func (v NullableSignDataWithClassicKey) IsSet() bool {
	return v.isSet
}

func (v *NullableSignDataWithClassicKey) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSignDataWithClassicKey(val *SignDataWithClassicKey) *NullableSignDataWithClassicKey {
	return &NullableSignDataWithClassicKey{value: val, isSet: true}
}

func (v NullableSignDataWithClassicKey) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSignDataWithClassicKey) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


