/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// SAMLAccessRules struct for SAMLAccessRules
type SAMLAccessRules struct {
	// Allowed redirect URIs after the authentication
	AllowedRedirectURIs *[]string `json:"allowed_redirect_URIs,omitempty"`
	// The attributes that login is restricted to.
	BoundAttributes *[]SAMLAttribute `json:"bound_attributes,omitempty"`
	// IDP metadata url
	IdpMetadataUrl *string `json:"idp_metadata_url,omitempty"`
	// IDP metadata XML
	IdpMetadataXml *string `json:"idp_metadata_xml,omitempty"`
	// A unique identifier to distinguish different users
	UniqueIdentifier *string `json:"unique_identifier,omitempty"`
}

// NewSAMLAccessRules instantiates a new SAMLAccessRules object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSAMLAccessRules() *SAMLAccessRules {
	this := SAMLAccessRules{}
	return &this
}

// NewSAMLAccessRulesWithDefaults instantiates a new SAMLAccessRules object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSAMLAccessRulesWithDefaults() *SAMLAccessRules {
	this := SAMLAccessRules{}
	return &this
}

// GetAllowedRedirectURIs returns the AllowedRedirectURIs field value if set, zero value otherwise.
func (o *SAMLAccessRules) GetAllowedRedirectURIs() []string {
	if o == nil || o.AllowedRedirectURIs == nil {
		var ret []string
		return ret
	}
	return *o.AllowedRedirectURIs
}

// GetAllowedRedirectURIsOk returns a tuple with the AllowedRedirectURIs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SAMLAccessRules) GetAllowedRedirectURIsOk() (*[]string, bool) {
	if o == nil || o.AllowedRedirectURIs == nil {
		return nil, false
	}
	return o.AllowedRedirectURIs, true
}

// HasAllowedRedirectURIs returns a boolean if a field has been set.
func (o *SAMLAccessRules) HasAllowedRedirectURIs() bool {
	if o != nil && o.AllowedRedirectURIs != nil {
		return true
	}

	return false
}

// SetAllowedRedirectURIs gets a reference to the given []string and assigns it to the AllowedRedirectURIs field.
func (o *SAMLAccessRules) SetAllowedRedirectURIs(v []string) {
	o.AllowedRedirectURIs = &v
}

// GetBoundAttributes returns the BoundAttributes field value if set, zero value otherwise.
func (o *SAMLAccessRules) GetBoundAttributes() []SAMLAttribute {
	if o == nil || o.BoundAttributes == nil {
		var ret []SAMLAttribute
		return ret
	}
	return *o.BoundAttributes
}

// GetBoundAttributesOk returns a tuple with the BoundAttributes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SAMLAccessRules) GetBoundAttributesOk() (*[]SAMLAttribute, bool) {
	if o == nil || o.BoundAttributes == nil {
		return nil, false
	}
	return o.BoundAttributes, true
}

// HasBoundAttributes returns a boolean if a field has been set.
func (o *SAMLAccessRules) HasBoundAttributes() bool {
	if o != nil && o.BoundAttributes != nil {
		return true
	}

	return false
}

// SetBoundAttributes gets a reference to the given []SAMLAttribute and assigns it to the BoundAttributes field.
func (o *SAMLAccessRules) SetBoundAttributes(v []SAMLAttribute) {
	o.BoundAttributes = &v
}

// GetIdpMetadataUrl returns the IdpMetadataUrl field value if set, zero value otherwise.
func (o *SAMLAccessRules) GetIdpMetadataUrl() string {
	if o == nil || o.IdpMetadataUrl == nil {
		var ret string
		return ret
	}
	return *o.IdpMetadataUrl
}

// GetIdpMetadataUrlOk returns a tuple with the IdpMetadataUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SAMLAccessRules) GetIdpMetadataUrlOk() (*string, bool) {
	if o == nil || o.IdpMetadataUrl == nil {
		return nil, false
	}
	return o.IdpMetadataUrl, true
}

// HasIdpMetadataUrl returns a boolean if a field has been set.
func (o *SAMLAccessRules) HasIdpMetadataUrl() bool {
	if o != nil && o.IdpMetadataUrl != nil {
		return true
	}

	return false
}

// SetIdpMetadataUrl gets a reference to the given string and assigns it to the IdpMetadataUrl field.
func (o *SAMLAccessRules) SetIdpMetadataUrl(v string) {
	o.IdpMetadataUrl = &v
}

// GetIdpMetadataXml returns the IdpMetadataXml field value if set, zero value otherwise.
func (o *SAMLAccessRules) GetIdpMetadataXml() string {
	if o == nil || o.IdpMetadataXml == nil {
		var ret string
		return ret
	}
	return *o.IdpMetadataXml
}

// GetIdpMetadataXmlOk returns a tuple with the IdpMetadataXml field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SAMLAccessRules) GetIdpMetadataXmlOk() (*string, bool) {
	if o == nil || o.IdpMetadataXml == nil {
		return nil, false
	}
	return o.IdpMetadataXml, true
}

// HasIdpMetadataXml returns a boolean if a field has been set.
func (o *SAMLAccessRules) HasIdpMetadataXml() bool {
	if o != nil && o.IdpMetadataXml != nil {
		return true
	}

	return false
}

// SetIdpMetadataXml gets a reference to the given string and assigns it to the IdpMetadataXml field.
func (o *SAMLAccessRules) SetIdpMetadataXml(v string) {
	o.IdpMetadataXml = &v
}

// GetUniqueIdentifier returns the UniqueIdentifier field value if set, zero value otherwise.
func (o *SAMLAccessRules) GetUniqueIdentifier() string {
	if o == nil || o.UniqueIdentifier == nil {
		var ret string
		return ret
	}
	return *o.UniqueIdentifier
}

// GetUniqueIdentifierOk returns a tuple with the UniqueIdentifier field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SAMLAccessRules) GetUniqueIdentifierOk() (*string, bool) {
	if o == nil || o.UniqueIdentifier == nil {
		return nil, false
	}
	return o.UniqueIdentifier, true
}

// HasUniqueIdentifier returns a boolean if a field has been set.
func (o *SAMLAccessRules) HasUniqueIdentifier() bool {
	if o != nil && o.UniqueIdentifier != nil {
		return true
	}

	return false
}

// SetUniqueIdentifier gets a reference to the given string and assigns it to the UniqueIdentifier field.
func (o *SAMLAccessRules) SetUniqueIdentifier(v string) {
	o.UniqueIdentifier = &v
}

func (o SAMLAccessRules) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AllowedRedirectURIs != nil {
		toSerialize["allowed_redirect_URIs"] = o.AllowedRedirectURIs
	}
	if o.BoundAttributes != nil {
		toSerialize["bound_attributes"] = o.BoundAttributes
	}
	if o.IdpMetadataUrl != nil {
		toSerialize["idp_metadata_url"] = o.IdpMetadataUrl
	}
	if o.IdpMetadataXml != nil {
		toSerialize["idp_metadata_xml"] = o.IdpMetadataXml
	}
	if o.UniqueIdentifier != nil {
		toSerialize["unique_identifier"] = o.UniqueIdentifier
	}
	return json.Marshal(toSerialize)
}

type NullableSAMLAccessRules struct {
	value *SAMLAccessRules
	isSet bool
}

func (v NullableSAMLAccessRules) Get() *SAMLAccessRules {
	return v.value
}

func (v *NullableSAMLAccessRules) Set(val *SAMLAccessRules) {
	v.value = val
	v.isSet = true
}

func (v NullableSAMLAccessRules) IsSet() bool {
	return v.isSet
}

func (v *NullableSAMLAccessRules) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSAMLAccessRules(val *SAMLAccessRules) *NullableSAMLAccessRules {
	return &NullableSAMLAccessRules{value: val, isSet: true}
}

func (v NullableSAMLAccessRules) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSAMLAccessRules) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


