/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// RenewCertificate struct for RenewCertificate
type RenewCertificate struct {
	// The name of the PKI certificate issuer
	CertIssuerName *string `json:"cert-issuer-name,omitempty"`
	// Generate a new key as part of the certificate renewal
	GenerateKey *bool `json:"generate-key,omitempty"`
	// Certificate item id
	ItemId *int64 `json:"item-id,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Certificate name
	Name *string `json:"name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewRenewCertificate instantiates a new RenewCertificate object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRenewCertificate() *RenewCertificate {
	this := RenewCertificate{}
	var json bool = false
	this.Json = &json
	return &this
}

// NewRenewCertificateWithDefaults instantiates a new RenewCertificate object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRenewCertificateWithDefaults() *RenewCertificate {
	this := RenewCertificate{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetCertIssuerName returns the CertIssuerName field value if set, zero value otherwise.
func (o *RenewCertificate) GetCertIssuerName() string {
	if o == nil || o.CertIssuerName == nil {
		var ret string
		return ret
	}
	return *o.CertIssuerName
}

// GetCertIssuerNameOk returns a tuple with the CertIssuerName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RenewCertificate) GetCertIssuerNameOk() (*string, bool) {
	if o == nil || o.CertIssuerName == nil {
		return nil, false
	}
	return o.CertIssuerName, true
}

// HasCertIssuerName returns a boolean if a field has been set.
func (o *RenewCertificate) HasCertIssuerName() bool {
	if o != nil && o.CertIssuerName != nil {
		return true
	}

	return false
}

// SetCertIssuerName gets a reference to the given string and assigns it to the CertIssuerName field.
func (o *RenewCertificate) SetCertIssuerName(v string) {
	o.CertIssuerName = &v
}

// GetGenerateKey returns the GenerateKey field value if set, zero value otherwise.
func (o *RenewCertificate) GetGenerateKey() bool {
	if o == nil || o.GenerateKey == nil {
		var ret bool
		return ret
	}
	return *o.GenerateKey
}

// GetGenerateKeyOk returns a tuple with the GenerateKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RenewCertificate) GetGenerateKeyOk() (*bool, bool) {
	if o == nil || o.GenerateKey == nil {
		return nil, false
	}
	return o.GenerateKey, true
}

// HasGenerateKey returns a boolean if a field has been set.
func (o *RenewCertificate) HasGenerateKey() bool {
	if o != nil && o.GenerateKey != nil {
		return true
	}

	return false
}

// SetGenerateKey gets a reference to the given bool and assigns it to the GenerateKey field.
func (o *RenewCertificate) SetGenerateKey(v bool) {
	o.GenerateKey = &v
}

// GetItemId returns the ItemId field value if set, zero value otherwise.
func (o *RenewCertificate) GetItemId() int64 {
	if o == nil || o.ItemId == nil {
		var ret int64
		return ret
	}
	return *o.ItemId
}

// GetItemIdOk returns a tuple with the ItemId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RenewCertificate) GetItemIdOk() (*int64, bool) {
	if o == nil || o.ItemId == nil {
		return nil, false
	}
	return o.ItemId, true
}

// HasItemId returns a boolean if a field has been set.
func (o *RenewCertificate) HasItemId() bool {
	if o != nil && o.ItemId != nil {
		return true
	}

	return false
}

// SetItemId gets a reference to the given int64 and assigns it to the ItemId field.
func (o *RenewCertificate) SetItemId(v int64) {
	o.ItemId = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *RenewCertificate) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RenewCertificate) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *RenewCertificate) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *RenewCertificate) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *RenewCertificate) GetName() string {
	if o == nil || o.Name == nil {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RenewCertificate) GetNameOk() (*string, bool) {
	if o == nil || o.Name == nil {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *RenewCertificate) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *RenewCertificate) SetName(v string) {
	o.Name = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *RenewCertificate) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RenewCertificate) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *RenewCertificate) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *RenewCertificate) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *RenewCertificate) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RenewCertificate) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *RenewCertificate) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *RenewCertificate) SetUidToken(v string) {
	o.UidToken = &v
}

func (o RenewCertificate) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CertIssuerName != nil {
		toSerialize["cert-issuer-name"] = o.CertIssuerName
	}
	if o.GenerateKey != nil {
		toSerialize["generate-key"] = o.GenerateKey
	}
	if o.ItemId != nil {
		toSerialize["item-id"] = o.ItemId
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Name != nil {
		toSerialize["name"] = o.Name
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableRenewCertificate struct {
	value *RenewCertificate
	isSet bool
}

func (v NullableRenewCertificate) Get() *RenewCertificate {
	return v.value
}

func (v *NullableRenewCertificate) Set(val *RenewCertificate) {
	v.value = val
	v.isSet = true
}

func (v NullableRenewCertificate) IsSet() bool {
	return v.isSet
}

func (v *NullableRenewCertificate) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRenewCertificate(val *RenewCertificate) *NullableRenewCertificate {
	return &NullableRenewCertificate{value: val, isSet: true}
}

func (v NullableRenewCertificate) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRenewCertificate) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


