/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// ListTargetsOutput struct for ListTargetsOutput
type ListTargetsOutput struct {
	NextPage *string `json:"next_page,omitempty"`
	Targets *[]Target `json:"targets,omitempty"`
}

// NewListTargetsOutput instantiates a new ListTargetsOutput object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewListTargetsOutput() *ListTargetsOutput {
	this := ListTargetsOutput{}
	return &this
}

// NewListTargetsOutputWithDefaults instantiates a new ListTargetsOutput object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewListTargetsOutputWithDefaults() *ListTargetsOutput {
	this := ListTargetsOutput{}
	return &this
}

// GetNextPage returns the NextPage field value if set, zero value otherwise.
func (o *ListTargetsOutput) GetNextPage() string {
	if o == nil || o.NextPage == nil {
		var ret string
		return ret
	}
	return *o.NextPage
}

// GetNextPageOk returns a tuple with the NextPage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListTargetsOutput) GetNextPageOk() (*string, bool) {
	if o == nil || o.NextPage == nil {
		return nil, false
	}
	return o.NextPage, true
}

// HasNextPage returns a boolean if a field has been set.
func (o *ListTargetsOutput) HasNextPage() bool {
	if o != nil && o.NextPage != nil {
		return true
	}

	return false
}

// SetNextPage gets a reference to the given string and assigns it to the NextPage field.
func (o *ListTargetsOutput) SetNextPage(v string) {
	o.NextPage = &v
}

// GetTargets returns the Targets field value if set, zero value otherwise.
func (o *ListTargetsOutput) GetTargets() []Target {
	if o == nil || o.Targets == nil {
		var ret []Target
		return ret
	}
	return *o.Targets
}

// GetTargetsOk returns a tuple with the Targets field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListTargetsOutput) GetTargetsOk() (*[]Target, bool) {
	if o == nil || o.Targets == nil {
		return nil, false
	}
	return o.Targets, true
}

// HasTargets returns a boolean if a field has been set.
func (o *ListTargetsOutput) HasTargets() bool {
	if o != nil && o.Targets != nil {
		return true
	}

	return false
}

// SetTargets gets a reference to the given []Target and assigns it to the Targets field.
func (o *ListTargetsOutput) SetTargets(v []Target) {
	o.Targets = &v
}

func (o ListTargetsOutput) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.NextPage != nil {
		toSerialize["next_page"] = o.NextPage
	}
	if o.Targets != nil {
		toSerialize["targets"] = o.Targets
	}
	return json.Marshal(toSerialize)
}

type NullableListTargetsOutput struct {
	value *ListTargetsOutput
	isSet bool
}

func (v NullableListTargetsOutput) Get() *ListTargetsOutput {
	return v.value
}

func (v *NullableListTargetsOutput) Set(val *ListTargetsOutput) {
	v.value = val
	v.isSet = true
}

func (v NullableListTargetsOutput) IsSet() bool {
	return v.isSet
}

func (v *NullableListTargetsOutput) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableListTargetsOutput(val *ListTargetsOutput) *NullableListTargetsOutput {
	return &NullableListTargetsOutput{value: val, isSet: true}
}

func (v NullableListTargetsOutput) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableListTargetsOutput) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


