/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// KmipClientSetRule struct for KmipClientSetRule
type KmipClientSetRule struct {
	// Access capabilities
	Capability []string `json:"capability"`
	ClientId *string `json:"client-id,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	Name *string `json:"name,omitempty"`
	// Access path
	Path string `json:"path"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewKmipClientSetRule instantiates a new KmipClientSetRule object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewKmipClientSetRule(capability []string, path string, ) *KmipClientSetRule {
	this := KmipClientSetRule{}
	this.Capability = capability
	var json bool = false
	this.Json = &json
	this.Path = path
	return &this
}

// NewKmipClientSetRuleWithDefaults instantiates a new KmipClientSetRule object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewKmipClientSetRuleWithDefaults() *KmipClientSetRule {
	this := KmipClientSetRule{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetCapability returns the Capability field value
func (o *KmipClientSetRule) GetCapability() []string {
	if o == nil  {
		var ret []string
		return ret
	}

	return o.Capability
}

// GetCapabilityOk returns a tuple with the Capability field value
// and a boolean to check if the value has been set.
func (o *KmipClientSetRule) GetCapabilityOk() (*[]string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Capability, true
}

// SetCapability sets field value
func (o *KmipClientSetRule) SetCapability(v []string) {
	o.Capability = v
}

// GetClientId returns the ClientId field value if set, zero value otherwise.
func (o *KmipClientSetRule) GetClientId() string {
	if o == nil || o.ClientId == nil {
		var ret string
		return ret
	}
	return *o.ClientId
}

// GetClientIdOk returns a tuple with the ClientId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipClientSetRule) GetClientIdOk() (*string, bool) {
	if o == nil || o.ClientId == nil {
		return nil, false
	}
	return o.ClientId, true
}

// HasClientId returns a boolean if a field has been set.
func (o *KmipClientSetRule) HasClientId() bool {
	if o != nil && o.ClientId != nil {
		return true
	}

	return false
}

// SetClientId gets a reference to the given string and assigns it to the ClientId field.
func (o *KmipClientSetRule) SetClientId(v string) {
	o.ClientId = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *KmipClientSetRule) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipClientSetRule) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *KmipClientSetRule) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *KmipClientSetRule) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *KmipClientSetRule) GetName() string {
	if o == nil || o.Name == nil {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipClientSetRule) GetNameOk() (*string, bool) {
	if o == nil || o.Name == nil {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *KmipClientSetRule) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *KmipClientSetRule) SetName(v string) {
	o.Name = &v
}

// GetPath returns the Path field value
func (o *KmipClientSetRule) GetPath() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Path
}

// GetPathOk returns a tuple with the Path field value
// and a boolean to check if the value has been set.
func (o *KmipClientSetRule) GetPathOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Path, true
}

// SetPath sets field value
func (o *KmipClientSetRule) SetPath(v string) {
	o.Path = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *KmipClientSetRule) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipClientSetRule) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *KmipClientSetRule) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *KmipClientSetRule) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *KmipClientSetRule) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipClientSetRule) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *KmipClientSetRule) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *KmipClientSetRule) SetUidToken(v string) {
	o.UidToken = &v
}

func (o KmipClientSetRule) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["capability"] = o.Capability
	}
	if o.ClientId != nil {
		toSerialize["client-id"] = o.ClientId
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Name != nil {
		toSerialize["name"] = o.Name
	}
	if true {
		toSerialize["path"] = o.Path
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableKmipClientSetRule struct {
	value *KmipClientSetRule
	isSet bool
}

func (v NullableKmipClientSetRule) Get() *KmipClientSetRule {
	return v.value
}

func (v *NullableKmipClientSetRule) Set(val *KmipClientSetRule) {
	v.value = val
	v.isSet = true
}

func (v NullableKmipClientSetRule) IsSet() bool {
	return v.isSet
}

func (v *NullableKmipClientSetRule) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableKmipClientSetRule(val *KmipClientSetRule) *NullableKmipClientSetRule {
	return &NullableKmipClientSetRule{value: val, isSet: true}
}

func (v NullableKmipClientSetRule) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableKmipClientSetRule) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


