/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// K8SAuth struct for K8SAuth
type K8SAuth struct {
	// AuthMethodTokenExpiration is time in seconds of expiration of the Akeyless Kube Auth Method token
	AmTokenExpiration *int64 `json:"am_token_expiration,omitempty"`
	// AuthMethodAccessId of the Kubernetes auth method
	AuthMethodAccessId *string `json:"auth_method_access_id,omitempty"`
	// AuthMethodSigningKey is the private key (in base64 of the PEM format) associated with the public key defined in the Kubernetes auth method, that used to sign the internal token for the Akeyless Kubernetes Auth Method
	AuthMethodPrvKeyPem *string `json:"auth_method_prv_key_pem,omitempty"`
	// ClusterApiType defines types of API access to cluster
	ClusterApiType *string `json:"cluster_api_type,omitempty"`
	// DisableISSValidation is optional parameter to disable ISS validation
	DisableIssValidation *bool `json:"disable_iss_validation,omitempty"`
	Id *string `json:"id,omitempty"`
	K8sAuthType *string `json:"k8s_auth_type,omitempty"`
	// K8SCACert is the CA Cert to use to call into the kubernetes API
	K8sCaCert *string `json:"k8s_ca_cert,omitempty"`
	// K8sClientCertData is the client certificate for k8s client certificate authentication
	K8sClientCertData *string `json:"k8s_client_cert_data,omitempty"`
	// K8sClientKeyData is the client key for k8s client certificate authentication
	K8sClientKeyData *string `json:"k8s_client_key_data,omitempty"`
	// K8SHost is the url string for the kubernetes API
	K8sHost *string `json:"k8s_host,omitempty"`
	// K8SIssuer is the claim that specifies who issued the Kubernetes token
	K8sIssuer *string `json:"k8s_issuer,omitempty"`
	// K8SPublicKeysPEM is the list of public key in PEM format
	K8sPubKeysPem *[]string `json:"k8s_pub_keys_pem,omitempty"`
	// K8STokenReviewerJWT is the bearer for clusterApiTypeK8s, used during TokenReview API call
	K8sTokenReviewerJwt *string `json:"k8s_token_reviewer_jwt,omitempty"`
	Name *string `json:"name,omitempty"`
	// RancherApiKey the bear token for clusterApiTypeRancher
	RancherApiKey *string `json:"rancher_api_key,omitempty"`
	// RancherClusterId cluster id as define in rancher (in case of clusterApiTypeRancher)
	RancherClusterId *string `json:"rancher_cluster_id,omitempty"`
	// UseLocalCAJwt is an optional parameter to set defaulting to using the local service account when running in a Kubernetes pod
	UseLocalCaJwt *bool `json:"use_local_ca_jwt,omitempty"`
}

// NewK8SAuth instantiates a new K8SAuth object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewK8SAuth() *K8SAuth {
	this := K8SAuth{}
	return &this
}

// NewK8SAuthWithDefaults instantiates a new K8SAuth object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewK8SAuthWithDefaults() *K8SAuth {
	this := K8SAuth{}
	return &this
}

// GetAmTokenExpiration returns the AmTokenExpiration field value if set, zero value otherwise.
func (o *K8SAuth) GetAmTokenExpiration() int64 {
	if o == nil || o.AmTokenExpiration == nil {
		var ret int64
		return ret
	}
	return *o.AmTokenExpiration
}

// GetAmTokenExpirationOk returns a tuple with the AmTokenExpiration field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetAmTokenExpirationOk() (*int64, bool) {
	if o == nil || o.AmTokenExpiration == nil {
		return nil, false
	}
	return o.AmTokenExpiration, true
}

// HasAmTokenExpiration returns a boolean if a field has been set.
func (o *K8SAuth) HasAmTokenExpiration() bool {
	if o != nil && o.AmTokenExpiration != nil {
		return true
	}

	return false
}

// SetAmTokenExpiration gets a reference to the given int64 and assigns it to the AmTokenExpiration field.
func (o *K8SAuth) SetAmTokenExpiration(v int64) {
	o.AmTokenExpiration = &v
}

// GetAuthMethodAccessId returns the AuthMethodAccessId field value if set, zero value otherwise.
func (o *K8SAuth) GetAuthMethodAccessId() string {
	if o == nil || o.AuthMethodAccessId == nil {
		var ret string
		return ret
	}
	return *o.AuthMethodAccessId
}

// GetAuthMethodAccessIdOk returns a tuple with the AuthMethodAccessId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetAuthMethodAccessIdOk() (*string, bool) {
	if o == nil || o.AuthMethodAccessId == nil {
		return nil, false
	}
	return o.AuthMethodAccessId, true
}

// HasAuthMethodAccessId returns a boolean if a field has been set.
func (o *K8SAuth) HasAuthMethodAccessId() bool {
	if o != nil && o.AuthMethodAccessId != nil {
		return true
	}

	return false
}

// SetAuthMethodAccessId gets a reference to the given string and assigns it to the AuthMethodAccessId field.
func (o *K8SAuth) SetAuthMethodAccessId(v string) {
	o.AuthMethodAccessId = &v
}

// GetAuthMethodPrvKeyPem returns the AuthMethodPrvKeyPem field value if set, zero value otherwise.
func (o *K8SAuth) GetAuthMethodPrvKeyPem() string {
	if o == nil || o.AuthMethodPrvKeyPem == nil {
		var ret string
		return ret
	}
	return *o.AuthMethodPrvKeyPem
}

// GetAuthMethodPrvKeyPemOk returns a tuple with the AuthMethodPrvKeyPem field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetAuthMethodPrvKeyPemOk() (*string, bool) {
	if o == nil || o.AuthMethodPrvKeyPem == nil {
		return nil, false
	}
	return o.AuthMethodPrvKeyPem, true
}

// HasAuthMethodPrvKeyPem returns a boolean if a field has been set.
func (o *K8SAuth) HasAuthMethodPrvKeyPem() bool {
	if o != nil && o.AuthMethodPrvKeyPem != nil {
		return true
	}

	return false
}

// SetAuthMethodPrvKeyPem gets a reference to the given string and assigns it to the AuthMethodPrvKeyPem field.
func (o *K8SAuth) SetAuthMethodPrvKeyPem(v string) {
	o.AuthMethodPrvKeyPem = &v
}

// GetClusterApiType returns the ClusterApiType field value if set, zero value otherwise.
func (o *K8SAuth) GetClusterApiType() string {
	if o == nil || o.ClusterApiType == nil {
		var ret string
		return ret
	}
	return *o.ClusterApiType
}

// GetClusterApiTypeOk returns a tuple with the ClusterApiType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetClusterApiTypeOk() (*string, bool) {
	if o == nil || o.ClusterApiType == nil {
		return nil, false
	}
	return o.ClusterApiType, true
}

// HasClusterApiType returns a boolean if a field has been set.
func (o *K8SAuth) HasClusterApiType() bool {
	if o != nil && o.ClusterApiType != nil {
		return true
	}

	return false
}

// SetClusterApiType gets a reference to the given string and assigns it to the ClusterApiType field.
func (o *K8SAuth) SetClusterApiType(v string) {
	o.ClusterApiType = &v
}

// GetDisableIssValidation returns the DisableIssValidation field value if set, zero value otherwise.
func (o *K8SAuth) GetDisableIssValidation() bool {
	if o == nil || o.DisableIssValidation == nil {
		var ret bool
		return ret
	}
	return *o.DisableIssValidation
}

// GetDisableIssValidationOk returns a tuple with the DisableIssValidation field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetDisableIssValidationOk() (*bool, bool) {
	if o == nil || o.DisableIssValidation == nil {
		return nil, false
	}
	return o.DisableIssValidation, true
}

// HasDisableIssValidation returns a boolean if a field has been set.
func (o *K8SAuth) HasDisableIssValidation() bool {
	if o != nil && o.DisableIssValidation != nil {
		return true
	}

	return false
}

// SetDisableIssValidation gets a reference to the given bool and assigns it to the DisableIssValidation field.
func (o *K8SAuth) SetDisableIssValidation(v bool) {
	o.DisableIssValidation = &v
}

// GetId returns the Id field value if set, zero value otherwise.
func (o *K8SAuth) GetId() string {
	if o == nil || o.Id == nil {
		var ret string
		return ret
	}
	return *o.Id
}

// GetIdOk returns a tuple with the Id field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetIdOk() (*string, bool) {
	if o == nil || o.Id == nil {
		return nil, false
	}
	return o.Id, true
}

// HasId returns a boolean if a field has been set.
func (o *K8SAuth) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// SetId gets a reference to the given string and assigns it to the Id field.
func (o *K8SAuth) SetId(v string) {
	o.Id = &v
}

// GetK8sAuthType returns the K8sAuthType field value if set, zero value otherwise.
func (o *K8SAuth) GetK8sAuthType() string {
	if o == nil || o.K8sAuthType == nil {
		var ret string
		return ret
	}
	return *o.K8sAuthType
}

// GetK8sAuthTypeOk returns a tuple with the K8sAuthType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetK8sAuthTypeOk() (*string, bool) {
	if o == nil || o.K8sAuthType == nil {
		return nil, false
	}
	return o.K8sAuthType, true
}

// HasK8sAuthType returns a boolean if a field has been set.
func (o *K8SAuth) HasK8sAuthType() bool {
	if o != nil && o.K8sAuthType != nil {
		return true
	}

	return false
}

// SetK8sAuthType gets a reference to the given string and assigns it to the K8sAuthType field.
func (o *K8SAuth) SetK8sAuthType(v string) {
	o.K8sAuthType = &v
}

// GetK8sCaCert returns the K8sCaCert field value if set, zero value otherwise.
func (o *K8SAuth) GetK8sCaCert() string {
	if o == nil || o.K8sCaCert == nil {
		var ret string
		return ret
	}
	return *o.K8sCaCert
}

// GetK8sCaCertOk returns a tuple with the K8sCaCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetK8sCaCertOk() (*string, bool) {
	if o == nil || o.K8sCaCert == nil {
		return nil, false
	}
	return o.K8sCaCert, true
}

// HasK8sCaCert returns a boolean if a field has been set.
func (o *K8SAuth) HasK8sCaCert() bool {
	if o != nil && o.K8sCaCert != nil {
		return true
	}

	return false
}

// SetK8sCaCert gets a reference to the given string and assigns it to the K8sCaCert field.
func (o *K8SAuth) SetK8sCaCert(v string) {
	o.K8sCaCert = &v
}

// GetK8sClientCertData returns the K8sClientCertData field value if set, zero value otherwise.
func (o *K8SAuth) GetK8sClientCertData() string {
	if o == nil || o.K8sClientCertData == nil {
		var ret string
		return ret
	}
	return *o.K8sClientCertData
}

// GetK8sClientCertDataOk returns a tuple with the K8sClientCertData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetK8sClientCertDataOk() (*string, bool) {
	if o == nil || o.K8sClientCertData == nil {
		return nil, false
	}
	return o.K8sClientCertData, true
}

// HasK8sClientCertData returns a boolean if a field has been set.
func (o *K8SAuth) HasK8sClientCertData() bool {
	if o != nil && o.K8sClientCertData != nil {
		return true
	}

	return false
}

// SetK8sClientCertData gets a reference to the given string and assigns it to the K8sClientCertData field.
func (o *K8SAuth) SetK8sClientCertData(v string) {
	o.K8sClientCertData = &v
}

// GetK8sClientKeyData returns the K8sClientKeyData field value if set, zero value otherwise.
func (o *K8SAuth) GetK8sClientKeyData() string {
	if o == nil || o.K8sClientKeyData == nil {
		var ret string
		return ret
	}
	return *o.K8sClientKeyData
}

// GetK8sClientKeyDataOk returns a tuple with the K8sClientKeyData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetK8sClientKeyDataOk() (*string, bool) {
	if o == nil || o.K8sClientKeyData == nil {
		return nil, false
	}
	return o.K8sClientKeyData, true
}

// HasK8sClientKeyData returns a boolean if a field has been set.
func (o *K8SAuth) HasK8sClientKeyData() bool {
	if o != nil && o.K8sClientKeyData != nil {
		return true
	}

	return false
}

// SetK8sClientKeyData gets a reference to the given string and assigns it to the K8sClientKeyData field.
func (o *K8SAuth) SetK8sClientKeyData(v string) {
	o.K8sClientKeyData = &v
}

// GetK8sHost returns the K8sHost field value if set, zero value otherwise.
func (o *K8SAuth) GetK8sHost() string {
	if o == nil || o.K8sHost == nil {
		var ret string
		return ret
	}
	return *o.K8sHost
}

// GetK8sHostOk returns a tuple with the K8sHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetK8sHostOk() (*string, bool) {
	if o == nil || o.K8sHost == nil {
		return nil, false
	}
	return o.K8sHost, true
}

// HasK8sHost returns a boolean if a field has been set.
func (o *K8SAuth) HasK8sHost() bool {
	if o != nil && o.K8sHost != nil {
		return true
	}

	return false
}

// SetK8sHost gets a reference to the given string and assigns it to the K8sHost field.
func (o *K8SAuth) SetK8sHost(v string) {
	o.K8sHost = &v
}

// GetK8sIssuer returns the K8sIssuer field value if set, zero value otherwise.
func (o *K8SAuth) GetK8sIssuer() string {
	if o == nil || o.K8sIssuer == nil {
		var ret string
		return ret
	}
	return *o.K8sIssuer
}

// GetK8sIssuerOk returns a tuple with the K8sIssuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetK8sIssuerOk() (*string, bool) {
	if o == nil || o.K8sIssuer == nil {
		return nil, false
	}
	return o.K8sIssuer, true
}

// HasK8sIssuer returns a boolean if a field has been set.
func (o *K8SAuth) HasK8sIssuer() bool {
	if o != nil && o.K8sIssuer != nil {
		return true
	}

	return false
}

// SetK8sIssuer gets a reference to the given string and assigns it to the K8sIssuer field.
func (o *K8SAuth) SetK8sIssuer(v string) {
	o.K8sIssuer = &v
}

// GetK8sPubKeysPem returns the K8sPubKeysPem field value if set, zero value otherwise.
func (o *K8SAuth) GetK8sPubKeysPem() []string {
	if o == nil || o.K8sPubKeysPem == nil {
		var ret []string
		return ret
	}
	return *o.K8sPubKeysPem
}

// GetK8sPubKeysPemOk returns a tuple with the K8sPubKeysPem field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetK8sPubKeysPemOk() (*[]string, bool) {
	if o == nil || o.K8sPubKeysPem == nil {
		return nil, false
	}
	return o.K8sPubKeysPem, true
}

// HasK8sPubKeysPem returns a boolean if a field has been set.
func (o *K8SAuth) HasK8sPubKeysPem() bool {
	if o != nil && o.K8sPubKeysPem != nil {
		return true
	}

	return false
}

// SetK8sPubKeysPem gets a reference to the given []string and assigns it to the K8sPubKeysPem field.
func (o *K8SAuth) SetK8sPubKeysPem(v []string) {
	o.K8sPubKeysPem = &v
}

// GetK8sTokenReviewerJwt returns the K8sTokenReviewerJwt field value if set, zero value otherwise.
func (o *K8SAuth) GetK8sTokenReviewerJwt() string {
	if o == nil || o.K8sTokenReviewerJwt == nil {
		var ret string
		return ret
	}
	return *o.K8sTokenReviewerJwt
}

// GetK8sTokenReviewerJwtOk returns a tuple with the K8sTokenReviewerJwt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetK8sTokenReviewerJwtOk() (*string, bool) {
	if o == nil || o.K8sTokenReviewerJwt == nil {
		return nil, false
	}
	return o.K8sTokenReviewerJwt, true
}

// HasK8sTokenReviewerJwt returns a boolean if a field has been set.
func (o *K8SAuth) HasK8sTokenReviewerJwt() bool {
	if o != nil && o.K8sTokenReviewerJwt != nil {
		return true
	}

	return false
}

// SetK8sTokenReviewerJwt gets a reference to the given string and assigns it to the K8sTokenReviewerJwt field.
func (o *K8SAuth) SetK8sTokenReviewerJwt(v string) {
	o.K8sTokenReviewerJwt = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *K8SAuth) GetName() string {
	if o == nil || o.Name == nil {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetNameOk() (*string, bool) {
	if o == nil || o.Name == nil {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *K8SAuth) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *K8SAuth) SetName(v string) {
	o.Name = &v
}

// GetRancherApiKey returns the RancherApiKey field value if set, zero value otherwise.
func (o *K8SAuth) GetRancherApiKey() string {
	if o == nil || o.RancherApiKey == nil {
		var ret string
		return ret
	}
	return *o.RancherApiKey
}

// GetRancherApiKeyOk returns a tuple with the RancherApiKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetRancherApiKeyOk() (*string, bool) {
	if o == nil || o.RancherApiKey == nil {
		return nil, false
	}
	return o.RancherApiKey, true
}

// HasRancherApiKey returns a boolean if a field has been set.
func (o *K8SAuth) HasRancherApiKey() bool {
	if o != nil && o.RancherApiKey != nil {
		return true
	}

	return false
}

// SetRancherApiKey gets a reference to the given string and assigns it to the RancherApiKey field.
func (o *K8SAuth) SetRancherApiKey(v string) {
	o.RancherApiKey = &v
}

// GetRancherClusterId returns the RancherClusterId field value if set, zero value otherwise.
func (o *K8SAuth) GetRancherClusterId() string {
	if o == nil || o.RancherClusterId == nil {
		var ret string
		return ret
	}
	return *o.RancherClusterId
}

// GetRancherClusterIdOk returns a tuple with the RancherClusterId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetRancherClusterIdOk() (*string, bool) {
	if o == nil || o.RancherClusterId == nil {
		return nil, false
	}
	return o.RancherClusterId, true
}

// HasRancherClusterId returns a boolean if a field has been set.
func (o *K8SAuth) HasRancherClusterId() bool {
	if o != nil && o.RancherClusterId != nil {
		return true
	}

	return false
}

// SetRancherClusterId gets a reference to the given string and assigns it to the RancherClusterId field.
func (o *K8SAuth) SetRancherClusterId(v string) {
	o.RancherClusterId = &v
}

// GetUseLocalCaJwt returns the UseLocalCaJwt field value if set, zero value otherwise.
func (o *K8SAuth) GetUseLocalCaJwt() bool {
	if o == nil || o.UseLocalCaJwt == nil {
		var ret bool
		return ret
	}
	return *o.UseLocalCaJwt
}

// GetUseLocalCaJwtOk returns a tuple with the UseLocalCaJwt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *K8SAuth) GetUseLocalCaJwtOk() (*bool, bool) {
	if o == nil || o.UseLocalCaJwt == nil {
		return nil, false
	}
	return o.UseLocalCaJwt, true
}

// HasUseLocalCaJwt returns a boolean if a field has been set.
func (o *K8SAuth) HasUseLocalCaJwt() bool {
	if o != nil && o.UseLocalCaJwt != nil {
		return true
	}

	return false
}

// SetUseLocalCaJwt gets a reference to the given bool and assigns it to the UseLocalCaJwt field.
func (o *K8SAuth) SetUseLocalCaJwt(v bool) {
	o.UseLocalCaJwt = &v
}

func (o K8SAuth) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AmTokenExpiration != nil {
		toSerialize["am_token_expiration"] = o.AmTokenExpiration
	}
	if o.AuthMethodAccessId != nil {
		toSerialize["auth_method_access_id"] = o.AuthMethodAccessId
	}
	if o.AuthMethodPrvKeyPem != nil {
		toSerialize["auth_method_prv_key_pem"] = o.AuthMethodPrvKeyPem
	}
	if o.ClusterApiType != nil {
		toSerialize["cluster_api_type"] = o.ClusterApiType
	}
	if o.DisableIssValidation != nil {
		toSerialize["disable_iss_validation"] = o.DisableIssValidation
	}
	if o.Id != nil {
		toSerialize["id"] = o.Id
	}
	if o.K8sAuthType != nil {
		toSerialize["k8s_auth_type"] = o.K8sAuthType
	}
	if o.K8sCaCert != nil {
		toSerialize["k8s_ca_cert"] = o.K8sCaCert
	}
	if o.K8sClientCertData != nil {
		toSerialize["k8s_client_cert_data"] = o.K8sClientCertData
	}
	if o.K8sClientKeyData != nil {
		toSerialize["k8s_client_key_data"] = o.K8sClientKeyData
	}
	if o.K8sHost != nil {
		toSerialize["k8s_host"] = o.K8sHost
	}
	if o.K8sIssuer != nil {
		toSerialize["k8s_issuer"] = o.K8sIssuer
	}
	if o.K8sPubKeysPem != nil {
		toSerialize["k8s_pub_keys_pem"] = o.K8sPubKeysPem
	}
	if o.K8sTokenReviewerJwt != nil {
		toSerialize["k8s_token_reviewer_jwt"] = o.K8sTokenReviewerJwt
	}
	if o.Name != nil {
		toSerialize["name"] = o.Name
	}
	if o.RancherApiKey != nil {
		toSerialize["rancher_api_key"] = o.RancherApiKey
	}
	if o.RancherClusterId != nil {
		toSerialize["rancher_cluster_id"] = o.RancherClusterId
	}
	if o.UseLocalCaJwt != nil {
		toSerialize["use_local_ca_jwt"] = o.UseLocalCaJwt
	}
	return json.Marshal(toSerialize)
}

type NullableK8SAuth struct {
	value *K8SAuth
	isSet bool
}

func (v NullableK8SAuth) Get() *K8SAuth {
	return v.value
}

func (v *NullableK8SAuth) Set(val *K8SAuth) {
	v.value = val
	v.isSet = true
}

func (v NullableK8SAuth) IsSet() bool {
	return v.isSet
}

func (v *NullableK8SAuth) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableK8SAuth(val *K8SAuth) *NullableK8SAuth {
	return &NullableK8SAuth{value: val, isSet: true}
}

func (v NullableK8SAuth) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableK8SAuth) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


