/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
	"time"
)

// ItemVersion struct for ItemVersion
type ItemVersion struct {
	AccessDate *time.Time `json:"access_date,omitempty"`
	AccessDateDisplay *string `json:"access_date_display,omitempty"`
	CertificateVersionInfo *CertificateVersionInfo `json:"certificate_version_info,omitempty"`
	CreationDate *time.Time `json:"creation_date,omitempty"`
	CustomerFragmentId *string `json:"customer_fragment_id,omitempty"`
	DeletionDate *time.Time `json:"deletion_date,omitempty"`
	// ItemState defines the different states an Item can be in
	ItemVersionState *string `json:"item_version_state,omitempty"`
	ModificationDate *time.Time `json:"modification_date,omitempty"`
	ProtectionKeyName *string `json:"protection_key_name,omitempty"`
	Version *int32 `json:"version,omitempty"`
	WithCustomerFragment *bool `json:"with_customer_fragment,omitempty"`
}

// NewItemVersion instantiates a new ItemVersion object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewItemVersion() *ItemVersion {
	this := ItemVersion{}
	return &this
}

// NewItemVersionWithDefaults instantiates a new ItemVersion object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewItemVersionWithDefaults() *ItemVersion {
	this := ItemVersion{}
	return &this
}

// GetAccessDate returns the AccessDate field value if set, zero value otherwise.
func (o *ItemVersion) GetAccessDate() time.Time {
	if o == nil || o.AccessDate == nil {
		var ret time.Time
		return ret
	}
	return *o.AccessDate
}

// GetAccessDateOk returns a tuple with the AccessDate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemVersion) GetAccessDateOk() (*time.Time, bool) {
	if o == nil || o.AccessDate == nil {
		return nil, false
	}
	return o.AccessDate, true
}

// HasAccessDate returns a boolean if a field has been set.
func (o *ItemVersion) HasAccessDate() bool {
	if o != nil && o.AccessDate != nil {
		return true
	}

	return false
}

// SetAccessDate gets a reference to the given time.Time and assigns it to the AccessDate field.
func (o *ItemVersion) SetAccessDate(v time.Time) {
	o.AccessDate = &v
}

// GetAccessDateDisplay returns the AccessDateDisplay field value if set, zero value otherwise.
func (o *ItemVersion) GetAccessDateDisplay() string {
	if o == nil || o.AccessDateDisplay == nil {
		var ret string
		return ret
	}
	return *o.AccessDateDisplay
}

// GetAccessDateDisplayOk returns a tuple with the AccessDateDisplay field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemVersion) GetAccessDateDisplayOk() (*string, bool) {
	if o == nil || o.AccessDateDisplay == nil {
		return nil, false
	}
	return o.AccessDateDisplay, true
}

// HasAccessDateDisplay returns a boolean if a field has been set.
func (o *ItemVersion) HasAccessDateDisplay() bool {
	if o != nil && o.AccessDateDisplay != nil {
		return true
	}

	return false
}

// SetAccessDateDisplay gets a reference to the given string and assigns it to the AccessDateDisplay field.
func (o *ItemVersion) SetAccessDateDisplay(v string) {
	o.AccessDateDisplay = &v
}

// GetCertificateVersionInfo returns the CertificateVersionInfo field value if set, zero value otherwise.
func (o *ItemVersion) GetCertificateVersionInfo() CertificateVersionInfo {
	if o == nil || o.CertificateVersionInfo == nil {
		var ret CertificateVersionInfo
		return ret
	}
	return *o.CertificateVersionInfo
}

// GetCertificateVersionInfoOk returns a tuple with the CertificateVersionInfo field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemVersion) GetCertificateVersionInfoOk() (*CertificateVersionInfo, bool) {
	if o == nil || o.CertificateVersionInfo == nil {
		return nil, false
	}
	return o.CertificateVersionInfo, true
}

// HasCertificateVersionInfo returns a boolean if a field has been set.
func (o *ItemVersion) HasCertificateVersionInfo() bool {
	if o != nil && o.CertificateVersionInfo != nil {
		return true
	}

	return false
}

// SetCertificateVersionInfo gets a reference to the given CertificateVersionInfo and assigns it to the CertificateVersionInfo field.
func (o *ItemVersion) SetCertificateVersionInfo(v CertificateVersionInfo) {
	o.CertificateVersionInfo = &v
}

// GetCreationDate returns the CreationDate field value if set, zero value otherwise.
func (o *ItemVersion) GetCreationDate() time.Time {
	if o == nil || o.CreationDate == nil {
		var ret time.Time
		return ret
	}
	return *o.CreationDate
}

// GetCreationDateOk returns a tuple with the CreationDate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemVersion) GetCreationDateOk() (*time.Time, bool) {
	if o == nil || o.CreationDate == nil {
		return nil, false
	}
	return o.CreationDate, true
}

// HasCreationDate returns a boolean if a field has been set.
func (o *ItemVersion) HasCreationDate() bool {
	if o != nil && o.CreationDate != nil {
		return true
	}

	return false
}

// SetCreationDate gets a reference to the given time.Time and assigns it to the CreationDate field.
func (o *ItemVersion) SetCreationDate(v time.Time) {
	o.CreationDate = &v
}

// GetCustomerFragmentId returns the CustomerFragmentId field value if set, zero value otherwise.
func (o *ItemVersion) GetCustomerFragmentId() string {
	if o == nil || o.CustomerFragmentId == nil {
		var ret string
		return ret
	}
	return *o.CustomerFragmentId
}

// GetCustomerFragmentIdOk returns a tuple with the CustomerFragmentId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemVersion) GetCustomerFragmentIdOk() (*string, bool) {
	if o == nil || o.CustomerFragmentId == nil {
		return nil, false
	}
	return o.CustomerFragmentId, true
}

// HasCustomerFragmentId returns a boolean if a field has been set.
func (o *ItemVersion) HasCustomerFragmentId() bool {
	if o != nil && o.CustomerFragmentId != nil {
		return true
	}

	return false
}

// SetCustomerFragmentId gets a reference to the given string and assigns it to the CustomerFragmentId field.
func (o *ItemVersion) SetCustomerFragmentId(v string) {
	o.CustomerFragmentId = &v
}

// GetDeletionDate returns the DeletionDate field value if set, zero value otherwise.
func (o *ItemVersion) GetDeletionDate() time.Time {
	if o == nil || o.DeletionDate == nil {
		var ret time.Time
		return ret
	}
	return *o.DeletionDate
}

// GetDeletionDateOk returns a tuple with the DeletionDate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemVersion) GetDeletionDateOk() (*time.Time, bool) {
	if o == nil || o.DeletionDate == nil {
		return nil, false
	}
	return o.DeletionDate, true
}

// HasDeletionDate returns a boolean if a field has been set.
func (o *ItemVersion) HasDeletionDate() bool {
	if o != nil && o.DeletionDate != nil {
		return true
	}

	return false
}

// SetDeletionDate gets a reference to the given time.Time and assigns it to the DeletionDate field.
func (o *ItemVersion) SetDeletionDate(v time.Time) {
	o.DeletionDate = &v
}

// GetItemVersionState returns the ItemVersionState field value if set, zero value otherwise.
func (o *ItemVersion) GetItemVersionState() string {
	if o == nil || o.ItemVersionState == nil {
		var ret string
		return ret
	}
	return *o.ItemVersionState
}

// GetItemVersionStateOk returns a tuple with the ItemVersionState field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemVersion) GetItemVersionStateOk() (*string, bool) {
	if o == nil || o.ItemVersionState == nil {
		return nil, false
	}
	return o.ItemVersionState, true
}

// HasItemVersionState returns a boolean if a field has been set.
func (o *ItemVersion) HasItemVersionState() bool {
	if o != nil && o.ItemVersionState != nil {
		return true
	}

	return false
}

// SetItemVersionState gets a reference to the given string and assigns it to the ItemVersionState field.
func (o *ItemVersion) SetItemVersionState(v string) {
	o.ItemVersionState = &v
}

// GetModificationDate returns the ModificationDate field value if set, zero value otherwise.
func (o *ItemVersion) GetModificationDate() time.Time {
	if o == nil || o.ModificationDate == nil {
		var ret time.Time
		return ret
	}
	return *o.ModificationDate
}

// GetModificationDateOk returns a tuple with the ModificationDate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemVersion) GetModificationDateOk() (*time.Time, bool) {
	if o == nil || o.ModificationDate == nil {
		return nil, false
	}
	return o.ModificationDate, true
}

// HasModificationDate returns a boolean if a field has been set.
func (o *ItemVersion) HasModificationDate() bool {
	if o != nil && o.ModificationDate != nil {
		return true
	}

	return false
}

// SetModificationDate gets a reference to the given time.Time and assigns it to the ModificationDate field.
func (o *ItemVersion) SetModificationDate(v time.Time) {
	o.ModificationDate = &v
}

// GetProtectionKeyName returns the ProtectionKeyName field value if set, zero value otherwise.
func (o *ItemVersion) GetProtectionKeyName() string {
	if o == nil || o.ProtectionKeyName == nil {
		var ret string
		return ret
	}
	return *o.ProtectionKeyName
}

// GetProtectionKeyNameOk returns a tuple with the ProtectionKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemVersion) GetProtectionKeyNameOk() (*string, bool) {
	if o == nil || o.ProtectionKeyName == nil {
		return nil, false
	}
	return o.ProtectionKeyName, true
}

// HasProtectionKeyName returns a boolean if a field has been set.
func (o *ItemVersion) HasProtectionKeyName() bool {
	if o != nil && o.ProtectionKeyName != nil {
		return true
	}

	return false
}

// SetProtectionKeyName gets a reference to the given string and assigns it to the ProtectionKeyName field.
func (o *ItemVersion) SetProtectionKeyName(v string) {
	o.ProtectionKeyName = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *ItemVersion) GetVersion() int32 {
	if o == nil || o.Version == nil {
		var ret int32
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemVersion) GetVersionOk() (*int32, bool) {
	if o == nil || o.Version == nil {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *ItemVersion) HasVersion() bool {
	if o != nil && o.Version != nil {
		return true
	}

	return false
}

// SetVersion gets a reference to the given int32 and assigns it to the Version field.
func (o *ItemVersion) SetVersion(v int32) {
	o.Version = &v
}

// GetWithCustomerFragment returns the WithCustomerFragment field value if set, zero value otherwise.
func (o *ItemVersion) GetWithCustomerFragment() bool {
	if o == nil || o.WithCustomerFragment == nil {
		var ret bool
		return ret
	}
	return *o.WithCustomerFragment
}

// GetWithCustomerFragmentOk returns a tuple with the WithCustomerFragment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemVersion) GetWithCustomerFragmentOk() (*bool, bool) {
	if o == nil || o.WithCustomerFragment == nil {
		return nil, false
	}
	return o.WithCustomerFragment, true
}

// HasWithCustomerFragment returns a boolean if a field has been set.
func (o *ItemVersion) HasWithCustomerFragment() bool {
	if o != nil && o.WithCustomerFragment != nil {
		return true
	}

	return false
}

// SetWithCustomerFragment gets a reference to the given bool and assigns it to the WithCustomerFragment field.
func (o *ItemVersion) SetWithCustomerFragment(v bool) {
	o.WithCustomerFragment = &v
}

func (o ItemVersion) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessDate != nil {
		toSerialize["access_date"] = o.AccessDate
	}
	if o.AccessDateDisplay != nil {
		toSerialize["access_date_display"] = o.AccessDateDisplay
	}
	if o.CertificateVersionInfo != nil {
		toSerialize["certificate_version_info"] = o.CertificateVersionInfo
	}
	if o.CreationDate != nil {
		toSerialize["creation_date"] = o.CreationDate
	}
	if o.CustomerFragmentId != nil {
		toSerialize["customer_fragment_id"] = o.CustomerFragmentId
	}
	if o.DeletionDate != nil {
		toSerialize["deletion_date"] = o.DeletionDate
	}
	if o.ItemVersionState != nil {
		toSerialize["item_version_state"] = o.ItemVersionState
	}
	if o.ModificationDate != nil {
		toSerialize["modification_date"] = o.ModificationDate
	}
	if o.ProtectionKeyName != nil {
		toSerialize["protection_key_name"] = o.ProtectionKeyName
	}
	if o.Version != nil {
		toSerialize["version"] = o.Version
	}
	if o.WithCustomerFragment != nil {
		toSerialize["with_customer_fragment"] = o.WithCustomerFragment
	}
	return json.Marshal(toSerialize)
}

type NullableItemVersion struct {
	value *ItemVersion
	isSet bool
}

func (v NullableItemVersion) Get() *ItemVersion {
	return v.value
}

func (v *NullableItemVersion) Set(val *ItemVersion) {
	v.value = val
	v.isSet = true
}

func (v NullableItemVersion) IsSet() bool {
	return v.isSet
}

func (v *NullableItemVersion) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableItemVersion(val *ItemVersion) *NullableItemVersion {
	return &NullableItemVersion{value: val, isSet: true}
}

func (v NullableItemVersion) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableItemVersion) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


