/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
	"time"
)

// ItemSraStatus struct for ItemSraStatus
type ItemSraStatus struct {
	CountByHostInfo *map[string]int64 `json:"count_by_host_info,omitempty"`
	CountInfo *map[string]map[string]int64 `json:"count_info,omitempty"`
	HostsInUse *[]string `json:"hosts_in_use,omitempty"`
	IsInUse *bool `json:"is_in_use,omitempty"`
	LastUsedItem *time.Time `json:"last_used_item,omitempty"`
}

// NewItemSraStatus instantiates a new ItemSraStatus object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewItemSraStatus() *ItemSraStatus {
	this := ItemSraStatus{}
	return &this
}

// NewItemSraStatusWithDefaults instantiates a new ItemSraStatus object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewItemSraStatusWithDefaults() *ItemSraStatus {
	this := ItemSraStatus{}
	return &this
}

// GetCountByHostInfo returns the CountByHostInfo field value if set, zero value otherwise.
func (o *ItemSraStatus) GetCountByHostInfo() map[string]int64 {
	if o == nil || o.CountByHostInfo == nil {
		var ret map[string]int64
		return ret
	}
	return *o.CountByHostInfo
}

// GetCountByHostInfoOk returns a tuple with the CountByHostInfo field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemSraStatus) GetCountByHostInfoOk() (*map[string]int64, bool) {
	if o == nil || o.CountByHostInfo == nil {
		return nil, false
	}
	return o.CountByHostInfo, true
}

// HasCountByHostInfo returns a boolean if a field has been set.
func (o *ItemSraStatus) HasCountByHostInfo() bool {
	if o != nil && o.CountByHostInfo != nil {
		return true
	}

	return false
}

// SetCountByHostInfo gets a reference to the given map[string]int64 and assigns it to the CountByHostInfo field.
func (o *ItemSraStatus) SetCountByHostInfo(v map[string]int64) {
	o.CountByHostInfo = &v
}

// GetCountInfo returns the CountInfo field value if set, zero value otherwise.
func (o *ItemSraStatus) GetCountInfo() map[string]map[string]int64 {
	if o == nil || o.CountInfo == nil {
		var ret map[string]map[string]int64
		return ret
	}
	return *o.CountInfo
}

// GetCountInfoOk returns a tuple with the CountInfo field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemSraStatus) GetCountInfoOk() (*map[string]map[string]int64, bool) {
	if o == nil || o.CountInfo == nil {
		return nil, false
	}
	return o.CountInfo, true
}

// HasCountInfo returns a boolean if a field has been set.
func (o *ItemSraStatus) HasCountInfo() bool {
	if o != nil && o.CountInfo != nil {
		return true
	}

	return false
}

// SetCountInfo gets a reference to the given map[string]map[string]int64 and assigns it to the CountInfo field.
func (o *ItemSraStatus) SetCountInfo(v map[string]map[string]int64) {
	o.CountInfo = &v
}

// GetHostsInUse returns the HostsInUse field value if set, zero value otherwise.
func (o *ItemSraStatus) GetHostsInUse() []string {
	if o == nil || o.HostsInUse == nil {
		var ret []string
		return ret
	}
	return *o.HostsInUse
}

// GetHostsInUseOk returns a tuple with the HostsInUse field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemSraStatus) GetHostsInUseOk() (*[]string, bool) {
	if o == nil || o.HostsInUse == nil {
		return nil, false
	}
	return o.HostsInUse, true
}

// HasHostsInUse returns a boolean if a field has been set.
func (o *ItemSraStatus) HasHostsInUse() bool {
	if o != nil && o.HostsInUse != nil {
		return true
	}

	return false
}

// SetHostsInUse gets a reference to the given []string and assigns it to the HostsInUse field.
func (o *ItemSraStatus) SetHostsInUse(v []string) {
	o.HostsInUse = &v
}

// GetIsInUse returns the IsInUse field value if set, zero value otherwise.
func (o *ItemSraStatus) GetIsInUse() bool {
	if o == nil || o.IsInUse == nil {
		var ret bool
		return ret
	}
	return *o.IsInUse
}

// GetIsInUseOk returns a tuple with the IsInUse field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemSraStatus) GetIsInUseOk() (*bool, bool) {
	if o == nil || o.IsInUse == nil {
		return nil, false
	}
	return o.IsInUse, true
}

// HasIsInUse returns a boolean if a field has been set.
func (o *ItemSraStatus) HasIsInUse() bool {
	if o != nil && o.IsInUse != nil {
		return true
	}

	return false
}

// SetIsInUse gets a reference to the given bool and assigns it to the IsInUse field.
func (o *ItemSraStatus) SetIsInUse(v bool) {
	o.IsInUse = &v
}

// GetLastUsedItem returns the LastUsedItem field value if set, zero value otherwise.
func (o *ItemSraStatus) GetLastUsedItem() time.Time {
	if o == nil || o.LastUsedItem == nil {
		var ret time.Time
		return ret
	}
	return *o.LastUsedItem
}

// GetLastUsedItemOk returns a tuple with the LastUsedItem field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ItemSraStatus) GetLastUsedItemOk() (*time.Time, bool) {
	if o == nil || o.LastUsedItem == nil {
		return nil, false
	}
	return o.LastUsedItem, true
}

// HasLastUsedItem returns a boolean if a field has been set.
func (o *ItemSraStatus) HasLastUsedItem() bool {
	if o != nil && o.LastUsedItem != nil {
		return true
	}

	return false
}

// SetLastUsedItem gets a reference to the given time.Time and assigns it to the LastUsedItem field.
func (o *ItemSraStatus) SetLastUsedItem(v time.Time) {
	o.LastUsedItem = &v
}

func (o ItemSraStatus) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CountByHostInfo != nil {
		toSerialize["count_by_host_info"] = o.CountByHostInfo
	}
	if o.CountInfo != nil {
		toSerialize["count_info"] = o.CountInfo
	}
	if o.HostsInUse != nil {
		toSerialize["hosts_in_use"] = o.HostsInUse
	}
	if o.IsInUse != nil {
		toSerialize["is_in_use"] = o.IsInUse
	}
	if o.LastUsedItem != nil {
		toSerialize["last_used_item"] = o.LastUsedItem
	}
	return json.Marshal(toSerialize)
}

type NullableItemSraStatus struct {
	value *ItemSraStatus
	isSet bool
}

func (v NullableItemSraStatus) Get() *ItemSraStatus {
	return v.value
}

func (v *NullableItemSraStatus) Set(val *ItemSraStatus) {
	v.value = val
	v.isSet = true
}

func (v NullableItemSraStatus) IsSet() bool {
	return v.isSet
}

func (v *NullableItemSraStatus) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableItemSraStatus(val *ItemSraStatus) *NullableItemSraStatus {
	return &NullableItemSraStatus{value: val, isSet: true}
}

func (v NullableItemSraStatus) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableItemSraStatus) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


