/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GatewayUpdateTlsCert gatewayUpdateTlsCert is a command that updates Gateway TLS certificate
type GatewayUpdateTlsCert struct {
	// TLS Certificate (base64 encoded)
	CertData *string `json:"cert-data,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// TLS Private Key (base64 encoded)
	KeyData *string `json:"key-data,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGatewayUpdateTlsCert instantiates a new GatewayUpdateTlsCert object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGatewayUpdateTlsCert() *GatewayUpdateTlsCert {
	this := GatewayUpdateTlsCert{}
	var json bool = false
	this.Json = &json
	return &this
}

// NewGatewayUpdateTlsCertWithDefaults instantiates a new GatewayUpdateTlsCert object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGatewayUpdateTlsCertWithDefaults() *GatewayUpdateTlsCert {
	this := GatewayUpdateTlsCert{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetCertData returns the CertData field value if set, zero value otherwise.
func (o *GatewayUpdateTlsCert) GetCertData() string {
	if o == nil || o.CertData == nil {
		var ret string
		return ret
	}
	return *o.CertData
}

// GetCertDataOk returns a tuple with the CertData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateTlsCert) GetCertDataOk() (*string, bool) {
	if o == nil || o.CertData == nil {
		return nil, false
	}
	return o.CertData, true
}

// HasCertData returns a boolean if a field has been set.
func (o *GatewayUpdateTlsCert) HasCertData() bool {
	if o != nil && o.CertData != nil {
		return true
	}

	return false
}

// SetCertData gets a reference to the given string and assigns it to the CertData field.
func (o *GatewayUpdateTlsCert) SetCertData(v string) {
	o.CertData = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GatewayUpdateTlsCert) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateTlsCert) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GatewayUpdateTlsCert) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GatewayUpdateTlsCert) SetJson(v bool) {
	o.Json = &v
}

// GetKeyData returns the KeyData field value if set, zero value otherwise.
func (o *GatewayUpdateTlsCert) GetKeyData() string {
	if o == nil || o.KeyData == nil {
		var ret string
		return ret
	}
	return *o.KeyData
}

// GetKeyDataOk returns a tuple with the KeyData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateTlsCert) GetKeyDataOk() (*string, bool) {
	if o == nil || o.KeyData == nil {
		return nil, false
	}
	return o.KeyData, true
}

// HasKeyData returns a boolean if a field has been set.
func (o *GatewayUpdateTlsCert) HasKeyData() bool {
	if o != nil && o.KeyData != nil {
		return true
	}

	return false
}

// SetKeyData gets a reference to the given string and assigns it to the KeyData field.
func (o *GatewayUpdateTlsCert) SetKeyData(v string) {
	o.KeyData = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GatewayUpdateTlsCert) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateTlsCert) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GatewayUpdateTlsCert) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GatewayUpdateTlsCert) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GatewayUpdateTlsCert) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateTlsCert) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GatewayUpdateTlsCert) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GatewayUpdateTlsCert) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GatewayUpdateTlsCert) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CertData != nil {
		toSerialize["cert-data"] = o.CertData
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.KeyData != nil {
		toSerialize["key-data"] = o.KeyData
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGatewayUpdateTlsCert struct {
	value *GatewayUpdateTlsCert
	isSet bool
}

func (v NullableGatewayUpdateTlsCert) Get() *GatewayUpdateTlsCert {
	return v.value
}

func (v *NullableGatewayUpdateTlsCert) Set(val *GatewayUpdateTlsCert) {
	v.value = val
	v.isSet = true
}

func (v NullableGatewayUpdateTlsCert) IsSet() bool {
	return v.isSet
}

func (v *NullableGatewayUpdateTlsCert) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGatewayUpdateTlsCert(val *GatewayUpdateTlsCert) *NullableGatewayUpdateTlsCert {
	return &NullableGatewayUpdateTlsCert{value: val, isSet: true}
}

func (v NullableGatewayUpdateTlsCert) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGatewayUpdateTlsCert) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


