/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GatewayUpdateLdapAuthConfig gatewayUpdateLdapAuth is a command that updates ldap auth config
type GatewayUpdateLdapAuthConfig struct {
	// The access ID of the Ldap auth method
	AccessId *string `json:"access-id,omitempty"`
	// Bind DN
	BindDn *string `json:"bind-dn,omitempty"`
	// Bind DN Password
	BindDnPassword *string `json:"bind-dn-password,omitempty"`
	// Group Attr
	GroupAttr *string `json:"group-attr,omitempty"`
	// Group Dn
	GroupDn *string `json:"group-dn,omitempty"`
	// Group Filter
	GroupFilter *string `json:"group-filter,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// LDAP CA Certificate (base64 encoded)
	LdapCaCert *string `json:"ldap-ca-cert,omitempty"`
	// Enable Ldap [true/false]
	LdapEnable *string `json:"ldap-enable,omitempty"`
	// LDAP Server URL, e.g. ldap://planetexpress.com:389
	LdapUrl *string `json:"ldap-url,omitempty"`
	// Ldap Anonymous Search
	LdapAnonymousSearch *bool `json:"ldap_anonymous_search,omitempty"`
	// The private key (base64 encoded), associated with the public key defined in the Ldap auth
	SigningKeyData *string `json:"signing-key-data,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// User Attribute
	UserAttribute *string `json:"user-attribute,omitempty"`
	// User DN
	UserDn *string `json:"user-dn,omitempty"`
}

// NewGatewayUpdateLdapAuthConfig instantiates a new GatewayUpdateLdapAuthConfig object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGatewayUpdateLdapAuthConfig() *GatewayUpdateLdapAuthConfig {
	this := GatewayUpdateLdapAuthConfig{}
	var json bool = false
	this.Json = &json
	return &this
}

// NewGatewayUpdateLdapAuthConfigWithDefaults instantiates a new GatewayUpdateLdapAuthConfig object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGatewayUpdateLdapAuthConfigWithDefaults() *GatewayUpdateLdapAuthConfig {
	this := GatewayUpdateLdapAuthConfig{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetAccessId returns the AccessId field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetAccessId() string {
	if o == nil || o.AccessId == nil {
		var ret string
		return ret
	}
	return *o.AccessId
}

// GetAccessIdOk returns a tuple with the AccessId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetAccessIdOk() (*string, bool) {
	if o == nil || o.AccessId == nil {
		return nil, false
	}
	return o.AccessId, true
}

// HasAccessId returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasAccessId() bool {
	if o != nil && o.AccessId != nil {
		return true
	}

	return false
}

// SetAccessId gets a reference to the given string and assigns it to the AccessId field.
func (o *GatewayUpdateLdapAuthConfig) SetAccessId(v string) {
	o.AccessId = &v
}

// GetBindDn returns the BindDn field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetBindDn() string {
	if o == nil || o.BindDn == nil {
		var ret string
		return ret
	}
	return *o.BindDn
}

// GetBindDnOk returns a tuple with the BindDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetBindDnOk() (*string, bool) {
	if o == nil || o.BindDn == nil {
		return nil, false
	}
	return o.BindDn, true
}

// HasBindDn returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasBindDn() bool {
	if o != nil && o.BindDn != nil {
		return true
	}

	return false
}

// SetBindDn gets a reference to the given string and assigns it to the BindDn field.
func (o *GatewayUpdateLdapAuthConfig) SetBindDn(v string) {
	o.BindDn = &v
}

// GetBindDnPassword returns the BindDnPassword field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetBindDnPassword() string {
	if o == nil || o.BindDnPassword == nil {
		var ret string
		return ret
	}
	return *o.BindDnPassword
}

// GetBindDnPasswordOk returns a tuple with the BindDnPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetBindDnPasswordOk() (*string, bool) {
	if o == nil || o.BindDnPassword == nil {
		return nil, false
	}
	return o.BindDnPassword, true
}

// HasBindDnPassword returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasBindDnPassword() bool {
	if o != nil && o.BindDnPassword != nil {
		return true
	}

	return false
}

// SetBindDnPassword gets a reference to the given string and assigns it to the BindDnPassword field.
func (o *GatewayUpdateLdapAuthConfig) SetBindDnPassword(v string) {
	o.BindDnPassword = &v
}

// GetGroupAttr returns the GroupAttr field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetGroupAttr() string {
	if o == nil || o.GroupAttr == nil {
		var ret string
		return ret
	}
	return *o.GroupAttr
}

// GetGroupAttrOk returns a tuple with the GroupAttr field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetGroupAttrOk() (*string, bool) {
	if o == nil || o.GroupAttr == nil {
		return nil, false
	}
	return o.GroupAttr, true
}

// HasGroupAttr returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasGroupAttr() bool {
	if o != nil && o.GroupAttr != nil {
		return true
	}

	return false
}

// SetGroupAttr gets a reference to the given string and assigns it to the GroupAttr field.
func (o *GatewayUpdateLdapAuthConfig) SetGroupAttr(v string) {
	o.GroupAttr = &v
}

// GetGroupDn returns the GroupDn field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetGroupDn() string {
	if o == nil || o.GroupDn == nil {
		var ret string
		return ret
	}
	return *o.GroupDn
}

// GetGroupDnOk returns a tuple with the GroupDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetGroupDnOk() (*string, bool) {
	if o == nil || o.GroupDn == nil {
		return nil, false
	}
	return o.GroupDn, true
}

// HasGroupDn returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasGroupDn() bool {
	if o != nil && o.GroupDn != nil {
		return true
	}

	return false
}

// SetGroupDn gets a reference to the given string and assigns it to the GroupDn field.
func (o *GatewayUpdateLdapAuthConfig) SetGroupDn(v string) {
	o.GroupDn = &v
}

// GetGroupFilter returns the GroupFilter field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetGroupFilter() string {
	if o == nil || o.GroupFilter == nil {
		var ret string
		return ret
	}
	return *o.GroupFilter
}

// GetGroupFilterOk returns a tuple with the GroupFilter field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetGroupFilterOk() (*string, bool) {
	if o == nil || o.GroupFilter == nil {
		return nil, false
	}
	return o.GroupFilter, true
}

// HasGroupFilter returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasGroupFilter() bool {
	if o != nil && o.GroupFilter != nil {
		return true
	}

	return false
}

// SetGroupFilter gets a reference to the given string and assigns it to the GroupFilter field.
func (o *GatewayUpdateLdapAuthConfig) SetGroupFilter(v string) {
	o.GroupFilter = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GatewayUpdateLdapAuthConfig) SetJson(v bool) {
	o.Json = &v
}

// GetLdapCaCert returns the LdapCaCert field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetLdapCaCert() string {
	if o == nil || o.LdapCaCert == nil {
		var ret string
		return ret
	}
	return *o.LdapCaCert
}

// GetLdapCaCertOk returns a tuple with the LdapCaCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetLdapCaCertOk() (*string, bool) {
	if o == nil || o.LdapCaCert == nil {
		return nil, false
	}
	return o.LdapCaCert, true
}

// HasLdapCaCert returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasLdapCaCert() bool {
	if o != nil && o.LdapCaCert != nil {
		return true
	}

	return false
}

// SetLdapCaCert gets a reference to the given string and assigns it to the LdapCaCert field.
func (o *GatewayUpdateLdapAuthConfig) SetLdapCaCert(v string) {
	o.LdapCaCert = &v
}

// GetLdapEnable returns the LdapEnable field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetLdapEnable() string {
	if o == nil || o.LdapEnable == nil {
		var ret string
		return ret
	}
	return *o.LdapEnable
}

// GetLdapEnableOk returns a tuple with the LdapEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetLdapEnableOk() (*string, bool) {
	if o == nil || o.LdapEnable == nil {
		return nil, false
	}
	return o.LdapEnable, true
}

// HasLdapEnable returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasLdapEnable() bool {
	if o != nil && o.LdapEnable != nil {
		return true
	}

	return false
}

// SetLdapEnable gets a reference to the given string and assigns it to the LdapEnable field.
func (o *GatewayUpdateLdapAuthConfig) SetLdapEnable(v string) {
	o.LdapEnable = &v
}

// GetLdapUrl returns the LdapUrl field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetLdapUrl() string {
	if o == nil || o.LdapUrl == nil {
		var ret string
		return ret
	}
	return *o.LdapUrl
}

// GetLdapUrlOk returns a tuple with the LdapUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetLdapUrlOk() (*string, bool) {
	if o == nil || o.LdapUrl == nil {
		return nil, false
	}
	return o.LdapUrl, true
}

// HasLdapUrl returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasLdapUrl() bool {
	if o != nil && o.LdapUrl != nil {
		return true
	}

	return false
}

// SetLdapUrl gets a reference to the given string and assigns it to the LdapUrl field.
func (o *GatewayUpdateLdapAuthConfig) SetLdapUrl(v string) {
	o.LdapUrl = &v
}

// GetLdapAnonymousSearch returns the LdapAnonymousSearch field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetLdapAnonymousSearch() bool {
	if o == nil || o.LdapAnonymousSearch == nil {
		var ret bool
		return ret
	}
	return *o.LdapAnonymousSearch
}

// GetLdapAnonymousSearchOk returns a tuple with the LdapAnonymousSearch field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetLdapAnonymousSearchOk() (*bool, bool) {
	if o == nil || o.LdapAnonymousSearch == nil {
		return nil, false
	}
	return o.LdapAnonymousSearch, true
}

// HasLdapAnonymousSearch returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasLdapAnonymousSearch() bool {
	if o != nil && o.LdapAnonymousSearch != nil {
		return true
	}

	return false
}

// SetLdapAnonymousSearch gets a reference to the given bool and assigns it to the LdapAnonymousSearch field.
func (o *GatewayUpdateLdapAuthConfig) SetLdapAnonymousSearch(v bool) {
	o.LdapAnonymousSearch = &v
}

// GetSigningKeyData returns the SigningKeyData field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetSigningKeyData() string {
	if o == nil || o.SigningKeyData == nil {
		var ret string
		return ret
	}
	return *o.SigningKeyData
}

// GetSigningKeyDataOk returns a tuple with the SigningKeyData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetSigningKeyDataOk() (*string, bool) {
	if o == nil || o.SigningKeyData == nil {
		return nil, false
	}
	return o.SigningKeyData, true
}

// HasSigningKeyData returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasSigningKeyData() bool {
	if o != nil && o.SigningKeyData != nil {
		return true
	}

	return false
}

// SetSigningKeyData gets a reference to the given string and assigns it to the SigningKeyData field.
func (o *GatewayUpdateLdapAuthConfig) SetSigningKeyData(v string) {
	o.SigningKeyData = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GatewayUpdateLdapAuthConfig) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GatewayUpdateLdapAuthConfig) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserAttribute returns the UserAttribute field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetUserAttribute() string {
	if o == nil || o.UserAttribute == nil {
		var ret string
		return ret
	}
	return *o.UserAttribute
}

// GetUserAttributeOk returns a tuple with the UserAttribute field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetUserAttributeOk() (*string, bool) {
	if o == nil || o.UserAttribute == nil {
		return nil, false
	}
	return o.UserAttribute, true
}

// HasUserAttribute returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasUserAttribute() bool {
	if o != nil && o.UserAttribute != nil {
		return true
	}

	return false
}

// SetUserAttribute gets a reference to the given string and assigns it to the UserAttribute field.
func (o *GatewayUpdateLdapAuthConfig) SetUserAttribute(v string) {
	o.UserAttribute = &v
}

// GetUserDn returns the UserDn field value if set, zero value otherwise.
func (o *GatewayUpdateLdapAuthConfig) GetUserDn() string {
	if o == nil || o.UserDn == nil {
		var ret string
		return ret
	}
	return *o.UserDn
}

// GetUserDnOk returns a tuple with the UserDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLdapAuthConfig) GetUserDnOk() (*string, bool) {
	if o == nil || o.UserDn == nil {
		return nil, false
	}
	return o.UserDn, true
}

// HasUserDn returns a boolean if a field has been set.
func (o *GatewayUpdateLdapAuthConfig) HasUserDn() bool {
	if o != nil && o.UserDn != nil {
		return true
	}

	return false
}

// SetUserDn gets a reference to the given string and assigns it to the UserDn field.
func (o *GatewayUpdateLdapAuthConfig) SetUserDn(v string) {
	o.UserDn = &v
}

func (o GatewayUpdateLdapAuthConfig) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessId != nil {
		toSerialize["access-id"] = o.AccessId
	}
	if o.BindDn != nil {
		toSerialize["bind-dn"] = o.BindDn
	}
	if o.BindDnPassword != nil {
		toSerialize["bind-dn-password"] = o.BindDnPassword
	}
	if o.GroupAttr != nil {
		toSerialize["group-attr"] = o.GroupAttr
	}
	if o.GroupDn != nil {
		toSerialize["group-dn"] = o.GroupDn
	}
	if o.GroupFilter != nil {
		toSerialize["group-filter"] = o.GroupFilter
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.LdapCaCert != nil {
		toSerialize["ldap-ca-cert"] = o.LdapCaCert
	}
	if o.LdapEnable != nil {
		toSerialize["ldap-enable"] = o.LdapEnable
	}
	if o.LdapUrl != nil {
		toSerialize["ldap-url"] = o.LdapUrl
	}
	if o.LdapAnonymousSearch != nil {
		toSerialize["ldap_anonymous_search"] = o.LdapAnonymousSearch
	}
	if o.SigningKeyData != nil {
		toSerialize["signing-key-data"] = o.SigningKeyData
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserAttribute != nil {
		toSerialize["user-attribute"] = o.UserAttribute
	}
	if o.UserDn != nil {
		toSerialize["user-dn"] = o.UserDn
	}
	return json.Marshal(toSerialize)
}

type NullableGatewayUpdateLdapAuthConfig struct {
	value *GatewayUpdateLdapAuthConfig
	isSet bool
}

func (v NullableGatewayUpdateLdapAuthConfig) Get() *GatewayUpdateLdapAuthConfig {
	return v.value
}

func (v *NullableGatewayUpdateLdapAuthConfig) Set(val *GatewayUpdateLdapAuthConfig) {
	v.value = val
	v.isSet = true
}

func (v NullableGatewayUpdateLdapAuthConfig) IsSet() bool {
	return v.isSet
}

func (v *NullableGatewayUpdateLdapAuthConfig) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGatewayUpdateLdapAuthConfig(val *GatewayUpdateLdapAuthConfig) *NullableGatewayUpdateLdapAuthConfig {
	return &NullableGatewayUpdateLdapAuthConfig{value: val, isSet: true}
}

func (v NullableGatewayUpdateLdapAuthConfig) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGatewayUpdateLdapAuthConfig) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


