/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GatewayUpdateDefaults gatewayUpdateDefaults is a command that updates defaults settings
type GatewayUpdateDefaults struct {
	// Default Certificate access id for UI login
	CertAccessId *string `json:"cert-access-id,omitempty"`
	// Trigger an event when Gateway status is changed [true/false]
	EventOnStatusChange *string `json:"event-on-status-change,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of the gateway default encryption key
	Key *string `json:"key,omitempty"`
	// Default OIDC access id for UI login
	OidcAccessId *string `json:"oidc-access-id,omitempty"`
	// Default SAML access id for UI login
	SamlAccessId *string `json:"saml-access-id,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGatewayUpdateDefaults instantiates a new GatewayUpdateDefaults object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGatewayUpdateDefaults() *GatewayUpdateDefaults {
	this := GatewayUpdateDefaults{}
	var certAccessId string = "use-existing"
	this.CertAccessId = &certAccessId
	var json bool = false
	this.Json = &json
	var key string = "Default"
	this.Key = &key
	var oidcAccessId string = "use-existing"
	this.OidcAccessId = &oidcAccessId
	var samlAccessId string = "use-existing"
	this.SamlAccessId = &samlAccessId
	return &this
}

// NewGatewayUpdateDefaultsWithDefaults instantiates a new GatewayUpdateDefaults object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGatewayUpdateDefaultsWithDefaults() *GatewayUpdateDefaults {
	this := GatewayUpdateDefaults{}
	var certAccessId string = "use-existing"
	this.CertAccessId = &certAccessId
	var json bool = false
	this.Json = &json
	var key string = "Default"
	this.Key = &key
	var oidcAccessId string = "use-existing"
	this.OidcAccessId = &oidcAccessId
	var samlAccessId string = "use-existing"
	this.SamlAccessId = &samlAccessId
	return &this
}

// GetCertAccessId returns the CertAccessId field value if set, zero value otherwise.
func (o *GatewayUpdateDefaults) GetCertAccessId() string {
	if o == nil || o.CertAccessId == nil {
		var ret string
		return ret
	}
	return *o.CertAccessId
}

// GetCertAccessIdOk returns a tuple with the CertAccessId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateDefaults) GetCertAccessIdOk() (*string, bool) {
	if o == nil || o.CertAccessId == nil {
		return nil, false
	}
	return o.CertAccessId, true
}

// HasCertAccessId returns a boolean if a field has been set.
func (o *GatewayUpdateDefaults) HasCertAccessId() bool {
	if o != nil && o.CertAccessId != nil {
		return true
	}

	return false
}

// SetCertAccessId gets a reference to the given string and assigns it to the CertAccessId field.
func (o *GatewayUpdateDefaults) SetCertAccessId(v string) {
	o.CertAccessId = &v
}

// GetEventOnStatusChange returns the EventOnStatusChange field value if set, zero value otherwise.
func (o *GatewayUpdateDefaults) GetEventOnStatusChange() string {
	if o == nil || o.EventOnStatusChange == nil {
		var ret string
		return ret
	}
	return *o.EventOnStatusChange
}

// GetEventOnStatusChangeOk returns a tuple with the EventOnStatusChange field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateDefaults) GetEventOnStatusChangeOk() (*string, bool) {
	if o == nil || o.EventOnStatusChange == nil {
		return nil, false
	}
	return o.EventOnStatusChange, true
}

// HasEventOnStatusChange returns a boolean if a field has been set.
func (o *GatewayUpdateDefaults) HasEventOnStatusChange() bool {
	if o != nil && o.EventOnStatusChange != nil {
		return true
	}

	return false
}

// SetEventOnStatusChange gets a reference to the given string and assigns it to the EventOnStatusChange field.
func (o *GatewayUpdateDefaults) SetEventOnStatusChange(v string) {
	o.EventOnStatusChange = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GatewayUpdateDefaults) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateDefaults) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GatewayUpdateDefaults) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GatewayUpdateDefaults) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *GatewayUpdateDefaults) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateDefaults) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *GatewayUpdateDefaults) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *GatewayUpdateDefaults) SetKey(v string) {
	o.Key = &v
}

// GetOidcAccessId returns the OidcAccessId field value if set, zero value otherwise.
func (o *GatewayUpdateDefaults) GetOidcAccessId() string {
	if o == nil || o.OidcAccessId == nil {
		var ret string
		return ret
	}
	return *o.OidcAccessId
}

// GetOidcAccessIdOk returns a tuple with the OidcAccessId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateDefaults) GetOidcAccessIdOk() (*string, bool) {
	if o == nil || o.OidcAccessId == nil {
		return nil, false
	}
	return o.OidcAccessId, true
}

// HasOidcAccessId returns a boolean if a field has been set.
func (o *GatewayUpdateDefaults) HasOidcAccessId() bool {
	if o != nil && o.OidcAccessId != nil {
		return true
	}

	return false
}

// SetOidcAccessId gets a reference to the given string and assigns it to the OidcAccessId field.
func (o *GatewayUpdateDefaults) SetOidcAccessId(v string) {
	o.OidcAccessId = &v
}

// GetSamlAccessId returns the SamlAccessId field value if set, zero value otherwise.
func (o *GatewayUpdateDefaults) GetSamlAccessId() string {
	if o == nil || o.SamlAccessId == nil {
		var ret string
		return ret
	}
	return *o.SamlAccessId
}

// GetSamlAccessIdOk returns a tuple with the SamlAccessId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateDefaults) GetSamlAccessIdOk() (*string, bool) {
	if o == nil || o.SamlAccessId == nil {
		return nil, false
	}
	return o.SamlAccessId, true
}

// HasSamlAccessId returns a boolean if a field has been set.
func (o *GatewayUpdateDefaults) HasSamlAccessId() bool {
	if o != nil && o.SamlAccessId != nil {
		return true
	}

	return false
}

// SetSamlAccessId gets a reference to the given string and assigns it to the SamlAccessId field.
func (o *GatewayUpdateDefaults) SetSamlAccessId(v string) {
	o.SamlAccessId = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GatewayUpdateDefaults) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateDefaults) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GatewayUpdateDefaults) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GatewayUpdateDefaults) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GatewayUpdateDefaults) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateDefaults) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GatewayUpdateDefaults) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GatewayUpdateDefaults) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GatewayUpdateDefaults) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CertAccessId != nil {
		toSerialize["cert-access-id"] = o.CertAccessId
	}
	if o.EventOnStatusChange != nil {
		toSerialize["event-on-status-change"] = o.EventOnStatusChange
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.OidcAccessId != nil {
		toSerialize["oidc-access-id"] = o.OidcAccessId
	}
	if o.SamlAccessId != nil {
		toSerialize["saml-access-id"] = o.SamlAccessId
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGatewayUpdateDefaults struct {
	value *GatewayUpdateDefaults
	isSet bool
}

func (v NullableGatewayUpdateDefaults) Get() *GatewayUpdateDefaults {
	return v.value
}

func (v *NullableGatewayUpdateDefaults) Set(val *GatewayUpdateDefaults) {
	v.value = val
	v.isSet = true
}

func (v NullableGatewayUpdateDefaults) IsSet() bool {
	return v.isSet
}

func (v *NullableGatewayUpdateDefaults) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGatewayUpdateDefaults(val *GatewayUpdateDefaults) *NullableGatewayUpdateDefaults {
	return &NullableGatewayUpdateDefaults{value: val, isSet: true}
}

func (v NullableGatewayUpdateDefaults) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGatewayUpdateDefaults) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


