/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// EventForwarderUpdateServiceNow eventForwarderUpdateServiceNow is a command that updates service now event forwarder
type EventForwarderUpdateServiceNow struct {
	// Workstation Admin Name
	AdminName *string `json:"admin-name,omitempty"`
	// Workstation Admin Password
	AdminPwd *string `json:"admin-pwd,omitempty"`
	// The RSA Private Key to use when connecting with jwt authentication
	AppPrivateKeyBase64 *string `json:"app-private-key-base64,omitempty"`
	// Auth Method Event sources
	AuthMethodsEventSourceLocations *[]string `json:"auth-methods-event-source-locations,omitempty"`
	// The authentication type to use [user-pass/jwt]
	AuthType *string `json:"auth-type,omitempty"`
	// The client ID to use when connecting with jwt authentication
	ClientId *string `json:"client-id,omitempty"`
	// The client secret to use when connecting with jwt authentication
	ClientSecret *string `json:"client-secret,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Enable/Disable Event Forwarder [true/false]
	Enable *string `json:"enable,omitempty"`
	// List of event types to notify about [request-access, certificate-pending-expiration, certificate-expired, certificate-provisioning-success, certificate-provisioning-failure, auth-method-pending-expiration, auth-method-expired, next-automatic-rotation, rotated-secret-success, rotated-secret-failure, dynamic-secret-failure, multi-auth-failure, uid-rotation-failure, apply-justification, email-auth-method-approved, usage, rotation-usage, gateway-inactive, static-secret-updated, rate-limiting, usage-report]
	EventTypes *[]string `json:"event-types,omitempty"`
	// Event sources
	GatewaysEventSourceLocations []string `json:"gateways-event-source-locations"`
	// Workstation Host
	Host *string `json:"host,omitempty"`
	// Items Event sources
	ItemsEventSourceLocations *[]string `json:"items-event-source-locations,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Whether to keep previous version [true/false]. If not set, use default according to account settings
	KeepPrevVersion *string `json:"keep-prev-version,omitempty"`
	// The name of a key that used to encrypt the EventForwarder secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// EventForwarder name
	Name string `json:"name"`
	// New EventForwarder name
	NewName *string `json:"new-name,omitempty"`
	// Targets Event sources
	TargetsEventSourceLocations *[]string `json:"targets-event-source-locations,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// The user email to identify with when connecting with jwt authentication
	UserEmail *string `json:"user-email,omitempty"`
}

// NewEventForwarderUpdateServiceNow instantiates a new EventForwarderUpdateServiceNow object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEventForwarderUpdateServiceNow(gatewaysEventSourceLocations []string, name string, ) *EventForwarderUpdateServiceNow {
	this := EventForwarderUpdateServiceNow{}
	var authType string = "user-pass"
	this.AuthType = &authType
	var enable string = "true"
	this.Enable = &enable
	this.GatewaysEventSourceLocations = gatewaysEventSourceLocations
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewEventForwarderUpdateServiceNowWithDefaults instantiates a new EventForwarderUpdateServiceNow object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEventForwarderUpdateServiceNowWithDefaults() *EventForwarderUpdateServiceNow {
	this := EventForwarderUpdateServiceNow{}
	var authType string = "user-pass"
	this.AuthType = &authType
	var enable string = "true"
	this.Enable = &enable
	var json bool = false
	this.Json = &json
	return &this
}

// GetAdminName returns the AdminName field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetAdminName() string {
	if o == nil || o.AdminName == nil {
		var ret string
		return ret
	}
	return *o.AdminName
}

// GetAdminNameOk returns a tuple with the AdminName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetAdminNameOk() (*string, bool) {
	if o == nil || o.AdminName == nil {
		return nil, false
	}
	return o.AdminName, true
}

// HasAdminName returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasAdminName() bool {
	if o != nil && o.AdminName != nil {
		return true
	}

	return false
}

// SetAdminName gets a reference to the given string and assigns it to the AdminName field.
func (o *EventForwarderUpdateServiceNow) SetAdminName(v string) {
	o.AdminName = &v
}

// GetAdminPwd returns the AdminPwd field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetAdminPwd() string {
	if o == nil || o.AdminPwd == nil {
		var ret string
		return ret
	}
	return *o.AdminPwd
}

// GetAdminPwdOk returns a tuple with the AdminPwd field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetAdminPwdOk() (*string, bool) {
	if o == nil || o.AdminPwd == nil {
		return nil, false
	}
	return o.AdminPwd, true
}

// HasAdminPwd returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasAdminPwd() bool {
	if o != nil && o.AdminPwd != nil {
		return true
	}

	return false
}

// SetAdminPwd gets a reference to the given string and assigns it to the AdminPwd field.
func (o *EventForwarderUpdateServiceNow) SetAdminPwd(v string) {
	o.AdminPwd = &v
}

// GetAppPrivateKeyBase64 returns the AppPrivateKeyBase64 field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetAppPrivateKeyBase64() string {
	if o == nil || o.AppPrivateKeyBase64 == nil {
		var ret string
		return ret
	}
	return *o.AppPrivateKeyBase64
}

// GetAppPrivateKeyBase64Ok returns a tuple with the AppPrivateKeyBase64 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetAppPrivateKeyBase64Ok() (*string, bool) {
	if o == nil || o.AppPrivateKeyBase64 == nil {
		return nil, false
	}
	return o.AppPrivateKeyBase64, true
}

// HasAppPrivateKeyBase64 returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasAppPrivateKeyBase64() bool {
	if o != nil && o.AppPrivateKeyBase64 != nil {
		return true
	}

	return false
}

// SetAppPrivateKeyBase64 gets a reference to the given string and assigns it to the AppPrivateKeyBase64 field.
func (o *EventForwarderUpdateServiceNow) SetAppPrivateKeyBase64(v string) {
	o.AppPrivateKeyBase64 = &v
}

// GetAuthMethodsEventSourceLocations returns the AuthMethodsEventSourceLocations field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetAuthMethodsEventSourceLocations() []string {
	if o == nil || o.AuthMethodsEventSourceLocations == nil {
		var ret []string
		return ret
	}
	return *o.AuthMethodsEventSourceLocations
}

// GetAuthMethodsEventSourceLocationsOk returns a tuple with the AuthMethodsEventSourceLocations field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetAuthMethodsEventSourceLocationsOk() (*[]string, bool) {
	if o == nil || o.AuthMethodsEventSourceLocations == nil {
		return nil, false
	}
	return o.AuthMethodsEventSourceLocations, true
}

// HasAuthMethodsEventSourceLocations returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasAuthMethodsEventSourceLocations() bool {
	if o != nil && o.AuthMethodsEventSourceLocations != nil {
		return true
	}

	return false
}

// SetAuthMethodsEventSourceLocations gets a reference to the given []string and assigns it to the AuthMethodsEventSourceLocations field.
func (o *EventForwarderUpdateServiceNow) SetAuthMethodsEventSourceLocations(v []string) {
	o.AuthMethodsEventSourceLocations = &v
}

// GetAuthType returns the AuthType field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetAuthType() string {
	if o == nil || o.AuthType == nil {
		var ret string
		return ret
	}
	return *o.AuthType
}

// GetAuthTypeOk returns a tuple with the AuthType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetAuthTypeOk() (*string, bool) {
	if o == nil || o.AuthType == nil {
		return nil, false
	}
	return o.AuthType, true
}

// HasAuthType returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasAuthType() bool {
	if o != nil && o.AuthType != nil {
		return true
	}

	return false
}

// SetAuthType gets a reference to the given string and assigns it to the AuthType field.
func (o *EventForwarderUpdateServiceNow) SetAuthType(v string) {
	o.AuthType = &v
}

// GetClientId returns the ClientId field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetClientId() string {
	if o == nil || o.ClientId == nil {
		var ret string
		return ret
	}
	return *o.ClientId
}

// GetClientIdOk returns a tuple with the ClientId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetClientIdOk() (*string, bool) {
	if o == nil || o.ClientId == nil {
		return nil, false
	}
	return o.ClientId, true
}

// HasClientId returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasClientId() bool {
	if o != nil && o.ClientId != nil {
		return true
	}

	return false
}

// SetClientId gets a reference to the given string and assigns it to the ClientId field.
func (o *EventForwarderUpdateServiceNow) SetClientId(v string) {
	o.ClientId = &v
}

// GetClientSecret returns the ClientSecret field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetClientSecret() string {
	if o == nil || o.ClientSecret == nil {
		var ret string
		return ret
	}
	return *o.ClientSecret
}

// GetClientSecretOk returns a tuple with the ClientSecret field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetClientSecretOk() (*string, bool) {
	if o == nil || o.ClientSecret == nil {
		return nil, false
	}
	return o.ClientSecret, true
}

// HasClientSecret returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasClientSecret() bool {
	if o != nil && o.ClientSecret != nil {
		return true
	}

	return false
}

// SetClientSecret gets a reference to the given string and assigns it to the ClientSecret field.
func (o *EventForwarderUpdateServiceNow) SetClientSecret(v string) {
	o.ClientSecret = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *EventForwarderUpdateServiceNow) SetDescription(v string) {
	o.Description = &v
}

// GetEnable returns the Enable field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetEnable() string {
	if o == nil || o.Enable == nil {
		var ret string
		return ret
	}
	return *o.Enable
}

// GetEnableOk returns a tuple with the Enable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetEnableOk() (*string, bool) {
	if o == nil || o.Enable == nil {
		return nil, false
	}
	return o.Enable, true
}

// HasEnable returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasEnable() bool {
	if o != nil && o.Enable != nil {
		return true
	}

	return false
}

// SetEnable gets a reference to the given string and assigns it to the Enable field.
func (o *EventForwarderUpdateServiceNow) SetEnable(v string) {
	o.Enable = &v
}

// GetEventTypes returns the EventTypes field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetEventTypes() []string {
	if o == nil || o.EventTypes == nil {
		var ret []string
		return ret
	}
	return *o.EventTypes
}

// GetEventTypesOk returns a tuple with the EventTypes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetEventTypesOk() (*[]string, bool) {
	if o == nil || o.EventTypes == nil {
		return nil, false
	}
	return o.EventTypes, true
}

// HasEventTypes returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasEventTypes() bool {
	if o != nil && o.EventTypes != nil {
		return true
	}

	return false
}

// SetEventTypes gets a reference to the given []string and assigns it to the EventTypes field.
func (o *EventForwarderUpdateServiceNow) SetEventTypes(v []string) {
	o.EventTypes = &v
}

// GetGatewaysEventSourceLocations returns the GatewaysEventSourceLocations field value
func (o *EventForwarderUpdateServiceNow) GetGatewaysEventSourceLocations() []string {
	if o == nil  {
		var ret []string
		return ret
	}

	return o.GatewaysEventSourceLocations
}

// GetGatewaysEventSourceLocationsOk returns a tuple with the GatewaysEventSourceLocations field value
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetGatewaysEventSourceLocationsOk() (*[]string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.GatewaysEventSourceLocations, true
}

// SetGatewaysEventSourceLocations sets field value
func (o *EventForwarderUpdateServiceNow) SetGatewaysEventSourceLocations(v []string) {
	o.GatewaysEventSourceLocations = v
}

// GetHost returns the Host field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetHost() string {
	if o == nil || o.Host == nil {
		var ret string
		return ret
	}
	return *o.Host
}

// GetHostOk returns a tuple with the Host field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetHostOk() (*string, bool) {
	if o == nil || o.Host == nil {
		return nil, false
	}
	return o.Host, true
}

// HasHost returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasHost() bool {
	if o != nil && o.Host != nil {
		return true
	}

	return false
}

// SetHost gets a reference to the given string and assigns it to the Host field.
func (o *EventForwarderUpdateServiceNow) SetHost(v string) {
	o.Host = &v
}

// GetItemsEventSourceLocations returns the ItemsEventSourceLocations field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetItemsEventSourceLocations() []string {
	if o == nil || o.ItemsEventSourceLocations == nil {
		var ret []string
		return ret
	}
	return *o.ItemsEventSourceLocations
}

// GetItemsEventSourceLocationsOk returns a tuple with the ItemsEventSourceLocations field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetItemsEventSourceLocationsOk() (*[]string, bool) {
	if o == nil || o.ItemsEventSourceLocations == nil {
		return nil, false
	}
	return o.ItemsEventSourceLocations, true
}

// HasItemsEventSourceLocations returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasItemsEventSourceLocations() bool {
	if o != nil && o.ItemsEventSourceLocations != nil {
		return true
	}

	return false
}

// SetItemsEventSourceLocations gets a reference to the given []string and assigns it to the ItemsEventSourceLocations field.
func (o *EventForwarderUpdateServiceNow) SetItemsEventSourceLocations(v []string) {
	o.ItemsEventSourceLocations = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *EventForwarderUpdateServiceNow) SetJson(v bool) {
	o.Json = &v
}

// GetKeepPrevVersion returns the KeepPrevVersion field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetKeepPrevVersion() string {
	if o == nil || o.KeepPrevVersion == nil {
		var ret string
		return ret
	}
	return *o.KeepPrevVersion
}

// GetKeepPrevVersionOk returns a tuple with the KeepPrevVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetKeepPrevVersionOk() (*string, bool) {
	if o == nil || o.KeepPrevVersion == nil {
		return nil, false
	}
	return o.KeepPrevVersion, true
}

// HasKeepPrevVersion returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasKeepPrevVersion() bool {
	if o != nil && o.KeepPrevVersion != nil {
		return true
	}

	return false
}

// SetKeepPrevVersion gets a reference to the given string and assigns it to the KeepPrevVersion field.
func (o *EventForwarderUpdateServiceNow) SetKeepPrevVersion(v string) {
	o.KeepPrevVersion = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *EventForwarderUpdateServiceNow) SetKey(v string) {
	o.Key = &v
}

// GetName returns the Name field value
func (o *EventForwarderUpdateServiceNow) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *EventForwarderUpdateServiceNow) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *EventForwarderUpdateServiceNow) SetNewName(v string) {
	o.NewName = &v
}

// GetTargetsEventSourceLocations returns the TargetsEventSourceLocations field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetTargetsEventSourceLocations() []string {
	if o == nil || o.TargetsEventSourceLocations == nil {
		var ret []string
		return ret
	}
	return *o.TargetsEventSourceLocations
}

// GetTargetsEventSourceLocationsOk returns a tuple with the TargetsEventSourceLocations field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetTargetsEventSourceLocationsOk() (*[]string, bool) {
	if o == nil || o.TargetsEventSourceLocations == nil {
		return nil, false
	}
	return o.TargetsEventSourceLocations, true
}

// HasTargetsEventSourceLocations returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasTargetsEventSourceLocations() bool {
	if o != nil && o.TargetsEventSourceLocations != nil {
		return true
	}

	return false
}

// SetTargetsEventSourceLocations gets a reference to the given []string and assigns it to the TargetsEventSourceLocations field.
func (o *EventForwarderUpdateServiceNow) SetTargetsEventSourceLocations(v []string) {
	o.TargetsEventSourceLocations = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *EventForwarderUpdateServiceNow) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *EventForwarderUpdateServiceNow) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserEmail returns the UserEmail field value if set, zero value otherwise.
func (o *EventForwarderUpdateServiceNow) GetUserEmail() string {
	if o == nil || o.UserEmail == nil {
		var ret string
		return ret
	}
	return *o.UserEmail
}

// GetUserEmailOk returns a tuple with the UserEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventForwarderUpdateServiceNow) GetUserEmailOk() (*string, bool) {
	if o == nil || o.UserEmail == nil {
		return nil, false
	}
	return o.UserEmail, true
}

// HasUserEmail returns a boolean if a field has been set.
func (o *EventForwarderUpdateServiceNow) HasUserEmail() bool {
	if o != nil && o.UserEmail != nil {
		return true
	}

	return false
}

// SetUserEmail gets a reference to the given string and assigns it to the UserEmail field.
func (o *EventForwarderUpdateServiceNow) SetUserEmail(v string) {
	o.UserEmail = &v
}

func (o EventForwarderUpdateServiceNow) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AdminName != nil {
		toSerialize["admin-name"] = o.AdminName
	}
	if o.AdminPwd != nil {
		toSerialize["admin-pwd"] = o.AdminPwd
	}
	if o.AppPrivateKeyBase64 != nil {
		toSerialize["app-private-key-base64"] = o.AppPrivateKeyBase64
	}
	if o.AuthMethodsEventSourceLocations != nil {
		toSerialize["auth-methods-event-source-locations"] = o.AuthMethodsEventSourceLocations
	}
	if o.AuthType != nil {
		toSerialize["auth-type"] = o.AuthType
	}
	if o.ClientId != nil {
		toSerialize["client-id"] = o.ClientId
	}
	if o.ClientSecret != nil {
		toSerialize["client-secret"] = o.ClientSecret
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Enable != nil {
		toSerialize["enable"] = o.Enable
	}
	if o.EventTypes != nil {
		toSerialize["event-types"] = o.EventTypes
	}
	if true {
		toSerialize["gateways-event-source-locations"] = o.GatewaysEventSourceLocations
	}
	if o.Host != nil {
		toSerialize["host"] = o.Host
	}
	if o.ItemsEventSourceLocations != nil {
		toSerialize["items-event-source-locations"] = o.ItemsEventSourceLocations
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.KeepPrevVersion != nil {
		toSerialize["keep-prev-version"] = o.KeepPrevVersion
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.TargetsEventSourceLocations != nil {
		toSerialize["targets-event-source-locations"] = o.TargetsEventSourceLocations
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserEmail != nil {
		toSerialize["user-email"] = o.UserEmail
	}
	return json.Marshal(toSerialize)
}

type NullableEventForwarderUpdateServiceNow struct {
	value *EventForwarderUpdateServiceNow
	isSet bool
}

func (v NullableEventForwarderUpdateServiceNow) Get() *EventForwarderUpdateServiceNow {
	return v.value
}

func (v *NullableEventForwarderUpdateServiceNow) Set(val *EventForwarderUpdateServiceNow) {
	v.value = val
	v.isSet = true
}

func (v NullableEventForwarderUpdateServiceNow) IsSet() bool {
	return v.isSet
}

func (v *NullableEventForwarderUpdateServiceNow) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEventForwarderUpdateServiceNow(val *EventForwarderUpdateServiceNow) *NullableEventForwarderUpdateServiceNow {
	return &NullableEventForwarderUpdateServiceNow{value: val, isSet: true}
}

func (v NullableEventForwarderUpdateServiceNow) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEventForwarderUpdateServiceNow) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


