/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
	"time"
)

// EmailPassAccessRules struct for EmailPassAccessRules
type EmailPassAccessRules struct {
	Alg *string `json:"alg,omitempty"`
	// The Email value
	Email *string `json:"email,omitempty"`
	// EncEmailWithSharedKey is the email of this auth method, encrypted with the shared auth/uam key (for use in uam)
	EncEmailWithSharedKey *string `json:"enc_email_with_shared_key,omitempty"`
	// The password value
	HashPass *string `json:"hash_pass,omitempty"`
	// The last password change date
	LastResetPassword *time.Time `json:"last_reset_password,omitempty"`
}

// NewEmailPassAccessRules instantiates a new EmailPassAccessRules object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEmailPassAccessRules() *EmailPassAccessRules {
	this := EmailPassAccessRules{}
	return &this
}

// NewEmailPassAccessRulesWithDefaults instantiates a new EmailPassAccessRules object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEmailPassAccessRulesWithDefaults() *EmailPassAccessRules {
	this := EmailPassAccessRules{}
	return &this
}

// GetAlg returns the Alg field value if set, zero value otherwise.
func (o *EmailPassAccessRules) GetAlg() string {
	if o == nil || o.Alg == nil {
		var ret string
		return ret
	}
	return *o.Alg
}

// GetAlgOk returns a tuple with the Alg field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EmailPassAccessRules) GetAlgOk() (*string, bool) {
	if o == nil || o.Alg == nil {
		return nil, false
	}
	return o.Alg, true
}

// HasAlg returns a boolean if a field has been set.
func (o *EmailPassAccessRules) HasAlg() bool {
	if o != nil && o.Alg != nil {
		return true
	}

	return false
}

// SetAlg gets a reference to the given string and assigns it to the Alg field.
func (o *EmailPassAccessRules) SetAlg(v string) {
	o.Alg = &v
}

// GetEmail returns the Email field value if set, zero value otherwise.
func (o *EmailPassAccessRules) GetEmail() string {
	if o == nil || o.Email == nil {
		var ret string
		return ret
	}
	return *o.Email
}

// GetEmailOk returns a tuple with the Email field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EmailPassAccessRules) GetEmailOk() (*string, bool) {
	if o == nil || o.Email == nil {
		return nil, false
	}
	return o.Email, true
}

// HasEmail returns a boolean if a field has been set.
func (o *EmailPassAccessRules) HasEmail() bool {
	if o != nil && o.Email != nil {
		return true
	}

	return false
}

// SetEmail gets a reference to the given string and assigns it to the Email field.
func (o *EmailPassAccessRules) SetEmail(v string) {
	o.Email = &v
}

// GetEncEmailWithSharedKey returns the EncEmailWithSharedKey field value if set, zero value otherwise.
func (o *EmailPassAccessRules) GetEncEmailWithSharedKey() string {
	if o == nil || o.EncEmailWithSharedKey == nil {
		var ret string
		return ret
	}
	return *o.EncEmailWithSharedKey
}

// GetEncEmailWithSharedKeyOk returns a tuple with the EncEmailWithSharedKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EmailPassAccessRules) GetEncEmailWithSharedKeyOk() (*string, bool) {
	if o == nil || o.EncEmailWithSharedKey == nil {
		return nil, false
	}
	return o.EncEmailWithSharedKey, true
}

// HasEncEmailWithSharedKey returns a boolean if a field has been set.
func (o *EmailPassAccessRules) HasEncEmailWithSharedKey() bool {
	if o != nil && o.EncEmailWithSharedKey != nil {
		return true
	}

	return false
}

// SetEncEmailWithSharedKey gets a reference to the given string and assigns it to the EncEmailWithSharedKey field.
func (o *EmailPassAccessRules) SetEncEmailWithSharedKey(v string) {
	o.EncEmailWithSharedKey = &v
}

// GetHashPass returns the HashPass field value if set, zero value otherwise.
func (o *EmailPassAccessRules) GetHashPass() string {
	if o == nil || o.HashPass == nil {
		var ret string
		return ret
	}
	return *o.HashPass
}

// GetHashPassOk returns a tuple with the HashPass field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EmailPassAccessRules) GetHashPassOk() (*string, bool) {
	if o == nil || o.HashPass == nil {
		return nil, false
	}
	return o.HashPass, true
}

// HasHashPass returns a boolean if a field has been set.
func (o *EmailPassAccessRules) HasHashPass() bool {
	if o != nil && o.HashPass != nil {
		return true
	}

	return false
}

// SetHashPass gets a reference to the given string and assigns it to the HashPass field.
func (o *EmailPassAccessRules) SetHashPass(v string) {
	o.HashPass = &v
}

// GetLastResetPassword returns the LastResetPassword field value if set, zero value otherwise.
func (o *EmailPassAccessRules) GetLastResetPassword() time.Time {
	if o == nil || o.LastResetPassword == nil {
		var ret time.Time
		return ret
	}
	return *o.LastResetPassword
}

// GetLastResetPasswordOk returns a tuple with the LastResetPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EmailPassAccessRules) GetLastResetPasswordOk() (*time.Time, bool) {
	if o == nil || o.LastResetPassword == nil {
		return nil, false
	}
	return o.LastResetPassword, true
}

// HasLastResetPassword returns a boolean if a field has been set.
func (o *EmailPassAccessRules) HasLastResetPassword() bool {
	if o != nil && o.LastResetPassword != nil {
		return true
	}

	return false
}

// SetLastResetPassword gets a reference to the given time.Time and assigns it to the LastResetPassword field.
func (o *EmailPassAccessRules) SetLastResetPassword(v time.Time) {
	o.LastResetPassword = &v
}

func (o EmailPassAccessRules) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Alg != nil {
		toSerialize["alg"] = o.Alg
	}
	if o.Email != nil {
		toSerialize["email"] = o.Email
	}
	if o.EncEmailWithSharedKey != nil {
		toSerialize["enc_email_with_shared_key"] = o.EncEmailWithSharedKey
	}
	if o.HashPass != nil {
		toSerialize["hash_pass"] = o.HashPass
	}
	if o.LastResetPassword != nil {
		toSerialize["last_reset_password"] = o.LastResetPassword
	}
	return json.Marshal(toSerialize)
}

type NullableEmailPassAccessRules struct {
	value *EmailPassAccessRules
	isSet bool
}

func (v NullableEmailPassAccessRules) Get() *EmailPassAccessRules {
	return v.value
}

func (v *NullableEmailPassAccessRules) Set(val *EmailPassAccessRules) {
	v.value = val
	v.isSet = true
}

func (v NullableEmailPassAccessRules) IsSet() bool {
	return v.isSet
}

func (v *NullableEmailPassAccessRules) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEmailPassAccessRules(val *EmailPassAccessRules) *NullableEmailPassAccessRules {
	return &NullableEmailPassAccessRules{value: val, isSet: true}
}

func (v NullableEmailPassAccessRules) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEmailPassAccessRules) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


