/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DynamicSecretCreateCassandra dynamicSecretCreateCassandra is a command that creates a Cassandra dynamic secret
type DynamicSecretCreateCassandra struct {
	// Cassandra creation statements
	CassandraCreationStatements *string `json:"cassandra-creation-statements,omitempty"`
	// Cassandra hosts IP or addresses, comma separated
	CassandraHosts *string `json:"cassandra-hosts,omitempty"`
	// Cassandra superuser password
	CassandraPassword *string `json:"cassandra-password,omitempty"`
	// Cassandra port
	CassandraPort *string `json:"cassandra-port,omitempty"`
	// Cassandra superuser username
	CassandraUsername *string `json:"cassandra-username,omitempty"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Dynamic secret name
	Name string `json:"name"`
	// The length of the password to be generated
	PasswordLength *string `json:"password-length,omitempty"`
	// Dynamic producer encryption key
	ProducerEncryptionKeyName *string `json:"producer-encryption-key-name,omitempty"`
	// Enable/Disable SSL [true/false]
	Ssl *bool `json:"ssl,omitempty"`
	// SSL CA certificate in base64 encoding generated from a trusted Certificate Authority (CA)
	SslCertificate *string `json:"ssl-certificate,omitempty"`
	// Add tags attached to this object
	Tags *[]string `json:"tags,omitempty"`
	// Target name
	TargetName *string `json:"target-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// User TTL
	UserTtl *string `json:"user-ttl,omitempty"`
}

// NewDynamicSecretCreateCassandra instantiates a new DynamicSecretCreateCassandra object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDynamicSecretCreateCassandra(name string, ) *DynamicSecretCreateCassandra {
	this := DynamicSecretCreateCassandra{}
	var cassandraPort string = "9042"
	this.CassandraPort = &cassandraPort
	var json bool = false
	this.Json = &json
	this.Name = name
	var ssl bool = false
	this.Ssl = &ssl
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// NewDynamicSecretCreateCassandraWithDefaults instantiates a new DynamicSecretCreateCassandra object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDynamicSecretCreateCassandraWithDefaults() *DynamicSecretCreateCassandra {
	this := DynamicSecretCreateCassandra{}
	var cassandraPort string = "9042"
	this.CassandraPort = &cassandraPort
	var json bool = false
	this.Json = &json
	var ssl bool = false
	this.Ssl = &ssl
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// GetCassandraCreationStatements returns the CassandraCreationStatements field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetCassandraCreationStatements() string {
	if o == nil || o.CassandraCreationStatements == nil {
		var ret string
		return ret
	}
	return *o.CassandraCreationStatements
}

// GetCassandraCreationStatementsOk returns a tuple with the CassandraCreationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetCassandraCreationStatementsOk() (*string, bool) {
	if o == nil || o.CassandraCreationStatements == nil {
		return nil, false
	}
	return o.CassandraCreationStatements, true
}

// HasCassandraCreationStatements returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasCassandraCreationStatements() bool {
	if o != nil && o.CassandraCreationStatements != nil {
		return true
	}

	return false
}

// SetCassandraCreationStatements gets a reference to the given string and assigns it to the CassandraCreationStatements field.
func (o *DynamicSecretCreateCassandra) SetCassandraCreationStatements(v string) {
	o.CassandraCreationStatements = &v
}

// GetCassandraHosts returns the CassandraHosts field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetCassandraHosts() string {
	if o == nil || o.CassandraHosts == nil {
		var ret string
		return ret
	}
	return *o.CassandraHosts
}

// GetCassandraHostsOk returns a tuple with the CassandraHosts field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetCassandraHostsOk() (*string, bool) {
	if o == nil || o.CassandraHosts == nil {
		return nil, false
	}
	return o.CassandraHosts, true
}

// HasCassandraHosts returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasCassandraHosts() bool {
	if o != nil && o.CassandraHosts != nil {
		return true
	}

	return false
}

// SetCassandraHosts gets a reference to the given string and assigns it to the CassandraHosts field.
func (o *DynamicSecretCreateCassandra) SetCassandraHosts(v string) {
	o.CassandraHosts = &v
}

// GetCassandraPassword returns the CassandraPassword field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetCassandraPassword() string {
	if o == nil || o.CassandraPassword == nil {
		var ret string
		return ret
	}
	return *o.CassandraPassword
}

// GetCassandraPasswordOk returns a tuple with the CassandraPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetCassandraPasswordOk() (*string, bool) {
	if o == nil || o.CassandraPassword == nil {
		return nil, false
	}
	return o.CassandraPassword, true
}

// HasCassandraPassword returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasCassandraPassword() bool {
	if o != nil && o.CassandraPassword != nil {
		return true
	}

	return false
}

// SetCassandraPassword gets a reference to the given string and assigns it to the CassandraPassword field.
func (o *DynamicSecretCreateCassandra) SetCassandraPassword(v string) {
	o.CassandraPassword = &v
}

// GetCassandraPort returns the CassandraPort field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetCassandraPort() string {
	if o == nil || o.CassandraPort == nil {
		var ret string
		return ret
	}
	return *o.CassandraPort
}

// GetCassandraPortOk returns a tuple with the CassandraPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetCassandraPortOk() (*string, bool) {
	if o == nil || o.CassandraPort == nil {
		return nil, false
	}
	return o.CassandraPort, true
}

// HasCassandraPort returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasCassandraPort() bool {
	if o != nil && o.CassandraPort != nil {
		return true
	}

	return false
}

// SetCassandraPort gets a reference to the given string and assigns it to the CassandraPort field.
func (o *DynamicSecretCreateCassandra) SetCassandraPort(v string) {
	o.CassandraPort = &v
}

// GetCassandraUsername returns the CassandraUsername field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetCassandraUsername() string {
	if o == nil || o.CassandraUsername == nil {
		var ret string
		return ret
	}
	return *o.CassandraUsername
}

// GetCassandraUsernameOk returns a tuple with the CassandraUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetCassandraUsernameOk() (*string, bool) {
	if o == nil || o.CassandraUsername == nil {
		return nil, false
	}
	return o.CassandraUsername, true
}

// HasCassandraUsername returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasCassandraUsername() bool {
	if o != nil && o.CassandraUsername != nil {
		return true
	}

	return false
}

// SetCassandraUsername gets a reference to the given string and assigns it to the CassandraUsername field.
func (o *DynamicSecretCreateCassandra) SetCassandraUsername(v string) {
	o.CassandraUsername = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *DynamicSecretCreateCassandra) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *DynamicSecretCreateCassandra) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DynamicSecretCreateCassandra) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *DynamicSecretCreateCassandra) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *DynamicSecretCreateCassandra) SetName(v string) {
	o.Name = v
}

// GetPasswordLength returns the PasswordLength field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetPasswordLength() string {
	if o == nil || o.PasswordLength == nil {
		var ret string
		return ret
	}
	return *o.PasswordLength
}

// GetPasswordLengthOk returns a tuple with the PasswordLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetPasswordLengthOk() (*string, bool) {
	if o == nil || o.PasswordLength == nil {
		return nil, false
	}
	return o.PasswordLength, true
}

// HasPasswordLength returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasPasswordLength() bool {
	if o != nil && o.PasswordLength != nil {
		return true
	}

	return false
}

// SetPasswordLength gets a reference to the given string and assigns it to the PasswordLength field.
func (o *DynamicSecretCreateCassandra) SetPasswordLength(v string) {
	o.PasswordLength = &v
}

// GetProducerEncryptionKeyName returns the ProducerEncryptionKeyName field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetProducerEncryptionKeyName() string {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		var ret string
		return ret
	}
	return *o.ProducerEncryptionKeyName
}

// GetProducerEncryptionKeyNameOk returns a tuple with the ProducerEncryptionKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetProducerEncryptionKeyNameOk() (*string, bool) {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		return nil, false
	}
	return o.ProducerEncryptionKeyName, true
}

// HasProducerEncryptionKeyName returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasProducerEncryptionKeyName() bool {
	if o != nil && o.ProducerEncryptionKeyName != nil {
		return true
	}

	return false
}

// SetProducerEncryptionKeyName gets a reference to the given string and assigns it to the ProducerEncryptionKeyName field.
func (o *DynamicSecretCreateCassandra) SetProducerEncryptionKeyName(v string) {
	o.ProducerEncryptionKeyName = &v
}

// GetSsl returns the Ssl field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetSsl() bool {
	if o == nil || o.Ssl == nil {
		var ret bool
		return ret
	}
	return *o.Ssl
}

// GetSslOk returns a tuple with the Ssl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetSslOk() (*bool, bool) {
	if o == nil || o.Ssl == nil {
		return nil, false
	}
	return o.Ssl, true
}

// HasSsl returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasSsl() bool {
	if o != nil && o.Ssl != nil {
		return true
	}

	return false
}

// SetSsl gets a reference to the given bool and assigns it to the Ssl field.
func (o *DynamicSecretCreateCassandra) SetSsl(v bool) {
	o.Ssl = &v
}

// GetSslCertificate returns the SslCertificate field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetSslCertificate() string {
	if o == nil || o.SslCertificate == nil {
		var ret string
		return ret
	}
	return *o.SslCertificate
}

// GetSslCertificateOk returns a tuple with the SslCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetSslCertificateOk() (*string, bool) {
	if o == nil || o.SslCertificate == nil {
		return nil, false
	}
	return o.SslCertificate, true
}

// HasSslCertificate returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasSslCertificate() bool {
	if o != nil && o.SslCertificate != nil {
		return true
	}

	return false
}

// SetSslCertificate gets a reference to the given string and assigns it to the SslCertificate field.
func (o *DynamicSecretCreateCassandra) SetSslCertificate(v string) {
	o.SslCertificate = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *DynamicSecretCreateCassandra) SetTags(v []string) {
	o.Tags = &v
}

// GetTargetName returns the TargetName field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetTargetName() string {
	if o == nil || o.TargetName == nil {
		var ret string
		return ret
	}
	return *o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetTargetNameOk() (*string, bool) {
	if o == nil || o.TargetName == nil {
		return nil, false
	}
	return o.TargetName, true
}

// HasTargetName returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasTargetName() bool {
	if o != nil && o.TargetName != nil {
		return true
	}

	return false
}

// SetTargetName gets a reference to the given string and assigns it to the TargetName field.
func (o *DynamicSecretCreateCassandra) SetTargetName(v string) {
	o.TargetName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DynamicSecretCreateCassandra) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DynamicSecretCreateCassandra) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserTtl returns the UserTtl field value if set, zero value otherwise.
func (o *DynamicSecretCreateCassandra) GetUserTtl() string {
	if o == nil || o.UserTtl == nil {
		var ret string
		return ret
	}
	return *o.UserTtl
}

// GetUserTtlOk returns a tuple with the UserTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateCassandra) GetUserTtlOk() (*string, bool) {
	if o == nil || o.UserTtl == nil {
		return nil, false
	}
	return o.UserTtl, true
}

// HasUserTtl returns a boolean if a field has been set.
func (o *DynamicSecretCreateCassandra) HasUserTtl() bool {
	if o != nil && o.UserTtl != nil {
		return true
	}

	return false
}

// SetUserTtl gets a reference to the given string and assigns it to the UserTtl field.
func (o *DynamicSecretCreateCassandra) SetUserTtl(v string) {
	o.UserTtl = &v
}

func (o DynamicSecretCreateCassandra) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CassandraCreationStatements != nil {
		toSerialize["cassandra-creation-statements"] = o.CassandraCreationStatements
	}
	if o.CassandraHosts != nil {
		toSerialize["cassandra-hosts"] = o.CassandraHosts
	}
	if o.CassandraPassword != nil {
		toSerialize["cassandra-password"] = o.CassandraPassword
	}
	if o.CassandraPort != nil {
		toSerialize["cassandra-port"] = o.CassandraPort
	}
	if o.CassandraUsername != nil {
		toSerialize["cassandra-username"] = o.CassandraUsername
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.PasswordLength != nil {
		toSerialize["password-length"] = o.PasswordLength
	}
	if o.ProducerEncryptionKeyName != nil {
		toSerialize["producer-encryption-key-name"] = o.ProducerEncryptionKeyName
	}
	if o.Ssl != nil {
		toSerialize["ssl"] = o.Ssl
	}
	if o.SslCertificate != nil {
		toSerialize["ssl-certificate"] = o.SslCertificate
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.TargetName != nil {
		toSerialize["target-name"] = o.TargetName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserTtl != nil {
		toSerialize["user-ttl"] = o.UserTtl
	}
	return json.Marshal(toSerialize)
}

type NullableDynamicSecretCreateCassandra struct {
	value *DynamicSecretCreateCassandra
	isSet bool
}

func (v NullableDynamicSecretCreateCassandra) Get() *DynamicSecretCreateCassandra {
	return v.value
}

func (v *NullableDynamicSecretCreateCassandra) Set(val *DynamicSecretCreateCassandra) {
	v.value = val
	v.isSet = true
}

func (v NullableDynamicSecretCreateCassandra) IsSet() bool {
	return v.isSet
}

func (v *NullableDynamicSecretCreateCassandra) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDynamicSecretCreateCassandra(val *DynamicSecretCreateCassandra) *NullableDynamicSecretCreateCassandra {
	return &NullableDynamicSecretCreateCassandra{value: val, isSet: true}
}

func (v NullableDynamicSecretCreateCassandra) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDynamicSecretCreateCassandra) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


