/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DeleteGwCluster struct for DeleteGwCluster
type DeleteGwCluster struct {
	// Gateway Cluster, e.g. acc-abcd12345678/p-123456789012/defaultCluster
	ClusterName string `json:"cluster-name"`
	// Enforce deletion
	ForceDeletion *bool `json:"force-deletion,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewDeleteGwCluster instantiates a new DeleteGwCluster object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDeleteGwCluster(clusterName string, ) *DeleteGwCluster {
	this := DeleteGwCluster{}
	this.ClusterName = clusterName
	var json bool = false
	this.Json = &json
	return &this
}

// NewDeleteGwClusterWithDefaults instantiates a new DeleteGwCluster object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDeleteGwClusterWithDefaults() *DeleteGwCluster {
	this := DeleteGwCluster{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetClusterName returns the ClusterName field value
func (o *DeleteGwCluster) GetClusterName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ClusterName
}

// GetClusterNameOk returns a tuple with the ClusterName field value
// and a boolean to check if the value has been set.
func (o *DeleteGwCluster) GetClusterNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ClusterName, true
}

// SetClusterName sets field value
func (o *DeleteGwCluster) SetClusterName(v string) {
	o.ClusterName = v
}

// GetForceDeletion returns the ForceDeletion field value if set, zero value otherwise.
func (o *DeleteGwCluster) GetForceDeletion() bool {
	if o == nil || o.ForceDeletion == nil {
		var ret bool
		return ret
	}
	return *o.ForceDeletion
}

// GetForceDeletionOk returns a tuple with the ForceDeletion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteGwCluster) GetForceDeletionOk() (*bool, bool) {
	if o == nil || o.ForceDeletion == nil {
		return nil, false
	}
	return o.ForceDeletion, true
}

// HasForceDeletion returns a boolean if a field has been set.
func (o *DeleteGwCluster) HasForceDeletion() bool {
	if o != nil && o.ForceDeletion != nil {
		return true
	}

	return false
}

// SetForceDeletion gets a reference to the given bool and assigns it to the ForceDeletion field.
func (o *DeleteGwCluster) SetForceDeletion(v bool) {
	o.ForceDeletion = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DeleteGwCluster) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteGwCluster) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DeleteGwCluster) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DeleteGwCluster) SetJson(v bool) {
	o.Json = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DeleteGwCluster) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteGwCluster) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DeleteGwCluster) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DeleteGwCluster) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DeleteGwCluster) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteGwCluster) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DeleteGwCluster) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DeleteGwCluster) SetUidToken(v string) {
	o.UidToken = &v
}

func (o DeleteGwCluster) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["cluster-name"] = o.ClusterName
	}
	if o.ForceDeletion != nil {
		toSerialize["force-deletion"] = o.ForceDeletion
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableDeleteGwCluster struct {
	value *DeleteGwCluster
	isSet bool
}

func (v NullableDeleteGwCluster) Get() *DeleteGwCluster {
	return v.value
}

func (v *NullableDeleteGwCluster) Set(val *DeleteGwCluster) {
	v.value = val
	v.isSet = true
}

func (v NullableDeleteGwCluster) IsSet() bool {
	return v.isSet
}

func (v *NullableDeleteGwCluster) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDeleteGwCluster(val *DeleteGwCluster) *NullableDeleteGwCluster {
	return &NullableDeleteGwCluster{value: val, isSet: true}
}

func (v NullableDeleteGwCluster) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDeleteGwCluster) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


