/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// ChangeAdminAccountPassword struct for ChangeAdminAccountPassword
type ChangeAdminAccountPassword struct {
	// Current password
	CurrentPassword string `json:"current-password"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// New password
	NewPassword string `json:"new-password"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewChangeAdminAccountPassword instantiates a new ChangeAdminAccountPassword object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewChangeAdminAccountPassword(currentPassword string, newPassword string, ) *ChangeAdminAccountPassword {
	this := ChangeAdminAccountPassword{}
	this.CurrentPassword = currentPassword
	var json bool = false
	this.Json = &json
	this.NewPassword = newPassword
	return &this
}

// NewChangeAdminAccountPasswordWithDefaults instantiates a new ChangeAdminAccountPassword object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewChangeAdminAccountPasswordWithDefaults() *ChangeAdminAccountPassword {
	this := ChangeAdminAccountPassword{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetCurrentPassword returns the CurrentPassword field value
func (o *ChangeAdminAccountPassword) GetCurrentPassword() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.CurrentPassword
}

// GetCurrentPasswordOk returns a tuple with the CurrentPassword field value
// and a boolean to check if the value has been set.
func (o *ChangeAdminAccountPassword) GetCurrentPasswordOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.CurrentPassword, true
}

// SetCurrentPassword sets field value
func (o *ChangeAdminAccountPassword) SetCurrentPassword(v string) {
	o.CurrentPassword = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *ChangeAdminAccountPassword) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ChangeAdminAccountPassword) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *ChangeAdminAccountPassword) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *ChangeAdminAccountPassword) SetJson(v bool) {
	o.Json = &v
}

// GetNewPassword returns the NewPassword field value
func (o *ChangeAdminAccountPassword) GetNewPassword() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.NewPassword
}

// GetNewPasswordOk returns a tuple with the NewPassword field value
// and a boolean to check if the value has been set.
func (o *ChangeAdminAccountPassword) GetNewPasswordOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.NewPassword, true
}

// SetNewPassword sets field value
func (o *ChangeAdminAccountPassword) SetNewPassword(v string) {
	o.NewPassword = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *ChangeAdminAccountPassword) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ChangeAdminAccountPassword) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *ChangeAdminAccountPassword) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *ChangeAdminAccountPassword) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *ChangeAdminAccountPassword) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ChangeAdminAccountPassword) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *ChangeAdminAccountPassword) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *ChangeAdminAccountPassword) SetUidToken(v string) {
	o.UidToken = &v
}

func (o ChangeAdminAccountPassword) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["current-password"] = o.CurrentPassword
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["new-password"] = o.NewPassword
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableChangeAdminAccountPassword struct {
	value *ChangeAdminAccountPassword
	isSet bool
}

func (v NullableChangeAdminAccountPassword) Get() *ChangeAdminAccountPassword {
	return v.value
}

func (v *NullableChangeAdminAccountPassword) Set(val *ChangeAdminAccountPassword) {
	v.value = val
	v.isSet = true
}

func (v NullableChangeAdminAccountPassword) IsSet() bool {
	return v.isSet
}

func (v *NullableChangeAdminAccountPassword) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableChangeAdminAccountPassword(val *ChangeAdminAccountPassword) *NullableChangeAdminAccountPassword {
	return &NullableChangeAdminAccountPassword{value: val, isSet: true}
}

func (v NullableChangeAdminAccountPassword) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableChangeAdminAccountPassword) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


