/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CertAccessRules struct for CertAccessRules
type CertAccessRules struct {
	// a list of allowed cors domains if used for browser authentication
	AllowedCors *[]string `json:"allowed_cors,omitempty"`
	// A list of names. At least one must exist in the Common Name. Supports globbing.
	BoundCommonNames *[]string `json:"bound_common_names,omitempty"`
	// A list of DNS names. At least one must exist in the SANs. Supports globbing.
	BoundDnsSans *[]string `json:"bound_dns_sans,omitempty"`
	// A list of Email Addresses. At least one must exist in the SANs. Supports globbing.
	BoundEmailSans *[]string `json:"bound_email_sans,omitempty"`
	// A list of extensions formatted as \"oid:value\". Expects the extension value to be some type of ASN1 encoded string. All values must match. Supports globbing on \"value\".
	BoundExtensions *[]string `json:"bound_extensions,omitempty"`
	// A list of Organizational Units names. At least one must exist in the OU field.
	BoundOrganizationalUnits *[]string `json:"bound_organizational_units,omitempty"`
	// A list of URIs. At least one must exist in the SANs. Supports globbing.
	BoundUriSans *[]string `json:"bound_uri_sans,omitempty"`
	// Base64 encdoed PEM certificate
	Certificate *string `json:"certificate,omitempty"`
	// A list of revoked cert ids
	RevokedCertIds *[]string `json:"revoked_cert_ids,omitempty"`
	// A unique identifier to distinguish different users
	UniqueIdentifier *string `json:"unique_identifier,omitempty"`
}

// NewCertAccessRules instantiates a new CertAccessRules object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCertAccessRules() *CertAccessRules {
	this := CertAccessRules{}
	return &this
}

// NewCertAccessRulesWithDefaults instantiates a new CertAccessRules object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCertAccessRulesWithDefaults() *CertAccessRules {
	this := CertAccessRules{}
	return &this
}

// GetAllowedCors returns the AllowedCors field value if set, zero value otherwise.
func (o *CertAccessRules) GetAllowedCors() []string {
	if o == nil || o.AllowedCors == nil {
		var ret []string
		return ret
	}
	return *o.AllowedCors
}

// GetAllowedCorsOk returns a tuple with the AllowedCors field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertAccessRules) GetAllowedCorsOk() (*[]string, bool) {
	if o == nil || o.AllowedCors == nil {
		return nil, false
	}
	return o.AllowedCors, true
}

// HasAllowedCors returns a boolean if a field has been set.
func (o *CertAccessRules) HasAllowedCors() bool {
	if o != nil && o.AllowedCors != nil {
		return true
	}

	return false
}

// SetAllowedCors gets a reference to the given []string and assigns it to the AllowedCors field.
func (o *CertAccessRules) SetAllowedCors(v []string) {
	o.AllowedCors = &v
}

// GetBoundCommonNames returns the BoundCommonNames field value if set, zero value otherwise.
func (o *CertAccessRules) GetBoundCommonNames() []string {
	if o == nil || o.BoundCommonNames == nil {
		var ret []string
		return ret
	}
	return *o.BoundCommonNames
}

// GetBoundCommonNamesOk returns a tuple with the BoundCommonNames field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertAccessRules) GetBoundCommonNamesOk() (*[]string, bool) {
	if o == nil || o.BoundCommonNames == nil {
		return nil, false
	}
	return o.BoundCommonNames, true
}

// HasBoundCommonNames returns a boolean if a field has been set.
func (o *CertAccessRules) HasBoundCommonNames() bool {
	if o != nil && o.BoundCommonNames != nil {
		return true
	}

	return false
}

// SetBoundCommonNames gets a reference to the given []string and assigns it to the BoundCommonNames field.
func (o *CertAccessRules) SetBoundCommonNames(v []string) {
	o.BoundCommonNames = &v
}

// GetBoundDnsSans returns the BoundDnsSans field value if set, zero value otherwise.
func (o *CertAccessRules) GetBoundDnsSans() []string {
	if o == nil || o.BoundDnsSans == nil {
		var ret []string
		return ret
	}
	return *o.BoundDnsSans
}

// GetBoundDnsSansOk returns a tuple with the BoundDnsSans field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertAccessRules) GetBoundDnsSansOk() (*[]string, bool) {
	if o == nil || o.BoundDnsSans == nil {
		return nil, false
	}
	return o.BoundDnsSans, true
}

// HasBoundDnsSans returns a boolean if a field has been set.
func (o *CertAccessRules) HasBoundDnsSans() bool {
	if o != nil && o.BoundDnsSans != nil {
		return true
	}

	return false
}

// SetBoundDnsSans gets a reference to the given []string and assigns it to the BoundDnsSans field.
func (o *CertAccessRules) SetBoundDnsSans(v []string) {
	o.BoundDnsSans = &v
}

// GetBoundEmailSans returns the BoundEmailSans field value if set, zero value otherwise.
func (o *CertAccessRules) GetBoundEmailSans() []string {
	if o == nil || o.BoundEmailSans == nil {
		var ret []string
		return ret
	}
	return *o.BoundEmailSans
}

// GetBoundEmailSansOk returns a tuple with the BoundEmailSans field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertAccessRules) GetBoundEmailSansOk() (*[]string, bool) {
	if o == nil || o.BoundEmailSans == nil {
		return nil, false
	}
	return o.BoundEmailSans, true
}

// HasBoundEmailSans returns a boolean if a field has been set.
func (o *CertAccessRules) HasBoundEmailSans() bool {
	if o != nil && o.BoundEmailSans != nil {
		return true
	}

	return false
}

// SetBoundEmailSans gets a reference to the given []string and assigns it to the BoundEmailSans field.
func (o *CertAccessRules) SetBoundEmailSans(v []string) {
	o.BoundEmailSans = &v
}

// GetBoundExtensions returns the BoundExtensions field value if set, zero value otherwise.
func (o *CertAccessRules) GetBoundExtensions() []string {
	if o == nil || o.BoundExtensions == nil {
		var ret []string
		return ret
	}
	return *o.BoundExtensions
}

// GetBoundExtensionsOk returns a tuple with the BoundExtensions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertAccessRules) GetBoundExtensionsOk() (*[]string, bool) {
	if o == nil || o.BoundExtensions == nil {
		return nil, false
	}
	return o.BoundExtensions, true
}

// HasBoundExtensions returns a boolean if a field has been set.
func (o *CertAccessRules) HasBoundExtensions() bool {
	if o != nil && o.BoundExtensions != nil {
		return true
	}

	return false
}

// SetBoundExtensions gets a reference to the given []string and assigns it to the BoundExtensions field.
func (o *CertAccessRules) SetBoundExtensions(v []string) {
	o.BoundExtensions = &v
}

// GetBoundOrganizationalUnits returns the BoundOrganizationalUnits field value if set, zero value otherwise.
func (o *CertAccessRules) GetBoundOrganizationalUnits() []string {
	if o == nil || o.BoundOrganizationalUnits == nil {
		var ret []string
		return ret
	}
	return *o.BoundOrganizationalUnits
}

// GetBoundOrganizationalUnitsOk returns a tuple with the BoundOrganizationalUnits field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertAccessRules) GetBoundOrganizationalUnitsOk() (*[]string, bool) {
	if o == nil || o.BoundOrganizationalUnits == nil {
		return nil, false
	}
	return o.BoundOrganizationalUnits, true
}

// HasBoundOrganizationalUnits returns a boolean if a field has been set.
func (o *CertAccessRules) HasBoundOrganizationalUnits() bool {
	if o != nil && o.BoundOrganizationalUnits != nil {
		return true
	}

	return false
}

// SetBoundOrganizationalUnits gets a reference to the given []string and assigns it to the BoundOrganizationalUnits field.
func (o *CertAccessRules) SetBoundOrganizationalUnits(v []string) {
	o.BoundOrganizationalUnits = &v
}

// GetBoundUriSans returns the BoundUriSans field value if set, zero value otherwise.
func (o *CertAccessRules) GetBoundUriSans() []string {
	if o == nil || o.BoundUriSans == nil {
		var ret []string
		return ret
	}
	return *o.BoundUriSans
}

// GetBoundUriSansOk returns a tuple with the BoundUriSans field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertAccessRules) GetBoundUriSansOk() (*[]string, bool) {
	if o == nil || o.BoundUriSans == nil {
		return nil, false
	}
	return o.BoundUriSans, true
}

// HasBoundUriSans returns a boolean if a field has been set.
func (o *CertAccessRules) HasBoundUriSans() bool {
	if o != nil && o.BoundUriSans != nil {
		return true
	}

	return false
}

// SetBoundUriSans gets a reference to the given []string and assigns it to the BoundUriSans field.
func (o *CertAccessRules) SetBoundUriSans(v []string) {
	o.BoundUriSans = &v
}

// GetCertificate returns the Certificate field value if set, zero value otherwise.
func (o *CertAccessRules) GetCertificate() string {
	if o == nil || o.Certificate == nil {
		var ret string
		return ret
	}
	return *o.Certificate
}

// GetCertificateOk returns a tuple with the Certificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertAccessRules) GetCertificateOk() (*string, bool) {
	if o == nil || o.Certificate == nil {
		return nil, false
	}
	return o.Certificate, true
}

// HasCertificate returns a boolean if a field has been set.
func (o *CertAccessRules) HasCertificate() bool {
	if o != nil && o.Certificate != nil {
		return true
	}

	return false
}

// SetCertificate gets a reference to the given string and assigns it to the Certificate field.
func (o *CertAccessRules) SetCertificate(v string) {
	o.Certificate = &v
}

// GetRevokedCertIds returns the RevokedCertIds field value if set, zero value otherwise.
func (o *CertAccessRules) GetRevokedCertIds() []string {
	if o == nil || o.RevokedCertIds == nil {
		var ret []string
		return ret
	}
	return *o.RevokedCertIds
}

// GetRevokedCertIdsOk returns a tuple with the RevokedCertIds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertAccessRules) GetRevokedCertIdsOk() (*[]string, bool) {
	if o == nil || o.RevokedCertIds == nil {
		return nil, false
	}
	return o.RevokedCertIds, true
}

// HasRevokedCertIds returns a boolean if a field has been set.
func (o *CertAccessRules) HasRevokedCertIds() bool {
	if o != nil && o.RevokedCertIds != nil {
		return true
	}

	return false
}

// SetRevokedCertIds gets a reference to the given []string and assigns it to the RevokedCertIds field.
func (o *CertAccessRules) SetRevokedCertIds(v []string) {
	o.RevokedCertIds = &v
}

// GetUniqueIdentifier returns the UniqueIdentifier field value if set, zero value otherwise.
func (o *CertAccessRules) GetUniqueIdentifier() string {
	if o == nil || o.UniqueIdentifier == nil {
		var ret string
		return ret
	}
	return *o.UniqueIdentifier
}

// GetUniqueIdentifierOk returns a tuple with the UniqueIdentifier field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertAccessRules) GetUniqueIdentifierOk() (*string, bool) {
	if o == nil || o.UniqueIdentifier == nil {
		return nil, false
	}
	return o.UniqueIdentifier, true
}

// HasUniqueIdentifier returns a boolean if a field has been set.
func (o *CertAccessRules) HasUniqueIdentifier() bool {
	if o != nil && o.UniqueIdentifier != nil {
		return true
	}

	return false
}

// SetUniqueIdentifier gets a reference to the given string and assigns it to the UniqueIdentifier field.
func (o *CertAccessRules) SetUniqueIdentifier(v string) {
	o.UniqueIdentifier = &v
}

func (o CertAccessRules) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AllowedCors != nil {
		toSerialize["allowed_cors"] = o.AllowedCors
	}
	if o.BoundCommonNames != nil {
		toSerialize["bound_common_names"] = o.BoundCommonNames
	}
	if o.BoundDnsSans != nil {
		toSerialize["bound_dns_sans"] = o.BoundDnsSans
	}
	if o.BoundEmailSans != nil {
		toSerialize["bound_email_sans"] = o.BoundEmailSans
	}
	if o.BoundExtensions != nil {
		toSerialize["bound_extensions"] = o.BoundExtensions
	}
	if o.BoundOrganizationalUnits != nil {
		toSerialize["bound_organizational_units"] = o.BoundOrganizationalUnits
	}
	if o.BoundUriSans != nil {
		toSerialize["bound_uri_sans"] = o.BoundUriSans
	}
	if o.Certificate != nil {
		toSerialize["certificate"] = o.Certificate
	}
	if o.RevokedCertIds != nil {
		toSerialize["revoked_cert_ids"] = o.RevokedCertIds
	}
	if o.UniqueIdentifier != nil {
		toSerialize["unique_identifier"] = o.UniqueIdentifier
	}
	return json.Marshal(toSerialize)
}

type NullableCertAccessRules struct {
	value *CertAccessRules
	isSet bool
}

func (v NullableCertAccessRules) Get() *CertAccessRules {
	return v.value
}

func (v *NullableCertAccessRules) Set(val *CertAccessRules) {
	v.value = val
	v.isSet = true
}

func (v NullableCertAccessRules) IsSet() bool {
	return v.isSet
}

func (v *NullableCertAccessRules) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCertAccessRules(val *CertAccessRules) *NullableCertAccessRules {
	return &NullableCertAccessRules{value: val, isSet: true}
}

func (v NullableCertAccessRules) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCertAccessRules) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


